/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.statusupdater;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.model.ObjectClass;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.webclient.reports.ReportDomain;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class CustomReportStatusUpdater
implements StatusUpdater {
    private Hashtable objectIdVsCount = new Hashtable();
    private Hashtable objectIdVsRowDetails = new Hashtable();
    private boolean isCompleted = true;
    private ArrayList guidList = new ArrayList();
    private JSONObject multiDCDetails = new JSONObject();
    private ArrayList<Hashtable> errorList = new ArrayList();
    private String currentObjectName = null;
    private int currentTaskCode;

    public void init(Hashtable reportDomains) {
        JSONObject domainNameVsDCProps = null;
        Enumeration e = reportDomains.keys();
        while (e.hasMoreElements()) {
            try {
                domainNameVsDCProps = new JSONObject();
                String domainName = (String)e.nextElement();
                ReportDomain reportDomain = (ReportDomain)reportDomains.get(domainName);
                ArrayList dcList = reportDomain.getDCList();
                JSONObject dcProperies = null;
                for (int j = 0; j < dcList.size(); ++j) {
                    dcProperies = new JSONObject();
                    Hashtable hash = (Hashtable)dcList.get(j);
                    Integer status = (Integer)hash.get("status");
                    String dcName = (String)hash.get("dcName");
                    dcProperies.put("count", 0);
                    dcProperies.put("status", (Object)status);
                    dcProperies.put("image", (Object)"icn-dc");
                    domainNameVsDCProps.put(dcName, (Object)dcProperies);
                }
                this.multiDCDetails.put(domainName, (Object)domainNameVsDCProps);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void updateStatus(Properties prop, String objClass, String guid) {
        if (!this.guidList.contains(guid)) {
            ObjectClass objDetails = DirectoryObjectAPI.getInstance().getObjectClass(objClass);
            Integer objectId = objDetails.getId();
            Long objCount = (Long)this.objectIdVsCount.get(objectId);
            if (objCount == null) {
                objCount = 0L;
            }
            objCount = objCount + 1L;
            this.objectIdVsCount.put(objectId, objCount);
            ArrayList<Properties> rowList = (ArrayList<Properties>)this.objectIdVsRowDetails.get(objectId);
            if (rowList == null) {
                rowList = new ArrayList<Properties>();
            }
            if (rowList.size() < 25) {
                rowList.add(prop);
                this.objectIdVsRowDetails.put(objectId, rowList);
            }
            this.guidList.add(guid);
        }
    }

    public void setIsCompleted(boolean flag) {
        this.isCompleted = flag;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public JSONObject getJSONObject(JSONObject reqJsonObject, AdventNetResourceBundle rb) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject = this.getCommonJSONObject(rb);
            Integer viewType = reqJsonObject.getInt("viewType");
            if (viewType != null && viewType == 2) {
                jsonObject.put("dcDetails", (Object)this.multiDCDetails);
            } else {
                Integer objectId = reqJsonObject.getInt("tabId");
                boolean count = false;
                if (this.objectIdVsCount.get(objectId) != null) {
                    jsonObject.put("tabCount", this.objectIdVsCount.get(objectId));
                }
                jsonObject.put("rowData", (Object)this.getRowDetails(reqJsonObject.getJSONArray("columns"), objectId));
                jsonObject.put("dcDetails", (Object)this.multiDCDetails);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonObject;
    }

    private JSONArray getRowDetails(JSONArray tabIdAttributeList, int objectId) {
        JSONArray rowDetails = new JSONArray();
        Object json = null;
        JSONObject row = null;
        try {
            ArrayList rowDataList = (ArrayList)this.objectIdVsRowDetails.get(objectId);
            for (int index = 0; rowDataList != null && index < rowDataList.size(); ++index) {
                row = new JSONObject();
                Properties prop = (Properties)rowDataList.get(index);
                for (int innerIndex = 0; innerIndex < tabIdAttributeList.length(); ++innerIndex) {
                    JSONObject attribProp = (JSONObject)tabIdAttributeList.get(innerIndex);
                    Integer attribId = attribProp.getInt("ATTRIB_ID");
                    if (prop.containsKey(attribId)) {
                        ArrayList value = (ArrayList)prop.get(attribId);
                        row.put(attribId.toString(), (Object)ClientUtil.htmlEscape(ClientUtil.scriptEscape(value.get(0).toString())));
                        continue;
                    }
                    row.put(attribId.toString(), (Object)"-");
                }
                rowDetails.put((Object)row);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowDetails;
    }

    private JSONObject getCommonJSONObject(AdventNetResourceBundle rb) {
        JSONObject jsonObject = new JSONObject();
        try {
            jsonObject.put("isReportRunning", !this.isCompleted);
            jsonObject.put("count", this.guidList.size());
            jsonObject.put("errors", (Object)FcJSONUtility.listToJSONArray(this.errorList));
            jsonObject.put("count", this.guidList.size());
            jsonObject.put("isErrorOccurred", !this.errorList.isEmpty());
            if (!this.isCompleted) {
                jsonObject.put("statusMessage", (Object)this.getCurrentStatusMessage(rb));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonObject;
    }

    protected String getCurrentStatusMessage(AdventNetResourceBundle rb) {
        String message = rb.getString("reports.final_report_page.generating_reports");
        if (this.currentTaskCode == StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue()) {
            message = rb.getString("admp.reports.common.stat_msg.process_interrupted_loading_fetched_data");
        } else if (this.currentTaskCode == StatusUpdater.TASKCODE.FETCHING_DETAILS_FROM_DCS.getValue()) {
            message = rb.getString("reports.final_report_page.generating_reports");
        }
        return message;
    }

    public void setProgressTask(int taskCode) {
        this.currentTaskCode = taskCode;
    }

    public ArrayList getCriterias() {
        return null;
    }

    public Hashtable getTaskErrors(AdventNetResourceBundle rb) {
        return null;
    }

    public String getDefaultStatusMessage(AdventNetResourceBundle rb) {
        return null;
    }

    public int getCurrentTaskCode() {
        return 0;
    }

    public ArrayList<Hashtable> getErrorList() {
        return null;
    }

    public void updateStatus(JSONArray jsonArray, String domainName) {
    }

    public void updateErrorStatus(Hashtable errors) {
        this.errorList.add(errors);
    }

    public void init(DataObject rvcDataObject) {
    }

    public void init(DataObject rvcDataObject, Long cvcDataId) {
    }

    public void setTaskObject(Object obj) {
        this.currentObjectName = (String)obj;
    }

    public void setTaskError(Object message) {
    }

    public JSONObject getMultiDCDetails() {
        return this.multiDCDetails;
    }

    public void setProperties(String baseTableName, boolean isSyncEnabled, boolean isRowsUpdatedBySync) {
    }
}

