/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.statusupdater;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.statusupdater.AdvGroupStatusUpdater;
import java.util.ArrayList;
import java.util.Properties;
import org.json.JSONArray;

public class WAADUsersStatusUpdater
extends AdvGroupStatusUpdater
implements StatusUpdater {
    private ArrayList delegatedO365Domains = new ArrayList();

    public void initFilterDetails(Long loginId, String o365Account) {
        try {
            Row waadDomainRow;
            String domainsString;
            this.delegatedO365Domains = new ArrayList();
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPUsersWAADAccDetailsMapping", (String)"LOGIN_ID"), (Object)loginId, 0);
            criteria = criteria.and(new Criteria(new Column("ADMPUsersWAADAccDetailsMapping", "TYPE_OF_DATA"), (Object)DelegationUtil.RESULT_DATA, 0));
            criteria = criteria.and(new Criteria(new Column("ADMPUsersWAADAccDetailsMapping", "WAAD_TENANT_ID"), (Object)o365Account, 0));
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPUsersWAADAccDetailsMapping", criteria);
            if (!dataObject.isEmpty() && !(domainsString = (String)(waadDomainRow = dataObject.getRow("ADMPUsersWAADAccDetailsMapping")).get("WAAD_DOMAINS")).equalsIgnoreCase("All Domains")) {
                JSONArray waadDomains = new JSONArray(domainsString);
                for (int i = 0; i < waadDomains.length(); ++i) {
                    this.delegatedO365Domains.add(waadDomains.getString(i));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void init(DataObject rvcDataObject, Long cvcDataId) {
        super.init(rvcDataObject, cvcDataId);
        this.objectIdVsObjectClass.clear();
        this.objectIdVsObjectClass.put(6, "o365user");
    }

    @Override
    public void updateStatus(Properties prop, String objClass, String guid) {
        ArrayList valueList;
        String upn;
        if (this.delegatedO365Domains.size() > 0 && prop.containsKey(17004) && (upn = (String)(valueList = (ArrayList)prop.get(17004)).get(0)).indexOf("@") != -1) {
            String upnSuffix = upn.substring(upn.indexOf("@") + 1);
            boolean authorizedDomain = false;
            for (String domain : this.delegatedO365Domains) {
                if (!domain.equalsIgnoreCase(upnSuffix)) continue;
                authorizedDomain = true;
                break;
            }
            if (!authorizedDomain) {
                return;
            }
        }
        super.updateStatus(prop, objClass, guid);
    }

    @Override
    public String getDefaultStatusMessage(AdventNetResourceBundle rb) {
        return rb.getString("admp.reports.waad.status_no_office_365_users_available");
    }

    @Override
    protected String getCurrentStatusMessage(AdventNetResourceBundle rb) {
        String message = rb.getString("admp.reports.waad.status.fetching_users");
        if (this.currentTaskCode == StatusUpdater.TASKCODE.PROCESS_INTERRUPTED.getValue()) {
            message = rb.getString("admp.reports.common.stat_msg.process_interrupted_loading_fetched_data");
        }
        return message;
    }
}

