/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.support;

import com.adventnet.sym.adsm.common.webclient.reports.ZipUtility;
import com.adventnet.sym.adsm.common.webclient.support.AgeFileFilter;
import com.adventnet.sym.adsm.common.webclient.support.UploadAction;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class CompressLogFiles {
    private String fs = File.separator;
    private static Logger logger = Logger.getLogger(CompressLogFiles.class.getName());
    private ZipOutputStream zipOut = null;
    private GZIPOutputStream gzipOut = null;
    private File zipFile = null;
    static boolean interrupt = false;
    private List<File> filteredFiles = new CopyOnWriteArrayList<File>();
    private int days;
    private final long maxSize = 500000L;
    private final long maxRows = 10000L;
    private boolean zipEntry = false;
    private static CompressLogFiles compressLogs;

    private CompressLogFiles() {
    }

    public static CompressLogFiles getInstance() {
        if (compressLogs == null) {
            compressLogs = new CompressLogFiles();
        }
        return compressLogs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String createSupportFile(String fileName) throws Exception {
        FileInputStream in = null;
        String outFilename = null;
        this.days = -365;
        String s = ".." + this.fs + "logs";
        String audit = ".." + this.fs + "audit-data" + this.fs + "audit" + this.fs + "technicians";
        String pgLog = ".." + this.fs + "pgsql" + this.fs + "data" + this.fs + "pg_log";
        String patch = ".." + this.fs + "Patch";
        try {
            File patchDir;
            File supportDir = new File(s + this.fs + "support");
            File tempDir = new File(s + this.fs + "support" + this.fs);
            File accessDir = new File(s + this.fs + "support" + this.fs + "access");
            this.deleteRecursive(supportDir);
            accessDir.mkdirs();
            this.filterLogDirectory();
            this.splitAccess(new File(s + this.fs + "access_log.txt"), accessDir);
            if (new File(audit).exists()) {
                ArrayList<String> technicians = this.getSubdirectories(audit);
                for (int i = 0; i < technicians.size(); ++i) {
                    String techPath = audit + this.fs + technicians.get(i);
                    File auditDir = new File(techPath);
                    File techSupportDir = new File(s + this.fs + "support" + this.fs + technicians.get(i));
                    this.copyDirectory(auditDir, techSupportDir);
                }
            }
            File serverDir = new File(".." + this.fs + "bin");
            File hsdestDir = new File(s + this.fs + "support" + this.fs + "hs_err");
            this.copyDirectory(serverDir, hsdestDir);
            File pgLogDir = new File(pgLog);
            if (pgLogDir.exists()) {
                File pgdestDir = new File(s + this.fs + "support" + this.fs + "pg_log");
                this.copyDirectory(pgLogDir, pgdestDir);
            }
            if ((patchDir = new File(patch)).exists()) {
                this.copyDirectory(patchDir, supportDir);
            }
            outFilename = fileName + ".zip.gz";
            fileName = fileName + ".zip";
            String gzFile = s + this.fs + "support" + this.fs + outFilename;
            String zipDir = tempDir.getCanonicalPath();
            ZipUtility.makeZip(zipDir, "ADManagerPlus@123", null, null, fileName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (this.zipEntry) {
                this.zipEntry = false;
                this.zipOut.close();
            }
        }
        try {
            int len;
            String gzFile = s + this.fs + "support" + this.fs + outFilename;
            this.gzipOut = new GZIPOutputStream(new FileOutputStream(gzFile));
            in = new FileInputStream(s + this.fs + "support" + this.fs + fileName);
            byte[] buf = new byte[1024];
            while ((len = in.read(buf)) > 0) {
                this.gzipOut.write(buf, 0, len);
            }
            this.zipFile = new File(".." + this.fs + fileName);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error in zipping");
            e.printStackTrace();
        }
        finally {
            in.close();
            this.gzipOut.finish();
            this.gzipOut.close();
            this.zipFile.delete();
        }
        try {
            String supportFile = ".." + File.separator + "logs" + File.separator + "support" + File.separator + outFilename;
            boolean uploadStatus = UploadAction.checkUploadAccess();
            logger.log(Level.WARNING, " Upload Status : " + uploadStatus);
            outFilename = outFilename + "&" + uploadStatus;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Error while obtaining Connection" + e.toString(), e);
        }
        return outFilename;
    }

    public void splitAccess(File access, File accessDir) throws Exception {
        try {
            BufferedReader br = new BufferedReader(new FileReader(access));
            File file = new File(accessDir + this.fs + "ACCESS_LOG.txt");
            if (!file.exists()) {
                file.createNewFile();
            }
            BufferedWriter bw = new BufferedWriter(new FileWriter(file));
            String lastLine = null;
            int count = 0;
            GregorianCalendar cal = new GregorianCalendar();
            cal.add(5, this.days);
            Long cutoffDate = cal.getTime().getTime();
            String line = br.readLine();
            Date date = this.parseAccess(line);
            Long accessDate = date.getTime();
            do {
                ++count;
                if (accessDate >= cutoffDate) {
                    bw.write(line);
                    bw.newLine();
                }
                if ((long)count % 10000L == 0L) {
                    if (file.length() != 0L) {
                        bw.close();
                        this.renameFile(file, accessDir, date, count);
                        file = new File(accessDir + this.fs + "ACCESS_LOG.txt");
                        bw = new BufferedWriter(new FileWriter(file));
                    }
                    date = this.parseAccess(line);
                    accessDate = date.getTime();
                }
                lastLine = line;
            } while ((line = br.readLine()) != null);
            bw.close();
            this.renameFile(file, accessDir, this.parseAccess(lastLine), count);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while Splitting access file ");
        }
    }

    public Date parseAccess(String line) throws Exception {
        String dte = "";
        try {
            Pattern pattern = Pattern.compile("(\\d{2})[./-]([a-zA-z]{3})[./-](\\d{2,4})");
            String[] temp = line.split("[ ]+(?=([^\"]*\"[^\"]*\")*[^\"]*$)");
            temp[7] = temp[7].replace("[", "");
            String[] dm = temp[7].split(":", 2);
            dte = dm[0];
            if (!pattern.matcher(dm[0]).matches()) {
                temp[6] = temp[6].replace("[", "");
                String[] d = temp[6].split(":", 2);
                dte = d[0];
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while Parsing access file ");
        }
        return new SimpleDateFormat("dd/MMM/yyyy").parse(dte);
    }

    public void renameFile(File file, File accessDir, Date date, int count) {
        try {
            String dateStr = new SimpleDateFormat("MM-dd-yyyy").format(date);
            String fileName = accessDir + this.fs + "ACCESS_LOG" + "_" + dateStr + "_" + count + ".txt";
            File newName = new File(fileName);
            file.renameTo(newName);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while Renaming splitted access file ");
        }
    }

    public void filterByDate(File srcDir, File dstDir, int days) {
        try {
            if (srcDir.isDirectory()) {
                if (!dstDir.exists()) {
                    dstDir.mkdir();
                }
                GregorianCalendar cal = new GregorianCalendar();
                cal.add(5, days);
                Date cutoffDate = cal.getTime();
                AgeFileFilter filter = new AgeFileFilter(cutoffDate, false);
                File[] subdirectory = srcDir.listFiles(filter);
                for (int i = 0; i < subdirectory.length; ++i) {
                    if (subdirectory[i].isDirectory()) {
                        String dir = String.valueOf(subdirectory[i]);
                        if (!dir.endsWith("archive")) continue;
                        this.filterByDate(subdirectory[i], new File(dstDir, subdirectory[i].getName()), days);
                        continue;
                    }
                    String file = String.valueOf(subdirectory[i]);
                    if (file.contains("access_log") || !file.endsWith(".zip") && !file.endsWith(".txt") && !file.endsWith(".log")) continue;
                    this.filteredFiles.add(subdirectory[i]);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem in filterByDate ");
        }
    }

    public void filterLogDirectory() throws Exception {
        try {
            String s = ".." + this.fs + "logs";
            File logsDir = new File(s);
            File supportDir = new File(s + this.fs + "support");
            if (this.days == -365) {
                this.filterByDate(logsDir, supportDir, this.days);
            }
            while (this.getFilesSize(this.filteredFiles) > 500000L) {
                ++this.days;
                this.filteredFiles.clear();
                this.filterByDate(logsDir, supportDir, this.days);
            }
            for (File file : this.filteredFiles) {
                String fileName = file.getName();
                if (fileName.endsWith(".zip")) {
                    fileName = "archive" + this.fs + fileName;
                }
                this.copyFile(file, new File(supportDir, fileName));
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem in filterLogDirectory ");
        }
    }

    public long getFilesSize(List<File> files) {
        long length = 0L;
        try {
            for (File file : files) {
                length += file.length();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while getting file size ");
        }
        return length / 1000L;
    }

    public void copyDirectory(File srcDir, File dstDir) {
        try {
            if (srcDir.isDirectory()) {
                if (!dstDir.exists()) {
                    dstDir.mkdir();
                }
                FilenameFilter filter = new FilenameFilter(){

                    @Override
                    public boolean accept(File currentDir, String name) {
                        String dirName = String.valueOf(currentDir);
                        if (dirName.endsWith("bin")) {
                            return name.startsWith("hs_err");
                        }
                        if (dirName.endsWith("Patch")) {
                            return name.startsWith("spec");
                        }
                        return !name.endsWith(".lck");
                    }
                };
                String[] subdirectory = srcDir.list(filter);
                for (int i = 0; i < subdirectory.length; ++i) {
                    if (subdirectory[i].equalsIgnoreCase("support")) continue;
                    this.copyDirectory(new File(srcDir, subdirectory[i]), new File(dstDir, subdirectory[i]));
                }
            } else {
                this.copyFile(srcDir, dstDir);
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while copying directory ");
        }
    }

    public boolean deleteRecursive(File path) {
        boolean ret = false;
        try {
            if (path.exists()) {
                ret = true;
                if (path.isDirectory()) {
                    for (File f : path.listFiles()) {
                        ret = ret && this.deleteRecursive(f);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while deleting ");
        }
        return ret && path.delete();
    }

    public void copyFile(File src, File dst) throws IOException {
        try {
            String fileName = src.getName();
            String ext = "";
            if (fileName.lastIndexOf(".") != -1 && fileName.lastIndexOf(".") != 0) {
                ext = fileName.substring(fileName.lastIndexOf(".") + 1);
            }
            if (ext.equalsIgnoreCase("txt") || ext.equalsIgnoreCase("log") || ext.equalsIgnoreCase("xml")) {
                int len;
                FileInputStream in = new FileInputStream(src);
                FileOutputStream out = new FileOutputStream(dst);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while copying file ");
        }
    }

    public void zipRecursively(ZipOutputStream jos, String directory) throws Exception {
        if (interrupt) {
            this.cancelOperation();
            return;
        }
        File dir = new File(directory);
        File[] files = dir.listFiles();
        ZipEntry je = null;
        String fi = null;
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            fi = file.getCanonicalPath();
            if (file.isDirectory()) {
                je = new ZipEntry(fi + File.separator);
                try {
                    jos.putNextEntry(je);
                }
                catch (IOException ioe) {
                    logger.log(Level.SEVERE, "Problem while creating zip ");
                }
                this.zipEntry = true;
                this.zipRecursively(jos, file.getCanonicalPath());
                continue;
            }
            je = new ZipEntry(fi);
            try {
                jos.putNextEntry(je);
            }
            catch (IOException ioex) {
                logger.log(Level.SEVERE, "Problem while creating zip ");
            }
            try {
                this.getFileContents(file.getCanonicalPath(), jos);
                continue;
            }
            catch (Exception fe) {
                logger.log(Level.SEVERE, "Problem while creating zip ");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getFileContents(String fileName, OutputStream ous) {
        File fi = new File(fileName);
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(fi);
            bis = new BufferedInputStream(fis);
        }
        catch (FileNotFoundException fnfe) {
            logger.log(Level.SEVERE, "Problem while creating zip ");
            return false;
        }
        try {
            int i;
            while ((i = bis.read()) != -1) {
                ous.write(i);
            }
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "Problem while creating zip ");
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
                if (bis != null) {
                    bis.close();
                }
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Problem while creating zip ");
            }
        }
        return true;
    }

    public void cancelOperation() {
        try {
            if (this.zipEntry) {
                this.zipEntry = false;
                this.zipOut.close();
            }
            if (this.gzipOut != null) {
                this.gzipOut.finish();
                this.gzipOut.close();
            }
            if (this.zipFile != null) {
                this.zipFile.delete();
            }
            this.filteredFiles.clear();
            if (interrupt) {
                interrupt = false;
                compressLogs = null;
            }
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Problem while cancel operation ");
        }
    }

    public ArrayList<String> getSubdirectories(String parent) {
        ArrayList<String> childs = new ArrayList<String>();
        try {
            File auditDir = new File(parent);
            String[] children = auditDir.list();
            for (int i = 0; i < children.length; ++i) {
                childs.add(children[i]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return childs;
    }

    public void endOpearation() {
        interrupt = true;
        this.cancelOperation();
    }
}

