/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.transformers;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.util.HashMap;

public class CustomFieldsTransformers
implements Transformers {
    @Override
    public Object renderCell(AdventNetResourceBundle rb, String columnName, Object value, HashMap attributeProperties, HashMap inputValues, boolean isExport) {
        String finalValue = "";
        Long loginId = (Long)inputValues.get("LOGIN_ID");
        if (value != null) {
            int trimSize = (Integer)attributeProperties.get("TRIM_SIZE");
            finalValue = this.getvalue(rb, columnName, value.toString(), trimSize, loginId, isExport);
        } else {
            finalValue = "-";
        }
        return finalValue.toString();
    }

    private String getvalue(AdventNetResourceBundle rb, String columnName, String value, int trimSize, Long loginId, boolean isExport) {
        StringBuilder tdCellValue = new StringBuilder("<span class=\"blacktxt1\" ");
        if (isExport) {
            tdCellValue = new StringBuilder();
        }
        if (!value.equals("0")) {
            Long fileTime = Long.parseLong(value.toString());
            value = DateTimeUtil.getDateFromFileTime((Long)fileTime, (Long)loginId);
        } else {
            value = "-";
        }
        if (!isExport) {
            tdCellValue.append("alt=\"" + ClientUtil.htmlEscape(value.toString()) + "\" title=\"" + ClientUtil.htmlEscape(value.toString()) + "\">" + ClientUtil.htmlEscape(value.toString()));
            tdCellValue.append("</span>");
        } else {
            tdCellValue.append(value.toString());
        }
        return tdCellValue.toString();
    }
}

