/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.transformers;

import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutConstants;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.TimeZone;

public class DefaultTransformers
implements Transformers {
    @Override
    public Object renderCell(AdventNetResourceBundle rb, String columnName, Object value, HashMap attributeProperties, HashMap inputValues, boolean isExport) {
        String finalValue = "";
        Long loginId = (Long)inputValues.get("LOGIN_ID");
        int defaultTrimSize = 30;
        if (value != null) {
            int trimSize = attributeProperties.get("TRIM_SIZE") != null ? (Integer)attributeProperties.get("TRIM_SIZE") : defaultTrimSize;
            int iamAppId = 0;
            if (attributeProperties.get("IAMAPP_ID") != null) {
                iamAppId = (Integer)attributeProperties.get("IAMAPP_ID");
            }
            finalValue = this.getvalue(rb, columnName, value.toString(), trimSize, iamAppId, loginId, isExport);
        } else {
            finalValue = "-";
        }
        return finalValue.toString();
    }

    private String getvalue(AdventNetResourceBundle rb, String columnName, String value, int trimSize, int iamAppId, Long loginId, boolean isExport) {
        StringBuilder tdCellValue = new StringBuilder("<span class=\"blacktxt1\" ");
        if (isExport) {
            tdCellValue = new StringBuilder();
        }
        String trimedValue = "";
        if (columnName.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
            if (!value.equals("0")) {
                Long fileTime = Long.parseLong(value.toString());
                value = DateTimeUtil.getAccountExpiresDateFromFileTime((Long)fileTime, (AdventNetResourceBundle)rb, (Long)loginId);
            } else {
                value = rb.getString("admp.reports.user.account_exp_date.never_expires");
            }
            trimedValue = value.toString();
        } else if (columnName.equalsIgnoreCase("PASSWORD_EXPIRY_DATE")) {
            if (!isExport) {
                if (!value.equals("0") && !value.equals("-1")) {
                    Long time = Long.parseLong(value.toString());
                    value = DateTimeUtil.formatDate((Long)time, (Long)loginId);
                } else {
                    value = value.equals("0") ? rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon") : rb.getString("admp.reports.user.pwd_exp_date.never_expires");
                }
                value = ClientUtil.getLocaledString(rb, value.toString());
                trimedValue = value.toString();
            } else {
                trimedValue = value;
            }
        } else if (columnName.equalsIgnoreCase("DAYS_TO_EXPIRE_PASSWORD")) {
            value = DateTimeUtil.getDaysToExpire((String)value.toString(), (AdventNetResourceBundle)rb);
            value = ClientUtil.getLocaledString(rb, value.toString());
            trimedValue = value.toString();
        } else if (columnName.equalsIgnoreCase("DAYS_SINCE_LAST_LOGON")) {
            Long longObj = new Long(value.toString());
            value = rb.getString("admp.common.text.not_applicable");
            if (longObj != 0L) {
                value = new Long(DateTimeUtil.getNoOfDays((Long)longObj)).toString();
            }
            trimedValue = value.toString();
        } else if (columnName.equalsIgnoreCase("DAYS_SINCE_PASSWORD_SET")) {
            value = DateTimeUtil.getDaysSincePasswordSet((String)value.toString());
            value = ClientUtil.getLocaledString(rb, value.toString());
            trimedValue = value.toString();
        } else if (columnName.equalsIgnoreCase("WHEN_CREATED") || columnName.equalsIgnoreCase("WHEN_CHANGED") || columnName.equalsIgnoreCase("LAST_LOGON_TIME") || columnName.equalsIgnoreCase("LAST_LOGON_TIMESTAMP") || columnName.equalsIgnoreCase("LAST_LOGOFF_TIME") || columnName.equalsIgnoreCase("BAD_PASSWORD_TIME") || columnName.equalsIgnoreCase("ACCOUNT_LOCK_ON_TIME") || columnName.equalsIgnoreCase("PASSWORD_LAST_SET") || columnName.equalsIgnoreCase("CREATION_TIME") || columnName.equalsIgnoreCase("LAST_ACCESS_TIME") || columnName.equalsIgnoreCase("LAST_WRITE_TIME") || columnName.equalsIgnoreCase("MODIFIED_TIME") || columnName.equalsIgnoreCase("CREATED_ON") || columnName.equalsIgnoreCase("CHANGED_ON") || columnName.equalsIgnoreCase("LOCK_OUT_TIME") || columnName.equalsIgnoreCase("O365_LAST_LOGON_TIME") || columnName.equalsIgnoreCase("O365_LAST_LOGOFF_TIME")) {
            if (!isExport) {
                if (iamAppId == FcLayoutConstants.GOOGLE_APPS_APPID) {
                    Long timeValue = Long.parseLong(value.toString());
                    value = DateTimeUtil.formatDate((Long)timeValue, (Long)loginId);
                    if (columnName.equalsIgnoreCase("LAST_LOGON_TIME")) {
                        Calendar calendar = Calendar.getInstance();
                        calendar.set(1970, 0, 1, 0, 0, 0);
                        calendar.set(14, 0);
                        calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                        Long unixtime = calendar.getTimeInMillis();
                        if (unixtime.equals(timeValue)) {
                            value = "-";
                        }
                    }
                } else if (!value.equals("0") && !value.equals("-")) {
                    try {
                        Long fileTime = Long.parseLong(value.toString());
                        value = DateTimeUtil.getDateFromFileTime((Long)fileTime, (Long)loginId);
                    }
                    catch (NumberFormatException ex) {
                        value = value.toString();
                    }
                } else if (columnName.equalsIgnoreCase("PASSWORD_LAST_SET")) {
                    value = rb.getString("admp.reports.common.reportresulttxt.must_change_at_next_logon");
                }
                trimedValue = value.toString();
            } else if (iamAppId == FcLayoutConstants.GOOGLE_APPS_APPID) {
                Long timeValue = Long.parseLong(value.toString());
                trimedValue = DateTimeUtil.formatDate((Long)timeValue, (Long)loginId);
                if (columnName.equalsIgnoreCase("LAST_LOGON_TIME")) {
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(1970, 0, 1, 0, 0, 0);
                    calendar.set(14, 0);
                    calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                    Long unixtime = calendar.getTimeInMillis();
                    if (unixtime.equals(timeValue)) {
                        trimedValue = "-";
                    }
                }
            } else {
                trimedValue = !value.equals("0") ? value : "0";
            }
        } else {
            trimedValue = columnName.equalsIgnoreCase("IS_SUSPENDED") ? (value.equalsIgnoreCase("true") ? rb.getString("admp.reports.gapps.text.user_status_suspended") : rb.getString("admp.reports.gapps.text.user_status_active")) : (columnName.equalsIgnoreCase("CHANGEPASSWORDATNEXTLOGIN") ? (value.equalsIgnoreCase("true") ? rb.getString("admp.ad_explorer.view_props.user.common.statmsg.true") : rb.getString("admp.ad_explorer.view_props.user.common.statmsg.false")) : (columnName.equalsIgnoreCase("USAGE_LOCATION") ? (value = O365MgmtHandler.getCountryName((String)value)) : (!isExport && value.length() > trimSize ? value.substring(0, trimSize) + "..." : value.toString())));
        }
        if (!isExport) {
            tdCellValue.append("alt=\"" + ClientUtil.htmlEscape(value.toString()) + "\" title=\"" + ClientUtil.htmlEscape(value.toString()) + "\">" + ClientUtil.htmlEscape(trimedValue));
            tdCellValue.append("</span>");
        } else {
            tdCellValue.append(trimedValue);
        }
        return tdCellValue.toString();
    }
}

