/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserErrorHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserCreationScriptHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.DynamicController;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.CustomScript;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AddUserListener
implements NativeListener,
DynamicController {
    AdventNetResourceBundle rb;
    protected static Logger mgmtLog = Logger.getLogger("ADMangLogger");
    protected PrintWriter out = null;
    protected long sleepMillis = 700L;
    protected boolean isCompleted = false;
    protected Properties userCreationStatus = new Properties();
    protected boolean stop = false;
    protected Long userCreationID = null;
    protected String domainName = null;
    private String containerName = null;
    protected ArrayList userCreationGroupList = null;
    protected ArrayList<String> invalidGroups = null;
    protected ArrayList<Hashtable> userDetailsList = null;
    protected String keyLdapName = "";
    protected String keyLdapValue = "";
    protected String addMoreContainerName = "";
    protected Long loginId;
    protected boolean isAppendMultiValue = true;
    protected boolean isClearEmptyValue = true;
    protected String errorMessage = "";
    protected String hostId;
    protected ArrayList attributeList;
    public Hashtable<String, String> errorList;

    public void setWriter(PrintWriter o) {
        this.out = o;
    }

    public AddUserListener() {
    }

    public AddUserListener(Long userCreationID, String domainName, Long loginId, String hostId, String containerName, ArrayList<Hashtable> userDetailsList, ArrayList userCreationGroupList, ArrayList attributeList) {
        if (containerName != null) {
            this.userCreationID = userCreationID;
            this.domainName = domainName;
            this.addMoreContainerName = containerName;
            this.userDetailsList = userDetailsList;
            this.userCreationGroupList = userCreationGroupList;
            this.loginId = loginId;
            this.hostId = hostId;
            this.attributeList = attributeList;
        }
    }

    public void setErrorValue(String errorName, String key) {
        this.errorList.put(errorName, key);
    }

    public boolean isExcludeChildOU() {
        return false;
    }

    public void setIsExcludeChildOU(Boolean isExcludeChildOU) {
    }

    public void setNativeError(String domainName, Hashtable errorHash) {
    }

    public void setNativeError(String domainName, String dCName, Hashtable errorHash) {
    }

    public void addUser(Locale locale) {
        this.rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Action action = new Action(this);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    public void addUser() {
        this.rb = ResourceBundleMgr.getInstance().getBundle();
        Action action = new Action(this);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    public void addUser(AdventNetResourceBundle rb) {
        this.rb = rb;
        Action action = new Action(this);
        this.stop = false;
        this.isCompleted = false;
        action.start();
    }

    public void stop() {
        this.stop = true;
        while (!this.isCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void getProperties(ArrayList<Hashtable> valuesList, ArrayList<Hashtable> propList, ArrayList<Hashtable> modifyList, ArrayList<Hashtable> tsList, ArrayList<Hashtable> winNTAttributeList, ArrayList<String> groupList, Properties props) {
        this.getProperties("create", valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, props, "User");
    }

    public void getProperties(String actionType, ArrayList<Hashtable> valuesList, ArrayList<Hashtable> propList, ArrayList<Hashtable> modifyList, ArrayList<Hashtable> tsList, ArrayList<Hashtable> winNTAttributeList, ArrayList<String> groupList, Properties props, String management) {
        this.getProperties(actionType, valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, new ArrayList<String>(), props, null, management);
    }

    public void getProperties(String actionType, ArrayList<Hashtable> valuesList, ArrayList<Hashtable> propList, ArrayList<Hashtable> modifyList, ArrayList<Hashtable> tsList, ArrayList<Hashtable> winNTAttributeList, ArrayList<String> groupList, Properties props, Hashtable authorizedDomainOUHash, String management) {
        this.getProperties(actionType, valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, new ArrayList<String>(), props, management);
    }

    public void getProperties(String actionType, ArrayList<Hashtable> valuesList, ArrayList<Hashtable> propList, ArrayList<Hashtable> modifyList, ArrayList<Hashtable> tsList, ArrayList<Hashtable> winNTAttributeList, ArrayList<String> groupList, ArrayList<String> crossForestMembersList, Properties props, String management) {
        this.getProperties(actionType, valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, crossForestMembersList, props, null, management);
    }

    public void getProperties(String actionType, ArrayList<Hashtable> valuesList, ArrayList<Hashtable> propList, ArrayList<Hashtable> modifyList, ArrayList<Hashtable> tsList, ArrayList<Hashtable> winNTAttributeList, ArrayList<String> groupList, ArrayList<String> crossForestMembersList, Properties props, Hashtable authorizedDomainOUHash, String management) {
        try {
            this.errorList = new Hashtable();
            int countryFlag = 0;
            String mailAlias = "";
            this.fillPropsValues(valuesList, props, authorizedDomainOUHash);
            for (Hashtable hashtable2 : valuesList) {
                boolean isMultiValue;
                boolean attribValEmpty;
                String attributeName;
                block140: {
                    String stringObj;
                    String string;
                    ArrayList<String> trimmedList;
                    ArrayList list;
                    String attribValue;
                    String string2;
                    ArrayList attribValList;
                    attributeName = (String)hashtable2.get("ATTRIB_LDAP_NAME");
                    Object attrValueObj = hashtable2.get("ATTRIB_VALUE");
                    Long dataType = (Long)hashtable2.get("DATA_HANDLER_TYPE");
                    attribValEmpty = false;
                    isMultiValue = false;
                    if (!this.canUpdate(attributeName) || attributeName.equalsIgnoreCase("name") || attributeName.equalsIgnoreCase("password") || attributeName.equalsIgnoreCase("ouName")) continue;
                    if (attrValueObj instanceof String) {
                        if (attrValueObj != null) {
                            attribValEmpty = attrValueObj.toString().equals("");
                        }
                    } else if (attrValueObj instanceof ArrayList) {
                        attribValList = (ArrayList)attrValueObj;
                        if (attribValList != null) {
                            if (attribValList.size() == 0) {
                                attribValEmpty = true;
                            }
                            if (attribValList.size() == 1) {
                                attribValEmpty = ((String)attribValList.get(0)).equals("");
                            }
                        }
                        isMultiValue = true;
                    }
                    if (attribValEmpty && (actionType.equalsIgnoreCase("create") || !this.isClearEmptyValue || this.isEmptyValueNotAllowed(attributeName, dataType))) continue;
                    if (attributeName.equalsIgnoreCase("sAMAccountName")) {
                        String samName = (String)attrValueObj;
                        if ((management.equalsIgnoreCase("User") || management.equalsIgnoreCase("Computer")) && samName.length() > 19) {
                            samName = samName.substring(0, 20);
                        }
                        props.put("samAccountName", samName);
                        if (actionType.equalsIgnoreCase("modify") || management.equalsIgnoreCase("Group")) {
                            hashtable2.put("ATTRIB_VALUE", samName);
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("initials")) {
                        string2 = (String)attrValueObj;
                        if (string2 != null) {
                            if (string2.length() > 6) {
                                string2 = string2.substring(0, 6);
                            }
                            hashtable2.put("ATTRIB_VALUE", string2);
                            hashtable2.put("DATA_HANDLER_TYPE", 3L);
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("displayName")) {
                        string2 = (String)attrValueObj;
                        if (string2 != null) {
                            hashtable2.put("ATTRIB_VALUE", string2);
                            hashtable2.put("DATA_HANDLER_TYPE", 3L);
                            props.put("displayName", string2);
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("c") || attributeName.equalsIgnoreCase("co") || attributeName.equalsIgnoreCase("countryCode")) {
                        if (countryFlag == 0) {
                            String countryValue = (String)attrValueObj;
                            if (attributeName.equalsIgnoreCase("countryCode") && (countryValue.equals("0") || countryValue.equals(""))) {
                                attribValEmpty = true;
                                countryValue = "0";
                            }
                            ArrayList countryValues = null;
                            Hashtable<String, Object> cchashtable = new Hashtable<String, Object>();
                            cchashtable.put("ATTRIB_VALUE_COUNT", new Long(1L));
                            cchashtable.put("ATTRIB_LDAP_NAME", "countryCode");
                            cchashtable.put("DATA_HANDLER_TYPE", new Long(7L));
                            Hashtable<String, Object> chashtable = new Hashtable<String, Object>();
                            chashtable.put("ATTRIB_VALUE_COUNT", new Long(1L));
                            chashtable.put("ATTRIB_LDAP_NAME", "c");
                            chashtable.put("DATA_HANDLER_TYPE", new Long(3L));
                            Hashtable<String, Object> cohashtable = new Hashtable<String, Object>();
                            cohashtable.put("ATTRIB_VALUE_COUNT", new Long(1L));
                            cohashtable.put("ATTRIB_LDAP_NAME", "co");
                            cohashtable.put("DATA_HANDLER_TYPE", new Long(3L));
                            countryValues = UserMgmtUtil.getCountriesList((String)attributeName, (String)countryValue);
                            if (countryValues != null && countryValues.size() > 0) {
                                Properties p = (Properties)countryValues.get(0);
                                cchashtable.put("ATTRIB_VALUE", p.get("countryCode").toString());
                                chashtable.put("ATTRIB_VALUE", p.get("c").toString());
                                cohashtable.put("ATTRIB_VALUE", p.get("co").toString());
                            }
                            if (attribValEmpty || countryValues != null && countryValues.size() > 0) {
                                propList.add(cchashtable);
                                propList.add(chashtable);
                                propList.add(cohashtable);
                                ++countryFlag;
                            } else {
                                countryFlag = 0;
                            }
                        }
                    } else if (attributeName.equalsIgnoreCase("userAccountControl")) {
                        if (attrValueObj != null) {
                            String[] UACSplit = attrValueObj.toString().split(";");
                            Integer integer = AddUserClientUtil.getIntegerValue(hashtable2.get("ATTRIB_COLUMN_NAME").toString(), UACSplit[0]);
                            if (actionType.equalsIgnoreCase("modify")) {
                                try {
                                    if (UACSplit.length > 1) {
                                        int nandStatus = Integer.parseInt(UACSplit[1]);
                                        Integer nandAccountStatus = new Integer(~nandStatus);
                                        hashtable2.put("ATTRIB_AND_VALUE", nandAccountStatus.toString());
                                        int modifiedValue = integer & ~nandStatus;
                                        hashtable2.put("ATTRIB_UAC_VALUE", new Integer(modifiedValue).toString());
                                    }
                                }
                                catch (Exception uacException) {
                                    mgmtLog.log(Level.INFO, "While Spliting UseraccountControl, Exception Occurs" + uacException.toString());
                                }
                            } else if ((integer & 2) == 2) {
                                hashtable2.put("ATTRIB_AND_VALUE", new Integer(-33).toString());
                            } else {
                                hashtable2.put("ATTRIB_AND_VALUE", new Integer(-35).toString());
                            }
                            hashtable2.put("ATTRIB_VALUE", integer.toString());
                            modifyList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("pwdLastSet")) {
                        string2 = (String)attrValueObj;
                        if (string2 != null) {
                            hashtable2.put("ATTRIB_VALUE", AddUserClientUtil.getLongValue(string2));
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("accountExpires")) {
                        try {
                            string2 = (String)attrValueObj;
                            if (string2 == null) break block140;
                            String regex = "^(1[0-2]|0[1-9])-(3[01]|[12][0-9]|0[1-9])-[0-9]{4}$";
                            Pattern pattern = Pattern.compile(regex);
                            Matcher matcher = pattern.matcher(string2);
                            if (matcher.matches()) {
                                SimpleDateFormat dateFormat = new SimpleDateFormat("MM-dd-yyyy");
                                Date date = dateFormat.parse(string2);
                                hashtable2.put("ATTRIB_VALUE", DateTimeUtil.getFileTimeFromSystemTime((Long)date.getTime()));
                                propList.add(hashtable2);
                                break block140;
                            }
                            hashtable2.put("ATTRIB_VALUE", Long.valueOf(string2));
                            propList.add(hashtable2);
                        }
                        catch (NumberFormatException e) {
                            this.rb = ResourceBundleMgr.getInstance().getBundle();
                            this.setErrorValue("accountExpires", MessageFormat.format(this.rb.getString("admp.mgmt.csv_import.common.statmsg.no_changes_done_date_format"), "MM-dd-yyyy"));
                            e.printStackTrace();
                        }
                    } else if (attributeName.startsWith("ts")) {
                        if (attrValueObj != null) {
                            attribValue = attrValueObj.toString();
                            hashtable2.put("ATTRIB_VALUE", attribValue);
                            tsList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("userFlags")) {
                        if (attrValueObj != null) {
                            attribValue = attrValueObj.toString();
                            if (actionType.equalsIgnoreCase("modify") && attribValue.equals("0")) {
                                hashtable2.put("ATTRIB_VALUE", attribValue);
                                hashtable2.put("ATTRIB_AND_VALUE", new Integer(-65).toString());
                            } else {
                                hashtable2.put("ATTRIB_VALUE", attribValue);
                                hashtable2.put("ATTRIB_AND_VALUE", new Integer(-1).toString());
                            }
                            winNTAttributeList.add(hashtable2);
                        }
                    } else if (dataType == 6L) {
                        String dialin = "";
                        if (attrValueObj != null) {
                            String value = attrValueObj.toString();
                            if (value.equalsIgnoreCase("1")) {
                                value = "true";
                            } else if (value.equalsIgnoreCase("0")) {
                                value = "false";
                            }
                            hashtable2.put("ATTRIB_VALUE", value.toUpperCase());
                            propList.add(hashtable2);
                            if (attributeName.equalsIgnoreCase("msExchHideFromAddressLists") && value.equalsIgnoreCase("true")) {
                                Hashtable<String, Object> showInAddressBook = new Hashtable<String, Object>();
                                showInAddressBook.put("ATTRIB_LDAP_NAME", "showInAddressBook");
                                showInAddressBook.put("ATTRIB_VALUE", "");
                                showInAddressBook.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                showInAddressBook.put("DW_CONTROL_CODE", new Long(1L));
                                showInAddressBook.put("DATA_HANDLER_TYPE", new Long(1L));
                                propList.add(showInAddressBook);
                            }
                            if (attributeName.equals("msNPAllowDialin")) {
                                if (value.equalsIgnoreCase("true")) {
                                    dialin = "allow";
                                } else if (value.equalsIgnoreCase("false")) {
                                    dialin = "deny";
                                }
                                props.put("dialIn", dialin);
                            }
                        }
                    } else if (attributeName.equalsIgnoreCase("memberOf")) {
                        list = (ArrayList)attrValueObj;
                        this.invalidGroups = new ArrayList();
                        if (!list.isEmpty() && !attribValEmpty) {
                            for (String string3 : list) {
                                if (groupList.contains(string3)) continue;
                                Properties properties = UserMgmtUtil.getPropertiesfromDN((String)string3.trim(), (ArrayList)this.userCreationGroupList);
                                if (properties != null) {
                                    String dn = (String)properties.get("Distinguished_Name");
                                    if (dn == null) continue;
                                    groupList.add(dn);
                                    continue;
                                }
                                this.invalidGroups.add(string3);
                            }
                        }
                    } else if (attributeName.equalsIgnoreCase("member")) {
                        list = (ArrayList)attrValueObj;
                        if (list != null && !list.isEmpty()) {
                            trimmedList = new ArrayList<String>();
                            if (attribValEmpty) {
                                trimmedList.add((String)list.get(0));
                            } else {
                                for (Object object : list) {
                                    String value = (String)object;
                                    if ((value = value.trim()).equals("")) continue;
                                    if (CommonUtil.isCrossForestMember((String)this.domainName, (String)value)) {
                                        String memberSID = UserMgmtUtil.getSIDFromDN((String)DomainUtil.getDomainNamefromDN((String)value), (String)value);
                                        if (memberSID == null || crossForestMembersList.contains(memberSID)) continue;
                                        crossForestMembersList.add(memberSID);
                                        continue;
                                    }
                                    trimmedList.add(value);
                                }
                            }
                            if (trimmedList.size() == 0 && !crossForestMembersList.isEmpty() && !this.isAppendMultiValue) {
                                attribValEmpty = true;
                                trimmedList.add("");
                            }
                            if (trimmedList.size() > 0) {
                                hashtable2.put("ATTRIB_VALUE_COUNT", new Long(trimmedList.size()));
                                if (trimmedList.size() == 1) {
                                    hashtable2.put("ATTRIB_VALUE", (String)trimmedList.get(0));
                                } else {
                                    hashtable2.put("ATTRIB_VALUE", trimmedList);
                                }
                                propList.add(hashtable2);
                            }
                        }
                    } else if (attributeName.equalsIgnoreCase("authOrig") || attributeName.equalsIgnoreCase("unauthOrig")) {
                        Hashtable dLTable = (Hashtable)hashtable2.clone();
                        ArrayList list2 = (ArrayList)attrValueObj;
                        ArrayList<String> dLMemList = new ArrayList<String>();
                        ArrayList<String> origList = new ArrayList<String>();
                        if (!list2.isEmpty() && !attribValEmpty) {
                            for (Object object : list2) {
                                String dn = (String)object;
                                String objectClass = UserMgmtUtil.getMailRecipientObjectClass((String)(dn = dn.trim()));
                                if (objectClass.equalsIgnoreCase("group")) {
                                    dLMemList.add(dn);
                                    continue;
                                }
                                origList.add(dn);
                            }
                        }
                        if (!origList.isEmpty()) {
                            hashtable2.put("ATTRIB_VALUE_COUNT", origList.size());
                            if (origList.size() == 1) {
                                hashtable2.put("ATTRIB_VALUE", origList.get(0));
                            } else if (list2.size() > 1) {
                                hashtable2.put("ATTRIB_VALUE", origList);
                            }
                            propList.add(hashtable2);
                        }
                        if (!dLMemList.isEmpty()) {
                            if (attributeName.equalsIgnoreCase("authOrig")) {
                                dLTable.put("ATTRIB_LDAP_NAME", "dLMemSubmitPerms");
                            } else {
                                dLTable.put("ATTRIB_LDAP_NAME", "dLMemRejectPerms");
                            }
                            dLTable.put("ATTRIB_VALUE_COUNT", dLMemList.size());
                            if (dLMemList.size() == 1) {
                                dLTable.put("ATTRIB_VALUE", dLMemList.get(0));
                            } else if (dLMemList.size() > 1) {
                                dLTable.put("ATTRIB_VALUE", dLMemList);
                            }
                            propList.add(dLTable);
                        }
                    } else if (attributeName.equalsIgnoreCase("targetAddress")) {
                        String targetAddress = (String)attrValueObj;
                        if (targetAddress != null) {
                            targetAddress = "SMTP:" + targetAddress.substring(targetAddress.indexOf(":") + 1);
                            hashtable2.put("ATTRIB_VALUE", targetAddress);
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("proxyAddresses")) {
                        attribValList = (ArrayList)attrValueObj;
                        if (attribValList != null) {
                            trimmedList = new ArrayList();
                            for (Object object : attribValList) {
                                string = (String)object;
                                string = string.trim();
                                trimmedList.add(string);
                            }
                            if (props.get("targetAddress") != null && !trimmedList.contains((String)props.get("targetAddress"))) {
                                trimmedList.add((String)props.get("targetAddress"));
                            }
                            hashtable2.put("ATTRIB_VALUE_COUNT", trimmedList.size());
                            if (!trimmedList.isEmpty() && trimmedList.size() == 1) {
                                hashtable2.put("ATTRIB_VALUE", trimmedList.get(0));
                            } else {
                                hashtable2.put("ATTRIB_VALUE", trimmedList);
                            }
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("primaryGroupID")) {
                        string2 = (String)attrValueObj;
                        if (string2 != null) {
                            String groupDN;
                            String defaultNamingContext = (String)DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(this.domainName);
                            Properties properties = UserMgmtUtil.getPropertiesfromRID((String)string2, (ArrayList)this.userCreationGroupList, (String)defaultNamingContext);
                            if (properties != null && !groupList.contains(groupDN = properties.getProperty("Distinguished_Name"))) {
                                groupList.add(groupDN);
                            }
                            hashtable2.put("ATTRIB_VALUE", string2);
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equals("msExchAdminGroup")) {
                        string2 = (String)attrValueObj;
                        if (props.get("mailAlias") != null) {
                            mailAlias = props.getProperty("mailAlias");
                        }
                        if (string2 != null) {
                            string2 = string2 + "/cn=Recipients/cn=" + mailAlias;
                            hashtable2.put("ATTRIB_LDAP_NAME", "legacyExchangeDN");
                            hashtable2.put("ATTRIB_VALUE", string2);
                            propList.add(hashtable2);
                        }
                    } else if (attributeName.equalsIgnoreCase("managedBy")) {
                        stringObj = (String)attrValueObj;
                        if (stringObj != null) {
                            hashtable2.put("ATTRIB_VALUE", stringObj);
                            propList.add(hashtable2);
                            props.put("managedBy", stringObj);
                        }
                    } else if (attributeName.equalsIgnoreCase("managerCanUpdateMembers")) {
                        props.put("managerCanUpdateMembers", attrValueObj.toString());
                    } else if (attributeName.equalsIgnoreCase("preventDeletion")) {
                        props.put("preventDeletion", (Boolean)attrValueObj);
                    } else if (dataType == 10L) {
                        Long longValue = Long.valueOf(attrValueObj.toString());
                        if (longValue != null) {
                            hashtable2.put("ATTRIB_VALUE", longValue);
                            propList.add(hashtable2);
                        }
                    } else if (dataType == 9L) {
                        String userValue = attrValueObj.toString().toUpperCase();
                        Long longValue = 0L;
                        if (userValue != null && userValue.contains("Z") && userValue.indexOf("Z") == userValue.length() - 1) {
                            Date date = null;
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
                                sdf.setTimeZone(TimeZone.getTimeZone("UTC"));
                                date = sdf.parse(userValue.replace("Z", ""));
                                longValue = DateTimeUtil.getFileTime((Long)date.getTime());
                            }
                            catch (ParseException pe) {
                                pe.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                        if (longValue != null) {
                            hashtable2.put("ATTRIB_VALUE", longValue);
                            propList.add(hashtable2);
                        }
                    } else if (attrValueObj instanceof String) {
                        stringObj = (String)attrValueObj;
                        if (stringObj != null) {
                            hashtable2.put("ATTRIB_VALUE", stringObj);
                            propList.add(hashtable2);
                        }
                    } else if (attrValueObj instanceof ArrayList && (attribValList = (ArrayList)attrValueObj) != null) {
                        trimmedList = new ArrayList();
                        for (Object object : attribValList) {
                            string = (String)object;
                            string = string.trim();
                            trimmedList.add(string);
                        }
                        hashtable2.put("ATTRIB_VALUE_COUNT", trimmedList.size());
                        if (!trimmedList.isEmpty() && trimmedList.size() == 1) {
                            hashtable2.put("ATTRIB_VALUE", trimmedList.get(0));
                        } else {
                            hashtable2.put("ATTRIB_VALUE", trimmedList);
                        }
                        propList.add(hashtable2);
                    }
                }
                if (!actionType.equalsIgnoreCase("modify")) continue;
                if (attribValEmpty) {
                    this.updateNativeFlagForEmpty(propList, attributeName, props);
                    continue;
                }
                if (!isMultiValue) continue;
                this.updateNativeFlagForAppendOverwrite(propList, attributeName, props);
            }
            mgmtLog.log(Level.SEVERE, "The final propList value is :: " + propList);
            mgmtLog.log(Level.SEVERE, "The final groupList value is :: " + groupList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void fillPropsValues(ArrayList<Hashtable> valuesList, Properties props, Hashtable authorizedDomainOUHash) {
        block0: for (Hashtable hashtable2 : valuesList) {
            Object attrValueObj = hashtable2.get("ATTRIB_VALUE");
            String attributeName = (String)hashtable2.get("ATTRIB_LDAP_NAME");
            if (attributeName.equalsIgnoreCase("mailNickName")) {
                if (attrValueObj == null) continue;
                props.put("mailAlias", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("msExchHomeServerName")) {
                if (attrValueObj == null) continue;
                props.put("exchangeServer", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("msExchAdminGroup")) {
                if (attrValueObj == null) continue;
                props.put("adminGroup", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("msExchArchiveDatabaseLink")) {
                if (attrValueObj == null) continue;
                props.put("msExchArchiveDatabaseLink", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("msExchArchiveAddress")) {
                if (attrValueObj == null) continue;
                props.put("msExchArchiveAddress", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("targetAddress")) {
                if (attrValueObj == null) continue;
                props.put("targetAddress", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("proxyAddresses")) {
                if (attrValueObj == null) continue;
                props.put("proxyAddresses", (ArrayList)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("msExchPoliciesExcluded")) {
                if (attrValueObj == null) continue;
                props.put("msExchPoliciesExcluded", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("name")) {
                if (attrValueObj == null) continue;
                props.put("userName", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("distinguishedName")) {
                if (attrValueObj == null) continue;
                props.put("distinguishedName", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("password")) {
                if (attrValueObj == null) continue;
                props.put("password", (String)attrValueObj);
                continue;
            }
            if (attributeName.equalsIgnoreCase("passwordType")) {
                if (attrValueObj == null) continue;
                props.put("passwordType", (String)attrValueObj);
                continue;
            }
            if (attributeName.equals("homeDirectory")) {
                if (attrValueObj == null) continue;
                props.put("remoteHomeDir", (String)attrValueObj);
                continue;
            }
            if (attributeName.equals("tsHomeDir")) {
                if (attrValueObj == null) continue;
                props.put("tsRemoteHomeDir", (String)attrValueObj);
                continue;
            }
            if (attributeName.equals("tsProfilePath")) {
                if (attrValueObj == null) continue;
                props.put("tsProfilePath", (String)attrValueObj);
                continue;
            }
            if (attributeName.equals("profilePath")) {
                if (attrValueObj == null) continue;
                props.put("profilePath", (String)attrValueObj);
                continue;
            }
            if (attributeName.equals("homeMDB")) {
                if (attrValueObj == null) continue;
                props.put("homeMDB", (String)attrValueObj);
                continue;
            }
            if (attributeName.equals("manager") || attributeName.equals("managedBy")) {
                props.put("manager", (String)attrValueObj);
                continue;
            }
            if (!attributeName.equalsIgnoreCase("OUName") || hashtable2 == null || attrValueObj == null) continue;
            String container = (String)attrValueObj;
            container = container.trim();
            ArrayList ouList = null;
            ouList = authorizedDomainOUHash != null ? (ArrayList)authorizedDomainOUHash.get(this.domainName) : HelpdeskUtil.getOUList((String)this.domainName, (Long)this.loginId);
            if (ouList == null) {
                props.put("OUName", container);
                continue;
            }
            if (ouList.isEmpty()) {
                props.put("OUName", container);
                continue;
            }
            for (Object object : ouList) {
                String string = (String)object;
                if (!container.equalsIgnoreCase(string) && !container.toLowerCase().endsWith(string.toLowerCase())) continue;
                props.put("OUName", container);
                continue block0;
            }
        }
    }

    public boolean isEmptyValueNotAllowed(String attributeName, Long dataType) {
        String[] excludeLdapNames = new String[]{"samAccountName", "cn", "msExchAdminGroup", "msExchHomeServerName", "homeMDB", "legacyExchangeDN"};
        boolean isInvalid = false;
        for (int i = 0; i < excludeLdapNames.length; ++i) {
            if (!attributeName.equalsIgnoreCase(excludeLdapNames[i])) continue;
            isInvalid = true;
            break;
        }
        if (dataType != 1L && dataType != 3L && dataType != 6L) {
            isInvalid = true;
        }
        return isInvalid;
    }

    public void updateNativeFlagForEmpty(ArrayList<Hashtable> propList, String attributeName, Properties props) {
        if (attributeName.equalsIgnoreCase("authOrig") || attributeName.equalsIgnoreCase("unauthOrig")) {
            Hashtable<String, Object> authHashtable = new Hashtable<String, Object>();
            authHashtable.put("ATTRIB_LDAP_NAME", attributeName);
            authHashtable.put("ATTRIB_VALUE", "");
            authHashtable.put("ATTRIB_VALUE_COUNT", new Long(1L));
            authHashtable.put("DW_CONTROL_CODE", new Long(1L));
            authHashtable.put("DATA_HANDLER_TYPE", new Long(1L));
            propList.add(authHashtable);
            Hashtable<String, Object> unauthHashtable = new Hashtable<String, Object>();
            if (attributeName.equalsIgnoreCase("authOrig")) {
                unauthHashtable.put("ATTRIB_LDAP_NAME", "dLMemSubmitPerms");
            } else {
                unauthHashtable.put("ATTRIB_LDAP_NAME", "dLMemRejectPerms");
            }
            unauthHashtable.put("ATTRIB_VALUE", "");
            unauthHashtable.put("ATTRIB_VALUE_COUNT", new Long(1L));
            unauthHashtable.put("DW_CONTROL_CODE", new Long(1L));
            unauthHashtable.put("DATA_HANDLER_TYPE", new Long(1L));
            propList.add(unauthHashtable);
        } else if (propList != null && propList.size() > 0) {
            if (attributeName.equalsIgnoreCase("c") || attributeName.equalsIgnoreCase("co") || attributeName.equalsIgnoreCase("countryCode")) {
                Hashtable cchashtable = AddUserListener.getAttribProps(propList, "countryCode");
                Hashtable cohashtable = AddUserListener.getAttribProps(propList, "co");
                Hashtable chashtable = AddUserListener.getAttribProps(propList, "c");
                if (cohashtable != null) {
                    cohashtable.put("ATTRIB_VALUE", "");
                    cohashtable.put("DW_CONTROL_CODE", new Long(1L));
                }
                if (chashtable != null) {
                    chashtable.put("ATTRIB_VALUE", "");
                    chashtable.put("DW_CONTROL_CODE", new Long(1L));
                }
                if (cchashtable != null) {
                    cchashtable.put("ATTRIB_VALUE", "0");
                }
            } else {
                Hashtable hashtable = AddUserListener.getAttribProps(propList, attributeName);
                if (hashtable != null) {
                    hashtable.put("DW_CONTROL_CODE", new Long(1L));
                }
            }
        }
        if (attributeName.equalsIgnoreCase("memberOf")) {
            props.put("removeMemberOf", "true");
        }
    }

    public void updateNativeFlagForAppendOverwrite(ArrayList<Hashtable> propList, String attributeName, Properties props) {
        if (propList != null && propList.size() > 0) {
            if (attributeName.equalsIgnoreCase("authOrig") || attributeName.equalsIgnoreCase("unauthOrig")) {
                Hashtable authListHash = AddUserListener.getAttribProps(propList, attributeName);
                Hashtable dlMemListHash = null;
                dlMemListHash = attributeName.equalsIgnoreCase("authOrig") ? AddUserListener.getAttribProps(propList, "dLMemSubmitPerms") : AddUserListener.getAttribProps(propList, "dLMemRejectPerms");
                if (this.isAppendMultiValue) {
                    if (authListHash != null) {
                        authListHash.put("DW_CONTROL_CODE", new Long(3L));
                    }
                    if (dlMemListHash != null) {
                        dlMemListHash.put("DW_CONTROL_CODE", new Long(3L));
                    }
                } else if (authListHash != null && dlMemListHash != null) {
                    authListHash.put("DW_CONTROL_CODE", new Long(2L));
                    dlMemListHash.put("DW_CONTROL_CODE", new Long(2L));
                } else if (authListHash == null && dlMemListHash != null) {
                    Hashtable<String, Object> authHashtable = new Hashtable<String, Object>();
                    authHashtable.put("ATTRIB_LDAP_NAME", attributeName);
                    authHashtable.put("ATTRIB_VALUE", "");
                    authHashtable.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    authHashtable.put("DW_CONTROL_CODE", new Long(1L));
                    authHashtable.put("DATA_HANDLER_TYPE", new Long(1L));
                    propList.add(authHashtable);
                    dlMemListHash.put("DW_CONTROL_CODE", new Long(2L));
                } else if (authListHash != null && dlMemListHash == null) {
                    Hashtable<String, Object> unauthHashtable = new Hashtable<String, Object>();
                    if (attributeName.equalsIgnoreCase("authOrig")) {
                        unauthHashtable.put("ATTRIB_LDAP_NAME", "dLMemSubmitPerms");
                    } else {
                        unauthHashtable.put("ATTRIB_LDAP_NAME", "dLMemRejectPerms");
                    }
                    unauthHashtable.put("ATTRIB_VALUE", "");
                    unauthHashtable.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    unauthHashtable.put("DW_CONTROL_CODE", new Long(1L));
                    unauthHashtable.put("DATA_HANDLER_TYPE", new Long(1L));
                    propList.add(unauthHashtable);
                    authListHash.put("DW_CONTROL_CODE", new Long(2L));
                }
            } else {
                Hashtable temphashtable = AddUserListener.getAttribProps(propList, attributeName);
                if (temphashtable != null) {
                    if (!this.isAppendMultiValue) {
                        temphashtable.put("DW_CONTROL_CODE", new Long(2L));
                    } else {
                        temphashtable.put("DW_CONTROL_CODE", new Long(3L));
                    }
                }
            }
        }
        if (attributeName.equalsIgnoreCase("memberOf") && !this.isAppendMultiValue) {
            props.put("removeMemberOf", "true");
        }
    }

    public static Hashtable getAttribProps(ArrayList<Hashtable> propList, String attributeName) {
        Hashtable hashtable = null;
        for (int i = 0; i < propList.size(); ++i) {
            hashtable = propList.get(i);
            String attrName = (String)hashtable.get("ATTRIB_LDAP_NAME");
            if (!attrName.equalsIgnoreCase(attributeName)) continue;
            return hashtable;
        }
        return null;
    }

    public static void setFormatValue(ArrayList<Hashtable> propList, String attribute, String value) {
        block6: {
            block4: {
                block5: {
                    if (!attribute.equals("homeDirectory") && !attribute.equals("tsHomeDir") || !value.equals("")) break block4;
                    if (!attribute.equals("homeDirectory")) break block5;
                    for (Hashtable hashtable : propList) {
                        String ldapString = (String)hashtable.get("ATTRIB_LDAP_NAME");
                        if (!ldapString.equalsIgnoreCase("homeDrive")) continue;
                        propList.remove(hashtable);
                        return;
                    }
                    break block6;
                }
                if (!attribute.equals("tsHomeDir")) break block6;
                for (Hashtable hashtable : propList) {
                    String ldapString = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    if (!ldapString.equalsIgnoreCase("tsHomeDirDrive")) continue;
                    propList.remove(hashtable);
                    return;
                }
                break block6;
            }
            for (Hashtable hashtable : propList) {
                String ldapString = (String)hashtable.get("ATTRIB_LDAP_NAME");
                if (!ldapString.equalsIgnoreCase(attribute)) continue;
                if (!value.equals("")) {
                    hashtable.put("ATTRIB_VALUE", value);
                }
                return;
            }
        }
    }

    public static void setProxiesFormatValue(String domainName, ArrayList<Hashtable> valuesList, ArrayList<Hashtable> propList, String samAccountName, String userName, ArrayList customList, String sipAddress) {
        try {
            boolean proxyAdd = false;
            for (Hashtable hashtable : propList) {
                String ldapString = (String)hashtable.get("ATTRIB_LDAP_NAME");
                if (!ldapString.equalsIgnoreCase("proxyAddresses")) continue;
                proxyAdd = true;
                ArrayList<String> formattedProxyList = new ArrayList<String>();
                Integer attribCount = (Integer)hashtable.get("ATTRIB_VALUE_COUNT");
                if (attribCount.equals(1)) {
                    String proxy = (String)hashtable.get("ATTRIB_VALUE");
                    proxy = FormatClientUtil.getFormatValue(domainName, proxy, valuesList, samAccountName, userName, customList);
                    formattedProxyList.add(proxy);
                } else {
                    ArrayList proxyList = (ArrayList)hashtable.get("ATTRIB_VALUE");
                    for (Object object : proxyList) {
                        String proxy = (String)object;
                        proxy = FormatClientUtil.getFormatValue(domainName, proxy, valuesList, samAccountName, userName, customList);
                        formattedProxyList.add(proxy);
                    }
                }
                if (sipAddress != null) {
                    formattedProxyList.add(sipAddress);
                }
                if (formattedProxyList.size() == 1) {
                    hashtable.put("ATTRIB_VALUE", (String)formattedProxyList.get(0));
                } else {
                    hashtable.put("ATTRIB_VALUE", formattedProxyList);
                }
                hashtable.put("ATTRIB_VALUE_COUNT", new Long(formattedProxyList.size()));
                return;
            }
            if (!proxyAdd && sipAddress != null) {
                Hashtable<String, Object> proxyTable = new Hashtable<String, Object>();
                proxyTable.put("ATTRIB_LDAP_NAME", "proxyAddresses");
                proxyTable.put("DATA_HANDLER_TYPE", 3L);
                proxyTable.put("ATTRIB_VALUE_COUNT", 1L);
                proxyTable.put("ATTRIB_VALUE", sipAddress);
                proxyTable.put("DW_CONTROL_CODE", new Long(3L));
                propList.add(proxyTable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRow(Properties prop) {
        AddUserHandler.getInstance().updateCreationStatus(this.rb, prop);
        this.updateUI(prop);
        this.userCreationStatus = prop;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public Properties getCreationStatusProps() {
        return this.userCreationStatus;
    }

    public void stopCreation() {
        this.isCompleted = true;
    }

    @Override
    public void controlUI(PrintWriter o) {
        if (this.isCompleted) {
            return;
        }
        while (!this.isCompleted) {
            try {
                Thread.sleep(this.sleepMillis);
                if (this.sleepMillis != 700L) continue;
                this.sleepMillis = 200L;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.out.write(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occurred_message"), e.getMessage()));
            }
        }
        try {
            if (this.out != null && !this.out.checkError() && this.isCompleted) {
                this.out.write("<script>window.location.href='UserManagement.do?methodToCall=addUser&selectedTab=admin'</script>");
                System.out.println("Add user Complete");
                this.out.flush();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.out = null;
    }

    private void updateUI(Properties prop) {
        Long userIndex = (Long)prop.get("USER_INDEX");
        if (this.out != null) {
            this.out.write("<script> updateUI('" + userIndex.toString() + "','" + prop.getProperty("CREATION_MESSAGE") + "','" + prop.getProperty("CREATION_STATUS") + "')</script>");
            this.out.flush();
        }
    }

    public void getPropertiesExch2007(ArrayList<Hashtable> valuesList, ArrayList<Hashtable> exchPropList) {
        try {
            String[] exchRecipientPolicyProp = new String[]{"st", "department", "company", "givenName", "sn"};
            ArrayList<String> exProps = new ArrayList<String>();
            for (String string : exchRecipientPolicyProp) {
                exProps.add(string);
            }
            for (Hashtable hashtable2 : valuesList) {
                String string;
                String attributeName = (String)hashtable2.get("ATTRIB_LDAP_NAME");
                if (attributeName.equalsIgnoreCase("pwdLastSet") || attributeName.equalsIgnoreCase("accountExpires")) {
                    Long longValue = (Long)hashtable2.get("ATTRIB_VALUE");
                    String string2 = longValue.toString();
                    if (string2 == null) continue;
                    hashtable2.put("ATTRIB_VALUE", AddUserClientUtil.getLongValue(string2));
                    exchPropList.add(hashtable2);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("primaryGroupID") || attributeName.equalsIgnoreCase("msNPAllowDialin")) {
                    string = (String)hashtable2.get("ATTRIB_VALUE");
                    if (string == null || string.equals("")) continue;
                    hashtable2.put("ATTRIB_VALUE", string);
                    exchPropList.add(hashtable2);
                    continue;
                }
                if (attributeName.equalsIgnoreCase("proxyAddresses")) {
                    ArrayList list = (ArrayList)hashtable2.get("ATTRIB_VALUE");
                    ArrayList<String> trimmedList = new ArrayList<String>();
                    for (Object object : list) {
                        String string3 = (String)object;
                        string3 = string3.trim();
                        trimmedList.add(string3);
                    }
                    hashtable2.put("ATTRIB_VALUE_COUNT", trimmedList.size());
                    if (!trimmedList.isEmpty() && trimmedList.size() == 1) {
                        hashtable2.put("ATTRIB_VALUE", trimmedList.get(0));
                    } else {
                        hashtable2.put("ATTRIB_VALUE", trimmedList);
                    }
                    if (trimmedList.isEmpty()) continue;
                    exchPropList.add(hashtable2);
                    continue;
                }
                if (!exProps.contains(attributeName) || (string = (String)hashtable2.get("ATTRIB_VALUE")) == null || string.equals("")) continue;
                exchPropList.add(hashtable2);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected boolean canUpdate(String attributeName) {
        return true;
    }

    public void setHostId(String hostId) {
        this.hostId = hostId;
    }

    public String getCrossForestErrorMsg(NativeError errHandler, String key, AdventNetResourceBundle rb) {
        String errMsg = null;
        try {
            Hashtable error = errHandler.getErrors();
            if (error != null) {
                StringBuilder strBuilder = new StringBuilder();
                ArrayList errList = (ArrayList)error.get(key);
                if (errList != null && errList.size() > 0) {
                    Hashtable errHash = (Hashtable)errList.get(0);
                    String errorStr = errHash.get("ERROR_MESSAGE").toString();
                    strBuilder.append(rb.getString(errHash.get("ERROR_MESSAGE").toString()));
                    if (errHash.get("ERROR_CODE") != null && !errHash.get("ERROR_CODE").equals("0")) {
                        strBuilder.append(" - ");
                        strBuilder.append(rb.getString("admp.common.native.error_text.error_code"));
                        strBuilder.append(" : ");
                        strBuilder.append((String)errHash.get("ERROR_CODE"));
                        strBuilder.append(" ");
                    }
                }
                errMsg = strBuilder.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errMsg;
    }

    public void setErrorMessage() {
        this.errorMessage = "";
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    private class Action
    extends Thread {
        private AddUserListener addUserListener;

        public Action(AddUserListener addUserListener2) {
            this.addUserListener = addUserListener2;
        }

        @Override
        public void run() {
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)AddUserListener.this.loginId, (String)AddUserListener.this.hostId, (Integer)6002, (DataObject)auditDataObj, (ArrayList)AddUserListener.this.attributeList, (AdventNetResourceBundle)AddUserListener.this.rb);
                Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                audit_info.put("audit_id", audit_id);
                boolean isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"userMgmt");
                boolean iterateNames = AddUserHandler.getInstance().isIterationEnabled(AddUserListener.this.userCreationID);
                Hashtable permissionTable = UserPermissionsHandler.getInstance().getPermissions(AddUserListener.this.userCreationID, AddUserListener.this.domainName, AddUserListener.this.rb);
                Hashtable customAttributesTable = AddUserHandler.getInstance().getCustomAttributesList(AddUserListener.this.userCreationID);
                StringBuffer searchStringBuffer = null;
                for (Hashtable hashtable : AddUserListener.this.userDetailsList) {
                    AddUserListener.this.containerName = AddUserListener.this.addMoreContainerName;
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    ArrayList<Hashtable> propList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> essenPropList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> exchPropList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> modifyList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> tsList = new ArrayList<Hashtable>();
                    ArrayList<Hashtable> winNTAttributeList = new ArrayList<Hashtable>();
                    ArrayList<String> groupList = new ArrayList<String>();
                    Properties props = new Properties();
                    AddUserListener.this.getProperties(valuesList, propList, modifyList, tsList, winNTAttributeList, groupList, props);
                    String exchangeServer = null;
                    String adminGroup = null;
                    boolean usePowershell = false;
                    if (props.get("exchangeServer") != null || props.get("exchangeServer") != "") {
                        exchangeServer = props.getProperty("exchangeServer");
                    }
                    if (props.get("adminGroup") != null || props.get("adminGroup") != "") {
                        adminGroup = props.getProperty("adminGroup");
                    }
                    String mailAlias = null;
                    if (props.get("mailAlias") != null) {
                        mailAlias = props.getProperty("mailAlias");
                    }
                    String targetAddress = null;
                    if (props.get("targetAddress") != null) {
                        targetAddress = props.getProperty("targetAddress");
                    }
                    Integer exchType = 2003;
                    if (exchangeServer != null) {
                        exchType = ExchangeUtil.getExchangeServerType((String)exchangeServer);
                    }
                    if (adminGroup != null) {
                        exchType = ExchangeUtil.getAdminGroupType((String)adminGroup);
                    }
                    if (exchType >= 2007) {
                        usePowershell = true;
                        AddUserListener.this.getPropertiesExch2007(valuesList, exchPropList);
                    }
                    String userName = "";
                    if (props.get("userName") != null) {
                        userName = props.getProperty("userName");
                    }
                    String samAccountName = "";
                    if (props.get("samAccountName") != null) {
                        samAccountName = props.getProperty("samAccountName");
                    }
                    if (props.get("OUName") != null) {
                        AddUserListener.this.containerName = props.getProperty("OUName");
                    }
                    Hashtable nameVsValues = (Hashtable)customAttributesTable.get(userIndex);
                    ArrayList customList = new ArrayList();
                    if (nameVsValues != null) {
                        Enumeration e = nameVsValues.keys();
                        while (e.hasMoreElements()) {
                            String attributeName = (String)e.nextElement();
                            ArrayList values = (ArrayList)nameVsValues.get(attributeName);
                            if (values == null || values.size() <= 0) continue;
                            ArrayList<String> formattedValues = new ArrayList<String>();
                            for (Object object : values) {
                                String format = (String)object;
                                format = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, format, valuesList, samAccountName, userName, new ArrayList());
                                formattedValues.add(format);
                            }
                            int count = formattedValues.size();
                            Hashtable<String, Object> customTable = new Hashtable<String, Object>();
                            customTable.put("ATTRIB_LDAP_NAME", attributeName);
                            customTable.put("DATA_HANDLER_TYPE", 3L);
                            customTable.put("ATTRIB_VALUE_COUNT", new Long(count));
                            if (count == 1) {
                                customTable.put("ATTRIB_VALUE", formattedValues.get(0));
                            } else {
                                customTable.put("ATTRIB_VALUE", formattedValues);
                            }
                            customList.add(customTable);
                        }
                    }
                    if (AddUserListener.this.containerName == null || AddUserListener.this.containerName.equalsIgnoreCase("")) {
                        Properties properties = null;
                        String domainName = "";
                        ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)AddUserListener.this.loginId);
                        if (domainName == null || domainName.equalsIgnoreCase("")) {
                            properties = HDTDomainHandler.getSelectedDomain((Long)AddUserListener.this.loginId);
                            domainName = properties.getProperty("DOMAIN_NAME");
                        } else {
                            properties = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)AddUserListener.this.loginId);
                        }
                        String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
                        String defaultContainerName = UserMgmtUtil.getDefaultContainerName((String)defaultNamingContext, (ArrayList)ouList);
                        AddUserListener.this.containerName = defaultContainerName;
                    }
                    String password = "";
                    if (props.get("password") != null) {
                        password = props.getProperty("password");
                    }
                    String passwordType = "";
                    if (props.get("passwordType") != null) {
                        passwordType = props.getProperty("passwordType");
                    }
                    String remoteHomeDir = "";
                    if (props.get("remoteHomeDir") != null) {
                        remoteHomeDir = props.getProperty("remoteHomeDir");
                    }
                    String tsRemoteHomeDir = "";
                    if (props.get("tsRemoteHomeDir") != null) {
                        tsRemoteHomeDir = props.getProperty("tsRemoteHomeDir");
                    }
                    String profilePath = "";
                    if (props.get("profilePath") != null) {
                        profilePath = props.getProperty("profilePath");
                    }
                    String tsProfilePath = "";
                    if (props.get("tsProfilePath") != null) {
                        tsProfilePath = props.getProperty("tsProfilePath");
                    }
                    String tsWorkingDir = "";
                    if (props.get("tsWorkingDir") != null) {
                        tsWorkingDir = props.getProperty("tsWorkingDir");
                    }
                    Boolean IS_HOME_DIR_SHARED = (Boolean)permissionTable.get("IS_HOME_DIR_SHARED");
                    Boolean TS_IS_HOME_DIR_SHARED = (Boolean)permissionTable.get("TS_IS_HOME_DIR_SHARED");
                    Properties homeDirShareProps = null;
                    Properties tsHomeDirShareProps = null;
                    String homeMDB = null;
                    if (props.get("homeMDB") != null) {
                        homeMDB = props.getProperty("homeMDB");
                    }
                    String dialIn = null;
                    if (props.get("dialIn") != null && !props.get("dialIn").equals("")) {
                        dialIn = props.getProperty("dialIn");
                    }
                    if (modifyList.isEmpty()) {
                        Hashtable<String, Object> defaultTable = new Hashtable<String, Object>();
                        defaultTable.put("ATTRIB_LDAP_NAME", "userAccountControl");
                        defaultTable.put("ATTRIB_AND_VALUE", new Integer(-3).toString());
                        defaultTable.put("ATTRIB_VALUE", new Integer(512).toString());
                        defaultTable.put("ATTRIB_VALUE_COUNT", 1L);
                        defaultTable.put("DATA_HANDLER_TYPE", 7L);
                        modifyList.add(defaultTable);
                    }
                    if (AddUserListener.this.stop) break;
                    if (!isLicenseExceeded) {
                        if (iterateNames) {
                            AddUserClientUtil.setIteratedUserName(AddUserListener.this.domainName, AddUserListener.this.loginId, propList, userIndex, props, AddUserListener.this.containerName);
                            userName = props.getProperty("userName");
                            samAccountName = props.getProperty("samAccountName");
                            if (passwordType.equalsIgnoreCase("sameasusername")) {
                                password = samAccountName;
                                Criteria criteria = new Criteria(new Column(AddUserHandler.USER_ATTRIBUTE_TABLE, "USER_INDEX"), (Object)userIndex, 0);
                                UpdateQueryImpl query = new UpdateQueryImpl(AddUserHandler.USER_ATTRIBUTE_TABLE);
                                query.setCriteria(criteria);
                                query.setUpdateColumn("PASSWORD", (Object)password);
                                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)query);
                            }
                        }
                        userName = CommonUtil.escapeString((String)userName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS);
                        String distinguishedName = "CN=" + userName + "," + AddUserListener.this.containerName;
                        samAccountName = CommonUtil.replaceSAMAccountSplChars((String)samAccountName);
                        remoteHomeDir = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, remoteHomeDir, valuesList, samAccountName, userName, customList, true);
                        if (IS_HOME_DIR_SHARED.booleanValue()) {
                            homeDirShareProps = AddUserClientUtil.getShareDetails(AddUserListener.this.domainName, valuesList, permissionTable, samAccountName, userName, "homeFolder", customList);
                            AddUserListener.setFormatValue(propList, "homeDirectory", remoteHomeDir);
                            remoteHomeDir = homeDirShareProps.getProperty("shareRemotePath");
                        } else {
                            AddUserListener.setFormatValue(propList, "homeDirectory", remoteHomeDir);
                        }
                        profilePath = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, profilePath, valuesList, samAccountName, userName, customList, true);
                        AddUserListener.setFormatValue(propList, "profilePath", profilePath);
                        tsRemoteHomeDir = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, tsRemoteHomeDir, valuesList, samAccountName, userName, customList, true);
                        if (TS_IS_HOME_DIR_SHARED.booleanValue()) {
                            tsHomeDirShareProps = AddUserClientUtil.getShareDetails(AddUserListener.this.domainName, valuesList, permissionTable, samAccountName, userName, "tsHomeFolder", customList);
                            AddUserListener.setFormatValue(tsList, "tsHomeDir", tsRemoteHomeDir);
                            tsRemoteHomeDir = tsHomeDirShareProps.getProperty("shareRemotePath");
                        } else {
                            AddUserListener.setFormatValue(tsList, "tsHomeDir", tsRemoteHomeDir);
                        }
                        tsProfilePath = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, tsProfilePath, valuesList, samAccountName, userName, customList, true);
                        AddUserListener.setFormatValue(tsList, "tsProfilePath", tsProfilePath);
                        tsWorkingDir = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, tsWorkingDir, valuesList, samAccountName, userName, customList, true);
                        AddUserListener.setFormatValue(tsList, "tsWorkingDir", tsWorkingDir);
                        String sipAddress = null;
                        String upn = null;
                        for (Hashtable hashtable1 : propList) {
                            String valueString;
                            String ldapString = (String)hashtable1.get("ATTRIB_LDAP_NAME");
                            if (ldapString.equalsIgnoreCase("msRTCSIP-Line") || ldapString.equalsIgnoreCase("msRTCSIP-LineServer") || ldapString.equalsIgnoreCase("msRTCSIP-PrimaryUserAddress")) {
                                valueString = (String)hashtable1.get("ATTRIB_VALUE");
                                valueString = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, valueString, valuesList, samAccountName, userName, customList);
                                hashtable1.put("ATTRIB_VALUE", valueString);
                                if (!ldapString.equalsIgnoreCase("msRTCSIP-PrimaryUserAddress")) continue;
                                sipAddress = valueString;
                                continue;
                            }
                            if (ldapString.equalsIgnoreCase("mail") || ldapString.equalsIgnoreCase("displayNamePrintable")) {
                                valueString = (String)hashtable1.get("ATTRIB_VALUE");
                                hashtable1.put("ATTRIB_VALUE", valueString);
                                continue;
                            }
                            if (ldapString.equalsIgnoreCase("userPrincipalName")) {
                                upn = (String)hashtable1.get("ATTRIB_VALUE");
                                continue;
                            }
                            if (!ldapString.equalsIgnoreCase("mailNickname")) continue;
                            mailAlias = (String)hashtable1.get("ATTRIB_VALUE");
                        }
                        if (!usePowershell) {
                            AddUserListener.setProxiesFormatValue(AddUserListener.this.domainName, valuesList, propList, samAccountName, userName, customList, sipAddress);
                        } else {
                            AddUserListener.setProxiesFormatValue(AddUserListener.this.domainName, valuesList, exchPropList, samAccountName, userName, customList, sipAddress);
                        }
                        Hashtable<String, Object> logProps = new Hashtable<String, Object>();
                        logProps.put(AddUserListener.this.rb.getString("admp.common.attrib_disp_name.dn_domain_name"), AddUserListener.this.domainName);
                        logProps.put(AddUserListener.this.rb.getString("admp.common.attrib_disp_name.container_name"), AddUserListener.this.containerName);
                        logProps.put(AddUserListener.this.rb.getString("admp.common.attrib_disp_name.user_name"), userName);
                        logProps.put(AddUserListener.this.rb.getString("admp.common.attrib_disp_name.sam_name"), samAccountName);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.properties"), propList);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.exchange_properties"), exchPropList);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.update_properties"), modifyList);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_properties"), tsList);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.winnt_properties"), winNTAttributeList);
                        logProps.put(AddUserListener.this.rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.groups"), groupList);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.remote_home_dir"), remoteHomeDir);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_remote_home_dir"), tsRemoteHomeDir);
                        logProps.put(AddUserListener.this.rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.profile_path"), profilePath);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.ts_profile_path"), profilePath);
                        logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.custom_properties"), customList);
                        if (homeMDB != null) {
                            logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.home_mdb"), homeMDB);
                        }
                        if (dialIn != null && !dialIn.equals("")) {
                            logProps.put(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.dial_in"), dialIn);
                        }
                        Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)((Long)audit_info.get("audit_id")), (Long)userIndex, (String)samAccountName, (String)AddUserListener.this.domainName, (DataObject)auditDataObj);
                        audit_info.put("user_index", userIndex);
                        int i = 0;
                        while (i < propList.size()) {
                            Hashtable hash = propList.get(i);
                            String attrName = (String)hash.get("ATTRIB_COLUMN_NAME");
                            for (String essAttrName : UserMgmtUtil.essentialAttrib) {
                                if (!essAttrName.equals(attrName)) continue;
                                essenPropList.add(hash);
                            }
                            if (essenPropList.contains(hash)) {
                                propList.remove(hash);
                                continue;
                            }
                            ++i;
                        }
                        NativeError error = null;
                        error = !usePowershell ? ADHandler.addUser((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)AddUserListener.this.containerName, (String)userName, (String)samAccountName, (String)password, propList, modifyList, tsList, winNTAttributeList, groupList, essenPropList, (String)homeMDB, (String)dialIn, (String)upn) : ADHandler.addUser((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)AddUserListener.this.containerName, (String)userName, (String)samAccountName, (String)password, exchPropList, modifyList, tsList, winNTAttributeList, groupList, essenPropList, null, (String)dialIn, (String)upn);
                        Properties prop = AddUserErrorHandler.getBulkUserErrorMessage((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (String)userName, (String)samAccountName, (String)CommonUtil.escapeDN((String)AddUserListener.this.containerName), groupList, (NativeError)error);
                        mgmtLog.log(Level.INFO, "userIndex from Listener" + userIndex);
                        prop.put("USER_INDEX", userIndex);
                        prop.setProperty("userName", userName);
                        prop.setProperty("logonName", samAccountName);
                        prop.setProperty("password", password);
                        String CREATION_STATUS = prop.getProperty("CREATION_STATUS");
                        if (!CREATION_STATUS.equalsIgnoreCase("SEVERE")) {
                            NativeError nativeError;
                            NativeError nativeError2;
                            String localPath;
                            String shareName;
                            String serverName;
                            Long accessMask;
                            Long aceType;
                            String objectDN;
                            Properties cloneProperties;
                            Properties properties;
                            ArrayList<Properties> shareAceCloneList;
                            ArrayList shareAceList;
                            NativeError nativeError3;
                            String stringValue;
                            Object objectValue;
                            String key;
                            Enumeration<Object> enumeration;
                            Properties cloneProperties2;
                            Properties properties2;
                            ArrayList<Properties> aceCloneList;
                            ArrayList aceList;
                            ArrayList<Properties> list;
                            ArrayList mbrRights = (ArrayList)permissionTable.get("MBR_ACL");
                            ArrayList<Properties> mbrRightsTemp = new ArrayList<Properties>();
                            if (mbrRights != null && !mbrRights.isEmpty()) {
                                for (Object object : mbrRights) {
                                    Properties properties3 = (Properties)object;
                                    Properties tempProp = (Properties)properties3.clone();
                                    String objectDN2 = properties3.getProperty("DN");
                                    list = UserPermissionsUtil.searchSIDs((String)"DN_STRING", (String)objectDN2, (String)AddUserListener.this.domainName);
                                    if (list.size() == 0) continue;
                                    Properties sidProp = (Properties)list.get(0);
                                    String objectSID = sidProp.getProperty("SID_STRING");
                                    if (objectDN2.equalsIgnoreCase("%userName%")) {
                                        if (!usePowershell) {
                                            tempProp.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                        } else {
                                            tempProp.put("DN", objectSID);
                                        }
                                    } else if (!usePowershell) {
                                        tempProp.put("DN", CommonUtil.escapeDN((String)objectDN2));
                                    } else {
                                        tempProp.put("DN", objectSID);
                                    }
                                    mbrRightsTemp.add(tempProp);
                                }
                                if (homeMDB != null && !usePowershell) {
                                    NativeError nativeError4 = ADHandler.setMailBoxPermission((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, mbrRightsTemp, (String)distinguishedName);
                                    AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError4, (String)"mailBoxRights");
                                }
                            }
                            String searchString = "(&(objectClass=user)(objectCategory=user)(sAMAccountName=" + samAccountName + "))";
                            if (!customList.isEmpty()) {
                                NativeError customError = ADHandler.searchAndModifyUser((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)AddUserListener.this.containerName, (String)searchString, null, null, customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)AddUserListener.this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                            }
                            if (usePowershell) {
                                String ldapString;
                                String message;
                                Properties exchangeServerDetails;
                                if (homeMDB != null) {
                                    exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)AddUserListener.this.domainName, (String)exchangeServer);
                                    message = ADHandler.createMailBox2007((String)AddUserListener.this.domainName, (long)AddUserListener.this.loginId, (String)distinguishedName, (String)mailAlias, (String)homeMDB, (Properties)exchangeServerDetails, mbrRightsTemp);
                                    if (message.length() != 0) {
                                        prop.setProperty("CREATION_MESSAGE", prop.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.legacy_mailbox_created"), AddUserListener.this.rb.getString(message)));
                                    }
                                    MgmtUtil.updateMailServer(propList, exchangeServerDetails);
                                } else if (targetAddress != null && mailAlias != null) {
                                    exchangeServerDetails = ExchangeUtil.getExchangeServerDetailsForAdminGroup((String)AddUserListener.this.domainName, (String)adminGroup, (Long)AddUserListener.this.loginId);
                                    message = ADHandler.createMailEnabled2007((String)AddUserListener.this.domainName, (long)AddUserListener.this.loginId, (String)distinguishedName, (String)mailAlias, (String)targetAddress, (Properties)exchangeServerDetails);
                                    if (message.length() != 0) {
                                        prop.setProperty("CREATION_MESSAGE", prop.getProperty("CREATION_MESSAGE") + " " + MessageFormat.format(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.mail_enabled"), AddUserListener.this.rb.getString(message)));
                                    }
                                }
                                searchString = "(&(objectClass=user)(objectCategory=user)(sAMAccountName=" + samAccountName + "))";
                                boolean policiesExcluded = false;
                                for (Hashtable hashvalue : propList) {
                                    ldapString = (String)hashvalue.get("ATTRIB_LDAP_NAME");
                                    if (!ldapString.equalsIgnoreCase("msExchPoliciesExcluded")) continue;
                                    policiesExcluded = true;
                                    break;
                                }
                                if (!policiesExcluded) {
                                    for (Hashtable hashvalue1 : propList) {
                                        ldapString = (String)hashvalue1.get("ATTRIB_LDAP_NAME");
                                        if (!ldapString.equalsIgnoreCase("proxyAddresses")) continue;
                                        propList.remove(hashvalue1);
                                        break;
                                    }
                                }
                                NativeError exchPropError = ADHandler.searchAndModifyUser((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)AddUserListener.this.containerName, (String)searchString, null, null, propList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)AddUserListener.this.rb, (Properties)prop, (NativeError)exchPropError, (String)searchString);
                                if (!customList.isEmpty()) {
                                    NativeError customError = ADHandler.searchAndModifyUser((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)AddUserListener.this.containerName, (String)searchString, null, null, customList, new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList(), (boolean)false);
                                    AddUserErrorHandler.setBulkUserCustomAttributesError((AdventNetResourceBundle)AddUserListener.this.rb, (Properties)prop, (NativeError)customError, (String)searchString);
                                }
                            }
                            ArrayList memberList = null;
                            String primaryGroupId = null;
                            for (Hashtable hashtable2 : valuesList) {
                                String attributeName = (String)hashtable2.get("ATTRIB_LDAP_NAME");
                                if (attributeName.equalsIgnoreCase("memberOf")) {
                                    memberList = (ArrayList)hashtable2.get("ATTRIB_VALUE");
                                    continue;
                                }
                                if (!attributeName.equalsIgnoreCase("primaryGroupID")) continue;
                                primaryGroupId = (String)hashtable2.get("ATTRIB_VALUE");
                            }
                            if (memberList == null) {
                                memberList = new ArrayList();
                            }
                            if (primaryGroupId == null) {
                                primaryGroupId = "513";
                            }
                            boolean isDifferentPG = false;
                            if (!primaryGroupId.equals("513")) {
                                isDifferentPG = true;
                            }
                            boolean isDomainUserAvail = false;
                            for (Object object : memberList) {
                                String objectRID;
                                String string = (String)object;
                                Properties grpProps = UserMgmtUtil.getPropertiesfromDN((String)string, (ArrayList)AddUserListener.this.userCreationGroupList);
                                if (grpProps == null || !(objectRID = grpProps.getProperty("objectRID")).equals("513")) continue;
                                isDomainUserAvail = true;
                            }
                            if (!isDomainUserAvail && isDifferentPG) {
                                list = new ArrayList<Properties>();
                                Properties p = new Properties();
                                p.put("ATTRIB_VALUE", distinguishedName);
                                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                p.put("DATA_HANDLER_TYPE", new Long(3L));
                                p.put("ATTRIB_LDAP_NAME", "member");
                                p.put("DW_CONTROL_CODE", new Long(4L));
                                list.add(p);
                                String groupSid = UserMgmtUtil.getGroupSIDfromRID((String)"513", (ArrayList)AddUserListener.this.userCreationGroupList);
                                mgmtLog.log(Level.INFO, "Removing Group Domain Users from the Member Of");
                                if (groupSid != null) {
                                    try {
                                        ADHandlerForMgmt.modifyGroup((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)groupSid, (String)distinguishedName, list, null);
                                    }
                                    catch (Exception e) {
                                        mgmtLog.log(Level.INFO, "Error in Removing Group : Domain Users");
                                    }
                                }
                            }
                            if (searchStringBuffer == null) {
                                searchStringBuffer = new StringBuffer("(|");
                            }
                            searchStringBuffer.append("(sAMAccountName=" + samAccountName + ")");
                            if (!remoteHomeDir.equals("") && remoteHomeDir.startsWith("\\")) {
                                try {
                                    aceList = (ArrayList)permissionTable.get("HOME_DIR_ACL");
                                    aceCloneList = new ArrayList<Properties>();
                                    for (Object object : aceList) {
                                        properties2 = (Properties)object;
                                        cloneProperties2 = new Properties();
                                        enumeration = properties2.keys();
                                        while (enumeration.hasMoreElements()) {
                                            key = (String)enumeration.nextElement();
                                            objectValue = properties2.get(key);
                                            if (key.equalsIgnoreCase("DN")) {
                                                stringValue = (String)objectValue;
                                                if (stringValue.equalsIgnoreCase("%userName%")) {
                                                    cloneProperties2.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                                    continue;
                                                }
                                                cloneProperties2.put("DN", CommonUtil.escapeDN((String)((String)objectValue)));
                                                continue;
                                            }
                                            cloneProperties2.put(key, objectValue);
                                        }
                                        aceCloneList.add(cloneProperties2);
                                    }
                                    if (IS_HOME_DIR_SHARED.booleanValue() && remoteHomeDir.endsWith("$")) {
                                        remoteHomeDir = remoteHomeDir.substring(0, remoteHomeDir.length() - 1);
                                    }
                                    Boolean HD_INHERIT_PERMISSIONS = (Boolean)permissionTable.get("HD_INHERIT_PERMISSIONS");
                                    long inheritLong = 0x20000000L;
                                    if (!HD_INHERIT_PERMISSIONS.booleanValue()) {
                                        inheritLong = 0x80000000L;
                                    }
                                    nativeError3 = ADHandlerForMgmt.createFolder((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)remoteHomeDir, null, (String)CommonUtil.escapeDN((String)distinguishedName), aceCloneList, (long)inheritLong);
                                    AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError3, (String)"homeDir");
                                    if (IS_HOME_DIR_SHARED.booleanValue() && nativeError3.getError((Object)AddUserListener.this.domainName) == null) {
                                        shareAceList = (ArrayList)permissionTable.get("SHARE_ACL");
                                        shareAceCloneList = new ArrayList<Properties>();
                                        for (Object object : shareAceList) {
                                            properties = (Properties)object;
                                            cloneProperties = new Properties();
                                            objectDN = (String)properties.get("DN");
                                            if (objectDN.equalsIgnoreCase("%userName%")) {
                                                cloneProperties.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                            } else {
                                                cloneProperties.put("DN", CommonUtil.escapeDN((String)objectDN));
                                            }
                                            aceType = (Long)properties.get("ACE_TYPE");
                                            if (aceType.equals(0L)) {
                                                cloneProperties.put("ACCESS_TYPE", (Object)2L);
                                            } else {
                                                cloneProperties.put("ACCESS_TYPE", (Object)3L);
                                            }
                                            cloneProperties.put("TRUSTEE_TYPE", (Object)1L);
                                            accessMask = (Long)properties.get("ACCESS_MASK");
                                            cloneProperties.put("ACCESS_MASK", accessMask);
                                            shareAceCloneList.add(cloneProperties);
                                        }
                                        serverName = homeDirShareProps.getProperty("serverName");
                                        shareName = homeDirShareProps.getProperty("shareName");
                                        localPath = homeDirShareProps.getProperty("localPath");
                                        nativeError2 = ADHandler.shareFolder((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)serverName, (String)shareName, (String)localPath, shareAceCloneList);
                                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError2, (String)"homeDirShare");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (!tsRemoteHomeDir.equals("") && tsRemoteHomeDir.startsWith("\\\\")) {
                                try {
                                    aceList = (ArrayList)permissionTable.get("TS_HOME_DIR_ACL");
                                    aceCloneList = new ArrayList();
                                    for (Object object : aceList) {
                                        properties2 = (Properties)object;
                                        cloneProperties2 = new Properties();
                                        enumeration = properties2.keys();
                                        while (enumeration.hasMoreElements()) {
                                            key = (String)enumeration.nextElement();
                                            objectValue = properties2.get(key);
                                            if (key.equalsIgnoreCase("DN")) {
                                                stringValue = (String)objectValue;
                                                if (stringValue.equalsIgnoreCase("%userName%")) {
                                                    cloneProperties2.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                                    continue;
                                                }
                                                cloneProperties2.put("DN", CommonUtil.escapeDN((String)((String)objectValue)));
                                                continue;
                                            }
                                            cloneProperties2.put(key, objectValue);
                                        }
                                        aceCloneList.add(cloneProperties2);
                                    }
                                    if (TS_IS_HOME_DIR_SHARED.booleanValue() && tsRemoteHomeDir.endsWith("$")) {
                                        tsRemoteHomeDir = tsRemoteHomeDir.substring(0, tsRemoteHomeDir.length() - 1);
                                    }
                                    Boolean TS_HD_INHERIT_PERMISSIONS = (Boolean)permissionTable.get("TS_HD_INHERIT_PERMISSIONS");
                                    long inheritLong = 0x20000000L;
                                    if (!TS_HD_INHERIT_PERMISSIONS.booleanValue()) {
                                        inheritLong = 0x80000000L;
                                    }
                                    nativeError3 = ADHandlerForMgmt.createFolder((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)tsRemoteHomeDir, null, (String)CommonUtil.escapeDN((String)distinguishedName), aceCloneList, (long)inheritLong);
                                    AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError3, (String)"tsHomeDir");
                                    if (TS_IS_HOME_DIR_SHARED.booleanValue() && nativeError3.getError((Object)AddUserListener.this.domainName) == null) {
                                        shareAceList = (ArrayList)permissionTable.get("TS_SHARE_ACL");
                                        shareAceCloneList = new ArrayList();
                                        for (Object object : shareAceList) {
                                            properties = (Properties)object;
                                            cloneProperties = new Properties();
                                            objectDN = (String)properties.get("DN");
                                            if (objectDN.equalsIgnoreCase("%userName%")) {
                                                cloneProperties.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                            } else {
                                                cloneProperties.put("DN", CommonUtil.escapeDN((String)objectDN));
                                            }
                                            aceType = (Long)properties.get("ACE_TYPE");
                                            if (aceType.equals(0L)) {
                                                cloneProperties.put("ACCESS_TYPE", (Object)2L);
                                            } else {
                                                cloneProperties.put("ACCESS_TYPE", (Object)3L);
                                            }
                                            cloneProperties.put("TRUSTEE_TYPE", (Object)1L);
                                            accessMask = (Long)properties.get("ACCESS_MASK");
                                            cloneProperties.put("ACCESS_MASK", accessMask);
                                            shareAceCloneList.add(cloneProperties);
                                        }
                                        serverName = tsHomeDirShareProps.getProperty("serverName");
                                        shareName = tsHomeDirShareProps.getProperty("shareName");
                                        localPath = tsHomeDirShareProps.getProperty("localPath");
                                        nativeError2 = ADHandler.shareFolder((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)serverName, (String)shareName, (String)localPath, shareAceCloneList);
                                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError2, (String)"tsHomeDirShare");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (!profilePath.equals("") && profilePath.startsWith("\\\\")) {
                                try {
                                    aceList = (ArrayList)permissionTable.get("PROF_DIR_ACL");
                                    aceCloneList = new ArrayList();
                                    for (Object object : aceList) {
                                        properties2 = (Properties)object;
                                        cloneProperties2 = new Properties();
                                        enumeration = properties2.keys();
                                        while (enumeration.hasMoreElements()) {
                                            key = (String)enumeration.nextElement();
                                            objectValue = properties2.get(key);
                                            if (key.equalsIgnoreCase("DN")) {
                                                stringValue = (String)objectValue;
                                                if (stringValue.equalsIgnoreCase("%userName%")) {
                                                    cloneProperties2.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                                    continue;
                                                }
                                                cloneProperties2.put("DN", CommonUtil.escapeDN((String)((String)objectValue)));
                                                continue;
                                            }
                                            cloneProperties2.put(key, objectValue);
                                        }
                                        aceCloneList.add(cloneProperties2);
                                    }
                                    if (profilePath.endsWith("$")) {
                                        profilePath = profilePath.substring(0, profilePath.length() - 1);
                                    }
                                    Boolean CREATE_PROFILE = (Boolean)permissionTable.get("CREATE_PROFILE");
                                    Boolean PROF_INHERIT_PERMISSIONS = (Boolean)permissionTable.get("PROF_INHERIT_PERMISSIONS");
                                    long inheritLong = 0x20000000L;
                                    if (!PROF_INHERIT_PERMISSIONS.booleanValue()) {
                                        inheritLong = 0x80000000L;
                                    }
                                    if (CREATE_PROFILE.booleanValue()) {
                                        nativeError = ADHandlerForMgmt.createFolder((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)profilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), aceCloneList, (long)inheritLong);
                                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError, (String)"profilePath");
                                        Boolean VISTA_PROFILE = (Boolean)permissionTable.get("VISTA_PROFILE");
                                        if (VISTA_PROFILE.booleanValue()) {
                                            profilePath = profilePath + ".v2";
                                            nativeError = ADHandlerForMgmt.createFolder((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)profilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), aceCloneList, (long)inheritLong);
                                            AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError, (String)"vistaprofilePath");
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            if (!tsProfilePath.equals("") && tsProfilePath.startsWith("\\\\")) {
                                try {
                                    aceList = (ArrayList)permissionTable.get("TS_PROF_DIR_ACL");
                                    aceCloneList = new ArrayList();
                                    for (Object object : aceList) {
                                        Properties properties4 = (Properties)object;
                                        cloneProperties2 = new Properties();
                                        enumeration = properties4.keys();
                                        while (enumeration.hasMoreElements()) {
                                            key = (String)enumeration.nextElement();
                                            objectValue = properties4.get(key);
                                            if (key.equalsIgnoreCase("DN")) {
                                                stringValue = (String)objectValue;
                                                if (stringValue.equalsIgnoreCase("%userName%")) {
                                                    cloneProperties2.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                                                    continue;
                                                }
                                                cloneProperties2.put("DN", CommonUtil.escapeDN((String)((String)objectValue)));
                                                continue;
                                            }
                                            cloneProperties2.put(key, objectValue);
                                        }
                                        aceCloneList.add(cloneProperties2);
                                    }
                                    if (tsProfilePath.endsWith("$")) {
                                        tsProfilePath = tsProfilePath.substring(0, tsProfilePath.length() - 1);
                                    }
                                    Boolean TS_CREATE_PROFILE = (Boolean)permissionTable.get("TS_CREATE_PROFILE");
                                    Boolean TS_PROF_INHERIT_PERMISSIONS = (Boolean)permissionTable.get("TS_PROF_INHERIT_PERMISSIONS");
                                    long inheritLong = 0x20000000L;
                                    if (!TS_PROF_INHERIT_PERMISSIONS.booleanValue()) {
                                        inheritLong = 0x80000000L;
                                    }
                                    if (TS_CREATE_PROFILE.booleanValue()) {
                                        nativeError = ADHandlerForMgmt.createFolder((String)AddUserListener.this.domainName, (Long)AddUserListener.this.loginId, (String)tsProfilePath, null, (String)CommonUtil.escapeDN((String)distinguishedName), aceCloneList, (long)inheritLong);
                                        AddUserErrorHandler.setBulkUserHFError((AdventNetResourceBundle)AddUserListener.this.rb, (String)AddUserListener.this.domainName, (Properties)prop, (NativeError)nativeError, (String)"tsProfilePath");
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                            Long templateId = AddUserHandler.getTemplateId((Long)userIndex);
                            Boolean isCustomScriptEnabled = UserCreationScriptHandler.isCustomScriptEnabled((Long)templateId);
                            String scriptResult = AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script");
                            if (isCustomScriptEnabled.booleanValue()) {
                                try {
                                    Hashtable customScriptTable = UserCreationScriptHandler.getCustomScriptProps((Long)templateId);
                                    String command = (String)customScriptTable.get("SCRIPT_COMMAND");
                                    if (command != null && !command.equals("")) {
                                        command = FormatClientUtil.getFormatValue(AddUserListener.this.domainName, command, valuesList, samAccountName, userName, customList);
                                    }
                                    Boolean runScript = false;
                                    Boolean ignoreWarning = (Boolean)customScriptTable.get("IGNORE_WARNING");
                                    Long timeOut = 5L;
                                    if (command != null && !command.equals("") && !prop.getProperty("CREATION_STATUS").equalsIgnoreCase("SEVERE")) {
                                        if (ignoreWarning.booleanValue()) {
                                            runScript = true;
                                        } else if (!prop.getProperty("CREATION_STATUS").equalsIgnoreCase("WARNING")) {
                                            runScript = true;
                                        }
                                    }
                                    if (runScript.booleanValue()) {
                                        CustomScript customScript = new CustomScript(AddUserListener.this.rb, timeOut, command);
                                        scriptResult = customScript.runThread();
                                        if (scriptResult.indexOf("All rights reserved.") != -1) {
                                            scriptResult.substring(scriptResult.indexOf("All rights reserved.") + 20);
                                        }
                                        scriptResult = MessageFormat.format(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.script_execution"), scriptResult);
                                    }
                                }
                                catch (Exception e) {
                                    scriptResult = AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exception_script_execution");
                                    e.printStackTrace();
                                }
                                String status = prop.getProperty("CREATION_MESSAGE") + "\t" + scriptResult;
                                prop.setProperty("CREATION_MESSAGE", status);
                            }
                        }
                        AddUserListener.this.addRow(prop);
                        TechAuditAPI.getInstance().auditLogs(AddUserListener.this.loginId, logProps, prop.getProperty("CREATION_MESSAGE"), AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.mgmtname.user_creation"), AddUserListener.this.rb);
                        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
                    } else {
                        Properties prop = new Properties();
                        prop.setProperty("CREATION_STATUS", "WARNING");
                        prop.setProperty("CREATION_MESSAGE", MessageFormat.format(AddUserListener.this.rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.statmsg.could_not_create_license_level_exceeded"), LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers")));
                        prop.setProperty("CREATION_IMAGE", "/images/error_icon.gif");
                        prop.setProperty("CREATION_MESSAGE_STYLE", "blacktxt1");
                        prop.put("USER_INDEX", userIndex);
                        prop.setProperty("userName", userName);
                        prop.setProperty("logonName", samAccountName);
                        prop.setProperty("password", password);
                        AddUserListener.this.addRow(prop);
                        audit_info.put("error_msg", prop.getProperty("CREATION_MESSAGE"));
                    }
                    mgmtLog.log(Level.INFO, "After User Creation");
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                if (searchStringBuffer != null) {
                    searchStringBuffer.append(")");
                    mgmtLog.log(Level.INFO, "Search String :" + searchStringBuffer);
                }
                this.addUserListener.isCompleted = true;
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            }
            catch (Exception e) {
                mgmtLog.log(Level.SEVERE, "Native Exception : " + e.getMessage());
                e.printStackTrace();
                this.addUserListener.isCompleted = true;
            }
        }
    }
}

