/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.CategoryHandler;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.LCSServerHandler;
import com.adventnet.sym.adsm.common.server.LyncServerHandler;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportReqParams;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.CSVReader;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.upload.FormFile;

public class BulkModificationAPI {
    static Logger logger = Logger.getLogger("ADMangLogger");

    protected static void setDomainList(HttpServletRequest request, ActionForm form) {
        block3: {
            try {
                HttpSession session = request.getSession();
                ReportBean bean = (ReportBean)form;
                Integer reportId = (Integer)bean.get("reportId");
                Long actionId = ClientUtil.getActionId(reportId);
                request.setAttribute("actionId", (Object)actionId);
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                Hashtable domainVsactions = authObject.getDomainActionMap();
                ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
                bean.set("domainList", domainList);
                String[] domainsArr = (String[])bean.get("domains");
                if (domainsArr == null || domainsArr.length <= 0) break block3;
                String currentDomainNamingContext = domainsArr[0];
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                String currentDomain = (String)dnDomainNameMap.get(currentDomainNamingContext);
                if (domainList == null || currentDomain == null) break block3;
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties domainProps = (Properties)domainList.get(i);
                    String domainNameFromProps = domainProps.getProperty("DOMAIN_NAME");
                    if (!currentDomain.equalsIgnoreCase(domainNameFromProps)) continue;
                    domainList.remove(i);
                    domainList.add(0, domainProps);
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected static void setLegacyExchExists(HttpServletRequest request, ActionForm form) {
        try {
            ReportBean bean = (ReportBean)form;
            Boolean legexch = false;
            Criteria criteria = new Criteria(new Column("ADSMExchangeServers", "VERSION"), null, 1);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMExchangeServers", criteria);
            Iterator itr = dataobj.getRows("ADSMExchangeServers");
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                String ver = (String)r.get("VERSION");
                StringTokenizer st = new StringTokenizer(ver, "Version ", false);
                float vn = Float.parseFloat(st.nextToken());
                if (!((double)vn <= 6.5)) continue;
                legexch = true;
            }
            bean.set("LegacyExch", legexch.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void doAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String operation = request.getParameter("operation");
        logger.log(Level.INFO, "ModifyAction doAction Operation : " + operation);
        ReportBean bean = (ReportBean)form;
        if (request.getParameter("resetValues") != null) {
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            listener.checkBoxes(request, bean);
        }
        if (operation.equalsIgnoreCase("Show Users") || operation.equalsIgnoreCase("Stop") || operation.equalsIgnoreCase("showList")) {
            BulkModificationAPI.search(bean, request, response);
        } else if (operation.equalsIgnoreCase("Apply") || operation.equalsIgnoreCase("Stop Modification") || operation.equalsIgnoreCase("showModifyUserResult")) {
            BulkModificationAPI.apply(bean, request, response);
        }
    }

    protected static void setArrayValues(HttpServletRequest request, ReportBean bean) {
        String[] ar = new String[]{"publicDelegatesList", "publicDelegatesLabel", "userValues", "userLabels", "allowInheritable", "meMRrecipientsDNList", "meMRrecipientsDisplayList", "proxyAddressValues", "proxyAddressLabels", "sendAsDelegatesList", "sendAsDelegatesLabel", "ldapMultiValue"};
        BeanMap props = (BeanMap)bean.get("props");
        for (int i = 0; i < ar.length; ++i) {
            if (request.getParameterValues(ar[i]) == null) continue;
            String[] ar1 = request.getParameterValues(ar[i]);
            props.put(ar[i], request.getParameterValues(ar[i]));
        }
    }

    private static boolean checkAuthForMgmtAction(HttpServletRequest request, ReportBean bean) throws Exception {
        String[] domains = (String[])bean.get("domains");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        if (domains != null && domains.length > 0) {
            String defaultNamingContext = domains[0];
            String domainName = (String)dnDomainNameMap.get(defaultNamingContext);
            return ClientAuthorizationUtil.isAuthorized(request, domainName, (Integer)bean.get("reportId"));
        }
        return true;
    }

    protected static void search(ReportBean bean, HttpServletRequest request, HttpServletResponse response) {
        String forwardPage = "result";
        BulkModificationAPI.setArrayValues(request, bean);
        Integer reportId = (Integer)bean.get("reportId");
        ModifyUserListener listener = (ModifyUserListener)bean.getListener();
        String operation = request.getParameter("operation");
        try {
            ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId);
            if (BulkModificationAPI.checkAuthForMgmtAction(request, bean)) {
                if (operation.equalsIgnoreCase("Show Users")) {
                    listener.search(request, bean);
                    request.setAttribute("listener", (Object)listener);
                    bean.set("attributeId", new Integer(-1));
                    bean.set("FROM_INDEX", new Long(1L));
                    bean.set("PAGE_NUMBER", "1");
                    bean.set("ascending", "true");
                    BulkModificationAPI.initBeanDatas(bean);
                } else if (listener.getGenerationId() != null) {
                    ReportClientUtil.checkAndSetSelectAllObjectGUIDs(request, bean);
                    if (operation.equalsIgnoreCase("Stop")) {
                        listener.stop(request);
                    }
                    ReportResultUtil.setRecordsCount(request, bean, listener.getGenerationId(), new ReportReqParams());
                    listener.setEmptyFieldsMessage(request, bean);
                }
                request.setAttribute("operation", (Object)operation);
            } else {
                System.out.println(" checkAuthForMgmtAction is false for the reportId " + reportId + " Ssetting error mesg");
                request.setAttribute("errorMsg", (Object)"Access denied");
                request.setAttribute("operation", (Object)"showList");
            }
            request.setAttribute("ColumnList", (Object)attributelist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void initBeanProps(ReportBean bean) {
        BeanMap props = (BeanMap)bean.get("props");
        String[] propsKeys = new String[]{"addToGroupSidVsNameMap", "removeFromGroupSidVsNameMap", "addToGroupDNVsNameMap", "removeFromGroupDNVsNameMap"};
        for (int index = 0; index < propsKeys.length; ++index) {
            props.put(propsKeys[index], new Hashtable());
        }
    }

    protected static void initBeanDatas(ReportBean bean) {
        bean.set("selectedSIDs", new ArrayList());
        bean.set("deSelectedSIDs", new ArrayList());
        bean.set("selectAllUsers", "false");
    }

    protected static void resetResultTable(ReportBean bean) {
        ModifyUserListener listener = (ModifyUserListener)bean.getListener();
        Long generationId = listener.getGenerationId();
        try {
            UpdateQueryImpl updateQuery = new UpdateQueryImpl(listener.getResultTableName());
            Criteria criteria = new Criteria(Column.getColumn((String)listener.getResultTableName(), (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get(listener.getResultTableName(), criteria);
            updateQuery.setCriteria(criteria);
            updateQuery.setUpdateColumn("MESSAGE", (Object)"NULL");
            CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Error in setting UserPersonalDetails");
            e.printStackTrace();
        }
    }

    protected static void apply(ReportBean bean, HttpServletRequest request, HttpServletResponse response) {
        try {
            Integer reportId = (Integer)bean.get("reportId");
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String operation = request.getParameter("operation");
            ArrayList modifiedList = ReportAttributeHandler.getInstance().getModifiedColumns(reportId);
            if (operation.equalsIgnoreCase("Apply")) {
                bean.set("modifyResultColumn", "");
                bean.set("FROM_INDEX", new Long(1L));
                bean.set("PAGE_NUMBER", "1");
                bean.set("ascending", "true");
                bean.set("searchSIDs", new ArrayList());
                ReportClientUtil.checkAndSetSelectAllObjectGUIDs(request, bean);
                listener.modifyUser(request, bean);
                request.setAttribute("listener", (Object)listener);
            } else if (operation.equalsIgnoreCase("Stop Modification")) {
                listener.stop(request);
                ReportResultUtil.setModifyResult(request, bean, reportId, listener.getGenerationId(), listener.getResultTableName());
            } else if (operation.equalsIgnoreCase("showModifyUserResult")) {
                ReportResultUtil.setModifyResult(request, bean, reportId, listener.getGenerationId(), listener.getResultTableName());
            }
            request.setAttribute("ColumnList", (Object)modifiedList);
            request.setAttribute("operation", (Object)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static boolean checkReportIDChanges(ReportBean bean, HttpServletRequest request) {
        boolean status = false;
        try {
            Integer reportId = (Integer)bean.get("reportId");
            Integer previousReportId = (Integer)bean.get("previousReportId");
            ModifyUserListener listener = null;
            if (reportId != null && !reportId.equals(previousReportId)) {
                status = true;
                HttpSession session = request.getSession();
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                Long[] actionIds = authObject.getActionArray();
                DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
                Row r = obj.getFirstRow("ADSMReports");
                String tile = (String)r.get("TILE_NAME");
                String className = (String)r.get("CLASS_NAME");
                String description = (String)r.get("DESCRIPTION");
                Class<?> classToInvoke = Class.forName(className.trim());
                listener = (ModifyUserListener)classToInvoke.newInstance();
                listener.init(request, r);
                bean.set("tile", tile);
                bean.setListener(listener);
                bean.set("previousReportId", reportId);
                bean.set("attributeId", new Integer(-1));
                bean.set("RANGE", NavigateRangeUtil.getDefaultRange((String)"BulkModification", (Long)loginId));
                bean.set("FROM_INDEX", new Long(1L));
                bean.set("PAGE_NUMBER", "1");
                bean.set("ascending", "true");
                bean.set("description", description);
                bean.set("inputSource", "");
                bean.set("reportActions", CategoryHandler.getReportActions((Long)listener.getCategoryId(), (Long[])actionIds));
                BulkModificationAPI.initBeanDatas(bean);
                BulkModificationAPI.initBeanProps(bean);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    protected static void setValues(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            Integer reportId = (Integer)bean.get("reportId");
            Integer previousReportId = (Integer)bean.get("previousReportId");
            ModifyUserListener listener = null;
            if (request.getParameter("init") != null) {
                bean.set("reportId", new Integer(-1));
                bean.set("previousReportId", new Integer(0));
                bean.set("inputSource", "");
            } else if (BulkModificationAPI.checkReportIDChanges(bean, request)) {
                Hashtable hash = new Hashtable();
                bean.set("domainOUList", hash);
                bean.set("domainVsExcludeChildOU", new Hashtable());
                bean.set("excludedOUList", new Hashtable());
            } else if (bean.getListener() != null) {
                listener = (ModifyUserListener)bean.getListener();
                listener.setRb(ResourceBundleMgr.getInstance().getBundle());
            }
            Hashtable domains = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
            bean.set("dnDomainNameMap", domains.get("dnDomainNameMap"));
            String[] parameters = new String[]{rb.getString("admp.mgmt.user_mgmt.common.input.select_attribute"), "displayName", "userPrincipalName", "sn", "cn", "mail", "mailNickName", "company", "description"};
            String[] searchTypes = new String[]{"contains", "startsWith", "endsWith", "equal"};
            bean.set("parameterList", parameters);
            BeanMap props = (BeanMap)bean.get("props");
            if (reportId == 1005 || reportId == 1015 || reportId == 1024 || reportId == 1039) {
                String drives = rb.getString("admp.mgmt.user_mgmt.common.input.drivelist");
                if (reportId == 1015) {
                    drives = rb.getString("admp.user_creation.ts_drives");
                    ArrayList<String> tsLogon = new ArrayList<String>();
                    ArrayList<String> tsLogonValues = new ArrayList<String>();
                    tsLogon.add("Allow");
                    tsLogon.add("Deny");
                    tsLogonValues.add(rb.getString("usermanagement.terminal_profile_attributes.allow"));
                    tsLogonValues.add(rb.getString("usermanagement.terminal_profile_attributes.deny"));
                    props.put("tsLogonKey", tsLogon);
                    props.put("tsLogonValues", tsLogonValues);
                }
                String[] driveList = drives.split(",");
                props.put("driveList", driveList);
            } else if (reportId == 1017) {
                ArrayList<String> reConnectSettingsOptions = new ArrayList<String>();
                ArrayList<String> reConnectSettingsOptionValues = new ArrayList<String>();
                reConnectSettingsOptions.add("--");
                reConnectSettingsOptions.add("usermanagement.terminal_sessions.from_any_client");
                reConnectSettingsOptions.add("usermanagement.terminal_sessions.from_originating_client_only");
                reConnectSettingsOptionValues.add(rb.getString("usermanagement.terminal_environment.NA"));
                reConnectSettingsOptionValues.add(rb.getString("usermanagement.terminal_sessions.from_any_client"));
                reConnectSettingsOptionValues.add(rb.getString("usermanagement.terminal_sessions.from_originating_client_only"));
                props.put("reConnectSettingsOptions", reConnectSettingsOptions);
                props.put("reConnectSettingsOptionValues", reConnectSettingsOptionValues);
                reConnectSettingsOptions = new ArrayList();
                reConnectSettingsOptionValues = new ArrayList();
                reConnectSettingsOptions.add("--");
                reConnectSettingsOptions.add("usermanagement.terminal_sessions.disconnect_from_session");
                reConnectSettingsOptions.add("usermanagement.terminal_sessions.end_session");
                reConnectSettingsOptionValues.add(rb.getString("usermanagement.terminal_environment.NA"));
                reConnectSettingsOptionValues.add(rb.getString("usermanagement.terminal_sessions.disconnect_from_session"));
                reConnectSettingsOptionValues.add(rb.getString("usermanagement.terminal_sessions.end_session"));
                props.put("brokenTimeOutSettingsOption", reConnectSettingsOptions);
                props.put("brokenTimeOutSettingsValues", reConnectSettingsOptionValues);
                ArrayList<String> sessionLabels = new ArrayList<String>();
                for (int i = 0; i < UserMgmtUtil.sessionLabelList.size(); ++i) {
                    sessionLabels.add(i, rb.getString((String)UserMgmtUtil.sessionLabelList.get(i)));
                }
                props.put("timeLabels", sessionLabels);
                props.put("timeValues", UserMgmtUtil.sessionValues);
            } else if (reportId == 3004 || reportId == 3005 || reportId == 1001 || reportId == 1020 || reportId == 1011) {
                AdminUtil.setFormatsAndRules(props, request);
                String[] colNames = null;
                String[] propNames = null;
                if (reportId == 3004) {
                    String[] repPropNames;
                    String[] repColNames;
                    colNames = repColNames = new String[]{"EMAIL_ADDRESS_FORMAT"};
                    propNames = repPropNames = new String[]{"mailFormat"};
                    props.put("mailDomain", "");
                    BulkModificationAPI.setOrgAttribList(request, props, "physicalDeliveryOfficeName", "OFFICE", "officesList", rb);
                } else if (reportId == 3005) {
                    String[] repColNames = new String[]{"FULL_NAME_FORMAT", "DISPLAY_NAME_FORMAT"};
                    colNames = repColNames;
                    String[] repPropNames = new String[]{"fullNameFormat", "displayNameFormat"};
                    propNames = repPropNames;
                } else if (reportId == 1001) {
                    String[] repColNames = new String[]{"LOGON_NAME_FORMAT", "SAM_ACCOUNT_NAME_FORMAT", "FULL_NAME_FORMAT", "DISPLAY_NAME_FORMAT"};
                    colNames = repColNames;
                    String[] repPropNames = new String[]{"logonNameFormat", "samAccountNameFormat", "fullNameFormat", "displayNameFormat"};
                    propNames = repPropNames;
                } else if (reportId == 1020) {
                    String[] repColNames = new String[]{"EMAIL_ADDRESS_FORMAT"};
                    colNames = repColNames;
                    String[] repPropNames = new String[]{"mailFormat"};
                    propNames = repPropNames;
                    props.put("mailDomain", "");
                    BulkModificationAPI.setOrgAttribList(request, props, "physicalDeliveryOfficeName", "OFFICE", "officesList", rb);
                } else if (reportId == 1011) {
                    String[] repColNames = new String[]{"MAIL_ALIAS_FORMAT", "SIMPLE_DISPLAY_NAME_FORMAT"};
                    colNames = repColNames;
                    String[] repPropNames = new String[]{"mailNickName", "displayNamePrintable"};
                    propNames = repPropNames;
                    ArrayList<String> msExchHideFromAddressListsValues = new ArrayList<String>();
                    ArrayList<String> msExchHideFromAddressListsKey = new ArrayList<String>();
                    msExchHideFromAddressListsKey.add("--");
                    msExchHideFromAddressListsKey.add("usermanagement.terminal_environment.yes");
                    msExchHideFromAddressListsKey.add("usermanagement.terminal_environment.no");
                    msExchHideFromAddressListsValues.add(rb.getString("usermanagement.terminal_environment.NA"));
                    msExchHideFromAddressListsValues.add(rb.getString("usermanagement.terminal_environment.yes"));
                    msExchHideFromAddressListsValues.add(rb.getString("usermanagement.terminal_environment.no"));
                    props.put("msExchHideFromAddressListsValues", msExchHideFromAddressListsValues);
                    props.put("msExchHideFromAddressListsKey", msExchHideFromAddressListsKey);
                }
                BulkModificationAPI.setDefaultFormatSettingsProps(propNames, colNames, props);
            } else if (reportId == 1028) {
                ArrayList<String> remoteAccessOptions = new ArrayList<String>();
                ArrayList<String> remoteAccessOptionValues = new ArrayList<String>();
                remoteAccessOptions.add("usermanagement.terminal_profile_attributes.allow");
                remoteAccessOptions.add("usermanagement.terminal_profile_attributes.deny");
                remoteAccessOptions.add("usermanagement.dial_in.apply_remote_access_policy");
                remoteAccessOptionValues.add(rb.getString("usermanagement.terminal_profile_attributes.allow"));
                remoteAccessOptionValues.add(rb.getString("usermanagement.terminal_profile_attributes.deny"));
                remoteAccessOptionValues.add(rb.getString("usermanagement.dial_in.apply_remote_access_policy"));
                props.put("remoteAccessOptions", remoteAccessOptions);
                props.put("remoteAccessOptionValues", remoteAccessOptionValues);
            } else if (reportId == 1016) {
                ArrayList<String> environmentOptions = new ArrayList<String>();
                ArrayList<String> environmentOptionValues = new ArrayList<String>();
                environmentOptions.add("--");
                environmentOptions.add("usermanagement.terminal_environment.yes");
                environmentOptions.add("usermanagement.terminal_environment.no");
                environmentOptionValues.add(rb.getString("usermanagement.terminal_environment.NA"));
                environmentOptionValues.add(rb.getString("usermanagement.terminal_environment.yes"));
                environmentOptionValues.add(rb.getString("usermanagement.terminal_environment.no"));
                props.put("environmentOptions", environmentOptions);
                props.put("environmentOptionValues", environmentOptionValues);
                environmentOptions = new ArrayList();
                environmentOptionValues = new ArrayList();
                environmentOptions.add("--");
                environmentOptions.add("usermanagement.terminal_environment.enable");
                environmentOptions.add("usermanagement.terminal_environment.disable");
                environmentOptionValues.add(rb.getString("usermanagement.terminal_environment.NA"));
                environmentOptionValues.add(rb.getString("usermanagement.terminal_environment.enable"));
                environmentOptionValues.add(rb.getString("usermanagement.terminal_environment.disable"));
                props.put("startProgramOptions", environmentOptions);
                props.put("startProgramOptionValues", environmentOptionValues);
            } else if (reportId == 1019) {
                ArrayList<String> passwordOptions = new ArrayList<String>();
                ArrayList<String> passwordOptionValues = new ArrayList<String>();
                passwordOptions.add("--");
                passwordOptions.add("Yes");
                passwordOptions.add("No");
                passwordOptionValues.add(rb.getString("admp.mgmt.user_mgmt.ts_env.input.na"));
                passwordOptionValues.add(rb.getString("admp.mgmt.user_mgmt.common.input.yes"));
                passwordOptionValues.add(rb.getString("admp.mgmt.user_mgmt.common.input.no"));
                props.put("passwordOptions", passwordOptions);
                props.put("passwordOptionValues", passwordOptionValues);
            } else if (reportId == 1002) {
                ArrayList<String> account = new ArrayList<String>();
                ArrayList<String> accountValues = new ArrayList<String>();
                account.add("--");
                account.add("Enable");
                account.add("Disable");
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.ts_env.input.na"));
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.ts_env.input.enable"));
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.ts_env.input.disable"));
                props.put("accountKey", account);
                props.put("accountValues", accountValues);
                accountValues = new ArrayList();
                account = new ArrayList();
                account.add("--");
                account.add("Never");
                account.add("End Of");
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.enab_dis_users.input.na"));
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.enab_dis_users.input.never"));
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.enab_dis_users.input.end_of"));
                props.put("expiresKey", account);
                props.put("expiresValue", accountValues);
            } else if (reportId == 1011) {
                AdminUtil.setFormatsAndRules(props, request);
                String[] colNames = new String[]{"MAIL_ALIAS_FORMAT", "SIMPLE_DISPLAY_NAME_FORMAT"};
                String[] propNames = new String[]{"mailNickName", "displayNamePrintable"};
                ArrayList formatValueList = new ArrayList();
                BulkModificationAPI.setDefaultFormatSettingsProps(propNames, colNames, props);
                ArrayList displayList = (ArrayList)props.get("formats");
                ArrayList valueList = (ArrayList)props.get("formatValues");
                displayList.add(0, rb.getString("client.admin.adminutil.select_format"));
                valueList.add(0, "--");
            } else if (reportId == 1012) {
                ArrayList<String> exchangeAccount = new ArrayList<String>();
                ArrayList<String> exchangeAccountValues = new ArrayList<String>();
                exchangeAccount.add("--");
                exchangeAccount.add("Enable");
                exchangeAccount.add("Disable");
                exchangeAccountValues.add(rb.getString("usermanagement.terminal_environment.NA"));
                exchangeAccountValues.add(rb.getString("usermanagement.terminal_environment.enable"));
                exchangeAccountValues.add(rb.getString("usermanagement.terminal_environment.disable"));
                props.put("exchangeAccount", exchangeAccount);
                props.put("exchangeAccountValues", exchangeAccountValues);
            } else if (reportId == 1013 || reportId == 1030) {
                BulkModificationAPI.setMailBoxValues(request, bean, false);
                AdminUtil.setFormatsAndRules(props, request);
                String[] colNames = new String[]{"MAIL_ALIAS_FORMAT"};
                String[] propNames = new String[]{"mailAlias"};
                BulkModificationAPI.setDefaultFormatSettingsProps(propNames, colNames, props);
            } else if (reportId == 1031) {
                BulkModificationAPI.setMailBoxValues(request, bean, true);
            } else if (reportId == 1037) {
                MgmtClientUtil.setPoliciesValues(request, bean);
            } else if (reportId == 1025) {
                String[] jniType = new String[]{"CHAR", "INTEGER", "BOOLEAN", "BIGINT", "DATETIME", "UTCTIME", "MULTIVALUE"};
                String[] displayType = new String[]{rb.getString("admp.mgmt.user_mgmt.ldap_attrbs.data_type.unicode_string"), rb.getString("admp.mgmt.user_mgmt.ldap_attrbs.data_type.integer"), rb.getString("admp.mgmt.user_mgmt.ldap_attrbs.data_type.boolean"), rb.getString("admp.mgmt.user_mgmt.ldap_attrbs.data_type.larger_int"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_date_time"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_utc_coded_time"), rb.getString("admp.admin.custom_settgs.ldap_attrbs.attribvalue_multivalue_string")};
                props.put("displayType", displayType);
                props.put("jniType", jniType);
            } else if (reportId == 1027) {
                BulkModificationAPI.setOffLineAddressList(request, bean);
            } else if (reportId == 1003 || reportId == 3003) {
                String[] ldapNameArray = new String[]{"TITLE", "COMPANY", "DEPARTMENT"};
                String[] attribNameArray = new String[]{"TITLE", "COMPANY", "DEPT"};
                String[] attribListNameArray = new String[]{"titleList", "companyList", "deptList"};
                for (int i = 0; i < ldapNameArray.length; ++i) {
                    BulkModificationAPI.setOrgAttribList(request, props, ldapNameArray[i], attribNameArray[i], attribListNameArray[i], rb);
                }
            } else if (reportId == 1029) {
                ArrayList<Properties> mailBoxRightsList = new ArrayList<Properties>();
                Properties mbAceTable = new Properties();
                Object[] values = new Object[]{"%userName%", "%userName%", 131072L, rb.getString("admp.ad_mgmt.create_temp.mbox_rights.read_permissions"), 2L, rb.getString("admp.ad_mgmt.create_temp.mbox_rights.this_object_and_subcontainers"), 0L, rb.getString("admp.mgmt.user_mgmt.mailbox_rights.attribvalue_allow")};
                for (int i = 0; i < UserPermissionsUtil.folderACEProps.length; ++i) {
                    mbAceTable.put(UserPermissionsUtil.folderACEProps[i], values[i]);
                }
                mailBoxRightsList.add(mbAceTable);
                props.put("MBR_ACL", mailBoxRightsList);
            } else if (reportId == 1034) {
                ArrayList<String> account = new ArrayList<String>();
                ArrayList<String> accountValues = new ArrayList<String>();
                account.add("Enable");
                account.add("Disable");
                account.add("Delete");
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.ts_env.input.enable"));
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.ts_env.input.disable"));
                accountValues.add(rb.getString("admp.mgmt.user_mgmt.csv_mod_users.delete"));
                props.put("accountKey", account);
                props.put("accountValues", accountValues);
                BulkModificationAPI.setCommunicationServers(request, bean);
            } else if (reportId == 1008) {
                if (props.get("delivContLengthScale") == null) {
                    props.put("delivContLengthScale", "usermanagement.delivery_restrictions.kB");
                }
                if (props.get("submissionContlengthScale") == null) {
                    props.put("submissionContlengthScale", "usermanagement.delivery_restrictions.kB");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setCommunicationServers(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            String previousDomainName;
            String domainName = null;
            String[] domains = (String[])bean.get("domains");
            BeanMap props = (BeanMap)bean.get("props");
            Integer reportId = (Integer)bean.get("reportId");
            Long actionId = ClientUtil.getActionId(reportId);
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
            if (domains.length > 0) {
                boolean authDomain = false;
                String val = domains[0];
                if (val.endsWith("disable")) {
                    val = val.substring(0, val.lastIndexOf("disable"));
                }
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(val);
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties propsVal = (Properties)domainList.get(i);
                    if (!propsVal.getProperty("DOMAIN_NAME").equalsIgnoreCase(domainName)) continue;
                    authDomain = true;
                    break;
                }
                if (!authDomain) {
                    Properties domainProp = (Properties)domainList.get(0);
                    domainName = domainProp.getProperty("DOMAIN_NAME");
                }
            }
            if (domainName == null) {
                Properties domainProps = (Properties)domainList.get(0);
                domainName = domainProps.getProperty("DOMAIN_NAME");
                for (int i = 0; i < domainList.size(); ++i) {
                    domainProps = (Properties)domainList.get(i);
                    if (!domainProps.getProperty("IS_DEFAULT_DOMAIN").equalsIgnoreCase("true")) continue;
                    domainName = domainProps.getProperty("DOMAIN_NAME");
                }
            }
            if (!(previousDomainName = props.getProperty("previousDomainName")).equalsIgnoreCase(domainName)) {
                props.put("serverNameValue", "");
                props.put("previousDomainName", domainName);
            }
            ArrayList lyncservers = LyncServerHandler.getLyncServers((String)domainName);
            ArrayList serverNames = new ArrayList();
            ArrayList serverNameValues = new ArrayList();
            ArrayList servers = LCSServerHandler.getLCSServers((String)domainName);
            String serverNameValue = props.getProperty("serverNameValue");
            if (lyncservers != null && !lyncservers.isEmpty()) {
                serverNames = (ArrayList)lyncservers.get(0);
                serverNameValues = (ArrayList)lyncservers.get(1);
            }
            if (servers != null && !servers.isEmpty()) {
                serverNames.addAll((ArrayList)servers.get(0));
                serverNameValues.addAll((ArrayList)servers.get(1));
            }
            if (serverNames.size() == 0) {
                serverNames.add(rb.getString("admp.mgmt.user_mgmt.cre_template.text_no_live_communication_servers_found"));
                serverNameValues.add("0");
            }
            if (serverNameValue == null || serverNameValue.equalsIgnoreCase("")) {
                serverNameValue = (String)serverNameValues.get(0);
            }
            props.put("serverNames", serverNames);
            props.put("serverNameValues", serverNameValues);
            props.put("serverNameValue", serverNameValue);
            props.put("SPI_URI_FORMAT", "sip:%mail%");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setOrgAttribList(HttpServletRequest request, BeanMap props, String ldapName, String attribName, String attribListName, AdventNetResourceBundle rb) {
        ArrayList<String> attribList = new ArrayList<String>();
        String attribVal = "";
        if (props.get(ldapName) != null) {
            attribVal = (String)props.get(ldapName);
        }
        try {
            DataObject dataObj = AdminUtil.comboAttribs(attribName);
            Iterator it = dataObj.getRows("ADSMOrgAttributes");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                attribList.add(rb.getString((String)r.get("ORG_ATTRIB_NAME")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (attribVal != "" && !attribList.contains(attribVal)) {
            attribList.add(attribVal);
        }
        Collections.sort(attribList, String.CASE_INSENSITIVE_ORDER);
        props.put(attribListName, attribList);
    }

    private static void setDefaultFormatSettingsProps(String[] propNames, String[] colNames, BeanMap props) {
        try {
            Criteria crit = null;
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatDefaultSettings", crit);
            if (obj.isEmpty()) {
                for (int i = 0; i < colNames.length; ++i) {
                    props.put(propNames[i], 0L);
                }
            } else {
                Iterator it = obj.getRows("ADSMFormatDefaultSettings");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    for (int i = 0; i < colNames.length; ++i) {
                        Long formatValue = (Long)r.get(colNames[i]);
                        String formatValueStr = formatValue.toString();
                        props.put(propNames[i], formatValueStr);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setMailBoxValues(HttpServletRequest request, ReportBean bean, Boolean hideLegacyServers) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            String mailBoxStoreValue;
            String serverNameValue;
            String previousDomainName;
            String domainName = null;
            String[] domains = (String[])bean.get("domains");
            BeanMap props = (BeanMap)bean.get("props");
            Integer reportId = (Integer)bean.get("reportId");
            Long actionId = ClientUtil.getActionId(reportId);
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
            boolean isServerAvailable = true;
            if (domains.length > 0) {
                boolean authDomain = false;
                String val = domains[0];
                if (val.endsWith("disable")) {
                    val = val.substring(0, val.lastIndexOf("disable"));
                }
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(val);
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties propsVal = (Properties)domainList.get(i);
                    if (!propsVal.getProperty("DOMAIN_NAME").equalsIgnoreCase(domainName)) continue;
                    authDomain = true;
                    break;
                }
                if (!authDomain) {
                    Properties domainProp = (Properties)domainList.get(0);
                    domainName = domainProp.getProperty("DOMAIN_NAME");
                }
            }
            if (domainName == null) {
                Properties domainProps = (Properties)domainList.get(0);
                domainName = domainProps.getProperty("DOMAIN_NAME");
                for (int i = 0; i < domainList.size(); ++i) {
                    Properties propsVal = (Properties)domainList.get(i);
                    if (!propsVal.getProperty("IS_DEFAULT_DOMAIN").equalsIgnoreCase("true")) continue;
                    domainName = propsVal.getProperty("DOMAIN_NAME");
                }
            }
            if (!(previousDomainName = props.getProperty("previousDomainName")).equalsIgnoreCase(domainName)) {
                props.put("serverNameValue", "");
                props.put("previousDomainName", domainName);
            }
            ArrayList servers = new ArrayList();
            ArrayList dag = new ArrayList();
            if (!hideLegacyServers.booleanValue()) {
                servers = ExchangeHandler.getExchangeServers((String)domainName);
                dag = ExchangeHandler.getDagDetails((String)domainName);
            } else {
                servers = ExchangeUtil.getPSExchangeServers((String)domainName);
            }
            ArrayList serverNames = new ArrayList();
            ArrayList serverNameValues = new ArrayList();
            ArrayList dagNames = new ArrayList();
            ArrayList dagNameValues = new ArrayList();
            if (servers != null && !servers.isEmpty()) {
                serverNames = (ArrayList)servers.get(0);
                serverNameValues = (ArrayList)servers.get(1);
            }
            if (serverNames.size() == 0) {
                serverNames.add(rb.getString("client.usermanagement.CreateMailBoxListener.no_mail_servers_available"));
                serverNameValues.add("0");
                isServerAvailable = false;
            }
            if (isServerAvailable && reportId == 1030) {
                serverNames.add(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.servername.all_servers"));
                serverNameValues.add("All Servers");
            }
            if (dag != null && !dag.isEmpty()) {
                dagNames = (ArrayList)dag.get(0);
                dagNameValues = (ArrayList)dag.get(1);
            }
            if ((serverNameValue = props.getProperty("serverNameValue")) == null || serverNameValue.equalsIgnoreCase("")) {
                serverNameValue = (String)serverNameValues.get(0);
            }
            props.put("serverNames", serverNames);
            props.put("serverNameValues", serverNameValues);
            props.put("serverNameValue", serverNameValue);
            props.put("dagNames", dagNames);
            props.put("dagNameValues", dagNameValues);
            ArrayList mailBoxes = ExchangeHandler.getMailBoxStores((String)domainName, (String)serverNameValue);
            ArrayList<String> mailBoxStores = new ArrayList<String>();
            ArrayList<String> mailBoxStoreValues = new ArrayList<String>();
            if (mailBoxes != null && !mailBoxes.isEmpty()) {
                Integer exchVersion = ExchangeUtil.getExchangeServerType((String)serverNameValue);
                if (exchVersion >= 2010 && reportId == 1013) {
                    mailBoxStores.add(rb.getString("client.usermanagement.CreateMailBoxListener.automatic"));
                    mailBoxStoreValues.add("0");
                }
                mailBoxStores.addAll((ArrayList)mailBoxes.get(0));
                mailBoxStoreValues.addAll((ArrayList)mailBoxes.get(1));
            }
            boolean isExch2007 = ExchangeUtil.checkExchange2007((String)serverNameValue);
            if (mailBoxStores.size() == 0 && serverNameValue.equalsIgnoreCase("All Servers")) {
                mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.servername.all_databases"));
                mailBoxStoreValues.add("All databases");
                isExch2007 = true;
            }
            if (mailBoxStores.size() == 0) {
                mailBoxStores.add(rb.getString("client.usermanagement.CreateMailBoxListener.no_mail_box_stores"));
                mailBoxStoreValues.add("0");
            }
            if ((mailBoxStoreValue = (String)props.get("mailBoxStoreValue")) == null || mailBoxStoreValue.equalsIgnoreCase("")) {
                mailBoxStoreValue = (String)mailBoxStoreValues.get(0);
            }
            props.put("mailBoxStores", mailBoxStores);
            props.put("mailBoxStoreValues", mailBoxStoreValues);
            props.put("mailBoxStoreValue", mailBoxStoreValue);
            if (isExch2007) {
                props.put("exch2007Display", "display:block;");
                props.put("exch2003Display", "display:none;");
            } else {
                props.put("exch2007Display", "display:none;");
                props.put("exch2003Display", "display:block;");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setOffLineAddressList(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            String offlineAddress;
            String previousDomainName;
            String domainName = null;
            String[] domains = (String[])bean.get("domains");
            BeanMap props = (BeanMap)bean.get("props");
            if (domains.length > 0) {
                String val = domains[0];
                if (val.endsWith("disable")) {
                    val = val.substring(0, val.lastIndexOf("disable"));
                }
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(val);
            }
            if (domainName == null) {
                Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            }
            if (!(previousDomainName = props.getProperty("previousDomainName")).equalsIgnoreCase(domainName)) {
                props.put("offlineAddress", "");
                props.put("previousDomainName", domainName);
            }
            ArrayList offlineAddList = ExchangeHandler.getExchangeOfflineAddressList((String)domainName);
            ArrayList offlineAddListNames = (ArrayList)offlineAddList.get(0);
            ArrayList offlineAddListDNs = (ArrayList)offlineAddList.get(1);
            if (offlineAddListNames.size() == 0) {
                offlineAddListNames.add(rb.getString("usermanagement.modify_offline_address_book.no_exchange_offline_address_books_available"));
                offlineAddListDNs.add("0");
            }
            if ((offlineAddress = props.getProperty("offlineAddress")) == null || offlineAddress.equalsIgnoreCase("")) {
                offlineAddress = (String)offlineAddListDNs.get(0);
            }
            props.put("offlineAddListNames", offlineAddListNames);
            props.put("offlineAddListDNs", offlineAddListDNs);
            props.put("offlineAddress", offlineAddress);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static Boolean csvImport(ReportBean bean, HttpServletRequest request) {
        Integer[] nonSearchableAttribId = new Integer[]{1234, 2051, 3039, 8018, 10069, 1047};
        Boolean importedFileStatus = true;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            String[] domains = (String[])bean.get("domains");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String defaultNamingContext = domains[0];
            String domainName = (String)dnDomainNameMap.get(defaultNamingContext);
            String sessionID = request.getSession().getId();
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = "CN=Users," + defaultNamingContext;
            if (ouList.size() > 0) {
                containerName = (String)ouList.get(0);
            }
            Long userCreationID = AddUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, null, loginId);
            listener.setGenerationId(userCreationID);
            FileInputStream fileInputStream = null;
            UploadedFileItem uploadedFileItem = null;
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                if (!filesList.isEmpty()) {
                    uploadedFileItem = (UploadedFileItem)filesList.get(0);
                    File file = uploadedFileItem.getUploadedFile();
                    fileInputStream = new FileInputStream(file);
                } else {
                    request.setAttribute("importErrorMessage", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.empty_file_provide_ldap_attrib_values_separate_rows"));
                    return false;
                }
            }
            FormFile formFile = (FormFile)bean.get("browse");
            String fileName = uploadedFileItem.getFileName();
            request.setAttribute("fileName", (Object)fileName);
            FileInputStream stream = fileInputStream;
            Vector headerVector = new Vector();
            int headerSize = 0;
            Vector valuesVector = new Vector();
            StringBuilder message = new StringBuilder();
            boolean header = true;
            if (fileName != null) {
                if (!fileName.substring(fileName.lastIndexOf(".")).equalsIgnoreCase(".csv")) {
                    message.append(rb.getString("admp.mgmt.bulk_creation.common.info.sel_csv_file_import"));
                    importedFileStatus = false;
                    request.setAttribute("importErrorMessage", (Object)message.toString());
                    return importedFileStatus;
                }
                try {
                    stream = fileInputStream;
                }
                catch (Exception e) {
                    message.append(e.getMessage());
                    importedFileStatus = false;
                    request.setAttribute("importErrorMessage", (Object)message.toString());
                }
            }
            CSVReader csvReader = new CSVReader(stream, rb);
            ArrayList<Vector> list = new ArrayList<Vector>();
            try {
                headerVector = csvReader.getAllFieldsInLine();
                headerSize = headerVector.size();
            }
            catch (Exception headerVectorException) {
                if (headerVectorException instanceof EOFException) {
                    csvReader.close();
                }
                csvReader.close();
                request.setAttribute("importErrorMessage", (Object)headerVectorException.getMessage());
                importedFileStatus = false;
            }
            if (headerVector.isEmpty() || headerSize == 1 && headerVector.get(0).toString().equals("")) {
                request.setAttribute("importErrorMessage", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.empty_file_provide_ldap_attrib_values_separate_rows"));
                importedFileStatus = false;
            }
            try {
                while (true) {
                    if ((valuesVector = csvReader.getAllFieldsInLine()).size() != headerSize) {
                        csvReader.close();
                        message = new StringBuilder();
                        message.append(rb.getString("admp.mgmt.fc_layout_error.header_and_value_size_should_equal"));
                        importedFileStatus = false;
                        request.setAttribute("importErrorMessage", (Object)message.toString());
                        return importedFileStatus;
                    }
                    list.add(valuesVector);
                }
            }
            catch (Exception e) {
                if (e instanceof EOFException) {
                    csvReader.close();
                } else {
                    csvReader.close();
                    importedFileStatus = false;
                    request.setAttribute("importErrorMessage", (Object)e.getMessage());
                }
                if (list.isEmpty()) {
                    request.setAttribute("importErrorMessage", (Object)rb.getString("admp.mgmt.csv_import.common.statmsg.one_row_available_provide_both_ldap_attrib_header_values_in_consecutive_rows"));
                    importedFileStatus = false;
                }
                ArrayList<Hashtable> attributeList = new ArrayList<Hashtable>();
                ArrayList unKnownAttribtesList = new ArrayList();
                ArrayList headerVectorArray = new ArrayList();
                Locale locale = request.getLocale();
                if (headerVector != null) {
                    headerSize = headerVector.size();
                    for (Object object : headerVector) {
                        Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", object);
                        headerVectorArray.add(object);
                        if (!attributesdetails.isEmpty()) {
                            Long actionId = (Long)attributesdetails.get("ACTION_ID");
                            Integer attribId = (Integer)attributesdetails.get("ATTRIB_ID");
                            Integer relationalType = (Integer)attributesdetails.get("RELATIONAL_TYPE");
                            if (!attributeList.contains(attributesdetails) && actionId != null && actionId < 16000L && relationalType != 1) {
                                if (Arrays.asList(nonSearchableAttribId).contains(attribId)) continue;
                                attributeList.add(attributesdetails);
                                continue;
                            }
                            String ldapName = (String)attributesdetails.get("ATTRIB_LDAP_NAME");
                            if (!AddUserHandler.getInstance().isCustomAttribute(attribId) || relationalType == 1) continue;
                            attributeList.add(attributesdetails);
                            continue;
                        }
                        unKnownAttribtesList.add(object);
                    }
                }
                bean.set("headerVectorArray", headerVectorArray);
                bean.set("attributeList", attributeList);
                ArrayList userDetailsList = new ArrayList();
                ArrayList customDetailsList = new ArrayList();
                if (headerVector != null && !list.isEmpty()) {
                    for (Vector vector : list) {
                        try {
                            Hashtable userDetails = new Hashtable();
                            ArrayList<Properties> customDetail = new ArrayList<Properties>();
                            for (int i = 0; i < vector.size(); ++i) {
                                Object object = vector.get(i);
                                String headerObject = (String)headerVector.get(i);
                                if (unKnownAttribtesList.contains(headerObject)) {
                                    String str = (String)object;
                                    StringTokenizer token = new StringTokenizer(str, ";");
                                    while (token.hasMoreElements()) {
                                        String s = (String)token.nextElement();
                                        Properties properties = new Properties();
                                        properties.setProperty("CUSTOM_ATTRIB_NAME", headerObject);
                                        properties.setProperty("CUSTOM_ATTRIB_VALUE", s);
                                        customDetail.add(properties);
                                    }
                                    continue;
                                }
                                for (Hashtable hashtable : attributeList) {
                                    String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                                    Integer relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                                    if (relationalType == 1) {
                                        String[] multiValuesArray;
                                        ArrayList<String> l = new ArrayList<String>();
                                        String str = (String)object;
                                        for (String string : multiValuesArray = str.split("(?<!\\\\);")) {
                                            l.add(string);
                                        }
                                        if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                        userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), l);
                                        continue;
                                    }
                                    if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                    userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), object);
                                }
                            }
                            userDetailsList.add(userDetails);
                            customDetailsList.add(customDetail);
                        }
                        catch (ArrayIndexOutOfBoundsException e2) {
                            int vectorIndex = list.indexOf(vector);
                            vectorIndex = header ? (vectorIndex += 2) : ++vectorIndex;
                            message = new StringBuilder();
                            message.append(rb.getString("usermanagement.message.at_line"));
                            message.append(" " + vectorIndex + " ");
                            message.append(rb.getString("usermanagement.message.in_the_file"));
                            message.append(" " + vector.size() + " ");
                            message.append(rb.getString("usermanagement.message.values_are_found_against"));
                            message.append(" " + headerSize + " ");
                            message.append(rb.getString("usermanagement.message.values_in_the_header"));
                            importedFileStatus = false;
                            request.setAttribute("importErrorMessage", (Object)message.toString());
                            break;
                        }
                    }
                }
                if (!userDetailsList.isEmpty()) {
                    AddUserHandler.getInstance().addUserDetailsList(userCreationID, userDetailsList, attributeList, customDetailsList);
                }
                request.setAttribute("count", (Object)new Long(AddUserHandler.getInstance().getCount(userCreationID).intValue()));
                request.setAttribute("importSuccessMessage", (Object)rb.getString("client.csv.CSVUserListener.successfully_imported_values"));
                bean.set("inputSource", "csv");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return importedFileStatus;
    }

    protected static Criteria getFilterCriter(HttpServletRequest request, String oldResultTableName) {
        Criteria filtercrCriteria = null;
        String filter = request.getParameter("filter");
        filtercrCriteria = filter != null && filter.equals("filter") ? ReportResultUtil.getModifiedSidFilterCriteria(oldResultTableName) : ReportResultUtil.getModifiedSidCriteria(oldResultTableName);
        logger.log(Level.INFO, "Mgmt-to-Mgmt action execuation filter criteria : " + filtercrCriteria);
        return filtercrCriteria;
    }

    protected static Criteria getFilterCriterForCsv(HttpServletRequest request) {
        Criteria filtercrCriteria = null;
        String filter = request.getParameter("filter");
        if (filter != null && filter.equals("filter")) {
            filtercrCriteria = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_STATUS"), (Object)"*Error*", 3);
            filtercrCriteria = filtercrCriteria.and(new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_STATUS"), (Object)"*Warning*", 3));
        } else {
            filtercrCriteria = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_STATUS"), (Object)"NULL", 1);
        }
        logger.log(Level.INFO, "Mgmt-to-Mgmt (by csvimport) action execuation filter criteria : " + filtercrCriteria);
        return filtercrCriteria;
    }

    public static boolean showMoreAction(ReportBean bean) {
        Integer reportId = (Integer)bean.get("reportId");
        ArrayList<Integer> deleteActionReportIdList = new ArrayList<Integer>();
        deleteActionReportIdList.add(1026);
        deleteActionReportIdList.add(2005);
        deleteActionReportIdList.add(3006);
        deleteActionReportIdList.add(4003);
        deleteActionReportIdList.add(9006);
        return deleteActionReportIdList.contains(reportId);
    }

    public static Object getConfigForHDT(Long loginId, String paramName) {
        Object configValue = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPUsersPersonal", crit);
            Row r = dataObj.getFirstRow("ADMPUsersPersonal");
            configValue = r.get(paramName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configValue;
    }

    public static void updateConfigForHDT(Long loginId, String paramName, Object paramValue) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPUsersPersonal", crit);
            Row r = dataObj.getFirstRow("ADMPUsersPersonal");
            r.set(paramName, paramValue);
            dataObj.updateRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

