/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.FcValidation;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ContactsListener
extends ModifyUserListener {
    public ContactsListener() {
        this.reportId = new Integer(1020);
        this.actions = new String[]{"telephoneNumber", "mailFormat", "wWWHomePage", "desc", "physicalDeliveryOfficeName", "homePhone", "pager", "mobile", "facsimileTelephoneNumber", "ipPhone", "info"};
        this.actionIds = new long[]{1223L, 1224L, 1225L, 1226L, 1227L, 1228L, 1229L, 1230L, 1231L, 1232L, 1307L};
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1018L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            BeanMap props = (BeanMap)bean.get("props");
            for (int j = 0; j < selectedAttributes.length; ++j) {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, this.getId(selectedAttributes[j]))) continue;
                Properties p = new Properties();
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                String beanValue = props.getProperty(selectedAttributes[j]);
                if (beanValue.equals("")) {
                    p.put("DW_CONTROL_CODE", new Long(1L));
                }
                p.put("ATTRIB_VALUE", beanValue);
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                if (selectedAttributes[j].equals("mailFormat")) {
                    String val = FormatClientUtil.getFormatValue(new Long(props.getProperty("mailFormat")), result, domainName, "");
                    val = val + "@" + FormatClientUtil.getFormatValue(props.getProperty("mailDomain"), result, domainName, "");
                    String errorMsg = FcValidation.doEmailIdValidation((String)this.rb.getString("admp.common.attrib_disp_name.e_mail"), (Object)val, (AdventNetResourceBundle)this.rb);
                    if (!errorMsg.equalsIgnoreCase("")) {
                        message.append(errorMsg);
                    }
                    p.put("ATTRIB_LDAP_NAME", "mail");
                    p.put("ATTRIB_VALUE", val);
                } else if (selectedAttributes[j].equals("desc")) {
                    p.put("ATTRIB_LDAP_NAME", "description");
                }
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error") + " : ");
                    }
                } else {
                    message.insert(0, MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), new String("")));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.contact_attribs.mgmtname.contact_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        try {
            String emptyFields = "";
            String[] actionLabels = new String[]{"admp.mgmt.user_mgmt.contact_attribs.input.telephone_number", "admp.mgmt.user_mgmt.contact_attribs.input.e_mail", "admp.mgmt.user_mgmt.contact_attribs.input.web_page", "admp.mgmt.user_mgmt.contact_attribs.input.description", "admp.mgmt.user_mgmt.contact_attribs.input.office", "admp.mgmt.user_mgmt.contact_attribs.input.home_phone", "admp.mgmt.user_mgmt.contact_attribs.input.pager", "admp.mgmt.user_mgmt.contact_attribs.input.mobile", "admp.mgmt.user_mgmt.contact_attribs.input.fax", "admp.mgmt.user_mgmt.contact_attribs.input.ip_phone", "admp.mgmt.user_mgmt.contact_attribs.input.notes"};
            Locale locale = request.getLocale();
            List<String> selectedAttributes = Arrays.asList((String[])bean.get("selectedAttributes"));
            BeanMap props = (BeanMap)bean.get("props");
            for (int i = 0; i < this.actions.length; ++i) {
                String beanValue;
                if (!selectedAttributes.contains(this.actions[i]) || this.actions[i].equals("mailFormat") || !(beanValue = props.getProperty(this.actions[i])).equals("")) continue;
                emptyFields = emptyFields.length() == 0 ? this.rb.getString(actionLabels[i]) : emptyFields + "," + this.rb.getString(actionLabels[i]);
            }
            if (emptyFields.length() != 0) {
                emptyFields = MessageFormat.format(this.rb.getString("admp.mgmt.common.confirm.blank_values_cleared_in_ad_want_to_continue"), emptyFields);
                request.setAttribute("emptyFields", (Object)emptyFields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

