/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CreateMailBoxListener
extends ModifyUserListener {
    public CreateMailBoxListener() {
        this.reportId = new Integer(1013);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        try {
            Properties p;
            String mailBox;
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1027L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String sid = this.getValue(result, 1144);
            String firstName = this.getValue(result, 1001);
            String lastName = this.getValue(result, 1002);
            String initials = this.getValue(result, 1003);
            String logonName = this.getValue(result, 1006);
            String dn = this.getValue(result, 1004);
            BeanMap props = (BeanMap)bean.get("props");
            String mailAliasFormat = props.getProperty("mailAlias");
            String mailAlias = "";
            boolean validAlias = true;
            if (!mailAliasFormat.equalsIgnoreCase("--")) {
                Properties p2 = new Properties();
                mailAlias = FormatClientUtil.getFormatValue(new Long(mailAliasFormat), result, domainName, "");
                if (!mailAlias.equals("")) {
                    String query = "(&(objectCategory=person)(objectclass=user)(mailNickName=";
                    boolean isExists = ADHandler.checkObjectExist((String)domainName, (Long)loginId, (String)(query + mailAlias + "))"), null);
                    if (isExists) {
                        int i = 2;
                        while (isExists) {
                            isExists = ADHandler.checkObjectExist((String)domainName, (Long)loginId, (String)(query + mailAlias + i + "))"), null);
                            ++i;
                        }
                        mailAlias = mailAlias + i;
                    }
                    String splChars = "@()[]\\;:\",<> ";
                    for (int i = 0; i < mailAlias.length(); ++i) {
                        if (splChars.indexOf(mailAlias.charAt(i)) == -1) continue;
                        validAlias = false;
                    }
                    p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p2.put("ATTRIB_LDAP_NAME", "mailNickName");
                    p2.put("DATA_HANDLER_TYPE", new Long(3L));
                    p2.put("ATTRIB_VALUE", mailAlias);
                    setAttributeList.add(p2);
                }
            }
            if (!(mailBox = props.getProperty("mailBoxStoreValue")).equals("0")) {
                Properties p1 = new Properties();
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("ATTRIB_LDAP_NAME", "homeMDB");
                p1.put("DATA_HANDLER_TYPE", new Long(1L));
                p1.put("ATTRIB_VALUE", mailBox);
                setAttributeList.add(p1);
            }
            Properties p2 = new Properties();
            p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p2.put("ATTRIB_LDAP_NAME", "msExchHomeServerName");
            p2.put("DATA_HANDLER_TYPE", new Long(1L));
            p2.put("ATTRIB_VALUE", props.getProperty("serverNameValue"));
            setAttributeList.add(p2);
            Properties p3 = new Properties();
            p3.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p3.put("DATA_HANDLER_TYPE", new Long(3L));
            p3.put("ATTRIB_LDAP_NAME", "mdbusedefaults");
            p3.put("ATTRIB_VALUE", "TRUE");
            setAttributeList.add(p3);
            logger.log(Level.INFO, "The mail store box & sid is : " + sid + " & attrib list : " + setAttributeList);
            String mailServer = props.getProperty("serverNameValue");
            String createMailbox = props.getProperty("crechxBox");
            String archiveMailbox = props.getProperty("arcchxBox");
            String statMessage = "";
            String actionName = this.rb.getString("usermanagement.CreateMailBox.createMailBoxToTheUsers");
            String objectGUID = (String)result.get("OBJECT_GUID");
            objectGUID = objectGUID.substring(objectGUID.indexOf("{") + 1, objectGUID.indexOf("}"));
            boolean usePowershell = false;
            Properties exchangeServerDetails = new Properties();
            String exchVersion = "2003";
            Integer exchType = 2003;
            if (!mailBox.equals("0")) {
                mailServer = ExchangeUtil.getMailboxServer((String)mailBox, (String)domainName);
            }
            usePowershell = ExchangeUtil.checkExchange2007((String)mailServer);
            exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
            exchVersion = exchangeServerDetails.getProperty("VERSION");
            exchType = (int)ExchangeUtil.getExchType((String)exchVersion);
            try {
                if ((mailAlias == null || mailAlias.equalsIgnoreCase("")) && createMailbox.equalsIgnoreCase("on")) {
                    throw new Exception(this.rb.getString("client.usermanagement.CreateMailBoxListener.empty_mail_nick_name_is_not_allowed"));
                }
                if (createMailbox.equalsIgnoreCase("on")) {
                    actionName = this.rb.getString("admp.mgmt.user_mgmt.cre_mailbox.mgmtname.create_mailbox");
                    if (validAlias) {
                        if (usePowershell) {
                            statMessage = ADHandler.createMailBox2007((String)domainName, (long)loginId, (String)objectGUID, (String)mailAlias, (String)mailBox, (Properties)exchangeServerDetails, null, (String)dn);
                            MgmtUtil.updateMailServer(setAttributeList, exchangeServerDetails);
                            message.append(this.rb.getString(statMessage));
                            if (statMessage.equals("")) {
                                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                            }
                        }
                        if (!usePowershell) {
                            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                            ADHandler.createMailBox((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)mailBox);
                        }
                        if (message.length() == 0) {
                            message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                        }
                    } else {
                        message.append(this.rb.getString("admp.management.usermanagement.create_mailbox.message.pls_enter_valid_alias_name"));
                    }
                }
                if (archiveMailbox.equalsIgnoreCase("on")) {
                    if (exchType >= 2010) {
                        actionName = this.rb.getString("admp.mgmt.user_mgmt.cre_mailbox.mgmtname.create_archive_mailbox");
                        statMessage = ADHandler.enableArchiveMailbox((String)domainName, (long)loginId, (String)objectGUID, (String)mailBox, (String)"", (Properties)exchangeServerDetails, (boolean)false, (String)dn);
                        if (!statMessage.equals("") && message.indexOf(this.rb.getString(statMessage)) == -1) {
                            message.append(this.rb.getString(statMessage));
                        }
                    } else {
                        message.append(this.rb.getString("admp.mgmt.user_mgmt.create_archive_mailbox.statmsg_archive_not_enabled"));
                    }
                    p = new Properties();
                    p.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.cre_template.input_archive_mailbox"));
                    p.put("ATTRIB_VALUE", this.rb.getString("admp.ad_explorer.view_props.user.common.statmsg.true"));
                    setAttributeList.add(p);
                }
                if (createMailbox.equalsIgnoreCase("on") && archiveMailbox.equalsIgnoreCase("on")) {
                    actionName = this.rb.getString("usermanagement.CreateMailBox.createMailBoxToTheUsers");
                }
                if (message.length() == 0) {
                    message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("groupmanagement.messages.successfully_modified_error") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(e.getMessage());
            }
            if (mailBox.equals("0")) {
                p = new Properties();
                p.put("ATTRIB_VALUE", this.rb.getString("admp.mgmt.user_mgmt.cre_template.auto_select_mailbox"));
                p.put("ATTRIB_LDAP_NAME", "homeMDB");
                setAttributeList.add(p);
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, actionName, this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

