/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class CustomScript {
    public AdventNetResourceBundle rb = null;
    public long timeOut = 1L;
    private String command = "";
    private String result = "Success";
    String encoding = "UTF-8";

    public CustomScript(AdventNetResourceBundle adventNetResourceBundle, Long l, String string) {
        this.rb = adventNetResourceBundle;
        this.timeOut = l;
        this.command = string;
    }

    public CustomScript() {
    }

    public String runThread() {
        try {
            if (CommonUtil.isDemo()) {
                return this.rb.getString("admp.common.text.custom_script_disabled_in_demo");
            }
            CustomScriptThread customScriptThread = new CustomScriptThread(this);
            this.encoding = I18NUtil.getDefaultCSVCharEncoding((Long)CommonUtil.ADMIN_LOGIN_ID);
            System.out.println("Starting CustomScriptThread ...");
            customScriptThread.start();
            long l = System.currentTimeMillis();
            try {
                customScriptThread.join(this.timeOut * 1000L, 1);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            System.out.println("CustomScriptThread ::" + customScriptThread.getName());
            if ((customScriptThread.isAlive() || System.currentTimeMillis() - l > this.timeOut * 1000L) && customScriptThread.isAlive()) {
                System.out.println("Custom script Thread alive......");
                try {
                    this.result = this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.custom_script_running_background");
                }
                catch (SecurityException securityException) {
                    securityException.printStackTrace();
                }
            }
            customScriptThread = null;
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            illegalThreadStateException.printStackTrace();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return this.result;
    }

    private class CustomScriptThread
    extends Thread {
        CustomScript customScript = new CustomScript();
        String encoding = I18NUtil.getDefaultCSVCharEncoding((Long)CommonUtil.ADMIN_LOGIN_ID);

        public CustomScriptThread(CustomScript customScript2) {
            this.customScript = customScript2;
        }

        private ArrayList<String> getScriptCommandArray(String string) {
            Pattern pattern = Pattern.compile("(?!\\B\"[^\"]*)\\s(?![^\"]*\"\\B)");
            String[] stringArray = string.split("\\s\"\"");
            ArrayList<String> arrayList = new ArrayList<String>();
            for (String string2 : stringArray) {
                String[] stringArray2;
                for (String string3 : stringArray2 = pattern.split(string2)) {
                    arrayList.add(string3);
                }
            }
            if (string.endsWith("\"\"")) {
                arrayList.add("");
            }
            return arrayList;
        }

        @Override
        public void run() {
            try {
                String string = "";
                Process process = null;
                ArrayList<String> arrayList = new ArrayList<String>();
                System.out.println("Custom Script Command::" + CustomScript.this.command);
                if (CustomScript.this.command == null) {
                    return;
                }
                Object object = this.getScriptCommandArray(CustomScript.this.command);
                String string2 = "";
                for (int i = 0; i < ((ArrayList)object).size(); ++i) {
                    if (string2.equalsIgnoreCase(".ps1")) {
                        arrayList.add("\"" + this.psEscape((String)((ArrayList)object).get(i)) + "\"");
                    } else {
                        arrayList.add((String)((ArrayList)object).get(i));
                    }
                    if (string2 != "") continue;
                    try {
                        File file;
                        String string3 = ((ArrayList)object).get(i);
                        if (string3.startsWith("\"") && string3.endsWith("\"")) {
                            string3 = string3.substring(1, string3.length() - 1);
                        }
                        if (!(file = new File(string3)).exists() || (string3 = file.getName()).indexOf(".") == -1) continue;
                        string2 = string3.substring(string3.lastIndexOf("."), string3.length());
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                System.out.println("Custom Script Command Array::" + ((Object)arrayList).toString());
                process = new ProcessBuilder(arrayList).start();
                process.getOutputStream().close();
                object = new BufferedReader(new InputStreamReader(process.getErrorStream(), this.encoding));
                string2 = null;
                if (!((BufferedReader)object).ready()) {
                    CustomScriptThread.sleep(1000L);
                }
                if (((BufferedReader)object).ready()) {
                    while ((string2 = ((BufferedReader)object).readLine()) != null) {
                        string = string + string2 + "\n";
                    }
                }
                ((BufferedReader)object).close();
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream(), this.encoding));
                while ((string2 = bufferedReader.readLine()) != null) {
                    string = string + string2 + "\n";
                }
                bufferedReader.close();
                if (!string.equalsIgnoreCase("")) {
                    CustomScript.this.result = string;
                }
                process.destroy();
            }
            catch (IOException iOException) {
                CustomScript.this.result = CustomScript.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.ioexception_occured_execution_script");
                iOException.printStackTrace();
            }
            catch (SecurityException securityException) {
                CustomScript.this.result = CustomScript.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.security_exception_occured_execution_script");
                securityException.printStackTrace();
            }
            catch (Exception exception) {
                CustomScript.this.result = CustomScript.this.rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exception_occured_execution_script");
                exception.printStackTrace();
            }
            System.out.println("CustomScript Execution finished...");
            System.out.println("Result:" + CustomScript.this.result);
        }

        private String psEscape(String string) {
            if (string.startsWith("\"") && string.endsWith("\"")) {
                string = string.substring(1, string.length() - 1);
            }
            String string2 = string.replace("\"", "`\\\"");
            return string2;
        }
    }
}

