/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUtil;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.webclient.TemplateAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class DeliveryOptionsListener
extends ModifyUserListener {
    public DeliveryOptionsListener() {
        this.cks = new String[]{"deliverAndReDirect"};
        this.reportId = new Integer(1009);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1023L})) {
            return this.rb.getString("client.DomainAction.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            BeanMap props = (BeanMap)bean.get("props");
            Properties auditSendAsProps = null;
            ArrayList sendAsDelegates = null;
            String sendAsOperation = "add";
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p;
                if (selectedAttributes[j].equals("publicDelegates")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1243L)) continue;
                    ArrayList publicDelegates = ClientUtil.getList((String[])props.get("publicDelegatesList"));
                    int count = publicDelegates.size();
                    p = new Properties();
                    p.put("ATTRIB_VALUE_COUNT", new Long(publicDelegates.size()));
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    p.put("DW_CONTROL_CODE", new Long(3L));
                    if (count > 0) {
                        if (count == 1) {
                            p.put("ATTRIB_VALUE", publicDelegates.get(0));
                        } else {
                            p.put("ATTRIB_VALUE", publicDelegates);
                        }
                    } else {
                        p.put("DW_CONTROL_CODE", new Long(1L));
                        p.put("ATTRIB_VALUE", "");
                    }
                    p.put("ATTRIB_LDAP_NAME", "publicDelegates");
                    setAttributeList.add(p);
                    continue;
                }
                if (selectedAttributes[j].equals("sendAsDelegates")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1279L)) continue;
                    sendAsDelegates = ClientUtil.getList((String[])props.get("sendAsDelegatesList"));
                    int count = sendAsDelegates.size();
                    auditSendAsProps = new Properties();
                    ArrayList<String> dNList = new ArrayList<String>();
                    String[] tableArray = new String[]{"ADSMUserGeneralDetails", "ADSMGroupGeneralDetails"};
                    String[] requiredColumns = new String[]{"DISTINGUISHED_NAME", "SID_STRING"};
                    String criteriaColumn = "SID_STRING";
                    ArrayList dbValuesList = FcLayoutUtil.getValuesFromTable((String[])tableArray, (String[])requiredColumns, (String)criteriaColumn, (ArrayList)sendAsDelegates);
                    for (int i = 0; i < dbValuesList.size(); ++i) {
                        Properties dbValueProp = (Properties)dbValuesList.get(i);
                        dNList.add(dbValueProp.getProperty("DISTINGUISHED_NAME"));
                    }
                    auditSendAsProps.put("ATTRIB_LDAP_NAME", "sendAs");
                    auditSendAsProps.put("ATTRIB_VALUE_COUNT", new Long(sendAsDelegates.size()));
                    auditSendAsProps.put("DATA_HANDLER_TYPE", new Long(1L));
                    auditSendAsProps.put("DW_CONTROL_CODE", new Long(3L));
                    if (count > 0) {
                        if (count == 1) {
                            auditSendAsProps.put("ATTRIB_VALUE", dNList.get(0));
                            continue;
                        }
                        auditSendAsProps.put("ATTRIB_VALUE", dNList);
                        continue;
                    }
                    sendAsOperation = "delete";
                    auditSendAsProps.put("DW_CONTROL_CODE", new Long(1L));
                    auditSendAsProps.put("ATTRIB_VALUE", "");
                    continue;
                }
                if (selectedAttributes[j].equals("forwardingAddress")) {
                    String forwardingAddressOption = props.getProperty("forwardingAddressOption");
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1245L)) continue;
                    if (forwardingAddressOption.equals("true")) {
                        Properties p2 = new Properties();
                        p2.put("ATTRIB_LDAP_NAME", "altRecipient");
                        p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p2.put("DATA_HANDLER_TYPE", new Long(3L));
                        p2.put("ATTRIB_VALUE", "none");
                        p2.put("DW_CONTROL_CODE", new Long(1L));
                        Properties p1 = new Properties();
                        p1.put("ATTRIB_LDAP_NAME", "deliverAndReDirect");
                        p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p1.put("DATA_HANDLER_TYPE", new Long(6L));
                        p1.put("ATTRIB_VALUE", "false");
                        p1.put("DW_CONTROL_CODE", new Long(1L));
                        setAttributeList.add(p2);
                        setAttributeList.add(p1);
                        continue;
                    }
                    String deliverAndReDirect = (String)props.get("deliverAndReDirect");
                    p = new Properties();
                    p.put("ATTRIB_LDAP_NAME", "altRecipient");
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_VALUE", props.getProperty("forwardingAddressDN"));
                    Properties p1 = new Properties();
                    p1.put("ATTRIB_LDAP_NAME", "deliverAndReDirect");
                    p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p1.put("DATA_HANDLER_TYPE", new Long(6L));
                    p1.put("ATTRIB_VALUE", deliverAndReDirect);
                    setAttributeList.add(p);
                    setAttributeList.add(p1);
                    continue;
                }
                if (!selectedAttributes[j].equals("recipientLimits") || !ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1244L)) continue;
                Properties p3 = new Properties();
                p3.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p3.put("DATA_HANDLER_TYPE", new Long(3L));
                p3.put("ATTRIB_LDAP_NAME", "msExchRecipLimit");
                String defaultRecipientLimits = props.getProperty("defaultRecipientLimits");
                if (defaultRecipientLimits.equals("true")) {
                    p3.put("DW_CONTROL_CODE", new Long(1L));
                    p3.put("ATTRIB_VALUE", "-");
                } else {
                    p3.put("ATTRIB_VALUE", props.getProperty(selectedAttributes[j]));
                }
                setAttributeList.add(p3);
            }
            logger.log(Level.INFO, " MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified") + " : ");
                    }
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                e.printStackTrace();
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
            if (sendAsDelegates != null) {
                try {
                    String errorMsg = "";
                    logger.log(Level.INFO, "modify sendAs permission:" + sendAsDelegates);
                    Hashtable resultProp = this.updateSendAsAttribute(sendAsDelegates, dn, sendAsOperation, domainName, loginId);
                    errorMsg = this.getErrorStringForSendAs(resultProp);
                    if (!errorMsg.equals("")) {
                        if (message.length() != 0) {
                            message = message.append("-");
                        }
                        message = message.append(errorMsg);
                    }
                    setAttributeList.add(auditSendAsProps);
                }
                catch (Exception e) {
                    message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
                }
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.deliv_opts.mgmtname.exchange_delivery_options"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            if (message.length() == 0) {
                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    public Hashtable updateSendAsAttribute(ArrayList SIDList, String dn, String operation, String domainName, Long loginId) {
        ArrayList nativeResult = new ArrayList();
        Hashtable resultSendAs = new Hashtable();
        try {
            ArrayList aceList = new ArrayList();
            Hashtable<String, Object> aceHash = new Hashtable<String, Object>();
            aceHash.put("ACCESS_MASK", 256L);
            aceHash.put("PERMISSION_GUID", "{ab721a54-1e2f-11d0-9819-00aa0040529b}");
            aceHash.put("INHERIT_TYPE_FLAG", new Long(2L));
            aceHash.put("ACE_ID", new Long(1L));
            aceHash.put("ACE_TYPE", 5L);
            aceHash.put("operation", operation);
            aceList.add(aceHash);
            nativeResult = ADHandler.delegateTemplate((String)domainName, (Long)loginId, aceList, (ArrayList)SIDList, (String)dn);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        for (int i = 0; i < nativeResult.size(); ++i) {
            Hashtable resultProp = (Hashtable)nativeResult.get(i);
            resultSendAs.put(SIDList.get(i), resultProp.get(new Long(1L)));
        }
        return resultSendAs;
    }

    public String getErrorStringForSendAs(Hashtable resultHash) {
        String resultString = "";
        ArrayList<String> errorList = new ArrayList<String>();
        Enumeration itr = resultHash.keys();
        while (itr.hasMoreElements()) {
            String sID = (String)itr.nextElement();
            Integer resultCode = Integer.parseInt((String)resultHash.get(sID));
            String errorString = TemplateAction.getErrorCodeString(resultCode);
            if (resultCode == 0) continue;
            if (!errorList.contains(errorString)) {
                errorList.add(errorString);
            }
            logger.log(Level.INFO, "Error while trying to update sendAs Attribute for : " + sID + " - " + this.rb.getString(errorString));
        }
        if (!errorList.isEmpty()) {
            resultString = this.rb.getString("admp.ad_mgmt.create_user.error_send_as");
            for (int i = 0; i < errorList.size(); ++i) {
                resultString = i == 0 ? resultString + this.rb.getString((String)errorList.get(i)) : resultString + ", " + this.rb.getString((String)errorList.get(i));
            }
        }
        return resultString;
    }
}

