/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class DialInListener
extends ModifyUserListener {
    public DialInListener() {
        this.reportId = new Integer(1028);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1050L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String guid = (String)result.get("OBJECT_GUID");
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            String userName = this.getValue(result, 1006);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_LDAP_NAME", "msNPAllowDialin");
            String remoteAccessPermission = (String)props.get("remoteAccessPermission");
            String remoteAccessPermissionAudit = "";
            if (remoteAccessPermission.equalsIgnoreCase("admp.mgmt.user_mgmt.dial-in_props.input.dial_in_allow")) {
                remoteAccessPermission = "TRUE";
                remoteAccessPermissionAudit = this.rb.getString("admp.common.attribvalue.true");
            } else if (remoteAccessPermission.equalsIgnoreCase("admp.mgmt.user_mgmt.dial-in_props.input.dial_in_deny")) {
                remoteAccessPermission = "FALSE";
                remoteAccessPermissionAudit = this.rb.getString("admp.common.attribvalue.false");
            } else {
                p.put("DW_CONTROL_CODE", new Long(1L));
                remoteAccessPermission = "";
                remoteAccessPermissionAudit = this.rb.getString("admp.auditing.uac_apply_remote_policy");
            }
            p.put("ATTRIB_VALUE", remoteAccessPermissionAudit);
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("DATA_HANDLER_TYPE", new Long(3L));
            setAttributeList.add(p);
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + userName + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandler.setDialInProps((String)domainName, (Long)loginId, (String)userName, (String)remoteAccessPermission, (String)dn);
                    ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error"));
                    }
                } else {
                    message.insert(0, MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), new String("")));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.dial-in_props.mgmtname.dial-in_attributes"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message.toString();
    }
}

