/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ExchFeaturesListener
extends ModifyUserListener {
    ArrayList protocolSettings = new ArrayList();
    String[] owaEnable = new String[]{UserMgmtUtil.HTTP_ENABLE, UserMgmtUtil.HTTP_ENABLE_X07, UserMgmtUtil.HTTP_ENABLE_X10, UserMgmtUtil.HTTP_ENABLE_X13, UserMgmtUtil.HTTP_ENABLE_X16};
    String[] owaDisable = new String[]{UserMgmtUtil.HTTP_DISABLE, UserMgmtUtil.HTTP_DISABLE_X07, UserMgmtUtil.HTTP_DISABLE_X10, UserMgmtUtil.HTTP_DISABLE_X13, UserMgmtUtil.HTTP_DISABLE_X16};
    String[] imapEnable = new String[]{UserMgmtUtil.IMAP4_ENABLE, UserMgmtUtil.IMAP4_ENABLE_X07, UserMgmtUtil.IMAP4_ENABLE_X10, UserMgmtUtil.IMAP4_ENABLE_X13, UserMgmtUtil.IMAP4_ENABLE_X13};
    String[] imapDisable = new String[]{UserMgmtUtil.IMAP4_DISABLE, UserMgmtUtil.IMAP4_DISABLE_X07, UserMgmtUtil.IMAP4_DISABLE_X10, UserMgmtUtil.IMAP4_DISABLE_X13, UserMgmtUtil.IMAP4_DISABLE_X16};
    String[] popEnable = new String[]{UserMgmtUtil.POP3_ENABLE, UserMgmtUtil.POP3_ENABLE_X07, UserMgmtUtil.POP3_ENABLE_X10, UserMgmtUtil.POP3_ENABLE_X13, UserMgmtUtil.POP3_ENABLE_X16};
    String[] popDisable = new String[]{UserMgmtUtil.POP3_DISABLE, UserMgmtUtil.POP3_DISABLE_X07, UserMgmtUtil.POP3_DISABLE_X10, UserMgmtUtil.POP3_DISABLE_X13, UserMgmtUtil.POP3_DISABLE_X16};
    String[] mapiEnable = new String[]{UserMgmtUtil.MAPI_ENABLE_X07, UserMgmtUtil.MAPI_ENABLE_X07, UserMgmtUtil.MAPI_ENABLE_X10, UserMgmtUtil.MAPI_ENABLE_X13, UserMgmtUtil.MAPI_ENABLE_X16};
    String[] mapiDisable = new String[]{UserMgmtUtil.MAPI_DISABLE_X07, UserMgmtUtil.MAPI_DISABLE_X07, UserMgmtUtil.MAPI_DISABLE_X10, UserMgmtUtil.MAPI_DISABLE_X13, UserMgmtUtil.MAPI_DISABLE_X16};

    public ExchFeaturesListener() {
        this.reportId = new Integer(1012);
        this.actionIds = new long[]{1251L, 1252L, 1253L, 1254L, 1255L, 1256L};
        this.actions = new String[]{"oma", "http", "imap", "pop", "activeSync", "mapi"};
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        str.append("(&(objectCategory=person)(objectClass=user)(mailnickname=*)(|(homeMDB=*)(msExchHomeServerName=*))");
        if (searchString != null && !searchString.equals("")) {
            StringTokenizer token = new StringTokenizer(searchString, ",");
            str.append("(|");
            while (token.hasMoreTokens()) {
                String s = (String)token.nextElement();
                if (this.searchAttributes != null) {
                    for (int i = 0; i < this.searchAttributes.size(); ++i) {
                        str.append("(" + this.searchAttributes.get(i) + "=*" + s + "*)");
                    }
                }
                str.append("(mailnickname=*" + s + "*)");
            }
            str.append(")");
        }
        str.append(")");
        logger.log(Level.INFO, "searchString in ExchFeaturesListener : " + str);
        return str.toString();
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            ArrayList<Properties> setAttributeList;
            block42: {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1026L})) {
                    return this.rb.getString("client.DomainAction.access_is_denied");
                }
                String[] selectedAttributes = new String[]{"oma", "http", "imap", "pop", "activeSync", "mapi"};
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                String sid = this.getValue(result, 1144);
                String dn = this.getValue(result, 1004);
                Integer mobileflagValue = 0;
                if (!this.getValue(result, 1156).equals("")) {
                    mobileflagValue = Integer.valueOf(this.getValue(result, 1156));
                }
                String homeMDB = this.getValue(result, 1081);
                Integer version = ExchangeUtil.getMailboxStoreType((String)homeMDB, (String)domainName);
                String httpFlag = this.getValue(result, 1146);
                String imapFlag = this.getValue(result, 1147);
                String popFlag = this.getValue(result, 1148);
                String mapiFlag = this.getValue(result, 1157);
                BeanMap props = (BeanMap)bean.get("props");
                setAttributeList = new ArrayList<Properties>();
                String attrValue = "";
                if (!homeMDB.equals("")) {
                    for (int j = 0; j < selectedAttributes.length; ++j) {
                        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, this.getId(selectedAttributes[j]))) continue;
                        String value = props.getProperty(selectedAttributes[j]);
                        if (!value.equalsIgnoreCase("--")) {
                            boolean bool = false;
                            if (value.equalsIgnoreCase("enable")) {
                                bool = true;
                            }
                            if (selectedAttributes[j].equals("oma") && version == 2003) {
                                mobileflagValue = bool ? Integer.valueOf(mobileflagValue & 5) : Integer.valueOf(mobileflagValue | 2);
                                attrValue = Integer.toString(mobileflagValue);
                            }
                            if (selectedAttributes[j].equals("activeSync")) {
                                if (version >= 2007) {
                                    mobileflagValue = bool ? Integer.valueOf(0) : Integer.valueOf(4);
                                } else {
                                    mobileflagValue = bool ? Integer.valueOf(mobileflagValue & 3) : Integer.valueOf(mobileflagValue | 4);
                                    if (mobileflagValue == 4) {
                                        mobileflagValue = 5;
                                    } else if (mobileflagValue == 6) {
                                        mobileflagValue = 7;
                                    }
                                }
                                attrValue = Integer.toString(mobileflagValue);
                                continue;
                            }
                            if (selectedAttributes[j].equals("http")) {
                                if (bool) {
                                    this.getValue(version, this.owaEnable);
                                    continue;
                                }
                                this.getValue(version, this.owaDisable);
                                continue;
                            }
                            if (selectedAttributes[j].equals("imap")) {
                                if (bool) {
                                    this.getValue(version, this.imapEnable);
                                    continue;
                                }
                                this.getValue(version, this.imapDisable);
                                continue;
                            }
                            if (selectedAttributes[j].equals("pop")) {
                                if (bool) {
                                    this.getValue(version, this.popEnable);
                                    continue;
                                }
                                this.getValue(version, this.popDisable);
                                continue;
                            }
                            if (version <= 2003 || !selectedAttributes[j].equals("mapi")) continue;
                            if (bool) {
                                this.getValue(version, this.mapiEnable);
                                continue;
                            }
                            this.getValue(version, this.mapiDisable);
                            continue;
                        }
                        if (selectedAttributes[j].equals("http")) {
                            if (httpFlag.equalsIgnoreCase(this.rb.getString("admp.reports.user.customized_column_values.Enabled")) || httpFlag.equals("")) {
                                this.getValue(version, this.owaEnable);
                                continue;
                            }
                            this.getValue(version, this.owaDisable);
                            continue;
                        }
                        if (selectedAttributes[j].equals("imap")) {
                            if (imapFlag.equalsIgnoreCase(this.rb.getString("admp.reports.user.customized_column_values.Enabled")) || imapFlag.equals("")) {
                                this.getValue(version, this.imapEnable);
                                continue;
                            }
                            this.getValue(version, this.imapDisable);
                            continue;
                        }
                        if (selectedAttributes[j].equals("pop")) {
                            if (popFlag.equalsIgnoreCase(this.rb.getString("admp.reports.user.customized_column_values.Enabled")) || popFlag.equals("")) {
                                this.getValue(version, this.popEnable);
                                continue;
                            }
                            this.getValue(version, this.popDisable);
                            continue;
                        }
                        if (version <= 2003 || !selectedAttributes[j].equals("mapi")) continue;
                        if (mapiFlag.equalsIgnoreCase(this.rb.getString("admp.reports.user.customized_column_values.Enabled")) || mapiFlag.equals("")) {
                            this.getValue(version, this.mapiEnable);
                            continue;
                        }
                        this.getValue(version, this.mapiDisable);
                    }
                    if (!attrValue.equals("")) {
                        Properties p = new Properties();
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("DATA_HANDLER_TYPE", new Long(7L));
                        p.put("ATTRIB_VALUE", attrValue);
                        p.put("ATTRIB_LDAP_NAME", "msExchOmaAdminWirelessEnable");
                        setAttributeList.add(p);
                    }
                    if (this.protocolSettings.size() > 0) {
                        Properties p = new Properties();
                        p.put("ATTRIB_VALUE_COUNT", new Long(this.protocolSettings.size()));
                        p.put("DATA_HANDLER_TYPE", new Long(3L));
                        if (this.protocolSettings.size() == 1) {
                            p.put("ATTRIB_VALUE", this.protocolSettings.get(0));
                        } else {
                            p.put("ATTRIB_VALUE", this.protocolSettings);
                        }
                        p.put("ATTRIB_LDAP_NAME", "protocolSettings");
                        setAttributeList.add(p);
                    }
                    logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
                    try {
                        if (setAttributeList.size() != 0) {
                            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                            if (message.length() == 0) {
                                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                            } else {
                                message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                            }
                            break block42;
                        }
                        message.insert(0, this.rb.getString("usermanagement.messages.unable_modify_user") + " : ");
                    }
                    catch (LocalizedException le) {
                        message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
                    }
                    catch (Exception e) {
                        message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
                    }
                } else {
                    message.append(this.rb.getString("admp.mgmt.user_mgmt.exchange_features.statmsg_select_valid_recipient"));
                }
            }
            if (message.length() == 0) {
                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.exch_features.mgmtname.exchange_features_attributes"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            if (this.protocolSettings.size() > 0) {
                this.protocolSettings.clear();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    public void getValue(Integer version, String[] arrValues) {
        if (version == 2016) {
            this.protocolSettings.add(arrValues[4]);
        } else if (version == 2013) {
            this.protocolSettings.add(arrValues[3]);
        } else if (version == 2010) {
            this.protocolSettings.add(arrValues[2]);
        } else if (version == 2007) {
            this.protocolSettings.add(arrValues[1]);
        } else {
            this.protocolSettings.add(arrValues[0]);
        }
    }
}

