/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class ExchPoliciesListener
extends ModifyUserListener {
    public ExchPoliciesListener() {
        this.reportId = new Integer(1037);
        this.actionIds = new long[]{1315L, 1316L, 1317L, 1318L, 1319L};
        this.actions = new String[]{"sharing", "roles", "retension", "umpolicy", "activeSyncPolicy"};
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        String mailBoxServer = null;
        boolean usePowerShell = false;
        String attrValue = "";
        StringBuffer message = new StringBuffer();
        String psResult = "";
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1083L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            String[] selectedAttributes = new String[]{"sharing", "roles", "retension", "activeSyncPolicy"};
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p = new Properties();
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, this.getId(selectedAttributes[j])) || (attrValue = props.getProperty(selectedAttributes[j])).equalsIgnoreCase("--")) continue;
                if (selectedAttributes[j].equals("sharing")) {
                    p.put("ATTRIB_VALUE", attrValue);
                    p.put("ATTRIB_LDAP_NAME", "msExchSharingPolicyLink");
                } else if (selectedAttributes[j].equals("roles")) {
                    p.put("ATTRIB_VALUE", attrValue);
                    p.put("ATTRIB_LDAP_NAME", "msExchRBACPolicyLink");
                } else if (selectedAttributes[j].equals("retension")) {
                    p.put("ATTRIB_VALUE", attrValue);
                    p.put("ATTRIB_LDAP_NAME", "msExchMailboxTemplateLink");
                } else if (selectedAttributes[j].equals("activeSyncPolicy")) {
                    p.put("ATTRIB_VALUE", attrValue);
                    p.put("ATTRIB_LDAP_NAME", "msExchMobileMailboxPolicyLink");
                }
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                setAttributeList.add(p);
            }
            mailBoxServer = this.getValue(result, 1101);
            usePowerShell = ExchangeUtil.checkExchange2007((String)mailBoxServer);
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (usePowerShell) {
                    int index;
                    if (setAttributeList.size() != 0) {
                        ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                        if (message.length() != 0) {
                            message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                        } else {
                            message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                        }
                    }
                    if ((index = mailBoxServer.lastIndexOf("cn=")) != -1 && mailBoxServer.trim().length() > index + 3) {
                        Properties exchangeServerDetails = null;
                        String exchangeServerName = mailBoxServer.substring(index + 3);
                        exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailBoxServer);
                        attrValue = props.getProperty("retension");
                        if (!(attrValue.equalsIgnoreCase("--") || attrValue.equals("") || (psResult = ADHandler.applyRetentionPolicy((String)domainName, (long)loginId, (String)exchangeServerName, (String)dn, (String)attrValue, (Properties)exchangeServerDetails)).equals(""))) {
                            message.append(this.rb.getString("admp.management.usermanagement.exch_policies.err_msg.applies_retention"));
                            message.append(this.rb.getString(psResult));
                        }
                        if (!(attrValue = props.getProperty("umpolicy")).equalsIgnoreCase("--") && !attrValue.equals("")) {
                            String SIPResourceIdentifier = "";
                            String pin = props.getProperty("password");
                            String extension = props.getProperty("extension");
                            String resetPin = props.getProperty("resetPinval");
                            String sipAddress = props.getProperty("sip");
                            String eumAddress = props.getProperty("umeAddr");
                            String policyName = props.getProperty("policy_umpolicy");
                            Properties p = new Properties();
                            p.put("ATTRIB_VALUE", policyName);
                            p.put("ATTRIB_LDAP_NAME", "msExchUMMailBoxPolicy");
                            setAttributeList.add(p);
                            String uriType = props.getProperty("urivalue");
                            if (!uriType.equals("0") && !uriType.equals("1")) {
                                if (uriType.equals("2")) {
                                    SIPResourceIdentifier = eumAddress;
                                } else if (uriType.equals("3")) {
                                    SIPResourceIdentifier = sipAddress;
                                }
                            }
                            resetPin = resetPin.equalsIgnoreCase("on") ? "$true" : "$false";
                            psResult = ADHandler.enableUMMailbox((String)domainName, (long)loginId, (String)exchangeServerName, (String)dn, (String)policyName, (String)extension, (String)pin, (String)resetPin, (String)SIPResourceIdentifier, (Properties)exchangeServerDetails);
                            if (!psResult.equals("")) {
                                message.append(this.rb.getString("admp.management.usermanagement.exch_policies.err_msg.applies_umpolicy"));
                                message.append(this.rb.getString(psResult));
                            }
                        }
                    }
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    }
                } else {
                    message.append(this.rb.getString("admp.mgmt.user_mgmt.exchange_features.statmsg_select_valid_recipient"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
            if (message.length() == 0) {
                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.exch_features.mgmtname.exchange_policies_attributes"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

