/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ExtendedAttributesUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set getDistinctMembersList(String columnName) {
        TreeSet<String> set = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            String ADSMExtendedAttributeDetails = "ADSMExtendedAttributeDetails";
            Table aDSMExtendedAttributeDetails = Table.getTable((String)ADSMExtendedAttributeDetails);
            SelectQueryImpl query = new SelectQueryImpl(aDSMExtendedAttributeDetails);
            Column column = Column.getColumn((String)ADSMExtendedAttributeDetails, (String)columnName);
            query.addSelectColumn(column);
            query.setDistinct(true);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                set.add(dataSet.getValue(columnName).toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ArrayList getIdsList(String columnName, String ldapName, ArrayList resultColumns) {
        ArrayList<Object> list = new ArrayList<Object>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            int i;
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            String ADSMExtendedAttributeDetails = "ADSMExtendedAttributeDetails";
            Table aDSMExtendedAttributeDetails = Table.getTable((String)ADSMExtendedAttributeDetails);
            SelectQueryImpl query = new SelectQueryImpl(aDSMExtendedAttributeDetails);
            Criteria criteria = new Criteria(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)columnName), (Object)ldapName, 0);
            for (i = 0; i < resultColumns.size(); ++i) {
                query.addSelectColumn(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)resultColumns.get(i).toString()));
            }
            query.setCriteria(criteria);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                for (i = 0; i < resultColumns.size(); ++i) {
                    list.add(dataSet.getValue(resultColumns.get(i).toString()));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return list;
    }

    public static boolean isAuthorized(HttpServletRequest request, String ldapName, String columnName, String domainName) {
        ArrayList<String> resultColumns = new ArrayList<String>();
        resultColumns.add(columnName);
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList authorizedIdsList = authObject.getActionList(domainName);
        ArrayList idsList = ExtendedAttributesUtil.getIdsList("ATTRIB_LDAP_NAME", ldapName, resultColumns);
        for (int i = 0; i < idsList.size(); ++i) {
            if (!authorizedIdsList.contains(idsList.get(i))) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAuthorizedValue(ArrayList authorizedIdsList, String columnValueName, int value, String columnId) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            String ADSMExtendedAttributeDetails = "ADSMExtendedAttributeDetails";
            Table aDSMExtendedAttributeDetails = Table.getTable((String)ADSMExtendedAttributeDetails);
            SelectQueryImpl query = new SelectQueryImpl(aDSMExtendedAttributeDetails);
            Criteria criteria = new Criteria(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)"ATTRIB_COLUMN_NAME"), (Object)columnValueName, 0);
            query.addSelectColumn(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)"ATTRIB_VALUE"));
            query.addSelectColumn(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)columnId));
            query.setCriteria(criteria);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                Long id = Long.valueOf(dataSet.getValue(columnId).toString());
                int tValue = Integer.parseInt(dataSet.getValue("ATTRIB_VALUE").toString());
                if (ExtendedAttributesUtil.isAuthorizedValue(authorizedIdsList, tValue, value, id)) continue;
                boolean bl = false;
                DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
                return bl;
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
        return true;
    }

    private static boolean isAuthorizedValue(ArrayList authorizedIdsList, int tValue, int uValue, Long id) {
        if ((tValue & uValue) == tValue && !authorizedIdsList.contains(id)) {
            System.out.println("Unauthorized value - " + uValue + ",while accessing the id : " + id);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isAuthorizedValue(HttpServletRequest request, String ldapName, Object objValue, String columnName, String domainName) {
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList authorizedIdsList = authObject.getActionList(domainName);
        Connection connection = null;
        DataSet dataSet = null;
        try {
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            String ADSMExtendedAttributeDetails = "ADSMExtendedAttributeDetails";
            Table aDSMExtendedAttributeDetails = Table.getTable((String)ADSMExtendedAttributeDetails);
            SelectQueryImpl query = new SelectQueryImpl(aDSMExtendedAttributeDetails);
            Criteria criteria = new Criteria(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)"ATTRIB_LDAP_NAME"), (Object)ldapName, 0);
            query.addSelectColumn(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)columnName));
            query.addSelectColumn(Column.getColumn((String)ADSMExtendedAttributeDetails, (String)"ATTRIB_VALUE"));
            query.setCriteria(criteria);
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                Long id = Long.valueOf(dataSet.getValue(columnName).toString());
                int tValue = Integer.parseInt(dataSet.getValue("ATTRIB_VALUE").toString());
                String[] UACSplit = objValue.toString().split(";");
                if (UACSplit.length > 1) {
                    if (!UACSplit[0].equals("") && !ExtendedAttributesUtil.isAuthorizedValue(authorizedIdsList, tValue, Integer.parseInt(UACSplit[0]), id)) {
                        boolean bl = false;
                        DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
                        return bl;
                    }
                    if (UACSplit[1].equals("") || ExtendedAttributesUtil.isAuthorizedValue(authorizedIdsList, tValue, Integer.parseInt(UACSplit[1]), id)) continue;
                    boolean bl = false;
                    DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
                    return bl;
                }
                if (objValue.toString().equals("") || ExtendedAttributesUtil.isAuthorizedValue(authorizedIdsList, tValue, Integer.parseInt(objValue.toString()), id)) continue;
                boolean bl = false;
                DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
                return bl;
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, (Connection)connection);
        }
    }
}

