/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LCSServerHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.LyncServerHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.framework.EscapeUtil;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class LyncMgmtListener
extends ModifyUserListener {
    public LyncMgmtListener() {
        this.reportId = new Integer(1034);
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        BeanMap props = (BeanMap)bean.get("props");
        String accountEnableDisable = props.getProperty("accountEnableDisable");
        StringBuffer str = new StringBuffer();
        str.append("(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))");
        if (accountEnableDisable.equals("Disable")) {
            str.append("(msRTCSIP-UserEnabled=TRUE)");
        }
        if (accountEnableDisable.equals("Enable")) {
            str.append("(!(msRTCSIP-UserEnabled=TRUE))");
        }
        if (accountEnableDisable.equals("Delete")) {
            str.append("(|(msRTCSIP-UserEnabled=TRUE)(msRTCSIP-UserEnabled=FALSE))");
        }
        if (searchString != null && !searchString.equals("")) {
            this.getSearchString(searchString, str);
        }
        str.append(")");
        logger.log(Level.INFO, "searchString in Lync Users : " + str);
        return str.toString();
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{5318L})) {
                return this.rb.getString("client.DomainAction.access_is_denied");
            }
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            BeanMap props = (BeanMap)bean.get("props");
            String accountEnableDisable = props.getProperty("accountEnableDisable");
            String spi_uri_format = props.getProperty("SPI_URI_FORMAT");
            String serverNameValue = props.getProperty("serverNameValue");
            String enableLCS = this.getValue(result, 1180);
            String value = FormatClientUtil.getFormatValue(spi_uri_format, result, domainName, "");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            Properties p = new Properties();
            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p.put("ATTRIB_COLUMN_NAME", "LCS_ENABLED");
            p.put("DW_CONTROL_CODE", new Long(2L));
            p.put("ATTRIB_LDAP_NAME", "msRTCSIP-UserEnabled");
            p.put("DATA_HANDLER_TYPE", new Long(3L));
            if (value.toLowerCase().equals("sip:") && accountEnableDisable.equals("Enable") && enableLCS.equalsIgnoreCase("")) {
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.enab_dis_lync_users.alert.no_email_available"));
                TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.usermanagement.createlync.createlyncUsers"), EscapeUtil.escSplCharsAsHTML((Object)this.getValue(result, 1010)), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                return message.toString();
            }
            if (accountEnableDisable.equals("Enable")) {
                p.put("ATTRIB_VALUE", "TRUE");
                Properties sipProp = new Properties();
                sipProp.put("ATTRIB_VALUE_COUNT", new Long(1L));
                sipProp.put("DW_CONTROL_CODE", new Long(2L));
                sipProp.put("ATTRIB_COLUMN_NAME", "LCS_SIP_URI");
                sipProp.put("ATTRIB_LDAP_NAME", "msRTCSIP-PrimaryUserAddress");
                sipProp.put("DATA_HANDLER_TYPE", new Long(3L));
                sipProp.put("ATTRIB_VALUE", value);
                setAttributeList.add(sipProp);
                Properties serverProp = new Properties();
                serverProp.put("ATTRIB_VALUE_COUNT", new Long(1L));
                serverProp.put("DW_CONTROL_CODE", new Long(2L));
                serverProp.put("ATTRIB_COLUMN_NAME", "LCS_SERVER");
                serverProp.put("ATTRIB_LDAP_NAME", "msRTCSIP-PrimaryHomeServer");
                serverProp.put("DATA_HANDLER_TYPE", new Long(3L));
                serverProp.put("ATTRIB_VALUE", serverNameValue);
                setAttributeList.add(serverProp);
                if (LCSServerHandler.isOcsServer((String)serverNameValue)) {
                    Properties ocsProp = new Properties();
                    ocsProp.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    ocsProp.put("DW_CONTROL_CODE", new Long(2L));
                    ocsProp.put("ATTRIB_COLUMN_NAME", "LCS_OPTION_FLAG");
                    ocsProp.put("ATTRIB_LDAP_NAME", "msRTCSIP-OptionFlags");
                    ocsProp.put("DATA_HANDLER_TYPE", new Long(7L));
                    ocsProp.put("ATTRIB_VALUE", new String("256"));
                    setAttributeList.add(ocsProp);
                    attributeList.add("msRTCSIP-OptionFlags");
                }
            } else if (accountEnableDisable.equals("Disable")) {
                p.put("ATTRIB_VALUE", "FALSE");
            } else {
                p.put("ATTRIB_VALUE", "-");
            }
            setAttributeList.add(p);
            String distinguishedName = this.getValue(result, 1005);
            String operation = "";
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " SIP Address : " + value);
            try {
                String error = "";
                String serverName = "";
                if (accountEnableDisable.equals("Disable") || accountEnableDisable.equals("Delete")) {
                    if (!value.startsWith("sip:") && !value.startsWith("SIP:")) {
                        value = "sip:" + value;
                    }
                    String pool = this.getValue(result, 1183);
                    Criteria crit = new Criteria(Column.getColumn((String)"ADSMLCSServers", (String)"SERVER_DISTINGUISHED_NAME"), (Object)pool, 0);
                    DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMLCSServers", crit);
                    if (!dataObject.isEmpty()) {
                        Row r = dataObject.getRow("ADSMLCSServers");
                        serverNameValue = serverName = (String)r.get("DNS_HOST_NAME");
                    }
                }
                if (accountEnableDisable.equals("Enable") && LyncServerHandler.isLyncServer((String)serverNameValue).booleanValue() || (accountEnableDisable.equals("Disable") || accountEnableDisable.equals("Delete")) && LyncServerHandler.isLyncServer((String)serverName).booleanValue()) {
                    if (distinguishedName != null && serverNameValue != null && value != null) {
                        String nativeDCFQDN = null;
                        nativeDCFQDN = !CommonUtil.isSiteBasedDCSelectionEnabled() ? this.getDcFqdn() : this.getOUBasedDcFqdn(StrUtil.getContainerDNFromDN((String)dn), loginId, domainName);
                        error = ADHandlerForMgmt.modifyLyncUser((String)distinguishedName, (String)serverNameValue, (String)value, (String)domainName, (Long)loginId, (String)nativeDCFQDN, (String)accountEnableDisable, (String)enableLCS);
                    }
                    if (error.equals("")) {
                        ADHandlerForMgmt.updateUserProperties((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)listener);
                        message.append(this.rb.getString("admp.mgmt.common.text.successfully_modified"));
                    }
                    if (!error.equals("")) {
                        message.append(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_user"));
                        message.append(". ");
                        message.append(this.rb.getString(error));
                    }
                } else if (!(setAttributeList.size() == 0 || accountEnableDisable.equals("Disable") && enableLCS.equals(""))) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.text.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error") + ":  ");
                    }
                } else {
                    message.append(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_user"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.modify_lync_policy.statmsg.unable_to_modify_the_user") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.usermanagement.createlync.createlyncUsers"), EscapeUtil.escSplCharsAsHTML((Object)this.getValue(result, 1010)), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setValidDC(String domainName, Long loginId) {
        this.dcFqdn = DomainUtil.getValidDC((String)domainName, (Long)loginId);
    }
}

