/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class MailboxRightsListener
extends ModifyUserListener {
    public MailboxRightsListener() {
        this.reportId = new Integer(1029);
    }

    @Override
    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        str.append("(&(objectCategory=person)(objectClass=user)(mailnickname=*)(|(homeMDB=*)(msExchHomeServerName=*))");
        if (searchString != null && !searchString.equals("")) {
            StringTokenizer token = new StringTokenizer(searchString, ",");
            str.append("(|");
            while (token.hasMoreTokens()) {
                String s = (String)token.nextElement();
                if (this.searchAttributes != null) {
                    for (int i = 0; i < this.searchAttributes.size(); ++i) {
                        str.append("(" + this.searchAttributes.get(i) + "=*" + s + "*)");
                    }
                }
                str.append("(mailnickname=*" + s + "*)");
            }
            str.append(")");
        }
        str.append(")");
        logger.log(Level.INFO, "searchString in MailboxRightsListener : " + str);
        return str.toString();
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        try {
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1059L})) {
                return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
            }
            String selfSID = this.getValue(result, 1144);
            String distinguishedName = this.getValue(result, 1004);
            String mailServer = this.getValue(result, 1101);
            BeanMap props = (BeanMap)bean.get("props");
            try {
                if (mailServer == null || mailServer.equalsIgnoreCase("")) {
                    throw new Exception(this.rb.getString("admp.mgmt.user_mgmt.mailbox_rights.statmsg.no_mailbox_exists"));
                }
                boolean usePowershell = ExchangeUtil.checkExchange2007((String)mailServer);
                ArrayList mbrRights = (ArrayList)props.get("MBR_ACL");
                ArrayList<Properties> mbrRightsTemp = new ArrayList<Properties>();
                if (mbrRights != null && !mbrRights.isEmpty()) {
                    for (Object object : mbrRights) {
                        Properties properties = (Properties)object;
                        Properties tempProp = (Properties)properties.clone();
                        String objectDN = properties.getProperty("DN");
                        String objectSID = properties.getProperty("SID");
                        if (objectDN.equalsIgnoreCase("%userName%")) {
                            if (!usePowershell) {
                                tempProp.put("DN", CommonUtil.escapeDN((String)distinguishedName));
                            } else {
                                tempProp.put("DN", "S-1-5-10");
                                tempProp.put("OBJECT_NAME", "S-1-5-10");
                            }
                        } else if (!usePowershell) {
                            tempProp.put("DN", CommonUtil.escapeDN((String)objectDN));
                        } else {
                            tempProp.put("DN", objectSID);
                        }
                        mbrRightsTemp.add(tempProp);
                    }
                } else {
                    throw new Exception(this.rb.getString("admp.mgmt.user_mgmt.mailbox_rights.statmsg.no_permissions_available"));
                }
                logger.log(Level.INFO, "Setting Mailbox Rights for :" + distinguishedName + " & Rights : " + mbrRightsTemp);
                if (!usePowershell) {
                    ADHandler.setMailBoxRights((String)domainName, (Long)loginId, mbrRightsTemp, (String)distinguishedName);
                } else {
                    Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                    String statMessage = ADHandler.setMailBoxRights2007((String)domainName, (Long)loginId, mbrRightsTemp, (String)distinguishedName, (Properties)exchangeServerDetails);
                    message.append(this.rb.getString(statMessage));
                }
                if (message.length() == 0) {
                    message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.common.statmsg.error_occured"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.mailbox_rights.mgmtname.mailbox_rights"), this.getValue(result, 1006), domainName, new ArrayList(), new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

