/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.BulkModificationAPI;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.File;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ModifyAction
extends DispatchAction {
    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();

    public ActionForward updateUIChanges(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String domainName = request.getParameter("domainName");
        ReportBean bean = (ReportBean)form;
        System.out.println("Domain Name " + domainName + " " + bean.get("reportId"));
        if (ClientAuthorizationUtil.isAuthorized(request, domainName, (Integer)bean.get("reportId"), "DENY_CSVIMPORT_ID")) {
            ClientUtil.setStatusXMLElement(response, "Success", "true");
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", "false");
        }
        BulkModificationAPI.initBeanProps(bean);
        return null;
    }

    public ActionForward execuateNextManagement(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        String tile = "mainPage";
        ReportBean bean = (ReportBean)form;
        Integer reportId = (Integer)bean.get("reportId");
        if (request.getParameter("reportId") != null) {
            reportId = Integer.parseInt(request.getParameter("reportId"));
            bean.set("reportId", reportId);
        }
        String operation = request.getParameter("operation");
        String inputSource = (String)bean.get("inputSource");
        System.out.println("Next management action starts for the reportId " + reportId + inputSource);
        try {
            if (inputSource.equalsIgnoreCase("csv")) {
                System.out.println("Execuate next management from csvImport");
                String oldGenerationIdStr = request.getParameter("oldGenerationId");
                Long oldGenerationId = Long.parseLong(oldGenerationIdStr);
                BulkModificationAPI.setValues(request, bean);
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                listener.initAttributeLists(bean);
                ArrayList<Hashtable> attributelist = new ArrayList<Hashtable>();
                listener.nextMgmtActionByCsv(request, bean, oldGenerationId);
                Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", bean.get("keyLdapName"));
                attributelist.add(attributesdetails);
                ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(listener.getGenerationId(), attributelist, -1, 0, null, null);
                request.setAttribute("count", (Object)new Long(AddUserHandler.getInstance().getCount(listener.getGenerationId()).intValue()));
                inputSource = "csv";
                request.setAttribute("result", (Object)userDetailsList);
                request.setAttribute("operation", (Object)"showList");
            } else {
                System.out.println("Execuate next management from bulkmodificiation");
                String oldResultTableName = request.getParameter("oldResultTableName");
                String oldGenerationIdStr = request.getParameter("oldGenerationId");
                Long oldGenerationId = Long.parseLong(oldGenerationIdStr);
                BulkModificationAPI.setDomainList(request, form);
                BulkModificationAPI.setValues(request, bean);
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                Criteria filterCriteria = BulkModificationAPI.getFilterCriter(request, oldResultTableName);
                listener.nextMgmtAction(bean, oldResultTableName, oldGenerationId, filterCriteria);
                ArrayList attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId);
                ReportResultUtil.getSearchResultRowsCount(request, bean, listener.getGenerationId(), attributelist);
                if (!inputSource.equalsIgnoreCase("reports")) {
                    inputSource = "management";
                }
                request.setAttribute("operation", (Object)operation);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            inputSource = "";
            request.setAttribute("modifyErrorMessage", (Object)e.getMessage());
        }
        tile = (String)bean.get("tile");
        bean.set("inputSource", inputSource);
        bean.set("beanName", "ModifyUserBean");
        return mapping.findForward(tile);
    }

    public ActionForward moveFromReportMoreActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long newGenerationId = -1L;
        PrintWriter writer = null;
        JSONObject jsonObj = new JSONObject();
        try {
            System.out.println("Modify Action starts");
            writer = response.getWriter();
            ReportBean bean = (ReportBean)form;
            BulkModificationAPI.setArrayValues(request, bean);
            BulkModificationAPI.setValues(request, bean);
            Integer oldReportId = Integer.parseInt(request.getParameter("oldReportId"));
            String oldResultTableName = request.getParameter("oldResultTableName");
            String oldGenerationIdStr = request.getParameter("oldGenerationId");
            String domainDNSName = request.getParameter("domainDNS");
            if (domainDNSName != null && !domainDNSName.equals("")) {
                String[] domains = new String[]{domainDNSName};
                bean.set("domains", domains);
            }
            Long oldGenerationId = Long.parseLong(oldGenerationIdStr);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String description = "Reports to mgmt action by Moreaction from report :" + oldReportId + " to mgmtAction : " + listener.getReportId() + " for the domain " + domainDNSName;
            listener.reportAction(request, oldResultTableName, oldGenerationId, description, false);
            newGenerationId = listener.getGenerationId();
            jsonObj.put("generationId", (Object)newGenerationId);
            jsonObj.put("status", true);
        }
        catch (Exception e) {
            try {
                jsonObj.put("status", false);
                jsonObj.put("modifyErrorMessage", (Object)e.getMessage());
            }
            catch (JSONException e1) {
                e1.printStackTrace();
            }
        }
        response.setContentType("application/json");
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward reportAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "mainPage";
        Object forward = null;
        String path = "";
        ReportBean bean = (ReportBean)form;
        try {
            System.out.println("Modify Action starts");
            HttpSession session = request.getSession();
            BulkModificationAPI.setArrayValues(request, bean);
            Integer reportId = (Integer)bean.get("reportId");
            Long actionId = 0L;
            Criteria criteria = new Criteria(new Column("ADSMReports", "REPORT_ID"), (Object)reportId, 0);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", criteria);
            if (!dataobj.isEmpty()) {
                Row r = dataobj.getFirstRow("ADSMReports");
                actionId = (Long)r.get("ACTION_ID");
            }
            BulkModificationAPI.initBeanDatas(bean);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
            bean.set("domainList", domainList);
            String domainDNSName = request.getParameter("domainName");
            if (domainDNSName != null && !domainDNSName.equals("")) {
                String[] domains = new String[]{domainDNSName};
                bean.set("domains", domains);
            }
            BulkModificationAPI.setValues(request, bean);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            if (request.getParameter("generationId") != null) {
                Long generationID = Long.parseLong(request.getParameter("generationId"));
                listener.setGenerationId(generationID);
            }
            if (request.getParameter("oldResultTableName") != null) {
                String oldResultTableName = request.getParameter("oldResultTableName");
                String oldGenerationIdStr = request.getParameter("oldGenerationId");
                Long oldGenerationId = Long.parseLong(oldGenerationIdStr);
                String description = "Home tab to mgmt action : " + listener.getReportId();
                System.out.println("Home to mgmt " + oldGenerationId + " oldResult " + oldResultTableName);
                listener.reportAction(request, oldResultTableName, oldGenerationId, description, true);
            }
            System.out.println("ReportAction new Generationid " + listener.getGenerationId());
            BulkModificationAPI.search(bean, request, response);
            boolean sidSelectionStatus = false;
            if (request.getParameter("sidSelectionStatus") != null) {
                sidSelectionStatus = Boolean.parseBoolean(request.getParameter("sidSelectionStatus"));
            }
            request.setAttribute("sidSelectionStatus", (Object)sidSelectionStatus);
            System.out.println("sidSelectionStatus " + sidSelectionStatus + " from request " + request.getParameter("sidSelectionStatus"));
            tile = (String)bean.get("tile");
            bean.set("inputSource", "reports");
            bean.set("beanName", "ModifyUserBean");
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("modifyErrorMessage", (Object)e.getMessage());
            tile = (String)bean.get("tile");
        }
        return mapping.findForward(tile);
    }

    public ActionForward initBeanSIDs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute("ModifyUserBean"));
            String checkAllUsers = request.getParameter("checkAllUsers");
            bean.set("selectedSIDs", new ArrayList());
            bean.set("deSelectedSIDs", new ArrayList());
            bean.set("searchSIDs", new ArrayList());
            bean.set("checkAllUsers", checkAllUsers);
            String checkAllUsers1 = (String)bean.get("checkAllUsers");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward modifyAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "mainPage";
        try {
            ReportBean bean = (ReportBean)form;
            String action = request.getParameter("action");
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            if (action != null && action.equals("createRequest")) {
                if (listener != null) {
                    WorkFlowClientUtil.setCheckboxSIDtoBean(request, bean);
                    listener.createRequest(request, bean);
                }
                tile = "createRequestResultDiv";
                return mapping.findForward(tile);
            }
            BulkModificationAPI.setArrayValues(request, bean);
            String operation = request.getParameter("operation");
            if (operation != null && !operation.equalsIgnoreCase("")) {
                BulkModificationAPI.checkReportIDChanges(bean, request);
                String actionLink = request.getParameter("actionLink");
                if (actionLink != null && actionLink.equalsIgnoreCase("back")) {
                    BulkModificationAPI.initBeanDatas(bean);
                    BulkModificationAPI.resetResultTable(bean);
                    if (listener != null) {
                        listener.setRb(ResourceBundleMgr.getInstance().getBundle(request));
                    }
                    bean.set("inputSource", "");
                }
                BulkModificationAPI.doAction(mapping, form, request, response);
            } else {
                BulkModificationAPI.setValues(request, bean);
                bean.set("beanName", "ModifyUserBean");
                bean.set("inputSource", "");
            }
            if (!bean.get("tile").equals("")) {
                tile = (String)bean.get("tile");
            }
            request.setAttribute("beanName", bean.get("beanName"));
            if (bean.get("reportId") != null) {
                BulkModificationAPI.setDomainList(request, form);
                if (request.getAttribute("actionId") != null && !ClientAuthorizationUtil.isAuthorized(request, (Long)request.getAttribute("actionId")).booleanValue()) {
                    return null;
                }
            }
            BulkModificationAPI.setLegacyExchExists(request, form);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new ActionForward("/404Error.do");
        }
        return mapping.findForward(tile);
    }

    public ActionForward csvHandle(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "mainPage";
        try {
            String operation;
            this.rb = ResourceBundleMgr.getInstance().getBundle(request);
            ReportBean bean = (ReportBean)form;
            BulkModificationAPI.checkReportIDChanges(bean, request);
            BulkModificationAPI.setArrayValues(request, bean);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            if (request.getParameter("resetValues") != null) {
                listener.checkBoxes(request, bean);
            }
            if ((operation = request.getParameter("operation")) == null) {
                operation = "showList";
            }
            String[] domains = (String[])bean.get("domains");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String defaultNamingContext = domains[0];
            String domainName = (String)dnDomainNameMap.get(defaultNamingContext);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer reportId = (Integer)bean.get("reportId");
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String reportName = (String)r.get("REPORT_NAME");
            session.setAttribute("domainName", (Object)domainName);
            if (operation.equalsIgnoreCase("import")) {
                BulkModificationAPI.initBeanDatas(bean);
                if (ClientAuthorizationUtil.isAuthorized(request, domainName, reportId, "DENY_CSVIMPORT_ID")) {
                    if (BulkModificationAPI.csvImport(bean, request).booleanValue()) {
                        listener.initAttributeLists(bean);
                        listener.setCSVRows(request, bean, "showList");
                        if (request.getAttribute("result") != null) {
                            if (((ArrayList)request.getAttribute("result")).isEmpty()) {
                                request.setAttribute("importErrorMessage", (Object)this.rb.getString("admp.mgmt.csv_import.common.statmsg.provided_ldap_attrib_not_match_with_object_ldap_names_try_Using_keyldap"));
                            } else {
                                Long count = (Long)request.getAttribute("count");
                                if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                                    String fileName = (String)request.getAttribute("fileName");
                                    DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.common.text.mgmt", (String)reportName, (Integer)reportId, (String)"-", (Boolean)Boolean.TRUE, (String)fileName, (String)"csv", (String)"-", (Integer)count.intValue());
                                }
                            }
                        }
                    } else {
                        request.setAttribute("result", new ArrayList());
                    }
                } else {
                    System.out.println("CSV Import auth check is false for the reportid " + bean.get("reportId") + "So setting error message");
                    request.setAttribute("result", new ArrayList());
                    request.setAttribute("importErrorMessage", (Object)this.rb.getString("admp.mgmt.common.statmsg.deny_csvimport_msg"));
                }
                bean.set("inputSource", "csv");
            } else if (operation.equalsIgnoreCase("showList")) {
                String actionLink = request.getParameter("actionLink");
                if (actionLink != null && actionLink.equalsIgnoreCase("back")) {
                    BulkModificationAPI.initBeanDatas(bean);
                }
                ReportClientUtil.checkAndSetSelectAllObjectGUIDs(request, bean);
                listener.setCSVRows(request, bean, "showList");
            } else if (operation.equalsIgnoreCase("Apply")) {
                bean.set("modifyResultColumn", "");
                bean.set("FROM_INDEX", new Long(1L));
                bean.set("PAGE_NUMBER", "1");
                bean.set("ascending", "true");
                ReportClientUtil.checkAndSetSelectAllObjectGUIDs(request, bean);
                listener.modifyCSVUser(request, bean);
                request.setAttribute("listener", (Object)listener);
                listener.setCSVRows(request, bean, "showModifyUserResult");
            } else if (operation.equalsIgnoreCase("showModifyUserResult")) {
                listener.setCSVRows(request, bean, "showModifyUserResult");
            } else if (operation.equalsIgnoreCase("Stop Modification")) {
                listener.stop(request);
                listener.setWriter(response.getWriter());
                listener.setCSVRows(request, bean, "showModifyUserResult");
            }
            request.setAttribute("domainName", (Object)domainName);
            request.setAttribute("operation", (Object)operation);
            tile = (String)bean.get("tile");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward getMailBoxStores(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            ReportBean bean = (ReportBean)form;
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            BeanMap props = (BeanMap)bean.get("props");
            String domainName = request.getParameter("domainName");
            String mailServer = request.getParameter("mailServer");
            String requestAction = request.getParameter("requestAction");
            ArrayList list = ExchangeHandler.getMailBoxStores((String)domainName, (String)mailServer);
            ArrayList<String> mailBoxStores = new ArrayList<String>();
            ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
            Integer reportId = (Integer)bean.get("reportId");
            if (reportId == null) {
                reportId = 0;
            }
            Integer exchVersion = 2003;
            if (list != null && !list.isEmpty()) {
                exchVersion = ExchangeUtil.getExchangeServerType((String)mailServer);
                if (exchVersion >= 2010 && (reportId != null && reportId == 1013 || requestAction != null && requestAction.equals("13"))) {
                    mailBoxStores.add(rb.getString("client.usermanagement.CreateMailBoxListener.automatic"));
                    mailBoxStoreDNs.add("0");
                }
                mailBoxStores.addAll((ArrayList)list.get(0));
                mailBoxStoreDNs.addAll((ArrayList)list.get(1));
            } else {
                list = ExchangeHandler.getMailBoxStoresFromDag((String)domainName, (String)mailServer);
                if (list != null && !list.isEmpty()) {
                    mailBoxStores.addAll((ArrayList)list.get(0));
                    mailBoxStoreDNs.addAll((ArrayList)list.get(1));
                }
            }
            if (mailServer.equalsIgnoreCase("All Servers") && reportId == 1030) {
                mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.servername.all_databases"));
                mailBoxStoreDNs.add("All Databases");
            }
            props.put("mailBoxStores", mailBoxStores);
            props.put("mailBoxStoreValues", mailBoxStoreDNs);
            props.put("mailServer", mailServer);
            boolean isPowershellEnabled = ExchangeUtil.checkExchange2007((String)mailServer);
            if (isPowershellEnabled || reportId == 1030) {
                props.put("exch2007Display", "display:block;");
                props.put("exch2003Display", "display:none;");
                isPowershellEnabled = true;
            } else {
                props.put("exch2007Display", "display:none;");
                props.put("exch2003Display", "display:block;");
            }
            request.setAttribute("domainName", (Object)domainName);
            if (mailBoxStoreDNs != null && !mailBoxStoreDNs.isEmpty()) {
                UserMgmtUtil.getMailBoxHTMLElement((HttpServletResponse)response, mailBoxStoreDNs, mailBoxStores, (boolean)isPowershellEnabled, (String)exchVersion.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward exportReport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "printPage";
        try {
            this.rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            ReportBean bean = (ReportBean)form;
            String beanName = (String)bean.get("beanName");
            Integer reportId = (Integer)bean.get("reportId");
            HashMap inputParams = (HashMap)bean.get("inputParams");
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            inputParams.put("loginId", loginId);
            inputParams.put("domainTxt", this.rb.getString("admp.common.text.domain"));
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            ArrayList attributelist = ReportAttributeHandler.getInstance().getModifiedColumns(reportId);
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            DataObject obj = ReportHandler.getReportDetails((Integer)reportId);
            Row r = obj.getFirstRow("ADSMReports");
            String reportFileName = (String)r.get("REPORT_FILE_NAME");
            String reportName = (String)r.get("REPORT_NAME");
            inputParams.put("actionTxt", this.rb.getString("admp.deleg.hdt_deleg.cre_hdt.text_action"));
            inputParams.put("modifyType", this.rb.getString(reportName));
            inputParams.put("Generated at", this.rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", this.rb.getString("admp.reports_export.pagefooter.page"));
            String basepath = request.getSession().getServletContext().getRealPath("/");
            reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
            String inputSource = (String)bean.get("inputSource");
            listener.exportReport(reportFileName, reportType, attributelist, inputParams, request, response, beanName, inputSource);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.text.ad_management", (String)((String)r.get("REPORT_NAME")), (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)listener.getExportFileName(), (String)reportType.toLowerCase(), (String)"-", (Integer)listener.getExportRowCount());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String type = request.getParameter("type");
        if (type != null && type.equals("print")) {
            return mapping.findForward(tile);
        }
        return null;
    }

    public ActionForward resultListUpdate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "";
        ArrayList attributelist = null;
        try {
            String isNavigate;
            ReportBean bean = (ReportBean)form;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            Long generationId = listener.getGenerationId();
            Integer reportId = (Integer)bean.get("reportId");
            String inputSource = (String)bean.get("inputSource");
            String fromIndesStr = request.getParameter("FROM_INDEX");
            String rangeStr = request.getParameter("RANGE");
            String sortColumnNameStr = request.getParameter("attributeId");
            String pageNumber = request.getParameter("PAGE_NUMBER");
            String modifyResultColumn = request.getParameter("modifyResultColumn");
            String sortingOrder = "true";
            if (request.getParameter("ascending") != null) {
                sortingOrder = request.getParameter("ascending");
            }
            String operation = request.getParameter("operation");
            Integer range = 25;
            if (rangeStr != null) {
                range = Integer.parseInt(rangeStr);
            }
            if ((isNavigate = request.getParameter("isNavigate")) != null && isNavigate.equals("false")) {
                NavigateRangeUtil.setDefaultRange((String)"BulkModification", (int)range, (Long)loginId);
            }
            Integer attributeId = -1;
            if (sortColumnNameStr != null) {
                attributeId = new Integer(sortColumnNameStr);
            }
            Long fromIndex = 1L;
            if (fromIndesStr != null) {
                fromIndex = new Long(fromIndesStr);
            }
            if (pageNumber == null) {
                pageNumber = "1";
            }
            Hashtable<String, Object> requestProperties = new Hashtable<String, Object>();
            requestProperties.put("FROM_INDEX", fromIndex);
            requestProperties.put("attributeId", attributeId);
            requestProperties.put("ascending", sortingOrder);
            requestProperties.put("modifyResultColumn", modifyResultColumn);
            if (inputSource.equals("csv") && operation.equalsIgnoreCase("showModifyUserResult")) {
                listener.setCSVRowsForModifiedList(request, bean, "showModifyUserResult", requestProperties);
                tile = "importModifiedList";
            } else if (operation.equalsIgnoreCase("showList")) {
                attributelist = ReportAttributeHandler.getInstance().getViewColumn(reportId);
                ReportResultUtil.setReportRows(request, bean, generationId, attributelist, operation, requestProperties);
                tile = "resultList";
            } else if (operation.equalsIgnoreCase("showModifyUserResult")) {
                attributelist = ReportAttributeHandler.getInstance().getModifiedColumns(reportId);
                ReportResultUtil.setModifyResult(request, bean, reportId, listener.getGenerationId(), listener.getResultTableName(), requestProperties);
                tile = "modifiedResultList";
            }
            request.setAttribute("ColumnList", (Object)attributelist);
            request.setAttribute("fromIndex", (Object)fromIndex);
            request.setAttribute("attributeId", (Object)attributeId);
            request.setAttribute("ascending", (Object)sortingOrder);
            request.setAttribute("pageNumber", (Object)pageNumber);
            request.setAttribute("operation", (Object)operation);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward checkAllSids(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            ReportBean bean = (ReportBean)form;
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            JSONArray arrayObject = ReportClientUtil.getAllSidForGenerationId(listener.getResultTableName(), listener.getGenerationId());
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("selectedSids", (Object)arrayObject);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        catch (Exception e) {
            writer.close();
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward addGroupMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            String beanName = request.getParameter("beanName");
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            BeanMap props = (BeanMap)bean.get("props");
            String modifyType = request.getParameter("modifyType");
            String init = request.getParameter("init");
            JSONObject jsonObject = new JSONObject(request.getParameter("selectedGroupSidArray").toString());
            JSONObject selectedGroupList = (JSONObject)jsonObject.get("selectedObjectList");
            Hashtable<String, String> groupSidVsNameMap = (Hashtable<String, String>)props.get(modifyType + "SidVsNameMap");
            if (groupSidVsNameMap == null || init != null && init.equalsIgnoreCase("true")) {
                groupSidVsNameMap = new Hashtable<String, String>();
            }
            ArrayList<Object> groupSidList = new ArrayList<Object>();
            Enumeration groupMapKeys = groupSidVsNameMap.keys();
            while (groupMapKeys.hasMoreElements()) {
                groupSidList.add(groupMapKeys.nextElement());
            }
            Iterator groupSidIterator = selectedGroupList.keys();
            while (groupSidIterator.hasNext()) {
                String groupSid = (String)groupSidIterator.next();
                if (groupSidList.contains(groupSid)) continue;
                groupSidList.add(groupSid);
                groupSidVsNameMap.put(groupSid, selectedGroupList.getString(groupSid));
            }
            props.put(modifyType + "SidVsNameMap", groupSidVsNameMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
            request.setAttribute("beanName", (Object)beanName);
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward removeGroupMembers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            String beanName = request.getParameter("beanName");
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            BeanMap props = (BeanMap)bean.get("props");
            String modifyType = request.getParameter("modifyType");
            JSONObject jsonObject = new JSONObject(request.getParameter("removeGroup").toString());
            String groupSid = jsonObject.getString("groupSid");
            Hashtable groupSidVsNameMap = (Hashtable)props.get(modifyType + "SidVsNameMap");
            if (groupSidVsNameMap == null) {
                groupSidVsNameMap = new Hashtable();
            }
            groupSidVsNameMap.remove(groupSid);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward compareBeanProps(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            Enumeration groupMapKeys;
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("ModifyUserBean");
            BeanMap props = (BeanMap)bean.get("props");
            Hashtable addToGroupSidVsNameMap = (Hashtable)props.get("addToGroupSidVsNameMap");
            Hashtable removeFromGroupSidVsNameMap = (Hashtable)props.get("removeFromGroupSidVsNameMap");
            ArrayList addToGroupSidList = new ArrayList();
            ArrayList removeFromGroupSidList = new ArrayList();
            if (addToGroupSidVsNameMap != null && addToGroupSidVsNameMap.size() > 0) {
                groupMapKeys = addToGroupSidVsNameMap.keys();
                while (groupMapKeys.hasMoreElements()) {
                    addToGroupSidList.add(groupMapKeys.nextElement());
                }
            }
            if (removeFromGroupSidVsNameMap != null && removeFromGroupSidVsNameMap.size() > 0) {
                groupMapKeys = removeFromGroupSidVsNameMap.keys();
                while (groupMapKeys.hasMoreElements()) {
                    removeFromGroupSidList.add(groupMapKeys.nextElement());
                }
            }
            JSONArray arrayObject = new JSONArray();
            for (int index = 0; index < addToGroupSidList.size(); ++index) {
                String addToGroupSid = (String)addToGroupSidList.get(index);
                if (!removeFromGroupSidList.contains(addToGroupSid)) continue;
                arrayObject.put(addToGroupSidVsNameMap.get(addToGroupSid));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("groupList", (Object)arrayObject);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            writer.close();
        }
        return null;
    }

    public ActionForward checkRecycleBinStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String message;
        Boolean recycleBinEnabled;
        block7: {
            this.rb = ResourceBundleMgr.getInstance().getBundle(request);
            String domainName = request.getParameter("domainName");
            recycleBinEnabled = false;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String domainFuncLevel = domainDetails.getProperty("DOMAIN_FUNCTIONAL_LEVEL");
            message = "";
            if (domainFuncLevel.equalsIgnoreCase("Windows Server 2008 R2")) {
                String partitionsDN = "CN=Partitions," + (String)domainDetails.get("CONFIGURATION_NAMING_CONTEXT");
                ArrayList<String> attributeList = new ArrayList<String>();
                attributeList.add("msDS-EnabledFeature");
                try {
                    Properties prop = ADHandler.getObjectProperties((String)domainName, (Long)loginId, (String)partitionsDN, attributeList);
                    ArrayList optionalFeatureList = (ArrayList)prop.get("msDS-EnabledFeature");
                    if (optionalFeatureList != null && optionalFeatureList.contains("CN=Recycle Bin Feature,CN=Optional Features,CN=Directory Service,CN=Windows NT,CN=Services," + (String)domainDetails.get("CONFIGURATION_NAMING_CONTEXT"))) {
                        recycleBinEnabled = true;
                        break block7;
                    }
                    message = this.rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.recycle_bin_disabled");
                }
                catch (Exception e) {
                    message = this.rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.recycle_bin_disabled");
                    e.printStackTrace();
                }
            } else {
                message = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.recycle_bin.statmsg.recycle_bin_not_supported"), domainName, domainFuncLevel);
            }
        }
        if (recycleBinEnabled.booleanValue()) {
            ClientUtil.setStatusXMLElement(response, "Success", "");
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", message);
        }
        return null;
    }

    public ActionForward addGrpMemberOf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            JSONObject updatedList = new JSONObject();
            HttpSession session = request.getSession();
            String beanName = request.getParameter("beanName");
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            BeanMap props = (BeanMap)bean.get("props");
            String modifyType = request.getParameter("modifyType");
            String init = request.getParameter("init");
            JSONObject selectedGrpsObj = new JSONObject(request.getParameter("selectedGroups").toString());
            Hashtable<String, String> groupDNVsNameMap = (Hashtable<String, String>)props.get(modifyType + "DNVsNameMap");
            if (groupDNVsNameMap == null || init != null && init.equalsIgnoreCase("true")) {
                groupDNVsNameMap = new Hashtable<String, String>();
            }
            ArrayList<Object> groupDNList = new ArrayList<Object>();
            Enumeration groupMapKeys = groupDNVsNameMap.keys();
            while (groupMapKeys.hasMoreElements()) {
                groupDNList.add(groupMapKeys.nextElement());
            }
            Iterator groupDNIterator = selectedGrpsObj.keys();
            while (groupDNIterator.hasNext()) {
                String groupDN = (String)groupDNIterator.next();
                if (groupDNList.contains(groupDN)) continue;
                groupDNList.add(groupDN);
                groupDNVsNameMap.put(groupDN, selectedGrpsObj.getString(groupDN));
                updatedList.put(groupDN, (Object)selectedGrpsObj.getString(groupDN));
            }
            props.put(modifyType + "DNVsNameMap", groupDNVsNameMap);
            request.setAttribute("beanName", (Object)beanName);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("html", (Object)updatedList.toString());
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward removeGrpMemberOf(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute(beanName);
            BeanMap props = (BeanMap)bean.get("props");
            String modifyType = request.getParameter("modifyType");
            String groupDN = request.getParameter("removeGroup");
            Hashtable groupDNVsNameMap = (Hashtable)props.get(modifyType + "DNVsNameMap");
            if (groupDNVsNameMap == null) {
                groupDNVsNameMap = new Hashtable();
            } else {
                groupDNVsNameMap.remove(groupDN);
            }
            props.put(modifyType + "DNVsNameMap", groupDNVsNameMap);
            ClientUtil.setStatusXMLElement(response, "Success", "");
        }
        catch (Exception e) {
            e.printStackTrace();
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward compareGrpOrgBeanProps(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        PrintWriter writer = null;
        try {
            Enumeration groupMapKeys;
            HttpSession session = request.getSession();
            DynaValidatorForm bean = (DynaValidatorForm)session.getAttribute("ModifyUserBean");
            BeanMap props = (BeanMap)bean.get("props");
            Hashtable addToGroupDNVsNameMap = (Hashtable)props.get("addToGroupDNVsNameMap");
            Hashtable removeFromGroupDNVsNameMap = (Hashtable)props.get("removeFromGroupDNVsNameMap");
            ArrayList addToGroupDNList = new ArrayList();
            ArrayList removeFromGroupDNList = new ArrayList();
            if (addToGroupDNVsNameMap != null && addToGroupDNVsNameMap.size() > 0) {
                groupMapKeys = addToGroupDNVsNameMap.keys();
                while (groupMapKeys.hasMoreElements()) {
                    addToGroupDNList.add(groupMapKeys.nextElement());
                }
            }
            if (removeFromGroupDNVsNameMap != null && removeFromGroupDNVsNameMap.size() > 0) {
                groupMapKeys = removeFromGroupDNVsNameMap.keys();
                while (groupMapKeys.hasMoreElements()) {
                    removeFromGroupDNList.add(groupMapKeys.nextElement());
                }
            }
            JSONArray arrayObject = new JSONArray();
            for (int index = 0; index < addToGroupDNList.size(); ++index) {
                String addToGroupDN = (String)addToGroupDNList.get(index);
                if (!removeFromGroupDNList.contains(addToGroupDN)) continue;
                arrayObject.put(addToGroupDNVsNameMap.get(addToGroupDN));
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("groupList", (Object)arrayObject);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        catch (Exception e) {
            e.printStackTrace();
            writer.close();
        }
        return null;
    }
}

