/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ModifyAddressAttributeListener
extends ModifyUserListener {
    public ModifyAddressAttributeListener() {
        this.reportId = new Integer(1003);
        this.actionIds = new long[]{1210L, 1211L, 1212L, 1213L, 1214L, 1215L, 1216L, 1217L, 1218L, 1219L};
        this.actions = new String[]{"title", "department", "company", "manager", "streetAddress", "postOfficeBox", "l", "st", "postalCode", "co"};
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1016L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            BeanMap props = (BeanMap)bean.get("props");
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            for (int j = 0; j < selectedAttributes.length; ++j) {
                if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, this.getId(selectedAttributes[j]))) continue;
                Properties p = new Properties();
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                String beanValue = props.getProperty(selectedAttributes[j]);
                if (beanValue.equals("")) {
                    p.put("DW_CONTROL_CODE", new Long(1L));
                }
                if (selectedAttributes[j].equals("manager")) {
                    p.put("DATA_HANDLER_TYPE", new Long(1L));
                    result.put("manager", beanValue);
                } else {
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                }
                p.put("ATTRIB_VALUE", beanValue);
                if (selectedAttributes[j].equals("co")) {
                    Properties coprop = new Properties();
                    coprop.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    coprop.put("ATTRIB_LDAP_NAME", "countryCode");
                    coprop.put("ATTRIB_VALUE", props.getProperty("countryCode"));
                    coprop.put("DATA_HANDLER_TYPE", new Long(3L));
                    Properties cprop = new Properties();
                    cprop.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    cprop.put("ATTRIB_LDAP_NAME", "c");
                    cprop.put("ATTRIB_VALUE", props.getProperty("c"));
                    cprop.put("DATA_HANDLER_TYPE", new Long(3L));
                    setAttributeList.add(coprop);
                    setAttributeList.add(cprop);
                }
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error"));
                    }
                } else {
                    message.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.addrs_attribs.mgmtname.addrs-org_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        String[] actionLabels = new String[]{"admp.mgmt.user_mgmt.addrs_attribs.input.title", "admp.mgmt.user_mgmt.addrs_attribs.input.dept", "admp.mgmt.user_mgmt.addrs_attribs.input.company", "admp.mgmt.user_mgmt.addrs_attribs.input.manager", "admp.mgmt.user_mgmt.addrs_attribs.input.street", "admp.mgmt.user_mgmt.addrs_attribs.input.po_box", "admp.mgmt.user_mgmt.addrs_attribs.input.city", "admp.mgmt.user_mgmt.addrs_attribs.input.state_province", "admp.mgmt.user_mgmt.addrs_attribs.input.zip_postal_code", "admp.mgmt.user_mgmt.addrs_attribs.input.country_region"};
        MgmtUtil.setEmptyFieldsMessage(request, bean, this.actions, actionLabels);
    }
}

