/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MgmtActionIdConstants;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import java.util.logging.Level;

public class ModifyLogonHoursListener
extends ModifyUserListener {
    public ModifyLogonHoursListener() {
        this.reportId = new Integer(1033);
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexArray = "0123456789ABCDEF".toCharArray();
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = hexArray[v >>> 4];
            hexChars[j * 2 + 1] = hexArray[v & 0xF];
        }
        return new String(hexChars);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{MgmtActionIdConstants.LOGON_HOURS_ACTIONID})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            String userName = this.getValue(result, 1005);
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            try {
                int j;
                int i;
                int extra;
                BeanMap props = (BeanMap)bean.get("props");
                String logonHoursStr = props.getProperty("logonHoursStr");
                if (logonHoursStr == null) {
                    logonHoursStr = "";
                }
                String[] allowedHours = logonHoursStr.split(",");
                byte[] bytes = new byte[21];
                BitSet bits = new BitSet(168);
                int allowedHoursLen = allowedHours.length;
                if (logonHoursStr.length() > 0) {
                    for (int i2 = 0; i2 < allowedHoursLen; ++i2) {
                        bits.set(Integer.parseInt(allowedHours[i2]));
                    }
                }
                BitSet leapBits = new BitSet(168);
                Hashtable tzProps = DateTimeUtil.getDateTimeFormats((Long)loginId);
                String tzId = (String)tzProps.get("timeZone");
                TimeZone tz = TimeZone.getTimeZone(tzId);
                logger.log(Level.INFO, "TimeZone: " + tz.getDisplayName() + ", ID: " + tz.getID());
                int leap = tz.getRawOffset() / 60000 / 60;
                if (leap > 0) {
                    extra = tz.getRawOffset() / 60000 % 60 <= 30 ? 0 : 1;
                    leap += extra;
                } else if (leap < 0) {
                    extra = tz.getRawOffset() / 60000 % 60 <= -30 ? 1 : 0;
                    leap -= extra;
                }
                if (leap > 0) {
                    i = leap;
                    j = 0;
                    while (i < 168) {
                        leapBits.set(j, bits.get(i));
                        ++i;
                        ++j;
                    }
                    i = 0;
                    j = 168 - leap;
                    while (i < leap) {
                        leapBits.set(j, bits.get(i));
                        ++i;
                        ++j;
                    }
                } else if (leap < 0) {
                    i = 0;
                    for (j = Math.abs(leap); j < 168; ++j) {
                        leapBits.set(j, bits.get(i));
                        ++i;
                    }
                    i = 168 - Math.abs(leap);
                    for (j = 0; j < Math.abs(leap); ++j) {
                        leapBits.set(j, bits.get(i));
                        ++i;
                    }
                } else {
                    leapBits = bits;
                }
                for (i = 0; i < 168; ++i) {
                    if (!leapBits.get(i)) continue;
                    int n = i / 8;
                    bytes[n] = (byte)(bytes[n] | 1 << i % 8);
                }
                Properties p = new Properties();
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_VALUE", ModifyLogonHoursListener.bytesToHex(bytes));
                p.put("ATTRIB_LDAP_NAME", "logonHours");
                setAttributeList.add(p);
                logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
                ADHandlerForMgmt.setLogonHours((String)domainName, (Long)loginId, (String)sid, (String)dn, (byte[])bytes, (ArrayList)attributeList, (NativeListener)this);
                message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                e.printStackTrace();
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.common.attrib_disp_name.logon_hours"), userName, domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message.toString();
    }
}

