/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.audit.DataImportExportAudit;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPhotoMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcExecuteNamingFormat;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyPhotoListener;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.privacy.PrivacyHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.apache.commons.io.FileUtils;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModifyPhotoAction
extends DispatchAction {
    protected static Logger logger = Logger.getLogger("ADMangLogger");

    public ActionForward modifyPhotoAttrib(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Integer reportId = Integer.parseInt(request.getParameter("reportId"));
        Long actionId = -1L;
        long bulkDenyActionId = 1102L;
        Criteria criteria = new Criteria(new Column("ADSMReports", "REPORT_ID"), (Object)reportId, 0);
        DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", criteria);
        if (!dataobj.isEmpty()) {
            Row r = dataobj.getFirstRow("ADSMReports");
            actionId = (Long)r.get("ACTION_ID");
        }
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Hashtable domainVsActions = authObject.getDomainActionMap();
        ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsActions, (Long)actionId);
        Iterator i$ = domainList.iterator();
        while (i$.hasNext()) {
            Properties domainProp;
            String domainName = (String)(domainProp = (Properties)i$.next()).get("DOMAIN_NAME");
            ArrayList allowedActions = (ArrayList)domainVsActions.get(domainName);
            domainProp.put("ALLOW_BULK", (Object)(!allowedActions.contains(bulkDenyActionId) ? 1 : 0));
        }
        Properties formatProp = ModifyPhotoListener.getDefaultFormatForHDT(loginId);
        request.setAttribute("defaultFormatType", (Object)formatProp.getProperty("defaultFormatType"));
        request.setAttribute("defaultFormat", (Object)formatProp.getProperty("defaultFormat"));
        request.setAttribute("domainList", (Object)domainList);
        return mapping.findForward("modifyPhoto");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward removeUserPhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try (PrintWriter writer = null;){
            String sidString = request.getParameter("sidString");
            String objectGuid = request.getParameter("objectGuid");
            String samAccountName = request.getParameter("samAccountName");
            String domainName = request.getParameter("domainName");
            String photoAttribute = request.getParameter("photoAttribute");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            ModifyPhotoListener mgmtListener = new ModifyPhotoListener();
            JSONObject jsonObject = mgmtListener.removeUserPhoto(domainName, loginId, reportId, request, sidString, objectGuid, samAccountName, photoAttribute, rb);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward getUsersForPhotoMgmt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter writer = null;
        JSONArray userDetailsForUI = new JSONArray();
        int totalUsersCount = 0;
        int startIndex = 1;
        int range = 25;
        int endIndex = 25;
        try {
            ADMPAuthObject authObject;
            JSONObject result;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String photoMgmtInputJsonStr = request.getParameter("userSelectionDetJson");
            String photoAttribute = request.getParameter("photoAttributeLdapName");
            JSONObject photoMgmtInput = new JSONObject(photoMgmtInputJsonStr);
            String domainName = photoMgmtInput.getString("domainName");
            JSONArray selectedOUListJsonArr = (JSONArray)photoMgmtInput.get("selectedOUs");
            JSONArray unSelectedOUListJsonArr = (JSONArray)photoMgmtInput.get("unSelectedOUs");
            Boolean excludeChildOU = photoMgmtInput.getBoolean("excludeChildOU");
            JSONObject searchCrit = (JSONObject)photoMgmtInput.get("searchCrit");
            String quickSearchStr = request.getParameter("quickSearchStr");
            ArrayList userList = new ArrayList();
            String searchString = "(&(objectClass=user)(objectCategory=person))";
            ArrayList<String> attribListToUI = new ArrayList<String>();
            attribListToUI.add("OBJECT_GUID");
            attribListToUI.add("SID_STRING");
            attribListToUI.add("DISPLAY_NAME");
            attribListToUI.add("SAM_ACCOUNT_NAME");
            String startIndexStr = request.getParameter("startIndex");
            String rangeStr = request.getParameter("range");
            if (startIndexStr != null && startIndexStr.length() > 0) {
                startIndex = Integer.parseInt(startIndexStr);
                range = Integer.parseInt(rangeStr);
            }
            if ((result = ModifyPhotoListener.getUsers(request, domainName, loginId, authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT"), startIndex, range, attribListToUI, photoAttribute, selectedOUListJsonArr, unSelectedOUListJsonArr, excludeChildOU, searchCrit, false, quickSearchStr)).has("userDetails")) {
                userDetailsForUI = (JSONArray)result.get("userDetails");
                totalUsersCount = result.getInt("totalUsersCount");
            }
            endIndex = startIndex + userDetailsForUI.length() - 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("userDetails", (Object)userDetailsForUI);
            jsonObject.put("totalUsersCount", totalUsersCount);
            jsonObject.put("startIndex", startIndex);
            jsonObject.put("range", range);
            jsonObject.put("endIndex", endIndex);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
            writer.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward getUserPhotosFromAD(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter writer = null;
        String errMsg = "";
        try {
            JSONArray userObjectIdArr;
            String jsonArrTxt = request.getParameter("userInfoList");
            String jsonObjIdArrTxt = request.getParameter("userObjectGuidList");
            String domainName = request.getParameter("domainName");
            String photoAttribute = request.getParameter("photoAttribute");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONArray userInfoArr = new JSONArray(jsonArrTxt);
            JSONArray jSONArray = userObjectIdArr = jsonObjIdArrTxt != null ? new JSONArray(jsonObjIdArrTxt) : new JSONArray();
            if (!photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                int userCount = userInfoArr.length();
                for (int indx = 0; indx < userCount; indx += 5) {
                    ArrayList<String> samAccountNameList = new ArrayList<String>();
                    for (int indx1 = indx; indx1 < indx + 5 && indx1 < userCount; ++indx1) {
                        samAccountNameList.add(userInfoArr.getString(indx1));
                    }
                    if (samAccountNameList.size() <= 0) continue;
                    errMsg = ModifyPhotoListener.getPhotoFromAD(request, domainName, loginId, photoAttribute, samAccountNameList);
                }
            } else {
                Properties mailboxEnabledUserProps = ModifyPhotoListener.getMailboxEnabledUsers(domainName, loginId);
                ArrayList<Object> samAccountNameList = new ArrayList<Object>();
                ArrayList<String> objectIdList = new ArrayList<String>();
                String photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute);
                for (int indx = 0; indx < userObjectIdArr.length(); ++indx) {
                    String objectGuid = userObjectIdArr.getString(indx);
                    if (mailboxEnabledUserProps.containsKey(objectGuid)) {
                        String mailServer = (String)mailboxEnabledUserProps.get(objectGuid);
                        mailboxEnabledUserProps.remove(objectGuid);
                        Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)domainName, (String)mailServer);
                        String status = ADHandler.getExchangePhoto((String)domainName, (long)loginId, (String)objectGuid, (String)photoFolder, (Properties)exchangeServerDetails);
                        if (status.length() <= 0) continue;
                        samAccountNameList.add(userInfoArr.get(indx));
                        objectIdList.add(objectGuid);
                        continue;
                    }
                    samAccountNameList.add(userInfoArr.get(indx));
                    objectIdList.add(objectGuid);
                }
                if (samAccountNameList.size() > 0) {
                    ModifyPhotoListener.getPhotoFromAD(request, domainName, loginId, "thumbnailPhoto", samAccountNameList);
                }
                for (String objectGuid : objectIdList) {
                    String source = ModifyPhotoListener.getPhotoFolder(request, domainName, "thumbnailPhoto");
                    source = source + objectGuid;
                    File src = new File(source);
                    String destination = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute);
                    File dest = new File(destination);
                    if (!dest.exists()) {
                        dest.mkdirs();
                    }
                    if (src.exists()) {
                        FileUtils.copyFileToDirectory((File)src, (File)dest, (boolean)false);
                        continue;
                    }
                    UserPhotoMgmtUtil.writePhotoToFile((String)photoFolder, (String)"", (String)objectGuid);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("errorMessage", (Object)errMsg);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
            writer.close();
        }
        return null;
    }

    public ActionForward cachePhotosForLayoutExecution(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String uniqueOperationId = request.getParameter("uniqueOperationId");
            String newUniqueOperationId = request.getParameter("newUniqueOperationId");
            if (uniqueOperationId != null) {
                String srcFolderPath = UserPhotoMgmtUtil.getPhotoFolderPath((int)0, (String)uniqueOperationId);
                String destFolderPath = UserPhotoMgmtUtil.getPhotoFolderPath((int)1, (String)newUniqueOperationId);
                File srcFolder = new File(srcFolderPath);
                if (!srcFolder.exists()) {
                    srcFolderPath = UserPhotoMgmtUtil.getPhotoFolderPath((int)1, (String)uniqueOperationId);
                    srcFolder = new File(srcFolderPath);
                }
                File destFolder = new File(destFolderPath);
                destFolder.mkdirs();
                if (srcFolder.exists()) {
                    FileUtils.copyDirectory((File)srcFolder, (File)destFolder, (boolean)false);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getUserPhotoForLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String uniqueOperationId = request.getParameter("vUniqueOperationId");
            String isForLayoutExec = request.getParameter("isForLayoutExecution");
            Boolean isForLayoutExecution = isForLayoutExec != null ? Boolean.parseBoolean(isForLayoutExec) : false;
            String filePath = "";
            if (uniqueOperationId != null) {
                String photoFolder = UserPhotoMgmtUtil.getPhotoFolderPath((int)0, (String)uniqueOperationId);
                File photoFileFolder = new File(photoFolder);
                if (isForLayoutExecution.booleanValue()) {
                    photoFolder = UserPhotoMgmtUtil.getPhotoFolderPath((int)1, (String)uniqueOperationId);
                    photoFileFolder = new File(photoFolder);
                }
                if (photoFileFolder.exists()) {
                    File[] photoFileList;
                    for (File file : photoFileList = photoFileFolder.listFiles()) {
                        if (file.isDirectory()) continue;
                        filePath = ModifyPhotoListener.getRelativeFilePath(request, file);
                        break;
                    }
                }
            }
            if (filePath.length() > 0) {
                response.sendRedirect(filePath);
            } else {
                response.sendRedirect("images/avatar.png");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getUserPhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String objectGUID = request.getParameter("vObjectGUID");
            String hexValOfImage = "";
            String photoAttribute = request.getParameter("vPhotoAttribute");
            String domainName = request.getParameter("vDomainName");
            String samAccountName = request.getParameter("vSamAccountName");
            String reqId = request.getParameter("requestId");
            Long requestId = 0L;
            if (reqId != null) {
                requestId = Long.parseLong(reqId);
            }
            String canShowError = request.getParameter("canShowError");
            String isADError = request.getParameter("isADError");
            boolean isForAutomation = false;
            if (canShowError != null && canShowError.equalsIgnoreCase("fetchFromAD")) {
                isForAutomation = true;
                canShowError = null;
            }
            if (objectGUID != null) {
                String photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribute);
                if (isForAutomation) {
                    photoFolder = UserPhotoMgmtUtil.getAutomationResultFolder() + "\\" + requestId + "\\";
                }
                hexValOfImage = ModifyPhotoListener.getPhotoFileAsHex(photoFolder, objectGUID);
                if (photoAttribute.equalsIgnoreCase("exchangePhoto") && (hexValOfImage == null || hexValOfImage.equals(""))) {
                    photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, "thumbnailPhoto");
                    hexValOfImage = ModifyPhotoListener.getPhotoFileAsHex(photoFolder, objectGUID);
                }
                if (hexValOfImage != null && !hexValOfImage.equals("")) {
                    byte[] byteArrOfImg = UserPhotoMgmtUtil.convertHexToByteArray((String)hexValOfImage);
                    String contentType = ModifyPhotoListener.getContentType(hexValOfImage);
                    response.setContentType(contentType);
                    response.getOutputStream().write(byteArrOfImg);
                }
            }
            if (hexValOfImage == null) {
                if (isForAutomation) {
                    response.sendRedirect("images/avatar.png");
                } else if (isADError != null && isADError.equalsIgnoreCase("true")) {
                    response.sendRedirect("images/photoError.jpg");
                } else {
                    response.sendRedirect("images/loading-icon.gif");
                }
            } else if (hexValOfImage.equals("") && canShowError == null) {
                response.sendRedirect("images/avatar.png");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getImportedPhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String objectGUID = request.getParameter("vObjectGUID");
            String uniqueOperationId = request.getParameter("vUniqueOperationId");
            String hexValOfImage = "-";
            String photoFilePath = "-";
            if (objectGUID != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)objectGUID, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0));
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtTempTable", crit);
                if (!dataObj.isEmpty()) {
                    Row row = dataObj.getRow("ADSMPhotoMgmtTempTable");
                    hexValOfImage = (String)row.get("PHOTO_HEX");
                    photoFilePath = (String)row.get("PHOTO_FILE_PATH");
                }
                if (!hexValOfImage.equals("-")) {
                    int hexStrLen = hexValOfImage.length();
                    byte[] byteArrOfImg = new byte[hexStrLen / 2];
                    for (int indx1 = 0; indx1 < hexStrLen; indx1 += 2) {
                        byteArrOfImg[indx1 / 2] = (byte)((Character.digit(hexValOfImage.charAt(indx1), 16) << 4) + Character.digit(hexValOfImage.charAt(indx1 + 1), 16));
                    }
                    String contentType = ModifyPhotoListener.getContentType(hexValOfImage);
                    response.setContentType(contentType);
                    response.getOutputStream().write(byteArrOfImg);
                } else if (!photoFilePath.equals("-")) {
                    response.setContentType("image/jpeg");
                    File file = new File(photoFilePath);
                    FileInputStream fileInputStream = new FileInputStream(file);
                    byte[] byteArrOfImg = new byte[(int)file.length()];
                    fileInputStream.read(byteArrOfImg);
                    fileInputStream.close();
                    response.getOutputStream().write(byteArrOfImg);
                } else {
                    response.sendRedirect("images/avatar.png");
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward importPhotoForBulkMgmt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String shareFolderPath = request.getParameter("photoShareFolder");
        String photoFileNameFormat = request.getParameter("photoFileNameFormat");
        String photoFileFormatType = request.getParameter("photoFileFormatType");
        String uniqueOperationId = request.getParameter("uniqueOperationId");
        String userSelectionDetJson = request.getParameter("userSelectionDetJson");
        String photoAttributeLdapName = request.getParameter("photoAttributeLdapName");
        String inputType = request.getParameter("isFilesAsInput");
        boolean isFilesAsInput = false;
        if (inputType != null && inputType.equalsIgnoreCase("true")) {
            isFilesAsInput = true;
        }
        JSONObject photoMgmtInput = new JSONObject(userSelectionDetJson);
        String domainName = photoMgmtInput.getString("domainName");
        JSONArray selectedOUListJsonArr = (JSONArray)photoMgmtInput.get("selectedOUs");
        JSONArray unSelectedOUListJsonArr = (JSONArray)photoMgmtInput.get("unSelectedOUs");
        Boolean excludeChildOU = photoMgmtInput.getBoolean("excludeChildOU");
        JSONObject searchCrit = (JSONObject)photoMgmtInput.get("searchCrit");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList<Object> attribListToUI = new ArrayList<String>();
        if (photoFileFormatType != null) {
            ModifyPhotoListener.setDefaultFormatForHDT(loginId, photoFileFormatType, photoFileNameFormat);
        }
        photoFileNameFormat = photoFileNameFormat.replaceAll("\"%\"", ":PER:");
        photoFileNameFormat = photoFileNameFormat.replaceAll("(?i)%userName%", "%sAMAccountName%");
        photoFileNameFormat = photoFileNameFormat.replaceAll("(?i)%LogonName%", "%sAMAccountName%");
        int initialIndx = photoFileNameFormat.indexOf("%");
        ArrayList<String> formatAttribList = new ArrayList<String>();
        while (initialIndx != -1 && initialIndx < photoFileNameFormat.length() - 1 && photoFileNameFormat.indexOf("%", initialIndx + 1) != -1) {
            int nextIndex = photoFileNameFormat.indexOf("%", initialIndx + 1);
            String attribName = photoFileNameFormat.substring(initialIndx + 1, nextIndex);
            if (!formatAttribList.contains(attribName)) {
                formatAttribList.add(attribName.toLowerCase());
            }
            if (nextIndex + 1 >= photoFileNameFormat.length()) break;
            initialIndx = photoFileNameFormat.indexOf("%", nextIndex + 1);
        }
        photoFileNameFormat = photoFileNameFormat.replaceAll(":PER:", "\"%\"");
        if (!formatAttribList.contains("objectguid")) {
            formatAttribList.add("objectguid");
        }
        for (int indx2 = 0; indx2 < formatAttribList.size(); ++indx2) {
            String ldapName = (String)formatAttribList.get(indx2);
            attribListToUI.add(ldapName);
        }
        attribListToUI = ModifyPhotoListener.getAttributeInfo(attribListToUI);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        JSONObject result = ModifyPhotoListener.getUsers(request, domainName, loginId, authObject, -1, -1, attribListToUI, null, selectedOUListJsonArr, unSelectedOUListJsonArr, excludeChildOU, searchCrit, true, null);
        ArrayList userDetailsForUI = (ArrayList)result.get("userDetails");
        Hashtable<String, ArrayList<String>> formatValVsObjectId = new Hashtable<String, ArrayList<String>>();
        int userCount = userDetailsForUI.size();
        for (int indx1 = 0; indx1 < userCount; ++indx1) {
            Properties userDetailObj = (Properties)userDetailsForUI.get(indx1);
            String formatValue = FcExecuteNamingFormat.getFormatValue(photoFileNameFormat, null, userDetailObj);
            String objectGUID = (String)userDetailObj.get("objectGUID");
            if ((formatValue = formatValue.trim().toLowerCase()) == null || formatValue.length() <= 0 || formatValue.equals("-")) continue;
            ArrayList<String> matchingGuidList = (ArrayList<String>)formatValVsObjectId.get(formatValue);
            if (matchingGuidList == null) {
                matchingGuidList = new ArrayList<String>();
                formatValVsObjectId.put(formatValue, matchingGuidList);
            }
            matchingGuidList.add(objectGUID);
        }
        JSONArray matchedUserObjectIdList = new JSONArray();
        JSONArray unMatchedPhotosList = new JSONArray();
        JSONArray unMatchedPhotosListWithError = new JSONArray();
        JSONArray matchedUserDetails = new JSONArray();
        boolean isSuccess = false;
        boolean isExchangePhoto = true;
        boolean isFileSizeExceed = false;
        String errorMsg = "";
        PrintWriter writer = null;
        try {
            ArrayList<Object> importedFilesList = new ArrayList<Object>();
            if (isFilesAsInput) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtImportedPhotos", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMPhotoMgmtImportedPhotos"));
                query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtImportedPhotos", (String)"UNIQUE_ID"));
                query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtImportedPhotos", (String)"FILE_NAME"));
                query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtImportedPhotos", (String)"FILE_LENGTH"));
                query.addSortColumn(new SortColumn("ADSMPhotoMgmtImportedPhotos", "UNIQUE_ID", true));
                query.setCriteria(crit);
                DataObject importedFilesDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                if (!importedFilesDO.isEmpty()) {
                    Iterator it = importedFilesDO.getRows("ADSMPhotoMgmtImportedPhotos");
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        Long uniqueId = (Long)r.get("UNIQUE_ID");
                        String fileName = (String)r.get("FILE_NAME");
                        Long fileLength = (Long)r.get("FILE_LENGTH");
                        JSONObject fileObj = new JSONObject();
                        fileObj.put("UNIQUE_ID", (Object)uniqueId);
                        fileObj.put("FILE_NAME", (Object)fileName);
                        fileObj.put("FILE_LENGTH", (Object)fileLength);
                        importedFilesList.add(fileObj);
                    }
                }
            } else {
                File sharedDirectory = new File(shareFolderPath);
                if (!sharedDirectory.exists() || !sharedDirectory.canRead()) {
                    throw new Exception(rb.getString("admp.mgmt.user_mgmt.photo_mgmt.status_folder_not_readable"));
                }
                File[] photoList = sharedDirectory.listFiles();
                if (photoList == null || photoList.length == 0) {
                    throw new Exception(rb.getString("admp.mgmt.user_mgmt.photo_mgmt.status_no_files_found"));
                }
                importedFilesList.addAll(Arrays.asList(photoList));
            }
            DataObject tempPhotoDataObj = null;
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtDetails", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
            DataObject mgmtDetailsDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtDetails", crit);
            if (mgmtDetailsDO.isEmpty()) {
                tempPhotoDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Row row = new Row("ADSMPhotoMgmtDetails");
                row.set("MGMT_UNIQUE_ID", (Object)uniqueOperationId);
                row.set("OPERATION_TIME", (Object)new Date().getTime());
                tempPhotoDataObj.addRow(row);
                CommonUtil.getPersistence((boolean[])new boolean[0]).add(tempPhotoDataObj);
            }
            Criteria tempDelCrit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(tempDelCrit);
            Hashtable<String, Boolean> nameCheck = new Hashtable<String, Boolean>();
            for (int indx = 0; indx < importedFilesList.size(); ++indx) {
                String fileErrorMsg = "";
                String fileName = "";
                Long fileLength = 0L;
                if (isFilesAsInput) {
                    JSONObject fileInfo = (JSONObject)importedFilesList.get(indx);
                    fileName = fileInfo.getString("FILE_NAME");
                    fileLength = (Long)fileInfo.get("FILE_LENGTH");
                } else {
                    File file = (File)importedFilesList.get(indx);
                    if (file.isDirectory()) continue;
                    fileName = file.getName();
                    fileLength = file.length();
                }
                int lastPeriodIndx = -1;
                lastPeriodIndx = fileName.lastIndexOf(".");
                String fileNameWithoutExtn = "";
                String fileExtn = "";
                if (lastPeriodIndx > 0) {
                    fileNameWithoutExtn = fileName.substring(0, lastPeriodIndx);
                    fileExtn = fileName.substring(lastPeriodIndx + 1);
                }
                if (nameCheck.get(fileNameWithoutExtn) != null) continue;
                nameCheck.put(fileNameWithoutExtn, true);
                ArrayList<String> supportedFormats = new ArrayList<String>();
                String supportedFormatsErrorKey = "admp.mgmt.user_mgmt.photo_mgmt.alert_invalid_photo_format";
                supportedFormats.add("jpg");
                supportedFormats.add("png");
                supportedFormats.add("jpeg");
                supportedFormats.add("gif");
                supportedFormats.add("bmp");
                if (!photoAttributeLdapName.equalsIgnoreCase("exchangePhoto")) {
                    supportedFormats.add("ico");
                    isExchangePhoto = false;
                } else {
                    supportedFormatsErrorKey = "admp.mgmt.user_mgmt.photo_mgmt.alert_invalid_exchange_photo_format";
                }
                if (lastPeriodIndx <= 0 || lastPeriodIndx == fileName.length() - 1) {
                    fileErrorMsg = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.alert_no_extn_for_file");
                } else if (!supportedFormats.contains(fileExtn.toLowerCase())) {
                    fileErrorMsg = rb.getString(supportedFormatsErrorKey);
                }
                ArrayList matchedObjectIDList = (ArrayList)formatValVsObjectId.get(fileNameWithoutExtn.toLowerCase());
                ArrayList withExtnMatchingObjectIdList = (ArrayList)formatValVsObjectId.get(fileName.toLowerCase());
                if (withExtnMatchingObjectIdList != null && withExtnMatchingObjectIdList.size() > 0) {
                    if (matchedObjectIDList == null) {
                        matchedObjectIDList = new ArrayList();
                    }
                    matchedObjectIDList.addAll(withExtnMatchingObjectIdList);
                }
                if (fileErrorMsg.length() == 0 && matchedObjectIDList != null && matchedObjectIDList.size() > 0) {
                    String hexValOfImage = "-";
                    String photoFilePath = "";
                    if (isFilesAsInput) {
                        JSONObject fileInfo = (JSONObject)importedFilesList.get(indx);
                        String uniqueId = fileInfo.getString("UNIQUE_ID");
                        Criteria photoCrit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtImportedPhotos", (String)"UNIQUE_ID"), (Object)uniqueId, 0);
                        DataObject photoDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtImportedPhotos", photoCrit);
                        if (!photoDO.isEmpty()) {
                            Row r = photoDO.getRow("ADSMPhotoMgmtImportedPhotos");
                            hexValOfImage = (String)r.get("PHOTO_HEX");
                            photoFilePath = (String)r.get("FILE_PATH");
                        }
                    } else {
                        File file = (File)importedFilesList.get(indx);
                        fileLength = file.length();
                        if (photoAttributeLdapName.equalsIgnoreCase("thumbnailPhoto") && fileLength > 102400L) {
                            file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)102400, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                        } else if (photoAttributeLdapName.equalsIgnoreCase("thumbnailLogo") && fileLength > 32767L) {
                            file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)Short.MAX_VALUE, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                        } else if ((photoAttributeLdapName.equalsIgnoreCase("jpegPhoto") || photoAttributeLdapName.equalsIgnoreCase("photo")) && fileLength > 0xA00000L) {
                            file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)0xA00000, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                        }
                        if (file == null) {
                            JSONObject unMatchedPhotoObj = new JSONObject();
                            unMatchedPhotoObj.put("FILE_NAME", (Object)fileName);
                            unMatchedPhotoObj.put("ERROR", (Object)rb.getString("admp.mgmt.user_mgmt.photo_mgmt.file_cannot_accessed"));
                            if (fileErrorMsg.length() <= 0) continue;
                            unMatchedPhotosListWithError.put((Object)unMatchedPhotoObj);
                            continue;
                        }
                        photoFilePath = file.getCanonicalPath();
                        fileLength = file.length();
                        if (!isExchangePhoto) {
                            byte[] bFile = new byte[fileLength.intValue()];
                            FileInputStream fileInputStream = null;
                            fileInputStream = new FileInputStream(file);
                            fileInputStream.read(bFile);
                            fileInputStream.close();
                            hexValOfImage = StrUtil.byteArrayToHexString((byte[])bFile);
                        }
                    }
                    for (int indx1 = 0; indx1 < matchedObjectIDList.size(); ++indx1) {
                        String matchedObjectID = (String)matchedObjectIDList.get(indx1);
                        Row row = new Row("ADSMPhotoMgmtTempTable");
                        row.set("MGMT_UNIQUE_ID", (Object)uniqueOperationId);
                        row.set("OBJECT_GUID", (Object)matchedObjectID);
                        row.set("PHOTO_HEX", (Object)hexValOfImage);
                        row.set("PHOTO_FILE_PATH", (Object)photoFilePath);
                        tempPhotoDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        tempPhotoDataObj.addRow(row);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(tempPhotoDataObj);
                        matchedUserObjectIdList.put((Object)matchedObjectID);
                    }
                    continue;
                }
                JSONObject unMatchedPhotoObj = new JSONObject();
                unMatchedPhotoObj.put("FILE_NAME", (Object)fileName);
                unMatchedPhotoObj.put("ERROR", (Object)fileErrorMsg);
                if (fileErrorMsg.length() > 0) {
                    unMatchedPhotosListWithError.put((Object)unMatchedPhotoObj);
                    continue;
                }
                unMatchedPhotosList.put((Object)unMatchedPhotoObj);
            }
            int unMatLen = unMatchedPhotosList.length();
            for (int mIndx = 0; mIndx < unMatLen; ++mIndx) {
                unMatchedPhotosListWithError.put(unMatchedPhotosList.get(mIndx));
            }
            String startIndexStr = request.getParameter("startIndex");
            String rangeStr = request.getParameter("range");
            int startIndex = 1;
            int range = 25;
            if (startIndexStr != null && startIndexStr.length() > 0) {
                startIndex = Integer.parseInt(startIndexStr);
                range = Integer.parseInt(rangeStr);
            }
            attribListToUI.clear();
            attribListToUI.add("OBJECT_GUID");
            attribListToUI.add("SID_STRING");
            attribListToUI.add("DISPLAY_NAME");
            attribListToUI.add("SAM_ACCOUNT_NAME");
            JSONObject matchedSearchCrit = new JSONObject();
            matchedSearchCrit.put("OBJECT_GUID_LIST", (Object)matchedUserObjectIdList);
            result = ModifyPhotoListener.getUsers(request, domainName, startIndex, range, attribListToUI, null, matchedSearchCrit, null);
            matchedUserDetails = (JSONArray)result.get("userDetails");
            if (matchedUserObjectIdList.length() == 0) {
                if (!isFilesAsInput) {
                    errorMsg = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.no_user_matched_warning");
                } else if (!isFileSizeExceed) {
                    errorMsg = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.no_user_matched_warning_files");
                }
                isSuccess = false;
            } else {
                isSuccess = true;
                errorMsg = "";
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtImportedPhotos", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            errorMsg = ex.getMessage();
        }
        finally {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isSuccess", isSuccess);
            jsonObject.put("errorMsg", (Object)errorMsg);
            jsonObject.put("matchedObjectGUIDList", (Object)matchedUserObjectIdList);
            jsonObject.put("unMatchedPhotosList", (Object)unMatchedPhotosListWithError);
            jsonObject.put("matchedUserDetails", (Object)matchedUserDetails);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
            writer.close();
        }
        return null;
    }

    public ActionForward deleteCachedData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String uniqueOperationId = request.getParameter("uniqueOperationId");
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtDetails", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMPhotoMgmtDetails"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtDetails", (String)"PHOTO_FOLDER"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtDetails", (String)"UNIQUE_ID"));
            sq.setCriteria(crit);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Iterator it = dataObj.getRows("ADSMPhotoMgmtDetails");
                while (it.hasNext()) {
                    File photoFolderObj;
                    Row r = (Row)it.next();
                    String photoFolder = (String)r.get("PHOTO_FOLDER");
                    if (photoFolder == null || !(photoFolderObj = new File(photoFolder)).exists()) continue;
                    FileUtils.cleanDirectory((File)photoFolderObj);
                    photoFolderObj.delete();
                }
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward getMatchedPhotos(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String uniqueOperationId = request.getParameter("uniqueOperationId");
        String userSelectionDetJson = request.getParameter("userSelectionDetJson");
        String matchedUserObjectListStr = request.getParameter("matchedUsersGuidList");
        JSONObject photoMgmtInput = new JSONObject(userSelectionDetJson);
        String domainName = photoMgmtInput.getString("domainName");
        JSONObject searchCrit = (JSONObject)photoMgmtInput.get("searchCrit");
        String quickSearchStr = request.getParameter("quickSearchStr");
        String getMatchedList = request.getParameter("getMatchedList");
        JSONArray matchedUserObjectIdList = new JSONArray(matchedUserObjectListStr);
        try (PrintWriter writer = null;){
            String startIndexStr = request.getParameter("startIndex");
            String rangeStr = request.getParameter("range");
            int startIndex = 1;
            int range = 25;
            if (startIndexStr != null && startIndexStr.length() > 0) {
                startIndex = Integer.parseInt(startIndexStr);
                range = Integer.parseInt(rangeStr);
            }
            ArrayList<String> attribListToUI = new ArrayList<String>();
            attribListToUI.add("OBJECT_GUID");
            attribListToUI.add("SID_STRING");
            attribListToUI.add("DISPLAY_NAME");
            attribListToUI.add("SAM_ACCOUNT_NAME");
            JSONObject matchedSearchCrit = new JSONObject();
            matchedSearchCrit.put("OBJECT_GUID_LIST", (Object)matchedUserObjectIdList);
            JSONObject result = ModifyPhotoListener.getUsers(request, domainName, startIndex, range, attribListToUI, null, matchedSearchCrit, quickSearchStr);
            JSONArray matchedUserDetails = new JSONArray();
            if (result.has("userDetails")) {
                matchedUserDetails = (JSONArray)result.get("userDetails");
            }
            JSONArray matchedGUIDList = null;
            if (getMatchedList != null && getMatchedList.equalsIgnoreCase("true")) {
                matchedGUIDList = new JSONArray();
                if (matchedUserDetails.length() > 0) {
                    JSONObject matchedResult = ModifyPhotoListener.getUsers(request, domainName, -1, range, attribListToUI, null, matchedSearchCrit, quickSearchStr);
                    JSONArray matchedResultUserList = (JSONArray)matchedResult.get("userDetails");
                    for (int indx = 0; indx < matchedResultUserList.length(); ++indx) {
                        JSONObject userInfoProp = (JSONObject)matchedResultUserList.get(indx);
                        String objectGUID = userInfoProp.getString("OBJECT_GUID");
                        matchedGUIDList.put((Object)objectGUID);
                    }
                }
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("userDetails", (Object)matchedUserDetails);
            jsonObject.put("startIndex", startIndex);
            jsonObject.put("endIndex", startIndex + matchedUserDetails.length() - 1);
            if (quickSearchStr != null) {
                jsonObject.put("totalUsersCount", result.get("totalUsersCount"));
            }
            if (matchedGUIDList != null) {
                jsonObject.put("matchedGUIDList", (Object)matchedGUIDList);
            }
            jsonObject.put("range", range);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward updateUserWithPhotos(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String uniqueOperationId = request.getParameter("uniqueOperationId");
        String selectedUsersGuidListStr = request.getParameter("selectedUsersGuidList");
        Integer reportId = Integer.parseInt(request.getParameter("reportId"));
        String domainName = request.getParameter("domainName");
        String photoAttributeLdapName = request.getParameter("photoAttributeLdapName");
        String photoAttribColumnName = request.getParameter("photoAttribColumnName");
        try (PrintWriter writer = null;){
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            ModifyPhotoListener mgmtListener = new ModifyPhotoListener();
            mgmtListener.doBulkMgmt(reportId, selectedUsersGuidListStr, uniqueOperationId, photoAttributeLdapName, photoAttribColumnName, request, domainName, loginId, rb);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("message", (Object)"done!");
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward getOperationStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try (PrintWriter writer = null;){
            String uniqueOperationId = request.getParameter("uniqueOperationId");
            boolean isCompleted = false;
            JSONArray resultList = new JSONArray();
            boolean isAllSuccess = true;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String successMessage = rb.getString("admp.mgmt.user_mgmt.photo_mgmt.user_photo_updated_successfully");
            if (uniqueOperationId != null && !uniqueOperationId.trim().equals("")) {
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMPhotoMgmtTempTable"));
                Join join = new Join("ADSMPhotoMgmtTempTable", "ADSMUserGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
                query.addJoin(join);
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
                if (ModifyPhotoListener.operationStatusHash.get(uniqueOperationId) == null) {
                    isCompleted = true;
                    crit = crit.and(new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"RESULT"), null, 1));
                } else {
                    query.addSortColumn(new SortColumn("ADSMPhotoMgmtTempTable", "RESULT", false));
                }
                query.addSortColumn(new SortColumn("ADSMUserGeneralDetails", "DISPLAY_NAME", true));
                query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"UNIQUE_ID"));
                query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"RESULT"));
                query.addSelectColumn(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"SAM_ACCOUNT_NAME"));
                query.addSelectColumn(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DISPLAY_NAME"));
                query.setCriteria(crit);
                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                if (dataObj != null && !dataObj.isEmpty()) {
                    Iterator it = dataObj.getRows("ADSMUserGeneralDetails");
                    while (it.hasNext()) {
                        Row row = (Row)it.next();
                        JSONObject resultData = new JSONObject();
                        resultData.put("SAM_ACCOUNT_NAME", (Object)((String)row.get("SAM_ACCOUNT_NAME")));
                        resultData.put("DISPLAY_NAME", (Object)((String)row.get("DISPLAY_NAME")));
                        String guidStr = (String)row.get("OBJECT_GUID");
                        Row pRow = dataObj.getRow("ADSMPhotoMgmtTempTable", new Criteria(Column.getColumn((String)"ADSMPhotoMgmtTempTable", (String)"OBJECT_GUID"), (Object)guidStr, 0));
                        String result = (String)pRow.get("RESULT");
                        if (result != null && result.equals("SUCCESS")) {
                            result = successMessage;
                        } else {
                            isAllSuccess = false;
                        }
                        resultData.put("RESULT", (Object)(result != null ? result : ""));
                        resultList.put((Object)resultData);
                    }
                }
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("resultDetails", (Object)resultList);
            jsonObject.put("isCompleted", isCompleted);
            jsonObject.put("isAllSuccess", isAllSuccess);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        return null;
    }

    public ActionForward stopBulkPhotoMgmt(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String uniqueOperationId = request.getParameter("uniqueOperationId");
            String opStatus = ModifyPhotoListener.operationStatusHash.get(uniqueOperationId);
            if (opStatus != null) {
                ModifyPhotoListener.operationStatusHash.put(uniqueOperationId, "STOP");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward updateSinglePhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try (PrintWriter writer = null;){
            String sidString = request.getParameter("sidString");
            String objectGuid = request.getParameter("objectGuid");
            String samAccountName = request.getParameter("samAccountName");
            String domainName = request.getParameter("domainName");
            String photoAttribute = request.getParameter("photoAttribute");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            String uniqueOperationId = request.getParameter("uniqueOperationId");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String fileExtn = request.getParameter("fileExtn");
            int x = Integer.parseInt(request.getParameter("x"));
            int y = Integer.parseInt(request.getParameter("y"));
            int w = Integer.parseInt(request.getParameter("w"));
            int h = Integer.parseInt(request.getParameter("h"));
            ModifyPhotoListener mgmtListener = new ModifyPhotoListener();
            JSONObject jsonObject = mgmtListener.updateSinglePhoto(domainName, loginId, reportId, uniqueOperationId, request, sidString, objectGuid, samAccountName, photoAttribute, fileExtn, x, y, w, h, rb);
            writer = response.getWriter();
            response.setContentType("application/json");
            writer.print(jsonObject);
            writer.flush();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward cacheSinglePhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter writer = null;
        String returnMsg = null;
        try {
            FileInputStream fileInputStream = null;
            UploadedFileItem uploadedFileItem = null;
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                String uniqueOperationId = request.getParameter("sm_operationId");
                String objectGuid = request.getParameter("sm_objectGuid");
                String photoAttribute = request.getParameter("sm_photoAttribute");
                String domainName = request.getParameter("sm_domainName");
                AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                uploadedFileItem = (UploadedFileItem)filesList.get(0);
                File file = uploadedFileItem.getUploadedFile();
                String fileName = uploadedFileItem.getFileName();
                Long fileLength = file.length();
                String exchangePhotoFolder = ModifyPhotoListener.getCachedExchPhotoFolder(request, domainName, uniqueOperationId);
                if (photoAttribute.equalsIgnoreCase("thumbnailPhoto") && fileLength > 102400L) {
                    file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)102400, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                } else if (photoAttribute.equalsIgnoreCase("thumbnailLogo") && fileLength > 32767L) {
                    file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)Short.MAX_VALUE, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                } else if ((photoAttribute.equalsIgnoreCase("jpegPhoto") || photoAttribute.equalsIgnoreCase("photo")) && fileLength > 0xA00000L) {
                    file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)0xA00000, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                }
                fileLength = file.length();
                if (returnMsg == null) {
                    byte[] bFile = null;
                    if (photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                        File exchPhoto = new File(exchangePhotoFolder + "\\" + fileName);
                        exchPhoto.mkdirs();
                        if (exchPhoto.exists()) {
                            exchPhoto.delete();
                        }
                        fileInputStream = new FileInputStream(file);
                        bFile = new byte[(int)file.length()];
                        fileInputStream.read(bFile);
                        fileInputStream.close();
                        FileOutputStream fos = new FileOutputStream(exchPhoto);
                        fos.write(bFile);
                        fos.close();
                    } else {
                        File reNFile = new File("..\\\\webapps\\\\adsm\\\\temp\\\\" + uniqueOperationId + fileName);
                        reNFile.mkdirs();
                        if (reNFile.exists()) {
                            reNFile.delete();
                        }
                        FileUtils.copyFile((File)file, (File)reNFile);
                        fileInputStream = new FileInputStream(reNFile);
                        bFile = new byte[(int)reNFile.length()];
                        fileInputStream.read(bFile);
                        fileInputStream.close();
                        if (reNFile.exists()) {
                            reNFile.delete();
                        }
                    }
                    Criteria cri = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtDetails", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(cri);
                    DataObject tempPhotoDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    Row detRow = new Row("ADSMPhotoMgmtDetails");
                    detRow.set("MGMT_UNIQUE_ID", (Object)uniqueOperationId);
                    detRow.set("OPERATION_TIME", (Object)new Date().getTime());
                    Row row = new Row("ADSMPhotoMgmtTempTable");
                    row.set("MGMT_UNIQUE_ID", (Object)uniqueOperationId);
                    row.set("OBJECT_GUID", (Object)objectGuid);
                    if (photoAttribute.equalsIgnoreCase("exchangePhoto")) {
                        detRow.set("PHOTO_FOLDER", (Object)exchangePhotoFolder);
                        row.set("PHOTO_HEX", (Object)"-");
                        row.set("PHOTO_FILE_PATH", (Object)(exchangePhotoFolder + "\\" + fileName));
                    } else {
                        row.set("PHOTO_HEX", (Object)StrUtil.byteArrayToHexString((byte[])bFile));
                    }
                    tempPhotoDataObj.addRow(detRow);
                    tempPhotoDataObj.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(tempPhotoDataObj);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (returnMsg == null) {
                returnMsg = "success";
            }
            writer = response.getWriter();
            response.setContentType("text/html");
            writer.print(returnMsg);
            writer.flush();
            writer.close();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward cachePhotosBeforeImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter writer = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fos = null;
        try {
            UploadedFileItem uploadedFileItem = null;
            JSONArray filesListArr = new JSONArray();
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                String uniqueOperationId = request.getParameter("bm_operationId");
                String photoAttribLdapName = request.getParameter("photoAttribLdapName");
                String domainName = request.getParameter("domainName");
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                String photoFolder = ModifyPhotoListener.getCachedExchPhotoFolder(request, domainName, uniqueOperationId);
                if (filesList.size() > 0) {
                    Criteria photoCrit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtDetails", (String)"MGMT_UNIQUE_ID"), (Object)uniqueOperationId, 0);
                    DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtDetails", photoCrit);
                    if (dataObj.isEmpty()) {
                        dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                        Row row = new Row("ADSMPhotoMgmtDetails");
                        row.set("MGMT_UNIQUE_ID", (Object)uniqueOperationId);
                        row.set("OPERATION_TIME", (Object)new Date().getTime());
                        if (photoAttribLdapName.equalsIgnoreCase("exchangephoto")) {
                            row.set("PHOTO_FOLDER", (Object)photoFolder);
                        }
                        dataObj.addRow(row);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
                    }
                }
                DataObject tempAddDO = null;
                for (int indx = 0; indx < filesList.size(); ++indx) {
                    uploadedFileItem = (UploadedFileItem)filesList.get(indx);
                    String fileName = uploadedFileItem.getFileName();
                    String filePath = "-";
                    File file = uploadedFileItem.getUploadedFile();
                    long fileSizeInBytes = file.length();
                    if (photoAttribLdapName.equalsIgnoreCase("thumbnailPhoto") && fileSizeInBytes > 102400L) {
                        file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)102400, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                    } else if (photoAttribLdapName.equalsIgnoreCase("thumbnailLogo") && fileSizeInBytes > 32767L) {
                        file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)Short.MAX_VALUE, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                    } else if ((photoAttribLdapName.equalsIgnoreCase("jpegPhoto") || photoAttribLdapName.equalsIgnoreCase("photo")) && fileSizeInBytes > 0xA00000L) {
                        file = UserPhotoMgmtUtil.calculateAndResizeFile((File)file, (int)0xA00000, (String)UserPhotoMgmtUtil.getNewUniqueOperationId());
                    }
                    fileSizeInBytes = file.length();
                    tempAddDO = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                    Row row = new Row("ADSMPhotoMgmtImportedPhotos");
                    row.set("MGMT_UNIQUE_ID", (Object)uniqueOperationId);
                    byte[] bFile = new byte[(int)file.length()];
                    fileInputStream = new FileInputStream(file);
                    fileInputStream.read(bFile);
                    if (!photoAttribLdapName.equalsIgnoreCase("exchangephoto")) {
                        row.set("PHOTO_HEX", (Object)StrUtil.byteArrayToHexString((byte[])bFile));
                    } else {
                        filePath = photoFolder + "\\" + fileName;
                        File photoFile = new File(filePath);
                        photoFile.mkdirs();
                        if (photoFile.exists()) {
                            photoFile.delete();
                        }
                        fos = new FileOutputStream(filePath);
                        fos.write(bFile);
                        row.set("PHOTO_HEX", (Object)"-");
                    }
                    row.set("FILE_PATH", (Object)filePath);
                    row.set("FILE_NAME", (Object)fileName.trim());
                    row.set("FILE_LENGTH", (Object)fileSizeInBytes);
                    tempAddDO.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).add(tempAddDO);
                    JSONObject fileObj = new JSONObject();
                    fileObj.put("UNIQUE_ID", (Object)((Long)row.get("UNIQUE_ID")));
                    fileObj.put("FILE_NAME", (Object)fileName.trim());
                    fileObj.put("FILE_LENGTH", file.length());
                    filesListArr.put((Object)fileObj);
                }
            }
            writer = response.getWriter();
            response.setContentType("text/html");
            writer.print(filesListArr);
            writer.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward cachePhotoForLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter writer = null;
        FileInputStream fileInputStream = null;
        FileOutputStream fos = null;
        try {
            UploadedFileItem uploadedFileItem = null;
            JSONObject jsonobj = new JSONObject();
            String fileName = "";
            String filePath = "";
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                File destFile;
                String photoAttribLdapName = request.getParameter("sm_photoAttribute");
                String uniqueOperationId = request.getParameter("bm_operationId");
                String isForLayoutExec = request.getParameter("isForLayoutExecution");
                Boolean isForLayoutExecution = isForLayoutExec != null ? Boolean.parseBoolean(isForLayoutExec) : false;
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                String photoFolder = UserPhotoMgmtUtil.getPhotoFolderPath((int)0, (String)uniqueOperationId);
                if (isForLayoutExecution.booleanValue()) {
                    photoFolder = UserPhotoMgmtUtil.getPhotoFolderPath((int)1, (String)uniqueOperationId);
                }
                if (!(destFile = new File(photoFolder = photoFolder + "\\")).exists()) {
                    destFile.mkdirs();
                } else {
                    File[] fileList;
                    for (File file : fileList = destFile.listFiles()) {
                        if (file.isDirectory()) continue;
                        file.delete();
                    }
                }
                uploadedFileItem = (UploadedFileItem)filesList.get(0);
                fileName = uploadedFileItem.getFileName();
                photoFolder = photoFolder + fileName;
                File file = uploadedFileItem.getUploadedFile();
                FileUtils.copyFileToDirectory((File)file, (File)destFile, (boolean)false);
                File[] fileList = destFile.listFiles();
                File toBeRenamed = new File(photoFolder);
                for (File f : fileList) {
                    if (f.isDirectory()) continue;
                    f.renameTo(toBeRenamed);
                }
                filePath = toBeRenamed.getCanonicalPath();
            }
            jsonobj.put("fileName", (Object)fileName);
            jsonobj.put("filePath", (Object)filePath);
            writer = response.getWriter();
            response.setContentType("text/html");
            writer.print(jsonobj);
            writer.flush();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception e) {}
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {}
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward deleteCachedPhoto(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try (PrintWriter writer = null;){
            String photoUniqueId = request.getParameter("photoUniqueId");
            if (photoUniqueId != null) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMPhotoMgmtImportedPhotos", (String)"UNIQUE_ID"), (Object)new Long(photoUniqueId), 0);
                DataObject photoDO = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMPhotoMgmtImportedPhotos", crit);
                if (!photoDO.isEmpty()) {
                    Row r = photoDO.getRow("ADSMPhotoMgmtImportedPhotos");
                    String filePath = (String)r.get("FILE_PATH");
                    if (filePath != null && !filePath.equals("-")) {
                        File file = new File(filePath);
                        file.delete();
                    }
                    CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
                }
            }
            writer = response.getWriter();
            response.setContentType("text/html");
            writer.print(photoUniqueId);
            writer.flush();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActionForward refreshUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try (PrintWriter writer = null;){
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            String photoAttribName = request.getParameter("photoAttribName");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"User"});
            String photoFolder = ModifyPhotoListener.getPhotoFolder(request, domainName, photoAttribName);
            File photoFolderObj = new File(photoFolder);
            photoFolderObj.mkdirs();
            FileUtils.cleanDirectory((File)photoFolderObj);
            writer = response.getWriter();
            response.setContentType("text/html");
            writer.print("Success!!");
            writer.flush();
        }
        return null;
    }

    public ActionForward exportResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            String uniqueOperationId = request.getParameter("uniqueOperationId");
            String exportType = request.getParameter("exportType");
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String jasperXmlFile = "ModifyUser.xml";
            String reportName = rb.getString("admp.mgmt.user_mgmt.export.modify_photo_attribute");
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("domain", domainName);
            inputParams.put("loginId", loginId);
            inputParams.put("domainTxt", rb.getString("admp.common.text.domain"));
            inputParams.put("actionTxt", rb.getString("admp.deleg.hdt_deleg.cre_hdt.text_action"));
            inputParams.put("modifyType", reportName);
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            ArrayList attributeList = ReportAttributeHandler.getInstance().getModifiedColumns(reportId);
            ArrayList list = ModifyPhotoListener.getUserInfoForExport(uniqueOperationId, attributeList, rb);
            Properties props = new Properties();
            props.put("ATTRIB_COLUMN_NAME", "STATUS");
            props.put("ATTRIB_DISP_NAME", rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.status"));
            props.put("ATTRIB_LDAP_NAME", "status");
            props.put("ATTRIB_ID", (Object)100000);
            props.put("RELATIONAL_TYPE", (Object)0);
            attributeList.add(props);
            Hashtable multipleValuesSids = new Hashtable();
            ReportJRDataSource dataSource = new ReportJRDataSource(list, multipleValuesSids, exportType);
            jasperXmlFile = request.getSession().getServletContext().getRealPath("/") + "jasperreports" + File.separator + "jrxml" + File.separator + jasperXmlFile;
            JasperDesign jasperDesign = JRXmlLoader.load((String)jasperXmlFile);
            request.setAttribute("jasperXmlFile", (Object)jasperXmlFile);
            String exportFileName = "ModifyPhotoResult";
            if (exportType.toLowerCase().indexOf("xls") != -1 || exportType.toLowerCase().indexOf("csv") != -1) {
                JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                JRElement[] elements = titleBand.getElements();
                for (int i = 0; i < elements.length; ++i) {
                    titleBand.removeElement((JRDesignElement)elements[i]);
                }
                titleBand.setHeight(0);
                JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                JRElement[] elements1 = pageHeaderBand.getElements();
                for (int i = 0; i < elements1.length; ++i) {
                    pageHeaderBand.removeElement((JRDesignElement)elements1[i]);
                }
                pageHeaderBand.setHeight(0);
                JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                JRElement[] elements2 = pageFooterBand.getElements();
                for (int i = 0; i < elements2.length; ++i) {
                    pageFooterBand.removeElement((JRDesignElement)elements2[i]);
                }
                pageFooterBand.setHeight(0);
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            } else if (exportType.toLowerCase().indexOf("html") != -1 || exportType.toLowerCase().indexOf("pdf") != -1) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable columnWidths = JRDesignUtil.calculateWidth(attributeList, list, multipleValuesSids, exportType, request, rb);
            JRDesignUtil.fillBand(jasperDesign, headerBand, detailBand, attributeList, exportType, rb, loginId, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            JasperPrint print = null;
            try {
                print = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
                print.setName(exportFileName);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.INFO, "Input Params After Filling " + inputParams);
                return null;
            }
            ReportExportUtil.exportReport(exportType, request, response, print, exportFileName, loginId);
            if (PrivacyHandler.getInstance().isExportAuditEnabled().booleanValue()) {
                DataImportExportAudit.auditDataFlow((Long)System.currentTimeMillis(), (Long)loginId, (String)HelpdeskUtil.getLoginUserName((Long)loginId), (String)request.getRemoteAddr(), (String)"admp.deleg.hdt_deleg.cre_role.text.ad_management", (String)"admp.mgmt.user_mgmt.export.modify_photo_attribute", (Integer)reportId, (String)"-", (Boolean)Boolean.FALSE, (String)(exportFileName + exportType), (String)exportType.toLowerCase(), (String)"-", (Integer)list.size());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }
}

