/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;

public class ModifySecurityAttributeListener
extends ModifyUserListener {
    public ModifySecurityAttributeListener() {
        this.reportId = new Integer(1002);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, AdmpInput admpInput, NativeListener listener, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        HashMap<String, String> props = new HashMap<String, String>();
        Integer mgmtID = Integer.parseInt(admpInput.getValue());
        if (mgmtID == RVCConstants.RV_MGMT_DISABLEUSER_ID) {
            props.put("accountEnableDisable", "disable");
        } else if (mgmtID == RVCConstants.RV_MGMT_ENABLEUSER_ID) {
            props.put("accountEnableDisable", "Enable");
        }
        return this.modifyUser(result, attributeList, props, listener, domainName, loginId, audit_info, auditDataObj);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        ModifyUserListener listener = (ModifyUserListener)bean.getListener();
        BeanMap props = (BeanMap)bean.get("props");
        return this.modifyUser(result, attributeList, props, (NativeListener)listener, domainName, loginId, audit_info, auditDataObj);
    }

    private String modifyUser(Hashtable result, ArrayList attributeList, HashMap props, NativeListener listener, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1014L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String accountUnLock;
            String accountEnableDisable;
            String accountStatus = "";
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            String name = this.getValue(result, 1005);
            String objGuid = (String)result.get("OBJECT_GUID");
            String guid = objGuid.substring(objGuid.indexOf("{") + 1, objGuid.indexOf("}"));
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
            ArrayList winNTProviderList = new ArrayList();
            int userAccountControl = 0;
            int andUserAccountControl = 0xFFFFFFF;
            boolean disableUserTask = false;
            String accountExpires = (String)props.get("accountExpires");
            if (accountExpires != null && !accountExpires.equals("--") && ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1209L)) {
                Properties p = new Properties();
                p.put("DATA_HANDLER_TYPE", new Long(10L));
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", "accountExpires");
                Long expireTime = new Long(0L);
                if (accountExpires.equals("End Of")) {
                    String s = (String)props.get("expireTime");
                    StringTokenizer dateTokenizer = new StringTokenizer(s, "-");
                    int count = dateTokenizer.countTokens();
                    int[] dateArray = new int[count];
                    for (int i = 0; i < count; ++i) {
                        dateArray[i] = Integer.parseInt(dateTokenizer.nextToken());
                    }
                    Calendar calendar = Calendar.getInstance();
                    calendar.set(dateArray[0], dateArray[1] - 1, dateArray[2], 0, 0, 0);
                    calendar.set(14, 0);
                    expireTime = DateTimeUtil.getFileTimeFromSystemTime((Long)calendar.getTimeInMillis());
                    logger.log(Level.INFO, "ACCOUNT_EXPIRY_DATE in File Time :" + expireTime);
                }
                p.put("ATTRIB_VALUE", expireTime);
                setAttributeList.add(p);
            }
            if ((accountEnableDisable = (String)props.get("accountEnableDisable")) != null && !accountEnableDisable.equals("--") && ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1208L)) {
                if (props.get("accountEnableDisable").equals("Enable")) {
                    andUserAccountControl &= 0xFFFFFD;
                    accountStatus = this.rb.getString("admp.ad_explorer.view_props.user.common.statmsg.enabled");
                } else {
                    userAccountControl |= 2;
                    accountStatus = this.rb.getString("admp.ad_explorer.view_props.user.common.statmsg.disabled");
                    disableUserTask = true;
                }
            }
            if ((accountUnLock = (String)props.get("accountUnLock")) != null && accountUnLock.equals("Yes")) {
                andUserAccountControl &= 0xFFFFFEF;
            }
            logger.log(Level.INFO, "userAccountControl : " + userAccountControl + " andUserAccountControl : " + andUserAccountControl);
            if (userAccountControl != 0 || andUserAccountControl != 0xFFFFFFF) {
                Properties p1 = new Properties();
                p1.put("DATA_HANDLER_TYPE", new Long(7L));
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("ATTRIB_LDAP_NAME", "userAccountControl");
                p1.put("ATTRIB_VALUE", String.valueOf(userAccountControl));
                p1.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
                modifyAttributeList.add(p1);
            }
            logger.log(Level.INFO, " MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList + " MODIFY ATTRIBUTELIST : " + modifyAttributeList + " WIN NT LIST : " + winNTProviderList);
            String disablePolicyMsg = "";
            try {
                if (setAttributeList.size() != 0 || modifyAttributeList.size() != 0 || winNTProviderList.size() != 0) {
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)name, setAttributeList, modifyAttributeList, winNTProviderList, (ArrayList)attributeList, (NativeListener)listener);
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"));
                    }
                    HashMap policyStatusMap = new HashMap();
                    if (disableUserTask) {
                        Integer dnId;
                        String ou = this.getValue(result, 1012);
                        if (ou == null || ou.equals("")) {
                            ou = StrUtil.getContainerDNFromDN((String)dn);
                            result.put(1012, ou);
                        }
                        if ((dnId = UserMgmtUtil.getAttributeId((String)"distinguishedName")) != null) {
                            result.put(dnId, dn);
                        }
                        disablePolicyMsg = DeleteUtil.executeDisablePolicyTasks(domainName, loginId, guid, dn, sid, result, this.rb, policyStatusMap);
                        if (policyStatusMap.size() > 0) {
                            CommonUtil.getAttributeModified(policyStatusMap, modifyAttributeList, (AdventNetResourceBundle)this.rb);
                            this.guidVsPolicyStatusMap.put(objGuid, policyStatusMap);
                            audit_info.put("auditMessage", disablePolicyMsg);
                        }
                    }
                    if (policyStatusMap.isEmpty()) {
                        this.guidVsPolicyStatusMap.remove(objGuid);
                    }
                } else {
                    message.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
            }
            if (!accountStatus.equals("")) {
                Properties p2 = (Properties)modifyAttributeList.get(0);
                p2.put("ATTRIB_LDAP_NAME", "UserAccountStatus");
                p2.put("ATTRIB_VALUE", accountStatus);
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.account_attrib"), this.getValue(result, 1010), domainName, setAttributeList, modifyAttributeList, new ArrayList(), message.toString() + disablePolicyMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

