/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.iam.GAppsUtil;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.objects.DirectoryObjectAPI;
import com.adventnet.sym.adsm.common.server.refresh.RefreshListener;
import com.adventnet.sym.adsm.common.server.refresh.WAADRefreshListener;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.OUHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.ContactUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DeprovisionUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.layout.gapps.GappsMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ModifySingleAction
extends DispatchAction {
    public ActionForward modifySingleUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String action;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long actionId = null;
        String tileName = action = (String)((DynaActionForm)form).get("action");
        String waadTenantId = "";
        if (action.equalsIgnoreCase("modifyPassword")) {
            actionId = 1277L;
        } else if (action.equalsIgnoreCase("modifyContactList")) {
            actionId = DelegationUtil.MODIFY_SINGLE_CONTACT_ACTION_ID;
        } else if (action.equalsIgnoreCase("copyObjectList")) {
            actionId = DelegationUtil.CREATE_SINLGLE_USER_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifyGroupList")) {
            actionId = DelegationUtil.MODIFY_SINGLE_GROUP_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifySharedMailboxList")) {
            actionId = DelegationUtil.MODIFY_SHARED_MAILBOX_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifyRoomMailboxList")) {
            actionId = DelegationUtil.MODIFY_ROOM_MAILBOX_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifyEquipmentMailboxList")) {
            actionId = DelegationUtil.MODIFY_EQUIPMENT_MAILBOX_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifyOUList")) {
            actionId = DelegationUtil.MODIFY_OU_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifyO365GroupList")) {
            ADMPAuthObject admpAuthObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList waadTenantIdList = O365MgmtHandler.getO365WaadTenantIdList((ADMPAuthObject)admpAuthObj);
            if (request.getParameter("waadTenantId") != null) {
                waadTenantId = request.getParameter("waadTenantId");
            } else if (waadTenantIdList != null && waadTenantIdList.size() > 0) {
                waadTenantId = (String)waadTenantIdList.get(0);
            }
            request.setAttribute("waadTenantIdList", (Object)waadTenantIdList);
            request.setAttribute("waadTenantId", (Object)waadTenantId);
        } else {
            actionId = DelegationUtil.MODIFY_SINGLE_USER_ACTION_ID;
        }
        ArrayList domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, actionId);
        if (request.getParameter("mode") != null && request.getParameter("mode").equalsIgnoreCase("workflow")) {
            domainList = WorkFlowUserHandler.getAuthorizedDomainList((Long)loginId, (Long)actionId);
        }
        Properties prop = HDTDomainHandler.getSelectedDomain((Long)loginId);
        String selectedDomainName = (String)prop.get("DOMAIN_NAME");
        String domainName = "";
        if (request.getParameter("domain") != null) {
            domainName = request.getParameter("domain");
        } else if (!domainList.isEmpty()) {
            domainName = selectedDomainName != null && domainList.contains(selectedDomainName) ? selectedDomainName : (String)domainList.get(0);
        }
        int startIndex = 0;
        String rangeStr = request.getParameter("RANGE");
        String startIndexStr = request.getParameter("FROM_INDEX");
        String isNavigate = request.getParameter("isNavigate");
        Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "SingleModification", loginId);
        request.setAttribute("RANGE", (Object)range);
        if (startIndexStr != null) {
            startIndex = Integer.parseInt(startIndexStr);
        }
        String searchPattern = "";
        if (request.getParameter("searchChar") != null) {
            String s = request.getParameter("searchChar");
            searchPattern = s + "*";
            request.setAttribute("searchChar", (Object)s);
        } else if (request.getParameter("searchText") != null) {
            String searchTextStr = request.getParameter("searchText");
            String searchText = searchTextStr.replaceAll("\\\\", "\\\\\\\\");
            searchText = DBUtil.escapeDBWildChars((String)searchText);
            boolean flag = false;
            for (int i = 0; i < searchText.length(); ++i) {
                if (searchText.charAt(i) != '*') continue;
                flag = true;
            }
            searchPattern = flag ? searchText : "*" + searchText + "*";
            request.setAttribute("searchText", (Object)searchTextStr);
        }
        ArrayList ouList = new ArrayList();
        Boolean isWorkFlow = false;
        if (request.getParameter("mode") != null && request.getParameter("mode").equalsIgnoreCase("workflow")) {
            ouList = WFRequesterUtil.getOUListWithExcludeChildCheck((String)domainName, (long)loginId, (Boolean)WFRequesterUtil.isExcludeChildOu((String)domainName, (Long)loginId));
            isWorkFlow = true;
        } else {
            ouList = HelpdeskUtil.getEscapedOUDNList((String)domainName, (Long)loginId);
        }
        ouList = DirectoryObjectUtil.getParentOUs((ArrayList)ouList);
        ArrayList userList = new ArrayList();
        Integer count = 0;
        if (action.equalsIgnoreCase("modifyContactList")) {
            userList = ContactUserHandler.getContactList((String)domainName, (String)searchPattern, (int)startIndex, (int)range, (ArrayList)ouList);
            count = ContactUserHandler.getContactCount((String)domainName, (String)searchPattern, (ArrayList)ouList);
        } else if (action.equalsIgnoreCase("modifyOUList")) {
            ArrayList<ArrayList> ouArrayList = new ArrayList<ArrayList>();
            ouArrayList.add(ouList);
            if (searchPattern.equals("")) {
                searchPattern = null;
            }
            userList = OUHandler.getOUsList((String)domainName, (String)searchPattern, (int)startIndex, (int)range, (Long)loginId, ouArrayList, null, null);
            count = OUHandler.getSUMOUCount((String)domainName, (String)searchPattern, ouArrayList);
        } else if (action.equalsIgnoreCase("modifySharedMailboxList")) {
            String SHARED_MAILBOX_RECIPIENT_TYPE = "4";
            userList = ExchangeHandler.getMailboxObjectForModification((String)searchPattern, (String)domainName, (int)startIndex, (int)range, (ArrayList)ouList, null, (String[])new String[]{SHARED_MAILBOX_RECIPIENT_TYPE}, (String)request.getParameter("sortColumn"), (String)request.getParameter("sortOrder"));
            count = ExchangeHandler.getMailBoxesCount((String)searchPattern, (String)domainName, (ArrayList)ouList, null, (String[])new String[]{SHARED_MAILBOX_RECIPIENT_TYPE});
        } else if (action.equalsIgnoreCase("modifyRoomMailboxList")) {
            String ROOM_MAILBOX_RECIPIENT_TYPE = "16";
            userList = ExchangeHandler.getMailboxObjectForModification((String)searchPattern, (String)domainName, (int)startIndex, (int)range, (ArrayList)ouList, null, (String[])new String[]{ROOM_MAILBOX_RECIPIENT_TYPE}, (String)request.getParameter("sortColumn"), (String)request.getParameter("sortOrder"));
            count = ExchangeHandler.getMailBoxesCount((String)searchPattern, (String)domainName, (ArrayList)ouList, null, (String[])new String[]{ROOM_MAILBOX_RECIPIENT_TYPE});
        } else if (action.equalsIgnoreCase("modifyEquipmentMailboxList")) {
            String EQUIPMENT_MAILBOX_RECIPIENT_TYPE = "32";
            userList = ExchangeHandler.getMailboxObjectForModification((String)searchPattern, (String)domainName, (int)startIndex, (int)range, (ArrayList)ouList, null, (String[])new String[]{EQUIPMENT_MAILBOX_RECIPIENT_TYPE}, (String)request.getParameter("sortColumn"), (String)request.getParameter("sortOrder"));
            count = ExchangeHandler.getMailBoxesCount((String)searchPattern, (String)domainName, (ArrayList)ouList, null, (String[])new String[]{EQUIPMENT_MAILBOX_RECIPIENT_TYPE});
        } else if (action.equalsIgnoreCase("modifyO365GroupList")) {
            if (searchPattern.equals("")) {
                searchPattern = null;
            }
            ADMPAuthObject admpAuthObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            userList = O365MgmtHandler.getO365GroupsList((String)waadTenantId, (String)searchPattern, (int)startIndex, (int)range, (String[])new String[]{"MailUniversalSecurityGroup", "MailUniversalDistributionGroup"}, (ADMPAuthObject)admpAuthObj);
            count = O365MgmtHandler.getO365GroupsCount((String)waadTenantId, (String)searchPattern, (String[])new String[]{"MailUniversalSecurityGroup", "MailUniversalDistributionGroup"}, (ADMPAuthObject)admpAuthObj);
        }
        request.setAttribute("domainList", (Object)domainList);
        request.setAttribute("domainName", (Object)domainName);
        request.setAttribute("selectedDomain", (Object)domainName);
        request.setAttribute("userList", (Object)userList);
        request.setAttribute("count", (Object)count);
        request.setAttribute("action", (Object)action);
        return mapping.findForward(tileName);
    }

    /*
     * WARNING - void declaration
     */
    public ActionForward showUserResultList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        void var23_34;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String action = request.getParameter("action");
        Long actionId = 0L;
        String tileName = (String)((DynaActionForm)form).get("action");
        if (action.equalsIgnoreCase("modifyGroupList")) {
            actionId = DelegationUtil.MODIFY_SINGLE_GROUP_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifyUserList")) {
            actionId = DelegationUtil.MODIFY_SINGLE_USER_ACTION_ID;
        } else if (action.equalsIgnoreCase("modifyOUList")) {
            actionId = DelegationUtil.MODIFY_OU_ACTION_ID;
        }
        ArrayList<String> domainList = ClientAuthorizationUtil.getAuthorizedDomainList(request, actionId);
        Properties prop = HDTDomainHandler.getSelectedDomain((Long)loginId);
        String selectedDomainName = (String)prop.get("DOMAIN_NAME");
        ArrayList<String> selectedDomainList = new ArrayList<String>();
        if (request.getParameter("domain") != null) {
            String selectedDomains = request.getParameter("domain");
            JSONArray jsonArray = new JSONArray(selectedDomains);
            for (int i = 0; i < jsonArray.length(); ++i) {
                selectedDomainList.add(jsonArray.getString(i));
            }
        } else if (!domainList.isEmpty()) {
            if (selectedDomainName != null && domainList.contains(selectedDomainName)) {
                selectedDomainList.add(selectedDomainName);
            } else {
                selectedDomainList.add(domainList.get(0));
            }
        }
        int startIndex = 0;
        Integer range = 0;
        String pageNavigationStr = request.getParameter("pageNavigation");
        if (pageNavigationStr != null) {
            JSONObject pageNavigation = new JSONObject(pageNavigationStr);
            startIndex = pageNavigation.getInt("startIndex");
            String rangeStr = pageNavigation.getString("range");
            String isNavigate = pageNavigation.getString("isNavigate");
            range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "SingleModification", loginId);
            request.setAttribute("RANGE", (Object)range);
        }
        String searchPattern = "";
        request.setAttribute("action", (Object)action);
        String s = request.getParameter("searchChar");
        request.setAttribute("searchChar", (Object)s);
        String searchTextStr = request.getParameter("searchText");
        request.setAttribute("searchText", (Object)searchTextStr);
        if (s != null) {
            searchPattern = s + "*";
        } else if (request.getParameter("searchText") != null) {
            String searchText = searchTextStr.replaceAll("\\\\", "\\\\\\\\");
            searchText = DBUtil.escapeDBWildChars((String)searchText);
            boolean flag = false;
            for (int i = 0; i < searchText.length(); ++i) {
                if (searchText.charAt(i) != '*') continue;
                flag = true;
            }
            searchPattern = flag ? searchText : "*" + searchText + "*";
        }
        ArrayList<ArrayList> ouList = new ArrayList<ArrayList>();
        Boolean isWorkFlow = false;
        if (request.getParameter("mode") != null && request.getParameter("mode").equalsIgnoreCase("workflow")) {
            for (Object e : selectedDomainList) {
                ouList.add(DirectoryObjectUtil.getParentOUs((ArrayList)WFRequesterUtil.getOUListWithExcludeChildCheck((String)((String)e), (long)loginId, (Boolean)WFRequesterUtil.isExcludeChildOu((String)((String)e), (Long)loginId))));
            }
            isWorkFlow = true;
        } else {
            for (Object e : selectedDomainList) {
                ouList.add(DirectoryObjectUtil.getParentOUs((ArrayList)HelpdeskUtil.getEscapedOUDNList((String)((String)e), (Long)loginId)));
            }
        }
        ArrayList userList = new ArrayList();
        Integer n = 0;
        String forward = "";
        if (action.equalsIgnoreCase("modifyUserList") || action.equalsIgnoreCase("modifyPassword")) {
            userList = UserHandler.getSUMUserList(selectedDomainList, (String)searchPattern, (int)startIndex, (int)range, ouList, (String)request.getParameter("sortColumn"), (String)request.getParameter("sortOrder"), (Boolean)isWorkFlow, (long)loginId);
            Integer n2 = UserHandler.getSUMUserCount(selectedDomainList, (String)searchPattern, ouList, (Boolean)isWorkFlow, (long)loginId);
        } else if (action.equalsIgnoreCase("modifyGroupList")) {
            userList = GroupHandler.getSUMGroupsList(selectedDomainList, (String)searchPattern, (int)startIndex, (int)range, (Long)loginId, ouList, (String)request.getParameter("sortColumn"), (String)request.getParameter("sortOrder"), (boolean)isWorkFlow);
            Integer n3 = GroupHandler.getSUMGroupCount(selectedDomainList, (String)searchPattern, ouList, (Long)loginId, (boolean)isWorkFlow);
        } else if (action.equalsIgnoreCase("modifyOUList")) {
            userList = OUHandler.getOUsList(selectedDomainList, (String)searchPattern, (int)startIndex, (int)range, (Long)loginId, ouList, (String)request.getParameter("sortColumn"), (String)request.getParameter("sortOrder"));
            Integer n4 = OUHandler.getSUMOUCount(selectedDomainList, (String)searchPattern, ouList);
        }
        request.setAttribute("domainList", domainList);
        request.setAttribute("userList", (Object)userList);
        request.setAttribute("count", (Object)var23_34);
        request.setAttribute("navigationConfig", (Object)ModifySingleAction.getDefaultNavigationConfig(loginId));
        return mapping.findForward("modifyUserResultList");
    }

    public ActionForward deleteUserObject(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer message = new StringBuffer();
        String messageType = "";
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ArrayList<String> objectOUList = new ArrayList<String>();
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String hostId = request.getRemoteHost();
            Hashtable resultList = new Hashtable();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)1026, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
            String domainName = request.getParameter("domain");
            String guid = request.getParameter("user");
            guid = "{" + guid + "}";
            Hashtable<Object, String> result = new Hashtable<Object, String>();
            result.put("OBJECT_GUID", guid);
            result.put("batchName", "ADMP_EXPORT_" + System.currentTimeMillis());
            Row r = DirectoryObjectAPI.getInstance().getObject(guid, "user");
            String samAccountName = (String)r.get("SAM_ACCOUNT_NAME");
            result.put(1006, samAccountName);
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)samAccountName, (String)domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("distinguishedName");
            guid = guid.substring(guid.indexOf("{") + 1, guid.lastIndexOf("}"));
            Properties prop = ADHandler.getObjectFromGUID((String)domainName, (Long)loginId, (String)guid, attribList);
            try {
                ArrayList dnList = (ArrayList)prop.get("distinguishedName");
                String dn = (String)dnList.get(0);
                String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dn);
                objectOUList.add(ouName);
                result.put(1012, ouName);
                Integer dnId = UserMgmtUtil.getAttributeId((String)"distinguishedName");
                if (dnId != null) {
                    result.put(dnId, dn);
                }
                messageType = "SUCCESS";
                message = DeleteUtil.deleteUser(domainName, loginId, dn, guid, result, rb);
            }
            catch (LocalizedException e) {
                e.printStackTrace();
                messageType = "ERROR";
                message = new StringBuffer(rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.unable_delete_user") + e.getMessage(rb));
            }
            catch (Exception e) {
                e.printStackTrace();
                messageType = "ERROR";
                message = new StringBuffer(rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.unable_delete_user") + e.getMessage());
            }
            if (message == null) {
                message = new StringBuffer();
                messageType = "SUCCESS";
                message.append(rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.successfully_deleted_user"));
            }
            if (messageType.equals("SUCCESS")) {
                auditObjectIdList.add(object_id);
            }
            audit_info.put("error_msg", message.toString());
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.user_mgmt.mgmtname.delete_user"), (String)r.get("SAM_ACCOUNT_NAME"), domainName, message.toString(), rb);
            if (auditObjectIdList.size() > 0) {
                MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                notifyListener.triggerNotification(auditDataObj, auditObjectIdList, Integer.valueOf(1), resultList, loginId, ReportsUtil.DELETE_USER_REPORT_ID, domainName, rb, null, objectOUList);
            }
        }
        catch (Exception e) {
            message = new StringBuffer();
            messageType = "ERROR";
            message.append(rb.getString("admp.mgmt.user_mgmt.del_users.statmsg.unable_delete_user"));
            e.printStackTrace();
        }
        JSONObject jsonObj = new JSONObject();
        jsonObj.put("message", (Object)message);
        jsonObj.put("messageType", (Object)messageType);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(jsonObj.toString());
        return null;
    }

    public ActionForward resetPassword(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        StringBuffer message = null;
        String pwdDetails = null;
        String pwdString = null;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Logger logger = Logger.getLogger("ADMangLogger");
        try {
            boolean isSuccess = false;
            boolean changePasswordAtNextLogin = false;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String hostId = request.getRemoteHost();
            Hashtable resultList = new Hashtable();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            ArrayList<String> objectOUList = new ArrayList<String>();
            DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Long audit_id = HDTAuditUtil.fillAuditDetails((Long)loginId, (String)hostId, (Integer)1019, (DataObject)auditDataObj, (AdventNetResourceBundle)rb);
            String domainName = request.getParameter("domain");
            String guid = request.getParameter("user");
            String password = request.getParameter("password");
            String random = request.getParameter("randomPwd");
            Row r = DirectoryObjectAPI.getInstance().getObject(guid, "user");
            String dnValue = (String)r.get("DISTINGUISHED_NAME");
            String ouName = DirectoryObjectUtil.getOUNameFromDN((String)dnValue);
            if (!objectOUList.contains(ouName)) {
                objectOUList.add(ouName);
            }
            if (random.equalsIgnoreCase("true")) {
                PasswordPolicy pwdPolicy = new PasswordPolicy();
                pwdPolicy.setPolicyDetails();
                password = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
            }
            String name = (String)r.get("SAM_ACCOUNT_NAME");
            Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)name, (String)domainName, (DataObject)auditDataObj);
            Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
            audit_info.put("object_id", object_id);
            Hashtable<String, String> managerAndPwd = new Hashtable<String, String>();
            if (password != null && !password.equals("")) {
                managerAndPwd.put("password", password);
            }
            if (name != null && !name.equals("")) {
                resultList.put(name, managerAndPwd);
            }
            if (password != null && !password.equals("") || random.equalsIgnoreCase("true")) {
                if (random.equalsIgnoreCase("true") && !ClientUtil.checkAuthorization(request, 1273L) || !random.equalsIgnoreCase("true") && !ClientUtil.checkAuthorization(request, 1274L)) {
                    message = new StringBuffer(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                } else {
                    try {
                        MgmtUtil.resetPassword(domainName, (String)r.get("SID_STRING"), (String)r.get("DISTINGUISHED_NAME"), (String)r.get("SAM_ACCOUNT_NAME"), password, request, audit_info, auditDataObj);
                        isSuccess = true;
                        auditObjectIdList.add((Long)audit_info.get("object_id"));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        message = new StringBuffer(e.getMessage());
                    }
                }
            }
            if (message == null) {
                HashMap<String, String> resetPasswordProps = new HashMap<String, String>();
                String mustChangePassword = "No";
                if (request.getParameter("mustChangePassword").equalsIgnoreCase("true")) {
                    changePasswordAtNextLogin = true;
                    mustChangePassword = "Yes";
                    resetPasswordProps.put("mustChangePassword", mustChangePassword);
                } else if (request.getParameter("mustChangePassword").equalsIgnoreCase("false")) {
                    resetPasswordProps.put("mustChangePassword", mustChangePassword);
                }
                resetPasswordProps.put("cantChangePassword", "--");
                resetPasswordProps.put("passwordNeverExpires", "--");
                try {
                    MgmtUtil.modifyPasswordAttributes(domainName, (String)r.get("SID_STRING"), (String)r.get("DISTINGUISHED_NAME"), (String)r.get("SAM_ACCOUNT_NAME"), resetPasswordProps, request, audit_info, auditDataObj);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    message = new StringBuffer();
                    message.append(e.getMessage());
                }
                if ("false".equalsIgnoreCase(request.getParameter("accountLockedOut"))) {
                    try {
                        MgmtUtil.unlock(domainName, (String)r.get("SID_STRING"), (String)r.get("DISTINGUISHED_NAME"), (String)r.get("SAM_ACCOUNT_NAME"), password, request, audit_info, auditDataObj);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        message = new StringBuffer();
                        message.append(e.getMessage());
                    }
                }
            }
            if (message == null) {
                message = new StringBuffer();
                message.append(rb.getString("admp.mgmt.user_mgmt.modify_single_user.status_msg.success"));
                if (random.equalsIgnoreCase("true")) {
                    pwdString = rb.getString("admp.user_mgmt.hdt_reset_pwd.text.pwd") + " : ";
                    pwdDetails = password;
                }
            }
            if (isSuccess) {
                String objectId;
                HashMap policyMap = DeprovisionUtil.getResetPasswordPolicyMap((String)domainName);
                if (Boolean.valueOf((String)policyMap.get("reset_password_google_apps")).booleanValue() && (objectId = GAppsUtil.getObjectId((String)guid)) != null && objectId != "") {
                    logger.log(Level.INFO, "Start: Reset Password in Google Apps");
                    if (GappsMgmtUtil.resetPassword(domainName, loginId, objectId, password, changePasswordAtNextLogin)) {
                        logger.log(Level.INFO, "Password reset successful in Google Apps");
                        message.append(" " + rb.getString("admp.mgmt.user_mgmt.reset_password_google_apps.statmsg_successful"));
                    } else {
                        message.append(" " + rb.getString("admp.mgmt.user_mgmt.reset_password_google_apps.statmsg_failure"));
                        logger.log(Level.INFO, "Could not reset password in Google Apps");
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("reset_password_in_o365")).booleanValue()) {
                    message.append(DeleteUtil.resetO365UserPwd(domainName, loginId, guid, password, changePasswordAtNextLogin, -1, rb));
                }
            }
            audit_info.put("error_msg", message.toString());
            HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
            if (auditObjectIdList.size() > 0) {
                MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                notifyListener.triggerNotification(auditDataObj, auditObjectIdList, Integer.valueOf(1), resultList, loginId, ReportsUtil.RESET_PASSWORD_REPORT_ID, domainName, rb, null, objectOUList);
            }
        }
        catch (Exception e) {
            message = new StringBuffer();
            message.append(rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.error_changing_password"));
            e.printStackTrace();
        }
        String statMsg = message.toString();
        if (statMsg != null) {
            statMsg = ClientUtil.getSplitString(statMsg, 25);
        }
        ModifySingleAction.getMsgXMLElement(response, statMsg, pwdString, pwdDetails);
        return null;
    }

    public static void getMsgXMLElement(HttpServletResponse response, String message, String pwdString, String pwdDetails) {
        ByteArrayOutputStream outNode = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            Element Message = document.createElement("message");
            Message.setAttribute("MESSAGE", message);
            Message.setAttribute("PASSWORDSTRING", pwdString);
            Message.setAttribute("PASSWORDVALUE", pwdDetails);
            data.appendChild(Message);
            response.setContentType("text/xml");
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward refreshUserList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"User"});
    }

    public ActionForward refreshSharedMailboxList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"MAILBOX"});
    }

    public ActionForward refreshRoomMailboxList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"MAILBOX"});
    }

    public ActionForward refreshEquipmentMailboxList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"MAILBOX"});
    }

    public ActionForward refreshContactList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"CONTACT"});
    }

    public ActionForward refreshGroupList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"Group"});
    }

    public ActionForward refreshO365GroupList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"o365group"});
    }

    public ActionForward refreshOUList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return this.refreshObjectList(mapping, form, request, response, new String[]{"organizationalUnit"});
    }

    public ActionForward refreshObjectList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response, String[] objectType) {
        String[] domains;
        String domainStr = request.getParameter("domainName");
        for (String domainName : domains = domainStr.split(",")) {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String searchPattern = "";
            if (request.getParameter("searchChar") != null && !request.getParameter("searchChar").equals("")) {
                String s = request.getParameter("searchChar");
                searchPattern = s + "*";
            } else if (request.getParameter("searchText") != null && !request.getParameter("searchText").equals("")) {
                String searchText = request.getParameter("searchText");
                searchPattern = searchText.indexOf(42) != -1 ? searchText : "*" + searchText + "*";
            }
            if (searchPattern.equals("")) {
                searchPattern = "*";
            }
            Locale locale = request.getLocale();
            RefreshListener li = null;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            if (objectType != null && Arrays.asList(objectType).contains("MAILBOX")) {
                ExchangeHandler.addMailBoxObjects((String)domainName, (Long)loginId, (boolean)true);
                li = new RefreshListener(CommonUtil.ADMIN_LOGIN_ID, domainName, "user", rb);
                li.refresh(searchPattern);
                continue;
            }
            if (objectType != null && Arrays.asList(objectType).contains("User")) {
                DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])objectType);
                continue;
            }
            if (objectType != null && Arrays.asList(objectType).contains("Group")) {
                DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])objectType);
                continue;
            }
            if (objectType != null && Arrays.asList(objectType).contains("CONTACT")) {
                DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])objectType);
                continue;
            }
            if (objectType != null && Arrays.asList(objectType).contains("o365group")) {
                int reportId = 48;
                String message = null;
                ADMPAuthObject admpAuthObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                Properties waadAccountProps = DomainInfoCache.getInstance().getWAADDomainProperties(domainName);
                String tenantId = (String)waadAccountProps.get("WAAD_TENANT_ID");
                long domainId = (Long)waadAccountProps.get("WAAD_DOMAIN_ID");
                WAADRefreshListener sidRefreshListener = new WAADRefreshListener(CommonUtil.ADMIN_LOGIN_ID, tenantId, "o365group", 67, rb);
                String msg = sidRefreshListener.refresh();
                WAADRefreshListener rlistener = new WAADRefreshListener(Long.valueOf(1L), domainName, "o365group", reportId, rb);
                message = rlistener.refresh();
                if (message != null && message.length() > 0) {
                    ClientUtil.setStatusXMLElement(response, "Message", rb.getString(message));
                    return null;
                }
                reportId = 60;
                rlistener = new WAADRefreshListener(Long.valueOf(1L), domainName, "o365group", reportId, rb);
                message = rlistener.refresh();
                if (message == null || message.length() <= 0) continue;
                ClientUtil.setStatusXMLElement(response, "Message", rb.getString(message));
                return null;
            }
            if (objectType != null && Arrays.asList(objectType).contains("organizationalUnit")) {
                DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"OU"});
                continue;
            }
            li = new RefreshListener(loginId, domainName, Arrays.asList(objectType).get(0), rb);
            li.refresh(searchPattern);
        }
        ClientUtil.setStatusXMLElement(response, "Success", "");
        return null;
    }

    public ActionForward getUserAccountStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String msg = "";
        try {
            boolean locked = false;
            boolean pwdStatus = false;
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            String objectGUID = request.getParameter("objectGUID");
            ArrayList<String> attribList = new ArrayList<String>();
            attribList.add("lockoutTime");
            attribList.add("msDS-ResultantPSO");
            attribList.add("pwdLastSet");
            Properties prop = ADHandler.getObjectFromGUID((String)domainName, (Long)loginId, (String)objectGUID, attribList);
            locked = UserHandler.getLockoutStatus((String)domainName, (Long)loginId, (Properties)prop);
            pwdStatus = UserHandler.getPasswordStatus((String)domainName, (Long)loginId, (Properties)prop);
            String lockedStatusStr = "disabled='true'";
            String pwdStatusStr = "";
            if (locked) {
                lockedStatusStr = "checked";
            }
            if (pwdStatus) {
                pwdStatusStr = "checked";
            }
            request.setAttribute("lockedStatus", (Object)lockedStatusStr);
            request.setAttribute("pwdStatus", (Object)pwdStatusStr);
        }
        catch (LocalizedException le) {
            msg = le.getMessage(rb);
            le.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("message", (Object)msg);
        return mapping.findForward("modifyPasswordDialog");
    }

    public static JSONObject getDefaultNavigationConfig(Long loginId) {
        JSONObject jsonObject = new JSONObject();
        try {
            ArrayList rangeList = NavigateRangeUtil.getRangeListForModule((String)"SingleModification");
            int range = NavigateRangeUtil.getDefaultRange((String)"SingleModification", (Long)loginId);
            jsonObject.put("startIndex", 1);
            jsonObject.put("toIndex", range);
            jsonObject.put("range", range);
            jsonObject.put("rangeList", (Object)FcJSONUtility.getJSONArray((ArrayList)rangeList));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonObject;
    }
}

