/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.SearchProfileHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.MgmtNotificationListener;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcValidation;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGenerator;
import com.adventnet.sym.adsm.common.server.querygenerator.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.queue.QueueHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.resultdata.ResultDataHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DirectoryObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.HDTAuditUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserBean;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.model.DynamicController;
import com.adventnet.sym.adsm.common.webclient.reports.AbstractListener;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultInputUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.BulkModificationAPI;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.ReportClientUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModifyUserListener
extends AbstractListener
implements DynamicController {
    protected static Logger logger = Logger.getLogger("ADMangLogger");
    protected Hashtable ldapNameVsDisplayName = null;
    protected String[] cks = null;
    public Hashtable domainVsIds = new Hashtable();
    public Hashtable authorizedDomainOUHash = null;
    public ArrayList groupIncludeList = null;
    public ArrayList groupExcludeList = null;
    private ArrayList updateList = null;
    protected boolean isLicenseExceeded = false;
    protected long[] actionIds = null;
    protected String[] actions = null;
    protected String tableName = null;
    protected int dnAttribId = 1004;
    protected int samAttribId = 1006;
    protected String dcFqdn = null;
    protected Hashtable dcFqdnHash = null;
    protected ArrayList searchAttributes = null;
    protected List<String> modifiedGuidList = new ArrayList<String>();

    public ModifyUserListener() {
        this.reportId = new Integer(1001);
        this.tableName = new String("ADSMModifyUserResult");
        this.dnAttribId = 1004;
        this.ldapNameVsDisplayName = new Hashtable();
        this.ldapNameVsDisplayName.put("displayNameFormat", "displayName");
        this.ldapNameVsDisplayName.put("logonNameFormat", "userPrincipalName");
        this.ldapNameVsDisplayName.put("fullNameFormat", "name");
        this.ldapNameVsDisplayName.put("samAccountNameFormat", "samAccountName");
        this.noOfObjects = LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers");
        this.updateList = new ArrayList();
        this.isLicenseExceeded = CommonUtil.isLicenseExceeded((String)"userMgmt");
        this.searchAttributes = SearchProfileHandler.getSearchAttributes((int)3, (int)1);
    }

    @Override
    public void init(HttpServletRequest request, Row r) {
        System.out.println("modify user listener: init");
        logger.log(Level.INFO, "MODIFY QUEUE INITIALIZATION... ");
        HttpSession session = request.getSession();
        this.baseTableName = (String)r.get("BASE_TABLE_NAME");
        this.resultTableName = (String)r.get("RESULT_TABLE_NAME");
        this.setRb(ResourceBundleMgr.getInstance().getBundle());
    }

    @Override
    public void setRb(AdventNetResourceBundle rb) {
        this.rb = rb;
    }

    public void setAuthorizedDomainOUHash(Hashtable authorizedDomainOUHash) {
        this.authorizedDomainOUHash = authorizedDomainOUHash;
    }

    public void setDomainVsIds(Hashtable domainVsIds) {
        this.domainVsIds = domainVsIds;
    }

    public String[] getCheckBoxNames() {
        return this.cks;
    }

    public ArrayList getMgmtActions(ArrayList actions) {
        Long subCategoryId;
        String categoryName;
        ArrayList actionItems;
        Hashtable hash;
        int i;
        ArrayList resultMgmtActions = new ArrayList();
        Hashtable<String, Object> mgmtActionItems = new Hashtable<String, Object>();
        ArrayList<Hashtable> l1 = new ArrayList<Hashtable>();
        for (i = 0; i < actions.size(); ++i) {
            hash = (Hashtable)actions.get(i);
            actionItems = (ArrayList)hash.get("ACTION_ITEMS");
            categoryName = (String)hash.get("CATEGORY_NAME");
            subCategoryId = (Long)hash.get("SUB_CATEGORY_ID");
            if (subCategoryId != 1002L && subCategoryId != 1005L && subCategoryId != 1006L || actionItems == null) continue;
            for (int k = 0; k < actionItems.size(); ++k) {
                Hashtable hash1 = (Hashtable)actionItems.get(k);
                l1.add(hash1);
            }
        }
        if (!l1.isEmpty()) {
            mgmtActionItems.put("CATEGORY_NAME", this.rb.getString("admp.reports.reports_to_mgmt.text.general_attribs"));
            mgmtActionItems.put("ACTION_ITEMS", l1);
            resultMgmtActions.add(mgmtActionItems);
        }
        for (i = 0; i < actions.size(); ++i) {
            l1 = new ArrayList();
            hash = (Hashtable)actions.get(i);
            actionItems = (ArrayList)hash.get("ACTION_ITEMS");
            categoryName = (String)hash.get("CATEGORY_NAME");
            subCategoryId = (Long)hash.get("SUB_CATEGORY_ID");
            if (actionItems == null || subCategoryId == 1002L || subCategoryId == 1005L || subCategoryId == 1006L) continue;
            if (subCategoryId == 1007L) {
                mgmtActionItems = new Hashtable();
                mgmtActionItems.put("CATEGORY_NAME", categoryName);
                mgmtActionItems.put("ACTION_ITEMS", actionItems);
            } else {
                mgmtActionItems = new Hashtable();
                mgmtActionItems.put("CATEGORY_NAME", categoryName);
                mgmtActionItems.put("ACTION_ITEMS", actionItems);
            }
            resultMgmtActions.add(mgmtActionItems);
        }
        return resultMgmtActions;
    }

    @Override
    public void checkBoxes(HttpServletRequest request, ReportBean bean) {
        HashMap props = (HashMap)bean.get("props");
        for (int i = 0; this.cks != null && i < this.cks.length; ++i) {
            if (request.getParameter("props(" + this.cks[i] + ")") != null) continue;
            props.put(this.cks[i], "false");
        }
    }

    @Override
    protected void checkAttributeList(ArrayList attributeList) {
    }

    @Override
    public void doAction(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
    }

    public void search(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
        try {
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            this.licenseExceed = false;
            this.generationId = ReportHandler.addReportGenerationDetails((Integer)this.reportId, (String)this.desc, (Long)loginId);
            logger.log(Level.INFO, "Generation ID : " + this.generationId);
            ArrayList attributeList = this.getReportAttributeList();
            String searchString = request.getParameter("searchString");
            ArrayList containerList = this.getContainerList(request, bean);
            Hashtable domainVsExcludeChildOU = (Hashtable)bean.get("domainVsExcludeChildOU");
            logger.log(Level.INFO, "The container list is : " + containerList);
            Hashtable excludedOUList = (Hashtable)bean.get("excludedOUList");
            Hashtable excludeContainerHash = this.constructExcludeContainerHash(containerList, domainVsExcludeChildOU, excludedOUList, dnDomainNameMap);
            logger.log(Level.INFO, "Form to Action : ");
            Action action = new Action(loginId, containerList, attributeList, this.getSearchQuery(searchString, bean), this, dnDomainNameMap, excludeContainerHash);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getCSVQuery(String keyLdapName, String keyLdapValue) {
        return "(&(objectClass=user)(objectCategory=user)(" + keyLdapName + "=" + keyLdapValue + "))";
    }

    public String getSearchQuery(String searchString, ReportBean bean) {
        StringBuffer str = new StringBuffer();
        str.append("(&(objectCategory=person)(objectClass=user)(!(sAMAccountType=805306370))");
        if (searchString != null && !searchString.equals("")) {
            this.getSearchString(searchString, str);
        }
        str.append(")");
        return str.toString();
    }

    public void getSearchString(String searchString, StringBuffer str) {
        StringTokenizer token = new StringTokenizer(searchString, ",");
        str.append("(|");
        while (token.hasMoreTokens()) {
            String s = (String)token.nextElement();
            s = CommonUtil.escapeSpecialCharacters((String)s);
            if (this.searchAttributes == null) continue;
            for (int i = 0; i < this.searchAttributes.size(); ++i) {
                str.append("(" + this.searchAttributes.get(i) + "=*" + s + "*)");
            }
        }
        str.append(")");
    }

    public void initdcFqdnHash() {
        this.dcFqdnHash = new Hashtable();
    }

    public void cleardcFqdnHash() {
        if (this.dcFqdnHash != null) {
            this.dcFqdnHash.clear();
        }
    }

    public void setValidDC(String domainName, Long loginId) {
    }

    public String getDcFqdn() {
        return this.dcFqdn;
    }

    public String getOUBasedDcFqdn(String ouName, Long loginId, String domainName) {
        String ouBasedDcFqdn = null;
        if (this.dcFqdnHash == null) {
            this.dcFqdnHash = new Hashtable();
        }
        if (this.dcFqdnHash.get(ouName) != null) {
            ouBasedDcFqdn = (String)this.dcFqdnHash.get(ouName);
        } else {
            ouBasedDcFqdn = DomainUtil.getValidDC((String)domainName, (Long)loginId, (String)ouName);
            this.dcFqdnHash.put(ouName, ouBasedDcFqdn);
        }
        return ouBasedDcFqdn;
    }

    public static Criteria getSIDCriteria(ReportBean bean) {
        return ReportResultUtil.getSIDCriteria(bean);
    }

    public static Criteria getSIDCriteria(ReportBean bean, String[] selectedSidArray) {
        return ReportResultUtil.getSIDCriteria(bean, selectedSidArray);
    }

    protected Properties getAttributeProps(String selectedAttribute, String value) {
        Properties p = new Properties();
        p.put("DATA_HANDLER_TYPE", new Long(3L));
        p.put("ATTRIB_VALUE", value);
        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
        p.put("ATTRIB_LDAP_NAME", this.ldapNameVsDisplayName.get(selectedAttribute));
        return p;
    }

    public Properties getSIDProps() {
        Properties sidProps = new Properties();
        sidProps.put("ATTRIB_ID", new Integer(1144));
        sidProps.put("ATTRIB_COLUMN_NAME", "SID_STRING");
        sidProps.put("TABLE_NAME", this.baseTableName);
        sidProps.put("RELATIONAL_TYPE", new Integer(0));
        return sidProps;
    }

    public void addDNProps(ArrayList attribList) {
        boolean dnExists = false;
        boolean samExists = false;
        if (attribList != null) {
            for (int i = 0; i < attribList.size(); ++i) {
                Properties attributeProperties = (Properties)attribList.get(i);
                if (attributeProperties.getProperty("ATTRIB_COLUMN_NAME").equals("DISTINGUISHED_NAME")) {
                    dnExists = true;
                }
                if (!attributeProperties.getProperty("ATTRIB_COLUMN_NAME").equals("SAM_ACCOUNT_NAME")) continue;
                samExists = true;
            }
        }
        if (!dnExists) {
            Properties dnProps = new Properties();
            dnProps.put("ATTRIB_ID", new Integer(this.dnAttribId));
            dnProps.put("ATTRIB_COLUMN_NAME", "DISTINGUISHED_NAME");
            dnProps.put("ATTRIB_LDAP_NAME", "distinguishedName");
            dnProps.put("TABLE_NAME", this.baseTableName);
            dnProps.put("RELATIONAL_TYPE", new Integer(0));
            attribList.add(dnProps);
        }
        if (!samExists) {
            Properties samProps = new Properties();
            samProps.put("ATTRIB_ID", new Integer(this.samAttribId));
            samProps.put("ATTRIB_COLUMN_NAME", "SAM_ACCOUNT_NAME");
            samProps.put("ATTRIB_LDAP_NAME", "sAMAccountName");
            samProps.put("TABLE_NAME", this.baseTableName);
            samProps.put("RELATIONAL_TYPE", new Integer(0));
            attribList.add(samProps);
        }
    }

    public ArrayList getModifiedViewColumns(Integer reportId) {
        return ReportAttributeHandler.getInstance().getModifiedColumns(reportId);
    }

    public void modifyUser(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String hostId = request.getRemoteHost();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        this.domainVsIds = authObject.getDomainActionMap();
        this.authorizedDomainOUHash = authObject.getDomainOUsMap();
        try {
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            ArrayList list = null;
            JSONObject jsonObject = new JSONObject(request.getParameter("selectedSid").toString().trim());
            JSONArray selectedSidArray = jsonObject.getJSONArray("selectedSid");
            String[] sidArray = new String[selectedSidArray.length()];
            for (int j = 0; j < selectedSidArray.length(); ++j) {
                sidArray[j] = selectedSidArray.getString(j);
            }
            Criteria resultTableCriteria = ModifyUserListener.getSIDCriteria(bean, sidArray);
            Criteria columnSearchCriteria = null;
            Properties p = new Properties();
            p.put("TABLE_NAME", this.resultTableName);
            p.put("ATTRIB_COLUMN_NAME", "OBJECT_GUID");
            ArrayList attributeList = this.getModifiedViewColumns(this.reportId);
            attributeList.add(this.getSIDProps());
            this.addDNProps(attributeList);
            Hashtable multipleValuesSids = new Hashtable();
            list = this.getRows(attributeList, p, true, -1, -1, multipleValuesSids, resultTableCriteria, columnSearchCriteria, new ArrayList());
            Integer count = ReportHandler.getSIDReportCount((Long)this.getGenerationId(), (String)this.resultTableName, (Criteria)resultTableCriteria);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("multipleValuesSids", multipleValuesSids);
            request.setAttribute("result", (Object)list);
            ModifyAction action = new ModifyAction(loginId, hostId, bean, list, this.getReportAttributeList(), 1);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getValue(Hashtable h, int i) {
        return this.getValue(h, new Integer(i));
    }

    public String getObjectName(Hashtable h) {
        String objName = this.getValue(h, new Integer(1006));
        if (objName == "") {
            objName = this.getValue(h, new Integer(1010));
        }
        return objName;
    }

    public void fillAttribs(ArrayList list, String attribName, Object attribValue) {
        if (list != null && list.size() > 0) {
            Properties prop = (Properties)list.get(0);
            prop.put("ATTRIB_LDAP_NAME", attribName);
            if (attribValue instanceof String) {
                prop.put("ATTRIB_VALUE", attribValue.toString());
            } else if (attribValue instanceof ArrayList) {
                prop.put("ATTRIB_LDAP_NAME", attribName);
                prop.put("ATTRIB_VALUE_COUNT", (Object)2L);
                prop.put("ATTRIB_VALUE", attribValue);
            }
        }
    }

    public String getValue(Hashtable h, Integer i) {
        String s = (String)h.get(i);
        if (s == null || s.equalsIgnoreCase("null") || s.equalsIgnoreCase("-")) {
            s = "";
        }
        return s;
    }

    @Override
    protected void updateOutList() {
        if (this.updateList.size() > 0) {
            logger.log(Level.INFO, "COUNTS : " + this.updateList.size());
            for (int i = 0; i < this.updateList.size() && i < 24; ++i) {
                this.out.write((String)this.updateList.get(i));
                this.out.flush();
            }
            this.updateList.clear();
        }
    }

    public void updateUI(Properties uiValues, String objectClass, String guid) {
    }

    public void updateUI(String str) {
        ++this.updatedCount;
        if (this.out != null) {
            this.updateOutList();
            if (this.updatedCount <= 25) {
                this.out.write("<script>if(this.load) updateUI(" + str + ")</script>");
            }
            this.out.write("<script>if(this.load) updateCount(" + this.updatedCount + ")</script>");
            this.out.flush();
        } else {
            this.updateList.add("<script>if(this.load) updateUI(" + str + ")</script>");
        }
    }

    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId) {
        return this.modifyUser(result, attributeList, bean, domainName, loginId, null, null);
    }

    public String modifyUser(Hashtable result, ArrayList attributeList, AdmpInput admpInput, NativeListener listener, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        return "";
    }

    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1013L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        ModifyUserListener listener = (ModifyUserListener)bean.getListener();
        StringBuffer errorMessage = new StringBuffer();
        String sid = this.getValue(result, 1144);
        String dn = this.getValue(result, 1004);
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        boolean fullNameSuccess = false;
        String[] selectedAttributes = new String[]{"displayNameFormat", "fullNameFormat", "logonNameFormat", "samAccountNameFormat"};
        long[] id = new long[]{1204L, 1205L, 1206L, 1207L};
        BeanMap props = (BeanMap)bean.get("props");
        for (int j = 0; j < selectedAttributes.length; ++j) {
            String value;
            if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, id[j]) || (value = props.getProperty(selectedAttributes[j])).equalsIgnoreCase("0")) continue;
            if ((value = FormatClientUtil.getFormatValue(new Long(value), result, domainName, "")) == null || value.equalsIgnoreCase("") || value.equals(".") || value.equals("..")) {
                if (errorMessage.length() > 0) {
                    errorMessage.append(", ");
                }
                String str = MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.empty_string"), this.ldapNameVsDisplayName.get(selectedAttributes[j]));
                errorMessage.append(str);
                continue;
            }
            if (selectedAttributes[j].equals("fullNameFormat")) {
                try {
                    fullNameSuccess = true;
                    logger.log(Level.INFO, "MODIFY Full Name :  " + dn + " value : " + value + " ATTRIBUTELIST : " + attributeList);
                    ADHandlerForMgmt.modifyUserFullName((String)domainName, (Long)loginId, (String)dn, (String)value, (ArrayList)attributeList);
                    ADHandlerForMgmt.updateUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)attributeList, (NativeListener)this);
                }
                catch (LocalizedException le) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append(le.getMessage(this.rb));
                }
                catch (Exception e) {
                    if (errorMessage.length() > 0) {
                        errorMessage.append(", ");
                    }
                    errorMessage.append(e.getMessage());
                }
                TechAuditAPI.getInstance().auditSingleAttributeModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.mod_fullname"), this.getValue(result, 1010), domainName, "fullname", value, errorMessage.toString(), this.rb.getString("admp.mgmt.user_mgmt.mgmtcategory.user_modification"), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                continue;
            }
            if (selectedAttributes[j].equals("logonNameFormat")) {
                try {
                    Properties p = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
                    String domainDNSName = p.getProperty("DOMAIN_DNS_NAME");
                    setAttributeList.add(this.getAttributeProps(selectedAttributes[j], value + "@" + domainDNSName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                continue;
            }
            if (selectedAttributes[j].equals("samAccountNameFormat")) {
                String validationErrorMsg = FcValidation.doSamAccountNameValidation((String)"sAMAccountName", (Object)value, (AdventNetResourceBundle)this.rb);
                if (validationErrorMsg == "") {
                    if (value.length() >= 20) {
                        value = value.substring(0, 20);
                    }
                    setAttributeList.add(this.getAttributeProps(selectedAttributes[j], value));
                    continue;
                }
                if (errorMessage.length() > 0) {
                    errorMessage.append(", ");
                }
                errorMessage.append(validationErrorMsg);
                continue;
            }
            setAttributeList.add(this.getAttributeProps(selectedAttributes[j], value));
        }
        logger.log(Level.INFO, " dnDomainNameMap and the LIST : " + domainName);
        logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + sid + " ATTRIBUTELIST : " + setAttributeList);
        if (setAttributeList.size() == 0) {
            if (!fullNameSuccess) {
                errorMessage.insert(0, this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error_occured"));
            }
        } else {
            try {
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                if (errorMessage.length() > 0) {
                    errorMessage.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error") + " : ");
                }
            }
            catch (LocalizedException le) {
                errorMessage.insert(0, MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(this.rb)));
            }
            catch (Exception e) {
                errorMessage.insert(0, MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.mgmtname.naming_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), errorMessage.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        if (errorMessage.length() == 0) {
            return this.rb.getString("admp.mgmt.common.statmsg.successfully_modified");
        }
        return errorMessage.toString();
    }

    public void initAttributeLists(ReportBean bean) {
        ArrayList attributeList = (ArrayList)bean.get("attributeList");
        String keyLdapName = null;
        for (int i = 0; i < CSVUserBean.keyLdapNames.length; ++i) {
            for (Hashtable hash : attributeList) {
                String str = (String)hash.get("ATTRIB_LDAP_NAME");
                if (!str.equalsIgnoreCase(CSVUserBean.keyLdapNames[i])) continue;
                keyLdapName = str;
                break;
            }
            if (keyLdapName != null) break;
        }
        bean.set("keyLdapName", keyLdapName);
        ArrayList resultAttributeList = new ArrayList();
        ArrayList<String> resultLdapNameList = new ArrayList<String>();
        for (Hashtable hash : attributeList) {
            String str = (String)hash.get("ATTRIB_LDAP_NAME");
            for (int i = 0; i < CSVUserBean.keyLdapNames.length; ++i) {
                if (!str.equalsIgnoreCase(CSVUserBean.keyLdapNames[i])) continue;
                resultAttributeList.add(hash);
                resultLdapNameList.add(str);
                if (resultAttributeList.size() == 4) break;
            }
            if (resultAttributeList.size() != 4) continue;
            break;
        }
        Integer reportId = (Integer)bean.get("reportId");
        BeanMap props = (BeanMap)bean.get("props");
        String resetPasswordOption = props.getProperty("resetPasswordOption");
        if (reportId == 1019 && resetPasswordOption != null && resetPasswordOption.equals("true")) {
            Hashtable<String, Object> hash3 = new Hashtable<String, Object>();
            hash3.put("RELATIONAL_TYPE", new Integer(0));
            hash3.put("ATTRIB_COLUMN_NAME", "PASSWORD");
            hash3.put("ATTRIB_LDAP_NAME", "password");
            hash3.put("ATTRIB_DISP_NAME", "Password");
            hash3.put("ATTRIB_ID", new Integer(1047));
            resultAttributeList.add(hash3);
        }
        Hashtable<String, Object> hash1 = new Hashtable<String, Object>();
        hash1.put("RELATIONAL_TYPE", new Integer(0));
        hash1.put("ATTRIB_COLUMN_NAME", "CREATION_STATUS");
        hash1.put("ATTRIB_LDAP_NAME", "Creation Status");
        resultAttributeList.add(hash1);
        Hashtable<String, Object> hash2 = new Hashtable<String, Object>();
        hash2.put("RELATIONAL_TYPE", new Integer(0));
        hash2.put("ATTRIB_COLUMN_NAME", "CREATION_MESSAGE");
        hash2.put("ATTRIB_LDAP_NAME", "Status");
        hash2.put("ATTRIB_DISP_NAME", "admp.mgmt.common.text.status");
        resultAttributeList.add(hash2);
        bean.set("resultAttributeList", resultAttributeList);
    }

    public void setCSVRowsForModifiedList(HttpServletRequest request, ReportBean bean, String operation, Hashtable requestProperties) {
        ArrayList attributeList = new ArrayList();
        Integer range = (Integer)bean.get("RANGE");
        Long startIndex = (Long)requestProperties.get("FROM_INDEX");
        Criteria crit = null;
        SortColumn sortColumn = null;
        crit = this.getSelectedCriteria(bean);
        attributeList = (ArrayList)bean.get("resultAttributeList");
        String modifyResultColumn = (String)requestProperties.get("modifyResultColumn");
        String ascending = (String)requestProperties.get("ascending");
        if (modifyResultColumn == null || modifyResultColumn.equals("")) {
            modifyResultColumn = "CREATION_MESSAGE";
        }
        sortColumn = new SortColumn(new Column(CSVUserBean.USER_ATTRIBUTE_TABLE, modifyResultColumn), new Boolean(ascending).booleanValue());
        if (ascending.equals("true")) {
            request.setAttribute("sortImage", (Object)"images/sortdown.gif");
        } else {
            request.setAttribute("sortImage", (Object)"images/sortup.gif");
        }
        Integer count = AddUserHandler.getInstance().getCount(this.generationId, crit);
        request.setAttribute("recordsCount", (Object)count);
        ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(this.generationId, attributeList, startIndex.intValue(), range.intValue(), sortColumn, crit);
        request.setAttribute("result", (Object)userDetailsList);
        request.setAttribute("modifyResultColumn", (Object)modifyResultColumn);
    }

    public void setCSVRows(HttpServletRequest request, ReportBean bean, String operation) {
        ArrayList attributeList = new ArrayList();
        int startIndex = -1;
        int range = 0;
        Criteria crit = null;
        SortColumn sortColumn = null;
        if (operation.equalsIgnoreCase("showList")) {
            if (bean.get("keyLdapName") != null) {
                Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", bean.get("keyLdapName"));
                attributeList.add(attributesdetails);
            }
        } else {
            crit = this.getSelectedCriteria(bean);
            attributeList = (ArrayList)bean.get("resultAttributeList");
            range = (Integer)bean.get("RANGE");
            startIndex = (int)((Long)bean.get("FROM_INDEX")).longValue();
            String modifyResultColumn = (String)bean.get("modifyResultColumn");
            if (modifyResultColumn == null || modifyResultColumn.equals("")) {
                modifyResultColumn = "CREATION_MESSAGE";
            }
            bean.set("modifyResultColumn", modifyResultColumn);
            String ascending = (String)bean.get("ascending");
            sortColumn = new SortColumn(new Column(CSVUserBean.USER_ATTRIBUTE_TABLE, modifyResultColumn), new Boolean(ascending).booleanValue());
            if (ascending.equals("true")) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            Integer count = AddUserHandler.getInstance().getCount(this.generationId, crit);
            request.setAttribute("recordsCount", (Object)count);
        }
        if (attributeList != null && !attributeList.isEmpty()) {
            if (attributeList.size() == 1 && ((Hashtable)attributeList.get(0)).size() == 0) {
                request.setAttribute("result", new ArrayList());
            } else {
                ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(this.generationId, attributeList, startIndex, range, sortColumn, crit);
                request.setAttribute("result", (Object)userDetailsList);
            }
        } else {
            request.setAttribute("result", new ArrayList());
        }
    }

    public void modifyCSVUser(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String hostId = request.getRemoteHost();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        this.domainVsIds = authObject.getDomainActionMap();
        this.authorizedDomainOUHash = authObject.getDomainOUsMap();
        try {
            if (!this.isCompleted) {
                return;
            }
            this.isCompleted = false;
            this.continueAction = true;
            ArrayList list = null;
            JSONObject jsonObject = new JSONObject(request.getParameter("selectedSid").toString().trim());
            JSONArray selectedSidArray = jsonObject.getJSONArray("selectedSid");
            String[] sidArray = new String[selectedSidArray.length()];
            for (int j = 0; j < selectedSidArray.length(); ++j) {
                sidArray[j] = selectedSidArray.getString(j);
            }
            Criteria crit = this.getSelectedUserIndexCriteria(sidArray);
            ArrayList attributeList = (ArrayList)bean.get("attributeList");
            list = AddUserHandler.getInstance().getUserDetailsList(this.generationId, attributeList, -1, 0, null, crit);
            Integer count = AddUserHandler.getInstance().getCount(this.generationId, crit);
            ModifyCSVAction action = new ModifyCSVAction(loginId, hostId, bean, list, 1);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getValue(ArrayList values, String key) {
        Properties p = (Properties)values.get(0);
        String str = "";
        if (key == null || p == null) {
            return str;
        }
        if (p.get(key) == null) {
            return str;
        }
        ArrayList l = (ArrayList)p.get(key);
        if (l == null || l.size() == 0) {
            return str;
        }
        return (String)l.get(l.size() - 1);
    }

    public String modifyCSVUser(String searchString, ReportBean bean, String defaultNamingContext, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        String message = null;
        try {
            ArrayList attib = this.getReportAttributeList();
            if (!attib.contains((String)bean.get("keyLdapName"))) {
                attib.add((String)bean.get("keyLdapName"));
            }
            Properties prop = this.getAttributeValues(this.domainName, defaultNamingContext, loginId, attib, searchString);
            logger.log(Level.INFO, " User Properties for Modify CSV User with the attributes, " + attib + " is : " + prop);
            String guid = this.getGuid(prop);
            if (guid == null) {
                reportLogger.log(Level.INFO, "SID is NULL for the Properties : " + prop);
                return this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.no_user_present");
            }
            Hashtable tableRowMap = new Hashtable();
            Hashtable relationalTableRowMap = new Hashtable();
            Hashtable uiValues = new Hashtable();
            this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues);
            ArrayList<String> guidList = new ArrayList<String>();
            guidList.add(guid);
            try {
                DBObjectUtil.addOrUpdate((String)this.baseTableName, (String)this.tableKey, guidList, tableRowMap, relationalTableRowMap);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList attributeList = this.getModifiedViewColumns(this.reportId);
            attributeList.add(this.getSIDProps());
            this.addDNProps(attributeList);
            Hashtable multipleValuesSids = new Hashtable();
            Criteria crit = new Criteria(new Column(this.baseTableName, this.tableKey), (Object)guid, 0);
            ArrayList list = DBObjectUtil.getObjects((String)this.baseTableName, (String)this.tableKey, (ArrayList)attributeList, (Criteria)crit);
            if (list.size() == 0) {
                return this.rb.getString("admp.mgmt.user_mgmt.common.statmsg.no_user_present") + this.rb.getString("admp.reports.reports_to_mgmt.text.regenerate_for_updated_results");
            }
            Hashtable result = (Hashtable)list.get(0);
            audit_info.put("distinguishedName", this.getValue(result, 1004));
            message = this.modifyUser(result, attib, bean, this.domainName, loginId, audit_info, auditDataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
            String errMsg = e.getMessage();
            this.auditFailure(audit_info, auditDataObj, errMsg);
            return errMsg;
        }
        return message;
    }

    public void auditFailure(Hashtable audit_info, DataObject auditDataObj, String errMsg) {
        try {
            Integer[] contactReportIds = new Integer[]{3003, 3004, 3005, 3006, 3013, 3014};
            List<Integer> contactReportIdsList = Arrays.asList(contactReportIds);
            Integer[] ouReportIds = new Integer[]{9006, 9007};
            List<Integer> ouReportIdsList = Arrays.asList(ouReportIds);
            Long obj_id = (Long)audit_info.get("object_id");
            Row auditRow = auditDataObj.getRow("ADSMAuditDetails");
            Row objRow = auditDataObj.getRow("ADSMAuditObjs", new Criteria(Column.getColumn((String)"ADSMAuditObjs", (String)"OBJECT_ID"), (Object)obj_id, 0));
            if (contactReportIdsList.contains(this.reportId)) {
                TechAuditAPI.getInstance().auditContactModification(this.loginId, (String)auditRow.get("ACTION_NAME"), (String)objRow.get("OBJECT_NAME"), (String)objRow.get("OBJECT_DOMAIN"), new ArrayList(), new ArrayList(), new ArrayList(), errMsg, obj_id, auditDataObj, this.rb);
            } else if (ouReportIdsList.contains(this.reportId)) {
                TechAuditAPI.getInstance().auditOUModification(this.loginId, (String)auditRow.get("ACTION_NAME"), (String)objRow.get("OBJECT_NAME"), (String)objRow.get("OBJECT_DOMAIN"), new ArrayList(), new ArrayList(), new ArrayList(), errMsg, obj_id, auditDataObj, this.rb);
            } else {
                TechAuditAPI.getInstance().auditUserModification(this.loginId, (String)auditRow.get("ACTION_NAME"), (String)objRow.get("OBJECT_NAME"), (String)objRow.get("OBJECT_DOMAIN"), new ArrayList(), new ArrayList(), new ArrayList(), errMsg, obj_id, auditDataObj, this.rb);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Hashtable uiValues) {
        this.addRow(prop, guid, tableRowMap, relationalTableRowMap, uiValues, null, null);
    }

    public void addRow(Properties prop, String guid, Hashtable tableRowMap, Hashtable relationalTableRowMap, Hashtable uiValues, Integer reportId, String tableKey) {
        try {
            Object values = null;
            Integer n = reportId = reportId == null ? this.reportId : reportId;
            if (tableKey != null && tableKey.equalsIgnoreCase("OBJECT_ID")) {
                ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(reportId, "O365User");
                ArrayList writerTableList = ReportAttributeHandler.getInstance().getWriterTables();
                for (int i = 0; i < tableNames.size(); ++i) {
                    String tableName = (String)tableNames.get(i);
                    ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, reportId);
                    if (writerTableList != null && writerTableList.contains(tableName)) continue;
                    this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, tableKey, guid, tableKey);
                }
            } else {
                ArrayList tableNames = ReportAttributeHandler.getInstance().getTableNames(reportId);
                int baseTableIndex = tableNames.indexOf(this.baseTableName);
                if (baseTableIndex > 0) {
                    tableNames.remove(baseTableIndex);
                    tableNames.add(0, this.baseTableName);
                }
                ArrayList writerTableList = ReportAttributeHandler.getInstance().getWriterTables();
                for (int i = 0; i < tableNames.size(); ++i) {
                    String tableName = (String)tableNames.get(i);
                    ArrayList attributeList = ReportAttributeHandler.getInstance().getAttributes(tableName, reportId);
                    if (writerTableList != null && writerTableList.contains(tableName)) continue;
                    this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, tableKey, guid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void createRows(String tableName, ArrayList attributeList, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties prop, String tableKey, String guid) throws Exception {
        this.createRows(tableName, attributeList, tableRowMap, relationalTableRowMap, prop, tableKey, guid, null);
    }

    public void createRows(String tableName, ArrayList attributeList, Hashtable tableRowMap, Hashtable relationalTableRowMap, Properties prop, String tableKey, String guid, String tempKey) throws Exception {
        ArrayList<Object> rowList = new ArrayList<Object>();
        ArrayList values = null;
        ArrayList<Row> multipleTableRowList = new ArrayList<Row>();
        Integer relationalType = null;
        Row r = null;
        tempKey = tempKey == null ? this.tempTableKey : tempKey;
        TableDefinition tableDef = MetaDataUtil.getTableDefinitionByName((String)tableName);
        for (int j = 0; j < attributeList.size(); ++j) {
            Properties p = (Properties)attributeList.get(j);
            String ldapName = (String)p.get("ATTRIB_LDAP_NAME");
            String columnName = (String)p.get("ATTRIB_COLUMN_NAME");
            Integer attributeId = (Integer)p.get("ATTRIB_ID");
            relationalType = (Integer)p.get("RELATIONAL_TYPE");
            if (tableName.equalsIgnoreCase("O365UserLicenseServiceMapping") && columnName.equalsIgnoreCase("SERVICES") || this.toBeExecutedAttributeList != null && !this.toBeExecutedAttributeList.contains(ldapName)) continue;
            values = (ArrayList)prop.get(ldapName);
            values = this.getDBCustomizedValues(columnName, ldapName, prop);
            if (tableName.endsWith("CustomDetails")) {
                ColumnDefinition colDef = tableDef.getColumnDefinitionByName(columnName);
                values = this.getCustomFieldValues(values, colDef, this.rb);
            }
            if (relationalType.equals(new Integer(1))) {
                if (values != null && !values.isEmpty()) {
                    for (int k = 0; k < values.size(); ++k) {
                        if (attributeId.equals(17018)) {
                            Properties licenseDetails = (Properties)values.get(k);
                            Enumeration<?> e = licenseDetails.propertyNames();
                            String licensevalue = (String)e.nextElement();
                            ArrayList servicePlans = (ArrayList)licenseDetails.get(licensevalue);
                            for (int i = 0; i < servicePlans.size(); ++i) {
                                Row r1 = new Row(tableName);
                                String servicePlan = (String)servicePlans.get(i);
                                r1.set(columnName, (Object)licensevalue);
                                r1.set("SERVICES", (Object)servicePlan);
                                r1.set(tempKey, (Object)guid);
                                multipleTableRowList.add(r1);
                            }
                            continue;
                        }
                        String value = (String)values.get(k);
                        Row r1 = null;
                        if (multipleTableRowList.size() > k) {
                            r1 = (Row)multipleTableRowList.get(k);
                        } else {
                            r1 = new Row(tableName);
                            multipleTableRowList.add(k, r1);
                        }
                        r1.set(columnName, (Object)value);
                        r1.set(tempKey, (Object)guid);
                    }
                    continue;
                }
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, (Object)"-");
                if (!attributeId.equals(17018)) continue;
                r = null;
                relationalTableRowMap.put(tableName, rowList);
                continue;
            }
            if (values != null && !values.isEmpty()) {
                if (r == null) {
                    r = new Row(tableName);
                }
                r.set(columnName, values.get(0));
                continue;
            }
            if (r == null) {
                r = new Row(tableName);
            }
            r.set(columnName, (Object)"-");
        }
        if (r != null) {
            r.set(tempKey, (Object)guid);
            rowList.add(r);
        }
        if (multipleTableRowList.size() > 0) {
            rowList.addAll(multipleTableRowList);
        }
        if (relationalType.equals(new Integer(0))) {
            tableRowMap.put(tableName, rowList);
        } else if (rowList.size() > 0) {
            relationalTableRowMap.put(tableName, rowList);
        }
    }

    protected Properties getAttributeValues(String domainName, String defaultNamingContext, Long loginId, ArrayList attributeList, String searchString) throws Exception {
        ArrayList values = null;
        ArrayList ouList = (ArrayList)this.authorizedDomainOUHash.get(domainName);
        if (ouList.size() == 0) {
            Properties prop = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            values = ADHandler.getObjectsWithOutListener((Properties)HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId), (String)defaultNamingContext, (ArrayList)attributeList, (String)searchString);
        } else {
            for (int i = 0; i < ouList.size(); ++i) {
                String distinguishedName = (String)ouList.get(i);
                values = ADHandler.getObjectsWithOutListener((Properties)HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId), (String)distinguishedName, (ArrayList)attributeList, (String)searchString);
                logger.log(Level.INFO, " Object Values : " + values + " for the search : " + searchString + ", with the DN :  " + distinguishedName);
                if (values.size() > 0) break;
            }
        }
        logger.log(Level.INFO, " Object Values : " + values + " for the search : " + searchString + ", with the OUs :  " + ouList);
        if (values == null || values.size() == 0) {
            throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.cannot_retrieve_object_does_not_exist_or_access_denied"));
        }
        if (values.size() > 1) {
            throw new Exception(this.rb.getString("admp.mgmt.common.statmsg.search_returns_more_than_one_value"));
        }
        return (Properties)values.get(0);
    }

    public Criteria getSelectedUserIndexCriteria(String[] selectedUserIndex) {
        Column col = Column.getColumn((String)CSVUserBean.USER_ATTRIBUTE_TABLE, (String)"USER_INDEX");
        Criteria criteria = new Criteria(col, (Object)selectedUserIndex, 8);
        return criteria;
    }

    public Criteria getSelectedCriteria(ReportBean bean) {
        Criteria crit = null;
        String selectAllUsers = (String)bean.get("selectAllUsers");
        ArrayList deSelectedSIDs = (ArrayList)bean.get("deSelectedSIDs");
        reportLogger.log(Level.INFO, "SELECT ALL USERS : " + selectAllUsers);
        if (selectAllUsers.equals("false")) {
            ArrayList objectIdList = (ArrayList)bean.get("selectedSIDs");
            Long[] objectIds = new Long[objectIdList.size()];
            for (int i = 0; i < objectIdList.size(); ++i) {
                objectIds[i] = new Long(Long.parseLong((String)objectIdList.get(i)));
            }
            Column col = new Column(CSVUserBean.USER_ATTRIBUTE_TABLE, "USER_INDEX");
            crit = new Criteria(col, (Object)objectIds, 8);
        } else if (deSelectedSIDs.size() > 0) {
            Long[] objectIds = new Long[deSelectedSIDs.size()];
            for (int i = 0; i < deSelectedSIDs.size(); ++i) {
                objectIds[i] = new Long(Long.parseLong((String)deSelectedSIDs.get(i)));
            }
            Column col = new Column(CSVUserBean.USER_ATTRIBUTE_TABLE, "USER_INDEX");
            crit = new Criteria(col, (Object)objectIds, 9);
        }
        reportLogger.log(Level.FINE, "CRIT for SELECT ALL USERS : " + crit);
        return crit;
    }

    protected void setTableProps(String domainName) {
        if (this.generationId == null) {
            this.generationId = ReportHandler.getRecentlyGeneratedReports((Integer)1019, (Long)1L);
        }
        this.setTableProps(domainName, this.generationId);
    }

    protected void setTableProps(String domainName, Long genId) {
        Hashtable<String, Object> tableProps = new Hashtable<String, Object>();
        tableProps.put("baseTableName", this.baseTableName);
        tableProps.put("generationId", genId);
        tableProps.put("domainName", domainName);
        tableProps.put("resultTableName", this.resultTableName);
        tableProps.put("resultHandling", "addOrUpdate");
    }

    protected void registerQueue() {
        ArrayList objectIds = this.getObjIdList();
        this.queueRegID = QueueHandler.getInstance().registerForUpdate(objectIds, this.getTableColumns());
        this.resultRegID = ResultDataHandler.getInstance().getProcessor().registerForUpdate(this.resultTableName);
    }

    public boolean checkAuthorization(String domainName, Long loginId, String guid) {
        boolean ret;
        block4: {
            ret = false;
            ArrayList ouList = (ArrayList)this.authorizedDomainOUHash.get(domainName);
            try {
                if (ouList.size() != 0) {
                    ArrayList<String> attribList = new ArrayList<String>();
                    attribList.add("distinguishedName");
                    guid = guid.substring(guid.indexOf("{") + 1, guid.lastIndexOf("}"));
                    Properties prop = ADHandler.getObjectFromGUID((String)domainName, (Long)loginId, (String)guid, attribList);
                    String dn = (String)((ArrayList)prop.get("distinguishedName")).get(0);
                    for (int i = 0; i < ouList.size(); ++i) {
                        String distinguishedName = (String)ouList.get(i);
                        String domainDN = DomainUtil.getDefaultNamingContext((String)domainName);
                        if (!distinguishedName.toLowerCase().endsWith(domainDN.toLowerCase()) || !dn.toLowerCase().endsWith(distinguishedName.toLowerCase())) continue;
                        ret = true;
                        break block4;
                    }
                    break block4;
                }
                ret = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    public void updateResult() {
        ReportHandler.checkAndAddSIDReportResult((Long)this.generationId, (String)this.resultTableName, (ArrayList)this.guidList);
        this.guidList = new ArrayList();
    }

    public void exportReport(String reportFileName, String reportType, ArrayList attributelist, Map inputParams, HttpServletRequest request, HttpServletResponse response, String beanName, String inputSource) {
        Locale locale = I18NUtil.getDefaultLocale((HttpServletRequest)request);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Hashtable columnWidths;
            Integer widthValue;
            HttpSession session = request.getSession();
            ReportBean bean = (ReportBean)((Object)session.getAttribute(beanName));
            boolean showSerialNo = JRFieldDesignUtil.getShowSerialNo();
            Integer reportId = (Integer)bean.get("reportId");
            String ascending = (String)bean.get("ascending");
            String reportName = (String)ReportHandler.getReportDetailsRow((Integer)reportId).get("REPORT_NAME");
            Hashtable multipleValuesSids = new Hashtable();
            AbstractListener listener = bean.getListener();
            Criteria crit = ReportResultUtil.getModifiedSidCriteria(listener.getResultTableName());
            ArrayList list = null;
            if (inputSource != null && inputSource.equalsIgnoreCase("csv")) {
                Hashtable hash = this.getCSVModifyRows(CSVUserBean.USER_ATTRIBUTE_TABLE, bean);
                list = (ArrayList)hash.get("resultList");
                attributelist = (ArrayList)hash.get("attributelist");
            } else {
                list = ReportResultUtil.getModifyRows(this.generationId, this.baseTableName, this.resultTableName, attributelist, null, new Boolean(ascending), -1, -1, multipleValuesSids, crit);
            }
            this.setExportRowCount(list.size());
            Properties props = new Properties();
            props.put("ATTRIB_COLUMN_NAME", "STATUS");
            props.put("ATTRIB_DISP_NAME", rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.status"));
            props.put("ATTRIB_LDAP_NAME", "status");
            props.put("ATTRIB_ID", (Object)100000);
            props.put("RELATIONAL_TYPE", (Object)0);
            attributelist.add(props);
            ReportHandler.getMultipleValues((ArrayList)attributelist, multipleValuesSids);
            ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
            if (reportId.equals(ReportsUtil.RESET_PASSWORD_USER_MGMT_REPORT_ID) && PasswordUtil.getShowPasswordValue()) {
                for (Hashtable row : list) {
                    row.put(new Integer(1047), "********");
                }
            }
            if (reportId.equals(ReportsUtil.DELETE_USER_MGMT_REPORT_ID)) {
                for (Hashtable row : list) {
                    if (this.guidVsPolicyStatusMap.get(row.get("OBJECT_GUID")) == null || ((HashMap)this.guidVsPolicyStatusMap.get(row.get("OBJECT_GUID"))).isEmpty()) continue;
                    String message = (String)row.get("MESSAGE");
                    Map policyStatusMap = (Map)this.guidVsPolicyStatusMap.get(row.get("OBJECT_GUID"));
                    for (Map.Entry entry : policyStatusMap.entrySet()) {
                        String key = (String)entry.getKey();
                        String value = (String)policyStatusMap.get(key);
                        message = message + value;
                    }
                    row.put("MESSAGE", message);
                }
            }
            ReportJRDataSource dataSource = new ReportJRDataSource(list, multipleValuesSids, showSerialNo, ReportExportUtil.STARTING_SERIAL_NUMBER, reportType);
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            reportName = JRFieldDesignUtil.getReportName(reportName, rb);
            jasperDesign.setName(reportName);
            JRFieldDesignUtil.setPDFFontForPageHeaderTitleBand(reportType, jasperDesign, locale);
            request.setAttribute("reportFileName", (Object)reportFileName);
            reportFileName = "ADMPReport";
            if (reportType.toLowerCase().indexOf("xls") != -1 || reportType.toLowerCase().indexOf("csv") != -1) {
                if (reportType.toLowerCase().indexOf("csv") != -1) {
                    JRDesignBand titleBand = (JRDesignBand)jasperDesign.getTitle();
                    JRElement[] elements = titleBand.getElements();
                    for (int i = 0; i < elements.length; ++i) {
                        titleBand.removeElement((JRDesignElement)elements[i]);
                    }
                    titleBand.setHeight(0);
                    JRDesignBand pageHeaderBand = (JRDesignBand)jasperDesign.getPageHeader();
                    JRElement[] elements1 = pageHeaderBand.getElements();
                    for (int i = 0; i < elements1.length; ++i) {
                        pageHeaderBand.removeElement((JRDesignElement)elements1[i]);
                    }
                    pageHeaderBand.setHeight(0);
                }
                JRDesignBand pageFooterBand = (JRDesignBand)jasperDesign.getPageFooter();
                JRElement[] elements2 = pageFooterBand.getElements();
                for (int i = 0; i < elements2.length; ++i) {
                    pageFooterBand.removeElement((JRDesignElement)elements2[i]);
                }
                pageFooterBand.setHeight(0);
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.TRUE);
            } else if (reportType.toLowerCase().indexOf("html") != -1 || reportType.toLowerCase().indexOf("pdf") != -1) {
                inputParams.put("IS_IGNORE_PAGINATION", Boolean.FALSE);
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable exportParams = JRFieldDesignUtil.exportSettings();
            int pageColumnWidth = jasperDesign.getColumnWidth();
            boolean flexWidth = true;
            String fixedExportWidth = (String)exportParams.get("FIXED_EXPORT_WIDTH");
            if (fixedExportWidth != null && fixedExportWidth.equalsIgnoreCase("TRUE")) {
                flexWidth = false;
                pageColumnWidth = JRFieldDesignUtil.getPageColumnWidth(exportParams, jasperDesign);
            }
            if ((widthValue = (Integer)(columnWidths = JRDesignUtil.calculateWidth(attributelist, list, multipleValuesSids, reportType, request, new Hashtable(), pageColumnWidth, flexWidth, showSerialNo, rb)).remove("maxColumnWidth")) != null) {
                pageColumnWidth = widthValue + (columnWidths.size() + 1) * 2;
                jasperDesign.setColumnWidth(pageColumnWidth);
                jasperDesign.setPageWidth(pageColumnWidth + 60);
            }
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributelist, reportType, null, 0, rb, loginId, showSerialNo, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            HashMap formatPatternMap = DateTimeUtil.getFormatPatternsMap((Long)loginId);
            JasperPrint print = null;
            try {
                print = JasperFillManager.fillReport((JasperReport)jasperReport, (Map)inputParams, (JRDataSource)dataSource);
            }
            catch (Exception e) {
                e.printStackTrace();
                logger.log(Level.INFO, "Input Params After Filling " + inputParams);
                return;
            }
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, loginId, this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Hashtable getCSVModifyRows(String resultTableName, ReportBean bean) {
        Hashtable hash = new Hashtable();
        ArrayList resultList = new ArrayList();
        ArrayList<Hashtable> attributelist = new ArrayList<Hashtable>();
        try {
            ArrayList resultAttribList = (ArrayList)bean.get("resultAttributeList");
            for (Hashtable validHeader : resultAttribList) {
                if (validHeader.get("ATTRIB_ID") == null) continue;
                Hashtable attributeProps = ReportAttributeHandler.getInstance().getAttributeID((String)validHeader.get("ATTRIB_LDAP_NAME"), new Integer(0), new Integer(2000));
                attributelist.add(attributeProps);
            }
            Column col = new Column(resultTableName, "USER_CREATION_ID");
            Criteria crit = new Criteria(col, (Object)this.generationId, 0);
            crit = crit.and(Column.getColumn((String)resultTableName, (String)"CREATION_MESSAGE"), (Object)"NULL", 1);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(resultTableName, crit);
            HashMap pwdMap = null;
            String tempTable = "ADSMUserBUMDetails_" + String.valueOf(this.generationId);
            TableDefinition td = MetaDataUtil.getTableDefinitionByName((String)tempTable);
            if (td != null) {
                AddUserHandler.getInstance();
                pwdMap = AddUserHandler.getFromBulkUserLayoutTempTable((String)tempTable);
            }
            if (dataObj != null) {
                Iterator it = dataObj.getRows(resultTableName);
                while (it.hasNext()) {
                    Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
                    Row row = (Row)it.next();
                    Long userIdx = (Long)row.get("USER_INDEX");
                    for (Hashtable attributeProps : resultAttribList) {
                        String columnName = (String)attributeProps.get("ATTRIB_COLUMN_NAME");
                        Integer attributeId = (Integer)attributeProps.get("ATTRIB_ID");
                        if (attributeId != null && attributeId == 1047) {
                            String pwdVal = "-";
                            pwdVal = PasswordUtil.getShowPasswordValue() ? "********" : (pwdMap != null && userIdx != null ? (String)pwdMap.get(userIdx) : (String)row.get(columnName));
                            if (pwdVal == null) {
                                hashtable.put(attributeId, "-");
                                continue;
                            }
                            hashtable.put(attributeId, pwdVal);
                            continue;
                        }
                        if (attributeId != null && row.get(columnName) != null) {
                            hashtable.put(attributeId, (String)row.get(columnName));
                            continue;
                        }
                        if (!columnName.equals("CREATION_MESSAGE")) continue;
                        hashtable.put("MESSAGE", (String)row.get("CREATION_MESSAGE"));
                    }
                    resultList.add(hashtable);
                }
            }
            hash.put("resultList", resultList);
            hash.put("attributelist", attributelist);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public void nextMgmtActionByCsv(HttpServletRequest request, ReportBean bean, Long oldUserCreationId) {
        try {
            String[] domains = (String[])bean.get("domains");
            Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
            String defaultNamingContext = domains[0];
            String domainName = (String)dnDomainNameMap.get(defaultNamingContext);
            String sessionID = request.getSession().getId();
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String containerName = "CN=Users," + defaultNamingContext;
            this.generationId = AddUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, null, loginId);
            logger.log(Level.INFO, "New UserCreationId for nextMgmt action is : " + this.generationId);
            ArrayList attributelist = (ArrayList)bean.get("attributeList");
            Criteria filterCriteria = BulkModificationAPI.getFilterCriterForCsv(request);
            ReportClientUtil.copyUserCreationId(oldUserCreationId, this.generationId, filterCriteria, attributelist);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Exception occurs so setting genid to null");
            this.generationId = null;
            throw new IllegalArgumentException(this.rb.getString("admp.mgmt.common.statmsg.no_data_for_domain"));
        }
    }

    public void nextMgmtAction(ReportBean bean, String oldResultTableName, Long oldGenerationId, Criteria filterCriteria) throws Exception {
        try {
            this.generationId = ReportClientUtil.copyUserResult(bean, this.reportId, filterCriteria, oldResultTableName, oldGenerationId, this.resultTableName, this.loginId);
            logger.log(Level.INFO, "New generation id " + this.generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.generationId = null;
            throw new IllegalArgumentException(this.rb.getString("admp.mgmt.common.statmsg.no_data_for_domain"));
        }
    }

    public void reportAction(HttpServletRequest request, String oldResultTableName, Long oldGenerationId, String description, boolean isRequestFromHomeTab) throws Exception {
        ArrayList selectedSidList = new ArrayList();
        try {
            HttpSession session = request.getSession();
            ReportBean reportBean = (ReportBean)((Object)session.getAttribute("ReportBean"));
            selectedSidList = isRequestFromHomeTab ? ReportResultInputUtil.getSelectedSidsFromHomeTabRequest(request, reportBean) : ReportResultInputUtil.getSelectedSids(request, reportBean);
            this.generationId = ReportClientUtil.copyUserResult(selectedSidList, this.reportId, this.resultTableName, this.loginId, description);
            System.out.println("Moreaction copyuserresult new generationid " + this.generationId);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.generationId = null;
            throw new IllegalArgumentException(this.rb.getString("admp.mgmt.common.statmsg.no_data_for_domain"));
        }
    }

    protected long getId(String action) {
        if (this.actions == null || this.actionIds == null) {
            return -1L;
        }
        for (int i = 0; i < this.actions.length; ++i) {
            if (!this.actions[i].equals(action)) continue;
            return this.actionIds[i];
        }
        return -1L;
    }

    public void createRequest(HttpServletRequest request, ReportBean bean) {
    }

    public Long createRequest(ReportBean bean, ArrayList selectedSIDsList, Long loginId, String subject, String desc) {
        return null;
    }

    public void setCreateReqResultMsg(HttpServletRequest request, Long requestId) {
        if (requestId != null) {
            System.out.println("Request Creation Success : RequestId: " + requestId);
            request.setAttribute("message", (Object)"Success");
            request.setAttribute("requestId", (Object)requestId);
        } else {
            System.out.println("Failure : RequestId:");
            request.setAttribute("message", (Object)"Failure");
            request.setAttribute("requestId", (Object)requestId);
        }
    }

    public void populateIncludedAndExcludedGroup(String domainName, Long loginId) {
    }

    public void setCreateReqResultMsg(ReportBean bean, Long requestId) {
        if (requestId != null) {
            System.out.println("Request Creation Success : RequestId: " + requestId);
            bean.set("message", "Success");
            bean.set("requestId", requestId);
        } else {
            System.out.println("Failure : RequestId:");
            bean.set("message", "Failure");
            bean.set("requestId", requestId);
        }
    }

    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
    }

    @Override
    public ArrayList getReportAttributeList() {
        ArrayList attributeList = super.getReportAttributeList();
        if (attributeList.contains("authOrig") && !attributeList.contains("dLMemSubmitPerms")) {
            attributeList.add("dLMemSubmitPerms");
        }
        if (attributeList.contains("unauthOrig") && !attributeList.contains("dLMemRejectPerms")) {
            attributeList.add("dLMemRejectPerms");
        }
        return attributeList;
    }

    protected class Action
    extends Thread {
        private ArrayList containerList = null;
        private NativeListener listener = null;
        private String searchString = null;
        private Hashtable dnDomainNameMap = null;
        private Hashtable excludeChildOUHash = null;
        private ArrayList attributeList = null;
        private Long loginId = null;

        public Action(Long loginId, ArrayList list, ArrayList attrib, String s, NativeListener li, Hashtable d, Hashtable excludeChildOUHash) {
            this.loginId = loginId;
            this.containerList = list;
            this.listener = li;
            this.searchString = s;
            this.dnDomainNameMap = d;
            this.excludeChildOUHash = excludeChildOUHash;
            this.attributeList = attrib;
        }

        @Override
        public void run() {
            ModifyUserListener.this.errorMessage = null;
            ModifyUserListener.this.guidList = new ArrayList();
            ModifyUserListener.this.registerQueue();
            for (int i = 0; i < this.containerList.size(); ++i) {
                try {
                    String dn = (String)this.containerList.get(i);
                    ModifyUserListener.this.domainName = (String)this.dnDomainNameMap.get(dn);
                    ModifyUserListener.this.setTableProps(ModifyUserListener.this.domainName);
                    Boolean isExcludeChildOU = Boolean.FALSE;
                    if (this.excludeChildOUHash != null && this.excludeChildOUHash.containsKey(dn)) {
                        isExcludeChildOU = (Boolean)this.excludeChildOUHash.get(dn);
                    }
                    if (this.attributeList.contains("password")) {
                        this.attributeList.remove("password");
                    }
                    ModifyUserListener.this.toBeExecutedAttributeList = this.attributeList;
                    this.listener.setIsExcludeChildOU(isExcludeChildOU);
                    QueryGenerator queryGen = QueryGeneratorFactory.getInstance().getQueryGenerator();
                    ModifyUserListener.this.addlResultIps.put("MESSAGE", queryGen.getDBNullValue());
                    logger.log(Level.INFO, "Searching the SIDs for the String " + this.searchString + " from the domain " + dn);
                    ADHandler.getObjects((String)ModifyUserListener.this.domainName, (Long)this.loginId, (String)dn, (ArrayList)this.attributeList, (String)this.searchString, (NativeListener)this.listener);
                    ModifyUserListener.this.updateQueue();
                    continue;
                }
                catch (Exception e) {
                    ModifyUserListener.this.errorMessage = e.getMessage();
                    e.printStackTrace();
                }
            }
            ModifyUserListener.this.updatedCount = 0;
            ModifyUserListener.this.totalCount = 0;
            ModifyUserListener.this.completedAction();
            ModifyUserListener.this.addlResultIps.clear();
        }
    }

    protected class ModifyAction
    extends Thread {
        private ArrayList list = null;
        ReportBean bean = null;
        private ArrayList attributeList = null;
        private ArrayList messageList = null;
        private int modifyCount = 0;
        private Long loginId = null;
        private String hostId = "";
        private Integer objectId = 0;

        public ModifyAction(Long loginId, String hostId, ReportBean b, ArrayList list, ArrayList attrib, Integer objectId) {
            this.bean = b;
            this.list = list;
            this.messageList = new ArrayList();
            this.attributeList = attrib;
            this.modifyCount = 0;
            this.loginId = loginId;
            this.hostId = hostId;
            this.objectId = objectId;
        }

        private void updatePreviousList() {
            if (this.messageList.size() > 0) {
                for (int i = 0; i < this.messageList.size(); ++i) {
                    ModifyUserListener.this.out.write((String)this.messageList.get(i));
                    ModifyUserListener.this.out.flush();
                }
                this.messageList.clear();
            }
        }

        private void updateMessage(String guid, String message) {
            ++this.modifyCount;
            String s = "<script>if(this.load) updateMessage('" + guid + "','" + ClientUtil.scriptEscape(message) + "')</script>";
            String s1 = "<script>if(this.load) updateCount('" + this.modifyCount + "')</script>";
            if (ModifyUserListener.this.out != null) {
                this.updatePreviousList();
                ModifyUserListener.this.out.write(s);
                ModifyUserListener.this.out.flush();
                ModifyUserListener.this.out.write(s1);
                ModifyUserListener.this.out.flush();
            } else {
                this.messageList.add(s);
                this.messageList.add(s1);
            }
            ReportHandler.updateSIDMessage((String)ModifyUserListener.this.resultTableName, (Long)ModifyUserListener.this.generationId, (String)guid, (String)message);
        }

        @Override
        public void run() {
            ModifyUserListener listener = (ModifyUserListener)this.bean.getListener();
            String[] domains = (String[])this.bean.get("domains");
            Hashtable dnDomainNameMap = (Hashtable)this.bean.get("dnDomainNameMap");
            String domain = domains[0];
            Integer updatedObjects = CommonUtil.getUpdatedObjects((AdventNetResourceBundle)ModifyUserListener.this.rb, (String)ModifyUserListener.this.tableName);
            Integer noOfObjects1 = 0;
            if (!ModifyUserListener.this.noOfObjects.equalsIgnoreCase("unlimited")) {
                noOfObjects1 = Integer.parseInt(ModifyUserListener.this.noOfObjects);
            }
            ModifyUserListener.this.domainName = (String)dnDomainNameMap.get(domain);
            ModifyUserListener.this.setValidDC(ModifyUserListener.this.domainName, this.loginId);
            ModifyUserListener.this.initdcFqdnHash();
            ModifyUserListener.this.populateIncludedAndExcludedGroup(ModifyUserListener.this.domainName, this.loginId);
            if (ModifyUserListener.this.domainName == null) {
                domain = DomainUtil.getDefaultNamingContext((String)domain);
                ModifyUserListener.this.domainName = (String)dnDomainNameMap.get(domain);
            }
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("domain", ModifyUserListener.this.domainName);
            this.bean.set("inputParams", inputParams);
            ModifyUserListener.this.setTableProps(ModifyUserListener.this.domainName);
            ModifyUserListener.this.registerQueue();
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)ModifyUserListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)ModifyUserListener.this.rb);
                String batchName = "ADMP_Export_" + System.currentTimeMillis();
                ModifyUserListener.this.updateResult = false;
                Hashtable resultList = new Hashtable();
                ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
                ArrayList<String> objectOUList = new ArrayList<String>();
                for (int i = 0; i < this.list.size() && ModifyUserListener.this.continueAction; ++i) {
                    String ouName;
                    Hashtable result = (Hashtable)this.list.get(i);
                    String objName = ModifyUserListener.this.getObjectName(result);
                    String dnValue = "";
                    result.remove(1047);
                    logger.log(Level.INFO, "The result Values is : " + result);
                    String guid = (String)result.get("OBJECT_GUID");
                    dnValue = (String)result.get(1004);
                    if (dnValue == null) {
                        dnValue = (String)result.get(3020);
                    }
                    if (dnValue == null) {
                        dnValue = (String)result.get(2003);
                    }
                    if (dnValue == null) {
                        dnValue = (String)result.get(10004);
                    }
                    if (dnValue == null) {
                        dnValue = (String)result.get(8003);
                    }
                    if (dnValue == null) {
                        dnValue = "";
                    }
                    if (!objectOUList.contains(ouName = DirectoryObjectUtil.getOUNameFromDN((String)dnValue))) {
                        objectOUList.add(ouName);
                    }
                    String resultDomainName = ModifyUserListener.this.domainName;
                    listener.setDomainName(resultDomainName);
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, (String)objName, (String)resultDomainName, (DataObject)auditDataObj);
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    audit_info.put("object_id", object_id);
                    String message = "";
                    if (ModifyUserListener.this.isLicenseExceeded) {
                        message = ModifyUserListener.this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.license_error");
                        this.updateMessage(guid, message);
                    } else {
                        result.put("batchName", batchName);
                        if (ModifyUserListener.this.checkAuthorization(resultDomainName, this.loginId, guid)) {
                            message = ModifyUserListener.this.modifyUser(result, this.attributeList, this.bean, resultDomainName, this.loginId, audit_info, auditDataObj);
                            Hashtable<String, String> managerAndPwd = new Hashtable<String, String>();
                            String managerVal = "";
                            if (result.get("manager") != null) {
                                managerVal = (String)result.get("manager");
                            }
                            if (managerVal != null && !managerVal.equals("")) {
                                managerAndPwd.put("manager", managerVal);
                            }
                            if (audit_info.get("password") != null && !audit_info.get("password").equals("")) {
                                managerAndPwd.put("password", (String)audit_info.get("password"));
                            }
                            resultList.put(objName, managerAndPwd);
                        } else {
                            message = ModifyUserListener.this.tableName.equalsIgnoreCase("ADSMModifyComputerResult") ? ModifyUserListener.this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.not_authorised_computer") : ModifyUserListener.this.rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.not_authorised_user");
                        }
                        this.updateMessage(guid, message);
                        if (message.toLowerCase().contains(ModifyUserListener.this.rb.getString("admp.admin.notification_profile.audit_obj_check.successfully_updated").toLowerCase())) {
                            auditObjectIdList.add(object_id);
                        }
                    }
                    if (audit_info.get("auditMessage") != null) {
                        message = message + audit_info.get("auditMessage");
                    }
                    audit_info.put("error_msg", message);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                UserHandler.updateIsDeletedFlag(ModifyUserListener.this.modifiedGuidList);
                ModifyUserListener.this.cleardcFqdnHash();
                ModifyUserListener.this.completedAction();
                ModifyUserListener.this.updateResult = true;
                ModifyUserListener.this.totalCount = 0;
                this.messageList.clear();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    Integer[] contactReportIds = new Integer[]{3003, 3004, 3005, 3006, 3013};
                    List<Integer> contactReportIdsList = Arrays.asList(contactReportIds);
                    Integer[] ouReportIds = new Integer[]{9006, 9007};
                    List<Integer> ouReportIdsList = Arrays.asList(ouReportIds);
                    if (contactReportIdsList.contains(ModifyUserListener.this.reportId)) {
                        this.objectId = 4;
                    } else if (ouReportIdsList.contains(ModifyUserListener.this.reportId)) {
                        this.objectId = 5;
                    }
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, this.objectId, resultList, this.loginId, ModifyUserListener.this.reportId, ModifyUserListener.this.domainName, ModifyUserListener.this.rb, null, objectOUList);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected class ModifyCSVAction
    extends Thread {
        private ArrayList list = null;
        ReportBean bean = null;
        private ArrayList messageList = null;
        private int modifyCount = 0;
        private Long loginId = null;
        private String hostId = "";
        private Integer objectId = 0;

        public ModifyCSVAction(Long loginId, String hostId, ReportBean b, ArrayList list, Integer objectId) {
            this.bean = b;
            this.list = list;
            this.messageList = new ArrayList();
            this.modifyCount = 0;
            this.loginId = loginId;
            this.hostId = hostId;
            this.objectId = objectId;
        }

        private void updatePreviousList() {
            if (this.messageList.size() > 0) {
                for (int i = 0; i < this.messageList.size(); ++i) {
                    ModifyUserListener.this.out.write((String)this.messageList.get(i));
                    ModifyUserListener.this.out.flush();
                }
                this.messageList.clear();
            }
        }

        private void updateMessage(Long userIndex, String message) {
            ++this.modifyCount;
            String s = "<script>if(this.load) updateMessage('" + userIndex.toString() + "','" + ClientUtil.scriptEscape(message) + "')</script>";
            String s1 = "<script>if(this.load) updateCount('" + this.modifyCount + "')</script>";
            if (ModifyUserListener.this.out != null) {
                this.updatePreviousList();
                ModifyUserListener.this.out.write(s);
                ModifyUserListener.this.out.flush();
                ModifyUserListener.this.out.write(s1);
                ModifyUserListener.this.out.flush();
            } else {
                this.messageList.add(s);
                this.messageList.add(s1);
            }
            Properties prop = new Properties();
            prop.setProperty("CREATION_STATUS", "WARNING");
            prop.setProperty("CREATION_MESSAGE", message);
            prop.put("USER_INDEX", userIndex);
            AddUserHandler.getInstance().updateCreationStatus(ModifyUserListener.this.rb, prop);
        }

        @Override
        public void run() {
            String[] domains = (String[])this.bean.get("domains");
            Hashtable dnDomainNameMap = (Hashtable)this.bean.get("dnDomainNameMap");
            String defaultNamingContext = domains[0];
            ModifyUserListener.this.domainName = (String)dnDomainNameMap.get(defaultNamingContext);
            ModifyUserListener.this.setValidDC(ModifyUserListener.this.domainName, this.loginId);
            ModifyUserListener.this.initdcFqdnHash();
            ModifyUserListener.this.populateIncludedAndExcludedGroup(ModifyUserListener.this.domainName, this.loginId);
            Integer updatedObjects = CommonUtil.getCSVImportObjectCount((AdventNetResourceBundle)ModifyUserListener.this.rb);
            Integer noOfObjects1 = 0;
            Hashtable resultList = new Hashtable();
            ArrayList<String> objectOUList = new ArrayList<String>();
            ArrayList<Long> auditObjectIdList = new ArrayList<Long>();
            if (!ModifyUserListener.this.noOfObjects.equalsIgnoreCase("unlimited")) {
                noOfObjects1 = Integer.parseInt(ModifyUserListener.this.noOfObjects);
            }
            HashMap<String, String> inputParams = new HashMap<String, String>();
            inputParams.put("domain", ModifyUserListener.this.domainName);
            this.bean.set("inputParams", inputParams);
            ModifyUserListener.this.setTableProps(ModifyUserListener.this.domainName, new Long(-1L));
            ModifyUserListener.this.registerQueue();
            ModifyUserListener.this.updateResult = false;
            String keyLdapName = (String)this.bean.get("keyLdapName");
            try {
                DataObject auditDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
                Long audit_id = HDTAuditUtil.fillAuditDetails((Long)this.loginId, (String)this.hostId, (Integer)ModifyUserListener.this.reportId, (DataObject)auditDataObj, (AdventNetResourceBundle)ModifyUserListener.this.rb);
                BeanMap pwdProps = (BeanMap)this.bean.get("props");
                String resetPwdOption = pwdProps.getProperty("resetPasswordOption");
                ArrayList<Long> userIndexIds = new ArrayList<Long>();
                for (int i = 0; ModifyUserListener.this.continueAction && i < this.list.size(); ++i) {
                    String dnValue;
                    String ouName;
                    Hashtable hashtable = (Hashtable)this.list.get(i);
                    Long userIndex = (Long)hashtable.get("USER_INDEX");
                    userIndexIds.add(userIndex);
                    String keyLdapValue = null;
                    String message = "";
                    Hashtable<String, Object> audit_info = new Hashtable<String, Object>();
                    ArrayList valuesList = (ArrayList)hashtable.get("USER_VALUES");
                    for (Hashtable hashtable1 : valuesList) {
                        String ldapName = (String)hashtable1.get("ATTRIB_LDAP_NAME");
                        if (!ldapName.equals(keyLdapName)) continue;
                        keyLdapValue = hashtable1.get("ATTRIB_VALUE").toString();
                        break;
                    }
                    Long object_id = HDTAuditUtil.fillAuditObjDetails((Long)audit_id, keyLdapValue, (String)ModifyUserListener.this.domainName, (DataObject)auditDataObj);
                    audit_info.put("object_id", object_id);
                    if (noOfObjects1 == 100 && updatedObjects > noOfObjects1 || ModifyUserListener.this.isLicenseExceeded) {
                        message = MessageFormat.format(ModifyUserListener.this.rb.getString("admp.mgmt.user_mgmt.common.license_exceeded_message"), LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers"));
                        this.updateMessage(userIndex, message);
                    } else {
                        String searchString = ModifyUserListener.this.getCSVQuery(keyLdapName, keyLdapValue);
                        message = ModifyUserListener.this.modifyCSVUser(searchString, this.bean, defaultNamingContext, this.loginId, audit_info, auditDataObj);
                        this.updateMessage(userIndex, message);
                    }
                    String managerVal = "";
                    Hashtable<String, String> managerAndPwd = new Hashtable<String, String>();
                    if (hashtable.get("manager") != null) {
                        managerVal = (String)hashtable.get("manager");
                    }
                    if (managerVal != null && !managerVal.equals("")) {
                        managerAndPwd.put("manager", managerVal);
                    }
                    if (audit_info.get("password") != null && !audit_info.get("password").equals("")) {
                        managerAndPwd.put("password", (String)audit_info.get("password"));
                    }
                    resultList.put(keyLdapValue, managerAndPwd);
                    if (message.toLowerCase().contains(ModifyUserListener.this.rb.getString("admp.admin.notification_profile.audit_obj_check.successfully_updated").toLowerCase())) {
                        auditObjectIdList.add((Long)audit_info.get("object_id"));
                    }
                    if (!objectOUList.contains(ouName = DirectoryObjectUtil.getOUNameFromDN((String)(dnValue = (String)audit_info.get("distinguishedName"))))) {
                        objectOUList.add(ouName);
                    }
                    audit_info.put("error_msg", message);
                    HDTAuditUtil.fillAuditObjectStatus(audit_info, (DataObject)auditDataObj);
                }
                Long creationId = ModifyUserListener.this.getGenerationId();
                boolean savePassword = PasswordUtil.getSavePasswordValue();
                if (!savePassword) {
                    if (resetPwdOption != null && resetPwdOption.equals("true")) {
                        AddUserHandler.getInstance();
                        String tempTableName = AddUserHandler.createBulkUserLayoutTempTable((Long)creationId);
                        AddUserHandler.getInstance();
                        AddUserHandler.copyIntoBulkUserLayoutTempTable((Long)creationId, userIndexIds, (String)tempTableName);
                    }
                    AddUserHandler.getInstance();
                    AddUserHandler.clearPwdForBUM((Long)creationId);
                }
                ModifyUserListener.this.cleardcFqdnHash();
                ModifyUserListener.this.updateQueue();
                ModifyUserListener.this.isCompleted = true;
                ModifyUserListener.this.totalCount = 0;
                ModifyUserListener.this.endQueue();
                ModifyUserListener.this.updateResult = true;
                this.messageList.clear();
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(auditDataObj);
                if (auditObjectIdList.size() > 0) {
                    MgmtNotificationListener notifyListener = new MgmtNotificationListener();
                    Integer[] contactReportIds = new Integer[]{3003, 3004, 3005, 3006, 3013};
                    List<Integer> contactReportIdsList = Arrays.asList(contactReportIds);
                    Integer[] ouReportIds = new Integer[]{9006, 9007};
                    List<Integer> ouReportIdsList = Arrays.asList(ouReportIds);
                    if (contactReportIdsList.contains(ModifyUserListener.this.reportId)) {
                        this.objectId = 4;
                    } else if (ouReportIdsList.contains(ModifyUserListener.this.reportId)) {
                        this.objectId = 5;
                    }
                    notifyListener.triggerNotification(auditDataObj, auditObjectIdList, this.objectId, resultList, this.loginId, ModifyUserListener.this.reportId, ModifyUserListener.this.domainName, ModifyUserListener.this.rb, null, objectOUList);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

