/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.usermanagement.MoveHomeFoldersListener;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class MoveDeleteTSHomeFolderListener
extends MoveHomeFoldersListener {
    public MoveDeleteTSHomeFolderListener() {
        this.reportId = new Integer(1039);
    }

    @Override
    public ArrayList getModifiedViewColumns(Integer reportId) {
        ArrayList attribList = super.getModifiedViewColumns(reportId);
        Properties tsProfilePathProps = new Properties();
        tsProfilePathProps.put("ATTRIB_COLUMN_NAME", "TS_PROFILE_PATH");
        tsProfilePathProps.put("ATTRIB_ID", new Integer(1120));
        tsProfilePathProps.put("ATTRIB_DISP_NAME", "reports.TS.TS_profile_path");
        tsProfilePathProps.put("TABLE_NAME", "ADSMUserTerminalDetails");
        tsProfilePathProps.put("ATTRIB_LDAP_NAME", "tsProfilePath");
        tsProfilePathProps.put("RELATIONAL_TYPE", new Integer(0));
        attribList.add(tsProfilePathProps);
        Properties tsHomeDriveProps = new Properties();
        tsHomeDriveProps.put("ATTRIB_COLUMN_NAME", "TS_HOME_DRIVE");
        tsHomeDriveProps.put("ATTRIB_ID", new Integer(1122));
        tsHomeDriveProps.put("ATTRIB_DISP_NAME", "reports.TS.TS_home_drive");
        tsHomeDriveProps.put("TABLE_NAME", "ADSMUserTerminalDetails");
        tsHomeDriveProps.put("ATTRIB_LDAP_NAME", "tsHomeDirDrive");
        tsHomeDriveProps.put("RELATIONAL_TYPE", new Integer(0));
        attribList.add(tsHomeDriveProps);
        Properties tsHomeFolderProps = new Properties();
        tsHomeFolderProps.put("ATTRIB_COLUMN_NAME", "TS_HOME_DIRECTORY");
        tsHomeFolderProps.put("ATTRIB_ID", new Integer(1121));
        tsHomeFolderProps.put("ATTRIB_DISP_NAME", "reports.TS.TS_home_directory");
        tsHomeFolderProps.put("TABLE_NAME", "ADSMUserTerminalDetails");
        tsHomeFolderProps.put("ATTRIB_LDAP_NAME", "tsHomeDir");
        tsHomeFolderProps.put("RELATIONAL_TYPE", new Integer(0));
        attribList.add(tsHomeFolderProps);
        Properties tsHomeFolderFlagProps = new Properties();
        tsHomeFolderFlagProps.put("ATTRIB_COLUMN_NAME", "TS_REMOTE_HOME_DIRECTORY");
        tsHomeFolderFlagProps.put("ATTRIB_ID", new Integer(1123));
        tsHomeFolderFlagProps.put("ATTRIB_DISP_NAME", "reports.TS.TS_remote_home_directory");
        tsHomeFolderFlagProps.put("TABLE_NAME", "ADSMUserTerminalDetails");
        tsHomeFolderFlagProps.put("ATTRIB_LDAP_NAME", "tsServerRemoteHomeDir");
        tsHomeFolderFlagProps.put("RELATIONAL_TYPE", new Integer(0));
        attribList.add(tsHomeFolderFlagProps);
        return attribList;
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        BeanMap props = (BeanMap)bean.get("props");
        String tsHomeFolderAction = (String)props.get("tsHomeFolderAction");
        if (tsHomeFolderAction.equalsIgnoreCase("move")) {
            return this.moveTSHomeFolder(result, attributeList, bean, domainName, loginId, audit_info, auditDataObj);
        }
        if (tsHomeFolderAction.equalsIgnoreCase("delete")) {
            return this.deleteTSHomeFolder(result, attributeList, bean, domainName, loginId, audit_info, auditDataObj);
        }
        return "";
    }

    public String moveTSHomeFolder(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        logger.log(Level.INFO, "moveTSHomeFolder");
        StringBuffer finalMessage = new StringBuffer();
        try {
            String sid = this.getValue(result, 1144);
            String userName = this.getValue(result, 1006);
            String dn = this.getValue(result, 1004);
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            List<String> tempAttributesList = Arrays.asList(selectedAttributes);
            ArrayList<String> selectedAttributesList = new ArrayList<String>(tempAttributesList);
            BeanMap props = (BeanMap)bean.get("props");
            boolean tsRetainHomeFolder = false;
            boolean tsRetainProfilePath = false;
            if (selectedAttributesList.contains("tsRetainHomeFolder")) {
                tsRetainHomeFolder = true;
                selectedAttributesList.remove(selectedAttributesList.indexOf("tsRetainHomeFolder"));
            }
            if (selectedAttributesList.contains("tsRetainProfilePath")) {
                tsRetainProfilePath = true;
                selectedAttributesList.remove(selectedAttributesList.indexOf("tsRetainProfilePath"));
            }
            for (String selectedAttribute : selectedAttributesList) {
                StringBuffer message;
                String movefrom;
                String moveto;
                String drive;
                String task;
                boolean tsProfilePath;
                boolean tsHomefolder;
                block53: {
                    tsHomefolder = false;
                    tsProfilePath = false;
                    boolean moveSuccess = false;
                    boolean v2Exists = false;
                    String value2 = new String();
                    task = new String();
                    drive = new String();
                    moveto = (String)props.get(selectedAttribute);
                    movefrom = "";
                    if (selectedAttribute.equals("tsMoveHomeDirectoryTo")) {
                        tsHomefolder = true;
                        movefrom = this.getValue(result, 1121);
                    } else if (selectedAttribute.equals("tsMoveProfilePathTo")) {
                        tsProfilePath = true;
                        movefrom = this.getValue(result, 1120);
                    }
                    message = new StringBuffer();
                    if (!movefrom.equals("") && movefrom.length() != 0 && movefrom.startsWith("\\\\")) {
                        try {
                            String value = moveto;
                            if (!moveto.endsWith("\\")) {
                                value = moveto.concat("\\");
                            }
                            value2 = value.concat(movefrom.substring(movefrom.lastIndexOf(92) + 1));
                            value2 = FormatClientUtil.getFormatValue(value2, result, domainName, "");
                            ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)movefrom, (String)value2);
                            moveSuccess = true;
                            if (tsProfilePath) {
                                String v2movefrom = movefrom;
                                v2movefrom = v2movefrom.concat(".V2");
                                String v2moveto = value2.concat(".V2");
                                File f = new File(v2movefrom);
                                if (f.exists() && f.isDirectory()) {
                                    v2Exists = true;
                                    ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)v2movefrom, (String)v2moveto);
                                } else {
                                    logger.log(Level.INFO, "V2 Profile Path Doesn't Exist");
                                }
                            }
                            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                            Properties p = new Properties();
                            if (selectedAttribute.equals("tsMoveHomeDirectoryTo")) {
                                p.put("ATTRIB_LDAP_NAME", "tsHomeDir");
                            } else if (selectedAttribute.equals("tsMoveProfilePathTo")) {
                                p.put("ATTRIB_LDAP_NAME", "tsProfilePath");
                            }
                            p.put("ATTRIB_VALUE", value2);
                            setAttributeList.add(p);
                            if (selectedAttribute.equals("tsMoveHomeDirectoryTo")) {
                                Properties p1 = new Properties();
                                p1.put("ATTRIB_LDAP_NAME", "tsHomeDirDrive");
                                drive = (String)props.get("tsMoveHomeDriveTo");
                                p1.put("ATTRIB_VALUE", drive);
                                setAttributeList.add(p1);
                            }
                            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                            try {
                                ADHandler.setTerminalServiceProps((String)domainName, (Long)loginId, (String)userName, setAttributeList, (String)sid, (String)dn);
                                if (tsHomefolder) {
                                    message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.successfully_moved_ts_homefolder"));
                                }
                                if (tsProfilePath) {
                                    message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.successfully_moved_ts_profile_path"));
                                }
                                if (tsHomefolder && !tsRetainHomeFolder) {
                                    boolean tsHomeDeleteStatus = true;
                                    tsHomeDeleteStatus = this.deleteSharedFolder(false, movefrom, domainName, loginId);
                                    if (!tsHomeDeleteStatus) {
                                        message.append(this.rb.getString("admp.mgmt.user_mgmt.move_tshomefolders.statmsg.unable_delete"));
                                    }
                                }
                                if (!tsProfilePath || tsRetainProfilePath) break block53;
                                boolean tsProfileDeleteStatus = true;
                                tsProfileDeleteStatus = v2Exists ? this.deleteSharedFolder(true, movefrom, domainName, loginId) : this.deleteSharedFolder(false, movefrom, domainName, loginId);
                                if (!tsProfileDeleteStatus) {
                                    message.append(this.rb.getString("admp.mgmt.user_mgmt.move_tsprofilepath.statmsg.unable_delete"));
                                }
                                break block53;
                            }
                            catch (LocalizedException le) {
                                if (tsProfilePath) {
                                    if (v2Exists) {
                                        this.deleteSharedFolder(true, value2, domainName, loginId);
                                    } else {
                                        this.deleteSharedFolder(false, value2, domainName, loginId);
                                    }
                                }
                                if (tsHomefolder) {
                                    this.deleteSharedFolder(false, value2, domainName, loginId);
                                }
                                if (tsHomefolder) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_homefolder"), le.getMessage(this.rb)));
                                }
                                if (tsProfilePath) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_profile_path"), le.getMessage(this.rb)));
                                }
                                break block53;
                            }
                            catch (Exception e) {
                                if (tsProfilePath) {
                                    if (v2Exists) {
                                        this.deleteSharedFolder(true, value2, domainName, loginId);
                                    } else {
                                        this.deleteSharedFolder(false, value2, domainName, loginId);
                                    }
                                }
                                if (tsHomefolder) {
                                    this.deleteSharedFolder(false, value2, domainName, loginId);
                                }
                                if (tsHomefolder) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_homefolder"), e.getMessage()));
                                }
                                if (tsProfilePath) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_profile_path"), e.getMessage()));
                                }
                                break block53;
                            }
                        }
                        catch (LocalizedException le) {
                            if (moveSuccess) {
                                this.deleteSharedFolder(false, value2, domainName, loginId);
                            }
                            if (tsHomefolder) {
                                message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_homefolder"), le.getMessage(this.rb)));
                            }
                            if (tsProfilePath) {
                                message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_profile_path"), le.getMessage(this.rb)));
                            }
                            break block53;
                        }
                        catch (Exception e) {
                            if (moveSuccess) {
                                this.deleteSharedFolder(false, value2, domainName, loginId);
                            }
                            if (tsHomefolder) {
                                message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_homefolder"), e.getMessage()));
                            }
                            if (tsProfilePath) {
                                message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_ts_profile_path"), e.getMessage()));
                            }
                            break block53;
                        }
                    }
                    if (tsHomefolder) {
                        message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_user_does_not_have_ts_homefolder"));
                    }
                    if (tsProfilePath) {
                        message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_move_user_does_not_have_ts_profile_path"));
                    }
                }
                String modifiedMoveFrom = movefrom;
                String retainedText = this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.folder_retained");
                String deletedText = this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.folder_deleted");
                if (tsProfilePath) {
                    task = this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.move_ts_profile");
                    modifiedMoveFrom = movefrom != null && movefrom != "" ? (tsRetainProfilePath ? modifiedMoveFrom + " " + retainedText : modifiedMoveFrom + " " + deletedText) : this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.no_home_folder");
                } else if (tsHomefolder) {
                    drive = (String)props.get("tsMoveHomeDriveTo");
                    task = this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.move_ts_homefolder");
                    modifiedMoveFrom = movefrom != null && movefrom != "" ? (tsRetainHomeFolder ? modifiedMoveFrom + "  " + retainedText : modifiedMoveFrom + "  " + deletedText) : this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.no_home_folder");
                }
                if (tsProfilePath || tsHomefolder) {
                    TechAuditAPI.getInstance().auditMoveHomeFolder(loginId, task, this.getValue(result, 1010), domainName, modifiedMoveFrom, moveto, drive, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb, tsProfilePath);
                }
                if (finalMessage.length() > 0) {
                    finalMessage.append(" ");
                }
                finalMessage.append(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalMessage.toString();
    }

    public String deleteTSHomeFolder(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        logger.log(Level.INFO, "deleteTSHomeFolder");
        StringBuffer message = new StringBuffer();
        try {
            String directoryPath = "";
            ArrayList<Properties> auditPropList = new ArrayList<Properties>();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            for (int i = 0; i < selectedAttributes.length; ++i) {
                boolean isDeleteTSHomeFolder = false;
                boolean isDeleteTSProfile = false;
                boolean isFolderDeleted = true;
                String action = selectedAttributes[i];
                Properties auditProp = new Properties();
                if (action.equalsIgnoreCase("tsDeleteHomeFolder")) {
                    isDeleteTSHomeFolder = true;
                    directoryPath = this.getValue(result, 1121);
                    auditProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.text.delete_ts_homefolder_from"));
                    auditProp.put("ATTRIB_VALUE", directoryPath);
                    auditPropList.add(auditProp);
                } else if (action.equalsIgnoreCase("tsDeleteProfile")) {
                    isDeleteTSProfile = true;
                    directoryPath = this.getValue(result, 1120);
                    auditProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.text.delete_ts_profile_from"));
                    auditProp.put("ATTRIB_VALUE", directoryPath);
                    auditPropList.add(auditProp);
                }
                logger.log(Level.INFO, "deleteTSHomeFolder action: " + action);
                String sid = this.getValue(result, 1144);
                String samAccountName = this.getValue(result, 1006);
                String dn = this.getValue(result, 1004);
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                if (this.validate(domainName, loginId, samAccountName, sid, dn, directoryPath, isDeleteTSHomeFolder, isDeleteTSProfile, message)) {
                    File folderPath = new File(directoryPath);
                    if (folderPath.exists() && folderPath.isDirectory()) {
                        isFolderDeleted = this.deleteTSFolder(domainName, loginId, directoryPath, isDeleteTSHomeFolder, isDeleteTSProfile, message);
                    } else {
                        logger.log(Level.INFO, "Folder Not Exists");
                        if (isDeleteTSHomeFolder) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.delete_user_no_ts_homefolder"));
                        }
                        if (isDeleteTSProfile) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.delete_user_no_ts_profile"));
                        }
                    }
                    if (isFolderDeleted) {
                        File vistaProfilePath;
                        if (isDeleteTSProfile && (vistaProfilePath = new File(directoryPath.concat(".V2"))).exists() && vistaProfilePath.isDirectory()) {
                            isFolderDeleted = this.deleteTSVistaFolder(domainName, loginId, directoryPath.concat(".V2"), message);
                        }
                        if (isFolderDeleted) {
                            DeleteUtil.clearADTSAttribute(domainName, loginId, samAccountName, dn, attributeList, isDeleteTSHomeFolder, isDeleteTSProfile, listener, message, this.rb);
                        }
                    }
                }
                if (!isDeleteTSHomeFolder && !isDeleteTSProfile) continue;
                TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.mgmtname.delete_ts_home_folders"), this.getValue(result, 1010), domainName, auditPropList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    private boolean validate(String domainName, Long loginId, String samAccountName, String sid, String dn, String directoryPath, boolean isDeleteTSHomeFolder, boolean isDeleteTSProfile, StringBuffer message) {
        boolean status = true;
        if (directoryPath.startsWith("\\\\")) {
            try {
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                Properties profileAttrib = new Properties();
                if (isDeleteTSHomeFolder) {
                    profileAttrib.put("ATTRIB_LDAP_NAME", "tsHomeDir");
                } else if (isDeleteTSProfile) {
                    profileAttrib.put("ATTRIB_LDAP_NAME", "tsProfilePath");
                }
                profileAttrib.put("ATTRIB_VALUE", directoryPath);
                setAttributeList.add(profileAttrib);
                logger.log(Level.INFO, "Starts checking access permission for setting TS AD attribute: " + setAttributeList);
                ADHandler.setTerminalServiceProps((String)domainName, (Long)loginId, (String)samAccountName, setAttributeList, (String)sid, (String)dn);
            }
            catch (LocalizedException le) {
                status = false;
                if (isDeleteTSHomeFolder) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_homefolder"), le.getMessage(this.rb)));
                }
                if (isDeleteTSProfile) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_profile"), le.getMessage(this.rb)));
                }
                le.printStackTrace();
            }
            catch (Exception e) {
                status = false;
                if (isDeleteTSHomeFolder) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_homefolder"), e.getMessage()));
                }
                if (isDeleteTSProfile) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_profile"), e.getMessage()));
                }
                e.printStackTrace();
            }
        } else {
            status = false;
            if (isDeleteTSHomeFolder) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_delete_user_no_remote_ts_homefolder"));
            }
            if (isDeleteTSProfile) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.unable_delete_user_no_remote_ts_profile"));
            }
        }
        return status;
    }

    private boolean deleteTSFolder(String domainName, Long loginId, String directoryPath, boolean isDeleteTSHomeFolder, boolean isDeleteTSProfile, StringBuffer message) {
        boolean isFolderDeleted = true;
        try {
            logger.log(Level.INFO, "delete Folder directoryPath: " + directoryPath);
            DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
            if (isDeleteTSHomeFolder) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.success_delete_ts_homefolder"));
            }
            if (isDeleteTSProfile) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.success_delete_ts_profile"));
            }
        }
        catch (LocalizedException le) {
            isFolderDeleted = false;
            if (isDeleteTSHomeFolder) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_homefolder"), le.getMessage(this.rb)));
            }
            if (isDeleteTSProfile) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_profile"), le.getMessage(this.rb)));
            }
            le.printStackTrace();
        }
        catch (Exception e) {
            isFolderDeleted = false;
            if (isDeleteTSHomeFolder) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_homefolder"), e.getMessage()));
            }
            if (isDeleteTSProfile) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_profile"), e.getMessage()));
            }
            e.printStackTrace();
        }
        return isFolderDeleted;
    }

    private boolean deleteTSVistaFolder(String domainName, Long loginId, String directoryPath, StringBuffer message) {
        boolean isVistaFolderDeleted = true;
        try {
            logger.log(Level.INFO, "delete TS vista Folder directoryPath: " + directoryPath);
            DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.success_delete_ts_vista_profile"));
        }
        catch (LocalizedException le) {
            isVistaFolderDeleted = false;
            message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_vista_profile"), le.getMessage(this.rb)));
            le.printStackTrace();
        }
        catch (Exception e) {
            isVistaFolderDeleted = false;
            message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_ts_homefolders.statmsg.error_delete_ts_vista_profile"), e.getMessage()));
            e.printStackTrace();
        }
        return isVistaFolderDeleted;
    }
}

