/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;

public class MoveHomeFoldersListener
extends ModifyUserListener {
    public MoveHomeFoldersListener() {
        this.reportId = new Integer(1024);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        BeanMap props = (BeanMap)bean.get("props");
        String homeFolderAction = (String)props.get("homeFolderAction");
        if (homeFolderAction.equalsIgnoreCase("move")) {
            return this.moveHomeFolder(result, attributeList, bean, domainName, loginId, audit_info, auditDataObj);
        }
        if (homeFolderAction.equalsIgnoreCase("delete")) {
            return this.deleteHomeFolder(result, attributeList, bean, domainName, loginId, audit_info, auditDataObj);
        }
        return "";
    }

    public String moveHomeFolder(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        logger.log(Level.INFO, "moveHomeFolder");
        StringBuffer finalMessage = new StringBuffer();
        try {
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            List<String> tempAttributesList = Arrays.asList(selectedAttributes);
            ArrayList<String> selectedAttributesList = new ArrayList<String>(tempAttributesList);
            BeanMap props = (BeanMap)bean.get("props");
            boolean retainHomeFolder = false;
            boolean retainProfilePath = false;
            if (selectedAttributesList.contains("retainHomeFolder")) {
                retainHomeFolder = true;
                selectedAttributesList.remove(selectedAttributesList.indexOf("retainHomeFolder"));
            }
            if (selectedAttributesList.contains("retainProfilePath")) {
                retainProfilePath = true;
                selectedAttributesList.remove(selectedAttributesList.indexOf("retainProfilePath"));
            }
            boolean homefolder = false;
            boolean profilePath = false;
            String task = new String();
            String modifiedMoveFrom = "";
            String drive = new String();
            String moveto = "";
            for (String selectedAttribute : selectedAttributesList) {
                StringBuffer message;
                String movefrom;
                block61: {
                    if (selectedAttribute.equalsIgnoreCase("deleteHomeFolder") || selectedAttribute.equalsIgnoreCase("deleteProfile")) continue;
                    homefolder = false;
                    profilePath = false;
                    boolean moveSuccess = false;
                    boolean v2Exists = false;
                    boolean profileExists = false;
                    String value2 = new String();
                    drive = new String();
                    task = new String();
                    moveto = (String)props.get(selectedAttribute);
                    movefrom = "";
                    if (selectedAttribute.equals("moveHomeDirectoryTo")) {
                        homefolder = true;
                        movefrom = this.getValue(result, 1042);
                    } else if (selectedAttribute.equals("moveProfilePathTo")) {
                        profilePath = true;
                        movefrom = this.getValue(result, 1024);
                    }
                    message = new StringBuffer();
                    String value = moveto;
                    if (!moveto.endsWith("\\")) {
                        value = moveto.concat("\\");
                    }
                    value2 = value.concat(movefrom.substring(movefrom.lastIndexOf(92) + 1));
                    value2 = FormatClientUtil.getFormatValue(value2, result, domainName, "");
                    String validPathMsg = "";
                    if (!movefrom.equals("") && movefrom.length() != 0 && !(validPathMsg = MgmtUtil.checkForValidPath(movefrom, value2, this.rb)).equals("")) {
                        message = message.append(validPathMsg);
                        homefolder = false;
                    } else {
                        if (!movefrom.equals("") && movefrom.length() != 0 && movefrom.startsWith("\\\\")) {
                            try {
                                File v = new File(movefrom);
                                if (v.exists() && v.isDirectory()) {
                                    logger.log(Level.INFO, "Profile Path Exist");
                                    profileExists = true;
                                    ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)movefrom, (String)value2);
                                    moveSuccess = true;
                                } else if (homefolder) {
                                    logger.log(Level.INFO, "Home folder move operation starts");
                                    ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)movefrom, (String)value2);
                                    moveSuccess = true;
                                }
                                String v2movefrom = "";
                                if (profilePath) {
                                    String v2moveto;
                                    v2movefrom = movefrom;
                                    File v2 = new File(v2movefrom.concat(".V2"));
                                    File v5 = new File(v2movefrom.concat(".V5"));
                                    File v6 = new File(v2movefrom.concat(".V6"));
                                    if (v2.exists() && v2.isDirectory()) {
                                        logger.log(Level.INFO, "V2 Profile Path Exist");
                                        v2moveto = value2.concat(".V2");
                                        v2Exists = true;
                                        ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)v2movefrom, (String)v2moveto);
                                        v2movefrom = v2movefrom.concat(".V2");
                                    }
                                    if (v5.exists() && v5.isDirectory()) {
                                        logger.log(Level.INFO, "V5 Profile Path Exist");
                                        v2moveto = value2.concat(".V5");
                                        v2Exists = true;
                                        ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)v2movefrom, (String)v2moveto);
                                        v2movefrom = v2movefrom.concat(".V5");
                                    }
                                    if (v6.exists() && v6.isDirectory()) {
                                        logger.log(Level.INFO, "V6 Profile Path Exist");
                                        v2moveto = value2.concat(".V6");
                                        v2Exists = true;
                                        ADHandlerForMgmt.moveFolder((String)domainName, (Long)loginId, (String)v2movefrom, (String)v2moveto);
                                        v2movefrom = v2movefrom.concat(".V6");
                                    }
                                }
                                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                                Properties p = new Properties();
                                if (selectedAttribute.equals("moveHomeDirectoryTo")) {
                                    p.put("ATTRIB_LDAP_NAME", "homeDirectory");
                                } else if (selectedAttribute.equals("moveProfilePathTo")) {
                                    p.put("ATTRIB_LDAP_NAME", "profilePath");
                                }
                                p.put("ATTRIB_VALUE", value2);
                                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                p.put("DATA_HANDLER_TYPE", new Long(3L));
                                setAttributeList.add(p);
                                if (selectedAttribute.equals("moveHomeDirectoryTo")) {
                                    Properties p1 = new Properties();
                                    p1.put("ATTRIB_LDAP_NAME", "homeDrive");
                                    drive = (String)props.get("moveHomeDriveTo");
                                    p1.put("ATTRIB_VALUE", drive);
                                    p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                                    p1.put("DATA_HANDLER_TYPE", new Long(3L));
                                    setAttributeList.add(p1);
                                }
                                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                                try {
                                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                                    if (homefolder) {
                                        message.append(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.successfully_moved_homefolder"));
                                    }
                                    if (profilePath) {
                                        message.append(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.successfully_moved_profile_path"));
                                    }
                                    if (homefolder && !retainHomeFolder) {
                                        boolean homeDeleteStatus = true;
                                        homeDeleteStatus = this.deleteSharedFolder(false, movefrom, domainName, loginId);
                                        if (!homeDeleteStatus) {
                                            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_delete"));
                                        }
                                    }
                                    if (!profilePath || retainProfilePath) break block61;
                                    boolean profileDeleteStatus = true;
                                    if (profileExists) {
                                        profileDeleteStatus = this.deleteSharedFolder(true, movefrom, domainName, loginId);
                                    }
                                    if (v2Exists) {
                                        profileDeleteStatus = this.deleteSharedFolder(true, v2movefrom, domainName, loginId);
                                    }
                                    if (!profileDeleteStatus) {
                                        message.append(this.rb.getString("admp.mgmt.user_mgmt.move_profilepath.statmsg.unable_delete"));
                                    }
                                    break block61;
                                }
                                catch (LocalizedException le) {
                                    if (profilePath) {
                                        if (v2Exists) {
                                            this.deleteSharedFolder(true, value2, domainName, loginId);
                                        } else {
                                            this.deleteSharedFolder(false, value2, domainName, loginId);
                                        }
                                    }
                                    if (homefolder) {
                                        this.deleteSharedFolder(false, value2, domainName, loginId);
                                    }
                                    if (homefolder) {
                                        message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.error_modifying_homefolder"), le.getMessage(this.rb)));
                                    }
                                    if (profilePath) {
                                        message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.error_modifying_profile_path"), le.getMessage(this.rb)));
                                    }
                                    break block61;
                                }
                                catch (Exception e) {
                                    if (profilePath) {
                                        if (v2Exists) {
                                            this.deleteSharedFolder(true, value2, domainName, loginId);
                                        } else {
                                            this.deleteSharedFolder(false, value2, domainName, loginId);
                                        }
                                    }
                                    if (homefolder) {
                                        this.deleteSharedFolder(false, value2, domainName, loginId);
                                    }
                                    if (homefolder) {
                                        message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.error_modifying_homefolder"), e.getMessage()));
                                    }
                                    if (profilePath) {
                                        message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.error_modifying_profile_path"), e.getMessage()));
                                    }
                                    break block61;
                                }
                            }
                            catch (LocalizedException le) {
                                if (moveSuccess) {
                                    this.deleteSharedFolder(false, value2, domainName, loginId);
                                }
                                if (homefolder) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_homefolder"), le.getMessage(this.rb)));
                                }
                                if (profilePath) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_profile_path"), le.getMessage(this.rb)));
                                }
                                break block61;
                            }
                            catch (Exception e) {
                                if (moveSuccess) {
                                    this.deleteSharedFolder(false, value2, domainName, loginId);
                                }
                                if (homefolder) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_homefolder"), e.getMessage()));
                                }
                                if (profilePath) {
                                    message = message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_profile_path"), e.getMessage()));
                                }
                                break block61;
                            }
                        }
                        if (homefolder) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_user_does_not_have_homefolder"));
                        }
                        if (profilePath) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_user_does_not_have_profile_path"));
                        }
                    }
                }
                modifiedMoveFrom = movefrom;
                String retainedText = this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.folder_retained");
                String deletedText = this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.folder_deleted");
                if (profilePath) {
                    task = this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.mgmtname.move_profilepath");
                    modifiedMoveFrom = movefrom != null && movefrom != "" ? (retainProfilePath ? modifiedMoveFrom + " " + retainedText : modifiedMoveFrom + " " + deletedText) : this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.no_home_folder");
                } else if (homefolder) {
                    drive = (String)props.get("moveHomeDriveTo");
                    task = this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.mgmtname.move_home_folders");
                    modifiedMoveFrom = movefrom != null && movefrom != "" ? (retainHomeFolder ? modifiedMoveFrom + " " + retainedText : modifiedMoveFrom + " " + deletedText) : this.rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.no_home_folder");
                }
                if (profilePath || homefolder) {
                    TechAuditAPI.getInstance().auditMoveHomeFolder(loginId, task, this.getValue(result, 1010), domainName, modifiedMoveFrom, moveto, drive, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb, profilePath);
                }
                if (finalMessage.length() > 0) {
                    finalMessage.append(" ");
                }
                finalMessage.append(message);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return finalMessage.toString();
    }

    public String deleteHomeFolder(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        logger.log(Level.INFO, "deleteHomeFolder");
        StringBuffer message = new StringBuffer();
        try {
            String directoryPath = "";
            ArrayList<Properties> auditPropList = new ArrayList<Properties>();
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            boolean isDeleteProfile = false;
            boolean isDeleteHomeFolder = false;
            for (int i = 0; i < selectedAttributes.length; ++i) {
                isDeleteHomeFolder = false;
                isDeleteProfile = false;
                boolean isFolderDeleted = true;
                String action = selectedAttributes[i];
                Properties auditProp = new Properties();
                if (action.equalsIgnoreCase("deleteHomeFolder")) {
                    isDeleteHomeFolder = true;
                    directoryPath = this.getValue(result, 1042);
                    auditProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.text.delete_homefolder_from"));
                    auditProp.put("ATTRIB_VALUE", directoryPath);
                    auditPropList.add(auditProp);
                } else if (action.equalsIgnoreCase("deleteProfile")) {
                    isDeleteProfile = true;
                    directoryPath = this.getValue(result, 1024);
                    auditProp.put("ATTRIB_LDAP_NAME", this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.text.delete_profile_from"));
                    auditProp.put("ATTRIB_VALUE", directoryPath);
                    auditPropList.add(auditProp);
                }
                logger.log(Level.INFO, "deleteHomeFolder action: " + action);
                String sid = this.getValue(result, 1144);
                String dn = this.getValue(result, 1004);
                ModifyUserListener listener = (ModifyUserListener)bean.getListener();
                if (this.validate(domainName, loginId, sid, dn, directoryPath, isDeleteHomeFolder, isDeleteProfile, message)) {
                    File folderPath = new File(directoryPath);
                    if (folderPath.exists() && folderPath.isDirectory()) {
                        isFolderDeleted = this.deleteFolder(domainName, loginId, directoryPath, isDeleteHomeFolder, isDeleteProfile, message);
                    } else {
                        logger.log(Level.INFO, "Folder Not Exists");
                        if (isDeleteHomeFolder) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.delete_user_no_homefolder"));
                        }
                        if (isDeleteProfile) {
                            message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.delete_user_no_profile"));
                        }
                    }
                    if (isFolderDeleted) {
                        if (isDeleteProfile) {
                            File vistaProfilePath = new File(directoryPath.concat(".V2"));
                            File v5ProfilePath = new File(directoryPath.concat(".V5"));
                            File v6ProfilePath = new File(directoryPath.concat(".V6"));
                            if (vistaProfilePath.exists() && vistaProfilePath.isDirectory()) {
                                isFolderDeleted = this.deleteProfileFolder(domainName, loginId, directoryPath.concat(".V2"), "Vista profile", message);
                            }
                            if (v5ProfilePath.exists() && v5ProfilePath.isDirectory()) {
                                isFolderDeleted = this.deleteProfileFolder(domainName, loginId, directoryPath.concat(".V5"), "V5 Profile", message);
                            }
                            if (v6ProfilePath.exists() && v6ProfilePath.isDirectory()) {
                                isFolderDeleted = this.deleteProfileFolder(domainName, loginId, directoryPath.concat(".V6"), "V6 Profile", message);
                            }
                        }
                        if (isFolderDeleted) {
                            DeleteUtil.clearADAttribute(domainName, loginId, sid, dn, attributeList, isDeleteHomeFolder, isDeleteProfile, listener, message, this.rb);
                        }
                    }
                }
                if (!isDeleteHomeFolder && !isDeleteProfile) continue;
                TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.mgmtname.delete_home_folder"), this.getValue(result, 1010), domainName, auditPropList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    private boolean validate(String domainName, Long loginId, String sid, String dn, String directoryPath, boolean isDeleteHomeFolder, boolean isDeleteProfile, StringBuffer message) {
        boolean status = true;
        if (directoryPath.startsWith("\\\\")) {
            try {
                ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                Properties profileAttrib = new Properties();
                if (isDeleteHomeFolder) {
                    profileAttrib.put("ATTRIB_LDAP_NAME", "homeDirectory");
                } else if (isDeleteProfile) {
                    profileAttrib.put("ATTRIB_LDAP_NAME", "profilePath");
                }
                profileAttrib.put("ATTRIB_VALUE", directoryPath);
                profileAttrib.put("ATTRIB_VALUE_COUNT", new Long(1L));
                profileAttrib.put("DATA_HANDLER_TYPE", new Long(3L));
                setAttributeList.add(profileAttrib);
                logger.log(Level.INFO, "Starts checking access permission for setting AD attribute: " + setAttributeList);
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), null, null);
            }
            catch (LocalizedException le) {
                status = false;
                if (isDeleteHomeFolder) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_clear_homefolder"), le.getMessage(this.rb)));
                }
                if (isDeleteProfile) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_clear_profile"), le.getMessage(this.rb)));
                }
                le.printStackTrace();
            }
            catch (Exception e) {
                status = false;
                if (isDeleteHomeFolder) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_clear_homefolder"), e.getMessage()));
                }
                if (isDeleteProfile) {
                    message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_clear_profile"), e.getMessage()));
                }
                e.printStackTrace();
            }
        } else {
            status = false;
            if (isDeleteHomeFolder) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.unable_delete_user_no_remote_homefolder"));
            }
            if (isDeleteProfile) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.unable_delete_user_no_remote_profile"));
            }
        }
        return status;
    }

    private boolean deleteFolder(String domainName, Long loginId, String directoryPath, boolean isDeleteHomeFolder, boolean isDeleteProfile, StringBuffer message) {
        boolean isFolderDeleted = true;
        try {
            logger.log(Level.INFO, "delete Folder directoryPath: " + directoryPath);
            DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
            if (isDeleteHomeFolder) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.success_delete_homefolder"));
            }
            if (isDeleteProfile) {
                message.append(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.success_delete_profile"));
            }
        }
        catch (LocalizedException le) {
            isFolderDeleted = false;
            if (isDeleteHomeFolder) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_homefolder"), le.getMessage(this.rb)));
            }
            if (isDeleteProfile) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_profile"), le.getMessage(this.rb)));
            }
            le.printStackTrace();
        }
        catch (Exception e) {
            isFolderDeleted = false;
            if (isDeleteHomeFolder) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_homefolder"), e.getMessage()));
            }
            if (isDeleteProfile) {
                message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_profile"), e.getMessage()));
            }
            e.printStackTrace();
        }
        return isFolderDeleted;
    }

    private boolean deleteProfileFolder(String domainName, Long loginId, String directoryPath, String profile, StringBuffer message) {
        boolean isVistaFolderDeleted = true;
        try {
            logger.log(Level.INFO, "delete profile path Folder directoryPath: " + directoryPath);
            DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
            message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.success_delete_profile_extension"), profile));
        }
        catch (LocalizedException le) {
            isVistaFolderDeleted = false;
            message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_profile_extension"), profile, le.getMessage(this.rb)));
            le.printStackTrace();
        }
        catch (Exception e) {
            isVistaFolderDeleted = false;
            message.append(MessageFormat.format(this.rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.error_delete_profile_extension"), profile, e.getMessage()));
            e.printStackTrace();
        }
        return isVistaFolderDeleted;
    }

    public boolean deleteSharedFolder(boolean v2Flag, String directoryPath, String domainName, Long loginId) {
        Boolean isFolderDeleted = false;
        Boolean isVistaFolderDeleted = false;
        try {
            File folderPath;
            if (v2Flag) {
                logger.log(Level.INFO, "Starts deleting VX homeFolder/profile after moved to new location, directoryPath: " + directoryPath);
                DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
                isVistaFolderDeleted = true;
            }
            if ((folderPath = new File(directoryPath)).exists() && folderPath.isDirectory()) {
                logger.log(Level.INFO, "Starts deleting previous homeFolder/profile after moved to new location, directoryPath: " + directoryPath);
                DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
                isFolderDeleted = true;
            }
        }
        catch (LocalizedException le) {
            isFolderDeleted = false;
            logger.log(Level.INFO, "Error deleting previous homeFolder/profile Folder:" + le.getMessage(this.rb));
            le.printStackTrace();
        }
        catch (Exception e) {
            isFolderDeleted = false;
            logger.log(Level.INFO, "Error deleting previous homeFolder/profile Folder:" + e.getMessage());
            e.printStackTrace();
        }
        return isVistaFolderDeleted != false || isFolderDeleted != false;
    }
}

