/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.iam.GAppsUtil;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.DBObjectUtil;
import com.adventnet.sym.adsm.common.server.util.DeprovisionUtil;
import com.adventnet.sym.adsm.common.webclient.layout.gapps.GappsMgmtUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class ResetPasswordListener
extends ModifyUserListener {
    public ResetPasswordListener() {
        this.cks = new String[]{"resetPasswordOption"};
        this.reportId = new Integer(1019);
    }

    private boolean checkUIOptions(HashMap props, String str) {
        String val = (String)props.get(str);
        return val == null || val.equals("--");
    }

    private String getPassword(BeanMap props, String samAccountName, String domainName, Long loginId) {
        String password = "";
        try {
            String resetPassword = props.getProperty("resetPassword");
            if (resetPassword.equals("sameAsUser")) {
                password = samAccountName;
            } else if (resetPassword.equals("text")) {
                password = props.getProperty("password");
            } else if (resetPassword.equals("generate")) {
                PasswordPolicy pwdPolicy = new PasswordPolicy();
                pwdPolicy.setPolicyDetails();
                password = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)this.rb);
            } else if (resetPassword.equals("leaveBlank")) {
                password = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return password;
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        String sid = this.getValue(result, 1144);
        String dn = this.getValue(result, 1004);
        String samAccountName = this.getValue(result, 1006);
        return this.modifyUser(result, attributeList, bean, domainName, loginId, sid, dn, samAccountName, audit_info, auditDataObj);
    }

    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, String sid, String dn, String samAccountName, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1012L})) {
            return this.rb.getString("admp.mgmt.common.statmsg.access_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            boolean isSuccess = false;
            boolean changePasswordAtNextLogin = false;
            int pwdNeverExpires = -1;
            String password = null;
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
            ArrayList<Properties> winNTProviderList = new ArrayList<Properties>();
            String guid = result.get("OBJECT_GUID").toString();
            ArrayList<Properties> logAttributeList = new ArrayList<Properties>();
            ModifyUserListener listener = (ModifyUserListener)bean.getListener();
            BeanMap props = (BeanMap)bean.get("props");
            String resetPasswordOption = props.getProperty("resetPasswordOption");
            if (resetPasswordOption != null && resetPasswordOption.equals("true")) {
                password = this.getPassword(props, samAccountName, domainName, loginId);
                audit_info.put("password", password);
                String resetPassword = props.getProperty("resetPassword");
                String inputSource = (String)bean.get("inputSource");
                try {
                    ADHandlerForMgmt.setPassword((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)password);
                    isSuccess = true;
                }
                catch (LocalizedException le) {
                    message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.error_while_changing_pwd") + le.getMessage(this.rb));
                }
                catch (Exception ex) {
                    message = new StringBuffer(this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.error_while_changing_pwd") + ex.getMessage());
                }
                if (inputSource != null && inputSource.equalsIgnoreCase("csv")) {
                    Long uniqueValue = AddUserHandler.getInstance().updateCSVUserDetails(result, (String)bean.get("keyLdapName"), this.generationId, password, message.toString());
                } else {
                    UserHandler.updatePassword((String)domainName, (String)sid, (String)password);
                }
                Properties logProp = new Properties();
                logProp.put("ATTRIB_LDAP_NAME", "password");
                logProp.put("ATTRIB_VALUE", password);
                logAttributeList.add(logProp);
            }
            String mustChangePassword = props.getProperty("mustChangePassword");
            String cantChangePassword = props.getProperty("cantChangePassword");
            String passwordNeverExpires = props.getProperty("passwordNeverExpires");
            if (resetPasswordOption == null || resetPasswordOption.equals("false") || message.toString().indexOf(this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.error_while_changing_pwd")) == -1 && resetPasswordOption.equals("true")) {
                Properties logProp;
                Properties p;
                if (mustChangePassword != null && !mustChangePassword.equals("--") && ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1201L)) {
                    p = new Properties();
                    p.put("DATA_HANDLER_TYPE", new Long(10L));
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "pwdLastSet");
                    logProp = new Properties();
                    logProp.put("ATTRIB_LDAP_NAME", "pwdLastSet");
                    if (mustChangePassword.equalsIgnoreCase("Yes")) {
                        logProp.put("ATTRIB_VALUE", new Long(0L));
                        changePasswordAtNextLogin = true;
                        try {
                            boolean checkCantChangePassword = ADHandlerForMgmt.checkCantChangePassword((String)domainName, (Long)loginId, (String)samAccountName, (String)dn);
                            logger.log(Level.INFO, "check native : checkCantChangePassword" + checkCantChangePassword + " UI OPTION " + this.checkUIOptions(props, "cantChangePassword"));
                            logger.log(Level.INFO, "check native : checkPasswordNeverExpires : UI OPTION " + this.checkUIOptions(props, "passwordNeverExpires"));
                            if (this.checkUIOptions(props, "cantChangePassword") && checkCantChangePassword) {
                                throw new Exception(this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.user_cant_change_pwd_set_to_this_user"));
                            }
                            if (this.checkUIOptions(props, "passwordNeverExpires") && ADHandlerForMgmt.checkPasswordNeverExpires((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                                throw new Exception(this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.pwd_never_expires_set_to_this_user"));
                            }
                            p.put("ATTRIB_VALUE", new Long(0L));
                            setAttributeList.add(p);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            message = new StringBuffer(e.getMessage());
                        }
                    } else {
                        logProp.put("ATTRIB_VALUE", new Long(-1L));
                        p.put("ATTRIB_VALUE", new Long(-1L));
                        setAttributeList.add(p);
                    }
                    logAttributeList.add(logProp);
                }
                if (cantChangePassword != null && !cantChangePassword.equals("--") && ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1202L)) {
                    p = new Properties();
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "userFlags");
                    logProp = new Properties();
                    logProp.put("ATTRIB_LDAP_NAME", "userFlags");
                    if (cantChangePassword.equalsIgnoreCase("Yes")) {
                        logProp.put("ATTRIB_VALUE", String.valueOf(64));
                        try {
                            if (this.checkUIOptions(props, "mustChangePassword") && ADHandlerForMgmt.checkUserMustChangePassword((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                                throw new Exception(this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.user_must_change_pwd_next_logon_set_to_this_user_select_this_option_no_and_click_apply"));
                            }
                            p.put("ATTRIB_VALUE", String.valueOf(64));
                            winNTProviderList.add(p);
                        }
                        catch (Exception e) {
                            message = new StringBuffer(e.getMessage());
                        }
                    } else {
                        logProp.put("ATTRIB_VALUE", String.valueOf(-65));
                        p.put("ATTRIB_AND_VALUE", String.valueOf(-65));
                        winNTProviderList.add(p);
                    }
                    logAttributeList.add(logProp);
                }
                if (passwordNeverExpires != null && !passwordNeverExpires.equals("--") && ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1203L)) {
                    int userAccountControl = 0;
                    int andUserAccountControl = 0xFFFFFFF;
                    Properties p1 = new Properties();
                    p1.put("DATA_HANDLER_TYPE", new Long(7L));
                    p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p1.put("ATTRIB_LDAP_NAME", "userAccountControl");
                    Properties logProp2 = new Properties();
                    logProp2.put("ATTRIB_LDAP_NAME", "userAccountControl");
                    if (passwordNeverExpires.equalsIgnoreCase("Yes")) {
                        logProp2.put("ATTRIB_VALUE", MessageFormat.format(this.rb.getString("admp.auditing.uac_password_never_expire_flag"), this.rb.getString("admp.common.attribvalue.true")));
                        logProp2.put("ATTRIB_UAC_VALUE", MessageFormat.format(this.rb.getString("admp.auditing.uac_password_never_expire_flag"), this.rb.getString("admp.common.attribvalue.true")));
                        try {
                            if (this.checkUIOptions(props, "mustChangePassword") && ADHandlerForMgmt.checkUserMustChangePassword((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                                throw new Exception(this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.statmsg.user_must_change_pwd_next_logon_set_to_this_user_select_this_option_no_and_click_apply"));
                            }
                            p1.put("ATTRIB_VALUE", String.valueOf(userAccountControl |= 0x10000));
                            p1.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
                            p1.put("ATTRIB_UAC_VALUE", MessageFormat.format(this.rb.getString("admp.auditing.uac_password_never_expire_flag"), this.rb.getString("admp.common.attribvalue.true")));
                            modifyAttributeList.add(p1);
                            pwdNeverExpires = 1;
                        }
                        catch (Exception e) {
                            message = new StringBuffer(e.getMessage());
                        }
                    } else {
                        logProp2.put("ATTRIB_VALUE", MessageFormat.format(this.rb.getString("admp.auditing.uac_password_never_expire_flag"), this.rb.getString("admp.common.attribvalue.false")));
                        logProp2.put("ATTRIB_UAC_VALUE", MessageFormat.format(this.rb.getString("admp.auditing.uac_password_never_expire_flag"), this.rb.getString("admp.common.attribvalue.false")));
                        p1.put("ATTRIB_VALUE", String.valueOf(userAccountControl));
                        p1.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl &= 0xFFEFFFF));
                        p1.put("ATTRIB_UAC_VALUE", MessageFormat.format(this.rb.getString("admp.auditing.uac_password_never_expire_flag"), this.rb.getString("admp.common.attribvalue.false")));
                        modifyAttributeList.add(p1);
                        pwdNeverExpires = 0;
                    }
                    logAttributeList.add(logProp2);
                }
            }
            logger.log(Level.INFO, "Modify User, Domain : " + domainName + " SID : " + sid + " AttributeList : " + setAttributeList + " modifyAttributeList : " + modifyAttributeList + " Win NT List : " + winNTProviderList);
            if (setAttributeList.size() != 0 || modifyAttributeList.size() != 0 || winNTProviderList.size() != 0) {
                try {
                    if (attributeList.contains("password")) {
                        attributeList.remove("password");
                    }
                    this.toBeExecutedAttributeList = attributeList;
                    ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)samAccountName, setAttributeList, modifyAttributeList, new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                    if (!cantChangePassword.equals("--") && winNTProviderList.size() > 0) {
                        boolean cantChangePasswordBool = false;
                        if (cantChangePassword.equalsIgnoreCase("Yes")) {
                            cantChangePasswordBool = true;
                        }
                        UserMgmtUtil.setUserCannotChangePass((boolean)cantChangePasswordBool, (String)domainName, (Long)loginId, (String)dn, (String)samAccountName);
                    }
                    if (cantChangePassword.equalsIgnoreCase("Yes")) {
                        ArrayList<Properties> l = new ArrayList<Properties>();
                        Properties p = new Properties();
                        p.put("DATA_HANDLER_TYPE", new Long(10L));
                        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                        p.put("ATTRIB_LDAP_NAME", "pwdLastSet");
                        p.put("ATTRIB_VALUE", new Long(-1L));
                        l.add(p);
                        try {
                            ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)samAccountName, l, new ArrayList(), new ArrayList(), (ArrayList)attributeList, (NativeListener)listener);
                        }
                        catch (Exception ex) {
                            System.out.println("RPL:::Error in updating the pwdLastSet ");
                            ex.printStackTrace();
                        }
                    }
                    if (message.length() == 0) {
                        message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error"));
                    }
                }
                catch (LocalizedException le) {
                    message = new StringBuffer(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error") + le.getMessage(this.rb));
                }
                catch (Exception e) {
                    message = new StringBuffer(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified_error") + e.getMessage());
                }
            }
            if (message.length() == 0) {
                message.append(this.rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
            }
            if (isSuccess) {
                String objectId;
                HashMap policyMap = DeprovisionUtil.getResetPasswordPolicyMap((String)domainName);
                if (Boolean.valueOf((String)policyMap.get("reset_password_google_apps")).booleanValue() && (objectId = GAppsUtil.getObjectId((String)guid)) != null && objectId != "") {
                    logger.log(Level.INFO, "Start: Reset Password in Google Apps");
                    if (GappsMgmtUtil.resetPassword(domainName, loginId, objectId, password, changePasswordAtNextLogin)) {
                        logger.log(Level.INFO, "Password reset successful in Google Apps");
                        message.append(" " + this.rb.getString("admp.mgmt.user_mgmt.reset_password_google_apps.statmsg_successful"));
                    } else {
                        message.append(" " + this.rb.getString("admp.mgmt.user_mgmt.reset_password_google_apps.statmsg_failure"));
                        logger.log(Level.INFO, "Could not reset password in Google Apps");
                    }
                }
                if (Boolean.valueOf((String)policyMap.get("reset_password_in_o365")).booleanValue()) {
                    message.append(DeleteUtil.resetO365UserPwd(domainName, loginId, guid, password, changePasswordAtNextLogin, pwdNeverExpires, this.rb));
                }
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.reset_pwd.mgmtname.reset_password"), samAccountName, domainName, logAttributeList, null, null, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setCSVRows(HttpServletRequest request, ReportBean bean, String operation) {
        super.setCSVRows(request, bean, operation);
        ArrayList userDetailsList = (ArrayList)request.getAttribute("result");
        ArrayList modifiedUserDetailsList = DBObjectUtil.modifyUserDetails((ArrayList)userDetailsList, (Integer)this.reportId, (String)((String)bean.get("keyLdapName")));
        request.setAttribute("result", (Object)modifiedUserDetailsList);
    }
}

