/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.SearchSIDsListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;

public class SearchSIDsAction
extends DispatchAction {
    public ActionForward searchSIDs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DynaValidatorForm bean = (DynaValidatorForm)form;
            SearchSIDsListener listener = null;
            if (bean.get("listener") != null) {
                listener = (SearchSIDsListener)bean.get("listener");
            } else {
                listener = new SearchSIDsListener();
                bean.set("listener", (Object)listener);
            }
            System.out.println("Getting Domains : ");
            Hashtable domains = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
            bean.set("dnDomainNameMap", domains.get("dnDomainNameMap"));
            request.setAttribute("domainList", domains.get("domainList"));
            String[] parameters = new String[]{"All", "cn", "description"};
            String[] parameterDisplay = new String[]{rb.getString("admp.search.search_attribute.all"), rb.getString("admp.common.attrib_disp_name.common_name"), rb.getString("admp.common.attrib_disp_name.desc")};
            String[] searchTypesDisplay = new String[]{rb.getString("admp.search.search_criteria.contains"), rb.getString("admp.search.search_criteria.startswith"), rb.getString("admp.search.search_criteria.endswith"), rb.getString("admp.search.search_criteria.equals"), rb.getString("admp.search.search_criteria.notequals")};
            String[] searchTypes = new String[]{"contains", "startsWith", "endsWith", "equals", "notEquals"};
            bean.set("parameterList", (Object)parameters);
            bean.set("parameterDisplay", (Object)parameterDisplay);
            bean.set("searchTypes", (Object)searchTypes);
            bean.set("searchTypesDisplay", (Object)searchTypesDisplay);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("mainPage");
    }

    public ActionForward export(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "printPage";
        try {
            DynaValidatorForm bean = (DynaValidatorForm)form;
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = I18NUtil.getClientLocale((Long)loginId, (HttpServletRequest)request);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            SearchSIDsListener listener = (SearchSIDsListener)bean.get("listener");
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = basepath + "jasper" + File.separator + "SearchSIDs.jasper";
            HashMap inputParams = (HashMap)bean.get("inputParams");
            inputParams.put("loginId", loginId);
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            System.out.println("The inputParams in export are : " + inputParams);
            Long searchSidId = (Long)bean.get("searchSIDID");
            request.setAttribute("searchSidId", (Object)searchSidId);
            listener.exportReport(reportFileName, reportType, inputParams, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String type = request.getParameter("type");
        if (type != null && type.equals("print")) {
            return mapping.findForward(tile);
        }
        return null;
    }

    public ActionForward search(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String searchType = request.getParameter("searchType");
        if (searchType != null && searchType.equalsIgnoreCase("simple")) {
            return this.simpleSearch(mapping, form, request, response);
        }
        DynaValidatorForm bean = (DynaValidatorForm)form;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        SearchSIDsListener listener = (SearchSIDsListener)bean.get("listener");
        String action = request.getParameter("action");
        if (action == null) {
            action = "";
        }
        try {
            if (action.equalsIgnoreCase("Search")) {
                listener.search(request, (Hashtable)bean.get("dnDomainNameMap"), bean);
                listener.setWriter(response.getWriter());
                request.setAttribute("listener", (Object)listener);
            } else if (listener.getSearchSidId() != null) {
                if (action.equalsIgnoreCase("Stop")) {
                    listener.stop(request);
                    listener.setWriter(response.getWriter());
                }
                String rangeStr = request.getParameter("RANGE");
                String isNavigate = request.getParameter("isNavigate");
                Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "ReportResult", loginId);
                listener.setSearchResult(request, range);
            }
            request.setAttribute("action", (Object)action);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("result");
    }

    public ActionForward simpleSearch(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            HttpSession session = request.getSession();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String commonName = request.getParameter("searchText");
            ArrayList domainList = new ArrayList();
            ArrayList searchedObjectsList = new ArrayList();
            ArrayList errorList = new ArrayList();
            SearchSIDsListener listener = new SearchSIDsListener();
            String action = request.getParameter("action");
            if (action != null && action.equals("search")) {
                String searchPattern = null;
                boolean flag = false;
                for (int i = 0; i < commonName.length(); ++i) {
                    if (commonName.charAt(i) != '*') continue;
                    flag = true;
                }
                searchPattern = !flag ? "*" + commonName + "*" : commonName;
                listener.addSearchParams("All", "contains", searchPattern);
                domainList = ClientAuthorizationUtil.getAuthorizedDomainPropList(request, 1801L);
                for (int j = 0; j < domainList.size(); ++j) {
                    Hashtable<String, String> hash;
                    Properties selectedDomain = (Properties)domainList.get(j);
                    String domainName = selectedDomain.getProperty("DOMAIN_NAME");
                    String defaultNamingContext = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
                    listener.setDomainName(domainName);
                    ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
                    if (ouList == null || ouList.size() == 0) {
                        ouList.add(defaultNamingContext);
                    } else {
                        ouList = DirectoryObjectUtil.getParentOUs(ouList);
                    }
                    try {
                        for (int i = 0; i < ouList.size(); ++i) {
                            ADHandler.searchADObjects((String)domainName, (Long)loginId, (String)((String)ouList.get(i)), (String)searchPattern, (NativeListener)listener);
                        }
                        continue;
                    }
                    catch (LocalizedException e) {
                        e.printStackTrace();
                        hash = new Hashtable<String, String>();
                        hash.put("domain", ((Properties)domainList.get(j)).getProperty("DOMAIN_DNS_NAME"));
                        hash.put("error", e.getMessage(rb));
                        errorList.add(hash);
                        continue;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        hash = new Hashtable();
                        hash.put("domain", ((Properties)domainList.get(j)).getProperty("DOMAIN_DNS_NAME"));
                        hash.put("error", e.getMessage());
                        errorList.add(hash);
                    }
                }
                listener.completedAction();
            } else {
                Long searchSidId = Long.valueOf(request.getParameter("searchId"));
                listener.setSearchSidId(searchSidId);
            }
            Integer count = listener.getSearchResultCount();
            String rangeStr = request.getParameter("RANGE");
            String isNavigate = request.getParameter("isNavigate");
            Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "ReportResult", loginId);
            int fromIndex = 1;
            if (request.getParameter("FROM_INDEX") != null) {
                fromIndex = Integer.parseInt(request.getParameter("FROM_INDEX"));
            }
            request.setAttribute("range", (Object)range);
            searchedObjectsList.addAll(listener.getRows("COMMON_NAME", true, fromIndex, range));
            if (!searchedObjectsList.isEmpty()) {
                StringBuffer forwardURLBuffer = null;
                for (int i = 0; i < searchedObjectsList.size(); ++i) {
                    Hashtable properties = (Hashtable)searchedObjectsList.get(i);
                    forwardURLBuffer = null;
                    String objectClassString = (String)properties.get("OBJECT_CLASS");
                    String nameString = (String)properties.get("COMMON_NAME");
                    String objectGuid = (String)properties.get("OBJECT_GUID");
                    String dnString = (String)properties.get("FQDN");
                    String domainName = "";
                    int startIndex = dnString.indexOf(",DC=");
                    for (int j = 0; j < domainList.size(); ++j) {
                        Properties selectedDomain = (Properties)domainList.get(j);
                        String domainNameStr = selectedDomain.getProperty("DOMAIN_NAME");
                        String defaultNamingContext = DomainUtil.getDefaultNamingContext((String)domainNameStr);
                        if (!defaultNamingContext.equals(dnString.substring(startIndex + 1))) continue;
                        domainName = domainNameStr;
                    }
                    if (objectClassString != null && objectClassString.equals("user")) {
                        forwardURLBuffer = new StringBuffer("selectedTab=home&guid=" + objectGuid + "&domainName=" + domainName + "&selectedObjectTab=properties&reportProperties=objectProperties&objectClass=" + objectClassString);
                        properties.put("queryString", forwardURLBuffer.toString());
                        properties.put("url", "ExecuteForm.do?methodToCall=init&operation=singleModify&templateCategoryId=6&");
                        continue;
                    }
                    forwardURLBuffer = new StringBuffer("bookmark=yes&selectedObjectTab=properties");
                    forwardURLBuffer.append("&objectClass=" + objectClassString + "&objectName=" + URLEncoder.encode(nameString) + "&guid=" + objectGuid + "&nodeClicked=" + URLEncoder.encode(dnString));
                    properties.put("queryString", forwardURLBuffer.toString());
                    properties.put("url", "SecurityExplorer.do?selectedTab=home&methodToCall=explorer");
                }
            }
            request.setAttribute("searchedObjectsList", searchedObjectsList);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("searchedString", (Object)commonName);
            request.setAttribute("errorList", errorList);
            request.setAttribute("searchSidId", (Object)listener.getSearchSidId());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("searchados");
    }
}

