/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.idioms.tablenavigator.TableNavigatorModel;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class SearchSIDsDataProvider
implements JRDataSource {
    private boolean data_available = false;
    private TableNavigatorModel tableModel = null;
    private int index = -1;
    private boolean showSerialNo = false;
    private int startingSerialNo = 0;

    public SearchSIDsDataProvider(HttpServletRequest request) {
        try {
            this.tableModel = this.getDefaultTableModel(request);
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    public SearchSIDsDataProvider(HttpServletRequest request, boolean showSerialNo, int startingSerialNo) {
        try {
            this.tableModel = this.getDefaultTableModel(request);
            this.showSerialNo = showSerialNo;
            this.startingSerialNo = startingSerialNo;
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    public TableNavigatorModel getDefaultTableModel(HttpServletRequest request) throws Exception {
        Long searchSidId = (Long)request.getAttribute("searchSidId");
        Table baseTable = new Table("ADSMSearchSIDsResult");
        SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
        String columnName = "COMMON_NAME";
        String ascending = "true";
        boolean sortType = true;
        if (request.getParameter("columnName") != null) {
            columnName = request.getParameter("columnName");
        }
        if (request.getParameter("ascending") != null) {
            ascending = request.getParameter("ascending");
        }
        sortType = ascending.equals("true");
        SortColumn sortColumn = new SortColumn("ADSMSearchSIDsResult", columnName, sortType);
        selectQuery.addSortColumn(sortColumn);
        ArrayList<Column> columnList = new ArrayList<Column>();
        Column commonName = new Column("ADSMSearchSIDsResult", "COMMON_NAME");
        Column fqdn = new Column("ADSMSearchSIDsResult", "FQDN");
        Column objectClass = new Column("ADSMSearchSIDsResult", "OBJECT_CLASS");
        Column domainName = new Column("ADSMSearchSIDsResult", "DOMAIN_NAME");
        columnList.add(commonName);
        columnList.add(fqdn);
        columnList.add(objectClass);
        columnList.add(domainName);
        Criteria criteria = new Criteria(new Column("ADSMSearchSIDsResult", "SEARCH_SID_ID"), (Object)searchSidId, 0);
        selectQuery.setCriteria(criteria);
        selectQuery.addSelectColumns(columnList);
        this.tableModel = SecurityClientUtil.getTableNavigatorModel((SelectQuery)selectQuery);
        this.tableModel.showRange(this.tableModel.getStartIndex(), this.tableModel.getTotalRecordsCount());
        this.data_available = this.tableModel.getTotalRecordsCount() > 0L;
        return this.tableModel;
    }

    public JRDataSource getJRDataSource() {
        return this;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String fieldname = jRField.getName();
        Object value = null;
        if (fieldname.equalsIgnoreCase("serialNo") && this.showSerialNo) {
            return this.startingSerialNo + "";
        }
        value = this.getFieldValue(this.tableModel, fieldname, this.index);
        return value;
    }

    public Object getFieldValue(TableNavigatorModel tm, String fieldname, int idx) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            String colname = tm.getColumnName(i);
            if (!colname.equalsIgnoreCase(fieldname)) continue;
            return ClientUtil.removeInvalidChars(tm.getValueAt(idx, i).toString());
        }
        return null;
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.index != 0) {
            ++this.startingSerialNo;
        }
        return this.index < this.tableModel.getRowCount();
    }
}

