/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.usermanagement.UserPermissionsHandler;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyUserListener;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;

public class TerminalProfileListener
extends ModifyUserListener {
    public TerminalProfileListener() {
        this.reportId = new Integer(1015);
    }

    @Override
    public String modifyUser(Hashtable result, ArrayList attributeList, ReportBean bean, String domainName, Long loginId, Hashtable audit_info, DataObject auditDataObj) {
        if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, new long[]{1029L})) {
            return this.rb.getString("client.DomainAction.access_is_denied");
        }
        StringBuffer message = new StringBuffer();
        try {
            String[] selectedAttributes = (String[])bean.get("selectedAttributes");
            String sid = this.getValue(result, 1144);
            String dn = this.getValue(result, 1004);
            String userName = this.getValue(result, 1006);
            BeanMap props = (BeanMap)bean.get("props");
            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
            boolean homeFolderOptionSelected = false;
            String val = " ";
            for (int j = 0; j < selectedAttributes.length; ++j) {
                Properties p;
                if (selectedAttributes[j].equals("tsProfilePath")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1259L)) continue;
                    val = FormatClientUtil.getFormatValue(props.getProperty(selectedAttributes[j]), result, domainName, "");
                    if (val.equals("")) {
                        val = "";
                    }
                    Properties p2 = new Properties();
                    p2.put("ATTRIB_VALUE", val);
                    p2.put("ATTRIB_LDAP_NAME", selectedAttributes[j]);
                    setAttributeList.add(p2);
                    continue;
                }
                if (selectedAttributes[j].equals("homeFolderOption")) {
                    if (!ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1258L)) continue;
                    String homeFolderOption = props.getProperty("homeFolderOption");
                    if (homeFolderOption.equals("true")) {
                        val = FormatClientUtil.getFormatValue(props.getProperty("localPathHomeDirectory"), result, domainName, "");
                        if (val.equals("")) {
                            val = "";
                        }
                        p = new Properties();
                        p.put("ATTRIB_LDAP_NAME", "tsHomeDir");
                        p.put("ATTRIB_VALUE", val);
                        setAttributeList.add(p);
                        continue;
                    }
                    homeFolderOptionSelected = true;
                    p = new Properties();
                    p.put("ATTRIB_LDAP_NAME", "tsHomeDir");
                    p.put("ATTRIB_VALUE", FormatClientUtil.getFormatValue(props.getProperty("connectHomeDirectory"), result, domainName, ""));
                    setAttributeList.add(p);
                    Properties p1 = new Properties();
                    p1.put("ATTRIB_LDAP_NAME", "tsHomeDirDrive");
                    p1.put("ATTRIB_VALUE", props.get("homeDrive"));
                    setAttributeList.add(p1);
                    continue;
                }
                if (!selectedAttributes[j].equals("tsAllowLogon") || !ClientUtil.checkAuthorization(this.domainVsIds, domainName, 1260L)) continue;
                String allowLogon = props.getProperty(selectedAttributes[j]);
                p = new Properties();
                p.put("ATTRIB_LDAP_NAME", "tsAllowLogon");
                if (allowLogon.equals("Allow")) {
                    p.put("ATTRIB_VALUE", "1");
                } else {
                    p.put("ATTRIB_VALUE", "0");
                }
                setAttributeList.add(p);
            }
            logger.log(Level.INFO, "MODIFY USER, DOMAIN :  " + domainName + " SID : " + userName + " ATTRIBUTELIST : " + setAttributeList);
            try {
                if (setAttributeList.size() != 0) {
                    ADHandler.setTerminalServiceProps((String)domainName, (Long)loginId, (String)userName, setAttributeList, (String)sid, (String)dn);
                    ArrayList aceList = new ArrayList();
                    if (message.length() == 0) {
                        message.append(this.rb.getString("groupmanagement.messages.successfully_modified"));
                    } else {
                        message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                    }
                    if (homeFolderOptionSelected) {
                        try {
                            aceList = UserPermissionsHandler.getInstance().getDefaultACEList(sid, null, domainName);
                            ADHandlerForMgmt.createFileFolder((String)domainName, (Long)loginId, (String)FormatClientUtil.getFormatValue((String)props.get("connectHomeDirectory"), result, domainName, ""), (String)sid, null, (ArrayList)aceList);
                        }
                        catch (LocalizedException le) {
                            message.append(this.rb.getString("usermanagement.messages.error_creating_homefolder") + le.getMessage(this.rb));
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            message.append(this.rb.getString("usermanagement.messages.error_creating_homefolder") + ex.getMessage());
                        }
                    }
                } else {
                    message.insert(0, this.rb.getString("groupmanagement.messages.successfully_modified_error") + " : ");
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(this.rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(this.rb));
            }
            catch (Exception e) {
                message = new StringBuffer(this.rb.getString("groupmanagement.messages.successfully_modified_error") + e.getMessage());
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, this.rb.getString("admp.mgmt.user_mgmt.ts_profile.mgmtname.terminal_service_profile_attribs"), this.getValue(result, 1010), domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return message.toString();
    }

    @Override
    public void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean) {
        try {
            String beanValue;
            String emptyFields = "";
            Locale locale = request.getLocale();
            List<String> selectedAttributes = Arrays.asList((String[])bean.get("selectedAttributes"));
            BeanMap props = (BeanMap)bean.get("props");
            if (selectedAttributes.contains("homeFolderOption") && props.get("homeFolderOption").equals("true") && (beanValue = props.getProperty("localPathHomeDirectory")).equals("")) {
                emptyFields = emptyFields.length() == 0 ? this.rb.getString("usermanagement.terminal_profile_attributes.terminal_service_home_folder") : emptyFields + "," + this.rb.getString("usermanagement.terminal_profile_attributes.terminal_service_home_folder");
            }
            if (selectedAttributes.contains("tsProfilePath") && (beanValue = props.getProperty("tsProfilePath")).equals("")) {
                emptyFields = emptyFields.length() == 0 ? this.rb.getString("usermanagement.terminal_profile_attributes.profile_path") : emptyFields + "," + this.rb.getString("usermanagement.terminal_profile_attributes.profile_path");
            }
            if (emptyFields.length() != 0) {
                emptyFields = MessageFormat.format(this.rb.getString("admp.mgmt.common.confirm.blank_values_cleared_in_ad_want_to_continue"), emptyFields);
                request.setAttribute("emptyFields", (Object)emptyFields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

