/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTApi;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ApplyTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleExecutor;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserListener;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ExtendedAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ListUserDataProvider;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserAttributeHandler;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import com.adventnet.sym.adsm.common.webclient.util.CSVReader;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.DirectoryObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UserAction
extends DispatchAction {
    Logger out = Logger.getLogger("ADMangLogger");

    public ActionForward deleteUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String[] users = request.getParameterValues("user");
        String domainName = request.getParameter("domains");
        for (int i = 0; i < users.length; ++i) {
            ADHandlerForMgmt.deleteUser((String)domainName, (Long)loginId, (String)users[i]);
        }
        request.setAttribute("message", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_deleted"));
        return this.list(mapping, form, request, response);
    }

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String domainName = "";
        if (request.getParameter("domain") != null) {
            domainName = request.getParameter("domain");
        } else {
            Properties selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
            domainName = (String)selectedDomain.get("DOMAIN_NAME");
        }
        request.setAttribute("ListingDomain", (Object)domainName);
        try {
            ArrayList domainList = DomainUtil.getDomainList();
            request.setAttribute("domainList", (Object)domainList);
            String rangeStr = request.getParameter("RANGE");
            String isNavigate = request.getParameter("isNavigate");
            Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "ReportResult", loginId);
            request.setAttribute("RANGE", (Object)range);
            long startIndex = 1L;
            long endIndex = new Long(range.intValue());
            if (request.getParameter("FROM_INDEX") != null) {
                startIndex = new Long(request.getParameter("FROM_INDEX"));
                endIndex = new Long(request.getParameter("TO_INDEX"));
            }
            request.setAttribute("FROM_INDEX", (Object)new Long(startIndex));
            request.setAttribute("TO_INDEX", (Object)new Long(endIndex));
            ArrayList userList = this.getUserList(request, domainName, new Long(startIndex).intValue(), range, loginId);
            request.setAttribute("userList", (Object)userList);
            request.setAttribute("domainName", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("list");
    }

    private ArrayList getUserList(HttpServletRequest request, String domainName, int startIndex, int range, Long loginId) {
        Long recordsCount = null;
        ArrayList userList = new ArrayList();
        try {
            String columnName = "DISPLAY_NAME";
            if (request.getParameter("columnName") != null) {
                columnName = request.getParameter("columnName");
            }
            request.setAttribute("columnName", (Object)columnName);
            String ascending = "true";
            if (request.getParameter("ascending") != null) {
                ascending = request.getParameter("ascending");
            }
            request.setAttribute("ascending", (Object)ascending);
            String searchPattern = null;
            if (request.getParameter("searchChar") != null) {
                String s = request.getParameter("searchChar");
                searchPattern = s + "*";
                request.setAttribute("searchChar", (Object)s);
            } else if (request.getParameter("searchTxt") != null) {
                String searchText = request.getParameter("searchTxt");
                searchPattern = "";
                boolean flag = false;
                for (int i = 0; i < searchText.length(); ++i) {
                    if (searchText.charAt(i) != '*') continue;
                    flag = true;
                }
                searchPattern = flag ? searchText : "*" + searchText + "*";
                request.setAttribute("searchTxt", (Object)searchText);
            }
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            userList = UserHandler.getUserList((String)domainName, (String)searchPattern, (String)columnName, (String)ascending, (int)startIndex, (int)range, (ArrayList)ouList, (Long)((Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID")));
            recordsCount = new Long(CommonUtil.getUserCount((String)searchPattern, (String)domainName, (ArrayList)ouList).intValue());
            request.setAttribute("recordsCount", (Object)recordsCount);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userList;
    }

    private void setCsvImportException(HttpServletRequest request, String statusMessage, AdventNetResourceBundle rb) {
        request.setAttribute("importErrorMessage", (Object)statusMessage);
        request.setAttribute("introductionStyle", (Object)"display:none");
        request.setAttribute("importErrorStyle", (Object)"display:block");
        request.setAttribute("userAttributesPageStyle", (Object)"display:none");
        request.setAttribute("userDetailsPageStyle", (Object)"display:none");
        request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_users"));
    }

    public ActionForward csvImport(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        UserBean userBean = (UserBean)form;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        FormFile formFile = (FormFile)userBean.get("browse");
        String fileName = formFile.getFileName();
        Boolean header = true;
        InputStream stream = null;
        Vector headerVector = new Vector();
        int headerSize = 0;
        Vector valuesVector = new Vector();
        StringBuilder message = new StringBuilder();
        boolean isWorkflowMode = false;
        boolean ouPresent = false;
        if (userBean.get("mode") != null && "workflow".equalsIgnoreCase((String)userBean.get("mode"))) {
            isWorkflowMode = true;
        }
        String selectedDomainName = (String)session.getAttribute("userCreationDomain");
        if (fileName != null) {
            try {
                stream = formFile.getInputStream();
            }
            catch (Exception e) {
                message.append(e.getMessage());
                this.setCsvImportException(request, message.toString(), rb);
                return mapping.findForward("bulkUser");
            }
        }
        String fileEncoding = request.getParameter("fileEncoding");
        CSVReader csvReader = new CSVReader(stream, fileEncoding, rb);
        ArrayList<Vector> list = new ArrayList<Vector>();
        try {
            headerVector = csvReader.getAllFieldsInLine();
        }
        catch (Exception headerVectorException) {
            if (headerVectorException instanceof EOFException) {
                csvReader.close();
            }
            csvReader.close();
            this.setCsvImportException(request, headerVectorException.getMessage(), rb);
            return mapping.findForward("bulkUser");
        }
        if (headerVector.isEmpty()) {
            this.setCsvImportException(request, rb.getString("admp.mgmt.csv_import.common.statmsg.empty_file_provide_ldap_attrib_values_separate_rows"), rb);
            return mapping.findForward("bulkUser");
        }
        try {
            while (true) {
                valuesVector = csvReader.getAllFieldsInLine();
                list.add(valuesVector);
            }
        }
        catch (EOFException eofexception) {
            csvReader.close();
        }
        catch (IOException e) {
            this.setCsvImportException(request, e.getMessage(), rb);
            return mapping.findForward("bulkUser");
        }
        catch (Exception valuesVectorException) {
            if (valuesVectorException instanceof EOFException) {
                csvReader.close();
            }
            csvReader.close();
            this.setCsvImportException(request, valuesVectorException.getMessage(), rb);
            return mapping.findForward("bulkUser");
        }
        if (list.isEmpty()) {
            this.setCsvImportException(request, rb.getString("admp.mgmt.csv_import.common.statmsg.one_row_available_provide_both_ldap_attrib_header_values_in_consecutive_rows"), rb);
            return mapping.findForward("bulkUser");
        }
        ArrayList<Hashtable> attributeList = (ArrayList<Hashtable>)session.getAttribute("attributeList");
        if (attributeList == null || attributeList.isEmpty()) {
            attributeList = new ArrayList<Hashtable>();
        }
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        ArrayList unKnownAttribtesList = new ArrayList();
        ArrayList authorizedCustomAttribList = new ArrayList();
        Set extendedLdapList = ExtendedAttributesUtil.getDistinctMembersList("ATTRIB_LDAP_NAME");
        if (headerVector != null) {
            ArrayList unAuthorizedAttributeList = new ArrayList();
            headerSize = headerVector.size();
            Boolean isOUNameInCSV = (Boolean)userBean.get("isOUNameInCSV");
            if (isOUNameInCSV.booleanValue()) {
                ArrayList previousUserDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
                if (previousUserDetailsList.size() > 1) {
                    Hashtable firstUserhashtable = (Hashtable)previousUserDetailsList.get(1);
                    if (firstUserhashtable != null) {
                        Hashtable headerListHashtable = (Hashtable)previousUserDetailsList.get(0);
                        ArrayList headerList = (ArrayList)headerListHashtable.get("USER_VALUES");
                        for (Hashtable headerHashtable : headerList) {
                            String ldapName = (String)headerHashtable.get("ATTRIB_LDAP_NAME");
                            if (!ldapName.equalsIgnoreCase("OUName")) continue;
                            userBean.setOUNameInCSV(request, true);
                            ouPresent = true;
                        }
                    }
                } else {
                    userBean.setOUNameInCSV(request, false);
                    session.setAttribute("attributeList", new ArrayList());
                }
            } else {
                for (Object object : headerVector) {
                    if (!object.toString().equalsIgnoreCase("OUName")) continue;
                    userBean.setOUNameInCSV(request, true);
                    ouPresent = true;
                }
            }
            attributeList = (ArrayList<Hashtable>)session.getAttribute("attributeList");
            if (attributeList == null || attributeList.isEmpty()) {
                attributeList = new ArrayList<Hashtable>();
            }
            for (Object object : headerVector) {
                if (object.toString() == "") {
                    message = new StringBuilder();
                    message.append(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.get_empty_header_error"));
                    request.setAttribute("importErrorMessage", (Object)message.toString());
                    request.setAttribute("introductionStyle", (Object)"display:none");
                    request.setAttribute("importErrorStyle", (Object)"display:block");
                    request.setAttribute("userAttributesPageStyle", (Object)"display:none");
                    request.setAttribute("userDetailsPageStyle", (Object)"display:none");
                    request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_users"));
                    return mapping.findForward("bulkUser");
                }
                Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", object);
                if (!attributesdetails.isEmpty()) {
                    Long actionId = (Long)attributesdetails.get("ACTION_ID");
                    if (actionId != null && !ClientUtil.checkAuthorization(request, selectedDomainName, (long)actionId) && !isWorkflowMode) {
                        unAuthorizedAttributeList.add(object);
                        continue;
                    }
                    if (extendedLdapList.contains(object.toString())) {
                        if (!ExtendedAttributesUtil.isAuthorized(request, object.toString(), "ACTION_ID", selectedDomainName)) {
                            unAuthorizedAttributeList.add(object);
                            continue;
                        }
                        if (attributeList.contains(attributesdetails)) continue;
                        attributeList.add(attributesdetails);
                        continue;
                    }
                    if (actionId != null) {
                        if (!attributeList.contains(attributesdetails) && actionId < 16000L) {
                            attributeList.add(attributesdetails);
                            continue;
                        }
                        if (actionId <= 16000L) continue;
                        authorizedCustomAttribList.add(object);
                        continue;
                    }
                    if (actionId != null || attributeList.contains(attributesdetails)) continue;
                    attributeList.add(attributesdetails);
                    continue;
                }
                if (!AddUserClientUtil.checkAuthorizationForCustomAttributes(request, selectedDomainName, object)) {
                    unAuthorizedAttributeList.add(object);
                    continue;
                }
                unKnownAttribtesList.add(object);
            }
            if (!unAuthorizedAttributeList.isEmpty()) {
                message = new StringBuilder();
                ArrayList l = unAuthorizedAttributeList;
                for (Object object : l) {
                    if (l.indexOf(object) != 0) {
                        message.append(", ");
                    }
                    message.append(object);
                }
                String str = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.follng_attributes_not_authorized"), message.toString());
                request.setAttribute("importErrorMessage", (Object)str);
                request.setAttribute("introductionStyle", (Object)"display:none");
                request.setAttribute("importErrorStyle", (Object)"display:block");
                request.setAttribute("userAttributesPageStyle", (Object)"display:none");
                request.setAttribute("userDetailsPageStyle", (Object)"display:none");
                request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_users"));
                return mapping.findForward("bulkUser");
            }
        }
        session.setAttribute("attributeList", attributeList);
        ArrayList userDetailsList = new ArrayList();
        ArrayList customAttributesList = new ArrayList();
        boolean templatePresent = false;
        if (headerVector != null && !list.isEmpty()) {
            for (Vector vector : list) {
                try {
                    Hashtable userDetails = new Hashtable();
                    ArrayList<Properties> arrayList = new ArrayList<Properties>();
                    for (int i = 0; i < vector.size(); ++i) {
                        Object object = vector.get(i);
                        String headerObject = (String)headerVector.get(i);
                        if (unKnownAttribtesList.contains(headerObject) || authorizedCustomAttribList.contains(headerObject)) {
                            String s = (String)object;
                            if (headerObject.equalsIgnoreCase("templateName")) {
                                Long id = UserTemplateHandler.getTemplateId((String)s);
                                if (id == null || !UserTemplateHandler.isAuthorized((Long)loginId, (Long)id)) continue;
                                templatePresent = true;
                                if (!((Boolean)userBean.get("isOUNameInCSV")).booleanValue()) {
                                    Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)"OUName");
                                    attributeList.add(attributesdetails);
                                    userBean.setOUNameInCSV(request, true);
                                }
                                Properties properties = new Properties();
                                properties.setProperty("CUSTOM_ATTRIB_NAME", headerObject);
                                properties.setProperty("CUSTOM_ATTRIB_VALUE", id.toString());
                                arrayList.add(properties);
                                continue;
                            }
                            Properties properties = new Properties();
                            properties.setProperty("CUSTOM_ATTRIB_NAME", headerObject);
                            properties.setProperty("CUSTOM_ATTRIB_VALUE", s);
                            arrayList.add(properties);
                            continue;
                        }
                        for (Hashtable hashtable : attributeList) {
                            String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                            Integer relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                            if (extendedLdapList.contains(headerObject) && !ExtendedAttributesUtil.isAuthorizedValue(request, headerObject, object, "ACTION_ID", selectedDomainName)) {
                                String str = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.follng_attribute_have_restricted_permission"), headerObject);
                                request.setAttribute("importErrorMessage", (Object)str);
                                request.setAttribute("introductionStyle", (Object)"display:none");
                                request.setAttribute("importErrorStyle", (Object)"display:block");
                                request.setAttribute("userAttributesPageStyle", (Object)"display:none");
                                request.setAttribute("userDetailsPageStyle", (Object)"display:none");
                                request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_users"));
                                return mapping.findForward("bulkUser");
                            }
                            if (relationalType == 1) {
                                String[] multiValuesArray;
                                ArrayList<String> l = new ArrayList<String>();
                                String str = (String)object;
                                for (String string : multiValuesArray = str.split("(?<!\\\\);")) {
                                    l.add(string);
                                }
                                if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                                userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), l);
                                continue;
                            }
                            if (!ldapName.equalsIgnoreCase(headerObject)) continue;
                            userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), object);
                        }
                    }
                    userDetailsList.add(userDetails);
                    customAttributesList.add(arrayList);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    int vectorIndex = list.indexOf(vector);
                    vectorIndex = header.booleanValue() ? (vectorIndex += 2) : ++vectorIndex;
                    message = new StringBuilder();
                    String mesStr = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_line_in_csv_at_line_number"), vectorIndex, vector.size(), headerSize);
                    message.append(mesStr);
                    request.setAttribute("importErrorMessage", (Object)message.toString());
                    request.setAttribute("introductionStyle", (Object)"display:none");
                    request.setAttribute("importErrorStyle", (Object)"display:block");
                    request.setAttribute("userAttributesPageStyle", (Object)"display:none");
                    request.setAttribute("userDetailsPageStyle", (Object)"display:none");
                    request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_users"));
                    return mapping.findForward("bulkUser");
                }
            }
        }
        if (!userDetailsList.isEmpty()) {
            AddUserHandler.getInstance().addUserDetailsList(userCreationID, userDetailsList, attributeList, customAttributesList);
        }
        if (templatePresent) {
            Properties passwordProps = (Properties)session.getAttribute("PasswordPolicy");
            String domainName = (String)session.getAttribute("userCreationDomain");
            Properties domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            String domainDNSName = domainProps.getProperty("DOMAIN_DNS_NAME");
            ArrayList toBeRemovedAttributes = new ArrayList();
            ArrayList<Hashtable> toBeUpdatedList = new ArrayList<Hashtable>();
            Hashtable presentTemplateDetails = UserTemplateHandler.getTemplateDetails((Long)0L);
            userDetailsList = AddUserHandler.getInstance().getSimpleUserDetailsList(userCreationID, attributeList);
            Hashtable customAttributes = AddUserHandler.getInstance().getCustomAttributesList(userCreationID);
            for (Hashtable hashtable : userDetailsList) {
                Long userIndex = (Long)hashtable.get("USER_INDEX");
                Hashtable customValues = (Hashtable)customAttributes.get(userIndex);
                ArrayList l = (ArrayList)customValues.remove("templateName");
                if (l == null || l.isEmpty()) continue;
                Long templateId = Long.parseLong((String)l.get(0));
                Hashtable toBeSetTemplateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
                ArrayList mailServerDNs = (ArrayList)session.getAttribute("mailServerDNs");
                ArrayList mailBoxStoreDNs = (ArrayList)session.getAttribute("mailBoxStoreDNs");
                ArrayList msExchAdminGroupDNList = (ArrayList)session.getAttribute("msExchAdminGroupDNList");
                Hashtable exchangeDefault = new Hashtable();
                exchangeDefault.put("MAIL_SERVER", mailServerDNs.get(0));
                exchangeDefault.put("MAIL_BOX_STORE", mailBoxStoreDNs.get(0));
                exchangeDefault.put("MS_EXCH_ADMIN_GROUP", msExchAdminGroupDNList.get(0));
                Hashtable hash = ApplyTemplateHandler.applyTemplate((Hashtable)hashtable, attributeList, (Hashtable)toBeSetTemplateDetails, (Hashtable)presentTemplateDetails, (Properties)passwordProps, (String)domainName, (String)domainDNSName, toBeRemovedAttributes, (int)userDetailsList.indexOf(hashtable), exchangeDefault, (Long)loginId);
                this.setTemplateContainer(hash, toBeSetTemplateDetails, ouPresent);
                toBeUpdatedList.add(hash);
            }
            for (String string : toBeRemovedAttributes) {
                Hashtable hashtable = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                if (hashtable != null && hashtable.isEmpty() || !attributeList.contains(hashtable)) continue;
                attributeList.remove(hashtable);
            }
            AddUserHandler.getInstance().updateUserDetailsList(userCreationID, toBeUpdatedList, attributeList);
            AddUserHandler.getInstance().removeTemplateIds(userCreationID);
        }
        request.setAttribute("importErrorMessage", (Object)"Successfully Imported Values");
        request.setAttribute("introductionStyle", (Object)"display:none");
        request.setAttribute("importErrorStyle", (Object)"display:none");
        request.setAttribute("userAttributesPageStyle", (Object)"display:none");
        request.setAttribute("userDetailsPageStyle", (Object)"display:block");
        request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_more"));
        return mapping.findForward("bulkUser");
    }

    public void setTemplateContainer(Hashtable hash, Hashtable toBeSetTemplateDetails, boolean ouPresent) {
        if (!ouPresent) {
            try {
                String container = (String)toBeSetTemplateDetails.get("container");
                System.out.println("Container: " + container);
                Hashtable hashtable = (Hashtable)hash.get("USER_VALUES");
                hashtable.put("OU_NAME", container);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public ActionForward getUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            UserBean bean = (UserBean)form;
            Properties properties = null;
            String domainName = (String)session.getAttribute("userCreationDomain");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (domainName == null) {
                properties = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = properties.getProperty("DOMAIN_NAME");
            } else {
                properties = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            String defaultNamingContext = properties.getProperty("DEFAULT_NAMING_CONTEXT");
            String defaultContainerName = UserMgmtUtil.getDefaultContainerName((String)defaultNamingContext, (ArrayList)ouList);
            ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
            if (attributeList == null) {
                attributeList = new ArrayList();
            }
            Long userCreationID = (Long)request.getSession().getAttribute("userCreationID");
            ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
            Boolean isOUNameInCSV = (Boolean)bean.get("isOUNameInCSV");
            Long templateId = ApplyTemplateHandler.getTemplateId((Long)userCreationID);
            if (isOUNameInCSV.booleanValue() && templateId != 0L) {
                for (int i = 0; i < userDetailsList.size(); ++i) {
                    Hashtable userAttributeDetails = (Hashtable)userDetailsList.get(i);
                    ArrayList userValueList = (ArrayList)userAttributeDetails.get("USER_VALUES");
                    Long userIndex = (Long)userAttributeDetails.get("USER_INDEX");
                    for (Hashtable hashtable : userValueList) {
                        String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                        Object value = hashtable.get("ATTRIB_VALUE");
                        if (!ldapName.equalsIgnoreCase("OUName") || value != null && !value.toString().equalsIgnoreCase("")) continue;
                        String tableName = "ADSMAUNamingAttributes";
                        Hashtable toBeSetTemplateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
                        String container = (String)toBeSetTemplateDetails.get("container");
                        if (ouList == null) {
                            value = container;
                        } else if (ouList.isEmpty()) {
                            value = container;
                        } else {
                            for (Object object : ouList) {
                                String string = (String)object;
                                if (!container.equalsIgnoreCase(string) && !container.endsWith(string)) continue;
                                value = container;
                            }
                        }
                        if (value == null) {
                            value = defaultContainerName;
                        }
                        hashtable.put("ATTRIB_VALUE", value);
                        UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
                        Criteria criteria = new Criteria(new Column(tableName, "USER_INDEX"), (Object)userIndex, 0);
                        updateQuery.setCriteria(criteria);
                        updateQuery.setUpdateColumn("OU_NAME", value);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
                    }
                }
            }
            int attribSize = 0;
            attribSize = attributeList.size();
            request.setAttribute("attribSize", (Object)attribSize);
            request.setAttribute("userDetailsList", (Object)userDetailsList);
            Hashtable customAttributes = AddUserHandler.getInstance().getCustomAttributesList(userCreationID);
            request.setAttribute("customAttributes", (Object)customAttributes);
            request.setAttribute("defaultContainerName", (Object)defaultContainerName);
            ArrayList customAttributeList = new ArrayList();
            if (!customAttributes.isEmpty()) {
                Enumeration enumeration = customAttributes.keys();
                while (enumeration.hasMoreElements()) {
                    Object key = enumeration.nextElement();
                    Hashtable nameVsValues = (Hashtable)customAttributes.get(key);
                    if (nameVsValues.isEmpty()) continue;
                    Enumeration enumeration2 = nameVsValues.keys();
                    while (enumeration2.hasMoreElements()) {
                        Object object = enumeration2.nextElement();
                        if (customAttributeList.contains(object)) continue;
                        customAttributeList.add(object);
                    }
                }
            }
            request.setAttribute("customAttributeList", customAttributeList);
            if (userDetailsList.isEmpty()) {
                request.setAttribute("listEmpty", (Object)"true");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("userDetails");
    }

    public ActionForward addorUpdateUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserBean userBean = (UserBean)form;
        boolean isWorkflowMode = false;
        if (userBean.get("mode") != null && "workflow".equalsIgnoreCase((String)userBean.get("mode"))) {
            isWorkflowMode = true;
        }
        userBean.initialize(mapping);
        HttpSession session = request.getSession();
        String operation = request.getParameter("operation");
        String forward = "userAttributeDetails";
        String domainName = (String)session.getAttribute("userCreationDomain");
        if (operation != null) {
            userBean.set("operation", operation);
            if (operation.equalsIgnoreCase("add")) {
                userBean.initAttributeDetails(request, "bulk", domainName, 0L, new ArrayList(), isWorkflowMode);
            } else {
                String userIndexString = request.getParameter("userIndex");
                long userIndex = Long.parseLong(userIndexString);
                if (operation.equalsIgnoreCase("modify")) {
                    UserAttributeHandler.modifyUserAttributeDetails(userBean, userIndex, request, domainName);
                    request.setAttribute("userIndex", (Object)userIndex);
                } else if (operation.equalsIgnoreCase("copy")) {
                    Long copyIndex = UserAttributeHandler.copyUserAttributeDetails(userBean, userIndex, request);
                    request.setAttribute("copyIndex", (Object)copyIndex);
                    ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
                    if (attributeList == null) {
                        attributeList = new ArrayList();
                    }
                    Long userCreationID = (Long)request.getSession().getAttribute("userCreationID");
                    ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
                    int attribSize = 0;
                    attribSize = attributeList.size();
                    request.setAttribute("attribSize", (Object)attribSize);
                    request.setAttribute("userDetailsList", (Object)userDetailsList);
                    Hashtable customAttributes = AddUserHandler.getInstance().getCustomAttributesList(userCreationID);
                    request.setAttribute("customAttributes", (Object)customAttributes);
                    ArrayList customAttributeList = new ArrayList();
                    if (!customAttributes.isEmpty()) {
                        Enumeration enumeration = customAttributes.keys();
                        while (enumeration.hasMoreElements()) {
                            Object key = enumeration.nextElement();
                            Hashtable nameVsValues = (Hashtable)customAttributes.get(key);
                            if (nameVsValues.isEmpty()) continue;
                            Enumeration enumeration2 = nameVsValues.keys();
                            while (enumeration2.hasMoreElements()) {
                                Object object = enumeration2.nextElement();
                                if (customAttributeList.contains(object)) continue;
                                customAttributeList.add(object);
                            }
                        }
                    }
                    request.setAttribute("customAttributeList", customAttributeList);
                    if (userDetailsList.isEmpty()) {
                        request.setAttribute("listEmpty", (Object)"true");
                    }
                    forward = "userDetails";
                }
            }
        }
        if (isWorkflowMode) {
            userBean.set("mode", "workflow");
        } else {
            userBean.set("mode", "default");
        }
        return mapping.findForward(forward);
    }

    public ActionForward setFormatValues(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserBean userBean = (UserBean)form;
        try {
            String value;
            Long format;
            String varName = request.getParameter("varName");
            String varValue = request.getParameter("varValue");
            String rowCount = request.getParameter("rowCount");
            userBean.setCheckPrivilege(false);
            ArrayList<Properties> customAttribList = new ArrayList<Properties>();
            if (!varName.equals("ldapValue")) {
                userBean.set(varName, varValue);
            }
            if (rowCount != null) {
                Long count = Long.parseLong(rowCount);
                int i = 0;
                while ((long)i < count) {
                    String cusAttribName = request.getParameter("attrib_name" + i);
                    String cusAttribVal = request.getParameter("attrib_value" + i);
                    Properties prop = new Properties();
                    prop.setProperty("CUSTOM_ATTRIB_NAME", cusAttribName);
                    prop.setProperty("CUSTOM_ATTRIB_VALUE", cusAttribVal);
                    customAttribList.add(prop);
                    ++i;
                }
            }
            HttpSession session = request.getSession();
            String domainName = (String)session.getAttribute("userCreationDomain");
            Long userCreationID = (Long)session.getAttribute("userCreationID");
            Hashtable formatProps = null;
            if (userCreationID != null) {
                formatProps = UserMgmtUtil.getNamingFormats((Long)userCreationID);
            }
            Properties valuesProps = new Properties();
            Long logonNameformat = (Long)formatProps.get("LOGON_NAME_FORMAT");
            String logonNameValue = "";
            if (varName.equals("LOGON_NAME")) {
                logonNameValue = varValue;
            } else if (!varName.equals("SAM_ACCOUNT_NAME")) {
                if (logonNameformat != null) {
                    logonNameValue = FormatClientUtil.getFormattedName(logonNameformat, userBean, domainName, "", customAttribList);
                }
                valuesProps.setProperty("LOGON_NAME", logonNameValue);
                userBean.set("LOGON_NAME", logonNameValue);
            } else {
                logonNameValue = (String)userBean.get("LOGON_NAME");
            }
            for (String string : UserTemplateUtil.namingTableColumns) {
                if (string.equals("LOGON_NAME_FORMAT")) continue;
                format = (Long)formatProps.get(string);
                value = "";
                if (format.equals(0L)) {
                    value = logonNameValue;
                } else if (format != null) {
                    value = FormatClientUtil.getFormattedName(format, userBean, domainName, logonNameValue, customAttribList);
                }
                if (!varName.equals("SAM_ACCOUNT_NAME")) {
                    valuesProps.setProperty(string.substring(0, string.lastIndexOf("_")), value);
                    userBean.set(string.substring(0, string.lastIndexOf("_")), value);
                    continue;
                }
                if (string.equals("SAM_ACCOUNT_NAME_FORMAT")) continue;
                valuesProps.setProperty(string.substring(0, string.lastIndexOf("_")), value);
                userBean.set(string.substring(0, string.lastIndexOf("_")), value);
            }
            for (String string : UserTemplateUtil.exchangeNamingColumns) {
                format = (Long)formatProps.get(string);
                value = "";
                if (format.equals(0L)) {
                    value = logonNameValue;
                } else if (format != null) {
                    value = FormatClientUtil.getFormattedName(format, userBean, domainName, logonNameValue, customAttribList);
                }
                if (string.equals("EMAIL_ADDRESS_FORMAT") && !format.equals(-1L)) {
                    String mailServer = (String)session.getAttribute("emailServerDNSName");
                    value = value + "@" + mailServer;
                }
                valuesProps.setProperty(string.substring(0, string.lastIndexOf("_")), value);
                userBean.set(string.substring(0, string.lastIndexOf("_")), value);
            }
            for (String string : UserTemplateUtil.mailEnableNamingColumns) {
                format = (Long)formatProps.get(string);
                value = "";
                if (format.equals(0L)) {
                    value = logonNameValue;
                } else if (format != null) {
                    value = FormatClientUtil.getFormattedName(format, userBean, domainName, logonNameValue, customAttribList);
                }
                valuesProps.setProperty(string.substring(0, string.lastIndexOf("_")), value);
                userBean.set(string.substring(0, string.lastIndexOf("_")), value);
            }
            ByteArrayOutputStream stream = UserMgmtUtil.getFormattedNamesXML((Properties)valuesProps);
            response.setContentType("text/xml");
            PrintWriter writer = response.getWriter();
            writer.print(stream);
            if (userBean.get("mode") != null && !"workflow".equalsIgnoreCase((String)userBean.get("mode"))) {
                userBean.setCheckPrivilege(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward saveUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String message = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_saved");
        UserBean userBean = (UserBean)form;
        userBean.saveUserDetails(request);
        request.setAttribute("message", (Object)message);
        return mapping.findForward("userAttributeDetails");
    }

    public ActionForward deleteUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        long userIndex = Long.parseLong(request.getParameter("userIndex"));
        AddUserHandler.getInstance().deleteUserDetails(Long.valueOf(userIndex));
        HttpSession session = request.getSession();
        ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
        if (attributeList == null) {
            attributeList = new ArrayList();
        }
        Long userCreationID = (Long)request.getSession().getAttribute("userCreationID");
        ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
        int attribSize = 0;
        attribSize = attributeList.size();
        request.setAttribute("attribSize", (Object)attribSize);
        request.setAttribute("userDetailsList", (Object)userDetailsList);
        Hashtable customAttributes = AddUserHandler.getInstance().getCustomAttributesList(userCreationID);
        request.setAttribute("customAttributes", (Object)customAttributes);
        ArrayList customAttributeList = new ArrayList();
        if (!customAttributes.isEmpty()) {
            Enumeration enumeration = customAttributes.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                Hashtable nameVsValues = (Hashtable)customAttributes.get(key);
                if (nameVsValues.isEmpty()) continue;
                Enumeration enumeration2 = nameVsValues.keys();
                while (enumeration2.hasMoreElements()) {
                    Object object = enumeration2.nextElement();
                    if (customAttributeList.contains(object)) continue;
                    customAttributeList.add(object);
                }
            }
        }
        request.setAttribute("customAttributeList", customAttributeList);
        if (userDetailsList.isEmpty()) {
            request.setAttribute("listEmpty", (Object)"true");
        }
        return mapping.findForward("userDetails");
    }

    public ActionForward getADObjects(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            UserBean userBean = (UserBean)form;
            String nodeClicked = request.getParameter("container");
            boolean isWorkflowMode = false;
            if (userBean.get("mode") != null && "workflow".equalsIgnoreCase((String)userBean.get("mode"))) {
                isWorkflowMode = true;
            }
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = (String)session.getAttribute("userCreationDomain");
            Properties selectedDomain = null;
            if (domainName == null) {
                domainName = request.getParameter("domainName");
            }
            if (domainName == null) {
                selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = selectedDomain.getProperty("DOMAIN_NAME");
            } else {
                selectedDomain = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            this.setDirectoryObject(selectedDomain, request, isWorkflowMode);
            String domainPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            String nodeClickedClone = nodeClicked;
            if (!domainPath.equalsIgnoreCase(nodeClickedClone)) {
                int domainNameIndex = nodeClicked.indexOf(domainPath);
                nodeClicked = nodeClicked.substring(0, domainNameIndex - 1);
                LdapName name = new LdapName(nodeClicked);
                List<Rdn> rdns = name.getRdns();
                String parentOUName = "";
                for (int index = 0; index < rdns.size(); ++index) {
                    Rdn rdn = rdns.get(index);
                    parentOUName = index == 0 ? rdn.toString() + "," + domainPath : rdn.toString() + "," + parentOUName;
                    this.setDirectoryObject(selectedDomain, parentOUName, request);
                    request.setAttribute("selectedObject", (Object)parentOUName);
                }
            }
            userBean.set("container", nodeClickedClone);
            if (isWorkflowMode) {
                Boolean isAuthorized = false;
                ArrayList authorizedWFDomainNamelist = WorkFlowUserHandler.getAuthorizedDomainListForCatagory((Long)loginId, (Integer)5);
                for (Properties prop : authorizedWFDomainNamelist) {
                    if (!domainName.equals(prop.getProperty("DOMAIN_NAME"))) continue;
                    isAuthorized = true;
                }
                request.setAttribute("authorized", (Object)String.valueOf(isAuthorized));
            } else if (request.getParameter("actionId") != null) {
                Long actionId = new Long(Long.parseLong(request.getParameter("actionId")));
                request.setAttribute("authorized", (Object)String.valueOf(ClientUtil.checkAuthorization(request, domainName, (long)actionId)));
            }
            request.setAttribute("selectedDomainName", (Object)domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setAttribute("errorMessage", (Object)e.getMessage());
        }
        return mapping.findForward("ado");
    }

    private void setDirectoryObject(Properties selectedDomain, HttpServletRequest request) throws Exception {
        this.setDirectoryObject(selectedDomain, request, false);
    }

    private void setDirectoryObject(Properties selectedDomain, HttpServletRequest request, Boolean isWorkflow) throws Exception {
        try {
            String domainName = selectedDomain.getProperty("DOMAIN_NAME");
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = new ArrayList();
            ouList = isWorkflow == false ? ClientAuthorizationUtil.getAuthorizedOUList(request, domainName) : WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId);
            DirectoryObject object = DirectoryObjectUtil.getDirectoryObject(domainName, loginId, rootPath, ouList);
            DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
            request.setAttribute("rootPath", (Object)rootPath);
            session.setAttribute("TreeModel", (Object)model);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request) {
        this.setDirectoryObject(selectedDomain, nodeClicked, request, false);
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request, Boolean isWorkflow) {
        if (isWorkflow.booleanValue()) {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList ouList = WFRequesterUtil.getOUListDN((String)selectedDomain.getProperty("DOMAIN_NAME"), (Long)loginId);
            if (ouList.contains(nodeClicked)) {
                this.setDirectoryObject(selectedDomain, nodeClicked, request, "TreeModel");
            }
        } else if (ClientAuthorizationUtil.isAuthorizedOU(request, selectedDomain.getProperty("DOMAIN_NAME"), nodeClicked)) {
            this.setDirectoryObject(selectedDomain, nodeClicked, request, "TreeModel");
        }
    }

    private void setDirectoryObject(Properties selectedDomain, String nodeClicked, HttpServletRequest request, String modelName) {
        try {
            String rootPath = selectedDomain.getProperty("DEFAULT_NAMING_CONTEXT");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(modelName);
            DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
            int index = nodeClicked.indexOf(rootPath);
            if (index > 0) {
                ArrayList<String> filter = new ArrayList<String>();
                filter.add("organizationalUnit");
                filter.add("container");
                DirectoryObjectUtil.getDirectoryObject(object, nodeClicked, selectedDomain, loginId, filter, false);
                DirectoryObjectTreeModel newModel = new DirectoryObjectTreeModel((TreeObject)object);
                session.setAttribute(modelName, (Object)newModel);
                String bookMarks = request.getParameter("bookmark");
                ArrayList<String> pathToOpen = (ArrayList<String>)session.getAttribute("TreeModel_showLines_showRootNode_OPENED-NODES");
                if (pathToOpen == null) {
                    pathToOpen = new ArrayList<String>();
                }
                pathToOpen.add(nodeClicked);
                session.setAttribute("TreeModel_showLines_showRootNode_OPENED-NODES", pathToOpen);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward summary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("status");
    }

    public ActionForward addMoreProxyAddressesDiv(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("editProxyAddressesDiv");
    }

    public ActionForward modifyAttribute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean saveFlag = true;
        try {
            HttpSession session = request.getSession();
            String index = request.getParameter("index");
            String value = request.getParameter("value");
            String attribute = request.getParameter("attribute");
            Long userCreationID = (Long)request.getSession().getAttribute("userCreationID");
            ArrayList attributeList = (ArrayList)request.getSession().getAttribute("attributeList");
            Hashtable attributeDetails = AddUserHandler.getInstance().getAttributeDetails(attribute, attributeList);
            String tableName = (String)attributeDetails.get("AU_TABLE_NAME");
            Long actionId = (Long)attributeDetails.get("ACTION_ID");
            String domainName = (String)session.getAttribute("userCreationDomain");
            if (actionId != null && ClientUtil.checkAuthorization(request, domainName, (long)actionId)) {
                Long longIndex = new Long(index);
                UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
                Criteria criteria = new Criteria(new Column(tableName, "USER_INDEX"), (Object)longIndex, 0);
                updateQuery.setCriteria(criteria);
                updateQuery.setUpdateColumn(attribute, (Object)value);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
            }
        }
        catch (Exception e) {
            saveFlag = false;
            e.printStackTrace();
        }
        if (saveFlag) {
            ClientUtil.setStatusXMLElement(response, "Success", "");
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward editGroups(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList<Properties> availableGroups = null;
        ArrayList selectedGroups = null;
        ArrayList<Properties> selectedGroupsRefreshed = new ArrayList<Properties>();
        try {
            String beanName = request.getParameter("beanName");
            HttpSession session = request.getSession();
            UserBean userBean = (UserBean)((Object)session.getAttribute(beanName));
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String domainName = request.getParameter("domainName");
            Properties domainProps = null;
            if (domainName == null) {
                domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
                domainName = domainProps.getProperty("DOMAIN_NAME");
            } else {
                domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            }
            ArrayList groupList = (ArrayList)session.getAttribute("userCreationGroupList");
            if (request.getParameter("groupString") != null) {
                String groupString = request.getParameter("groupString");
                StringTokenizer tokenizer = new StringTokenizer(groupString, ";");
                ArrayList<Properties> MEMBER_OF = new ArrayList<Properties>();
                StringBuilder builder = new StringBuilder("");
                while (tokenizer.hasMoreElements()) {
                    String distinguishedName = tokenizer.nextToken();
                    Properties properties = UserMgmtUtil.getPropertiesfromDN((String)distinguishedName, (ArrayList)groupList);
                    if (properties != null) {
                        MEMBER_OF.add(properties);
                    }
                    if (properties == null) continue;
                    String displayName = properties.getProperty("Display_Name");
                    builder.append(displayName);
                    if (!tokenizer.hasMoreElements()) continue;
                    builder.append(", ");
                }
                userBean.set("MEMBER_OF", MEMBER_OF);
                request.setAttribute("edited", (Object)"true");
                request.setAttribute("groupString", (Object)builder.toString());
                String pg = request.getParameter("pg");
                Properties PRIMARY_GROUP = UserMgmtUtil.getPropertiesfromDN((String)pg, (ArrayList)groupList);
                userBean.set("PRIMARY_GROUP", PRIMARY_GROUP);
                String groupRID = null;
                if (PRIMARY_GROUP != null) {
                    groupRID = PRIMARY_GROUP.getProperty("objectRID");
                }
                userBean.set("PRIMARY_GROUP_ID", groupRID);
            } else {
                availableGroups = new ArrayList<Properties>();
                for (Properties properties : groupList) {
                    String distinguishedName = properties.getProperty("distinguishedName");
                    String name = properties.getProperty("name");
                    String groupType = properties.getProperty("groupType");
                    String objectRID = properties.getProperty("objectSID");
                    objectRID = objectRID.substring(objectRID.lastIndexOf("-") + 1, objectRID.length());
                    Properties properties2 = new Properties();
                    properties2.setProperty("Display_Name", name);
                    properties2.setProperty("Distinguished_Name", distinguishedName);
                    properties2.setProperty("objectRID", objectRID);
                    properties2.setProperty("groupType", groupType);
                    availableGroups.add(properties2);
                }
                selectedGroups = (ArrayList)userBean.get("MEMBER_OF");
                ArrayList<Properties> tobeDeletedProps = new ArrayList<Properties>();
                for (Properties properties : selectedGroups) {
                    if (properties == null) continue;
                    for (Properties properties2 : availableGroups) {
                        if (!properties2.equals(properties)) continue;
                        tobeDeletedProps.add(properties2);
                    }
                    selectedGroupsRefreshed.add(properties);
                }
                userBean.set("MEMBER_OF", selectedGroupsRefreshed);
                for (Properties properties : tobeDeletedProps) {
                    availableGroups.remove(properties);
                }
            }
            request.setAttribute("beanName", (Object)beanName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("availableGroups", availableGroups);
        request.setAttribute("selectedGroups", selectedGroupsRefreshed);
        return mapping.findForward("groups");
    }

    public ActionForward validateUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String forward = "bulkUser";
        try {
            HttpSession session = request.getSession();
            Long userCreationID = (Long)session.getAttribute("userCreationID");
            ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
            Properties properties = (Properties)session.getAttribute("PasswordPolicy");
            String domainName = (String)session.getAttribute("userCreationDomain");
            Long templateId = ApplyTemplateHandler.getTemplateId((Long)userCreationID);
            ApplyTemplateHandler.applyTemplate((Long)userCreationID, (ArrayList)attributeList, (Long)templateId, (Properties)properties, (String)domainName, (HttpSession)session);
            forward = "selectContainerPage";
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (forward.equals("bulkUser")) {
            request.setAttribute("importErrorMessage", (Object)"");
            request.setAttribute("introductionStyle", (Object)"display:none");
            request.setAttribute("importErrorStyle", (Object)"display:none");
            request.setAttribute("userAttributesPageStyle", (Object)"display:none");
            request.setAttribute("userDetailsPageStyle", (Object)"display:block");
            request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_more"));
            request.setAttribute("validationErrors", (Object)"true");
        }
        return mapping.findForward(forward);
    }

    public ActionForward addUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList list;
        Locale locale = request.getLocale();
        UserBean bean = (UserBean)form;
        HttpSession session = request.getSession();
        String hostId = request.getRemoteHost();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        AddUserListener addUserListener = bean.getListener();
        if (request.getParameter("StopUserCreation") != null) {
            if (!addUserListener.isCompleted()) {
                addUserListener.stop();
            }
        } else if (addUserListener == null) {
            String containerName = request.getParameter("container");
            bean.set("container", containerName);
            AddUserHandler.getInstance().setContainer(userCreationID, containerName);
            ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
            String domainName = (String)session.getAttribute("userCreationDomain");
            ArrayList list2 = (ArrayList)session.getAttribute("userCreationGroupList");
            ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
            addUserListener = new AddUserListener(userCreationID, domainName, loginId, hostId, containerName, userDetailsList, list2, attributeList);
            bean.setListener(addUserListener);
            addUserListener.addUser(locale);
        }
        if ((list = AddUserHandler.getInstance().getCreationStatus(userCreationID)) != null && !list.isEmpty()) {
            request.setAttribute("list", (Object)list);
        }
        if (!addUserListener.isCompleted()) {
            addUserListener.setWriter(response.getWriter());
            request.setAttribute("listener", (Object)addUserListener);
        }
        return mapping.findForward("status");
    }

    public ActionForward validateAndAddUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList list;
        UserBean bean = (UserBean)form;
        HttpSession session = request.getSession();
        Locale locale = request.getLocale();
        String hostId = request.getRemoteHost();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        AddUserListener addUserListener = bean.getListener();
        String containerName = "";
        if (request.getParameter("StopUserCreation") != null) {
            if (!addUserListener.isCompleted()) {
                addUserListener.stop();
            }
        } else if (addUserListener == null) {
            try {
                ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
                Properties properties = (Properties)session.getAttribute("PasswordPolicy");
                String domainName = (String)session.getAttribute("userCreationDomain");
                Long templateId = ApplyTemplateHandler.getTemplateId((Long)userCreationID);
                ApplyTemplateHandler.applyTemplate((Long)userCreationID, (ArrayList)attributeList, (Long)templateId, (Properties)properties, (String)domainName, (HttpSession)session);
                ArrayList list2 = (ArrayList)session.getAttribute("userCreationGroupList");
                ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
                addUserListener = new AddUserListener(userCreationID, domainName, loginId, hostId, containerName, userDetailsList, list2, attributeList);
                bean.setListener(addUserListener);
                addUserListener.addUser(locale);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if ((list = AddUserHandler.getInstance().getCreationStatus(userCreationID)) != null && !list.isEmpty()) {
            request.setAttribute("list", (Object)list);
        }
        if (!addUserListener.isCompleted()) {
            addUserListener.setWriter(response.getWriter());
            request.setAttribute("listener", (Object)addUserListener);
        }
        return mapping.findForward("status");
    }

    public ActionForward createAddUserRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        UserBean bean = (UserBean)form;
        HttpSession session = request.getSession();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Boolean errorId = LicenseMgr.getInstance().isModuleLicensed("Workflow");
        if (!LicenseMgr.getInstance().isTrailEdition() && !errorId.booleanValue()) {
            request.setAttribute("message", (Object)LicenseMgr.getInstance().getlicenseMessage("Workflow", rb));
            return mapping.findForward("status");
        }
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        String containerName = request.getParameter("container");
        if (containerName != null && !containerName.equals("")) {
            bean.set("container", containerName);
            AddUserHandler.getInstance().setContainer(userCreationID, containerName);
        }
        String attributeListString = "";
        ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
        for (Hashtable hashtable : attributeList) {
            attributeListString = attributeListString + hashtable.get("ATTRIB_ID") + ";";
        }
        ArrayList actionDetails = new ArrayList();
        HashMap<String, Serializable> actionToPerform = new HashMap<String, Serializable>();
        actionToPerform.put("RequestAction", Long.valueOf(21L));
        ArrayList<AdmpInput> multipleInputs = new ArrayList<AdmpInput>();
        AdmpInput admpInput = new AdmpInput("attributeListString", attributeListString, false);
        multipleInputs.add(admpInput);
        actionToPerform.put("MultipleInputs", multipleInputs);
        actionDetails.add(actionToPerform);
        WorkFlowRequest wfRequest = new WorkFlowRequest();
        wfRequest.setRequestInputActions(actionDetails);
        wfRequest.setUserCreationId(userCreationID);
        wfRequest.setRequestMode(AutomationConstants.REQUEST_MANUAL_MODE);
        Long requestId = wfRequest.createRequest(loginId, null, rb.getString("admp.workflow.viewrequest.subject_for_create_request"), rb.getString("admp.mgmt.user_mgmt.cre_single_user.requestdesc.create_user_request"), Integer.valueOf(1), Integer.valueOf(5));
        if (requestId != null) {
            WFRuleExecutor executeRule = new WFRuleExecutor(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_CREATED), requestId, rb, loginId);
            executeRule.start();
            request.setAttribute("message", (Object)rb.getString("admp.mgmt.user_mgmt.cre_bulk_user.statmsg.request_created_success"));
        } else {
            request.setAttribute("message", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.error_occured_in_creating_request"));
        }
        bean.set("mode", "default");
        return mapping.findForward("status");
    }

    public ActionForward createOU(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String container = request.getParameter("container");
        String name = request.getParameter("name");
        String domainName = request.getParameter("domainName");
        Properties domainProps = null;
        if (domainName == null) {
            domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
            domainName = domainProps.getProperty("DOMAIN_NAME");
        } else {
            domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
        }
        String message = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_created_ou");
        long l = -1L;
        try {
            l = ADHandler.createObject((String)domainName, (Long)loginId, (String)"organizationalUnit", (String)name, (String)container);
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = le.getMessage(rb);
        }
        catch (Exception e) {
            message = e.getMessage();
            e.printStackTrace();
        }
        if (l == 0L) {
            ClientUtil.setStatusXMLElement(response, "Success", message);
            System.out.println("updating OUs after ou creation.");
            try {
                DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"OU"}, (boolean)false);
                HDTApi.getInstance().updateAuthObject();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", message);
        }
        return null;
    }

    public ActionForward getMailBoxStores(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            UserBean userBean = (UserBean)form;
            HttpSession session = request.getSession();
            String domainName = request.getParameter("domainName");
            this.out.log(Level.FINE, "getMailBoxStores domainName " + domainName);
            String mailServer = request.getParameter("mailServer");
            this.out.log(Level.FINE, "getMailBoxStores mailServer " + mailServer);
            ArrayList list = ExchangeHandler.getMailBoxStores((String)domainName, (String)mailServer);
            String mailBoxVersion = ExchangeUtil.getExchangeServerType((String)mailServer).toString();
            this.out.log(Level.FINE, "getMailBoxStores mailBoxVersion " + mailBoxVersion);
            ArrayList mailBoxStores = null;
            ArrayList mailBoxStoreDNs = null;
            if (list != null && !list.isEmpty()) {
                mailBoxStores = (ArrayList)list.get(0);
                mailBoxStoreDNs = (ArrayList)list.get(1);
            }
            this.out.log(Level.FINE, "getMailBoxStores mailBoxStores " + mailBoxStores);
            this.out.log(Level.FINE, "getMailBoxStores mailBoxStoreDNs " + mailBoxStoreDNs);
            userBean.set("mailBoxStores", mailBoxStores);
            userBean.set("mailBoxStoreDNs", mailBoxStoreDNs);
            userBean.set("mailVersion", mailBoxVersion);
            if (mailBoxStoreDNs != null && !mailBoxStoreDNs.isEmpty()) {
                UserMgmtUtil.getMailBoxHTMLElement((HttpServletResponse)response, (ArrayList)mailBoxStoreDNs, (ArrayList)mailBoxStores, (boolean)false, (String)mailBoxVersion);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward applyTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        Long templateId = Long.parseLong(request.getParameter("templateId"));
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
        String domainName = (String)session.getAttribute("userCreationDomain");
        if (attributeList != null && !attributeList.isEmpty()) {
            Properties properties = (Properties)session.getAttribute("PasswordPolicy");
            ApplyTemplateHandler.applyTemplate((Long)userCreationID, (ArrayList)attributeList, (Long)templateId, (Properties)properties, (String)domainName, (HttpSession)session);
            session.setAttribute("attributeList", (Object)attributeList);
            request.setAttribute("userDetailsPageStyle", (Object)"display:block");
            request.setAttribute("introductionStyle", (Object)"display:none");
            request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_more"));
        } else {
            ApplyTemplateHandler.setTemplate((Long)loginId, (Long)userCreationID, (Long)templateId);
            request.setAttribute("userDetailsPageStyle", (Object)"display:none");
            request.setAttribute("introductionStyle", (Object)"display:block");
            request.setAttribute("addButtonText", (Object)rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.add_users"));
        }
        Hashtable templateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
        String container = (String)templateDetails.get("container");
        if (container != null && !container.equals("")) {
            boolean setContainer = false;
            ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
            if (ouList == null) {
                setContainer = true;
            } else if (ouList.isEmpty()) {
                setContainer = true;
            } else {
                for (Object object : ouList) {
                    String string = (String)object;
                    if (!container.equalsIgnoreCase(string) && !container.endsWith(string)) continue;
                    setContainer = true;
                }
            }
            if (setContainer) {
                AddUserHandler.getInstance().setContainer(userCreationID, container);
            }
        }
        request.setAttribute("importErrorMessage", (Object)"");
        request.setAttribute("importErrorStyle", (Object)"display:none");
        request.setAttribute("userAttributesPageStyle", (Object)"display:none");
        return mapping.findForward("bulkUser");
    }

    public ActionForward exportUserList(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "printPage";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            String reportType = request.getParameter("reportType");
            String reportFileName = "";
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("loginId", request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID"));
            inputParams.put("name", rb.getString("admp.common.attrib_disp_name.name"));
            inputParams.put("creationTime", rb.getString("admp.common.attrib_disp_name.cre_time"));
            inputParams.put("modifiedTime", rb.getString("admp.common.attrib_disp_name.modify_time"));
            inputParams.put("location", rb.getString("admp.common.attrib_disp_name.location"));
            if (reportType == null) {
                reportType = "";
            }
            String basepath = request.getSession().getServletContext().getRealPath("/");
            if (reportType.equals("csv")) {
                reportFileName = basepath + "jasper" + File.separator + "ListUsers_csv.jasper";
            } else {
                reportFileName = basepath + "jasper" + File.separator + "ListUsers.jasper";
                inputParams.put("domains", rb.getString("admp.mgmt.common.text.domains"));
            }
            String domainName = request.getParameter("domain");
            inputParams.put("domainList", domainName);
            ArrayList list = this.getUserList(request, domainName, -1, -1, 1L);
            this.exportReport(reportFileName, reportType, list, inputParams, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String type = request.getParameter("type");
        if (type != null && type.equals("print")) {
            return mapping.findForward(tile);
        }
        return null;
    }

    public ActionForward exportUserCreationStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String tile = "printStatusPage";
        HttpSession session = request.getSession();
        String domainName = (String)session.getAttribute("userCreationDomain");
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        String containerName = AddUserHandler.getInstance().getContainer(userCreationID);
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = basepath + "jasper" + File.separator + "UserCreationStatus.jasper";
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("domainName", domainName);
            inputParams.put("containerName", containerName);
            inputParams.put("domainText", rb.getString("admp.common.text.domain"));
            inputParams.put("containerText", rb.getString("admp.common.text.container"));
            inputParams.put("userNameText", rb.getString("admp.common.attrib_disp_name.user_name"));
            inputParams.put("logonNameText", rb.getString("admp.common.attrib_disp_name.logon_name"));
            inputParams.put("passwordText", rb.getString("admp.common.attrib_disp_name.password"));
            inputParams.put("statusText", rb.getString("admp.common.text.status"));
            inputParams.put("loginId", request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID"));
            ArrayList list = AddUserHandler.getInstance().getCreationStatus(userCreationID);
            this.exportReport(reportFileName, reportType, list, inputParams, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String type = request.getParameter("type");
        if (type != null && type.equals("printStatus")) {
            return mapping.findForward(tile);
        }
        return null;
    }

    public void exportReport(String reportFileName, String reportType, ArrayList list, Map inputParams, HttpServletRequest request, HttpServletResponse response) {
        try {
            ListUserDataProvider dataProvider = new ListUserDataProvider(list);
            JRDataSource dataSource = dataProvider.getJRDataSource();
            JasperPrint print = null;
            try {
                print = JasperFillManager.fillReport((String)reportFileName, (Map)inputParams, (JRDataSource)dataSource);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("error page " + e);
                return;
            }
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            Date date = new Date();
            String currentDate = dateFormat.format(date);
            reportFileName = "UserCreationStatus_" + currentDate;
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ActionForward searchTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            int totalTemplateCount;
            HttpSession session = request.getSession();
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String bulkUserDomainName = (String)session.getAttribute("userCreationDomain");
            Long pageNumber = 1L;
            if (request.getParameter("pageNumber") != null) {
                pageNumber = Long.parseLong(request.getParameter("pageNumber"));
            }
            int searchTemplateCount = totalTemplateCount = UserTemplateHandler.getTemplatesCount((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")), (String)bulkUserDomainName, (String)"");
            String searchText = request.getParameter("searchText");
            if (searchText != null && !searchText.equals("")) {
                searchText = request.getParameter("searchText");
                searchTemplateCount = UserTemplateHandler.getTemplatesCount((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")), (String)bulkUserDomainName, (String)searchText);
            }
            int range = 10;
            Long startIndex = (pageNumber - 1L) * (long)range + 1L;
            int totalPages = searchTemplateCount / range;
            if (searchTemplateCount % range != 0) {
                ++totalPages;
            }
            ArrayList templateList = UserTemplateHandler.getTemplates((Long)((Long)session.getAttribute("ADMP_SESSION_LOGIN_ID")), (String)bulkUserDomainName, (String)searchText, (int)startIndex.intValue());
            ByteArrayOutputStream outNode = this.searchTemplateXMLElement(templateList, rb, totalPages, totalTemplateCount, searchTemplateCount);
            response.setContentType("text/xml; charset=UTF-8");
            PrintWriter writer = response.getWriter();
            writer.print(outNode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private ByteArrayOutputStream searchTemplateXMLElement(ArrayList<Properties> templateList, AdventNetResourceBundle rb, int totalPages, int totalRecordsCount, int searchRecordsCount) {
        ByteArrayOutputStream outNode = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            String searchTemplateResult = "";
            if (templateList != null && !templateList.isEmpty()) {
                searchTemplateResult = searchTemplateResult + "<table width='300' border='0' cellspacing='0' cellpadding='5' bgcolor='#ECF3F8'> ";
                for (Properties templateDetailProp : templateList) {
                    Long tempID = (Long)templateDetailProp.get("TEMPLATE_ID");
                    String tempName = rb.getString((String)templateDetailProp.get("TEMPLATE_NAME"));
                    searchTemplateResult = searchTemplateResult + "<tr> <td><input type='radio' name='templates' value='" + tempID + "'><span class='blacktxt1'>" + tempName + "</span></td><td>&nbsp;</td></tr>";
                }
                searchTemplateResult = searchTemplateResult + "</table>";
            }
            Element templateResultElt = document.createElement("templateResultElt");
            templateResultElt.setAttribute("searchTemplateResult", searchTemplateResult);
            data.appendChild(templateResultElt);
            Element templateSizeElt = document.createElement("templateSizeElt");
            templateSizeElt.setAttribute("templateListSize", Integer.toString(searchRecordsCount));
            data.appendChild(templateSizeElt);
            Element totalPagesElt = document.createElement("totalPagesElt");
            totalPagesElt.setAttribute("totalPages", Integer.toString(totalPages));
            data.appendChild(totalPagesElt);
            Element totalRecordsCountElt = document.createElement("totalRecordsCountElt");
            totalRecordsCountElt.setAttribute("totalRecordsCount", Integer.toString(totalRecordsCount));
            data.appendChild(totalRecordsCountElt);
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }
}

