/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserBean;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class UserAttributeHandler {
    public static void initAttributes(HttpServletRequest request, UserBean userBean, String domainName, ArrayList groupList, Long userCreationID) {
        try {
            String dateString = new SimpleDateFormat("yyyy/MM/dd").format(new Date(System.currentTimeMillis()));
            userBean.set("accountExpiresValue", dateString);
            ArrayList<Properties> MEMBER_OF = new ArrayList<Properties>();
            Properties PRIMARY_GROUP = new Properties();
            String defaultNamingContext = (String)DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(domainName);
            Properties groupProps = UserMgmtUtil.getPropertiesfromRID((String)"513", (ArrayList)groupList, (String)defaultNamingContext);
            if (groupProps != null) {
                MEMBER_OF.add(groupProps);
                PRIMARY_GROUP = (Properties)groupProps.clone();
            }
            userBean.set("MEMBER_OF", MEMBER_OF);
            userBean.set("PRIMARY_GROUP", PRIMARY_GROUP);
            userBean.set("HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
            userBean.set("UPN_SUFFIX", DomainHandler.getDomainDNSName((String)domainName));
            AddUserClientUtil.initComboValues(request, userBean);
            Properties customAttribProp = UserMgmtUtil.getCustomAttributes((String)"userCreation");
            if (customAttribProp.size() > 0) {
                String[] customDisplayNames = (String[])customAttribProp.get("customAttribDisplayName");
                String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
                userBean.set("CUSTOM_ATTRIB_DISPLAY_NAME", customDisplayNames);
                userBean.set("CUSTOM_ATTRIB_LDAP_NAME", customLdapNames);
            }
            Criteria crit = null;
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMFormatDefaultSettings", crit);
            if (!obj.isEmpty()) {
                String[] col_names = new String[]{"LOGON_NAME_FORMAT", "SAM_ACCOUNT_NAME_FORMAT", "FULL_NAME_FORMAT", "DISPLAY_NAME_FORMAT", "EMAIL_ADDRESS_FORMAT", "MAIL_ALIAS_FORMAT", "SIMPLE_DISPLAY_NAME_FORMAT", "ME_MAIL_ALIAS_FORMAT", "ME_SIMPLE_DISPLAY_NAME_FORMAT", "TARGET_ADDRESS_FORMAT"};
                Iterator it = obj.getRows("ADSMFormatDefaultSettings");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    for (int i = 0; i < col_names.length; ++i) {
                        UpdateQueryImpl updateQuery = new UpdateQueryImpl("ADSMAUUserCreation");
                        Criteria criteria = new Criteria(new Column("ADSMAUUserCreation", "USER_CREATION_ID"), (Object)userCreationID, 0);
                        DataObject dob = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAUUserCreation", criteria);
                        updateQuery.setCriteria(criteria);
                        updateQuery.setUpdateColumn(col_names[i], (Object)((Long)r.get(col_names[i])));
                        CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void initAttributes(HttpServletRequest request, UserBean userBean, Long templateId, String domainName, ArrayList groupList) {
        String upnSuffix;
        Properties groupProps;
        String mailEnabled;
        Hashtable templateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
        Enumeration enumeration = templateDetails.keys();
        String mailServerDomainName = "";
        boolean isNetworkHomeDirectory = false;
        Object tsHomeDrive = templateDetails.get("TS_HOME_DRIVE");
        if (tsHomeDrive != null) {
            isNetworkHomeDirectory = true;
        }
        if ((mailEnabled = (String)templateDetails.get("mailEnabled")) != null) {
            userBean.set("mailEnabled", mailEnabled);
        }
        while (enumeration.hasMoreElements()) {
            Object value;
            ArrayList list;
            String element = (String)enumeration.nextElement();
            if (element.equalsIgnoreCase("MEMBER_OF")) {
                ArrayList<Properties> arrayList = new ArrayList<Properties>();
                ArrayList list2 = (ArrayList)templateDetails.get(element);
                for (String string : list2) {
                    Properties properties = UserMgmtUtil.getPropertiesfromDN((String)string, (ArrayList)groupList);
                    if (properties == null) continue;
                    arrayList.add(properties);
                }
                userBean.set(element, arrayList);
                continue;
            }
            if (element.equalsIgnoreCase("REJECT_MESSAGES_FROM") || element.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                list = (ArrayList)templateDetails.get(element);
                if (list.isEmpty()) continue;
                ArrayList<String> mRrecipientsDNList = new ArrayList<String>();
                ArrayList<String> mRrecipientsDisplayList = new ArrayList<String>();
                for (Object object : list) {
                    String string = (String)object;
                    mRrecipientsDNList.add(string);
                    mRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                }
                if (mailEnabled.equalsIgnoreCase("MailBox")) {
                    userBean.set("mRrecipientsDNList", mRrecipientsDNList);
                    userBean.set("mRrecipientsDisplayList", mRrecipientsDisplayList);
                    userBean.set("mRrecipientsSelect", mRrecipientsDNList.get(0));
                    userBean.set("meMRrecipientsDNList", new ArrayList());
                    userBean.set("meMRrecipientsDisplayList", new ArrayList());
                    userBean.set("meMRrecipientsSelect", "");
                    if (element.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                        userBean.set("msgRestriction", "fromExcept");
                        userBean.set("meMsgRestriction", "all");
                        continue;
                    }
                    if (element.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                        userBean.set("msgRestriction", "onlyFrom");
                        userBean.set("meMsgRestriction", "all");
                        continue;
                    }
                    userBean.set("msgRestriction", "all");
                    continue;
                }
                if (!mailEnabled.equalsIgnoreCase("Mail")) continue;
                userBean.set("meMRrecipientsDNList", mRrecipientsDNList);
                userBean.set("meMRrecipientsDisplayList", mRrecipientsDisplayList);
                userBean.set("meMRrecipientsSelect", mRrecipientsDNList.get(0));
                userBean.set("mRrecipientsDNList", new ArrayList());
                userBean.set("mRrecipientsDisplayList", new ArrayList());
                userBean.set("mRrecipientsSelect", "");
                if (element.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                    userBean.set("meMsgRestriction", "fromExcept");
                    userBean.set("msgRestriction", "all");
                    continue;
                }
                if (element.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                    userBean.set("meMsgRestriction", "onlyFrom");
                    userBean.set("msgRestriction", "all");
                    continue;
                }
                userBean.set("meMsgRestriction", "all");
                continue;
            }
            if (element.equalsIgnoreCase("SEND_ON_BEHALF")) {
                list = (ArrayList)templateDetails.get(element);
                if (list.isEmpty()) continue;
                ArrayList<String> sobDNList = new ArrayList<String>();
                ArrayList<String> sobDisplayList = new ArrayList<String>();
                for (String string : list) {
                    sobDNList.add(string);
                    sobDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                }
                userBean.set("sobDNList", sobDNList);
                userBean.set("sobDisplayList", sobDisplayList);
                userBean.set("sobSelect", sobDNList.get(0));
                continue;
            }
            if (element.equalsIgnoreCase("PROTOCOL_SETTINGS")) {
                list = (ArrayList)templateDetails.get(element);
                AddUserClientUtil.setProtocolSettings(list, userBean);
                continue;
            }
            if (element.equalsIgnoreCase("EMAIL_PROXY_ADDRESSES")) {
                list = (ArrayList)templateDetails.get(element);
                if (list == null || list.isEmpty()) continue;
                if (mailEnabled.equalsIgnoreCase("mailBox")) {
                    userBean.set("proxyAddress", list);
                    userBean.set("emailProxyAddresses", list.get(0).toString());
                    continue;
                }
                if (!mailEnabled.equalsIgnoreCase("mail")) continue;
                userBean.set("meProxyAddress", list);
                userBean.set("meEmailProxyAddresses", list.get(0).toString());
                continue;
            }
            if (element.equalsIgnoreCase("MAIL_SERVER_DOMAIN_NAME")) {
                mailServerDomainName = (String)templateDetails.get("MAIL_SERVER_DOMAIN_NAME");
                continue;
            }
            if (element.equalsIgnoreCase("PASSWORD_LAST_SET") || element.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") || element.equalsIgnoreCase("KEEP_DELETED_ITEMS") || element.equalsIgnoreCase("TS_END_DISCONNECTION") || element.equalsIgnoreCase("TS_ACTIVE_SESSION") || element.equalsIgnoreCase("TS_IDLE_SESSION")) {
                userBean.set(element, AddUserClientUtil.getLongValue(templateDetails.get(element).toString()));
                continue;
            }
            if (element.equalsIgnoreCase("REQUIRE_AUTH") || element.equalsIgnoreCase("DELIVER_AND_REDIRECT") || element.equalsIgnoreCase("USE_DEFAULT_STORAGE") || element.equalsIgnoreCase("HIDDEN_TO_ADDRESSLISTS") || element.equalsIgnoreCase("ME_HIDDEN_TO_ADDRESSLISTS") || element.equalsIgnoreCase("ME_REQUIRE_AUTH")) {
                userBean.set(element, AddUserClientUtil.getBooleanValue(templateDetails.get(element).toString()));
                continue;
            }
            if (element.equalsIgnoreCase("ACCOUNT_STATUS") || element.equalsIgnoreCase("USER_FLAGS") || element.equalsIgnoreCase("COUNTRY_CODE")) {
                userBean.set(element, AddUserClientUtil.getIntegerValue(element, templateDetails.get(element).toString()));
                continue;
            }
            if (element.equalsIgnoreCase("MS_EXCH_EXCLUDE_POLICIES")) {
                if (templateDetails.get(element) == null || !((String)templateDetails.get(element)).equalsIgnoreCase("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}")) continue;
                if (mailEnabled.equalsIgnoreCase("MailBox")) {
                    userBean.set("INCLUDE_POLICIES", false);
                    continue;
                }
                if (!mailEnabled.equalsIgnoreCase("mail")) continue;
                userBean.set("ME_INCLUDE_POLICIES", false);
                continue;
            }
            if (element.equalsIgnoreCase("TEMPLATE_NAME") || element.equalsIgnoreCase("TEMPLATE_DESCRIPTION") || element.equalsIgnoreCase("TEMPLATE_DOMAIN_NAME") || element.equalsIgnoreCase("ITERATE_NAMES") || element.equalsIgnoreCase("ITERATE_BEGIN_INDEX") || element.equalsIgnoreCase("CUSTOM_SCRIPT") || element.startsWith("LCS") || (value = templateDetails.get(element)) == null) continue;
            userBean.set(element, templateDetails.get(element));
        }
        AddUserClientUtil.initComboValues(request, userBean);
        AddUserClientUtil.setAccountProperties(userBean, domainName);
        AddUserClientUtil.setTSProperties(userBean);
        AddUserClientUtil.setExchangeAttributes(userBean, domainName);
        UserAttributeHandler.setCustomAttributeValues(userBean, templateId);
        String defaultNamingContext = (String)DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(domainName);
        String primaryGroupRID = (String)userBean.get("PRIMARY_GROUP_ID");
        Properties PRIMARY_GROUP = new Properties();
        ArrayList MEMBER_OF = (ArrayList)userBean.get("MEMBER_OF");
        if (primaryGroupRID != null && !primaryGroupRID.equals("")) {
            PRIMARY_GROUP = UserMgmtUtil.getPropertiesfromRID((String)primaryGroupRID, (ArrayList)groupList, (String)defaultNamingContext);
            groupProps = (Properties)PRIMARY_GROUP.clone();
            if (!MEMBER_OF.contains(groupProps)) {
                MEMBER_OF.add(groupProps);
            }
        } else {
            groupProps = UserMgmtUtil.getPropertiesfromRID((String)"513", (ArrayList)groupList, (String)defaultNamingContext);
            MEMBER_OF.add(groupProps);
            PRIMARY_GROUP = (Properties)groupProps.clone();
            userBean.set("PRIMARY_GROUP_ID", "513");
        }
        userBean.set("MEMBER_OF", MEMBER_OF);
        userBean.set("PRIMARY_GROUP", PRIMARY_GROUP);
        String homeDirectory = (String)userBean.get("HOME_DIRECTORY");
        if (homeDirectory != null) {
            if (homeDirectory.startsWith("\\")) {
                userBean.set("homeFolder", "connect");
                userBean.set("networkHomeDirectory", homeDirectory);
                userBean.set("localHomeDirectory", "");
            } else {
                userBean.set("homeFolder", "local");
                userBean.set("HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
                userBean.set("networkHomeDirectory", "");
                userBean.set("localHomeDirectory", homeDirectory);
            }
        }
        if ((upnSuffix = (String)userBean.get("UPN_SUFFIX")) == null || upnSuffix.equals("")) {
            upnSuffix = DomainHandler.getDomainDNSName((String)domainName);
            userBean.set("UPN_SUFFIX", upnSuffix, false);
        }
    }

    public static void initAttributes(HttpServletRequest request, UserBean userBean, Long previousTemplateID, Long templateId, String domainName, ArrayList groupList, Long loginId, ArrayList customAttribList) {
        try {
            String container;
            Properties groupProps;
            String presentTemplatePwdAttribute;
            int i;
            String attribValue;
            String attribValue2;
            String presentLogonName;
            String tsHomeDirectory;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Hashtable toBeSetTemplateDetails = UserTemplateHandler.getTemplateDetails((Long)templateId);
            Hashtable presentTemplateDetails = UserTemplateHandler.getTemplateDetails((Long)previousTemplateID);
            String mailEnabled = "yes";
            ArrayList mailServersList = new ArrayList();
            ArrayList mailBoxStoresList = new ArrayList();
            ArrayList mailServers = new ArrayList();
            ArrayList<String> mailServerDNs = new ArrayList<String>();
            ArrayList<String> mailBoxStores = new ArrayList<String>();
            ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
            mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
            Boolean lcsEnabled = (Boolean)toBeSetTemplateDetails.get("LCS_ENABLED");
            if (lcsEnabled.booleanValue()) {
                userBean.set("LCS_ENABLED", lcsEnabled);
                for (String string : UserTemplateUtil.userTemplateLCSAttributes) {
                    if (string.equalsIgnoreCase("LCS_FEDERATION_ENABLED") || string.equalsIgnoreCase("LCS_INTERNET_ACCESS")) {
                        userBean.set(string, (Boolean)toBeSetTemplateDetails.get(string));
                        continue;
                    }
                    if (string.equalsIgnoreCase("LCS_SERVER")) {
                        userBean.set(string, toBeSetTemplateDetails.get(string));
                        continue;
                    }
                    if (!string.equalsIgnoreCase("LCS_OPTION_FLAG") && !string.equalsIgnoreCase("LCS_ARCHIVE")) continue;
                    userBean.set(string, (Integer)toBeSetTemplateDetails.get(string));
                }
                for (String string : UserTemplateUtil.userTemplateLCSAttributesFormat) {
                    String attribValue3 = (String)toBeSetTemplateDetails.get(string);
                    if (string.equalsIgnoreCase("LCS_SIP_URI_FORMAT")) {
                        if (!attribValue3.equalsIgnoreCase("sip:")) {
                            userBean.set("LCS_SIP_URI", attribValue3);
                        } else {
                            userBean.set("LCS_SIP_URI", (String)toBeSetTemplateDetails.get(string));
                        }
                    }
                    if (string.equalsIgnoreCase("LCS_DEVICE_LINE_URI_FORMAT")) {
                        if (!attribValue3.equalsIgnoreCase("sip:") && !attribValue3.equalsIgnoreCase("tel:")) {
                            userBean.set("LCS_DEVICE_LINE_URI", attribValue3);
                        } else {
                            userBean.set("LCS_DEVICE_LINE_URI", (String)toBeSetTemplateDetails.get(string));
                        }
                    }
                    if (!string.equalsIgnoreCase("LCS_DEVICE_LINE_SERVER_FORMAT")) continue;
                    if (!attribValue3.equalsIgnoreCase("sip:")) {
                        userBean.set("LCS_DEVICE_LINE_SERVER", attribValue3);
                        continue;
                    }
                    userBean.set("LCS_DEVICE_LINE_SERVER", (String)toBeSetTemplateDetails.get(string));
                }
            }
            boolean isNetworkHomeDirectory = false;
            boolean isNetworkTSHomeDirectory = false;
            String homeDirectory = (String)toBeSetTemplateDetails.get("HOME_DIRECTORY");
            if (homeDirectory != null && homeDirectory.startsWith("\\")) {
                isNetworkHomeDirectory = true;
            }
            if ((tsHomeDirectory = (String)toBeSetTemplateDetails.get("TS_HOME_DIRECTORY")) != null && tsHomeDirectory.startsWith("\\")) {
                isNetworkTSHomeDirectory = true;
            }
            if (mailServersList != null && !mailServersList.isEmpty()) {
                mailServers = (ArrayList)mailServersList.get(0);
                mailServerDNs = (ArrayList<String>)mailServersList.get(1);
                mailEnabled = "yes";
            }
            if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                String MAIL_SERVER = (String)userBean.get("MAIL_SERVER");
                if (MAIL_SERVER == null || MAIL_SERVER.equals("0") || MAIL_SERVER.equals("")) {
                    MAIL_SERVER = (String)mailServerDNs.get(0);
                }
                mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)MAIL_SERVER);
            } else {
                mailServers = new ArrayList();
                mailServers.add("No Mail Servers Available");
                mailServerDNs = new ArrayList<String>();
                mailServerDNs.add("0");
                mailEnabled = "no";
            }
            if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                mailBoxStores = (ArrayList<String>)mailBoxStoresList.get(0);
                mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
                mailEnabled = "yes";
            }
            if (mailBoxStores == null | mailBoxStores.isEmpty()) {
                mailBoxStores = new ArrayList<String>();
                mailBoxStores.add("No Mail Box Stores");
                mailBoxStoreDNs = new ArrayList<String>();
                mailBoxStoreDNs.add("0");
                mailEnabled = "no";
            }
            if ((presentLogonName = (String)userBean.get("LOGON_NAME")).indexOf("@") != -1) {
                presentLogonName = presentLogonName.substring(0, presentLogonName.lastIndexOf("@"));
            }
            Long presentLogonNameFormatValue = (Long)presentTemplateDetails.get("LOGON_NAME_FORMAT");
            String presentFormatLogonName = FormatClientUtil.getFormattedName(presentLogonNameFormatValue, userBean, domainName, presentLogonName, customAttribList);
            Long logonNameFormatValue = (Long)toBeSetTemplateDetails.get("LOGON_NAME_FORMAT");
            String formatLogonName = FormatClientUtil.getFormattedName(logonNameFormatValue, userBean, domainName, presentLogonName, customAttribList);
            String logonName = "";
            logonName = presentFormatLogonName.equalsIgnoreCase(presentLogonName) || presentLogonName.equalsIgnoreCase("") ? formatLogonName : presentLogonName;
            userBean.set("LOGON_NAME", logonName);
            for (String string : UserTemplateUtil.namingTableColumns) {
                if (string.equalsIgnoreCase("LOGON_NAME_FORMAT")) continue;
                AddUserClientUtil.setNamingAttribute(string, userBean, presentLogonName, domainName, presentTemplateDetails, toBeSetTemplateDetails, customAttribList);
            }
            userBean.set("DESCRIPTION", AddUserClientUtil.getBeanProperty("DESCRIPTION", "", userBean, presentTemplateDetails, toBeSetTemplateDetails));
            userBean.set("EMPLOYEE_ID", AddUserClientUtil.getBeanProperty("EMPLOYEE_ID", "", userBean, presentTemplateDetails, toBeSetTemplateDetails));
            for (String attribute : UserMgmtUtil.securityPropCheckEmpty) {
                String defaultValue = "";
                if (attribute.equalsIgnoreCase("PASSWORD_LAST_SET")) {
                    defaultValue = "0";
                }
                String attribValue4 = AddUserClientUtil.getBeanProperty(attribute, defaultValue, userBean, presentTemplateDetails, toBeSetTemplateDetails);
                if (attribute.equalsIgnoreCase("PASSWORD_LAST_SET")) {
                    userBean.set(attribute, AddUserClientUtil.getLongValue(attribValue4));
                    continue;
                }
                userBean.set(attribute, attribValue4);
            }
            for (String attribute : UserMgmtUtil.userContactProp) {
                userBean.set(attribute, AddUserClientUtil.getBeanProperty(attribute, "", userBean, presentTemplateDetails, toBeSetTemplateDetails));
            }
            for (String attribute : UserTemplateUtil.userTemplateCountryProp) {
                String attribValue3;
                if (attribute.equals("COUNTRY_CODE")) {
                    String attribValue5 = AddUserClientUtil.getBeanProperty(attribute, "-1", userBean, presentTemplateDetails, toBeSetTemplateDetails);
                    Integer value = 0;
                    if (!attribValue5.equals("")) {
                        value = AddUserClientUtil.getIntegerValue(attribute, attribValue5);
                    }
                    userBean.set(attribute, value);
                    continue;
                }
                if (attribute.equals("COUNRTY_TWO_DIGIT_CODE")) {
                    attribValue3 = AddUserClientUtil.getBeanProperty(attribute, "**", userBean, presentTemplateDetails, toBeSetTemplateDetails);
                    if (attribValue3 != null && attribValue3.equals("")) {
                        attribValue3 = "**";
                    }
                    userBean.set(attribute, attribValue3);
                    continue;
                }
                if (!attribute.equals("COUNTRY")) continue;
                attribValue3 = AddUserClientUtil.getBeanProperty(attribute, rb.getString("admp.mgmt.user_mgmt.cre_single_user.attribvalue_select_country"), userBean, presentTemplateDetails, toBeSetTemplateDetails);
                if (attribValue3 != null && attribValue3.equals("")) {
                    attribValue3 = rb.getString("admp.mgmt.user_mgmt.cre_single_user.attribvalue_select_country");
                }
                userBean.set(attribute, attribValue3);
            }
            for (String attribute : UserMgmtUtil.terminalPropCheckEmpty) {
                userBean.set(attribute, AddUserClientUtil.getBeanProperty(attribute, "", userBean, presentTemplateDetails, toBeSetTemplateDetails));
            }
            for (int i2 = 0; i2 < UserMgmtUtil.securityPropCheckDefault.length; ++i2) {
                String attribute = UserMgmtUtil.securityPropCheckDefault[i2];
                String defaultValue = UserMgmtUtil.securityPropDefaultValues[i2].toString();
                if (!attribute.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
                    String attribValue22 = AddUserClientUtil.getBeanProperty(attribute, defaultValue, userBean, presentTemplateDetails, toBeSetTemplateDetails);
                } else {
                    String accountExpiresStatus = (String)userBean.get("accountExpiresStatus");
                    if (accountExpiresStatus.equals("endOf")) {
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy/MM/dd");
                        Date accountExpiresValue = dateFormat.parse((String)userBean.get("accountExpiresDate"));
                        Date currentDate = new Date();
                        Long days = (accountExpiresValue.getTime() - currentDate.getTime()) / 86400000L;
                        days = days + 1L;
                        userBean.set(attribute, days);
                        Long presentExpiryDate = Long.valueOf(presentTemplateDetails.get("ACCOUNT_EXPIRY_DATE").toString());
                        if (presentExpiryDate != null && presentExpiryDate > 36500L) {
                            Long presentMillis = DateTimeUtil.getSystemTimeFromFileTime((Long)presentExpiryDate);
                            Calendar calendar = Calendar.getInstance();
                            Long millisecound = calendar.getTimeInMillis();
                            Long diff = presentMillis - millisecound;
                            Long l = days = Long.valueOf(diff / 86400000L);
                            Long l2 = days = Long.valueOf(days + 1L);
                            presentTemplateDetails.put("ACCOUNT_EXPIRY_DATE", days.toString());
                        }
                    } else {
                        userBean.set(attribute, null);
                    }
                    attribValue2 = AddUserClientUtil.getBeanProperty(attribute, defaultValue, userBean, presentTemplateDetails, toBeSetTemplateDetails);
                }
                if (attribute.equalsIgnoreCase("PRIMARY_GROUP_ID")) {
                    if (attribValue2.equals("")) {
                        attribValue2 = defaultValue;
                    }
                    userBean.set(attribute, attribValue2);
                    continue;
                }
                if (attribute.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
                    userBean.set(attribute, AddUserClientUtil.getLongValue(attribValue2));
                    continue;
                }
                if (attribute.equalsIgnoreCase("USER_FLAGS") || attribute.equalsIgnoreCase("ACCOUNT_STATUS")) {
                    userBean.set(attribute, AddUserClientUtil.getIntegerValue(attribute, attribValue2));
                    continue;
                }
                userBean.set(attribute, attribValue2);
            }
            for (int i2 = 0; i2 < UserMgmtUtil.terminalPropCheckDefault.length; ++i2) {
                String attribute = UserMgmtUtil.terminalPropCheckDefault[i2];
                String defaultValue = UserMgmtUtil.terminalPropDefaultValues[i2].toString();
                attribValue2 = AddUserClientUtil.getBeanProperty(attribute, defaultValue, userBean, presentTemplateDetails, toBeSetTemplateDetails);
                if (attribute.equalsIgnoreCase("TS_END_DISCONNECTION") || attribute.equalsIgnoreCase("TS_ACTIVE_SESSION") || attribute.equalsIgnoreCase("TS_IDLE_SESSION")) {
                    userBean.set(attribute, AddUserClientUtil.getLongValue(attribValue2));
                    continue;
                }
                userBean.set(attribute, attribValue2);
            }
            String presentEmailName = "";
            String mailFormat = "EMAIL_ADDRESS_FORMAT";
            if (userBean.get("EMAIL_ADDRESS") != null) {
                presentEmailName = (String)userBean.get("EMAIL_ADDRESS");
            }
            if (presentEmailName != null && presentEmailName.indexOf("@") != -1) {
                presentEmailName = presentEmailName.substring(0, presentEmailName.lastIndexOf("@"));
            }
            String mailName = "";
            Long mailFormatValue = (Long)toBeSetTemplateDetails.get("EMAIL_ADDRESS_FORMAT");
            if (!mailFormatValue.equals(-1L)) {
                mailName = AddUserClientUtil.getNamingAttribute(mailFormat, "EMAIL_ADDRESS", presentEmailName, userBean, presentLogonName, domainName, presentTemplateDetails, toBeSetTemplateDetails, customAttribList);
                String mailServerDomainName = (String)toBeSetTemplateDetails.get("MAIL_SERVER_DOMAIN_NAME");
                if (mailServerDomainName == null || mailServerDomainName.equals("")) {
                    mailServerDomainName = DomainHandler.getDomainDNSName((String)domainName);
                }
                mailName = mailName + "@" + mailServerDomainName;
            }
            userBean.set("EMAIL_ADDRESS", mailName);
            String upnSuffix = (String)toBeSetTemplateDetails.get("UPN_SUFFIX");
            if (upnSuffix == null || upnSuffix.equals("")) {
                upnSuffix = DomainHandler.getDomainDNSName((String)domainName);
            }
            userBean.set("UPN_SUFFIX", upnSuffix);
            String templateMailEnabled = (String)toBeSetTemplateDetails.get("mailEnabled");
            if (templateMailEnabled != null && templateMailEnabled.equalsIgnoreCase("MailBox") && mailEnabled.equalsIgnoreCase("yes")) {
                userBean.set("mailEnabled", "mailBox");
                for (String string : UserMgmtUtil.exchangePropCheckEmpty) {
                    if (string.equals("MAIL_ALIAS") || string.equals("SIMPLE_DISPLAY_NAME")) {
                        AddUserClientUtil.setNamingAttribute(string + "_FORMAT", userBean, presentLogonName, domainName, presentTemplateDetails, toBeSetTemplateDetails, customAttribList);
                        continue;
                    }
                    if (string.equals("EMAIL_ADDRESS")) continue;
                    userBean.set(string, AddUserClientUtil.getBeanProperty(string, "", userBean, presentTemplateDetails, toBeSetTemplateDetails));
                }
                for (int i3 = 0; i3 < UserMgmtUtil.exchangePropCheckDefault.length; ++i3) {
                    String attribute = UserMgmtUtil.exchangePropCheckDefault[i3];
                    String defaultValue = UserMgmtUtil.exchangePropDefaultValues[i3].toString();
                    attribValue = AddUserClientUtil.getBeanProperty(attribute, defaultValue, userBean, presentTemplateDetails, toBeSetTemplateDetails);
                    if (attribute.equalsIgnoreCase("REQUIRE_AUTH") || attribute.equalsIgnoreCase("DELIVER_AND_REDIRECT") || attribute.equalsIgnoreCase("USE_DEFAULT_STORAGE") || attribute.equalsIgnoreCase("HIDDEN_TO_ADDRESSLISTS")) {
                        userBean.set(attribute, AddUserClientUtil.getBooleanValue(attribValue));
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("KEEP_DELETED_ITEMS")) {
                        userBean.set(attribute, AddUserClientUtil.getLongValue(attribValue));
                        continue;
                    }
                    userBean.set(attribute, attribValue);
                }
                for (String string : UserMgmtUtil.exchangePropNoCheck) {
                    String attribValue6 = AddUserClientUtil.getBeanProperty(string, "true", userBean, presentTemplateDetails, toBeSetTemplateDetails);
                    userBean.set(string, AddUserClientUtil.getBooleanValue(attribValue6));
                }
                if (mailEnabled.equalsIgnoreCase("yes")) {
                    for (String string : UserMgmtUtil.exchangeServerAttributes) {
                        String toBeSetAttribute = (String)toBeSetTemplateDetails.get(string);
                        if (toBeSetAttribute == null || toBeSetAttribute.equals("")) continue;
                        userBean.set(string, toBeSetAttribute);
                    }
                }
                userBean.set("ME_IN_MESSAGE_SIZE", "");
                for (i = 0; i < UserMgmtUtil.mailEnablePropCheckDefault.length; ++i) {
                    String attribute = UserMgmtUtil.mailEnablePropCheckDefault[i];
                    Object defaultValue = UserMgmtUtil.mailEnablePropDefaultValues[i];
                    userBean.set(attribute, defaultValue);
                }
            } else if (templateMailEnabled != null && templateMailEnabled.equalsIgnoreCase("Mail") && mailEnabled.equalsIgnoreCase("yes")) {
                String toBeSetAttribute;
                userBean.set("mailEnabled", "mail");
                for (String string : UserMgmtUtil.mailEnablePropCheckEmpty) {
                    if (string.equals("ME_MAIL_ALIAS") || string.equals("ME_SIMPLE_DISPLAY_NAME") || string.equals("TARGET_ADDRESS")) {
                        AddUserClientUtil.setNamingAttribute(string + "_FORMAT", userBean, presentLogonName, domainName, presentTemplateDetails, toBeSetTemplateDetails, customAttribList);
                        continue;
                    }
                    if (string.equals("EMAIL_ADDRESS")) continue;
                    userBean.set(string, AddUserClientUtil.getBeanProperty(string, "", userBean, presentTemplateDetails, toBeSetTemplateDetails));
                }
                for (int i4 = 0; i4 < UserMgmtUtil.mailEnablePropCheckDefault.length; ++i4) {
                    String attribute = UserMgmtUtil.mailEnablePropCheckDefault[i4];
                    String defaultValue = UserMgmtUtil.mailEnablePropDefaultValues[i4].toString();
                    attribValue = AddUserClientUtil.getBeanProperty(attribute, defaultValue, userBean, presentTemplateDetails, toBeSetTemplateDetails);
                    userBean.set(attribute, AddUserClientUtil.getBooleanValue(attribValue));
                }
                if (mailEnabled.equalsIgnoreCase("yes") && (toBeSetAttribute = (String)toBeSetTemplateDetails.get("MS_EXCH_ADMIN_GROUP")) != null && !toBeSetAttribute.equals("")) {
                    userBean.set("MS_EXCH_ADMIN_GROUP", toBeSetAttribute);
                }
                for (String string : UserMgmtUtil.exchangePropCheckEmpty) {
                    if (string.equals("MAIL_ALIAS") || string.equals("SIMPLE_DISPLAY_NAME") || string.equals("EMAIL_ADDRESS") || string.equalsIgnoreCase("MS_EXCH_EXCLUDE_POLICIES")) continue;
                    userBean.set(string, "");
                }
                for (i = 0; i < UserMgmtUtil.exchangePropCheckDefault.length; ++i) {
                    String attribute = UserMgmtUtil.exchangePropCheckDefault[i];
                    Object defaultValue = UserMgmtUtil.exchangePropDefaultValues[i];
                    userBean.set(attribute, defaultValue);
                }
                userBean.set("USE_DEFAULT_STORAGE", true);
            } else {
                userBean.set("mailEnabled", "no");
                for (String string : UserMgmtUtil.exchangePropCheckEmpty) {
                    if (string.equals("MAIL_ALIAS") || string.equals("SIMPLE_DISPLAY_NAME") || string.equals("EMAIL_ADDRESS") || string.equalsIgnoreCase("MS_EXCH_EXCLUDE_POLICIES")) continue;
                    userBean.set(string, "");
                }
                for (i = 0; i < UserMgmtUtil.exchangePropCheckDefault.length; ++i) {
                    String attribute = UserMgmtUtil.exchangePropCheckDefault[i];
                    Object defaultValue = UserMgmtUtil.exchangePropDefaultValues[i];
                    userBean.set(attribute, defaultValue);
                }
                userBean.set("USE_DEFAULT_STORAGE", true);
                userBean.set("ME_IN_MESSAGE_SIZE", "");
                for (i = 0; i < UserMgmtUtil.mailEnablePropCheckDefault.length; ++i) {
                    String attribute = UserMgmtUtil.mailEnablePropCheckDefault[i];
                    Object defaultValue = UserMgmtUtil.mailEnablePropDefaultValues[i];
                    userBean.set(attribute, defaultValue);
                }
            }
            String password = "";
            String toBeSetPwdAttribute = (String)toBeSetTemplateDetails.get("PASSWORD_TYPE");
            String passwordType = "sameasusername";
            String presentPwdAttribute = (String)userBean.get("PASSWORD_TYPE");
            if (presentPwdAttribute == null) {
                presentPwdAttribute = "sameasusername";
            }
            passwordType = presentPwdAttribute.equals(presentTemplatePwdAttribute = (String)presentTemplateDetails.get("PASSWORD_TYPE")) ? toBeSetPwdAttribute : presentPwdAttribute;
            userBean.set("PASSWORD_TYPE", passwordType);
            String presentPwd = (String)userBean.get("PASSWORD");
            if (passwordType.equalsIgnoreCase("ownpassword")) {
                if (presentPwd == null || presentPwd.equals("")) {
                    password = (String)toBeSetTemplateDetails.get("PASSWORD");
                } else if (presentPwdAttribute != null) {
                    if (presentPwdAttribute.equals(presentTemplatePwdAttribute) && toBeSetTemplateDetails.get("PASSWORD") != null) {
                        if (presentPwdAttribute.equalsIgnoreCase("generatePassword")) {
                            password = (String)toBeSetTemplateDetails.get("PASSWORD");
                        } else if (presentPwdAttribute.equalsIgnoreCase("sameasusername")) {
                            String userName = (String)userBean.get("SAM_ACCOUNT_NAME");
                            if (userName == null) {
                                userName = (String)userBean.get("SAM_ACCOUNT_NAME");
                            }
                            password = userName.equalsIgnoreCase(presentPwd) ? (String)toBeSetTemplateDetails.get("PASSWORD") : presentPwd;
                        } else {
                            password = (String)toBeSetTemplateDetails.get("PASSWORD");
                        }
                    } else {
                        password = presentPwd;
                    }
                }
            }
            userBean.set("PASSWORD", password);
            mailEnabled = (String)userBean.get("mailEnabled");
            for (String attribute : UserMgmtUtil.multiValuAttribs) {
                String string;
                ArrayList list = (ArrayList)toBeSetTemplateDetails.get(attribute);
                if (attribute.equals("PROTOCOL_SETTINGS")) {
                    if (!mailEnabled.equalsIgnoreCase("MailBox")) continue;
                    AddUserClientUtil.setProtocolSettings(list, userBean);
                    continue;
                }
                if (attribute.equals("EMAIL_PROXY_ADDRESSES")) {
                    if (list == null || list.isEmpty()) continue;
                    if (mailEnabled.equalsIgnoreCase("mailBox")) {
                        userBean.set("proxyAddress", list);
                        userBean.set("emailProxyAddresses", list.get(0).toString());
                        continue;
                    }
                    if (!mailEnabled.equalsIgnoreCase("mail")) continue;
                    userBean.set("meProxyAddress", list);
                    userBean.set("meEmailProxyAddresses", list.get(0).toString());
                    continue;
                }
                if (attribute.equals("MEMBER_OF")) {
                    String presentTemplatePrimaryGroupRID;
                    Properties presentTemplatePrimaryGroup;
                    Properties properties;
                    ArrayList membersList = null;
                    membersList = (ArrayList)userBean.get("MEMBER_OF");
                    if (membersList == null) {
                        new ArrayList();
                    }
                    ArrayList propList = new ArrayList();
                    if (membersList.size() > 1) {
                        ArrayList presentTemplateMembers = (ArrayList)presentTemplateDetails.get(attribute);
                        if (presentTemplateMembers == null) {
                            presentTemplateMembers = new ArrayList();
                        }
                        ArrayList<Properties> toBeRemovedMembers = new ArrayList<Properties>();
                        for (Object e : presentTemplateMembers) {
                            properties = UserMgmtUtil.getPropertiesfromDN((String)((String)e), (ArrayList)groupList);
                            if (properties == null) continue;
                            toBeRemovedMembers.add(properties);
                        }
                        for (Object e : toBeRemovedMembers) {
                            membersList.remove(e);
                        }
                        for (Object e : membersList) {
                            if (propList.contains(e)) continue;
                            propList.add(e);
                        }
                    }
                    if ((presentTemplatePrimaryGroup = UserMgmtUtil.getPropertiesfromRID((String)(presentTemplatePrimaryGroupRID = (String)presentTemplateDetails.get("PRIMARY_GROUP_ID")), (ArrayList)groupList, (String)domainName)) != null) {
                        propList.remove(presentTemplatePrimaryGroup);
                    }
                    for (Object e : list) {
                        properties = UserMgmtUtil.getPropertiesfromDN((String)((String)e), (ArrayList)groupList);
                        if (properties == null || propList.contains(properties)) continue;
                        propList.add(properties);
                    }
                    userBean.set(attribute, propList);
                    continue;
                }
                if (attribute.equalsIgnoreCase("REJECT_MESSAGES_FROM") || attribute.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                    if (list.isEmpty()) continue;
                    ArrayList<String> mRrecipientsDNList = new ArrayList<String>();
                    ArrayList<String> mRrecipientsDisplayList = new ArrayList<String>();
                    for (Object object : list) {
                        string = (String)object;
                        mRrecipientsDNList.add(string);
                        mRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                    }
                    if (mailEnabled.equalsIgnoreCase("MailBox")) {
                        userBean.set("mRrecipientsDNList", mRrecipientsDNList);
                        userBean.set("mRrecipientsDisplayList", mRrecipientsDisplayList);
                        userBean.set("mRrecipientsSelect", mRrecipientsDNList.get(0));
                        userBean.set("meMRrecipientsDNList", new ArrayList());
                        userBean.set("meMRrecipientsDisplayList", new ArrayList());
                        userBean.set("meMRrecipientsSelect", "");
                        if (attribute.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                            userBean.set("msgRestriction", "fromExcept");
                            userBean.set("meMsgRestriction", "all");
                            continue;
                        }
                        if (attribute.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                            userBean.set("msgRestriction", "onlyFrom");
                            userBean.set("meMsgRestriction", "all");
                            continue;
                        }
                        userBean.set("msgRestriction", "all");
                        continue;
                    }
                    if (!mailEnabled.equalsIgnoreCase("Mail")) continue;
                    userBean.set("meMRrecipientsDNList", mRrecipientsDNList);
                    userBean.set("meMRrecipientsDisplayList", mRrecipientsDisplayList);
                    userBean.set("meMRrecipientsSelect", mRrecipientsDNList.get(0));
                    userBean.set("mRrecipientsDNList", new ArrayList());
                    userBean.set("mRrecipientsDisplayList", new ArrayList());
                    userBean.set("mRrecipientsSelect", "");
                    if (attribute.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                        userBean.set("meMsgRestriction", "fromExcept");
                        userBean.set("msgRestriction", "all");
                        continue;
                    }
                    if (attribute.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                        userBean.set("meMsgRestriction", "onlyFrom");
                        userBean.set("msgRestriction", "all");
                        continue;
                    }
                    userBean.set("meMsgRestriction", "all");
                    continue;
                }
                if (!attribute.equalsIgnoreCase("SEND_ON_BEHALF") || list.isEmpty()) continue;
                ArrayList<String> sobDNList = new ArrayList<String>();
                ArrayList<String> sobDisplayList = new ArrayList<String>();
                for (Object object : list) {
                    string = (String)object;
                    sobDNList.add(string);
                    sobDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                }
                userBean.set("sobDNList", sobDNList);
                userBean.set("sobDisplayList", sobDisplayList);
                userBean.set("sobSelect", sobDNList.get(0));
            }
            String primaryGroupRID = (String)userBean.get("PRIMARY_GROUP_ID");
            Properties NEW_PRIMARY_GROUP = new Properties();
            String defaultNamingContext = (String)DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(domainName);
            ArrayList NEW_MEMBER_OF = (ArrayList)userBean.get("MEMBER_OF");
            if (primaryGroupRID != null && !primaryGroupRID.equals("")) {
                NEW_PRIMARY_GROUP = UserMgmtUtil.getPropertiesfromRID((String)primaryGroupRID, (ArrayList)groupList, (String)defaultNamingContext);
                if (NEW_PRIMARY_GROUP == null) {
                    NEW_PRIMARY_GROUP = UserMgmtUtil.getPropertiesfromRID((String)"513", (ArrayList)groupList, (String)defaultNamingContext);
                }
                if (!NEW_MEMBER_OF.contains(groupProps = (Properties)NEW_PRIMARY_GROUP.clone())) {
                    NEW_MEMBER_OF.add(groupProps);
                }
            } else {
                if (groupList == null || groupList.isEmpty()) {
                    GroupHandler.init((String)domainName, (String)DomainUtil.getDefaultNamingContext((String)domainName), (Integer)109);
                    groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)DomainUtil.getDefaultNamingContext((String)domainName));
                }
                groupProps = UserMgmtUtil.getPropertiesfromRID((String)"513", (ArrayList)groupList, (String)defaultNamingContext);
                NEW_MEMBER_OF.add(groupProps);
                NEW_PRIMARY_GROUP = (Properties)groupProps.clone();
                userBean.set("PRIMARY_GROUP_ID", "513");
            }
            userBean.set("MEMBER_OF", NEW_MEMBER_OF);
            userBean.set("PRIMARY_GROUP", NEW_PRIMARY_GROUP);
            if (isNetworkHomeDirectory) {
                userBean.set("homeFolder", "connect");
                userBean.set("networkHomeDirectory", homeDirectory);
                userBean.set("localHomeDirectory", "");
                String homeDrive = (String)toBeSetTemplateDetails.get("HOME_DRIVE");
                if (homeDrive != null) {
                    userBean.set("HOME_DRIVE", homeDrive);
                }
            } else {
                userBean.set("homeFolder", "local");
                userBean.set("HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
                userBean.set("networkHomeDirectory", "");
                userBean.set("localHomeDirectory", homeDirectory);
            }
            AddUserClientUtil.initComboValues(request, userBean);
            AddUserClientUtil.setAccountProperties(userBean, domainName);
            AddUserClientUtil.setTSProperties(userBean);
            AddUserClientUtil.setExchangeAttributes(userBean, domainName);
            UserAttributeHandler.setCustomAttributeValues(userBean, templateId);
            String excludePolicies = (String)userBean.get("MS_EXCH_EXCLUDE_POLICIES");
            if (excludePolicies != null && excludePolicies.equalsIgnoreCase("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}")) {
                if (mailEnabled.equalsIgnoreCase("mailBox")) {
                    userBean.set("INCLUDE_POLICIES", false);
                } else if (mailEnabled.equalsIgnoreCase("mail")) {
                    userBean.set("ME_INCLUDE_POLICIES", false);
                }
            }
            if ((container = (String)toBeSetTemplateDetails.get("container")) != null && !container.equals("")) {
                boolean setContainer = false;
                ArrayList ouList = HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
                if (ouList == null) {
                    setContainer = true;
                } else if (ouList.isEmpty()) {
                    setContainer = true;
                } else {
                    for (Object object : ouList) {
                        String string = (String)object;
                        if (!container.equalsIgnoreCase(string) && !container.endsWith(string)) continue;
                        setContainer = true;
                    }
                }
                if (setContainer) {
                    userBean.set("container", container);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addorUpdateUserAttributeDetails(UserBean userBean, HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            Long userCreationID = (Long)session.getAttribute("userCreationID");
            String domainName = (String)session.getAttribute("userCreationDomain");
            ArrayList<Hashtable> attributeList = (ArrayList<Hashtable>)session.getAttribute("attributeList");
            ArrayList<String> toBeAddedAttributes = new ArrayList<String>();
            boolean update = false;
            String userIndex = request.getParameter("userIndex");
            if (userIndex != null && !userIndex.equals("")) {
                update = true;
            }
            AddUserClientUtil.setTobeAddedAttributes(userBean, toBeAddedAttributes, request, update);
            if (attributeList == null || attributeList.isEmpty()) {
                attributeList = new ArrayList<Hashtable>();
            }
            for (String string : toBeAddedAttributes) {
                Hashtable attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_COLUMN_NAME", (Object)string);
                if (attributeList.contains(attributesdetails)) continue;
                attributeList.add(attributesdetails);
            }
            session.setAttribute("attributeList", attributeList);
            Hashtable<String, Object> userDetailsTable = new Hashtable<String, Object>();
            for (String string : toBeAddedAttributes) {
                userDetailsTable.put(string, userBean.get(string));
            }
            String[] ldapNamesArray = request.getParameterValues("ldapName");
            String[] ldapValuesArray = request.getParameterValues("ldapValue");
            ArrayList<Properties> customAttribsList = new ArrayList<Properties>();
            Properties customAttribProp = UserMgmtUtil.getCustomAttributes((String)"userCreation");
            if (customAttribProp.size() > 0) {
                String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
                for (int i = 0; i < customLdapNames.length; ++i) {
                    String customLdapValue = request.getParameter(customLdapNames[i]);
                    if (customLdapValue == null || customLdapValue.equals("")) continue;
                    Properties properties = new Properties();
                    properties.setProperty("CUSTOM_ATTRIB_NAME", customLdapNames[i]);
                    properties.setProperty("CUSTOM_ATTRIB_VALUE", customLdapValue);
                    customAttribsList.add(properties);
                }
            }
            if (ldapNamesArray != null) {
                for (int i = 0; i < ldapNamesArray.length; ++i) {
                    if (ldapNamesArray[i].equalsIgnoreCase("") || ldapValuesArray[i].equalsIgnoreCase("")) continue;
                    Properties properties = new Properties();
                    properties.setProperty("CUSTOM_ATTRIB_NAME", ldapNamesArray[i]);
                    properties.setProperty("CUSTOM_ATTRIB_VALUE", ldapValuesArray[i]);
                    customAttribsList.add(properties);
                }
            }
            if (userIndex != null && !userIndex.equals("")) {
                AddUserHandler.getInstance().updateUserDetails(userCreationID, userDetailsTable, attributeList, customAttribsList, Long.valueOf(Long.parseLong(userIndex)));
            } else {
                AddUserHandler.getInstance().addUserDetails(userCreationID, userDetailsTable, attributeList, customAttribsList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void modifyUserAttributeDetails(UserBean userBean, long userIndex, HttpServletRequest request, String domainName) throws Exception {
        try {
            userBean.setCheckPrivilege(false);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
            Hashtable userDetails = AddUserHandler.getInstance().getUserDetails(Long.valueOf(userIndex), attributeList);
            Properties domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
            ArrayList groupList = (ArrayList)session.getAttribute("userCreationGroupList");
            if (groupList == null || groupList.isEmpty()) {
                GroupHandler.init((String)domainName, (String)domainProps.getProperty("DEFAULT_NAMING_CONTEXT"), (Integer)109);
                groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)domainProps.getProperty("DEFAULT_NAMING_CONTEXT"));
                session.setAttribute("userCreationGroupList", (Object)groupList);
            }
            String domainDNSName = domainProps.getProperty("DOMAIN_DNS_NAME");
            ArrayList userValues = (ArrayList)userDetails.get("USER_VALUES");
            String mailEnabled = "no";
            String mailNickName = null;
            String targetAddress = null;
            String homeMDB = null;
            for (Hashtable hashtable : userValues) {
                String attributeName = (String)hashtable.get("ATTRIB_COLUMN_NAME");
                if (attributeName.equals("MAIL_ALIAS") || attributeName.equals("ME_MAIL_ALIAS")) {
                    mailNickName = (String)hashtable.get("ATTRIB_VALUE");
                    continue;
                }
                if (attributeName.equals("TARGET_ADDRESS")) {
                    targetAddress = (String)hashtable.get("ATTRIB_VALUE");
                    continue;
                }
                if (!attributeName.equals("MAIL_BOX_STORE")) continue;
                homeMDB = (String)hashtable.get("ATTRIB_VALUE");
            }
            if (mailNickName != null && targetAddress != null) {
                mailEnabled = "mail";
            } else if (mailNickName != null && homeMDB != null) {
                mailEnabled = "mailBox";
            }
            userBean.set("mailEnabled", mailEnabled);
            for (Hashtable hashtable : userValues) {
                Integer relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                String attributeName = (String)hashtable.get("ATTRIB_COLUMN_NAME");
                if (relationalType.equals(1)) {
                    ArrayList list = (ArrayList)hashtable.get("ATTRIB_VALUE");
                    UserAttributeHandler.modifyMultipleValuedAttributes(userBean, domainName, loginId, attributeName, list, groupList, mailEnabled);
                    continue;
                }
                Object object = hashtable.get("ATTRIB_VALUE");
                if (object == null) continue;
                UserAttributeHandler.modifySingleValuedAttributes(userBean, domainName, attributeName, object, mailEnabled);
            }
            UserAttributeHandler.modifyGeneralValuedAttributes(request, userBean, domainName, loginId, domainProps, groupList);
            ArrayList customAttribsList = AddUserHandler.getInstance().getCustomAttributes(Long.valueOf(userIndex));
            AddUserClientUtil.setCustomAttributes(userBean, customAttribsList);
            ArrayList mailServersList = new ArrayList();
            ArrayList mailBoxStoresList = new ArrayList();
            ArrayList mailServers = new ArrayList();
            ArrayList mailServerDNs = new ArrayList();
            ArrayList mailBoxStores = new ArrayList();
            ArrayList mailBoxStoreDNs = new ArrayList();
            mailServers = (ArrayList)session.getAttribute("mailServers");
            mailServerDNs = (ArrayList)session.getAttribute("mailServerDNs");
            String MAIL_SERVER = (String)userBean.get("MAIL_SERVER");
            if (MAIL_SERVER.equals("0") || MAIL_SERVER.equals("")) {
                MAIL_SERVER = (String)mailServerDNs.get(0);
            }
            if (MAIL_SERVER.equals("0")) {
                mailBoxStores = new ArrayList();
                mailBoxStores.add("No Mail Box Stores");
                mailBoxStoreDNs = new ArrayList();
                mailBoxStoreDNs.add("0");
            } else {
                mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)MAIL_SERVER);
                if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                    mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
                    mailBoxStoreDNs = (ArrayList)mailBoxStoresList.get(1);
                } else {
                    mailBoxStores = new ArrayList();
                    mailBoxStores.add("No Mail Box Stores");
                    mailBoxStoreDNs = new ArrayList();
                    mailBoxStoreDNs.add("0");
                }
            }
            userBean.set("mailServers", mailServers);
            userBean.set("mailServerDNs", mailServerDNs);
            String MAIL_BOX_STORE = (String)mailBoxStoreDNs.get(0);
            userBean.set("mailBoxStores", mailBoxStores);
            userBean.set("mailBoxStoreDNs", mailBoxStoreDNs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long copyUserAttributeDetails(UserBean userBean, long userIndex, HttpServletRequest request) {
        HttpSession session = request.getSession();
        ArrayList attributeList = (ArrayList)session.getAttribute("attributeList");
        Long userCreationID = (Long)session.getAttribute("userCreationID");
        Long copyIndex = AddUserHandler.getInstance().copyUserDetails(userCreationID, Long.valueOf(userIndex), attributeList);
        return copyIndex;
    }

    public static void modifyMultipleValuedAttributes(UserBean bean, String domainName, Long loginId, String column, ArrayList<String> valueList, ArrayList groupList, String mailEnabled) {
        try {
            ArrayList<Properties> arrayList = new ArrayList<Properties>();
            if (valueList != null && !valueList.isEmpty()) {
                if (column.equalsIgnoreCase("MEMBER_OF")) {
                    for (String str : valueList) {
                        Properties prop = UserMgmtUtil.getPropertiesfromDN((String)str, (ArrayList)groupList);
                        if (prop == null) continue;
                        arrayList.add(prop);
                    }
                    bean.set(column, arrayList);
                } else if (column.equalsIgnoreCase("REJECT_MESSAGES_FROM") || column.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                    ArrayList<Properties> list = new ArrayList<Properties>();
                    if (!valueList.isEmpty()) {
                        ArrayList<String> mRrecipientsDNList = new ArrayList<String>();
                        ArrayList<String> mRrecipientsDisplayList = new ArrayList<String>();
                        Iterator<String> i$ = valueList.iterator();
                        while (i$.hasNext()) {
                            String object;
                            String string = object = i$.next();
                            mRrecipientsDNList.add(string);
                            mRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                            Properties properties = new Properties();
                            properties.setProperty("Distinguished_Name", string);
                            list.add(properties);
                        }
                        if (mailEnabled.equalsIgnoreCase("MailBox")) {
                            bean.set("mRrecipientsDNList", mRrecipientsDNList);
                            bean.set("mRrecipientsDisplayList", mRrecipientsDisplayList);
                            bean.set("mRrecipientsSelect", mRrecipientsDNList.get(0));
                            bean.set("meMRrecipientsDNList", new ArrayList());
                            bean.set("meMRrecipientsDisplayList", new ArrayList());
                            bean.set("meMRrecipientsSelect", "");
                            if (column.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                                bean.set("msgRestriction", "fromExcept");
                                bean.set("meMsgRestriction", "all");
                            } else if (column.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                                bean.set("msgRestriction", "onlyFrom");
                                bean.set("meMsgRestriction", "all");
                            } else {
                                bean.set("msgRestriction", "all");
                            }
                        } else if (mailEnabled.equalsIgnoreCase("Mail")) {
                            bean.set("meMRrecipientsDNList", mRrecipientsDNList);
                            bean.set("meMRrecipientsDisplayList", mRrecipientsDisplayList);
                            bean.set("meMRrecipientsSelect", mRrecipientsDNList.get(0));
                            bean.set("mRrecipientsDNList", new ArrayList());
                            bean.set("mRrecipientsDisplayList", new ArrayList());
                            bean.set("mRrecipientsSelect", "");
                            if (column.equalsIgnoreCase("REJECT_MESSAGES_FROM")) {
                                bean.set("meMsgRestriction", "fromExcept");
                                bean.set("msgRestriction", "all");
                            } else if (column.equalsIgnoreCase("ACCEPT_MESSAGES_FROM")) {
                                bean.set("meMsgRestriction", "onlyFrom");
                                bean.set("msgRestriction", "all");
                            } else {
                                bean.set("meMsgRestriction", "all");
                            }
                        }
                        bean.set(column, list);
                    }
                } else if (column.equalsIgnoreCase("SEND_ON_BEHALF")) {
                    ArrayList<Properties> list = new ArrayList<Properties>();
                    if (!valueList.isEmpty()) {
                        ArrayList<String> sobDNList = new ArrayList<String>();
                        ArrayList<String> sobDisplayList = new ArrayList<String>();
                        for (String string : valueList) {
                            sobDNList.add(string);
                            sobDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)string));
                            Properties properties = new Properties();
                            properties.setProperty("Distinguished_Name", string);
                            list.add(properties);
                        }
                        bean.set("sobDNList", sobDNList);
                        bean.set("sobDisplayList", sobDisplayList);
                        bean.set("sobSelect", sobDNList.get(0));
                    }
                    bean.set(column, list);
                } else if (column.equalsIgnoreCase("PROTOCOL_SETTINGS")) {
                    AddUserClientUtil.setProtocolSettings(valueList, bean);
                } else if (column.equalsIgnoreCase("EMAIL_PROXY_ADDRESSES")) {
                    ArrayList<String> resultList = new ArrayList<String>();
                    for (String string : valueList) {
                        resultList.add(string);
                    }
                    if (!resultList.isEmpty()) {
                        if (mailEnabled.equalsIgnoreCase("MailBox")) {
                            bean.set("proxyAddress", resultList);
                            bean.set("emailProxyAddresses", resultList.get(0));
                        } else if (mailEnabled.equalsIgnoreCase("Mail")) {
                            bean.set("meProxyAddress", resultList);
                            bean.set("meEmailProxyAddresses", resultList.get(0));
                        }
                    }
                    bean.set(column, resultList);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void modifySingleValuedAttributes(UserBean bean, String domainName, String column, Object value, String mailEnabled) {
        if (column.equalsIgnoreCase("PASSWORD_LAST_SET") || column.equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") || column.equalsIgnoreCase("KEEP_DELETED_ITEMS") || column.equalsIgnoreCase("TS_END_DISCONNECTION") || column.equalsIgnoreCase("TS_ACTIVE_SESSION") || column.equalsIgnoreCase("TS_IDLE_SESSION")) {
            value = AddUserClientUtil.getLongValue(value.toString());
        } else if (column.equalsIgnoreCase("COUNTRY_CODE") || column.equalsIgnoreCase("ACCOUNT_STATUS") || column.equalsIgnoreCase("USER_FLAGS")) {
            value = AddUserClientUtil.getIntegerValue(column, value.toString());
        } else if (column.equalsIgnoreCase("ME_REQUIRE_AUTH") || column.equalsIgnoreCase("ME_HIDDEN_TO_ADDRESSLISTS") || column.equalsIgnoreCase("HIDDEN_TO_ADDRESSLISTS") || column.equalsIgnoreCase("USE_DEFAULT_STORAGE") || column.equalsIgnoreCase("DELIVER_AND_REDIRECT") || column.equalsIgnoreCase("REQUIRE_AUTH") || column.equalsIgnoreCase("LCS_ENABLED") || column.equalsIgnoreCase("LCS_INTERNET_ACCESS") || column.equalsIgnoreCase("LCS_FEDERATION_ENABLED")) {
            value = AddUserClientUtil.getBooleanValue(value.toString());
        } else if (column.equalsIgnoreCase("MS_EXCH_EXCLUDE_POLICIES")) {
            if (value != null && ((String)value).equalsIgnoreCase("{26491CFC-9E50-4857-861B-0CB8DF22B5D7}")) {
                if (mailEnabled.equalsIgnoreCase("MailBox")) {
                    bean.set("INCLUDE_POLICIES", false);
                } else if (mailEnabled.equalsIgnoreCase("mail")) {
                    bean.set("ME_INCLUDE_POLICIES", false);
                }
            }
        } else if (column.equalsIgnoreCase("LCS_OPTION_FLAG") || column.equalsIgnoreCase("LCS_ARCHIVE")) {
            value = AddUserClientUtil.getIntegerValue(column, value.toString());
        }
        bean.set(column, value);
    }

    public static void modifyGeneralValuedAttributes(HttpServletRequest request, UserBean bean, String domainName, Long loginId, Properties domainProps, ArrayList groupList) {
        try {
            Properties groupProps;
            String LOGON_NAME = (String)bean.get("LOGON_NAME");
            String upnPrefix = "";
            String upnSuffix = "";
            int dnsNameIndex = LOGON_NAME.lastIndexOf("@");
            if (dnsNameIndex > 0) {
                upnPrefix = LOGON_NAME.substring(0, dnsNameIndex);
                upnSuffix = LOGON_NAME.substring(dnsNameIndex + 1);
            } else {
                upnPrefix = LOGON_NAME;
                upnSuffix = domainProps.getProperty("DOMAIN_DNS_NAME");
            }
            bean.set("LOGON_NAME", upnPrefix);
            bean.set("UPN_SUFFIX", upnSuffix);
            String primaryGroupRID = (String)bean.get("PRIMARY_GROUP_ID");
            Properties PRIMARY_GROUP = new Properties();
            ArrayList MEMBER_OF = (ArrayList)bean.get("MEMBER_OF");
            String defaultNamingContext = (String)DomainInfoCache.getInstance().getDomainVsDefaultNamingContext().get(domainName);
            if (primaryGroupRID != null && !primaryGroupRID.equals("")) {
                PRIMARY_GROUP = UserMgmtUtil.getPropertiesfromRID((String)primaryGroupRID, (ArrayList)groupList, (String)defaultNamingContext);
                groupProps = (Properties)PRIMARY_GROUP.clone();
                MEMBER_OF.add(groupProps);
            } else {
                groupProps = UserMgmtUtil.getPropertiesfromRID((String)"513", (ArrayList)groupList, (String)defaultNamingContext);
                MEMBER_OF.add(groupProps);
                PRIMARY_GROUP = (Properties)groupProps.clone();
                bean.set("PRIMARY_GROUP_ID", "513");
            }
            bean.set("MEMBER_OF", MEMBER_OF);
            bean.set("PRIMARY_GROUP", PRIMARY_GROUP);
            if (!((String)bean.get("HOME_DRIVE")).equals("")) {
                bean.set("homeFolder", "connect");
                bean.set("networkHomeDirectory", (String)bean.get("HOME_DIRECTORY"));
            } else {
                bean.set("HOME_DRIVE", UserMgmtUtil.homeDriveList.get(UserMgmtUtil.homeDriveList.size() - 1));
                bean.set("localHomeDirectory", (String)bean.get("HOME_DIRECTORY"));
            }
            AddUserClientUtil.setAccountProperties(bean, domainName);
            AddUserClientUtil.initComboValues(request, bean);
            AddUserClientUtil.setTSProperties(bean);
            AddUserClientUtil.setExchangeAttributes(bean, domainName);
            ArrayList mailGroupsList = new ArrayList();
            ArrayList<String> msExchAdminGroupDisplayList = new ArrayList<String>();
            ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
            mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName);
            if (!mailGroupsList.isEmpty()) {
                msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
                msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
                if (msExchAdminGroupDNList.isEmpty()) {
                    msExchAdminGroupDisplayList = new ArrayList<String>();
                    msExchAdminGroupDisplayList.add("No Exchange Administrative Groups Available");
                    msExchAdminGroupDNList = new ArrayList<String>();
                    msExchAdminGroupDNList.add("0");
                }
            }
            bean.set("msExchAdminGroupDisplayList", msExchAdminGroupDisplayList);
            bean.set("msExchAdminGroupDNList", msExchAdminGroupDNList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setCustomAttributeValues(UserBean userBean, Long templateId) {
        ArrayList arrayList = UserTemplateHandler.getCustomAttributes((Long)templateId);
        Properties customAttribProp = UserMgmtUtil.getCustomAttributes((String)"userCreation");
        ArrayList<String> configuredLdapNameList = new ArrayList<String>();
        if (customAttribProp.size() > 0) {
            String[] customLdapNames;
            for (String ldapName : customLdapNames = (String[])customAttribProp.get("customAttribLDAPName")) {
                configuredLdapNameList.add(ldapName);
            }
        }
        if (!arrayList.isEmpty()) {
            ArrayList<String> additionalLdapNamesList = new ArrayList<String>();
            ArrayList<String> additionalLdapValuesList = new ArrayList<String>();
            for (Properties properties : arrayList) {
                String ldapNameStr = properties.getProperty("CUSTOM_ATTRIB_NAME");
                String ldapValueStr = properties.getProperty("CUSTOM_ATTRIB_VALUE");
                if (configuredLdapNameList.contains(ldapNameStr)) continue;
                additionalLdapNamesList.add(ldapNameStr);
                additionalLdapValuesList.add(ldapValueStr);
            }
            String[] additionalLdapNamesArray = new String[additionalLdapNamesList.size()];
            additionalLdapNamesList.toArray(additionalLdapNamesArray);
            String[] additionalLdapValuesArray = new String[additionalLdapValuesList.size()];
            additionalLdapValuesList.toArray(additionalLdapValuesArray);
            userBean.set("CUSTOM_ATTRIB_NAME", additionalLdapNamesArray);
            userBean.set("CUSTOM_ATTRIB_VALUE", additionalLdapValuesArray);
        }
        if (customAttribProp.size() > 0) {
            String[] customDisplayNames = (String[])customAttribProp.get("customAttribDisplayName");
            String[] customLdapNames = (String[])customAttribProp.get("customAttribLDAPName");
            ArrayList<String> configuredDisplayNamesList = new ArrayList<String>();
            ArrayList<String> configuredLdapNamesList = new ArrayList<String>();
            ArrayList<String> configuredLdapValuesList = new ArrayList<String>();
            for (int i = 0; i < customLdapNames.length; ++i) {
                String ldapValuesStr = "";
                for (Properties properties : arrayList) {
                    String ldapNameStr = properties.getProperty("CUSTOM_ATTRIB_NAME");
                    if (!customLdapNames[i].equals(ldapNameStr)) continue;
                    ldapValuesStr = properties.getProperty("CUSTOM_ATTRIB_VALUE");
                }
                configuredDisplayNamesList.add(customDisplayNames[i]);
                configuredLdapNamesList.add(customLdapNames[i]);
                configuredLdapValuesList.add(ldapValuesStr);
            }
            String[] configuredDisplayNamesArray = new String[configuredDisplayNamesList.size()];
            configuredDisplayNamesList.toArray(configuredDisplayNamesArray);
            String[] configuredLdapNamesArray = new String[configuredLdapNamesList.size()];
            configuredLdapNamesList.toArray(configuredLdapNamesArray);
            String[] configuredLdapValuesArray = new String[configuredLdapValuesList.size()];
            configuredLdapValuesList.toArray(configuredLdapValuesArray);
            userBean.set("CUSTOM_ATTRIB_DISPLAY_NAME", configuredDisplayNamesArray);
            userBean.set("CUSTOM_ATTRIB_LDAP_NAME", configuredLdapNamesArray);
            userBean.set("CUSTOM_ATTRIB_LDAP_VALUE", configuredLdapValuesArray);
        }
    }
}

