/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.usermanagement;

import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.admin.PasswordPolicy;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.security.PasswordGenerator;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.ApplyTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserTemplateUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.AddUserListener;
import com.adventnet.sym.adsm.common.webclient.usermanagement.CreateSingleUser;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ExtendedAttributesUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.UserAttributeHandler;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.DynaClass;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.validator.DynaValidatorForm;

public class UserBean
extends DynaValidatorForm {
    Logger out = Logger.getLogger("ADMangLogger");
    private AddUserListener addUserListener = null;
    private boolean privilege = true;
    private Long[] ids = null;
    private String privilegeId = "";
    private ArrayList idslist = new ArrayList();

    public UserBean getClone(UserBean bean) {
        UserBean b = null;
        try {
            b = (UserBean)((Object)BeanUtils.cloneBean((Object)((Object)bean)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return b;
    }

    public AddUserListener getListener() {
        return this.addUserListener;
    }

    public void setListener(AddUserListener addUserListener) {
        this.addUserListener = addUserListener;
    }

    public void reset(ActionMapping mapping, HttpServletRequest request) {
        String type;
        String[] string = new String[]{"tsAllowLogOn", "tsInheritInitial", "tsDcDrives", "tsDcPrinters", "tsDcDedaultPrinter", "REQUIRE_AUTH", "DELIVER_AND_REDIRECT", "USE_DEFAULT_STORAGE", "HIDDEN_TO_ADDRESSLISTS", "header", "ME_REQUIRE_AUTH", "ME_HIDDEN_TO_ADDRESSLISTS", "ITERATE_NAMES", "INCLUDE_POLICIES", "ME_INCLUDE_POLICIES", "IS_HOME_DIR_SHARED", "TS_IS_HOME_DIR_SHARED", "CUSTOM_SCRIPT"};
        String[] lcsString = new String[]{"LCS_ENABLED", "LCS_REMOTE_CONTROL", "LCS_FEDERATION_ENABLED", "LCS_IM_ENABLED", "LCS_INTERNET_ACCESS"};
        DynaClass dynaClass = this.getDynaClass();
        String beanName = dynaClass.getName();
        Map map = this.getMap();
        for (String string2 : string) {
            if (!map.containsKey(string2)) continue;
            if (beanName.equalsIgnoreCase("UserTemplateBean")) {
                map.put(string2, false);
                continue;
            }
            this.set(string2, false, true);
        }
        String methodToCall = request.getParameter("methodToCall");
        if (methodToCall != null && methodToCall.equalsIgnoreCase("savePermissions") && (type = request.getParameter("type")) != null) {
            for (int i = 0; i < UserMgmtUtil.permTypes.length; ++i) {
                if (!UserMgmtUtil.permTypes[i].equalsIgnoreCase(type)) continue;
                for (String s : UserMgmtUtil.permsCheckBoxes[i]) {
                    if (!map.containsKey(s)) continue;
                    map.put(s, false);
                }
            }
        }
        if (methodToCall != null && methodToCall.equalsIgnoreCase("createUser")) {
            String action = request.getParameter("action");
            if (action != null && !action.equalsIgnoreCase("create")) {
                for (String string2 : lcsString) {
                    if (!map.containsKey(string2)) continue;
                    map.put(string2, false);
                }
            }
        } else {
            for (String string2 : lcsString) {
                if (!map.containsKey(string2)) continue;
                if (beanName.equalsIgnoreCase("UserTemplateBean")) {
                    map.put(string2, false);
                    continue;
                }
                if (beanName.equalsIgnoreCase("UserBean")) continue;
                this.set(string2, false, true);
            }
        }
        super.reset(mapping, request);
    }

    public void init(HttpServletRequest request, Properties domainProperties) {
        this.init(request, domainProperties, false);
    }

    public void init(HttpServletRequest request, Properties domainProperties, boolean isWorkflowMode) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.set("browse", null, false);
        HttpSession session = request.getSession();
        String sessionID = session.getId();
        this.out.log(Level.INFO, "Session Id : " + sessionID);
        String domainName = (String)domainProperties.get("DOMAIN_NAME");
        this.initSecurity(request, domainName);
        String rootDomainNamingContext = (String)domainProperties.get("DEFAULT_NAMING_CONTEXT");
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList ouList = new ArrayList();
        ouList = isWorkflowMode ? WFRequesterUtil.getOUListDN((String)domainName, (Long)loginId) : HelpdeskUtil.getOUList((String)domainName, (Long)loginId);
        String containerName = UserMgmtUtil.getDefaultContainerName((String)rootDomainNamingContext, (ArrayList)ouList);
        Long templateId = 0L;
        ArrayList templateIds = UserTemplateHandler.getTemplateIds((Long)loginId, (String)domainName);
        Long defaultTemplate = UserTemplateUtil.getDefaultTemplate((Long)loginId);
        if (templateIds.contains(defaultTemplate)) {
            templateId = defaultTemplate;
        }
        Long userCreationID = AddUserHandler.getInstance().addNewUserList(sessionID, domainName, containerName, templateId, loginId);
        this.out.log(Level.INFO, "UserCreation ID : " + userCreationID);
        session.setAttribute("userCreationID", (Object)userCreationID);
        session.setAttribute("attributeList", new ArrayList());
        ArrayList mailServersList = new ArrayList();
        ArrayList mailBoxStoresList = new ArrayList();
        ArrayList mailServers = new ArrayList();
        ArrayList<String> mailServerDNs = new ArrayList<String>();
        ArrayList mailBoxStores = new ArrayList();
        ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
        String mailBoxVersion = "";
        mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
        if (mailServersList != null && !mailServersList.isEmpty()) {
            mailServers = (ArrayList)mailServersList.get(0);
            mailServerDNs = (ArrayList<String>)mailServersList.get(1);
        }
        if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
            mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)((String)mailServerDNs.get(0)));
        } else {
            mailServers = new ArrayList();
            mailServers.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mail_server"));
            mailServerDNs = new ArrayList<String>();
            mailServerDNs.add("0");
        }
        if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
            mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
            mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
        }
        if (mailBoxStores == null || mailBoxStores.isEmpty()) {
            mailBoxStores = new ArrayList();
            mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mailbox_stores"));
            mailBoxStoreDNs = new ArrayList<String>();
            mailBoxStoreDNs.add("0");
        }
        if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
            mailBoxVersion = ExchangeUtil.getExchangeServerType((String)((String)mailServerDNs.get(0))).toString();
        }
        session.setAttribute("mailServers", (Object)mailServers);
        session.setAttribute("mailServerDNs", mailServerDNs);
        session.setAttribute("mailBoxStores", (Object)mailBoxStores);
        session.setAttribute("mailBoxStoreDNs", mailBoxStoreDNs);
        session.setAttribute("mailVersion", (Object)mailBoxVersion);
        ArrayList mailGroupsList = new ArrayList();
        ArrayList<String> msExchAdminGroupDisplayList = new ArrayList<String>();
        ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
        mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName);
        if (!mailGroupsList.isEmpty()) {
            msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
            msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
            if (msExchAdminGroupDNList.isEmpty()) {
                msExchAdminGroupDisplayList = new ArrayList<String>();
                msExchAdminGroupDisplayList.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_admin_group"));
                msExchAdminGroupDNList = new ArrayList<String>();
                msExchAdminGroupDNList.add("0");
            }
        }
        session.setAttribute("msExchAdminGroupDisplayList", msExchAdminGroupDisplayList);
        session.setAttribute("msExchAdminGroupDNList", msExchAdminGroupDNList);
        this.addUserListener = null;
    }

    public void initAttributeDetails(HttpServletRequest request, String actionType, String domainName, Long previousTemplateID, ArrayList customAttribList, Boolean isWorkflowMode) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            this.setCheckPrivilege(false);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            this.initSecurity(request, domainName);
            ArrayList groupList = (ArrayList)session.getAttribute("userCreationGroupList");
            if (groupList == null || groupList.isEmpty()) {
                GroupHandler.init((String)domainName, (String)DomainUtil.getDefaultNamingContext((String)domainName), (Integer)109);
                groupList = UserMgmtUtil.getGroupList((Long)loginId, (String)DomainUtil.getDefaultNamingContext((String)domainName));
                session.setAttribute("userCreationGroupList", (Object)groupList);
            }
            if (actionType.equals("single")) {
                Long userCreationID = (Long)session.getAttribute("userCreationID");
                Long templateId = ApplyTemplateHandler.getTemplateId((Long)userCreationID);
                if (templateId.equals(0L) && previousTemplateID.equals(0L)) {
                    UserAttributeHandler.initAttributes(request, this, domainName, groupList, userCreationID);
                } else {
                    UserAttributeHandler.initAttributes(request, this, previousTemplateID, templateId, domainName, groupList, loginId, customAttribList);
                }
                request.setAttribute("domainProps", (Object)HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId));
                ArrayList domainList = ClientAuthorizationUtil.getAuthorizedDomainPropList(request, DelegationUtil.CREATE_SINLGLE_USER_ACTION_ID);
                if (isWorkflowMode.booleanValue()) {
                    domainList = WorkFlowUserHandler.getAuthorizedDomainListForCatagory((Long)loginId, (Integer)5);
                }
                request.setAttribute("domainList", (Object)domainList);
                ArrayList mailServersList = new ArrayList();
                ArrayList mailBoxStoresList = new ArrayList();
                ArrayList mailServers = new ArrayList();
                ArrayList<String> mailServerDNs = new ArrayList<String>();
                ArrayList mailBoxStores = new ArrayList();
                ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
                String mailBoxVersion = "";
                mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
                if (mailServersList != null && !mailServersList.isEmpty()) {
                    mailServers = (ArrayList)mailServersList.get(0);
                    mailServerDNs = (ArrayList<String>)mailServersList.get(1);
                }
                if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                    String MAIL_SERVER = (String)this.get("MAIL_SERVER");
                    if (MAIL_SERVER == null || MAIL_SERVER.equals("0") || MAIL_SERVER.equals("")) {
                        MAIL_SERVER = (String)mailServerDNs.get(0);
                    }
                    mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)MAIL_SERVER);
                } else {
                    mailServers = new ArrayList();
                    mailServers.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mail_server"));
                    mailServerDNs = new ArrayList<String>();
                    mailServerDNs.add("0");
                }
                if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                    mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
                    mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
                }
                if (mailBoxStores == null || mailBoxStores.isEmpty()) {
                    mailBoxStores = new ArrayList();
                    mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mailbox_stores"));
                    mailBoxStoreDNs = new ArrayList<String>();
                    mailBoxStoreDNs.add("0");
                }
                if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                    mailBoxVersion = ExchangeUtil.getExchangeServerType((String)((String)mailServerDNs.get(0))).toString();
                }
                this.set("mailServers", mailServers);
                this.set("mailServerDNs", mailServerDNs);
                this.set("mailBoxStores", mailBoxStores);
                this.set("mailBoxStoreDNs", mailBoxStoreDNs);
                this.set("mailVersion", mailBoxVersion);
                ArrayList mailGroupsList = new ArrayList();
                ArrayList<String> msExchAdminGroupDisplayList = new ArrayList<String>();
                ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
                mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName);
                if (!mailGroupsList.isEmpty()) {
                    msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
                    msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
                    if (msExchAdminGroupDNList.isEmpty()) {
                        msExchAdminGroupDisplayList = new ArrayList<String>();
                        msExchAdminGroupDisplayList.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_admin_group"));
                        msExchAdminGroupDNList = new ArrayList<String>();
                        msExchAdminGroupDNList.add("0");
                    }
                }
                this.set("msExchAdminGroupDisplayList", msExchAdminGroupDisplayList);
                this.set("msExchAdminGroupDNList", msExchAdminGroupDNList);
            } else {
                Long userCreationID = (Long)session.getAttribute("userCreationID");
                Long templateId = ApplyTemplateHandler.getTemplateId((Long)userCreationID);
                if (templateId.equals(0L)) {
                    UserAttributeHandler.initAttributes(request, this, domainName, groupList, userCreationID);
                } else {
                    UserAttributeHandler.initAttributes(request, this, templateId, domainName, groupList);
                }
                ArrayList mailServersList = new ArrayList();
                ArrayList mailBoxStoresList = new ArrayList();
                ArrayList mailServers = new ArrayList();
                ArrayList<String> mailServerDNs = new ArrayList<String>();
                ArrayList mailBoxStores = new ArrayList();
                ArrayList<String> mailBoxStoreDNs = new ArrayList<String>();
                String mailBoxVersion = "";
                mailServersList = ExchangeHandler.getExchangeServers((String)domainName);
                if (mailServersList != null && !mailServersList.isEmpty()) {
                    mailServers = (ArrayList)mailServersList.get(0);
                    mailServerDNs = (ArrayList<String>)mailServersList.get(1);
                }
                if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                    String MAIL_SERVER = (String)this.get("MAIL_SERVER");
                    if (MAIL_SERVER == null || MAIL_SERVER.equals("0") || MAIL_SERVER.equals("")) {
                        MAIL_SERVER = (String)mailServerDNs.get(0);
                    }
                    mailBoxStoresList = ExchangeHandler.getMailBoxStores((String)domainName, (String)MAIL_SERVER);
                } else {
                    mailServers = new ArrayList();
                    mailServers.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mail_server"));
                    mailServerDNs = new ArrayList<String>();
                    mailServerDNs.add("0");
                }
                if (mailBoxStoresList != null && !mailBoxStoresList.isEmpty()) {
                    mailBoxStores = (ArrayList)mailBoxStoresList.get(0);
                    mailBoxStoreDNs = (ArrayList<String>)mailBoxStoresList.get(1);
                }
                if (mailBoxStores == null || mailBoxStores.isEmpty()) {
                    mailBoxStores = new ArrayList();
                    mailBoxStores.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_mailbox_stores"));
                    mailBoxStoreDNs = new ArrayList<String>();
                    mailBoxStoreDNs.add("0");
                }
                if (mailServerDNs != null && !mailServerDNs.isEmpty()) {
                    mailBoxVersion = ExchangeUtil.getExchangeServerType((String)((String)mailServerDNs.get(0))).toString();
                }
                this.set("mailServers", mailServers);
                this.set("mailServerDNs", mailServerDNs);
                this.set("mailBoxStores", mailBoxStores);
                this.set("mailBoxStoreDNs", mailBoxStoreDNs);
                this.set("mailVersion", mailBoxVersion);
                ArrayList mailGroupsList = new ArrayList();
                ArrayList<String> msExchAdminGroupDisplayList = new ArrayList<String>();
                ArrayList<String> msExchAdminGroupDNList = new ArrayList<String>();
                mailGroupsList = ExchangeUtil.getExchangeAdminGroups((String)domainName);
                if (!mailGroupsList.isEmpty()) {
                    msExchAdminGroupDisplayList = (ArrayList<String>)mailGroupsList.get(0);
                    msExchAdminGroupDNList = (ArrayList<String>)mailGroupsList.get(1);
                    if (msExchAdminGroupDNList.isEmpty()) {
                        msExchAdminGroupDisplayList = new ArrayList<String>();
                        msExchAdminGroupDisplayList.add(rb.getString("admp.mgmt.user_mgmt.cre_single_user.text.no_admin_group"));
                        msExchAdminGroupDNList = new ArrayList<String>();
                        msExchAdminGroupDNList.add("0");
                    }
                }
                this.set("msExchAdminGroupDisplayList", msExchAdminGroupDisplayList);
                this.set("msExchAdminGroupDNList", msExchAdminGroupDNList);
            }
            this.setCheckPrivilege(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void saveUserDetails(HttpServletRequest request) throws Exception {
        this.setNamingAttributes(request);
        this.setSecurityAttributes(request);
        this.setPasswordAttributes(request);
        this.setTerminalAttributes(request);
        String mailEnabled = (String)this.get("mailEnabled");
        if (mailEnabled.equalsIgnoreCase("mailBox")) {
            this.setExchangeAttributes(request);
            this.setEmailProxyAddresses(request, mailEnabled);
        } else if (mailEnabled.equalsIgnoreCase("mail")) {
            this.setMailEnableAttributes(request);
            this.setEmailProxyAddresses(request, mailEnabled);
        }
        UserAttributeHandler.addorUpdateUserAttributeDetails(this, request);
    }

    public Properties createSingleUser(HttpServletRequest request) throws Exception {
        this.setAttributes(request);
        Properties statusProps = CreateSingleUser.addSingleUser(this, request);
        return statusProps;
    }

    public Long createAddSingleUserRequest(HttpServletRequest request) throws Exception {
        this.setCheckPrivilege(false);
        this.setAttributes(request);
        Long requestId = CreateSingleUser.createAddSingleUserRequest(this, request);
        return requestId;
    }

    public void setAttributes(HttpServletRequest request) throws Exception {
        this.setNamingAttributes(request);
        this.setSecurityAttributes(request);
        this.setPasswordAttributes(request);
        this.setTerminalAttributes(request);
        this.setCustomAttributes(request);
        String mailEnabled = (String)this.get("mailEnabled");
        if (mailEnabled.equalsIgnoreCase("mailBox")) {
            this.setExchangeAttributes(request);
            this.setEmailProxyAddresses(request, mailEnabled);
        } else if (mailEnabled.equalsIgnoreCase("mail")) {
            this.setMailEnableAttributes(request);
            this.setEmailProxyAddresses(request, mailEnabled);
        }
        String containerText = request.getParameter("containerText");
        String container = "";
        container = containerText == null ? (String)this.get("container") : containerText;
        this.set("container", container);
    }

    public void setNamingAttributes(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Properties domainProps = null;
        String domainName = (String)session.getAttribute("userCreationDomain");
        if (domainName == null) {
            domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
            domainName = domainProps.getProperty("DOMAIN_NAME");
        } else {
            domainProps = HDTDomainHandler.getConfiguredValues((String)domainName, (Long)loginId);
        }
        String logonName = (String)this.get("LOGON_NAME");
        String upnSuffix = (String)this.get("UPN_SUFFIX");
        if (logonName != null && !logonName.equalsIgnoreCase("")) {
            this.set("LOGON_NAME", this.get("LOGON_NAME") + "@" + upnSuffix, false);
        }
    }

    public void setSecurityAttributes(HttpServletRequest request) throws Exception {
        String accountExpiresStatus;
        HttpSession session = request.getSession();
        ArrayList<String> getUACList = new ArrayList<String>();
        ArrayList<String> setUACList = new ArrayList<String>();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String domainName = (String)session.getAttribute("userCreationDomain");
        if (domainName == null) {
            Properties domainProps = HDTDomainHandler.getSelectedDomain((Long)loginId);
            domainName = domainProps.getProperty("DOMAIN_NAME");
        }
        String userAccountControl = (String)this.get("userAccountControl");
        String preUserAccountControl = request.getParameter("preUserAccountControl");
        if (preUserAccountControl != null && !preUserAccountControl.equals("")) {
            StringTokenizer preTokenizer = new StringTokenizer(preUserAccountControl, ",");
            while (preTokenizer.hasMoreTokens()) {
                getUACList.add(preTokenizer.nextToken());
            }
        }
        StringTokenizer tokenizer = new StringTokenizer(userAccountControl, ",");
        int uac = 0;
        int uacNand = 0;
        int uacNew = 0;
        while (tokenizer.hasMoreTokens()) {
            String temp = tokenizer.nextToken();
            setUACList.add(temp);
            uac += Integer.parseInt(temp);
        }
        if (!getUACList.isEmpty()) {
            for (int j = 0; j < getUACList.size(); ++j) {
                if (setUACList.contains(getUACList.get(j))) continue;
                System.out.println("UAC TO BE REMOVED : " + getUACList.get(j));
                uacNand += Integer.parseInt((String)getUACList.get(j));
            }
            if (this.privilegeId.equals("")) {
                this.set("NAND_ACCOUNT_STATUS", uacNand);
            } else if (ExtendedAttributesUtil.isAuthorizedValue(request, "userAccountControl", uacNand, this.privilegeId, domainName)) {
                this.set("NAND_ACCOUNT_STATUS", uacNand);
            }
        }
        if (!setUACList.isEmpty()) {
            for (int j = 0; j < setUACList.size(); ++j) {
                if (getUACList.contains(setUACList.get(j))) continue;
                uacNew += Integer.parseInt((String)setUACList.get(j));
            }
        }
        if (this.privilegeId.equals("")) {
            this.set("ACCOUNT_STATUS", uac);
        } else if (ExtendedAttributesUtil.isAuthorizedValue(request, "userAccountControl", uacNew, this.privilegeId, domainName)) {
            this.set("ACCOUNT_STATUS", uac);
        }
        String passwdLastSet = (String)this.get("passwdLastSet");
        if (passwdLastSet.equals("0")) {
            this.set("PASSWORD_LAST_SET", 0L);
        } else {
            this.set("PASSWORD_LAST_SET", -1L);
        }
        String usrFlgString = (String)this.get("usrFlgString");
        if (!usrFlgString.equals("")) {
            Integer USER_FLAGS = Integer.parseInt(usrFlgString);
            if (this.privilegeId.equals("")) {
                this.set("USER_FLAGS", USER_FLAGS);
            } else if (ExtendedAttributesUtil.isAuthorizedValue(request, "userFlags", USER_FLAGS, this.privilegeId, domainName)) {
                this.set("USER_FLAGS", USER_FLAGS);
            }
        }
        if ((accountExpiresStatus = (String)this.get("accountExpiresStatus")).equalsIgnoreCase("endof")) {
            String dateString = (String)this.get("accountExpiresDate");
            StringTokenizer dateTokenizer = new StringTokenizer(dateString, "/");
            int count = dateTokenizer.countTokens();
            int[] dateArray = new int[count];
            for (int i = 0; i < count; ++i) {
                dateArray[i] = Integer.parseInt(dateTokenizer.nextToken());
            }
            Calendar calendar = Calendar.getInstance();
            calendar.set(dateArray[0], dateArray[1] - 1, dateArray[2], 0, 0, 0);
            calendar.set(14, 0);
            Long fileTime = DateTimeUtil.getFileTimeFromSystemTime((Long)calendar.getTimeInMillis());
            this.set("ACCOUNT_EXPIRY_DATE", fileTime);
        } else if (accountExpiresStatus.equalsIgnoreCase("never")) {
            this.set("ACCOUNT_EXPIRY_DATE", 0L);
        } else if (accountExpiresStatus.equalsIgnoreCase("Custom")) {
            Long customAccountExpiresDays = AddUserClientUtil.getLongValue((String)this.get("customAccountExpiresDays"));
            this.set("ACCOUNT_EXPIRY_DATE", customAccountExpiresDays);
        } else {
            Long days = AddUserClientUtil.getLongValue((String)this.get("accountExpiresStatus"));
            this.set("ACCOUNT_EXPIRY_DATE", days);
        }
        String homeFolder = (String)this.get("homeFolder");
        if (homeFolder.equalsIgnoreCase("local")) {
            this.set("HOME_DRIVE", "", false);
            String localHomeDirectory = (String)this.get("localHomeDirectory");
            this.set("HOME_DIRECTORY", localHomeDirectory);
        } else {
            String networkHomeDirectory = (String)this.get("networkHomeDirectory");
            this.set("HOME_DIRECTORY", (String)this.get("networkHomeDirectory"));
        }
        Properties PRIMARY_GROUP = (Properties)this.get("PRIMARY_GROUP");
        ArrayList MEMBER_OF = (ArrayList)this.get("MEMBER_OF");
        if (!PRIMARY_GROUP.isEmpty() && !MEMBER_OF.isEmpty()) {
            int pgInd = 0;
            for (Properties properties : MEMBER_OF) {
                if (!properties.equals(PRIMARY_GROUP)) continue;
                pgInd = MEMBER_OF.indexOf(properties);
            }
            MEMBER_OF.remove(pgInd);
            String groupRID = PRIMARY_GROUP.getProperty("objectRID");
            this.set("PRIMARY_GROUP_ID", groupRID);
        } else {
            this.set("PRIMARY_GROUP_ID", null);
        }
        String logonSystems = (String)this.get("logonSystems");
        String logonToPermission = (String)this.get("logonToPermission");
        if (logonToPermission.equals("allComputers")) {
            this.set("LOGON_TO", "");
        } else {
            this.set("LOGON_TO", logonSystems);
        }
    }

    public void setPasswordAttributes(HttpServletRequest request) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        String domainName = (String)session.getAttribute("userCreationDomain");
        String PASSWORD_TYPE = (String)this.get("PASSWORD_TYPE");
        String PASSWORD = (String)this.get("PASSWORD");
        if (PASSWORD_TYPE.equalsIgnoreCase("generatepassword")) {
            PasswordPolicy pwdPolicy = new PasswordPolicy();
            pwdPolicy.setPolicyDetails();
            PASSWORD = PasswordGenerator.generatePassword((PasswordPolicy)pwdPolicy, (AdventNetResourceBundle)rb);
        } else if (PASSWORD_TYPE.equalsIgnoreCase("ownpassword")) {
            if (request.getParameter("enterPassword") != null) {
                PASSWORD = request.getParameter("enterPassword");
            }
        } else if (PASSWORD_TYPE.equalsIgnoreCase("sameasusername")) {
            if (request.getParameter("SAM_ACCOUNT_NAME") != null) {
                PASSWORD = request.getParameter("SAM_ACCOUNT_NAME");
            }
        } else if (PASSWORD_TYPE.equalsIgnoreCase("blankpassword")) {
            this.set("PASSWORD", "");
        }
        if (!PASSWORD.equals("")) {
            this.set("PASSWORD", PASSWORD);
        }
    }

    public void setTerminalAttributes(HttpServletRequest request) throws Exception {
        String TS_REMOTE_HOME_DIRECTORY = (String)this.get("TS_REMOTE_HOME_DIRECTORY");
        if (TS_REMOTE_HOME_DIRECTORY.equalsIgnoreCase("0")) {
            this.set("TS_HOME_DIRECTORY", request.getParameter("localTsHomeDirectory"));
            this.set("TS_HOME_DRIVE", "Z:");
        } else {
            this.set("TS_HOME_DIRECTORY", request.getParameter("networkTsHomeDirectory"));
        }
        Boolean tsAllowLogOn = (Boolean)this.get("tsAllowLogOn");
        if (tsAllowLogOn.booleanValue()) {
            this.set("TS_ALLOW_LOGON", "1");
        } else {
            this.set("TS_ALLOW_LOGON", "0");
        }
        Boolean tsInheritInitial = (Boolean)this.get("tsInheritInitial");
        if (tsInheritInitial.booleanValue()) {
            this.set("TS_INHERIT_INITIAL_PROGRAM", "0");
        } else {
            this.set("TS_INHERIT_INITIAL_PROGRAM", "1");
        }
        Boolean tsDcDrives = (Boolean)this.get("tsDcDrives");
        if (tsDcDrives.booleanValue()) {
            this.set("TS_DC_DRIVES", "1");
        } else {
            this.set("TS_DC_DRIVES", "0");
        }
        Boolean tsDcPrinters = (Boolean)this.get("tsDcPrinters");
        if (tsDcPrinters.booleanValue()) {
            this.set("TS_DC_PRINTERS", "1");
        } else {
            this.set("TS_DC_PRINTERS", "0");
        }
        Boolean tsDcDedaultPrinter = (Boolean)this.get("tsDcDedaultPrinter");
        if (tsDcDedaultPrinter.booleanValue()) {
            this.set("TS_DC_DEFAULT_PRINTER", "1");
        } else {
            this.set("TS_DC_DEFAULT_PRINTER", "0");
        }
        String allowDialIn = (String)this.get("ALLOW_DIALIN");
        this.set("ALLOW_DIALIN", allowDialIn);
    }

    public void setExchangeAttributes(HttpServletRequest request) throws Exception {
        String recipLim;
        String delivSize;
        String submSize;
        String dnString;
        Properties properties;
        HttpSession session = request.getSession();
        String domainName = (String)session.getAttribute("userCreationDomain");
        String keepDelItemsDays = (String)this.get("keepDelItemsDays");
        Long days = Long.parseLong(keepDelItemsDays);
        this.set("KEEP_DELETED_ITEMS", days * 86400L);
        Boolean useDefaultStorage = (Boolean)this.get("USE_DEFAULT_STORAGE");
        this.set("USE_DEFAULT_STORAGE", useDefaultStorage);
        String omaccess = (String)this.get("omaccess");
        String uis = (String)this.get("uis");
        String updNotify = (String)this.get("updNotify");
        String owaccess = (String)this.get("owaccess");
        ArrayList<Object> PROTOCOL_SETTINGS = new ArrayList();
        String mailServer = (String)this.get("MAIL_SERVER");
        String pop = (String)this.get("pop");
        String imap = (String)this.get("imap");
        if (mailServer != null) {
            Integer exchType = ExchangeUtil.getExchangeServerType((String)mailServer);
            PROTOCOL_SETTINGS = this.getProtocolSettings(owaccess, pop, imap, exchType);
            this.set("PROTOCOL_SETTINGS", PROTOCOL_SETTINGS);
            String OMA = this.getOMAString(omaccess, uis, updNotify);
            if (exchType >= 2007) {
                OMA = Integer.parseInt(OMA) > 3 ? "4" : "0";
            }
            this.set("OMA", OMA);
        }
        String msgRestriction = (String)this.get("msgRestriction");
        ArrayList<Properties> ACCEPT_MESSAGES_FROM = new ArrayList<Properties>();
        ArrayList<Properties> REJECT_MESSAGES_FROM = new ArrayList<Properties>();
        String mRrecipientsDNString = (String)this.get("mRrecipientsDNString");
        StringTokenizer stringTokenizer = new StringTokenizer(mRrecipientsDNString, "||");
        ArrayList<String> mRrecipientsDNList = new ArrayList<String>();
        ArrayList<String> mRrecipientsDisplayList = new ArrayList<String>();
        if (msgRestriction.equalsIgnoreCase("onlyFrom")) {
            while (stringTokenizer.hasMoreTokens()) {
                properties = new Properties();
                dnString = stringTokenizer.nextToken();
                if (dnString.contains("&amp;")) {
                    dnString = dnString.replaceAll("&amp;", "&");
                } else if (dnString.contains("&lt;")) {
                    dnString = dnString.replaceAll("&lt;", "<");
                } else if (dnString.contains("&gt;")) {
                    dnString = dnString.replaceAll("&gt;", ">");
                }
                properties.setProperty("Distinguished_Name", dnString);
                ACCEPT_MESSAGES_FROM.add(properties);
                mRrecipientsDNList.add(dnString);
                mRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)dnString));
            }
        } else if (msgRestriction.equalsIgnoreCase("fromExcept")) {
            while (stringTokenizer.hasMoreTokens()) {
                properties = new Properties();
                dnString = stringTokenizer.nextToken();
                if (dnString.contains("&amp;")) {
                    dnString = dnString.replaceAll("&amp;", "&");
                } else if (dnString.contains("&lt;")) {
                    dnString = dnString.replaceAll("&lt;", "<");
                } else if (dnString.contains("&gt;")) {
                    dnString = dnString.replaceAll("&gt;", ">");
                }
                properties.setProperty("Distinguished_Name", dnString);
                REJECT_MESSAGES_FROM.add(properties);
                mRrecipientsDNList.add(dnString);
                mRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)dnString));
            }
        }
        this.set("mRrecipientsDNList", mRrecipientsDNList);
        this.set("mRrecipientsDisplayList", mRrecipientsDisplayList);
        ArrayList<Properties> SEND_ON_BEHALF = new ArrayList<Properties>();
        String sobDNString = (String)this.get("sobDNString");
        StringTokenizer tokenizer = new StringTokenizer(sobDNString, "||");
        ArrayList<String> sobDNList = new ArrayList<String>();
        ArrayList<String> sobDisplayList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            Properties properties2 = new Properties();
            String dnString2 = tokenizer.nextToken();
            if (dnString2.contains("&amp;")) {
                dnString2 = dnString2.replaceAll("&amp;", "&");
            } else if (dnString2.contains("&lt;")) {
                dnString2 = dnString2.replaceAll("&lt;", "<");
            } else if (dnString2.contains("&gt;")) {
                dnString2 = dnString2.replaceAll("&gt;", ">");
            }
            properties2.setProperty("Distinguished_Name", dnString2);
            SEND_ON_BEHALF.add(properties2);
            sobDNList.add(dnString2);
            sobDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)dnString2));
        }
        this.set("sobDNList", sobDNList);
        this.set("sobDisplayList", sobDisplayList);
        this.set("REJECT_MESSAGES_FROM", REJECT_MESSAGES_FROM);
        this.set("ACCEPT_MESSAGES_FROM", ACCEPT_MESSAGES_FROM);
        this.set("SEND_ON_BEHALF", SEND_ON_BEHALF);
        String forwardTo = (String)this.get("FORWARD_TO");
        if (!forwardTo.equals("")) {
            this.set("forwardToText", UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)forwardTo));
        }
        if ((submSize = (String)this.get("submSize")).equals("default")) {
            this.set("OUT_MESSAGE_SIZE", "");
        }
        if ((delivSize = (String)this.get("delivSize")).equals("default")) {
            this.set("IN_MESSAGE_SIZE", "");
        }
        if ((recipLim = (String)this.get("recipLim")).equals("default")) {
            this.set("RECIPIENT_LIMITS", "");
        }
    }

    public void setEmailProxyAddresses(HttpServletRequest request, String mailEnabled) throws Exception {
        try {
            String formats = "";
            Boolean policyInclude = true;
            if (mailEnabled.equalsIgnoreCase("mailBox")) {
                formats = request.getParameter("formatsForProxies");
                policyInclude = (Boolean)this.get("INCLUDE_POLICIES");
            } else if (mailEnabled.equalsIgnoreCase("mail")) {
                formats = request.getParameter("meFormatsForProxies");
                policyInclude = (Boolean)this.get("ME_INCLUDE_POLICIES");
            }
            if (formats != null && !formats.equals("")) {
                StringTokenizer stringTokenizer = new StringTokenizer(formats, "|**|");
                ArrayList<String> EMAIL_PROXY_ADDRESSES = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    EMAIL_PROXY_ADDRESSES.add(stringTokenizer.nextToken());
                }
                this.set("EMAIL_PROXY_ADDRESSES", EMAIL_PROXY_ADDRESSES);
                if (!policyInclude.booleanValue()) {
                    this.set("MS_EXCH_EXCLUDE_POLICIES", "{26491CFC-9E50-4857-861B-0CB8DF22B5D7}");
                } else {
                    this.set("MS_EXCH_EXCLUDE_POLICIES", "");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getOMAString(String omaccess, String uis, String updNotify) {
        if (omaccess.equalsIgnoreCase("omaEnable") && uis.equalsIgnoreCase("uisEnable") && updNotify.equalsIgnoreCase("updNotifyEnable")) {
            return "0";
        }
        if (omaccess.equalsIgnoreCase("omaDisable") && uis.equalsIgnoreCase("uisEnable") && updNotify.equalsIgnoreCase("updNotifyEnable")) {
            return "2";
        }
        if (omaccess.equalsIgnoreCase("omaEnable") && uis.equalsIgnoreCase("uisDisable")) {
            return "5";
        }
        if (omaccess.equalsIgnoreCase("omaEnable") && uis.equalsIgnoreCase("uisEnable") && updNotify.equalsIgnoreCase("updNotifyDisable")) {
            return "1";
        }
        if (omaccess.equalsIgnoreCase("omaDisable") && uis.equalsIgnoreCase("uisDisable")) {
            return "7";
        }
        if (omaccess.equalsIgnoreCase("omaDisable") && uis.equalsIgnoreCase("uisEnable") && updNotify.equalsIgnoreCase("updNotifyDisable")) {
            return "3";
        }
        return "0";
    }

    public ArrayList<String> getProtocolSettings(String owaccess, String pop, String imap, Integer version) {
        ArrayList<String> protocolSettings = new ArrayList<String>();
        if (version == 2007) {
            if (owaccess.equalsIgnoreCase("owaEnable")) {
                protocolSettings.add(UserMgmtUtil.HTTP_ENABLE_X07);
            } else {
                protocolSettings.add(UserMgmtUtil.HTTP_DISABLE_X07);
            }
            if (pop.equalsIgnoreCase("popEnable")) {
                protocolSettings.add(UserMgmtUtil.POP3_ENABLE_X07);
            } else {
                protocolSettings.add(UserMgmtUtil.POP3_DISABLE_X07);
            }
            if (imap.equalsIgnoreCase("imapEnable")) {
                protocolSettings.add(UserMgmtUtil.IMAP4_ENABLE_X07);
            } else {
                protocolSettings.add(UserMgmtUtil.IMAP4_DISABLE_X07);
            }
        } else if (version >= 2010) {
            if (owaccess.equalsIgnoreCase("owaEnable")) {
                protocolSettings.add(UserMgmtUtil.HTTP_ENABLE_X10);
            } else {
                protocolSettings.add(UserMgmtUtil.HTTP_DISABLE_X10);
            }
            if (pop.equalsIgnoreCase("popEnable")) {
                protocolSettings.add(UserMgmtUtil.POP3_ENABLE_X10);
            } else {
                protocolSettings.add(UserMgmtUtil.POP3_DISABLE_X10);
            }
            if (imap.equalsIgnoreCase("imapEnable")) {
                protocolSettings.add(UserMgmtUtil.IMAP4_ENABLE_X10);
            } else {
                protocolSettings.add(UserMgmtUtil.IMAP4_DISABLE_X10);
            }
        } else {
            if (owaccess.equalsIgnoreCase("owaEnable")) {
                protocolSettings.add(UserMgmtUtil.HTTP_ENABLE);
            } else {
                protocolSettings.add(UserMgmtUtil.HTTP_DISABLE);
            }
            if (pop.equalsIgnoreCase("popEnable")) {
                protocolSettings.add(UserMgmtUtil.POP3_ENABLE);
            } else {
                protocolSettings.add(UserMgmtUtil.POP3_DISABLE);
            }
            if (imap.equalsIgnoreCase("imapEnable")) {
                protocolSettings.add(UserMgmtUtil.IMAP4_ENABLE);
            } else {
                protocolSettings.add(UserMgmtUtil.IMAP4_DISABLE);
            }
        }
        return protocolSettings;
    }

    public void setMailEnableAttributes(HttpServletRequest request) throws Exception {
        Properties properties;
        HttpSession session = request.getSession();
        String domainName = (String)session.getAttribute("userCreationDomain");
        String meMsgRestriction = (String)this.get("meMsgRestriction");
        ArrayList<Properties> ACCEPT_MESSAGES_FROM = new ArrayList<Properties>();
        ArrayList<Properties> REJECT_MESSAGES_FROM = new ArrayList<Properties>();
        String meMRrecipientsDNString = (String)this.get("meMRrecipientsDNString");
        StringTokenizer stringTokenizer = new StringTokenizer(meMRrecipientsDNString, "||");
        ArrayList<String> meMRrecipientsDNList = new ArrayList<String>();
        ArrayList<String> meMRrecipientsDisplayList = new ArrayList<String>();
        System.out.println("Tokens : " + meMRrecipientsDNString);
        System.out.println("Tokens COunt : " + stringTokenizer.countTokens());
        if (meMsgRestriction.equalsIgnoreCase("onlyFrom")) {
            while (stringTokenizer.hasMoreTokens()) {
                properties = new Properties();
                String dnString = stringTokenizer.nextToken();
                if (dnString.contains("&amp;")) {
                    dnString = dnString.replaceAll("&amp;", "&");
                } else if (dnString.contains("&lt;")) {
                    dnString = dnString.replaceAll("&lt;", "<");
                } else if (dnString.contains("&gt;")) {
                    dnString = dnString.replaceAll("&gt;", ">");
                }
                properties.setProperty("Distinguished_Name", dnString);
                ACCEPT_MESSAGES_FROM.add(properties);
                meMRrecipientsDNList.add(dnString);
                meMRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)dnString));
            }
        } else if (meMsgRestriction.equalsIgnoreCase("fromExcept")) {
            while (stringTokenizer.hasMoreTokens()) {
                properties = new Properties();
                String dnString = stringTokenizer.nextToken();
                if (dnString.contains("&amp;")) {
                    dnString = dnString.replaceAll("&amp;", "&");
                } else if (dnString.contains("&lt;")) {
                    dnString = dnString.replaceAll("&lt;", "<");
                } else if (dnString.contains("&gt;")) {
                    dnString = dnString.replaceAll("&gt;", ">");
                }
                properties.setProperty("Distinguished_Name", dnString);
                REJECT_MESSAGES_FROM.add(properties);
                meMRrecipientsDNList.add(dnString);
                meMRrecipientsDisplayList.add(UserMgmtUtil.getMOBDisplayNameFromDN((String)domainName, (String)dnString));
            }
        }
        this.set("meMRrecipientsDNList", meMRrecipientsDNList);
        this.set("meMRrecipientsDisplayList", meMRrecipientsDisplayList);
        this.set("REJECT_MESSAGES_FROM", REJECT_MESSAGES_FROM);
        this.set("ACCEPT_MESSAGES_FROM", ACCEPT_MESSAGES_FROM);
        String meDelivSize = (String)this.get("meDelivSize");
        if (meDelivSize.equals("default")) {
            this.set("ME_IN_MESSAGE_SIZE", "");
        }
    }

    public void setCustomAttributes(HttpServletRequest request) throws Exception {
        String[] customDisplayNames;
        long additional_custom_id = 0L;
        String mgmtType = "";
        if (this.privilegeId.equals("ACTION_ID")) {
            mgmtType = "userCreation";
            additional_custom_id = 1601L;
        } else if (this.privilegeId.equals("MODIFY_ID")) {
            mgmtType = "userModify";
            additional_custom_id = 1602L;
        }
        if (this.idslist.contains(additional_custom_id) || !this.privilege) {
            ArrayList<Properties> customAttribsList = new ArrayList<Properties>();
            String[] ldapNamesArray = request.getParameterValues("ldapName");
            String[] ldapValuesArray = request.getParameterValues("ldapValue");
            if (ldapNamesArray != null) {
                for (int i = 0; i < ldapNamesArray.length; ++i) {
                    if (ldapNamesArray[i].equalsIgnoreCase("") || ldapValuesArray[i].equalsIgnoreCase("")) continue;
                    Properties properties = new Properties();
                    properties.setProperty("CUSTOM_ATTRIB_NAME", ldapNamesArray[i]);
                    properties.setProperty("CUSTOM_ATTRIB_VALUE", ldapValuesArray[i]);
                    customAttribsList.add(properties);
                }
            }
            String[] ldapNames = new String[customAttribsList.size()];
            String[] ldapValues = new String[customAttribsList.size()];
            for (int i = 0; i < customAttribsList.size(); ++i) {
                Properties properties = (Properties)customAttribsList.get(i);
                ldapNames[i] = properties.getProperty("CUSTOM_ATTRIB_NAME");
                ldapValues[i] = properties.getProperty("CUSTOM_ATTRIB_VALUE");
            }
            super.set("CUSTOM_ATTRIB_NAME", (Object)ldapNames);
            super.set("CUSTOM_ATTRIB_VALUE", (Object)ldapValues);
        }
        if ((customDisplayNames = (String[])this.get("CUSTOM_ATTRIB_DISPLAY_NAME")) != null && customDisplayNames.length > 0) {
            String[] customLdapNames = (String[])this.get("CUSTOM_ATTRIB_LDAP_NAME");
            String[] customLdapValues = (String[])this.get("CUSTOM_ATTRIB_LDAP_VALUE");
            if (customLdapValues.length <= 0) {
                customLdapValues = new String[customDisplayNames.length];
            }
            for (int i = 0; i < customDisplayNames.length; ++i) {
                String customLdapValue = "";
                if (request.getParameter(customLdapNames[i]) != null && (this.idslist.contains(UserMgmtUtil.getCustomAttributeActionId((String)customLdapNames[i], (String)mgmtType)) || !this.privilege)) {
                    customLdapValues[i] = customLdapValue = request.getParameter(customLdapNames[i]);
                }
                if (customLdapValues[i] != null) continue;
                customLdapValues[i] = "";
            }
            super.set("CUSTOM_ATTRIB_DISPLAY_NAME", (Object)customDisplayNames);
            super.set("CUSTOM_ATTRIB_LDAP_NAME", (Object)customLdapNames);
            super.set("CUSTOM_ATTRIB_LDAP_VALUE", (Object)customLdapValues);
        }
    }

    public void setOUNameInCSV(HttpServletRequest request, Boolean val) throws Exception {
        this.set("isOUNameInCSV", val);
    }

    private void initSecurity(HttpServletRequest request, String domainName) {
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        this.idslist = authObject.getActionList(domainName);
        this.privilegeId = "ACTION_ID";
    }

    public void initSecurity(HttpServletRequest request, String method, String domainName) {
        HttpSession session = request.getSession();
        this.privilegeId = "MODIFY_ID";
        if (method.equalsIgnoreCase("singleModify")) {
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            this.idslist = authObject.getActionList(domainName);
        }
    }

    public void setCheckPrivilege(boolean b) {
        this.privilege = b;
    }

    public void set(String key, Object value) {
        this.set(key, value, this.privilege);
    }

    public void set(String key, Object value, boolean checkPrivilege) {
        boolean authorized;
        block8: {
            if (value == null) {
                return;
            }
            authorized = true;
            try {
                if (!checkPrivilege || this.idslist.size() < 1) break block8;
                ArrayList attributeList = AddUserHandler.getInstance().getAttributeList();
                for (int i = 0; i < attributeList.size(); ++i) {
                    Hashtable attributeDetails = (Hashtable)attributeList.get(i);
                    if (!attributeDetails.get("ATTRIB_COLUMN_NAME").equals(key)) continue;
                    Long actionId = (Long)attributeDetails.get(this.privilegeId);
                    if (actionId != null) {
                        authorized = false;
                        for (int j = 0; j < this.idslist.size(); ++j) {
                            if (!actionId.equals(this.idslist.get(j))) continue;
                            authorized = true;
                        }
                    }
                    break;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (authorized) {
            super.set(key, value);
        } else {
            this.out.log(Level.INFO, "UnAuthorized User. Trying to set the Property " + key);
        }
    }
}

