/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.delegation.DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class ClientAuthorizationUtil {
    public static boolean isAuthorizedObject(String dn, ArrayList ouList) {
        try {
            if (ouList == null || ouList.size() == 0) {
                return true;
            }
            for (int i = 0; i < ouList.size(); ++i) {
                String ouDN = ((String)ouList.get(i)).toLowerCase();
                if (!dn.toLowerCase().endsWith(ouDN)) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static ArrayList getAuthorizedOUList(HttpServletRequest request, String domainName) {
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList authOUList = (ArrayList)authObject.getDomainOUsMap().get(domainName);
        ArrayList ouList = new ArrayList();
        if (authOUList != null) {
            ouList = (ArrayList)authOUList.clone();
        }
        return ouList;
    }

    public static ArrayList getAuthorizedOUList(ADMPAuthObject authObject, String domainName) {
        ArrayList authOUList = (ArrayList)authObject.getDomainOUsMap().get(domainName);
        ArrayList ouList = new ArrayList();
        if (authOUList != null) {
            ouList = (ArrayList)authOUList.clone();
        }
        return ouList;
    }

    public static ArrayList getAuthorizedOUList(HttpServletRequest request, String domainName, Long actionId) {
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList ouList = (ArrayList)authObject.getDomainOUsMap().get(domainName);
        return ouList;
    }

    public static ArrayList<String> getAuthorizedDomainList(HttpServletRequest request, Long actionId) {
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        return ClientAuthorizationUtil.getAuthorizedDomainList(authObject, actionId);
    }

    public static ArrayList<String> getAuthorizedDomainList(ADMPAuthObject authObject, Long actionId) {
        ArrayList<String> authorizedDomainList = new ArrayList<String>();
        ArrayList domainNameList = authObject.getDomainNameList();
        for (String domainName : domainNameList) {
            if (!authObject.getActionList(domainName).contains(actionId)) continue;
            authorizedDomainList.add(domainName);
        }
        return authorizedDomainList;
    }

    public static ArrayList getAuthorizedDomainList(HttpServletRequest request, Integer reportId) {
        ArrayList authorizedDomainList = new ArrayList();
        Long actionId = ClientUtil.getActionId(reportId);
        if (actionId != null) {
            authorizedDomainList = ClientAuthorizationUtil.getAuthorizedDomainPropList(request, actionId);
        }
        return authorizedDomainList;
    }

    public static ArrayList getAuthorizedDomainPropList(HttpServletRequest request, Long actionId) {
        ArrayList<Properties> authorizedDomainList = new ArrayList<Properties>();
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList domainList = authObject.getDomainList();
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            String domainName = (String)domainProp.get("DOMAIN_NAME");
            if (!authObject.getActionList(domainName).contains(actionId)) continue;
            authorizedDomainList.add(domainProp);
        }
        return authorizedDomainList;
    }

    public static ArrayList getAuthorizedDomainAndOuList(HttpServletRequest request, Long actionId) throws Exception {
        ArrayList<Properties> authorizedDomainList = new ArrayList<Properties>();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Hashtable domainsHash = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
        ArrayList domainList = (ArrayList)domainsHash.get("domainList");
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            String domainName = (String)domainProp.get("DOMAIN_NAME");
            if (!authObject.getActionList(domainName).contains(actionId)) continue;
            authorizedDomainList.add(domainProp);
        }
        return authorizedDomainList;
    }

    public static Boolean isAuthorized(HttpSession session, String domainName, Long id) {
        Boolean isAuthorized = false;
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList actionList = authObject.getActionList(domainName);
        if (actionList != null) {
            isAuthorized = actionList.contains(id);
        }
        return isAuthorized;
    }

    public static Boolean isAuthorized(ADMPAuthObject authObject, String domainName, Long id) {
        Boolean isAuthorized = false;
        ArrayList actionList = authObject.getActionList(domainName);
        if (actionList != null) {
            isAuthorized = actionList.contains(id);
        }
        return isAuthorized;
    }

    public static Boolean isAuthorized(HttpServletRequest request, String domainName, Long id) {
        HttpSession session = request.getSession();
        return ClientAuthorizationUtil.isAuthorized(session, domainName, id);
    }

    public static Boolean isAuthorized(ADMPAuthObject authObject, ArrayList<String> domainList, Long id) {
        Boolean isAuthorized = false;
        for (String domain : domainList) {
            ArrayList actionList = authObject.getActionList(domain);
            if (actionList != null) {
                isAuthorized = actionList.contains(id);
            }
            if (!isAuthorized.booleanValue()) continue;
            break;
        }
        return isAuthorized;
    }

    public static Boolean isAuthorized(HttpServletRequest request, Long id) {
        Boolean isAuthorized = false;
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList actionList = authObject.getActionList();
        isAuthorized = actionList.contains(id);
        return isAuthorized;
    }

    public static boolean isAuthorized(Hashtable domainActionMap, String domainName, Long id) {
        Boolean isAuthorised = false;
        try {
            ArrayList actionList = (ArrayList)domainActionMap.get(domainName);
            if (actionList.contains(id)) {
                isAuthorised = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isAuthorised;
    }

    public static boolean isAuthorizedOU(HttpServletRequest request, String domainName, String ouDN) {
        ArrayList ouList = ClientAuthorizationUtil.getAuthorizedOUList(request, domainName);
        boolean isAuthorized = ClientAuthorizationUtil.isAuthorizedObject(ouDN, ouList);
        return isAuthorized;
    }

    public static boolean isAuthorized(HttpServletRequest request, Integer reportId) throws Exception {
        Boolean isAuthorised = false;
        HttpSession session = request.getSession();
        Long actionId = ClientUtil.getActionId(reportId);
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList actionList = authObject.getActionList();
        isAuthorised = actionList.contains(actionId);
        return isAuthorised;
    }

    public static boolean isAuthorized(HttpServletRequest request, String domainName, Integer reportId) throws Exception {
        Boolean isAuthorised = false;
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Long actionId = ClientUtil.getActionId(reportId);
        Hashtable domainActionIdMap = authObject.getDomainActionMap();
        ArrayList actionIdList = (ArrayList)domainActionIdMap.get(domainName);
        isAuthorised = actionIdList.contains(actionId);
        return isAuthorised;
    }

    public static boolean isAuthorized(HttpServletRequest request, String domainName, Integer reportId, String actionColumnName) throws Exception {
        Hashtable domainActionIdMap;
        ArrayList actionIdList;
        Boolean isAuthorised = false;
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Long actionId = ClientUtil.getActionId(reportId);
        Long denyId = ClientAuthorizationUtil.geDenyIdForActionName(actionId, actionColumnName);
        if (denyId != null && !(actionIdList = (ArrayList)(domainActionIdMap = authObject.getDomainActionMap()).get(domainName)).contains(denyId)) {
            isAuthorised = true;
        }
        return isAuthorised;
    }

    public static Long geDenyIdForActionName(Long actionId, String actionColumnName) throws Exception {
        Long denyId = null;
        Criteria criteria = new Criteria(Column.getColumn((String)"ActionIdDenyIdMapping", (String)"ACTION_ID"), (Object)actionId, 0);
        DataObject actionIdObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ActionIdDenyIdMapping", criteria);
        Row row = actionIdObject.getFirstRow("ActionIdDenyIdMapping");
        if (row != null) {
            denyId = (Long)row.get(actionColumnName);
        }
        return denyId;
    }

    public static Boolean isAuthorizedWorkflowAction(HttpServletRequest request, String domainName, Long id) {
        Boolean isAuthorized = false;
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList actionList = authObject.getWorkflowActionList(domainName);
        if (actionList != null) {
            isAuthorized = actionList.contains(id);
        }
        return isAuthorized;
    }

    public static Boolean isAuthorizedForChooseTemplate(HttpServletRequest request, String domainName, Long id) {
        Boolean isAuthorized = false;
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        if (authObject.isRequester().booleanValue()) {
            ArrayList actionList = authObject.getWorkflowActionList(domainName);
            if (actionList != null) {
                isAuthorized = actionList.contains(id);
            }
        } else {
            isAuthorized = true;
        }
        return isAuthorized;
    }

    public static boolean isSuperAdmin(HttpServletRequest request) throws Exception {
        Boolean isSuperAdmin = false;
        HttpSession session = request.getSession();
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList roleList = authObject.getRoleList();
        isSuperAdmin = roleList.contains(DelegationUtil.ADMIN_ROLE_ID);
        return isSuperAdmin;
    }

    public static DataObject getModuleDetails(Long[] actionIds, String tabName) {
        DataObject dataObj = null;
        try {
            Table baseTable = Table.getTable((String)"ModuleCategory");
            Criteria crit = new Criteria(Column.getColumn((String)"ModuleCategory", (String)"PARENT_ID"), (Object)tabName, 0);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            query.addJoin(new Join(baseTable, Table.getTable((String)"ModuleActionIdMapping"), new String[]{"MODULE_CATEGORY_ID"}, new String[]{"MODULE_CATEGORY_ID"}, 1));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Column col = Column.getColumn((String)"ModuleActionIdMapping", (String)"PRIORITY");
            query.addSortColumn(new SortColumn("ModuleCategory", "PRIORITY", true));
            query.addSortColumn(new SortColumn("ModuleActionIdMapping", "PRIORITY", true));
            crit = crit.and(CommonUtil.getActionCriteria((String)"ModuleActionIdMapping", (Long[])actionIds));
            query.setCriteria(crit);
            dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static boolean isAuthorizedForIamAppAction(HttpServletRequest request, ArrayList<String> domainNames, Long actionId) {
        try {
            for (int i = 0; i < domainNames.size(); ++i) {
                if (!ClientAuthorizationUtil.isAuthorized(request, domainNames.get(i), actionId).booleanValue()) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }
}

