/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.model.DirectoryObject;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DirectoryObjectUtil {
    public static ByteArrayOutputStream getADOXMLElement(DirectoryObject dirObject, String rootPath) {
        return DirectoryObjectUtil.getADOXMLElement(dirObject, rootPath, true, null, -1L);
    }

    public static ByteArrayOutputStream getADOXMLElement(DirectoryObject dirObject, String rootPath, boolean showContainerOnly) {
        return DirectoryObjectUtil.getADOXMLElement(dirObject, rootPath, showContainerOnly, null, -1L);
    }

    public static String getADOJSONElement(DirectoryObject dirObject, String rootPath, boolean showContainerOnly) {
        JSONObject json = new JSONObject();
        JSONObject data = new JSONObject();
        String returnValue = "";
        try {
            String NodeId = dirObject.getID();
            StringTokenizer tokenizer = new StringTokenizer(NodeId, ",");
            int cnt = tokenizer.countTokens();
            StringTokenizer rootToken = new StringTokenizer(rootPath, ",");
            int rtcnt = rootToken.countTokens();
            data.put("count", (Object)new Integer(cnt - rtcnt).toString());
            JSONObject parent = new JSONObject();
            parent.put("NodeId", (Object)NodeId);
            parent.put("scriptEscapedNodeId", (Object)ClientUtil.scriptEscape(dirObject.getID()));
            parent.put("htmlEscapedNodeId", (Object)ClientUtil.htmlEscape(dirObject.getID()));
            parent.put("aLink", (Object)dirObject.getActionLink());
            parent.put("displayName", (Object)dirObject.getName());
            parent.put("scriptEscapedDisplayName", (Object)ClientUtil.scriptEscape(dirObject.getName()));
            parent.put("htmlEscapedDisplayName", (Object)ClientUtil.htmlEscape(dirObject.getName()));
            String str = ClientUtil.htmlEscape(dirObject.getName());
            str = ClientUtil.scriptEscape(str);
            parent.put("htmlScriptEscapedDisplayName", (Object)str);
            str = ClientUtil.htmlEscape(dirObject.getID());
            str = ClientUtil.scriptEscape(str);
            parent.put("htmlScriptEscapedNodeId", (Object)str);
            parent.put("imageIcon", (Object)dirObject.getImageIcon());
            data.put("parent", (Object)parent);
            ArrayList childObjectList = dirObject.getChildObjectList();
            int childCount = childObjectList.size();
            boolean grandChild = true;
            if (showContainerOnly) {
                grandChild = false;
                for (int i = 0; i < childCount; ++i) {
                    DirectoryObject temp = (DirectoryObject)childObjectList.get(i);
                    String objectClass = temp.getObjectClass();
                    if (temp.isLeaf() && !objectClass.equalsIgnoreCase("organizationalUnit")) continue;
                    grandChild = true;
                }
            }
            if (grandChild) {
                ArrayList<JSONObject> childList = new ArrayList<JSONObject>();
                for (int i = 0; i < childCount; ++i) {
                    DirectoryObject temp = (DirectoryObject)childObjectList.get(i);
                    JSONObject child = new JSONObject();
                    child.put("NodeId", (Object)temp.getID());
                    child.put("scriptEscapedNodeId", (Object)ClientUtil.scriptEscape(temp.getID()));
                    child.put("htmlEscapedNodeId", (Object)ClientUtil.htmlEscape(temp.getID()));
                    child.put("aLink", (Object)temp.getActionLink());
                    child.put("displayName", (Object)temp.getName());
                    child.put("scriptEscapedDisplayName", (Object)ClientUtil.scriptEscape(temp.getName()));
                    child.put("htmlEscapedDisplayName", (Object)ClientUtil.htmlEscape(temp.getName()));
                    String str1 = ClientUtil.htmlEscape(temp.getName());
                    str1 = ClientUtil.scriptEscape(str1);
                    child.put("htmlScriptEscapedDisplayName", (Object)str1);
                    str1 = ClientUtil.htmlEscape(temp.getID());
                    str1 = ClientUtil.scriptEscape(str1);
                    child.put("htmlScriptEscapedNodeId", (Object)str1);
                    child.put("imageIcon", (Object)temp.getImageIcon());
                    child.put("leaf", (Object)new Boolean(temp.isLeaf()).toString());
                    childList.add(child);
                }
                data.put("child", childList);
            }
            json.put("data", (Object)data);
            returnValue = json.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnValue;
    }

    public static ByteArrayOutputStream getADOXMLElement(DirectoryObject dirObject, String rootPath, boolean showContainerOnly, String domainName, Long loginId) {
        ByteArrayOutputStream outNode = null;
        ArrayList wFRequesterOU = new ArrayList();
        if (loginId != -1L && domainName != null) {
            wFRequesterOU = WFRequesterUtil.getEscapedOUExcludeDNList((String)domainName, (Long)loginId);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DirectoryObject temp;
            int i;
            factory.setValidating(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element data = document.createElement("data");
            document.appendChild(data);
            String NodeId = dirObject.getID();
            StringTokenizer tokenizer = new StringTokenizer(NodeId, ",");
            int cnt = tokenizer.countTokens();
            StringTokenizer rootToken = new StringTokenizer(rootPath, ",");
            int rtcnt = rootToken.countTokens();
            Element count = document.createElement("count");
            count.setAttribute("value", new Integer(cnt - rtcnt).toString());
            data.appendChild(count);
            Element parent = document.createElement("parent");
            parent.setAttribute("NodeId", dirObject.getID());
            parent.setAttribute("scriptEscapedNodeId", ClientUtil.scriptEscape(dirObject.getID()));
            parent.setAttribute("htmlEscapedNodeId", ClientUtil.htmlEscape(dirObject.getID()));
            parent.setAttribute("aLink", dirObject.getActionLink());
            parent.setAttribute("displayName", dirObject.getName());
            parent.setAttribute("scriptEscapedDisplayName", ClientUtil.scriptEscape(dirObject.getName()));
            parent.setAttribute("htmlEscapedDisplayName", ClientUtil.htmlEscape(dirObject.getName()));
            String str = ClientUtil.htmlEscape(dirObject.getName());
            str = ClientUtil.scriptEscape(str);
            parent.setAttribute("htmlScriptEscapedDisplayName", str);
            str = ClientUtil.htmlEscape(dirObject.getID());
            str = ClientUtil.scriptEscape(str);
            parent.setAttribute("htmlScriptEscapedNodeId", str);
            parent.setAttribute("imageIcon", dirObject.getImageIcon());
            data.appendChild(parent);
            ArrayList childObjectList = dirObject.getChildObjectList();
            int childCount = childObjectList.size();
            boolean grandChild = true;
            if (showContainerOnly) {
                grandChild = false;
                for (i = 0; i < childCount; ++i) {
                    temp = (DirectoryObject)childObjectList.get(i);
                    String objectClass = temp.getObjectClass();
                    if (temp.isLeaf() && !objectClass.equalsIgnoreCase("organizationalUnit")) continue;
                    grandChild = true;
                }
            }
            if (grandChild) {
                for (i = 0; i < childCount; ++i) {
                    temp = (DirectoryObject)childObjectList.get(i);
                    Element child = document.createElement("child");
                    child.setAttribute("NodeId", temp.getID());
                    child.setAttribute("scriptEscapedNodeId", ClientUtil.scriptEscape(temp.getID()));
                    child.setAttribute("htmlEscapedNodeId", ClientUtil.htmlEscape(temp.getID()));
                    child.setAttribute("aLink", temp.getActionLink());
                    child.setAttribute("displayName", temp.getName());
                    child.setAttribute("scriptEscapedDisplayName", ClientUtil.scriptEscape(temp.getName()));
                    child.setAttribute("htmlEscapedDisplayName", ClientUtil.htmlEscape(temp.getName()));
                    child.setAttribute("object_guid", temp.getGuid());
                    if (wFRequesterOU.size() > 0) {
                        child.setAttribute("isWorkflow", "true");
                    }
                    if (wFRequesterOU.size() > 0 && !wFRequesterOU.contains(temp.getID())) {
                        child.setAttribute("disable", "true");
                    } else {
                        child.setAttribute("disable", "false");
                    }
                    String str1 = ClientUtil.htmlEscape(temp.getName());
                    str1 = ClientUtil.scriptEscape(str1);
                    child.setAttribute("htmlScriptEscapedDisplayName", str1);
                    str1 = ClientUtil.htmlEscape(temp.getID());
                    str1 = ClientUtil.scriptEscape(str1);
                    child.setAttribute("htmlScriptEscapedNodeId", str1);
                    child.setAttribute("imageIcon", temp.getImageIcon());
                    child.setAttribute("leaf", new Boolean(temp.isLeaf()).toString());
                    data.appendChild(child);
                }
            }
            DOMSource source = new DOMSource(data);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("encoding", System.getProperty("file.encoding"));
            outNode = new ByteArrayOutputStream();
            StreamResult result = new StreamResult(outNode);
            transformer.transform(source, result);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outNode;
    }

    public static DirectoryObject getDirectoryObject(String nodeClicked, HttpServletRequest request, String attrib) {
        HttpSession session = request.getSession();
        DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute(attrib);
        DirectoryObject object = (DirectoryObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
        DirectoryObject obj = DirectoryObjectUtil.getDirectoryObject(nodeClicked, object);
        return obj;
    }

    public static DirectoryObject getDirectoryObject(String nodeClicked, DirectoryObject object) {
        if (object.getID().equals(nodeClicked)) {
            return object;
        }
        ArrayList childList = object.getChildObjectList();
        if (childList.size() > 0) {
            for (int i = 0; i < childList.size(); ++i) {
                DirectoryObject childObject = (DirectoryObject)childList.get(i);
                DirectoryObject obj = DirectoryObjectUtil.getDirectoryObject(nodeClicked, childObject);
                if (obj == null) continue;
                return obj;
            }
        }
        return null;
    }

    public static ArrayList getParentOUsWithExcluded(ArrayList selectedlist, ArrayList excludedChildOUs) {
        ArrayList list = (ArrayList)selectedlist.clone();
        ArrayList<String> excludedOUList = new ArrayList<String>();
        block0: for (int i = 0; i < list.size(); ++i) {
            String dn = (String)list.get(i);
            for (int counter = 0; excludedChildOUs != null && counter < excludedChildOUs.size(); ++counter) {
                String excludedOUDN = (String)excludedChildOUs.get(counter);
                if (!excludedOUDN.endsWith(dn)) continue;
                excludedOUList.add(dn);
                list.remove(i);
                --i;
                continue block0;
            }
        }
        list = DirectoryObjectUtil.getParentOUs(list);
        list.addAll(excludedOUList);
        return list;
    }

    public static ArrayList getParentOUs(ArrayList l) {
        ArrayList list = (ArrayList)l.clone();
        block0: for (int i = 0; i < list.size(); ++i) {
            String s1 = ((String)list.get(i)).toLowerCase();
            for (int j = i + 1; j < list.size(); ++j) {
                String s2 = ((String)list.get(j)).toLowerCase();
                if (s1.endsWith(s2)) {
                    list.remove(i);
                    --i;
                    continue block0;
                }
                if (!s2.endsWith(s1)) continue;
                list.remove(j);
                --i;
                continue block0;
            }
        }
        return list;
    }

    public static DirectoryObject getDirectoryObject(String domainName, Long loginId, String rootPath, ArrayList ouList) throws Exception {
        DirectoryObject object = null;
        try {
            if (ouList == null || ouList.size() == 0) {
                object = (DirectoryObject)ADHandler.getDomainObject((String)domainName, (Long)loginId, (String)rootPath);
            } else {
                object = new DirectoryObject();
                ArrayList ous = DirectoryObjectUtil.getParentOUs(ouList);
                ArrayList ouProps = OUUtil.getOUProps((String)domainName, (Long)loginId, (ArrayList)ous);
                Properties childs = new Properties();
                for (int i = 0; i < ouProps.size(); ++i) {
                    Properties p = (Properties)ouProps.get(i);
                    DirectoryObject child = new DirectoryObject();
                    child.setName(p.getProperty("OU_NAME"));
                    child.setRelativeName(p.getProperty("DISTINGUISHED_NAME"));
                    child.setGuid(p.getProperty("OBJECT_GUID"));
                    child.setObjectClass(p.getProperty("OBJECT_CLASS"));
                    child.setIsLeaf(false);
                    child.setIsContainer(true);
                    childs.put(p.getProperty("DISTINGUISHED_NAME"), child);
                }
                object.setName(domainName);
                object.setRelativeName(rootPath);
                object.setObjectClass("domainDNS");
                object.setChildObjects(childs);
                object.setIsLeaf(false);
                object.setIsContainer(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return object;
    }

    public static DirectoryObject getDirectoryObjectGPM(HttpServletRequest request, String domainName, Long loginId, String rootPath, ArrayList ouList) throws Exception {
        DirectoryObject object = null;
        try {
            ArrayList dirobjects = ADHandler.getDomainObjectGPM((String)domainName, (Long)loginId, (String)rootPath);
            if (ouList == null || ouList.size() == 0) {
                object = (DirectoryObject)dirobjects.get(0);
                Properties objectChildObjects = new Properties();
                if (ClientAuthorizationUtil.isAuthorized(request.getSession(), domainName, new Long(1808L)).booleanValue()) {
                    objectChildObjects.put(((DirectoryObject)dirobjects.get(1)).getID(), dirobjects.get(1));
                }
                objectChildObjects.putAll((Map<?, ?>)object.getChildObjects());
                object.setChildObjects(objectChildObjects);
            } else {
                object = new DirectoryObject();
                Properties childs = new Properties();
                ArrayList ous = DirectoryObjectUtil.getParentOUs(ouList);
                ArrayList ouProps = OUUtil.getOUProps((String)domainName, (Long)loginId, (ArrayList)ous);
                for (int i = 0; i < ouProps.size(); ++i) {
                    Properties p = (Properties)ouProps.get(i);
                    DirectoryObject child = new DirectoryObject();
                    child.setName(p.getProperty("OU_NAME"));
                    child.setRelativeName(p.getProperty("DISTINGUISHED_NAME"));
                    child.setGuid(p.getProperty("OBJECT_GUID"));
                    child.setObjectClass(p.getProperty("OBJECT_CLASS"));
                    child.setIsLeaf(false);
                    child.setIsContainer(true);
                    childs.put(p.getProperty("DISTINGUISHED_NAME"), child);
                }
                object.setName(domainName);
                object.setRelativeName(rootPath);
                object.setObjectClass("domainDNS");
                if (ClientAuthorizationUtil.isAuthorized(request.getSession(), domainName, new Long(1808L)).booleanValue()) {
                    childs.put(((DirectoryObject)dirobjects.get(1)).getID(), dirobjects.get(1));
                }
                object.setChildObjects(childs);
                object.setIsLeaf(false);
                object.setIsContainer(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return object;
    }

    public static DirectoryObject getObject(DirectoryObject object, String dn) {
        Properties childObjects = object.getChildObjects();
        DirectoryObject ret = null;
        if (childObjects != null) {
            Enumeration<Object> e = childObjects.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                DirectoryObject obj = (DirectoryObject)childObjects.get(key);
                if (!dn.endsWith(key)) continue;
                if (key.equalsIgnoreCase(dn)) {
                    ret = obj;
                    return ret;
                }
                ret = DirectoryObjectUtil.getObject(obj, dn);
                if (ret == null) continue;
                break;
            }
        }
        return ret;
    }

    public static void getDirectoryObject(DirectoryObject object, String dn, Properties selectedDomain, Long loginId) {
        DirectoryObjectUtil.getDirectoryObject(object, dn, selectedDomain, loginId, null, false);
    }

    public static void getDirectoryObject(DirectoryObject object, String dn, Properties selectedDomain, Long loginId, ArrayList filter, boolean skipLeafCheck) {
        try {
            DirectoryObject directoryObject = DirectoryObjectUtil.getObject(object, dn);
            if (directoryObject.getChildObjects() == null) {
                DirectoryObject childObject = (DirectoryObject)ADHandler.getDomainObject((String)selectedDomain.getProperty("DOMAIN_NAME"), (Long)loginId, (String)dn, (ArrayList)filter, (boolean)skipLeafCheck);
                directoryObject.setChildObjects(childObject.getChildObjects());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

