/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.util.LicenseUtil;
import com.adventnet.sym.adsm.common.webclient.api.LicenseMgrAction;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.tools.prevalent.CMDClass;
import com.adventnet.tools.prevalent.LUtil;
import com.adventnet.tools.prevalent.Validation;
import com.adventnet.tools.prevalent.Wield;
import com.manageengine.ads.fw.license.LicenseManager;
import com.manageengine.ads.fw.license.LicenseXMLParser;
import com.manageengine.o365.server.admin.ManageLicenseHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.upload.FormFile;
import org.json.JSONObject;

public class LicenseUpgradeAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger("default");

    public ActionForward loadDetails(ActionMapping mapping, ActionForm fout, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String licenseType = Validation.getInstance().getUserType();
        HttpSession session = request.getSession();
        try {
            String isSDPAddon;
            String productExpiryDate;
            JSONObject jsonObj = new JSONObject();
            Validation w = Validation.getInstance();
            String productName = w.getProductName();
            if (productName.startsWith("AdventNet")) {
                productName = productName.replaceFirst("AdventNet ", "ZOHO Corp ");
            }
            if ((productExpiryDate = w.getEvaluationExpiryDate()).equalsIgnoreCase("never")) {
                productExpiryDate = rb.getString("client.util.LicenseUpgradeAction.never");
            }
            LicenseMgr.getInstance();
            String licenseType1 = LicenseMgr.getLicenseTypeString();
            licenseType = w.getUserType();
            long noOfDays = w.getEvaluationDays();
            Properties prop = CommonUtil.getProductInfo();
            String productVersion = prop.getProperty("version");
            String processor_architecture = prop.getProperty("processor_architecture") + " " + rb.getString("admp.upgradeLicense.license_upgrade.bit");
            String licenseMsg = "";
            String upgradeMsg = "";
            String noOfDaysToGo = String.valueOf(noOfDays);
            String numberOfDomains = "";
            String numberOfUsers = "";
            String maxUserCount = "";
            String organisation = "";
            String numberOfRequesters = "";
            String demoMsg = "";
            Boolean isDomainUserLicense = false;
            Boolean isWorkflowRequesterModuleLicensed = false;
            String licensedTo = w.getCompanyName();
            boolean isTrialLicense = false;
            boolean isFreeLicense = false;
            boolean flag = true;
            boolean sent = true;
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (licenseType1.equalsIgnoreCase("Enterprise")) {
                licenseType1 = "Professional";
            }
            if (licenseType != null && licenseType.equals("T")) {
                isTrialLicense = true;
                licenseType = rb.getString("client.util.LicenseUpgradeAction.evaluation_edition_trial_version");
                licenseMsg = MessageFormat.format(rb.getString("client.util.LicenseUpgradeAction.you_are_using_of_this_product_contact_sales_adventnet_com_if_you_wish_to_purchase_the_software"), licenseType);
                upgradeMsg = rb.getString("client.util.LicenseUpgradeAction.extend_your_trial_period_or_upgrade_to_the_registered_version_of_this_software_by_supplying_a_valid_license_file_obtained_from") + " ";
                organisation = "<a href=\"" + rb.getString("admp.upgradeLicense.license_upgrade.link.store_adventnet") + "\" target=\"_blank\">" + rb.getString("admp.upgradeLicense.license_upgrade.adventNet_inc") + " </a>";
            } else if (licenseType != null && licenseType.equals("F")) {
                isFreeLicense = true;
                licenseType = rb.getString("client.util.LicenseUpgradeAction.free_edition");
                noOfDaysToGo = rb.getString("client.util.LicenseUpgradeAction.Never");
                licenseMsg = MessageFormat.format(rb.getString("client.util.LicenseUpgradeAction.you_are_using_of_this_product_this_license_allows_you_to_manage_10_systems_and_will_expire_in_days_after_expiry_it_will_revert_to_the_free_edition_wherein_you_will_be_allowed_to_manage_only_10_systems_contact_sales_adventnet_com_if_you_wish_to_extend_the_trial_period_or_to_purchase_the_software"), licenseType, noOfDaysToGo);
                upgradeMsg = rb.getString("client.util.LicenseUpgradeAction.extend_your_trial_period_or_upgrade_to_the_registered_version_of_this_software_by_supplying_a_valid_license_file_obtained_from") + " ";
                organisation = "<a href=\"" + rb.getString("admp.upgradeLicense.license_upgrade.link.store_adventnet") + "\" target=\"_blank\">" + rb.getString("admp.upgradeLicense.license_upgrade.adventNet_inc") + " </a>";
                request.setAttribute("numberOfDomains", (Object)1);
            } else if (licenseType != null && licenseType.equals("R")) {
                licenseType = licenseType1 + " - " + rb.getString("client.util.LicenseUpgradeAction.registered_version");
                licenseMsg = MessageFormat.format(rb.getString("client.util.LicenseUpgradeAction.you_are_using_of_this_product_this_license_allows_you_to_manage_10_systems_and_will_expire_in_days_after_expiry_it_will_revert_to_the_free_edition_wherein_you_will_be_allowed_to_manage_only_10_systems_contact_sales_adventnet_com_if_you_wish_to_extend_the_trial_period_or_to_purchase_the_software"), licenseType, productExpiryDate);
                Properties numOfSystems = Validation.getInstance().getModuleProperties("Domains");
                numberOfDomains = numOfSystems.getProperty("NumberOfDomains");
                numberOfUsers = LicenseMgr.getInstance().getLicenseProperty("HelpDeskUsers", "NumberOfUsers");
                if (numberOfUsers == null) {
                    numberOfUsers = "0";
                }
                if ((numberOfRequesters = LicenseMgr.getInstance().getLicenseProperty("Workflow", "NumberOfRequesters")) == null) {
                    numberOfRequesters = "0";
                }
                upgradeMsg = numberOfDomains.equals("unlimited") ? rb.getString("client.util.LicenseUpgradeAction.renew_the_subscription_by_supplying_a_valid_license_file_obtained_from_AdventNet") + " " : rb.getString("client.util.LicenseUpgradeAction.upgrade_aDManager_plus_to_manage_more_domains_or_purchase_additional_helpdesk_technicians_or_renew_the_subscription_supply_a_valid_license_file_obtained_from_AdventNet") + " ";
                maxUserCount = LicenseMgr.getInstance().getLicenseProperty("ADMgmt", "NumberOfUsers");
                isDomainUserLicense = false;
                if (maxUserCount != null && !maxUserCount.equalsIgnoreCase("unlimited")) {
                    isDomainUserLicense = true;
                }
                isWorkflowRequesterModuleLicensed = false;
                String isWorkflowRequester = LicenseMgr.getInstance().getLicenseProperty("Workflow", LicenseUtil.WORKFLOW_REQUESTER);
                if (isWorkflowRequester == null) {
                    isWorkflowRequester = "false";
                }
                if (isWorkflowRequester.equalsIgnoreCase("true")) {
                    isWorkflowRequesterModuleLicensed = true;
                }
                Calendar cal = Calendar.getInstance();
                StringTokenizer stt = new StringTokenizer(productExpiryDate, " ");
                if (stt.countTokens() == 3) {
                    int yyyy = Integer.parseInt(stt.nextToken());
                    int mm = Integer.parseInt(stt.nextToken());
                    int dd = Integer.parseInt(stt.nextToken());
                    cal.set(yyyy, mm, dd);
                    SimpleDateFormat sdf = new SimpleDateFormat("MMM dd, yyyy");
                    productExpiryDate = sdf.format(cal.getTime());
                }
            }
            String isDemoMode = String.valueOf(CommonUtil.isDemo());
            if (isDemoMode.equals("true")) {
                demoMsg = "[Running in restricted Mode]";
            }
            String ret = "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.license_type") + "</td>";
            ret = ret + "<td><strong>" + licenseType + "</strong></td></tr>";
            Boolean isAWSImage = ADSMPersUtil.getSyMParameter((String)"isAWSImage") == null ? false : ADSMPersUtil.getSyMParameter((String)"isAWSImage").equalsIgnoreCase("true");
            if (!isAWSImage.booleanValue() && licensedTo != null && !licensedTo.isEmpty()) {
                ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.licensed_to") + "</td>";
                ret = ret + "<td>" + licensedTo + "</td></tr>";
            }
            ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.product_name") + "</td>";
            ret = ret + "<td>" + productName + "</td></tr>";
            ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.product_version") + "</td>";
            ret = ret + "<td>" + productVersion + "</td></tr>";
            ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.build_no") + "</td><td>" + CommonUtil.getBuildNumber() + "</td></tr>";
            ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.product_architecture") + "</td><td>" + processor_architecture + "</td></tr>";
            if (!(productExpiryDate == null || productExpiryDate.isEmpty() || isTrialLicense || isFreeLicense)) {
                ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.subscription_valid_till") + "</td>";
                ret = ret + "<td>" + productExpiryDate + "</td></tr>";
            }
            if (noOfDaysToGo != null && !noOfDaysToGo.isEmpty() && productExpiryDate != null && !productExpiryDate.equalsIgnoreCase(rb.getString("client.util.LicenseUpgradeAction.never")) && isTrialLicense && !isFreeLicense) {
                ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.days_to_expire") + "</td>";
                ret = ret + "<td>" + noOfDaysToGo + "</td></tr>";
            }
            if (!isDomainUserLicense.booleanValue() && numberOfDomains != null && !numberOfDomains.isEmpty()) {
                ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.number_of_domains") + "</td>";
                ret = ret + "<td>" + numberOfDomains + "</td></tr>";
                ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.number_of_help_desk_technicians") + "</td>";
                ret = ret + "<td>" + numberOfUsers + "</td></tr>";
            }
            if ((isSDPAddon = LicenseMgr.getInstance().getLicenseProperty("ServiceDeskUsers", "ServiceDesk")) != null && isSDPAddon.equalsIgnoreCase("true")) {
                String noOfSDPUsers = LicenseMgr.getInstance().getLicenseProperty("ServiceDeskUsers", "NumberOfServiceDeskUsers");
                if (noOfSDPUsers == null) {
                    noOfSDPUsers = "0";
                }
                ret = ret + "<tr><td>" + rb.getString("admp.upgradeLicense.license_upgrade.number_of_sdp_technicians") + "</td>";
                ret = ret + "<td>" + noOfSDPUsers + "</td></tr>";
            }
            jsonObj.put("message", (Object)ret);
            jsonObj.put("upgradeMsg", (Object)upgradeMsg);
            jsonObj.put("organisation", (Object)organisation);
            jsonObj.put("demoMsg", (Object)demoMsg);
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.log(Level.WARNING, "Exception while loading upgrade license page ", ex);
        }
        return null;
    }

    public ActionForward upgrade(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        try {
            String fileName = null;
            String licensePath = null;
            String upgradestatus = null;
            JSONObject licenseDetails = new JSONObject();
            DynaActionForm dynForm = (DynaActionForm)form;
            UploadedFileItem uploadedFileItem = null;
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                uploadedFileItem = (UploadedFileItem)filesList.get(0);
            }
            boolean isAdmpTechAvailableBeforeApply = CommonUtil.isAdmpTechAvailable();
            FormFile formFile = (FormFile)dynForm.get("browse");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
            fileName = uploadedFileItem.getFileName();
            try {
                licenseDetails = LicenseManager.getLicenseDetails();
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception while fetching license details: ", e);
            }
            if (fileName != null) {
                try {
                    licensePath = this.storeFile(fileName, formFile, request);
                }
                catch (Exception ex) {
                    logger.log(Level.WARNING, "Exception while storing the license file ", ex);
                }
            } else {
                upgradestatus = rb.getString("client.util.LicenseUpgradeAction.license_is_not_applied_properly_please_contact_sales_adventnet_com");
            }
            if (licensePath != null) {
                String successStatus;
                upgradestatus = LicenseUpgradeAction.upgradeLicense(request, fileName);
                if (!upgradestatus.equals(successStatus = rb.getString("admp.layout.license.upgrade.statmsg_license_upgraded_successfully")) && successStatus.equals(LicenseUpgradeAction.upgradeAD360License(request, licensePath))) {
                    upgradestatus = successStatus;
                    LicenseMgrAction.handleParentAppLicense(licensePath, licenseDetails);
                }
                if (upgradestatus.equals(successStatus)) {
                    LicenseManager.resetSentExpiryMail();
                }
            }
            PrintWriter writer = response.getWriter();
            writer.print(upgradestatus);
            LicenseMgr.getInstance();
            LicenseMgr.resetValues();
            boolean isAdmpTechAvailableAfterApply = CommonUtil.isAdmpTechAvailable();
            if (isAdmpTechAvailableBeforeApply != isAdmpTechAvailableAfterApply) {
                Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
                if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
                    ADMPAuthObject authObject = new ADMPAuthObject(loginId);
                    request.getSession().setAttribute("ADMP_AUTH_OBJECT", (Object)authObject);
                }
                if (!isAdmpTechAvailableAfterApply) {
                    Criteria crit = new Criteria(new Column("ADSMSearchProfile", "SEARCH_PROFILE_ID"), (Object)1L, 0);
                    DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMSearchProfile", crit);
                    Row r = obj.getFirstRow("ADSMSearchProfile");
                    r.set("IS_ENABLED", (Object)"0");
                    obj.updateRow(r);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(obj);
                }
            }
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Exception while upgrading the license file ", ex);
        }
        return null;
    }

    public static String upgradeLicense(HttpServletRequest request, String fileName) {
        String upgradestatus = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        String productHomeDir = System.getProperty("server.dir");
        try {
            String existing_license_dir = productHomeDir + File.separator;
            String new_license_dir = productHomeDir + File.separator + "bin" + File.separator + "license" + File.separator + fileName;
            LUtil.setLicenseDir((String)"lib");
            CMDClass cmd = new CMDClass();
            boolean success = false;
            Wield w = Wield.getInstance();
            Validation valid = Validation.getInstance();
            String user = (String)cmd.getUserList(new_license_dir).elementAt(0);
            success = w.doValidation(existing_license_dir, user, new_license_dir, false, true);
            String prodName = valid.getProductName();
            if (success) {
                valid.copyLicenseFile(existing_license_dir, new_license_dir);
                w.validateInvoke("AdventNet ManageEngine ADManager Plus");
                upgradestatus = rb.getString("admp.layout.license.upgrade.statmsg_license_upgraded_successfully");
                System.setProperty("licenseType", Validation.getInstance().getUserType());
                request.getSession().setAttribute("licenseType", (Object)Validation.getInstance().getUserType());
                ManageLicenseHandler.manageTenants(null);
            } else {
                w.validateInvoke("AdventNet ManageEngine ADManager Plus");
                upgradestatus = prodName == null || prodName.equalsIgnoreCase("") || prodName.equalsIgnoreCase("AdventNet ManageEngine ADManager Plus") ? "<span style=\"color:red;font-size:14px\">" + rb.getString("admp.layout.license.upgrade.statmsg_pls_enter_valid_license_file") + "</span>" : "<span style=\"color:red;font-size:14px\">" + MessageFormat.format(rb.getString("admp.layout.license.upgrade.statmsg_invalid_license_file"), prodName) + "</span>";
            }
        }
        catch (Exception ex) {
            upgradestatus = "<span style=\"color:red;font-size:14px\">" + rb.getString("admp.layout.license.upgrade.statmsg_pls_license_not_applied_properly") + "</span>";
            logger.log(Level.WARNING, "Exception while applying the license file ", ex);
        }
        return upgradestatus;
    }

    public static String upgradeAD360License(HttpServletRequest request, String licensePath) {
        String upgradeStatus = null;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            LicenseXMLParser xmlParser = new LicenseXMLParser(licensePath);
            if (xmlParser.isComponentPresent("ManageEngine ADManager Plus")) {
                logger.log(Level.INFO, "AD360 License : ADMP License is available! Going to upgrade ADMP");
                String admpLicense = xmlParser.getComponentLicense("ManageEngine ADManager Plus");
                LicenseManager licenseManager = new LicenseManager("ManageEngine ADManager Plus", admpLicense);
                String licenseFileLocation = licenseManager.getLicenseFileLocation();
                String licenseFileName = licenseFileLocation.substring(licenseFileLocation.lastIndexOf("\\") + 1);
                upgradeStatus = LicenseUpgradeAction.upgradeLicense(request, licenseFileName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            upgradeStatus = rb.getString("admp.layout.license.upgrade.statmsg_pls_enter_valid_license_file");
        }
        return upgradeStatus;
    }

    private String storeFile(String fileName, FormFile formFile, HttpServletRequest request) throws Exception {
        FileOutputStream fout = null;
        File saveFile = null;
        try {
            Object file;
            InputStream fileInputStream = null;
            UploadedFileItem uploadedFileItem = null;
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                uploadedFileItem = (UploadedFileItem)filesList.get(0);
                file = uploadedFileItem.getUploadedFile();
                fileInputStream = new FileInputStream((File)file);
            }
            InputStream fileInput = fileInputStream;
            file = new byte[fileInput.available()];
            fileInput.read((byte[])file);
            String currentPath = System.getProperty("user.dir");
            String directory = currentPath + File.separator + "license";
            File saveDir = new File(directory);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            saveFile = new File(directory + File.separator + fileName);
            fout = new FileOutputStream(saveFile);
            fout.write((byte[])file);
            fout.close();
            logger.log(Level.INFO, "The License File " + fileName + " stored successfully...");
            return saveFile.getAbsolutePath();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Exception while storing the licence file under license directory ", ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while storing the licence file under license directory ", ex);
            throw ex;
        }
    }
}

