/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.sym.adsm.common.server.ExchangeHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class MgmtClientUtil {
    public static void setPoliciesValues(HttpServletRequest request, ReportBean bean) {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request.getLocale());
        try {
            String previousDomainName;
            int i;
            String domainName = null;
            String[] domains = (String[])bean.get("domains");
            BeanMap props = (BeanMap)bean.get("props");
            Integer reportId = (Integer)bean.get("reportId");
            Long actionId = ClientUtil.getActionId(reportId);
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            ArrayList domainList = HDTDomainHandler.getDomainListForUser((Long)loginId, (Hashtable)domainVsactions, (Long)actionId);
            if (domains.length > 0) {
                boolean authDomain = false;
                String val = domains[0];
                if (val.endsWith("disable")) {
                    val = val.substring(0, val.lastIndexOf("disable"));
                }
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                domainName = (String)dnDomainNameMap.get(val);
                for (i = 0; i < domainList.size(); ++i) {
                    Properties propsVal = (Properties)domainList.get(i);
                    if (!propsVal.getProperty("DOMAIN_NAME").equalsIgnoreCase(domainName)) continue;
                    authDomain = true;
                    break;
                }
                if (!authDomain) {
                    Properties domainProp = (Properties)domainList.get(0);
                    domainName = domainProp.getProperty("DOMAIN_NAME");
                }
            }
            if (domainName == null) {
                Properties domainProps = (Properties)domainList.get(0);
                domainName = domainProps.getProperty("DOMAIN_NAME");
                for (int i2 = 0; i2 < domainList.size(); ++i2) {
                    Properties propsVal = (Properties)domainList.get(i2);
                    if (!propsVal.getProperty("IS_DEFAULT_DOMAIN").equalsIgnoreCase("true")) continue;
                    domainName = propsVal.getProperty("DOMAIN_NAME");
                }
            }
            if (!(previousDomainName = props.getProperty("previousDomainName")).equalsIgnoreCase(domainName)) {
                props.put("previousDomainName", domainName);
            }
            String[] tableNameArray = new String[]{"ADSMExchSharingPolicy", "ADSMExchRBACPolicy", "ADSMExchRetensionPolicy", "ADSMExchUMRecipientPolicy", "ADSMExchActiveSyncPolicy"};
            String[] nameArray = new String[]{"sharing", "role", "retension", "umpolicy", "activeSync"};
            i = 0;
            for (String tableName : tableNameArray) {
                HashMap<String, ArrayList<String>> map = MgmtClientUtil.getNameValues(tableName, domainName, rb);
                props.put("policyValues" + nameArray[i], map.get("dnNameList"));
                props.put("policyNames" + nameArray[i], map.get("serverNameList"));
                ++i;
            }
            ArrayList umPolicyDetails = new ArrayList();
            umPolicyDetails = ExchangeHandler.getExchangeUMPolicy((String)domainName);
            props.put("umPolicyDetails", umPolicyDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static HashMap<String, ArrayList<String>> getNameValues(String tableName, String domainName, AdventNetResourceBundle rb) {
        HashMap<String, ArrayList<String>> map = new HashMap<String, ArrayList<String>>();
        try {
            ArrayList policyDetails = new ArrayList();
            policyDetails = ExchangeHandler.getExchangePolicy((String)tableName, (String)domainName);
            ArrayList<String> dnNameList = new ArrayList<String>();
            ArrayList<String> serverNameList = new ArrayList<String>();
            dnNameList.add("--");
            serverNameList.add(rb.getString("usermanagement.terminal_environment.NA"));
            for (Properties propValue : policyDetails) {
                String dnName = propValue.get("distinguishedName").toString();
                String serverName = propValue.get("serverName").toString();
                dnName = ClientUtil.htmlEscape(dnName);
                dnNameList.add(dnName);
                serverNameList.add(serverName);
            }
            map.put("dnNameList", dnNameList);
            map.put("serverNameList", serverNameList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return map;
    }
}

