/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class MgmtUtil {
    private static Logger logger = Logger.getLogger("ADMangLogger");

    public static void resetPassword(String domainName, String sid, String dn, String samAccountName, String password, HttpServletRequest request, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (loginId == null) {
            loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
        ADMPAuthObject authObject = ClientUtil.getAuthObject(request);
        Hashtable domainVsIds = authObject.getDomainActionMap();
        if (!ClientUtil.checkAuthorization(domainVsIds, domainName, 1277L)) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        StringBuffer message = new StringBuffer();
        try {
            ADHandlerForMgmt.setPassword((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)password);
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = new StringBuffer(rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.error_changing_password") + le.getMessage(rb));
        }
        catch (Exception ex) {
            message = new StringBuffer(rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.error_changing_password") + ex.getMessage());
        }
        TechAuditAPI.getInstance().auditSingleAttributeModification(loginId, rb.getString("admp.mgmt.user_mgmt.reset_pwd.mgmtname.reset_password"), samAccountName, domainName, "password", password, message.toString(), rb.getString("admp.mgmt.user_mgmt.mgmtcategory.user_modification"), (Long)audit_info.get("object_id"), auditDataObj, rb);
        if (message.length() != 0) {
            throw new Exception(message.toString());
        }
    }

    public static void unlock(String domainName, String sid, String dn, String samAccountName, String password, HttpServletRequest request, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (loginId == null) {
            loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
        ADMPAuthObject authObject = ClientUtil.getAuthObject(request);
        Hashtable domainVsIds = authObject.getDomainActionMap();
        if (!ClientUtil.checkAuthorization(domainVsIds, domainName, 1103L)) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        StringBuffer message = new StringBuffer();
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        boolean userAccountControl = false;
        int andUserAccountControl = 0xFFFFFFF;
        if (userAccountControl || (andUserAccountControl &= 0xFFFFFEF) != 0xFFFFFFF) {
            Properties p1 = new Properties();
            p1.put("DATA_HANDLER_TYPE", new Long(10L));
            p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p1.put("ATTRIB_LDAP_NAME", "lockoutTime");
            p1.put("ATTRIB_VALUE", new Long(0L));
            setAttributeList.add(p1);
        }
        try {
            if (setAttributeList.size() != 0) {
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)samAccountName, setAttributeList, new ArrayList(), new ArrayList(), null, null);
            }
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(rb)));
        }
        catch (Exception e) {
            message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
        }
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.unlock_users.mgmtname.unlock_users"), samAccountName, domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        if (message.length() != 0) {
            throw new Exception(message.toString());
        }
    }

    public static void modifyPasswordAttributes(String domainName, String sid, String dn, String samAccountName, HashMap props, HttpServletRequest request, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Properties p;
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (loginId == null) {
            loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
        ADMPAuthObject authObject = ClientUtil.getAuthObject(request);
        Hashtable domainVsIds = authObject.getDomainActionMap();
        StringBuffer message = new StringBuffer();
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        ArrayList<Properties> modifyAttributeList = new ArrayList<Properties>();
        ArrayList<Properties> winNTProviderList = new ArrayList<Properties>();
        String mustChangePassword = (String)props.get("mustChangePassword");
        String cantChangePassword = (String)props.get("cantChangePassword");
        String passwordNeverExpires = (String)props.get("passwordNeverExpires");
        if (mustChangePassword != null) {
            if (ClientUtil.checkAuthorization(domainVsIds, domainName, 1201L)) {
                p = new Properties();
                p.put("DATA_HANDLER_TYPE", new Long(10L));
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", "pwdLastSet");
                if (mustChangePassword.equals("Yes")) {
                    try {
                        boolean checkCantChangePassword = ADHandlerForMgmt.checkCantChangePassword((String)domainName, (Long)loginId, (String)samAccountName, (String)dn);
                        boolean checkPasswordNeverExpires = ADHandlerForMgmt.checkPasswordNeverExpires((String)domainName, (Long)loginId, (String)sid, (String)dn);
                        logger.log(Level.INFO, "check native : checkCantChangePassword" + checkCantChangePassword);
                        logger.log(Level.INFO, "check native : checkPasswordNeverExpires" + checkPasswordNeverExpires);
                        if (MgmtUtil.checkUIOptions(props, "cantChangePassword") && checkCantChangePassword) {
                            throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.cant_set_change_pwd_next_logon_cannot_as_cant_change_pwd"));
                        }
                        if (MgmtUtil.checkUIOptions(props, "passwordNeverExpires") && checkPasswordNeverExpires) {
                            throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.statmsg.pwd_never_expires_set_so_cannot_set_change_pwd_next_logon"));
                        }
                        p.put("ATTRIB_VALUE", new Long(0L));
                        setAttributeList.add(p);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        message = new StringBuffer(e.getMessage());
                    }
                } else {
                    p.put("ATTRIB_VALUE", new Long(-1L));
                    setAttributeList.add(p);
                }
            } else {
                throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.alert.no_permission_modify_chagne_pwd_next_logon"));
            }
        }
        if (cantChangePassword != null && !cantChangePassword.equals("--")) {
            if (ClientUtil.checkAuthorization(domainVsIds, domainName, 1202L)) {
                p = new Properties();
                p.put("DATA_HANDLER_TYPE", new Long(3L));
                p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p.put("ATTRIB_LDAP_NAME", "userFlags");
                if (cantChangePassword.equals("Yes")) {
                    try {
                        if (MgmtUtil.checkUIOptions(props, "mustChangePassword") && ADHandlerForMgmt.checkUserMustChangePassword((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                            throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.alert.uncheck_the_change_pwd_next_logon_and_apply"));
                        }
                        p.put("ATTRIB_VALUE", String.valueOf(64));
                        winNTProviderList.add(p);
                    }
                    catch (Exception e) {
                        message = new StringBuffer(e.getMessage());
                    }
                } else {
                    p.put("ATTRIB_AND_VALUE", String.valueOf(-65));
                    winNTProviderList.add(p);
                }
            } else {
                throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.alert.no_permission_to_modify_cant_change_pwd"));
            }
        }
        if (passwordNeverExpires != null && !passwordNeverExpires.equals("--")) {
            if (ClientUtil.checkAuthorization(domainVsIds, domainName, 1203L)) {
                int userAccountControl = 0;
                int andUserAccountControl = 0xFFFFFFF;
                Properties p1 = new Properties();
                p1.put("DATA_HANDLER_TYPE", new Long(7L));
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("ATTRIB_LDAP_NAME", "userAccountControl");
                if (passwordNeverExpires.equals("Yes")) {
                    try {
                        if (MgmtUtil.checkUIOptions(props, "mustChangePassword") && ADHandlerForMgmt.checkUserMustChangePassword((String)domainName, (Long)loginId, (String)sid, (String)dn)) {
                            throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.alert.uncheck_the_change_pwd_next_logon_and_apply"));
                        }
                        p1.put("ATTRIB_VALUE", String.valueOf(userAccountControl |= 0x10000));
                        p1.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl));
                        modifyAttributeList.add(p1);
                    }
                    catch (Exception e) {
                        message = new StringBuffer(e.getMessage());
                    }
                } else {
                    p1.put("ATTRIB_VALUE", String.valueOf(userAccountControl));
                    p1.put("ATTRIB_AND_VALUE", String.valueOf(andUserAccountControl &= 0xFFEFFFF));
                    modifyAttributeList.add(p1);
                }
            } else {
                throw new Exception(rb.getString("admp.user_mgmt.hdt_reset_pwd.alert.no_permission_to_modify_pwd_never_expires"));
            }
        }
        logger.log(Level.INFO, "Modify User, Domain : " + domainName + " SID : " + sid + " AttributeList : " + setAttributeList + " modifyAttributeList : " + modifyAttributeList + " Win NT List : " + winNTProviderList);
        if (setAttributeList.size() != 0 || modifyAttributeList.size() != 0 || winNTProviderList.size() != 0) {
            try {
                ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)samAccountName, setAttributeList, modifyAttributeList, winNTProviderList, null, null);
                if (cantChangePassword.equals("Yes")) {
                    ArrayList<Properties> l = new ArrayList<Properties>();
                    Properties p2 = new Properties();
                    p2.put("DATA_HANDLER_TYPE", new Long(10L));
                    p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p2.put("ATTRIB_LDAP_NAME", "pwdLastSet");
                    p2.put("ATTRIB_VALUE", new Long(-1L));
                    l.add(p2);
                    try {
                        ADHandlerForMgmt.modifyUser((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)samAccountName, l, new ArrayList(), new ArrayList(), null, null);
                    }
                    catch (Exception ex) {
                        System.out.println("RPL:::Error in updating the pwdLastSet ");
                        ex.printStackTrace();
                    }
                }
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), le.getMessage(rb)));
            }
            catch (Exception e) {
                message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.common.statmsg.unable_to_modify_user_error"), e.getMessage()));
            }
        }
        TechAuditAPI.getInstance().auditUserModification(loginId, rb.getString("admp.mgmt.user_mgmt.reset_pwd.mgmtname.password_options"), samAccountName, domainName, setAttributeList, modifyAttributeList, winNTProviderList, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        if (message.length() != 0) {
            throw new Exception(message.toString());
        }
    }

    private static boolean checkUIOptions(HashMap props, String str) {
        String val = (String)props.get(str);
        return val == null || val.equals("--");
    }

    public static String checkAndCreateParent(String domainName, String parentDN, Long loginId) {
        return MgmtUtil.checkAndCreateParent(domainName, parentDN, loginId, true);
    }

    public static String checkAndCreateParent(String domainName, String parentDN, Long loginId, boolean isCreateNewOUActionAuthorized) {
        try {
            long error = ADHandler.checkOU((String)domainName, (Long)loginId, (String)parentDN);
            if (error == 0L) {
                return parentDN;
            }
            String parentParentDN = StrUtil.getContainerDNFromDN((String)parentDN);
            if (parentParentDN.equals("")) {
                return null;
            }
            String parentVal = MgmtUtil.checkAndCreateParent(domainName, parentParentDN, loginId, isCreateNewOUActionAuthorized);
            String oUName = StrUtil.getNameFromDN((String)parentDN);
            if (oUName != null && parentVal != null && isCreateNewOUActionAuthorized) {
                ADHandler.createOU((String)domainName, (Long)loginId, (String)"organizationalUnit", (String)oUName, (String)parentVal, new ArrayList());
                String createdVal = "OU=" + CommonUtil.escapeString((String)oUName, (String[])UserMgmtUtil.USERNAME_ESCAPE_CHARECTERS) + "," + parentVal;
                return createdVal;
            }
        }
        catch (Exception ex) {
            System.out.println("Error in checkOU ");
            ex.printStackTrace();
        }
        return null;
    }

    public static void setEmptyFieldsMessage(HttpServletRequest request, ReportBean bean, String[] actions, String[] actionLabels) {
        try {
            String emptyFields = "";
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            List<String> selectedAttributes = Arrays.asList((String[])bean.get("selectedAttributes"));
            BeanMap props = (BeanMap)bean.get("props");
            for (int i = 0; i < actions.length; ++i) {
                String beanValue;
                if (!selectedAttributes.contains(actions[i]) || !(beanValue = props.getProperty(actions[i])).equals("")) continue;
                emptyFields = emptyFields.length() == 0 ? rb.getString(actionLabels[i]) : emptyFields + "," + rb.getString(actionLabels[i]);
            }
            if (emptyFields.length() != 0) {
                emptyFields = MessageFormat.format(rb.getString("admp.mgmt.common.confirm.blank_values_cleared_in_ad_want_to_continue"), emptyFields);
                request.setAttribute("emptyFields", (Object)emptyFields);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void resetComputer(String domainName, String sid, String dn, String objectName, String password, HttpServletRequest request, Hashtable audit_info, DataObject auditDataObj) throws Exception {
        Long loginId = (Long)request.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (loginId == null) {
            loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        }
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(loginId);
        ADMPAuthObject authObject = ClientUtil.getAuthObject(request);
        Hashtable domainVsIds = authObject.getDomainActionMap();
        if (!ClientUtil.checkAuthorization(domainVsIds, domainName, 1290L)) {
            throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
        }
        StringBuffer message = new StringBuffer();
        try {
            ADHandlerForMgmt.setPassword((String)domainName, (Long)loginId, (String)sid, (String)dn, (String)password);
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = new StringBuffer(rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.unable_restore_computer") + le.getMessage(rb));
        }
        catch (Exception ex) {
            message = new StringBuffer(rb.getString("admp.mgmt.comp_mgmt.restore_comp.statmsg.unable_restore_computer") + ex.getMessage());
        }
        TechAuditAPI.getInstance().auditSingleAttributeModification(loginId, rb.getString("admp.mgmt.comp_mgmt.del_comps.mgmtname.reset_comps"), objectName, domainName, "password", "********", message.toString(), rb.getString("admp.workflow.create_request.sub_category.computer_modification"), (Long)audit_info.get("object_id"), auditDataObj, rb);
        if (message.length() != 0) {
            throw new Exception(message.toString());
        }
    }

    public static void updateMailServer(ArrayList propList, Properties exchProps) {
        String legacyDN = (String)exchProps.get("LEGACY_EXCHANGE_DN");
        for (int i = 0; i < propList.size(); ++i) {
            Hashtable propAttributeHash = (Hashtable)propList.get(i);
            String attribColumnName = (String)propAttributeHash.get("ATTRIB_COLUMN_NAME");
            if (attribColumnName == null || !attribColumnName.equalsIgnoreCase("MAIL_SERVER") || legacyDN.equals((String)propAttributeHash.get("ATTRIB_VALUE"))) continue;
            propAttributeHash.put("ATTRIB_VALUE", legacyDN);
            logger.log(Level.INFO, "Updating MAIL_SERVER value to ::" + legacyDN);
            break;
        }
    }

    public static String checkForValidPath(String moveFrom, String moveTo, AdventNetResourceBundle rb) {
        String message = "";
        try {
            Path startPath = Paths.get(moveFrom, new String[0]);
            Path destinationPath = Paths.get(moveTo, new String[0]);
            if (!Files.exists(destinationPath, new LinkOption[0])) {
                if (moveTo.toLowerCase().contains(moveFrom.toLowerCase())) {
                    message = rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.can_t_move_within_the_existing_homefolder");
                }
                return message;
            }
            if (Files.isSameFile(startPath, destinationPath)) {
                message = rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.successfully_moved_homefolder_same");
                return message;
            }
            while (destinationPath != null) {
                if (!Files.isSameFile(startPath, destinationPath = destinationPath.getParent())) continue;
                message = rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.can_t_move_within_the_existing_homefolder");
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message;
    }
}

