/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.layout.FcJSONUtility;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.csv.CSVUserBean;
import com.adventnet.sym.adsm.common.webclient.reports.ReportBean;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONObject;

public class ReportClientUtil {
    protected static Logger logger = Logger.getLogger("ADMangLogger");
    public static Long REPORT_RUN_STATUS_SUCCESS = 1L;
    private static String[] ids = new String[]{"80070005", "License"};

    public static Long copyUserResult(ReportBean bean, Integer reportId, Criteria c, String srcTableName, Long generationId, String targetTableName, Long loginId) throws Exception {
        Long id = null;
        try {
            id = ReportHandler.addReportGenerationDetails((Integer)reportId, (String)"Mgmt Action from Reports", (Long)loginId);
            Criteria crit = new Criteria(new Column(srcTableName, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            if (c != null) {
                crit = crit.and(c);
            }
            String tableKey = "OBJECT_GUID";
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)srcTableName));
            sq.addSelectColumn(Column.getColumn((String)srcTableName, (String)"*"));
            sq.setCriteria(crit);
            ArrayList tableNames = (ArrayList)bean.get("searchTableNames");
            for (int i = 0; tableNames != null && i < tableNames.size(); ++i) {
                String tableName = (String)tableNames.get(i);
                Join join = new Join(new Table(srcTableName), new Table(tableName), new String[]{tableKey}, new String[]{tableKey}, 2);
                sq.addJoin(join);
            }
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
            DataObject o = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Iterator it = obj.getRows(srcTableName);
            int count = 0;
            ArrayList<Object> objList = new ArrayList<Object>();
            while (it.hasNext()) {
                ++count;
                Row r = (Row)it.next();
                Row r1 = new Row(targetTableName);
                if (objList.contains(r.get("OBJECT_GUID"))) continue;
                r1.set("OBJECT_GUID", r.get("OBJECT_GUID"));
                r1.set("REPORT_GENERATION_ID", (Object)id);
                o.addRow(r1);
                objList.add(r.get("OBJECT_GUID"));
            }
            if (count <= 0) {
                throw new IllegalArgumentException("No Result Available.");
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(o);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "New GenerationId after copy the row in result table is : " + id);
        return id;
    }

    public static Long copyUserResult(ArrayList selectedSidList, Integer reportId, String targetTableName, Long loginId, String description) throws Exception {
        Long newgenerationId = null;
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            newgenerationId = ReportHandler.addReportGenerationDetails((Integer)reportId, (Long)new Long(0L), (String)description, (Long)loginId, (DataObject)dataObj);
            int i = 0;
            for (i = 0; i < selectedSidList.size(); ++i) {
                Row r1 = new Row(targetTableName);
                r1.set("OBJECT_GUID", selectedSidList.get(i));
                r1.set("REPORT_GENERATION_ID", (Object)newgenerationId);
                dataObj.addRow(r1);
            }
            if (selectedSidList.size() <= 0) {
                throw new IllegalArgumentException("No Result Available.");
            }
            System.out.println("Total no: of objects that are moved from reports to mgmt is : " + i);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newgenerationId;
    }

    public static JSONArray getAllSidForGenerationId(String tableName, Long generationId) {
        JSONArray arrayObject = new JSONArray();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            Iterator iterator = dataObject.getRows(tableName);
            while (iterator.hasNext()) {
                Row guidRow = (Row)iterator.next();
                arrayObject.put(guidRow.get("OBJECT_GUID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayObject;
    }

    public static Long copyUserResult(ReportBean bean, Integer reportId, String srcTableName, Long generationId, String targetTableName, Long loginId) throws Exception {
        Long id = null;
        id = ReportHandler.addReportGenerationDetails((Integer)reportId, (String)"Mgmt Action from Reports", (Long)loginId);
        try {
            String checkAllUsers = (String)bean.get("checkAllUsers");
            bean.set("selectAllUsers", checkAllUsers);
            if (checkAllUsers.equalsIgnoreCase("true")) {
                bean.set("searchSIDs", new ArrayList());
            }
            ArrayList searchSIDs = (ArrayList)bean.get("searchSIDs");
            ArrayList<Object> searchList = new ArrayList<Object>();
            ArrayList<Object> sidList = new ArrayList<Object>();
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Criteria searchCriteria = (Criteria)bean.get("searchCriteria");
            Criteria crit = new Criteria(new Column(srcTableName, "REPORT_GENERATION_ID"), (Object)generationId, 0);
            ArrayList deSelectedSearchSIDs = (ArrayList)bean.get("deSelectedSearchSIDs");
            if (searchSIDs.size() == 0 && searchCriteria != null) {
                ArrayList tableNames = (ArrayList)bean.get("searchTableNames");
                String tableKey = "OBJECT_GUID";
                if (searchCriteria != null) {
                    crit = crit.and(searchCriteria);
                }
                Table baseTableName = new Table(srcTableName);
                SelectQueryImpl sq = new SelectQueryImpl(baseTableName);
                if (bean.get("searchTableNames") != null) {
                    for (int i = 0; i < tableNames.size(); ++i) {
                        String tableName = (String)tableNames.get(i);
                        Join join = new Join(new Table(srcTableName), new Table(tableName), new String[]{tableKey}, new String[]{tableKey}, 2);
                        sq.addJoin(join);
                    }
                }
                sq.setCriteria(crit);
                sq.addSelectColumn(new Column(srcTableName, "OBJECT_GUID"));
                sq.addSelectColumn(new Column(srcTableName, "REPORT_GENERATION_ID"));
                DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)sq);
                Iterator it = obj.getRows(srcTableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    if (searchList.contains(r.get("OBJECT_GUID")) || deSelectedSearchSIDs.contains(r.get("OBJECT_GUID"))) continue;
                    searchList.add(r.get("OBJECT_GUID"));
                }
                if (searchList.size() == 0) {
                    checkAllUsers = "false";
                    ReportClientUtil.getDefaultSearchList(srcTableName, crit, searchList);
                }
            } else if (searchSIDs.size() == 0 && checkAllUsers.equalsIgnoreCase("false")) {
                ReportClientUtil.getDefaultSearchList(srcTableName, crit, searchList);
            } else if (searchSIDs.size() == 0 && checkAllUsers.equalsIgnoreCase("true")) {
                DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(srcTableName, crit);
                Iterator it = obj.getRows(srcTableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    if (searchList.contains(r.get("OBJECT_GUID")) || deSelectedSearchSIDs.contains(r.get("OBJECT_GUID"))) continue;
                    searchList.add(r.get("OBJECT_GUID"));
                }
            }
            if (searchList.size() > 0) {
                sidList.addAll(searchList);
            } else {
                sidList.addAll(searchSIDs);
            }
            for (int i = 0; i < sidList.size(); ++i) {
                Row r1 = new Row(targetTableName);
                r1.set("OBJECT_GUID", sidList.get(i));
                r1.set("REPORT_GENERATION_ID", (Object)id);
                dataObj.addRow(r1);
            }
            if (sidList.size() <= 0) {
                throw new IllegalArgumentException("No Result Available.");
            }
            System.out.println("Total no: of objects that are moved from reports to mgmt is : " + sidList.size());
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return id;
    }

    public static void copyUserCreationId(Long oldUserCreationId, Long newUserCreationId, Criteria filterCriteria, ArrayList<Hashtable> attributeList) {
        ArrayList userDetailsList = new ArrayList();
        Hashtable userDetails = null;
        try {
            Criteria criteria = new Criteria(new Column(CSVUserBean.USER_ATTRIBUTE_TABLE, "USER_CREATION_ID"), (Object)oldUserCreationId, 0);
            if (filterCriteria != null) {
                criteria = criteria.and(filterCriteria);
            }
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(CSVUserBean.USER_ATTRIBUTE_TABLE, criteria);
            Iterator iterator = dataObject.getRows(CSVUserBean.USER_ATTRIBUTE_TABLE);
            while (iterator.hasNext()) {
                userDetails = new Hashtable();
                Row row = (Row)iterator.next();
                int index = 0;
                for (Hashtable hashtable : attributeList) {
                    String ldapName = (String)hashtable.get("ATTRIB_LDAP_NAME");
                    Integer relationalType = (Integer)hashtable.get("RELATIONAL_TYPE");
                    String columnName = hashtable.get("ATTRIB_COLUMN_NAME").toString();
                    if (relationalType != 1) {
                        Object object = row.get(columnName);
                        userDetails.put(hashtable.get("ATTRIB_COLUMN_NAME"), object);
                    }
                    ++index;
                }
                userDetailsList.add(userDetails);
            }
            if (userDetailsList.isEmpty()) {
                throw new IllegalArgumentException("No Result Available.");
            }
            AddUserHandler.getInstance().addUserDetailsList(newUserCreationId, userDetailsList, attributeList, new ArrayList());
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException(ex.getMessage());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            logger.log(Level.INFO, "Exception occurs while copy the existing import details in AdsmAuNamingAttributes table.");
        }
    }

    public static void getDefaultSearchList(String srcTableName, Criteria crit, ArrayList searchList) {
        try {
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(srcTableName, crit);
            Iterator it = obj.getRows(srcTableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                if (searchList.contains(r.get("OBJECT_GUID"))) continue;
                searchList.add(r.get("OBJECT_GUID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void checkAndSetSelectAllObjectGUIDs(HttpServletRequest request, ReportBean bean) {
        try {
            String selectAllUsers = request.getParameter("selectAllUsersStr");
            ArrayList deSelectedSIDs = (ArrayList)bean.get("deSelectedSIDs");
            ArrayList selectedSIDs = (ArrayList)bean.get("selectedSIDs");
            if (selectAllUsers != null && !selectAllUsers.equals("")) {
                if (selectAllUsers.equals("true")) {
                    deSelectedSIDs.clear();
                } else if (selectAllUsers.equals("false")) {
                    selectedSIDs.clear();
                }
                bean.set("selectAllUsers", selectAllUsers);
                bean.set("checkAllUsers", selectAllUsers);
            }
            String[] selectedSIDsStr = request.getParameterValues("selectedSIDsStr");
            ArrayList<String> currentlySelected = new ArrayList<String>();
            for (int i = 0; selectedSIDsStr != null && i < selectedSIDsStr.length; ++i) {
                int index;
                currentlySelected.add(selectedSIDsStr[i]);
                if (!selectedSIDs.contains(selectedSIDsStr[i])) {
                    selectedSIDs.add(selectedSIDsStr[i]);
                }
                if ((index = deSelectedSIDs.indexOf(selectedSIDsStr[i])) == -1) continue;
                deSelectedSIDs.remove(index);
            }
            String deSelectedSIDsStr = request.getParameter("deSelectedSIDsStr");
            if (deSelectedSIDsStr != null) {
                StringTokenizer token = new StringTokenizer(deSelectedSIDsStr, ",");
                while (token.hasMoreTokens()) {
                    String objectGuid = (String)token.nextElement();
                    if (currentlySelected.contains(objectGuid)) continue;
                    if (!deSelectedSIDs.contains(objectGuid)) {
                        deSelectedSIDs.add(objectGuid);
                    }
                    if (!selectedSIDs.contains(objectGuid)) continue;
                    selectedSIDs.remove(objectGuid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Column getSortColumn(String resultTableName, String columnName, ArrayList attributeList) {
        for (int i = 0; i < attributeList.size(); ++i) {
            Properties p = (Properties)attributeList.get(i);
            if (!p.get("ATTRIB_COLUMN_NAME").equals(columnName)) continue;
            return new Column((String)p.get("TABLE_NAME"), (String)p.get("ATTRIB_COLUMN_NAME"));
        }
        return new Column(resultTableName, "MESSAGE");
    }

    public static String getBulkModificationTSTID(ArrayList list) {
        Hashtable idsCount = new Hashtable();
        for (int j = 0; j < list.size(); ++j) {
            Hashtable prop = (Hashtable)list.get(j);
            String message = (String)prop.get("MESSAGE");
            if (message == null) continue;
            for (int i = 0; i < ids.length; ++i) {
                if (message.contains(ids[i])) {
                    ReportClientUtil.putIDCount(idsCount, ids[i]);
                    continue;
                }
                int index = message.indexOf(" Error Code : ");
                if (index <= 0 || (index = message.indexOf(":", index)) <= 0) continue;
                String str = message.substring(index + 2);
                ReportClientUtil.putIDCount(idsCount, str);
            }
        }
        int maxCount = 0;
        String id = null;
        Enumeration e = idsCount.keys();
        while (e.hasMoreElements()) {
            String s = (String)e.nextElement();
            Integer c = (Integer)idsCount.get(s);
            if (c <= maxCount) continue;
            maxCount = c;
            id = s;
        }
        return id;
    }

    private static void putIDCount(Hashtable hash, String str) {
        Integer count = (Integer)hash.get(str);
        if (count == null) {
            count = new Integer(1);
            hash.put(str, count);
        } else {
            count = new Integer(count + 1);
            hash.put(str, count);
        }
    }

    public static boolean showActions(HttpServletRequest request, DynaValidatorForm bean) {
        String operation = (String)request.getAttribute("operation");
        String inputSource = (String)bean.get("inputSource");
        boolean show = false;
        if (operation == null || operation.equals("import") || operation.equals("reportAction") || operation.equals("nextMgmtAction") || (inputSource.equals("csv") || inputSource.equals("reports")) && operation.equals("showList")) {
            show = true;
            request.setAttribute("validateUI", (Object)"true");
        }
        return show;
    }

    public static void updateBeanWithOU(DynaValidatorForm bean, Long loginId, String defaultNamingContext, String[] ouDNs) {
        ArrayList domainList = (ArrayList)bean.get("domainList");
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            String defaultNamingCtxt = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
            if (!defaultNamingCtxt.equalsIgnoreCase(defaultNamingContext)) continue;
            String domainName = domainProp.getProperty("DOMAIN_NAME");
            for (int k = 0; k < ouDNs.length; ++k) {
                boolean exists = false;
                ArrayList ouList = (ArrayList)domainProp.get("ouList");
                for (int j = 0; j < ouList.size(); ++j) {
                    Properties ouProp = (Properties)ouList.get(j);
                    String dn = ouProp.getProperty("DISTINGUISHED_NAME");
                    if (!dn.equalsIgnoreCase(ouDNs[k])) continue;
                    exists = true;
                    break;
                }
                if (exists || defaultNamingContext.equalsIgnoreCase(ouDNs[k])) continue;
                Properties ouProp = ClientUtil.getOUDetails(domainName, ouDNs[k], loginId);
                ouList.add(ouProp);
                Hashtable dnDomainNameMap = (Hashtable)bean.get("dnDomainNameMap");
                dnDomainNameMap.put(ouDNs[k], domainName);
            }
        }
    }

    public static void checkOUWithBeanUpdateOUBaseTable(DynaValidatorForm bean, Long loginId, String defaultNamingContext, String[] ouDNs) {
        ArrayList domainList = (ArrayList)bean.get("domainList");
        for (int i = 0; i < domainList.size(); ++i) {
            Properties domainProp = (Properties)domainList.get(i);
            String defaultNamingCtxt = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
            if (!defaultNamingCtxt.equalsIgnoreCase(defaultNamingContext)) continue;
            String domainName = domainProp.getProperty("DOMAIN_NAME");
            for (int k = 0; k < ouDNs.length; ++k) {
                boolean exists = false;
                ArrayList ouList = (ArrayList)domainProp.get("ouList");
                for (int j = 0; j < ouList.size(); ++j) {
                    Properties ouProp = (Properties)ouList.get(j);
                    String dn = ouProp.getProperty("DISTINGUISHED_NAME");
                    if (!dn.equalsIgnoreCase(ouDNs[k])) continue;
                    exists = true;
                    break;
                }
                if (exists || defaultNamingContext.equalsIgnoreCase(ouDNs[k])) continue;
                try {
                    System.out.println("Going to trigger OU sync " + Arrays.asList(ouDNs));
                    DomainHandler.updateDomainDatas((String)domainName, (Long)loginId, (String[])new String[]{"OU"}, (boolean)true);
                    System.out.println("OUSync trigger complete ");
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static JSONObject getFieldJsonobJsonObject(Hashtable hashTable, String domainName) {
        JSONObject fieldDetailsJSONObject = new JSONObject();
        try {
            fieldDetailsJSONObject.put("domainName", (Object)domainName);
            fieldDetailsJSONObject.put("componentId", (Object)((Long)hashTable.get("DEFAULT_COMPONENT_ID")));
            fieldDetailsJSONObject.put("isDomainSpecificField", (Object)((Boolean)hashTable.get("IS_DOMAIN_SPECIFIC_FIELD")));
            fieldDetailsJSONObject.put("domainSpecificDataProviderClassName", (Object)((String)hashTable.get("DOMAIN_SPECIFIC_DP_CLASS")));
            fieldDetailsJSONObject.put("taskId", (Object)((Long)hashTable.get("MENU_ID")));
            fieldDetailsJSONObject.put("taskDetailsId", (Object)((Long)hashTable.get("MENU_ID")));
            fieldDetailsJSONObject.put("moduleName", (Object)"ReportsToDirectManagement");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fieldDetailsJSONObject;
    }

    public static Long getPageNavigationScriptConfigId(Integer reportId) {
        Long pageNavigationScriptConfigId = 2L;
        if (reportId.compareTo(40) == 0) {
            pageNavigationScriptConfigId = 1L;
        }
        return pageNavigationScriptConfigId;
    }

    public static JSONObject getDefaultNavigationConfig(Long loginId) {
        JSONObject jsonObject = new JSONObject();
        try {
            ArrayList rangeList = NavigateRangeUtil.getRangeListForModule((String)"ReportResult");
            int range = NavigateRangeUtil.getDefaultRange((String)"ReportResult", (Long)loginId);
            jsonObject.put("startIndex", 1);
            jsonObject.put("toIndex", range);
            jsonObject.put("range", range);
            jsonObject.put("rangeList", (Object)FcJSONUtility.getJSONArray((ArrayList)rangeList));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return jsonObject;
    }
}

