/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.util.ajax;

import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxMessageObject;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxResponse;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class AjaxUtil {
    private static final Logger LOGGER = Logger.getLogger(AjaxUtil.class.getName());

    public static String getResponse(String module, Object obj) {
        try {
            AjaxResponse ajr = new AjaxResponse();
            ajr.add(new AjaxMessageObject(module, obj));
            return ajr.toString();
        }
        catch (Exception e) {
            LOGGER.warning("Exception in getResponse = " + e.getMessage());
            return null;
        }
    }

    public static String getResponse(String module, Object obj, String type) {
        try {
            AjaxResponse ajr = new AjaxResponse();
            ajr.add(new AjaxMessageObject(module, type, obj));
            return ajr.toString();
        }
        catch (Exception e) {
            LOGGER.warning("Exception in getResponse for type = " + e.getMessage());
            return null;
        }
    }

    public static String getErrorResponse(String module, String errorMsg, Exception exp) {
        try {
            Hashtable<String, String> error = new Hashtable<String, String>();
            error.put("errorMessage", errorMsg);
            error.put("exception", exp.getMessage());
            AjaxResponse ajr = new AjaxResponse();
            ajr.add(new AjaxMessageObject(module, "error", error));
            return ajr.toString();
        }
        catch (Exception e) {
            LOGGER.warning("Exception in getErrorResponse of string = " + e.getMessage());
            return null;
        }
    }

    public static String getErrorResponse(String module, Object errorMsg, Exception exp) {
        try {
            Hashtable<String, Object> error = new Hashtable<String, Object>();
            error.put("errorMessage", errorMsg);
            error.put("exception", exp.getMessage());
            AjaxResponse ajr = new AjaxResponse();
            ajr.add(new AjaxMessageObject(module, "error", error));
            return ajr.toString();
        }
        catch (Exception e) {
            LOGGER.warning("Exception in getErrorResponse of Object = " + e.getMessage());
            return null;
        }
    }

    public static String getSuccessResponse(String module, String message) {
        try {
            Hashtable<String, String> msg = new Hashtable<String, String>();
            msg.put("message", message);
            AjaxResponse ajr = new AjaxResponse();
            ajr.add(new AjaxMessageObject(module, "success", msg));
            return ajr.toString();
        }
        catch (Exception e) {
            LOGGER.warning("Exception in getSuccessResponse = " + e.getMessage());
            return null;
        }
    }

    public static boolean writeResponse(HttpServletResponse response, String str) {
        try {
            response.getOutputStream().print(str);
        }
        catch (Exception exp) {
            return false;
        }
        return true;
    }

    public static boolean writeJsonResponse(HttpServletResponse response, String str) {
        try {
            response.setContentType("application/json");
            AjaxUtil.writeResponse(response, str);
        }
        catch (Exception exp) {
            return false;
        }
        return true;
    }

    public static JSONArray getJsonArrayFromList(ArrayList<Hashtable> hashTableOfList) {
        JSONArray jsonArray = new JSONArray();
        try {
            for (Hashtable hash : hashTableOfList) {
                Enumeration enumeration = hash.keys();
                JSONObject jsonObject = new JSONObject();
                while (enumeration.hasMoreElements()) {
                    String key = (String)enumeration.nextElement();
                    jsonObject.put(key, hash.get(key));
                }
                jsonArray.put((Object)jsonObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jsonArray;
    }
}

