/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.SidTableUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class O365HideAddresslistMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    int operationId;
    boolean isAuthorised = false;
    String usageLocation = "";
    String country = "";
    ArrayList<Properties> licenseDetails = new ArrayList();
    ArrayList auditPropList = new ArrayList();
    ArrayList<String> servicePlanNames = new ArrayList();
    boolean hidefromAddresslist = false;
    Integer selectedObjectsView = -1;
    boolean isDirSync = false;
    String domainName = "";

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            Thread action;
            String hide;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_HIDE_LISTS_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.isAuthorised = this.isAuthorized(tenantId, request);
            this.selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "o365user";
            this.baseTableName = "O365UserGeneralDetails";
            this.tableKey = "OBJECT_ID";
            this.initAttributeList(reportId);
            ArrayList o365PropsList = DomainInfoCache.getInstance().getO356AccountProperties();
            for (Properties o365Prop : o365PropsList) {
                if (o365Prop.isEmpty() || !o365Prop.containsValue(this.tenantId)) continue;
                this.isDirSync = (Boolean)o365Prop.get("IS_DIR_SYNC_ENABLED");
                break;
            }
            if ((hide = inputJsonObj.getString("hideListsO365")).equalsIgnoreCase("Yes")) {
                hide = "True";
                this.hidefromAddresslist = true;
            } else {
                hide = "False";
                this.hidefromAddresslist = false;
            }
            this.domainName = inputJsonObj.getString("domainName");
            Hashtable<String, String> inputDetails = new Hashtable<String, String>();
            inputDetails.put("HIDDEN_TO_ADDRESSLISTS", hide);
            String operation = "";
            Properties operationProp = new Properties();
            operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.hide_frm_exch_addr_list"));
            operationProp.put("ATTRIB_VALUE", inputJsonObj.getString("hideListsO365"));
            this.auditPropList.add(operationProp);
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (this.selectedObjectsView < 2) {
                action = new O365AbstractListener.ModifyMailAction(generationId, selectedUsersList, true, request.getRemoteHost());
                action.start();
            } else {
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                action = new O365AbstractListener.ModifyMailCSVAction(generationId, selectedUsersList, headerJsonArray, true, userCreationID, request.getRemoteHost());
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_HIDE_LISTS_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (this.selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
                json.put("selectedUsersList", (Object)selectedUsersList);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail) {
        String result = "";
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                String value = "";
                String dn = null;
                if (this.isDirSync) {
                    String[] arr = new String[]{uniqueValue};
                    String val = "";
                    if (uniqueValueNativeParamName.equalsIgnoreCase("UserPrincipalName")) {
                        val = "USER_PRINCIPAL_NAME";
                    } else if (uniqueValueNativeParamName.equalsIgnoreCase("ObjectId")) {
                        val = "OBJECT_ID";
                    }
                    value = O365MgmtHandler.getValueAsString((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID", (String)val, (String[])arr);
                }
                if (value.length() > 0 && !value.equals("-")) {
                    Properties objProps = SidTableUtil.getSidFromGuid((String)this.domainName, (String)value.toUpperCase());
                    if (objProps != null && !objProps.isEmpty()) {
                        value = (String)objProps.get("SID_STRING");
                        dn = (String)objProps.get("DN_STRING");
                    } else {
                        value = "";
                    }
                }
                PowerShellCommand powerShellCommand = new PowerShellCommand();
                if (this.isAuthorised) {
                    if (value.length() > 0 && !value.equals("-")) {
                        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                        setAttributeList.add(this.getAttributeProps("msExchHideFromAddressLists", String.valueOf(this.hidefromAddresslist).toUpperCase()));
                        ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)this.loginId, (String)value, (String)dn, setAttributeList, new ArrayList(), new ArrayList(), null);
                        result = this.rb.getString("admp.mgmt.common.statmsg.successfully_dirsync_o365");
                    } else {
                        powerShellCommand = new PowerShellCommand("Set-Mailbox");
                        powerShellCommand.setIdentity(uniqueValue);
                        powerShellCommand.addParameter("HiddenFromAddressListsEnabled", this.hidefromAddresslist);
                        if (this.selectedObjectsView >= 2) {
                            userDetail = new Properties();
                        }
                        PowerShellCommand getCommand = new PowerShellCommand("Get-Mailbox");
                        getCommand.addParameter("Identity", uniqueValue);
                        String res = ADHandler.updateO365Mailboxes((String)this.tenantId, (String)this.tenantPwd, (String)powerShellCommand.toString(), (String)getCommand.toString(), (int)1, (String)uniqueValue, (NativeListener)this, (ArrayList)this.attributeList, (String)uniqueValueNativeParamName, (Properties)((Properties)userDetail));
                        if (res != null && res.length() > 0) {
                            result = this.getResultString(res);
                        }
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                result = e.getMessage();
            }
            String statusMsg = CommonUtil.getStatusMsgForO365Actions((String)result, (AdventNetResourceBundle)this.rb);
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.ad_explorer.view_props.user.attrib_disp_name.hide_from_exch_address_list"), objName, this.tenantId, this.auditPropList, new ArrayList(), new ArrayList(), statusMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getResultString(String result) {
        try {
            Object obj = new JSONTokener(result).nextValue();
            if (obj instanceof JSONObject) {
                JSONObject json = new JSONObject(result);
                if (!json.has("friendlyErrorMsg")) {
                    return result;
                }
                result = json.getString("friendlyErrorMsg");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        if (userProp.containsKey("USER_PRINCIPAL_NAME")) {
            resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
        } else {
            resProp.put((Object)701, "-");
        }
        if (userProp.containsKey("DISPLAY_NAME")) {
            resProp.put((Object)703, userProp.getProperty("DISPLAY_NAME"));
        } else {
            resProp.put((Object)703, "-");
        }
        if (userProp.containsKey("HIDDEN_TO_ADDRESSLISTS")) {
            resProp.put((Object)750, userProp.getProperty("HIDDEN_TO_ADDRESSLISTS"));
        } else {
            resProp.put((Object)750, "-");
        }
        if (userProp.containsKey("MAIL_ALIAS")) {
            resProp.put((Object)751, userProp.getProperty("MAIL_ALIAS"));
        } else {
            resProp.put((Object)751, "-");
        }
        resProp.put((Object)702, statusMessage);
        return resProp;
    }

    private boolean isAuthorized(String tenantId, HttpServletRequest request) {
        Long actionId = 41016L;
        ArrayList configuredDomainList = DomainUtil.getConfiguredDomainNamesList();
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, configuredDomainList, actionId);
    }

    protected Properties getAttributeProps(String selectedAttribute, String value) {
        Properties p = new Properties();
        p.put("DATA_HANDLER_TYPE", new Long(3L));
        p.put("ATTRIB_VALUE", value);
        p.put("ATTRIB_VALUE_COUNT", new Long(1L));
        p.put("ATTRIB_LDAP_NAME", selectedAttribute);
        return p;
    }
}

