/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public class O365MailDelegationMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    int operationId;
    boolean isAuthorised = false;
    String usageLocation = "";
    String country = "";
    ArrayList<Properties> licenseDetails = new ArrayList();
    ArrayList auditPropList = new ArrayList();
    ArrayList<String> servicePlanNames = new ArrayList();
    JSONArray sendAs = new JSONArray();
    JSONArray sendOnBehalf = new JSONArray();
    JSONArray fullAccess = new JSONArray();
    Integer selectedObjectsView = -1;
    ArrayList sharedMailboxGroupsId = new ArrayList();
    ArrayList sharedMailboxGroupsName = new ArrayList();

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            String val;
            int i;
            Thread action;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_MAILBOX_DELE_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.isAuthorised = this.isAuthorized(tenantId, request);
            this.selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "o365user";
            this.baseTableName = "O365UserGeneralDetails";
            this.tableKey = "OBJECT_ID";
            this.initAttributeList(reportId);
            this.sendOnBehalf = inputJsonObj.getJSONArray("sendOnBehalfO365");
            this.sendAs = inputJsonObj.getJSONArray("sendAsO365");
            this.fullAccess = inputJsonObj.getJSONArray("fullAccessO365");
            String operation = "";
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (this.selectedObjectsView < 2) {
                action = new O365AbstractListener.ModifyMailAction(generationId, selectedUsersList, true, request.getRemoteHost());
                action.start();
            } else {
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                action = new O365AbstractListener.ModifyMailCSVAction(generationId, selectedUsersList, headerJsonArray, true, userCreationID, request.getRemoteHost());
                action.start();
            }
            Properties operationProp = new Properties();
            String attrVal = "";
            if (this.sendOnBehalf.length() > 0) {
                this.getExchangeSharedMailbox();
                operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.send_on_behalf"));
                attrVal = "";
                for (i = 0; i < this.sendOnBehalf.length(); ++i) {
                    val = (String)this.sendOnBehalf.get(i);
                    attrVal = attrVal.equals("") ? val : attrVal + ", " + val;
                }
                operationProp.put("ATTRIB_VALUE", attrVal);
                this.auditPropList.add(operationProp);
            }
            if (this.sendAs.length() > 0) {
                operationProp = new Properties();
                operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.common.attrib_disp_name.send_as"));
                attrVal = "";
                for (i = 0; i < this.sendAs.length(); ++i) {
                    val = (String)this.sendAs.get(i);
                    attrVal = attrVal.equals("") ? val : attrVal + ", " + val;
                }
                operationProp.put("ATTRIB_VALUE", attrVal);
                this.auditPropList.add(operationProp);
            }
            if (this.fullAccess.length() > 0) {
                operationProp = new Properties();
                operationProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.mgmt.fc_layout_title.o365_mail_full_Access"));
                attrVal = "";
                for (i = 0; i < this.fullAccess.length(); ++i) {
                    val = (String)this.fullAccess.get(i);
                    attrVal = attrVal.equals("") ? val : attrVal + ", " + val;
                }
                operationProp.put("ATTRIB_VALUE", attrVal);
                this.auditPropList.add(operationProp);
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_MAILBOX_DELE_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (this.selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
                json.put("selectedUsersList", (Object)selectedUsersList);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object userDetail) {
        String result = "";
        String statusMsg = "";
        try {
            String objName;
            block28: {
                objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
                objName = objName.equals("") ? uniqueValue : objName;
                try {
                    PowerShellCommand powerShellCommand = new PowerShellCommand();
                    if (this.isAuthorised) {
                        boolean continueProcess = true;
                        if (this.sendOnBehalf.length() > 0 && !this.sharedMailboxGroupsId.contains(uniqueValue) && !this.sharedMailboxGroupsName.contains(uniqueValue)) {
                            powerShellCommand = new PowerShellCommand("Set-Mailbox");
                            powerShellCommand.setIdentity(uniqueValue);
                            String sendOnBehalfScript = "@{add=";
                            for (int i = 0; i < this.sendOnBehalf.length(); ++i) {
                                String val = this.sendOnBehalf.getString(i);
                                val = val.replaceAll("'", "''");
                                if (i != 0) {
                                    sendOnBehalfScript = sendOnBehalfScript + ",";
                                }
                                sendOnBehalfScript = sendOnBehalfScript + "'" + val + "'";
                            }
                            sendOnBehalfScript = "-GrantSendOnBehalfTo " + sendOnBehalfScript + "}";
                            powerShellCommand.addString(sendOnBehalfScript);
                        } else if (this.sendOnBehalf.length() > 0) {
                            continueProcess = false;
                        }
                        if (continueProcess) {
                            if (this.sendAs.length() > 0) {
                                for (int i = 0; i < this.sendAs.length(); ++i) {
                                    String val = this.sendAs.getString(i);
                                    val = val.replaceAll("'", "''");
                                    PowerShellCommand powerShellCommand1 = new PowerShellCommand("Add-RecipientPermission");
                                    powerShellCommand1.setIdentity(uniqueValue);
                                    powerShellCommand1.addParameter("Trustee", val);
                                    powerShellCommand1.addParameter("AccessRights", "SendAs");
                                    powerShellCommand1.addParameter("Confirm:$False");
                                    powerShellCommand.setMultiQuery(powerShellCommand1);
                                }
                            }
                            if (this.fullAccess.length() > 0) {
                                for (int i = 0; i < this.fullAccess.length(); ++i) {
                                    String val = this.fullAccess.getString(i);
                                    val = val.replaceAll("'", "''");
                                    PowerShellCommand powerShellCommand2 = new PowerShellCommand("Add-MailboxPermission");
                                    powerShellCommand2.setIdentity(uniqueValue);
                                    powerShellCommand2.addParameter("User", val);
                                    powerShellCommand2.addParameter("AccessRights", "FullAccess");
                                    powerShellCommand2.addParameter("InheritanceType", "All");
                                    powerShellCommand.setMultiQuery(powerShellCommand2);
                                }
                            }
                            if (this.selectedObjectsView >= 2) {
                                userDetail = new Properties();
                            }
                            String script = "";
                            script = "$MBList = Get-Mailbox -Identity " + uniqueValue + ";";
                            script = script + "$userList = New-Object System.Collections.ArrayList;";
                            script = script + "$userList1 = New-Object System.Collections.ArrayList;";
                            script = script + "foreach ($mb in $MBList){";
                            script = script + "$userList.Clear();$userList1.Clear();";
                            script = script + "$fullAccessList= Get-MailboxPermission -Identity $mb.Identity;foreach($perm in $fullAccessList){if($perm.AccessRights[0].Contains(\"FullAccess\")){if(-not $userList.Contains($perm.User)){[void]$userList.Add($perm.User);}}};";
                            script = script + "$sendAsList= Get-RecipientPermission -Identity $mb.Identity;foreach($perm in $sendAsList){if($perm.AccessRights[0].Contains(\"SendAs\")){if(-not $userList1.Contains($perm.Trustee)){[void]$userList1.Add($perm.Trustee);}}};";
                            script = script + "add-Member -InputObject $mb -type NoteProperty -Name FullPermission -Value $userList;add-Member -InputObject $mb -type NoteProperty -Name SendAs -Value $userList1;$mb};";
                            String res = ADHandler.updateO365Mailboxes((String)this.tenantId, (String)this.tenantPwd, (String)powerShellCommand.toString(), (String)script, (int)1, (String)uniqueValue, (NativeListener)this, (ArrayList)this.attributeList, (String)uniqueValueNativeParamName, (Properties)((Properties)userDetail));
                            if (res != null && res.length() > 0) {
                                result = this.getResultString(res);
                            }
                            statusMsg = result;
                            boolean valuePresent = false;
                            try {
                                JSONObject json = new JSONObject(result);
                                if (this.sendAs.length() > 0) {
                                    valuePresent = false;
                                    if (json.has("SendAs")) {
                                        valuePresent = true;
                                    }
                                }
                                if (this.fullAccess.length() > 0) {
                                    valuePresent = false;
                                    if (json.has("FullPermission")) {
                                        valuePresent = true;
                                    }
                                }
                                if (this.sendOnBehalf.length() > 0) {
                                    valuePresent = false;
                                    if (json.has("GrantSendOnBehalfTo")) {
                                        valuePresent = true;
                                    }
                                }
                                if (valuePresent) {
                                    statusMsg = this.rb.getString("admp.mgmt.common.statmsg.successfully_modified");
                                }
                                break block28;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                valuePresent = false;
                                try {
                                    statusMsg = this.rb.getString(result);
                                    break block28;
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                }
                            }
                            break block28;
                        }
                        result = "admp.mgmt.comp_mgmt.common.cannot_apply_message";
                        statusMsg = this.rb.getString(result);
                        break block28;
                    }
                    result = "client.reports.ReportMgmtHandler.access_denied";
                    statusMsg = this.rb.getString(result);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.mgmt.fc_layout_title.o365_mail_delegation"), objName, this.tenantId, this.auditPropList, new ArrayList(), new ArrayList(), statusMsg, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public String getResultString(String result) {
        try {
            Object obj = new JSONTokener(result).nextValue();
            if (obj instanceof JSONObject) {
                JSONObject json = new JSONObject(result);
                if (!json.has("friendlyErrorMsg")) {
                    return result;
                }
                result = json.getString("friendlyErrorMsg");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        resProp.put((Object)701, userProp.getProperty("USER_PRINCIPAL_NAME"));
        resProp.put((Object)703, userProp.getProperty("DISPLAY_NAME"));
        resProp.put((Object)735, userProp.getProperty("SEND_ON_BEHALF"));
        resProp.put((Object)736, userProp.getProperty("SEND_AS"));
        resProp.put((Object)737, userProp.getProperty("FULL_PERMISSION"));
        resProp.put((Object)702, statusMessage);
        return resProp;
    }

    private boolean isAuthorized(String tenantId, HttpServletRequest request) {
        Long actionId = 41015L;
        ArrayList configuredDomainList = DomainUtil.getConfiguredDomainNamesList();
        return ClientAuthorizationUtil.isAuthorizedForIamAppAction(request, configuredDomainList, actionId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getExchangeSharedMailbox() {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(new Table("O365UserGeneralDetails"));
            Criteria crit = new Criteria(Column.getColumn((String)"O365UserExchangeDetails", (String)"RECIPIENT_TYPE"), (Object)"SharedMailbox", 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"O365UserGeneralDetails", (String)"OBJECT_ID"));
            sq.addSelectColumn(Column.getColumn((String)"O365UserGeneralDetails", (String)"USER_PRINCIPAL_NAME"));
            sq.addJoin(new Join("O365UserGeneralDetails", "O365UserExchangeDetails", new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                this.sharedMailboxGroupsId.add((String)dataSet.getValue("OBJECT_ID"));
                this.sharedMailboxGroupsName.add((String)dataSet.getValue("USER_PRINCIPAL_NAME"));
            }
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }
}

