/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.powershell.PowerShellCommand;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVCConstants;
import com.adventnet.sym.adsm.common.server.resultview.ResultViewDataHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.waad.O365AbstractListener;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class RemoteMailboxDisableMgmtListener
extends O365AbstractListener
implements IWAADBulkMgmtListener {
    boolean isAuthorised = false;
    ArrayList auditPropList = new ArrayList();
    String adDomain = "";
    Boolean disable = false;
    Boolean disableArchive = false;
    Boolean remove = false;

    public JSONObject performMgmtAction(String tenantId, Integer reportId, Object selectedUsers, Object inputJsonObject, HttpServletRequest request, Long loginId, AdventNetResourceBundle rb) {
        JSONObject rvcJsonObject = new JSONObject();
        try {
            Thread action;
            JSONArray selectedUsersList = (JSONArray)selectedUsers;
            JSONObject inputJsonObj = (JSONObject)inputJsonObject;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMRVCDataConfiguration", (String)"RVC_ID"), (Object)RVCConstants.O365_REMOTE_USER_RESULT_RVC_ID, 0);
            DataObject rvcDataObject = ResultViewDataHandler.getRVCDataObject((Criteria)criteria);
            Row rvcDataRow = rvcDataObject.getFirstRow("ADSMRVCDataConfiguration");
            String dynamicHandlerClassName = (String)rvcDataRow.get("CLASS_NAME");
            long generationId = WAADBulkMgmtUtil.getNewGenerationId(reportId, loginId);
            StatusUpdater statusUpdater = (StatusUpdater)Class.forName(dynamicHandlerClassName.trim()).newInstance();
            WAADBulkMgmtController.getInstance().addStatusUpdator(Long.valueOf(generationId), statusUpdater);
            this.adDomain = inputJsonObj.getString("adDomain");
            this.isAuthorised = this.isAuthorized(request);
            JSONArray authOUList = new JSONArray();
            if (inputJsonObj.has("authOUList")) {
                authOUList = (JSONArray)inputJsonObj.get("authOUList");
            }
            this.disable = inputJsonObj.getBoolean("disable");
            this.disableArchive = inputJsonObj.getBoolean("disableArchive");
            this.remove = inputJsonObj.getBoolean("remove");
            StringBuilder sb = new StringBuilder();
            Properties auditProp = new Properties();
            if (!this.disableArchive.booleanValue() || this.remove.booleanValue()) {
                auditProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.office_365_disable_common"));
                auditProp.put("ATTRIB_VALUE", this.disable);
                this.auditPropList.add(auditProp);
            } else {
                auditProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.office_365_archive_disable"));
                auditProp.put("ATTRIB_VALUE", this.disableArchive);
                this.auditPropList.add(auditProp);
            }
            Integer selectedObjectsView = Integer.parseInt(request.getParameter("selectedObjectsView"));
            this.loginId = loginId;
            this.tenantId = tenantId;
            this.rb = rb;
            this.objectClass = "user";
            this.baseTableName = "ADSMUserGeneralDetails";
            this.tableKey = "OBJECT_GUID";
            this.initAttributeList(reportId);
            auditProp = new Properties();
            auditProp.put("ATTRIB_LDAP_NAME", rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.office_365_remove"));
            auditProp.put("ATTRIB_VALUE", this.remove);
            this.auditPropList.add(auditProp);
            Long userCreationID = null;
            JSONArray headerJsonArray = null;
            if (selectedObjectsView < 2) {
                action = new O365AbstractListener.RemoteAction(generationId, selectedUsersList, request.getRemoteHost(), "", this.adDomain, this.disable != false && this.disableArchive == false || this.remove != false);
                action.start();
            } else {
                userCreationID = Long.parseLong(request.getParameter("userCreationID"));
                headerJsonArray = new JSONArray(request.getParameter("headerJsonArray"));
                action = new O365AbstractListener.RemoteCSVAction(generationId, selectedUsersList, headerJsonArray, userCreationID, request.getRemoteHost(), "", this.adDomain, authOUList, this.disable != false && this.disableArchive == false || this.remove != false);
                action.start();
            }
            rvcJsonObject = ResultViewDataHandler.getRVCConfigJson((Integer)0, (Integer)RVCConstants.O365_REMOTE_USER_RESULT_RVC_ID, null, (DataObject)rvcDataObject, (AdventNetResourceBundle)rb, (Long)1L);
            rvcJsonObject.put("isReportRunning", true);
            rvcJsonObject.put("generationId", generationId);
            JSONObject json = new JSONObject();
            if (selectedObjectsView < 2) {
                json.put("isCsvMgmt", false);
            } else {
                json.put("isCsvMgmt", true);
                json.put("userCreationID", (Object)userCreationID);
                json.put("headerJsonArray", (Object)headerJsonArray);
                json.put("userIndexes", (Object)selectedUsersList);
            }
            json.put("adDomain", (Object)this.adDomain);
            rvcJsonObject.put("customParams", (Object)json.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rvcJsonObject;
    }

    @Override
    public String modifyUser(String uniqueValue, String uniqueValueNativeParamName, Hashtable audit_info, DataObject auditDataObj, Object exchangeServerDetails) {
        String result = "admp.mgmt.gpo_mgmt_some_err_occ";
        try {
            String objName = CommonUtil.objNameFromDataObj((DataObject)auditDataObj);
            objName = objName.equals("") ? uniqueValue : objName;
            try {
                if (this.isAuthorised) {
                    String command = "Disable-Remotemailbox";
                    if (this.remove.booleanValue()) {
                        command = "Remove-RemoteMailbox";
                    }
                    PowerShellCommand powerShellCommand = new PowerShellCommand(command);
                    powerShellCommand.setIdentity(uniqueValue);
                    if (!this.remove.booleanValue() && this.disableArchive.booleanValue()) {
                        powerShellCommand.addParameter("Archive");
                    }
                    powerShellCommand.addParameter("Confirm:$False");
                    Properties p = (Properties)exchangeServerDetails;
                    if (p != null) {
                        String distinguishedName = "";
                        if (audit_info.get("DISTINGUISHED_NAME") != null) {
                            distinguishedName = (String)audit_info.remove("DISTINGUISHED_NAME");
                        }
                        String res = ADHandler.executePowershellCMD((String)this.adDomain, (Long)this.loginId, (String)distinguishedName, (PowerShellCommand)powerShellCommand, (Properties)p);
                        result = this.rb.getString(res);
                    }
                    try {
                        TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.office_365_disable"), objName, this.adDomain, this.auditPropList, new ArrayList(), new ArrayList(), result, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
                        return result;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else {
                    result = "client.reports.ReportMgmtHandler.access_denied";
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            TechAuditAPI.getInstance().auditO365Modification(this.loginId, this.rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.office_365_disable"), objName, this.adDomain, this.auditPropList, new ArrayList(), new ArrayList(), result, (Long)audit_info.get("object_id"), auditDataObj, this.rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    @Override
    public Properties updateStatus(Properties userProp, String statusMessage) {
        Properties resProp = new Properties();
        if (userProp.getProperty("STATUS").equalsIgnoreCase("SUCCESS")) {
            resProp.put((Object)84, userProp.getProperty("LOGON_NAME"));
            resProp.put((Object)85, userProp.getProperty("SAM_ACCOUNT_NAME"));
            resProp.put((Object)87, userProp.getProperty("FOLDER"));
            resProp.put((Object)708, statusMessage);
        } else {
            resProp.put((Object)84, userProp.getProperty("LOGON_NAME"));
            resProp.put((Object)85, userProp.getProperty("SAM_ACCOUNT_NAME"));
            resProp.put((Object)87, userProp.getProperty("FOLDER"));
            resProp.put((Object)708, statusMessage);
        }
        return resProp;
    }

    private boolean isAuthorized(HttpServletRequest request) {
        try {
            Integer reportId = 8056;
            return ClientAuthorizationUtil.isAuthorized(request, this.adDomain, reportId);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

