/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DerivedColumn;
import com.adventnet.ds.query.DerivedTable;
import com.adventnet.ds.query.GroupByClause;
import com.adventnet.ds.query.GroupByColumn;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainInfoCache;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.O365MgmtHandler;
import com.adventnet.sym.adsm.common.server.cvc.CVCUtil;
import com.adventnet.sym.adsm.common.server.delegation.O365DelegationUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.refresh.WAADRefreshListener;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.server.resultview.RVReqParams;
import com.adventnet.sym.adsm.common.server.resultview.TableViewQueryHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.RVUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.waad.IWAADBulkMgmtListener;
import com.adventnet.sym.adsm.common.server.waad.WAADBulkMgmtController;
import com.adventnet.sym.adsm.common.webclient.usermanagement.BulkModificationAPI;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtStatusUpdator;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class WAADBulkMgmtAction
extends DispatchAction {
    public static final Integer O365_LIC_MGMT_REPORT_ID = 8052;
    public static final Integer O365_MAIL_DELE_REPORT_ID = 8057;
    public static final Integer O365_HIDE_LISTS_REPORT_ID = 8058;
    public static final Integer O365_EMAIL_LIMITS_REPORT_ID = 8059;
    public static final Integer O365_CRT_USER_REPORT_ID = 8055;
    public static final Integer[] MAILBOX_MGMT_REPORT_IDS = new Integer[]{8060, 8061, 8062, 8057, 8058, 8059};
    public static final Integer O365_PROXY_ADDRESSES_REPORT_ID = 8061;
    public static final Integer O365_LIT_HOLD_MGMT_REPORT_ID = 8060;
    public static final Integer O365_INPLACE_ARCHIVE_MGMT_REPORT_ID = 8062;
    public static final Integer O365_IAMAPP_ID = 3;
    public static final Integer O365_REMOTE_REPORT_ID = 8056;
    private Join o365LicenseFilterJoin;
    private Criteria o365LicenseFilterCriteria;

    public ActionForward initMgmtTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardURL = "WAADBulkMgmt";
        try {
            int index;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String reportIdStr = request.getParameter("reportId");
            Integer reportId = Integer.parseInt(reportIdStr);
            String onTheFlyMgmtRepId = request.getParameter("onTheFlyMgmtReportId");
            int onTheFlyMgmtReportId = onTheFlyMgmtRepId != null ? Integer.parseInt(onTheFlyMgmtRepId) : 0;
            Criteria criteria = new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)reportId, 0);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMReports", criteria);
            Row r = dataobj.getFirstRow("ADSMReports");
            Long actionId = (Long)r.get("ACTION_ID");
            String inputDesc = rb.getString((String)r.get("INPUT_DESCRIPTION"));
            if (!ClientAuthorizationUtil.isAuthorized(request, actionId).booleanValue()) {
                return new ActionForward("/404Error.do");
            }
            request.setAttribute("mgmtName", (Object)rb.getString((String)r.get("REPORT_NAME")));
            request.setAttribute("mgmtDesc", (Object)rb.getString((String)r.get("DESCRIPTION")));
            Long cvcId = CVCUtil.getCVCId((Integer)reportId);
            Long cvcDataId = CVCUtil.getDefaultDataModelId((String)"WAADSmtpModify");
            JSONObject mgmtActionDetails = WAADBulkMgmtUtil.getMgmtActionDetails(reportId);
            request.setAttribute("SCRIPT_HANDLER", (Object)mgmtActionDetails.getString("SCRIPT_HANDLER"));
            request.setAttribute("ACTION_CLASS", (Object)mgmtActionDetails.getString("ACTION_CLASS"));
            String selectedDomain = new String();
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList totalList = reportId.equals(O365_CRT_USER_REPORT_ID) || reportId.equals(O365_REMOTE_REPORT_ID) ? HDTDomainHandler.getConfiguredList((Long)loginId) : HDTDomainHandler.getConfiguredList((Long)CommonUtil.ADMIN_LOGIN_ID);
            boolean applyOUFilter = false;
            ArrayList domainNameList = (ArrayList)authObject.getDomainNameList().clone();
            ArrayList o365CredList = new ArrayList();
            ArrayList domainPropList = new ArrayList();
            boolean isAuthorized = ClientAuthorizationUtil.isAuthorized(authObject, domainNameList, actionId);
            for (index = 0; index < totalList.size(); ++index) {
                String isDefaultDomain = ((Properties)totalList.get(index)).getProperty("IS_DEFAULT_DOMAIN");
                if (isDefaultDomain == null || isDefaultDomain.length() <= 0 || !isDefaultDomain.equalsIgnoreCase("true") || !domainNameList.contains(((Properties)totalList.get(index)).getProperty("DOMAIN_NAME"))) continue;
                selectedDomain = ((Properties)totalList.get(index)).getProperty("DOMAIN_NAME");
            }
            if (isAuthorized) {
                o365CredList = O365MgmtHandler.getAuthorizedCredentials((ADMPAuthObject)((ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT")));
                if (reportId.equals(O365_LIC_MGMT_REPORT_ID) || Arrays.asList(MAILBOX_MGMT_REPORT_IDS).contains(reportId)) {
                    long waadId = 0L;
                    String waadAccount = new String();
                    ArrayList linkedDomainProp = new ArrayList();
                    ArrayList<String> linkedDomainList = new ArrayList<String>();
                    ArrayList<String> delegatedDomainList = new ArrayList<String>();
                    ArrayList delegatedADDomainList = HDTDomainHandler.getHDTConfiguredDomainList((Long)loginId);
                    if (o365CredList.size() > 0) {
                        if (onTheFlyMgmtReportId != 0) {
                            JSONObject onTheFlyMgmtDetails = new JSONObject();
                            long mgmtGenId = Long.parseLong(request.getParameter("generationID"));
                            onTheFlyMgmtDetails.put("generationID", (Object)mgmtGenId);
                            String selObjectIds = request.getParameter("selectedObjectIds");
                            JSONArray selectedObjectIds = new JSONArray(selObjectIds);
                            onTheFlyMgmtDetails.put("selectedObjectIds", (Object)selectedObjectIds);
                            String deSelObjectIds = request.getParameter("deSelectedObjectIds");
                            JSONArray deSelectedObjectIds = new JSONArray(deSelObjectIds);
                            onTheFlyMgmtDetails.put("deSelectedObjectIds", (Object)deSelectedObjectIds);
                            waadId = Long.parseLong(request.getParameter("waadDomainId"));
                            boolean checkAll = Boolean.parseBoolean(request.getParameter("checkAll"));
                            onTheFlyMgmtDetails.put("checkAll", checkAll);
                            long onTheFlyMgmtCVCDataId = Long.parseLong(request.getParameter("cvcDataId"));
                            onTheFlyMgmtDetails.put("cvcDataId", (Object)onTheFlyMgmtCVCDataId);
                            boolean licFilterApplied = Boolean.parseBoolean(request.getParameter("o365LicenseFilterApplied"));
                            onTheFlyMgmtDetails.put("onTheFlyMgmtReportId", onTheFlyMgmtReportId);
                            if (licFilterApplied) {
                                String[] licFilterAttributes;
                                JSONObject custParams = new JSONObject(request.getParameter("customParams"));
                                JSONObject licFilterDetails = new JSONObject();
                                for (String licFilterAttrib : licFilterAttributes = new String[]{"o365LicenseFilterType", "customFilterType", "o365alfSelected", "advancedFilterType", "licenses"}) {
                                    if (!custParams.has(licFilterAttrib)) continue;
                                    licFilterDetails.put(licFilterAttrib, custParams.get(licFilterAttrib));
                                }
                                onTheFlyMgmtDetails.put("licFilterDetails", (Object)licFilterDetails);
                            }
                            applyOUFilter = false;
                            request.setAttribute("onTheFlyMgmtDetails", (Object)onTheFlyMgmtDetails.toString());
                            for (int i = 0; i < o365CredList.size(); ++i) {
                                if (waadId != (Long)((Properties)o365CredList.get(i)).get("WAAD_DOMAIN_ID")) continue;
                                waadAccount = ((Properties)o365CredList.get(i)).getProperty("WAAD_TENANT_ID");
                                linkedDomainProp = (ArrayList)((Properties)o365CredList.get(i)).get("LINKED_DOMAINS");
                                for (int ind = 0; ind < linkedDomainProp.size(); ++ind) {
                                    linkedDomainList.add(((Properties)linkedDomainProp.get(ind)).getProperty("AD_DOMAIN_NAME"));
                                }
                                break;
                            }
                        } else if (request.getParameter("waadAccId") == null) {
                            waadAccount = ((Properties)o365CredList.get(0)).getProperty("WAAD_TENANT_ID");
                            waadId = (Long)((Properties)o365CredList.get(0)).get("WAAD_DOMAIN_ID");
                            linkedDomainProp = (ArrayList)((Properties)o365CredList.get(0)).get("LINKED_DOMAINS");
                            for (int ind = 0; ind < linkedDomainProp.size(); ++ind) {
                                String adDomainName = ((Properties)linkedDomainProp.get(ind)).getProperty("AD_DOMAIN_NAME");
                                linkedDomainList.add(adDomainName);
                                if (!delegatedADDomainList.contains(adDomainName)) continue;
                                delegatedDomainList.add(adDomainName);
                            }
                            applyOUFilter = Boolean.parseBoolean(((Properties)o365CredList.get(0)).getProperty("IS_DIR_SYNC_ENABLED")) && delegatedDomainList.size() > 0;
                        } else {
                            waadAccount = request.getParameter("waadAccId");
                            for (int i = 0; i < o365CredList.size(); ++i) {
                                if (!waadAccount.equals(((Properties)o365CredList.get(i)).getProperty("WAAD_TENANT_ID"))) continue;
                                applyOUFilter = Boolean.parseBoolean(((Properties)o365CredList.get(i)).getProperty("IS_DIR_SYNC_ENABLED"));
                                waadId = (Long)((Properties)o365CredList.get(i)).get("WAAD_DOMAIN_ID");
                                linkedDomainProp = (ArrayList)((Properties)o365CredList.get(i)).get("LINKED_DOMAINS");
                                for (int ind = 0; ind < linkedDomainProp.size(); ++ind) {
                                    String adDomainName = ((Properties)linkedDomainProp.get(ind)).getProperty("AD_DOMAIN_NAME");
                                    linkedDomainList.add(adDomainName);
                                    if (!delegatedADDomainList.contains(adDomainName)) continue;
                                    delegatedDomainList.add(adDomainName);
                                }
                                applyOUFilter = Boolean.parseBoolean(((Properties)o365CredList.get(i)).getProperty("IS_DIR_SYNC_ENABLED")) && delegatedDomainList.size() > 0;
                                break;
                            }
                        }
                        domainNameList.retainAll(linkedDomainList);
                        request.setAttribute("domainNameList", (Object)domainNameList);
                        request.setAttribute("selectedDomainName", (Object)waadAccount);
                        request.setAttribute("selectedWaadTenantId", (Object)waadAccount);
                        if (!applyOUFilter) {
                            try {
                                Row r1;
                                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"WAADADMapping"));
                                query.addSelectColumn(Column.getColumn((String)"WAADADMapping", (String)"WAAD_DOMAIN_ID"));
                                query.addSelectColumn(Column.getColumn((String)"WAADADMapping", (String)"AD_OBJECT_CLASS_NAME"));
                                query.addSelectColumn(Column.getColumn((String)"WAADADMapping", (String)"WAAD_ATTRIB_NAME"));
                                Criteria c = new Criteria(Column.getColumn((String)"WAADADMapping", (String)"AD_OBJECT_CLASS_NAME"), (Object)"user", 0);
                                c = c.and(new Criteria(Column.getColumn((String)"WAADADMapping", (String)"WAAD_DOMAIN_ID"), (Object)waadId, 0));
                                query.setCriteria(c);
                                DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
                                if (!dataObj.isEmpty() && (r1 = dataObj.getFirstRow("WAADADMapping")).get("WAAD_ATTRIB_NAME") != null) {
                                    applyOUFilter = true;
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                } else if (reportId.equals(O365_CRT_USER_REPORT_ID)) {
                    try {
                        Hashtable iamAppIdVsLinkedADDomains = authObject.getDelegatedLinkedDomains();
                        ArrayList linkedADDomains = (ArrayList)iamAppIdVsLinkedADDomains.get(O365_IAMAPP_ID);
                        if (linkedADDomains == null) {
                            linkedADDomains = new ArrayList();
                        }
                        domainNameList.retainAll(linkedADDomains);
                        if (request.getParameter("domainName") == null) {
                            if (selectedDomain == null || selectedDomain.length() == 0 || !domainNameList.contains(selectedDomain)) {
                                selectedDomain = (String)domainNameList.get(0);
                            }
                        } else {
                            selectedDomain = request.getParameter("domainName");
                        }
                        request.setAttribute("selectedDomainName", (Object)selectedDomain);
                        Properties waadAccountProps = DomainInfoCache.getInstance().getO356AccountProperties(selectedDomain);
                        request.setAttribute("selectedWaadTenantId", (Object)((String)waadAccountProps.get("WAAD_TENANT_ID")));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    request.setAttribute("domainNameList", (Object)domainNameList);
                    forwardURL = "CreateO365FromAD";
                } else if (reportId.equals(O365_REMOTE_REPORT_ID)) {
                    for (int i = 0; i < domainNameList.size(); ++i) {
                        String domainName = (String)domainNameList.get(i);
                        if (ClientAuthorizationUtil.isAuthorized(authObject, domainName, actionId).booleanValue()) continue;
                        domainNameList.remove(i);
                        --i;
                    }
                    request.setAttribute("selectedDomainName", (Object)(request.getParameter("domainName") == null ? (String)domainNameList.get(0) : request.getParameter("domainName")));
                }
                for (index = 0; index < totalList.size(); ++index) {
                    if (!domainNameList.contains(((Properties)totalList.get(index)).getProperty("DOMAIN_NAME"))) continue;
                    domainPropList.add(totalList.get(index));
                }
                if (reportId.equals(O365_LIC_MGMT_REPORT_ID) || Arrays.asList(MAILBOX_MGMT_REPORT_IDS).contains(reportId)) {
                    if (domainPropList.size() == 0) {
                        applyOUFilter = false;
                    }
                    request.setAttribute("applyOUFilter", (Object)applyOUFilter);
                }
            } else {
                request.setAttribute("domainNameList", new ArrayList());
                request.setAttribute("selectedDomainName", (Object)"");
                request.setAttribute("selectedWaadTenantId", (Object)"");
            }
            request.setAttribute("domainPropList", domainPropList);
            Integer rvcId = RVUtil.getRVCId((Integer)reportId);
            Boolean showInputDetails = (Boolean)BulkModificationAPI.getConfigForHDT(loginId, "MGMT_SHOW_INPUT_DETAIL");
            request.setAttribute("reportId", (Object)reportId);
            request.setAttribute("cvcId", (Object)cvcId);
            request.setAttribute("cvcDataId", (Object)cvcDataId);
            request.setAttribute("o365CredList", (Object)o365CredList);
            request.setAttribute("rvcId", (Object)rvcId);
            request.setAttribute("inputDesc", (Object)inputDesc);
            request.setAttribute("showInputDetails", (Object)showInputDetails);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward(forwardURL);
    }

    public ActionForward getDynamicUpdateDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = null;
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            JSONObject reqJSONObject = new JSONObject(request.getParameter("params"));
            StatusUpdater dynamicUpdator = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(reqJSONObject.getLong("generationId")));
            jsonObject = dynamicUpdator.getJSONObject(reqJSONObject, rb);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward stopExecuteLayout(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long generationId = Long.parseLong(request.getParameter("generationId"));
            StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(generationId));
            ((WAADBulkMgmtStatusUpdator)statusUpdater).setIsStopped(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward checkAllObjectsSucceeded(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            boolean isAllSucceeded = false;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("isAllSucceeded", isAllSucceeded);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward getCommonErrorMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object forwardPage = null;
        try {
            boolean isAllSucceeded = true;
            String helpLink = "";
            String commonErrorMessage = "";
            JSONObject jsonObject = new JSONObject();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            long generationId = Long.parseLong(request.getParameter("generationId"));
            StatusUpdater statusUpdater = WAADBulkMgmtController.getInstance().getStatusUpdator(Long.valueOf(generationId));
            if (statusUpdater != null) {
                isAllSucceeded = ((WAADBulkMgmtStatusUpdator)statusUpdater).getIsAllObjectsSucceeded();
                if (!isAllSucceeded) {
                    helpLink = ((WAADBulkMgmtStatusUpdator)statusUpdater).getHelpLink();
                    commonErrorMessage = ((WAADBulkMgmtStatusUpdator)statusUpdater).getCommonErrorMessage();
                    jsonObject.put("helpLink", (Object)helpLink);
                }
                WAADBulkMgmtController.getInstance().removeStatusUpdator(Long.valueOf(generationId));
            } else {
                System.out.println("Error: StatusUpdater is null in o365 mgmt...");
            }
            jsonObject.put("isAllSucceeded", isAllSucceeded);
            jsonObject.put("commonErrorMessage", (Object)rb.getString(commonErrorMessage));
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward performAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Object connection = null;
        Object dataSet = null;
        try {
            String[] selectedObjectIdsArr;
            String onTheFlyMgmtRepId;
            String waadaccid = request.getParameter("waadaccid");
            String waadDomId = request.getParameter("waadDomainId");
            Long waadDomainId = null;
            if (waadDomId != null) {
                waadDomainId = Long.parseLong(waadDomId);
            }
            if (waadaccid == null && waadDomainId != null) {
                Properties waadAccountProps = DomainInfoCache.getInstance().getWAADDomainProperties(waadDomainId);
                waadaccid = (String)waadAccountProps.get("WAAD_TENANT_ID");
            }
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            String deSelectedObjectIdsStr = request.getParameter("deSelectedObjectIds");
            String checkAll = request.getParameter("checkAll");
            String selectedObjectIdsStr = request.getParameter("selectedObjectIds");
            String selectedObjectsView = request.getParameter("selectedObjectsView");
            String inputJson = request.getParameter("inputJson");
            String o365LicenseFilterApplied = request.getParameter("o365LicenseFilterApplied");
            if (o365LicenseFilterApplied == null) {
                o365LicenseFilterApplied = "false";
            }
            int onTheFlyMgmtReportId = (onTheFlyMgmtRepId = request.getParameter("onTheFlyMgmtReportId")) != null ? Integer.parseInt(onTheFlyMgmtRepId) : 0;
            String genId = request.getParameter("generationID");
            long generationId = genId != null ? Long.parseLong(genId) : 0L;
            this.o365LicenseFilterJoin = null;
            this.o365LicenseFilterCriteria = null;
            JSONObject inputObj = inputJson != null ? new JSONObject(inputJson) : new JSONObject();
            ArrayList authOUList = null;
            Criteria waadInactiveUsersCrit = null;
            boolean excludeChildOU = false;
            Criteria joinCrit = null;
            Criteria splCaseJoinCrit = null;
            String joinTableName = new String();
            Criteria exchJoinCrit = null;
            String adDomain = "";
            Criteria crit = null;
            String tableName = "";
            String colName = "";
            String clName = "";
            HttpSession session = request.getSession();
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            ArrayList delegatedO365Domains = O365DelegationUtil.getDelegatedIamAppDomains((Long)authObject.getLoginId(), (String)waadaccid);
            if (reportId.equals(O365_LIC_MGMT_REPORT_ID) || Arrays.asList(MAILBOX_MGMT_REPORT_IDS).contains(reportId)) {
                tableName = "O365UserGeneralDetails";
                colName = "OBJECT_ID";
                clName = "USER_PRINCIPAL_NAME";
            } else if (reportId.equals(O365_REMOTE_REPORT_ID)) {
                tableName = "ADSMMailBoxObjects";
                colName = "OBJECT_GUID";
                clName = "DOMAIN_NAME";
            } else {
                tableName = "ADSMUserGeneralDetails";
                colName = "OBJECT_GUID";
                clName = "DOMAIN_NAME";
            }
            if (inputObj.has("adDomain")) {
                excludeChildOU = inputObj.getBoolean("excludeChildOU");
                adDomain = inputObj.getString("adDomain");
                if (authObject != null && (authOUList = (ArrayList)authObject.getDomainOUsMap().get(adDomain)) != null) {
                    inputObj.put("authOUList", (Object)new JSONArray((Collection)authOUList));
                }
            }
            if (selectedObjectsView.equals("0") || selectedObjectsView.equals("1")) {
                if ("true".equalsIgnoreCase(checkAll)) {
                    Criteria deSelectedObjectIdsCrit;
                    boolean applyOUFilter = false;
                    ADMPAuthObject authObj = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                    boolean applyOURestriction = authObj.getApplyOURestriction(waadaccid, "user");
                    long loginId = authObj.getLoginId();
                    JSONArray deSelectedObjectIds = new JSONArray(deSelectedObjectIdsStr);
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedObjectIds);
                    crit = deSelectedObjectIdsCrit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)deSelectedObjectIdsArr, 9);
                    if (reportId.equals(O365_PROXY_ADDRESSES_REPORT_ID)) {
                        exchJoinCrit = O365MgmtHandler.getExchOnlineJoinCrit((String[])new String[]{"UserMailbox", "MailUser"}, null);
                    } else if (Arrays.asList(MAILBOX_MGMT_REPORT_IDS).contains(reportId)) {
                        exchJoinCrit = O365MgmtHandler.getExchOnlineJoinCrit((String[])new String[]{"UserMailbox"}, null);
                    }
                    if (reportId.equals(O365_CRT_USER_REPORT_ID) || reportId.equals(O365_REMOTE_REPORT_ID)) {
                        applyOUFilter = true;
                    } else if (inputObj.has("adDomain") || inputObj.has("domainList") || applyOURestriction) {
                        SelectQueryImpl q = new SelectQueryImpl(Table.getTable((String)"WAADADMapping"));
                        q.addSelectColumn(Column.getColumn((String)"WAADADMapping", (String)"WAAD_DOMAIN_ID"));
                        q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
                        q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
                        q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
                        q.addJoin(new Join("WAADADMapping", "ADSMWAADDomainConfiguration", new String[]{"WAAD_DOMAIN_ID"}, new String[]{"WAAD_DOMAIN_ID"}, 2));
                        q.addJoin(new Join("WAADADMapping", "ADSMAttributeDetails", new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
                        Criteria attrCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)waadaccid, 0);
                        attrCrit = attrCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)O365_IAMAPP_ID, 0));
                        attrCrit = attrCrit.and(new Criteria(Column.getColumn((String)"WAADADMapping", (String)"AD_OBJECT_CLASS_NAME"), (Object)"user", 0));
                        q.setCriteria(attrCrit);
                        DataObject joinAttrDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)q);
                        String joinColumnName = new String();
                        if (!joinAttrDataObj.isEmpty()) {
                            Row r = joinAttrDataObj.getFirstRow("ADSMAttributeDetails");
                            joinTableName = (String)r.get("TABLE_NAME");
                            joinColumnName = (String)r.get("ATTRIB_COLUMN_NAME");
                        }
                        joinCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID"), (Object)Column.getColumn((String)joinTableName, (String)joinColumnName), 0);
                        joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID"), (Object)"-", 1));
                        joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"IS_DELETED"), (Object)0, 1));
                        if (joinTableName.equalsIgnoreCase("ADSMUserGeneralDetails")) {
                            joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0));
                        } else {
                            splCaseJoinCrit = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0);
                            splCaseJoinCrit = splCaseJoinCrit.and(new Criteria(Column.getColumn((String)joinTableName, (String)"OBJECT_GUID"), (Object)Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), 0));
                        }
                        if (inputObj.has("adDomain")) {
                            adDomain = inputObj.getString("adDomain");
                            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)adDomain, 0));
                            applyOUFilter = true;
                        } else if (inputObj.has("domainList") || applyOURestriction) {
                            JSONArray domainList = new JSONArray();
                            domainList = inputObj.has("domainList") ? inputObj.getJSONArray("domainList") : O365DelegationUtil.getLinkedADDomains((ADMPAuthObject)authObject, (String)waadaccid);
                            authOUList = O365DelegationUtil.getAuthorizedOUList((ADMPAuthObject)authObject, (JSONArray)domainList);
                            Criteria domainCrit = null;
                            for (int indx = 0; indx < domainList.length(); ++indx) {
                                String domain = domainList.getString(indx);
                                domainCrit = domainCrit == null ? new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)domain, 0) : domainCrit.or(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"DOMAIN_NAME"), (Object)domain, 0));
                            }
                            if (domainCrit != null) {
                                crit = crit.and(domainCrit);
                            }
                            if (authOUList != null && authOUList.size() > 0) {
                                crit = crit.and(O365MgmtHandler.getAllOUSelectedCriteria((ArrayList)authOUList));
                            }
                        }
                    }
                    if (applyOUFilter) {
                        JSONArray selectedOUArr = inputObj.getJSONArray("selectedOUs");
                        JSONArray unSelectedOUArr = null;
                        if (inputObj.has("unSelectedOUs")) {
                            unSelectedOUArr = inputObj.getJSONArray("unSelectedOUs");
                        }
                        Criteria ouCrit = null;
                        ouCrit = reportId.equals(O365_REMOTE_REPORT_ID) ? O365MgmtHandler.getAuthentictedOUCriteriaMailObject((JSONArray)selectedOUArr, (JSONArray)unSelectedOUArr, (ArrayList)authOUList, (boolean)excludeChildOU) : O365MgmtHandler.getAuthentictedOUCriteria((JSONArray)selectedOUArr, (JSONArray)unSelectedOUArr, (ArrayList)authOUList, (boolean)excludeChildOU);
                        if (ouCrit != null) {
                            crit = crit.and(ouCrit);
                        }
                    }
                    if (onTheFlyMgmtReportId != 0) {
                        Criteria domainCrit;
                        JSONArray selectedObjectIds;
                        SelectQueryImpl subQuery = new SelectQueryImpl(Table.getTable((String)"O365UserReportResult"));
                        subQuery.addSelectColumn(Column.getColumn((String)"O365UserReportResult", (String)"OBJECT_ID"));
                        Criteria subQueryCrit = new Criteria(Column.getColumn((String)"O365UserReportResult", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                        subQuery.setCriteria(subQueryCrit);
                        DerivedColumn subQueryResCol = new DerivedColumn("O365UserReportResult", (SelectQuery)subQuery);
                        Criteria reportResultCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"OBJECT_ID"), (Object)subQueryResCol, 8);
                        if (selectedObjectIdsStr.length() > 0 && (selectedObjectIds = new JSONArray(selectedObjectIdsStr)).length() > 0) {
                            String[] selectedObjectIdsArr2 = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                            reportResultCrit = reportResultCrit.and(new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)selectedObjectIdsArr2, 8));
                        }
                        crit = deSelectedObjectIdsArr.length > 0 ? reportResultCrit.and(deSelectedObjectIdsCrit) : reportResultCrit;
                        if (onTheFlyMgmtReportId == 53 || applyOURestriction) {
                            long cvcDataId = Long.parseLong(request.getParameter("cvcDataId"));
                            RVReqParams reqParams = new RVReqParams();
                            reqParams.setCvcDataId(cvcDataId);
                            reqParams.setReportId(onTheFlyMgmtReportId);
                            waadInactiveUsersCrit = TableViewQueryHandler.getWaadInactiveUsersReportCrit((RVReqParams)reqParams);
                            if (waadInactiveUsersCrit != null || applyOURestriction) {
                                Hashtable joinCrits = WAADBulkMgmtUtil.getDirSyncJoinCrit(waadaccid);
                                if (joinCrits.containsKey("joinCrit")) {
                                    joinCrit = (Criteria)joinCrits.get("joinCrit");
                                }
                                if (joinCrits.containsKey("splCaseJoinCrit")) {
                                    splCaseJoinCrit = (Criteria)joinCrits.get("splCaseJoinCrit");
                                }
                                if (joinCrits.containsKey("joinTableName")) {
                                    joinTableName = (String)joinCrits.get("joinTableName");
                                }
                                if (waadInactiveUsersCrit != null) {
                                    crit = crit.and(waadInactiveUsersCrit);
                                }
                                if (applyOURestriction) {
                                    JSONArray domainList = O365DelegationUtil.getLinkedADDomains((ADMPAuthObject)authObject, (String)waadaccid);
                                    authOUList = O365DelegationUtil.getAuthorizedOUList((ADMPAuthObject)authObject, (JSONArray)domainList);
                                    Criteria ouCrit = null;
                                    ouCrit = O365MgmtHandler.getAuthentictedOUCriteria(null, null, (ArrayList)authOUList, (boolean)false, (String)"ADSMUserGeneralDetails");
                                    if (ouCrit != null) {
                                        crit = crit.and(ouCrit);
                                    }
                                }
                            }
                        }
                        if ((domainCrit = O365DelegationUtil.getO365DelegatedDomainCrit((ArrayList)delegatedO365Domains, (Long)(waadDomainId = Long.valueOf(O365MgmtHandler.getWaadDomainId((String)waadaccid))), (String)"user", (String)tableName)) != null) {
                            crit = crit.and(domainCrit);
                        }
                    }
                } else {
                    JSONArray selectedObjectIds = new JSONArray(selectedObjectIdsStr);
                    selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                    crit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)selectedObjectIdsArr, 8);
                }
                if (o365LicenseFilterApplied.equals("true") && tableName.equals("O365UserGeneralDetails")) {
                    RVReqParams reqParams = new RVReqParams();
                    JSONObject customParams = new JSONObject(request.getParameter("customParams"));
                    if (customParams.has("onTheFlyMgmtDetails")) {
                        JSONObject onTheFlyMgmtDetails = (JSONObject)customParams.get("onTheFlyMgmtDetails");
                        JSONObject licFilterDetails = (JSONObject)onTheFlyMgmtDetails.get("licFilterDetails");
                        Iterator it = licFilterDetails.keys();
                        while (it.hasNext()) {
                            String key = (String)it.next();
                            customParams.put(key, licFilterDetails.get(key));
                        }
                    }
                    reqParams.setCustomParams(customParams.toString());
                    this.getO365LicenseFilterJoinAndCriteria(reqParams);
                    if (this.o365LicenseFilterCriteria != null) {
                        crit = crit != null ? crit.and(this.o365LicenseFilterCriteria) : this.o365LicenseFilterCriteria;
                    }
                }
            } else {
                tableName = "ADSMAUNamingAttributes";
                colName = "USER_INDEX";
                if ("true".equalsIgnoreCase(checkAll)) {
                    JSONArray deSelectedObjectIds = new JSONArray(deSelectedObjectIdsStr);
                    String[] deSelectedObjectIdsArr = StrUtil.getStringArray((JSONArray)deSelectedObjectIds);
                    crit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)deSelectedObjectIdsArr, 9);
                } else {
                    JSONArray selectedObjectIds = new JSONArray(selectedObjectIdsStr);
                    selectedObjectIdsArr = StrUtil.getStringArray((JSONArray)selectedObjectIds);
                    crit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)selectedObjectIdsArr, 8);
                }
            }
            JSONArray waadUserDetList = new JSONArray();
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)tableName));
            query.addSelectColumn(Column.getColumn((String)tableName, (String)colName));
            if (onTheFlyMgmtReportId == 0) {
                if (selectedObjectsView.equals("0") || selectedObjectsView.equals("1")) {
                    ArrayList waadDomainList = new ArrayList();
                    Criteria domainCrit = null;
                    if (reportId.equals(O365_LIC_MGMT_REPORT_ID) || Arrays.asList(MAILBOX_MGMT_REPORT_IDS).contains(reportId)) {
                        waadDomainId = O365MgmtHandler.getWaadDomainId((String)waadaccid);
                        domainCrit = O365DelegationUtil.getO365DelegatedDomainCrit((ArrayList)delegatedO365Domains, (Long)waadDomainId, (String)"user", (String)tableName);
                        if (domainCrit != null) {
                            crit = crit.and(domainCrit);
                        }
                        crit = crit != null ? crit.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)0, 1)) : new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)0, 1);
                    } else {
                        domainCrit = new Criteria(Column.getColumn((String)tableName, (String)clName), (Object)adDomain, 0);
                        if (!reportId.equals(O365_REMOTE_REPORT_ID)) {
                            domainCrit = domainCrit.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DELETED"), (Object)1, 0));
                        }
                        crit = crit.and(domainCrit);
                    }
                }
                if (exchJoinCrit != null) {
                    query.addJoin(new Join("O365UserGeneralDetails", "O365UserExchangeDetails", exchJoinCrit, 2));
                }
            }
            if (joinCrit != null) {
                if (waadInactiveUsersCrit != null) {
                    query.addJoin(new Join("O365UserGeneralDetails", joinTableName, joinCrit, 1));
                } else {
                    query.addJoin(new Join("O365UserGeneralDetails", joinTableName, joinCrit, 2));
                }
            }
            if (splCaseJoinCrit != null) {
                if (waadInactiveUsersCrit != null) {
                    query.addJoin(new Join(joinTableName, "ADSMUserGeneralDetails", splCaseJoinCrit, 1));
                } else {
                    query.addJoin(new Join(joinTableName, "ADSMUserGeneralDetails", splCaseJoinCrit, 2));
                }
            }
            if (this.o365LicenseFilterJoin != null) {
                query.addJoin(this.o365LicenseFilterJoin);
            }
            query.setCriteria(crit);
            DataObject dataobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            if (!dataobj.isEmpty()) {
                Iterator rows = dataobj.getRows(tableName);
                while (rows.hasNext()) {
                    Row row = (Row)rows.next();
                    waadUserDetList.put((Object)row.get(colName).toString());
                }
            }
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String actionClassName = request.getParameter("actionClass");
            if (actionClassName == null) {
                JSONObject mgmtActionDetails = WAADBulkMgmtUtil.getMgmtActionDetails(reportId);
                actionClassName = mgmtActionDetails.getString("ACTION_CLASS");
            }
            Class<?> actionClass = Class.forName(actionClassName);
            IWAADBulkMgmtListener iMgmtListener = (IWAADBulkMgmtListener)actionClass.newInstance();
            JSONObject rvcJsonObject = iMgmtListener.performMgmtAction(waadaccid, reportId, (Object)waadUserDetList, (Object)inputObj, request, loginId, rb);
            if (inputObj.has("showInputDetails")) {
                boolean showInputDetails = inputObj.getBoolean("showInputDetails");
            }
            if (onTheFlyMgmtReportId != 0) {
                JSONObject custParams = new JSONObject(rvcJsonObject.getString("customParams"));
                JSONObject mgmtActionDetails = WAADBulkMgmtUtil.getMgmtActionDetails(reportId);
                custParams.put("SCRIPT_HANDLER", (Object)mgmtActionDetails.getString("SCRIPT_HANDLER"));
                custParams.put("ACTION_CLASS", (Object)mgmtActionDetails.getString("ACTION_CLASS"));
                custParams.put("onTheFlyMgmtReportId", onTheFlyMgmtReportId);
                rvcJsonObject.put("customParams", (Object)custParams.toString());
            }
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(rvcJsonObject.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward refreshUsers(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            String message = new String();
            if (request.getParameter("WAADAccountId") != null && request.getParameter("WAADAccountId") != "") {
                String WAADAccountId = request.getParameter("WAADAccountId");
                int reportId = 46;
                String objectClass = "o365user";
                if (request.getParameter("reportId") != null) {
                    reportId = Integer.parseInt(request.getParameter("reportId"));
                }
                reportId = reportId == 8057 ? 8057 : (reportId == 8060 ? 65 : (reportId == 8061 ? 8061 : (reportId == 8062 ? 8062 : (reportId == 8058 || reportId == 8059 ? 8058 : 46))));
                WAADRefreshListener rlistener = new WAADRefreshListener(Long.valueOf(1L), WAADAccountId, "o365user", reportId, rb);
                message = rlistener.refresh();
                if (message != null && message.length() > 0) {
                    ClientUtil.setStatusXMLElement(response, "Message", rb.getString(message));
                    return null;
                }
            }
            if (request.getParameter("domainList") != null && request.getParameter("domainList") != "") {
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                JSONArray domainNameArray = new JSONArray(request.getParameter("domainList"));
                Hashtable<String, String> domainKey = new Hashtable<String, String>();
                for (int i = 0; i < domainNameArray.length(); ++i) {
                    String domainName = domainNameArray.getString(i);
                    String key = "";
                    key = request.getParameter("reportId") != null && request.getParameter("reportId").equalsIgnoreCase("8056") ? DomainHandler.updateDomain((String)domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"Mailbox"}) : DomainHandler.doReportSync((String)domainName, (Long)CommonUtil.ADMIN_LOGIN_ID, (String[])new String[]{"userReport"});
                    domainKey.put(key, domainName);
                    if (domainKey.isEmpty()) continue;
                    String syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                    while (syncStatus.equalsIgnoreCase("false")) {
                        try {
                            Thread.sleep(200L);
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        syncStatus = DomainProcess.getInstance().getProcessStatus(domainKey);
                    }
                }
            }
            ClientUtil.setStatusXMLElement(response, "Message", "");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward exportResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        WAADBulkMgmtUtil.exportO365MgmtResult(request, response);
        return null;
    }

    public ActionForward updateInputDetailsPreference(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            boolean showInputDetails = Boolean.parseBoolean(request.getParameter("isPinned"));
            BulkModificationAPI.updateConfigForHDT(loginId, "MGMT_SHOW_INPUT_DETAIL", showInputDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private void getO365LicenseFilterJoinAndCriteria(RVReqParams reqParams) {
        String baseTableName = "O365UserGeneralDetails";
        try {
            this.o365LicenseFilterJoin = null;
            this.o365LicenseFilterCriteria = null;
            JSONObject customParams = new JSONObject(reqParams.getCustomParams());
            String o365UserLicenseServiceMappingTableName = "O365UserLicenseServiceMapping";
            if (customParams.has("o365LicenseFilterType")) {
                String o365LicenseFilterType = customParams.getString("o365LicenseFilterType");
                if (o365LicenseFilterType.equals("any")) {
                    this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"IS_LICENSED"), (Object)"True", 0);
                } else if (o365LicenseFilterType.equals("none")) {
                    this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"IS_LICENSED"), (Object)"False", 0);
                } else if (o365LicenseFilterType.equals("custom")) {
                    Boolean isAllLicenses = customParams.get("customFilterType").equals("all");
                    if (isAllLicenses.booleanValue()) {
                        String o365UserTableName = "o365User";
                        String o365UserLicenseMappingTableName = "o365UserLicenseMapping";
                        SelectQueryImpl o365UserLMQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserLMQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserLMQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"));
                        o365UserLMQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserLMQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"));
                        SelectQueryImpl o365UserQuery = new SelectQueryImpl((Table)new DerivedTable(o365UserLicenseMappingTableName, (Query)o365UserLMQuery));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"OBJECT_ID"));
                        Criteria cri = null;
                        JSONArray selectedLicenses = customParams.getJSONArray("licenses");
                        for (int k = 0; k < selectedLicenses.length(); ++k) {
                            cri = cri == null ? new Criteria(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0) : cri.or(new Criteria(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0));
                        }
                        o365UserQuery.setCriteria(cri);
                        Column col = Column.getColumn(null, (String)"*").count();
                        GroupByColumn gc1 = new GroupByColumn(Column.getColumn((String)o365UserLicenseMappingTableName, (String)"OBJECT_ID"), true);
                        ArrayList<GroupByColumn> gcl = new ArrayList<GroupByColumn>();
                        gcl.add(gc1);
                        GroupByClause gbc = new GroupByClause(gcl, new Criteria(col, (Object)selectedLicenses.length(), 4));
                        o365UserQuery.setGroupByClause(gbc);
                        this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"), (Object)new DerivedColumn(o365UserTableName, (SelectQuery)o365UserQuery), 8);
                    } else {
                        String o365UserTableName = "o365User";
                        String o365UserLicenseMappingTableName = "o365UserLicenseMapping";
                        SelectQueryImpl o365UserQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        Criteria cri = null;
                        JSONArray selectedLicenses = customParams.getJSONArray("licenses");
                        for (int k = 0; k < selectedLicenses.length(); ++k) {
                            cri = cri == null ? new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0) : cri.or(new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)selectedLicenses.getString(k), 0));
                        }
                        o365UserQuery.setCriteria(cri);
                        this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"), (Object)new DerivedColumn(o365UserTableName, (SelectQuery)o365UserQuery), 8);
                    }
                } else if (o365LicenseFilterType.equals("advanced")) {
                    Criteria cri;
                    String ser;
                    String lic;
                    int k;
                    Criteria cr;
                    JSONArray o365alfSelected = customParams.getJSONArray("o365alfSelected");
                    SelectQueryImpl o365UserQuery = null;
                    String o365UserTableName = "o365User";
                    if (customParams.getString("advancedFilterType").equals("any")) {
                        o365UserQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        o365UserQuery.addGroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        cr = null;
                        for (k = 0; k < o365alfSelected.length(); ++k) {
                            lic = o365alfSelected.getJSONObject(k).getString("license_id");
                            ser = o365alfSelected.getJSONObject(k).getString("service_id");
                            cri = new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)lic, 0);
                            cri = cri.and(new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"SERVICES"), (Object)ser, 0));
                            cr = cr == null ? cri : cr.or(cri);
                        }
                        if (cr != null) {
                            o365UserQuery.setCriteria(cr);
                        }
                    }
                    if (customParams.getString("advancedFilterType").equals("all")) {
                        o365UserQuery = new SelectQueryImpl(Table.getTable((String)o365UserLicenseServiceMappingTableName, (String)o365UserLicenseServiceMappingTableName));
                        o365UserQuery.addSelectColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"));
                        cr = null;
                        for (k = 0; k < o365alfSelected.length(); ++k) {
                            lic = o365alfSelected.getJSONObject(k).getString("license_id");
                            ser = o365alfSelected.getJSONObject(k).getString("service_id");
                            cri = new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"LICENSES"), (Object)lic, 0);
                            cri = cri.and(new Criteria(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"SERVICES"), (Object)ser, 0));
                            cr = cr == null ? cri : cr.or(cri);
                        }
                        if (cr != null) {
                            o365UserQuery.setCriteria(cr);
                        }
                        Column col = Column.getColumn(null, (String)"*").count();
                        GroupByColumn gc1 = new GroupByColumn(Column.getColumn((String)o365UserLicenseServiceMappingTableName, (String)"OBJECT_ID"), true);
                        ArrayList<GroupByColumn> gcl = new ArrayList<GroupByColumn>();
                        gcl.add(gc1);
                        GroupByClause gbc = new GroupByClause(gcl, new Criteria(col, (Object)o365alfSelected.length(), 4));
                        o365UserQuery.setGroupByClause(gbc);
                    }
                    this.o365LicenseFilterCriteria = new Criteria(Column.getColumn((String)baseTableName, (String)"OBJECT_ID"), (Object)new DerivedColumn(o365UserTableName, (SelectQuery)o365UserQuery), 8);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.o365LicenseFilterJoin = null;
            this.o365LicenseFilterCriteria = null;
        }
    }
}

