/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.StatusUpdater;
import com.adventnet.sym.adsm.common.webclient.statusupdater.AbstractStatusUpdater;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import org.json.JSONArray;
import org.json.JSONObject;

public class WAADBulkMgmtStatusUpdator
extends AbstractStatusUpdater
implements StatusUpdater {
    private Long totalCount = 0L;
    private Integer dynamicSize = 25;
    private Boolean isCompleted = false;
    private boolean isStopped = false;
    private ArrayList currentResultRows = new ArrayList();
    private boolean isAllObjectsSucceeded = true;
    private String helpLink = "";
    private String commonErrorMessage = "";
    private boolean isCsvMgmt = false;

    public void init(DataObject rvcDataObject, Long cvcDataId) {
    }

    public void setCsvMgmt(boolean val) {
        this.isCsvMgmt = val;
    }

    public void updateCsvStatus(ArrayList<Hashtable> valuesList, String message) {
        try {
            int i = 0;
            JSONObject rowObj = new JSONObject();
            for (Hashtable hashtable1 : valuesList) {
                String ldapVal = "-";
                if (hashtable1.get("ATTRIB_VALUE") != null && hashtable1.get("ATTRIB_VALUE").toString().length() > 0) {
                    ldapVal = (String)hashtable1.get("ATTRIB_VALUE");
                }
                rowObj.put("" + i, (Object)ldapVal);
                ++i;
            }
            rowObj.put("" + i, (Object)message);
            this.currentResultRows.add(0, rowObj);
            while (this.currentResultRows.size() > this.dynamicSize) {
                this.currentResultRows.remove(this.currentResultRows.size() - 1);
            }
            Long l = this.totalCount;
            Long l2 = this.totalCount = Long.valueOf(this.totalCount + 1L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateStatus(Properties prop, String objClass, String guid) {
        if (prop != null) {
            this.currentResultRows.add(0, prop);
            while (this.currentResultRows.size() > this.dynamicSize) {
                this.currentResultRows.remove(this.currentResultRows.size() - 1);
            }
            Long l = this.totalCount;
            Long l2 = this.totalCount = Long.valueOf(this.totalCount + 1L);
        }
    }

    public void setIsCompleted(boolean flag) {
        this.isCompleted = flag;
    }

    public void setIsStopped(boolean isStopped) {
        this.isStopped = isStopped;
    }

    public int getCurrentTaskCode() {
        return 0;
    }

    public void setProgressTask(int taskCode) {
    }

    public void setTaskObject(Object obj) {
    }

    public void setTaskError(Object error) {
    }

    public Hashtable getTaskErrors(AdventNetResourceBundle rb) {
        return new Hashtable();
    }

    public JSONObject getJSONObject(JSONObject jsonObject, AdventNetResourceBundle rb) {
        JSONObject statusJson = new JSONObject();
        JSONArray filterDetails = new JSONArray();
        try {
            statusJson.put("isCompleted", (Object)this.isCompleted);
            statusJson.put("count", (Object)this.totalCount);
            JSONObject json = null;
            JSONArray rvFilterIdArray = (JSONArray)jsonObject.get("rvFilterIdList");
            JSONArray filterIdAttributeList = (JSONArray)jsonObject.get("filterIdAttributeList");
            try {
                for (int index = 0; index < rvFilterIdArray.length(); ++index) {
                    json = new JSONObject();
                    int filterId = (Integer)rvFilterIdArray.get(index);
                    json.put("filterId", filterId);
                    json.put("count", (Object)this.totalCount);
                    if (!this.isCsvMgmt) {
                        JSONArray attributeList = (JSONArray)filterIdAttributeList.get(index);
                        json.put("rowData", (Object)this.getRowDetails(attributeList, rb));
                    } else {
                        json.put("rowData", (Object)this.getCsvRowDetails(rb));
                    }
                    filterDetails.put((Object)json);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            statusJson.put("filterDetails", (Object)filterDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusJson;
    }

    private JSONArray getCsvRowDetails(AdventNetResourceBundle rb) {
        JSONArray rowDetails = new JSONArray();
        try {
            for (int index = 0; this.currentResultRows != null && index < this.currentResultRows.size(); ++index) {
                rowDetails.put(this.currentResultRows.get(index));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowDetails;
    }

    private JSONArray getRowDetails(JSONArray attribList, AdventNetResourceBundle rb) {
        JSONArray rowDetails = new JSONArray();
        try {
            for (int index = 0; this.currentResultRows != null && index < this.currentResultRows.size(); ++index) {
                JSONArray rowJsonObj = new JSONArray();
                Properties prop = (Properties)this.currentResultRows.get(index);
                for (int innerIndex = 0; innerIndex < attribList.length(); ++innerIndex) {
                    String val = "-";
                    Integer attribId = (Integer)attribList.get(innerIndex);
                    if (prop.containsKey(attribId)) {
                        String value = (String)prop.get(attribId);
                        val = attribId == 709 ? "********" : ClientUtil.htmlEscape(rb.getString(value));
                    }
                    rowJsonObj.put((Object)val);
                }
                rowDetails.put((Object)rowJsonObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return rowDetails;
    }

    public boolean isCompleted() {
        return this.isCompleted;
    }

    public boolean isStopped() {
        return this.isStopped;
    }

    public void setIsAllObjectsSucceeded(boolean isSucceeded) {
        this.isAllObjectsSucceeded = isSucceeded;
    }

    public boolean getIsAllObjectsSucceeded() {
        return this.isAllObjectsSucceeded;
    }

    public void setHelpLink(String helpLink) {
        this.helpLink = helpLink;
    }

    public String getHelpLink() {
        return this.helpLink;
    }

    public void setCommonErrorMessage(String commonErrorMessage) {
        this.commonErrorMessage = commonErrorMessage;
    }

    public String getCommonErrorMessage() {
        return this.commonErrorMessage;
    }

    public ArrayList getCriterias() {
        return new ArrayList();
    }

    public String getDefaultStatusMessage(AdventNetResourceBundle rb) {
        return rb.getString("admp.mgmt.fileserver.perm_mgmt.stat_msg.empty_result");
    }

    public void init(DataObject rvcDataObject) {
    }

    public void updateStatus(JSONArray jsonArray, String domainName) {
    }

    public void updateErrorStatus(Hashtable errors) {
    }

    public ArrayList<Hashtable> getErrorList() {
        return null;
    }

    public JSONObject getMultiDCDetails() {
        return null;
    }

    public void init(Hashtable reportDomains) {
    }

    public void setProperties(String baseTableName, boolean isSyncEnabled, boolean isRowsUpdatedBySync) {
    }

    public void setIsRowUpdatedBySync(boolean isRowsUpdatedBySync) {
    }
}

