/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.waad;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.RVColumnUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.JRFieldDesignUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportExportUtil;
import com.adventnet.sym.adsm.common.webclient.reports.ReportJRDataSource;
import com.adventnet.sym.adsm.common.webclient.transformers.Transformers;
import com.adventnet.sym.adsm.common.webclient.waad.WAADBulkMgmtAction;
import java.io.File;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperFillManager;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignBand;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.json.JSONArray;
import org.json.JSONObject;

public class WAADBulkMgmtUtil {
    public static synchronized long getNewGenerationId(Integer reportId, Long loginId) {
        long generationId = 0L;
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row r = new Row("ADSMObjectGenerationDetails");
            r.set("LOGIN_ID", (Object)loginId);
            r.set("REPORT_ID", (Object)reportId);
            r.set("CREATION_TIME", (Object)new Long(System.currentTimeMillis()));
            r.set("STATUS", (Object)1L);
            r.set("REPORT_GENERATION_NAME", (Object)new Date().toString());
            r.set("DESCRIPTION", (Object)"");
            dataObj.addRow(r);
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
            generationId = (Long)r.get("REPORT_GENERATION_ID");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return generationId;
    }

    public static JSONObject getMgmtActionDetails(Integer reportId) {
        JSONObject mgmtActionDetails = new JSONObject();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"O365BulkMgmtOperations", (String)"REPORT_ID"), (Object)reportId, 0);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("O365BulkMgmtOperations", crit);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow("O365BulkMgmtOperations");
                mgmtActionDetails.put("REPORT_ID", (Object)reportId);
                mgmtActionDetails.put("SCRIPT_HANDLER", (Object)((String)r.get("SCRIPT_HANDLER")));
                mgmtActionDetails.put("ACTION_CLASS", (Object)((String)r.get("ACTION_CLASS")));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mgmtActionDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void exportO365MgmtResult(HttpServletRequest request, HttpServletResponse response) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            Locale locale = request.getLocale();
            Hashtable multipleValuesSids = new Hashtable();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            long generationId = Long.parseLong(request.getParameter("generationId"));
            Integer reportId = Integer.parseInt(request.getParameter("reportId"));
            String reportType = request.getParameter("reportType");
            String baseTableName = "O365UserGeneralDetails";
            String otherTableName = "ADSMUserGeneralDetails";
            if (reportId.equals(WAADBulkMgmtAction.O365_REMOTE_REPORT_ID)) {
                baseTableName = "ADSMMailBoxObjects";
            } else if (reportId.equals(WAADBulkMgmtAction.O365_HIDE_LISTS_REPORT_ID) || reportId.equals(WAADBulkMgmtAction.O365_EMAIL_LIMITS_REPORT_ID)) {
                baseTableName = "O365UserExchangeDetails";
                otherTableName = "O365UserGeneralDetails";
            }
            JSONObject customParams = new JSONObject(request.getParameter("customParams"));
            ArrayList<Integer> attributeIdList = new ArrayList<Integer>();
            ArrayList resultList = new ArrayList();
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            ArrayList attributeListProps = new ArrayList();
            if (customParams.getBoolean("isCsvMgmt")) {
                baseTableName = "ADSMAUNamingAttributes";
                JSONArray headerJsonArray = customParams.getJSONArray("headerJsonArray");
                ArrayList columns = new ArrayList();
                selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"));
                for (int i = 0; i < headerJsonArray.length(); ++i) {
                    ArrayList l;
                    String currentHeader = headerJsonArray.getString(i);
                    Hashtable attributesdetails = null;
                    if (currentHeader.equalsIgnoreCase("UserPrincipalName") && reportId.equals(WAADBulkMgmtAction.O365_CRT_USER_REPORT_ID)) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1005"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (reportId.equals(WAADBulkMgmtAction.O365_REMOTE_REPORT_ID)) {
                        if (currentHeader.equalsIgnoreCase("UserPrincipalName")) {
                            l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4012"}, (String)"ATTRIB_ID", null);
                            attributesdetails = (Hashtable)l.get(0);
                        } else if (currentHeader.equalsIgnoreCase("ObjectId")) {
                            l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4011"}, (String)"ATTRIB_ID", null);
                            attributesdetails = (Hashtable)l.get(0);
                        } else if (currentHeader.equalsIgnoreCase("objectGuid")) {
                            l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4011"}, (String)"ATTRIB_ID", null);
                            attributesdetails = (Hashtable)l.get(0);
                        } else if (currentHeader.equalsIgnoreCase("samAccountName")) {
                            l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4014"}, (String)"ATTRIB_ID", null);
                            attributesdetails = (Hashtable)l.get(0);
                        } else if (currentHeader.equalsIgnoreCase("distinguishedName")) {
                            l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"4013"}, (String)"ATTRIB_ID", null);
                            attributesdetails = (Hashtable)l.get(0);
                        }
                    } else if (currentHeader.equalsIgnoreCase("UserPrincipalName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17004"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("ObjectId")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"17001"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("objectGuid")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1145"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("samAccountName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1006"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else if (currentHeader.equalsIgnoreCase("distinguishedName")) {
                        l = ReportAttributesUtil.getAttributeProps((String[])new String[]{"1004"}, (String)"ATTRIB_ID", null);
                        attributesdetails = (Hashtable)l.get(0);
                    } else {
                        attributesdetails = AddUserHandler.getInstance().getAttributeDetails("ATTRIB_LDAP_NAME", (Object)currentHeader);
                    }
                    columns.add(attributesdetails.get("ATTRIB_COLUMN_NAME"));
                    selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)((String)attributesdetails.get("ATTRIB_COLUMN_NAME"))));
                    attributeIdList.add((Integer)attributesdetails.get("ATTRIB_ID"));
                }
                selectColumnList.add(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"));
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
                query.addSelectColumns(selectColumnList);
                Long userCreationID = customParams.getLong("userCreationID");
                Criteria userCreationCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_CREATION_ID"), (Object)userCreationID, 0);
                JSONArray selectedUsersList = customParams.getJSONArray("userIndexes");
                String[] userIndexes = StrUtil.getStringArray((JSONArray)selectedUsersList);
                Criteria userIndexesCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"USER_INDEX"), (Object)userIndexes, 8);
                Criteria msgCrit = new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"), null, 1);
                msgCrit.and(new Criteria(Column.getColumn((String)"ADSMAUNamingAttributes", (String)"CREATION_MESSAGE"), (Object)"", 1));
                Criteria crit = userCreationCrit.and(userIndexesCrit);
                crit = crit.and(msgCrit);
                query.setCriteria(crit);
                query.addSortColumn(new SortColumn("ADSMAUNamingAttributes", "USER_INDEX", true));
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQuery((Query)query, connection);
                HashMap pwdMap = null;
                String tempTable = "ADSMUserBUMDetails_" + String.valueOf(userCreationID);
                TableDefinition td = MetaDataUtil.getTableDefinitionByName((String)tempTable);
                if (td != null) {
                    AddUserHandler.getInstance();
                    pwdMap = AddUserHandler.getFromBulkUserLayoutTempTable((String)tempTable);
                }
                while (dataSet.next()) {
                    Hashtable<Object, Object> resultTable = new Hashtable<Object, Object>();
                    Long userIdx = (Long)dataSet.getValue("USER_INDEX");
                    for (int i = 0; i < attributeIdList.size(); ++i) {
                        String colName = (String)columns.get(i);
                        if (colName.equalsIgnoreCase("PASSWORD")) {
                            if (PasswordUtil.getShowPasswordValue()) {
                                resultTable.put(attributeIdList.get(i), "********");
                                continue;
                            }
                            if (pwdMap != null && userIdx != null) {
                                String pwdVal = (String)pwdMap.get(userIdx);
                                if (pwdVal != null) {
                                    resultTable.put(attributeIdList.get(i), pwdVal);
                                    continue;
                                }
                                resultTable.put(attributeIdList.get(i), "-");
                                continue;
                            }
                            if (dataSet.getValue(colName) != null) {
                                resultTable.put(attributeIdList.get(i), dataSet.getValue(colName));
                                continue;
                            }
                            resultTable.put(attributeIdList.get(i), "-");
                            continue;
                        }
                        Object obj = dataSet.getValue(colName);
                        resultTable.put(attributeIdList.get(i), obj);
                    }
                    resultTable.put("MESSAGE", rb.getString((String)dataSet.getValue("CREATION_MESSAGE")));
                    resultList.add(resultTable);
                }
            } else {
                Join join;
                String joinTableName = new String();
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)baseTableName));
                if (reportId.equals(WAADBulkMgmtAction.O365_CRT_USER_REPORT_ID)) {
                    joinTableName = "WAADCreateUserResult";
                    query = new SelectQueryImpl(Table.getTable((String)joinTableName));
                    join = new Join(joinTableName, baseTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 1);
                    query.addJoin(join);
                    join = new Join(joinTableName, otherTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                    query.addJoin(join);
                } else if (reportId.equals(WAADBulkMgmtAction.O365_REMOTE_REPORT_ID)) {
                    joinTableName = "WAADCreateUserResult";
                    query = new SelectQueryImpl(Table.getTable((String)joinTableName));
                    join = new Join(joinTableName, baseTableName, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
                    query.addJoin(join);
                } else if (reportId.equals(WAADBulkMgmtAction.O365_HIDE_LISTS_REPORT_ID) || reportId.equals(WAADBulkMgmtAction.O365_EMAIL_LIMITS_REPORT_ID)) {
                    joinTableName = "ADSMModifyUserResult";
                    query = new SelectQueryImpl(Table.getTable((String)baseTableName));
                    join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_GUID"}, 1);
                    query.addJoin(join);
                    join = new Join(baseTableName, otherTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 2);
                    query.addJoin(join);
                } else {
                    joinTableName = "ADSMModifyUserResult";
                    join = new Join(baseTableName, joinTableName, new String[]{"OBJECT_ID"}, new String[]{"OBJECT_GUID"}, 2);
                    query.addJoin(join);
                }
                boolean relationalTypePresent = false;
                attributeListProps = ReportAttributeHandler.getInstance().getViewColumn(reportId);
                boolean exchOnlineAttribPresent = false;
                for (int i = 0; i < attributeListProps.size(); ++i) {
                    Properties attributeProperties = (Properties)attributeListProps.get(i);
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    if (relationalType.equals(new Integer(1))) {
                        relationalTypePresent = true;
                        continue;
                    }
                    String table = attributeProperties.getProperty("TABLE_NAME");
                    if (table.equalsIgnoreCase("O365UserExchangeDetails")) {
                        exchOnlineAttribPresent = true;
                    }
                    Column column = new Column(table, attributeProperties.getProperty("ATTRIB_COLUMN_NAME"));
                    selectColumnList.add(column);
                }
                if (exchOnlineAttribPresent && (reportId.equals(WAADBulkMgmtAction.O365_PROXY_ADDRESSES_REPORT_ID) || reportId.equals(WAADBulkMgmtAction.O365_INPLACE_ARCHIVE_MGMT_REPORT_ID) || reportId.equals(WAADBulkMgmtAction.O365_LIT_HOLD_MGMT_REPORT_ID))) {
                    Join join2 = new Join(baseTableName, "O365UserExchangeDetails", new String[]{"OBJECT_ID"}, new String[]{"OBJECT_ID"}, 1);
                    query.addJoin(join2);
                }
                Column objIdColumn = new Column();
                if (reportId.equals(WAADBulkMgmtAction.O365_CRT_USER_REPORT_ID)) {
                    objIdColumn = Column.getColumn((String)joinTableName, (String)"OBJECT_GUID");
                    selectColumnList.add(objIdColumn);
                    objIdColumn = Column.getColumn((String)baseTableName, (String)"OBJECT_ID");
                    selectColumnList.add(objIdColumn);
                } else if (reportId.equals(WAADBulkMgmtAction.O365_REMOTE_REPORT_ID)) {
                    objIdColumn = Column.getColumn((String)joinTableName, (String)"OBJECT_GUID");
                    selectColumnList.add(objIdColumn);
                } else {
                    objIdColumn = Column.getColumn((String)baseTableName, (String)"OBJECT_ID");
                    if (!selectColumnList.contains(objIdColumn)) {
                        selectColumnList.add(objIdColumn);
                    }
                }
                selectColumnList.add(Column.getColumn((String)joinTableName, (String)"MESSAGE"));
                query.addSelectColumns(selectColumnList);
                if (reportId.equals(WAADBulkMgmtAction.O365_REMOTE_REPORT_ID)) {
                    query.addSortColumn(new SortColumn(baseTableName, "LOGON_NAME", true));
                } else {
                    query.addSortColumn(new SortColumn(baseTableName, "USER_PRINCIPAL_NAME", true));
                }
                Criteria criteria = new Criteria(Column.getColumn((String)joinTableName, (String)"REPORT_GENERATION_ID"), (Object)generationId, 0);
                query.setCriteria(criteria);
                RelationalAPI relationalAPI = RelationalAPI.getInstance();
                connection = relationalAPI.getConnection();
                dataSet = relationalAPI.executeQuery((Query)query, connection);
                while (dataSet.next()) {
                    String message;
                    Hashtable<Object, Object> resultTable = new Hashtable<Object, Object>();
                    for (int i = 0; i < attributeListProps.size(); ++i) {
                        Properties attributeProperties = (Properties)attributeListProps.get(i);
                        Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                        if (relationalType.equals(new Integer(1))) continue;
                        String columnName = attributeProperties.getProperty("ATTRIB_COLUMN_NAME");
                        Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                        String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                        if (dataSet.getValue(columnName) == null) continue;
                        if (columnName.equalsIgnoreCase("PASSWORD") && PasswordUtil.getShowPasswordValue()) {
                            resultTable.put(attributeId, "********");
                            continue;
                        }
                        Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                        HashMap<String, Object> colDetails = new HashMap<String, Object>();
                        colDetails.put("TRIM_SIZE", attributeProperties.get("TRIM_SIZE"));
                        Object columnValue = uiTransformer.renderCell(rb, columnName, dataSet.getValue(columnName), colDetails, new HashMap(), true);
                        resultTable.put(attributeId, columnValue);
                    }
                    String objId = new String();
                    ArrayList objIdMap = new ArrayList();
                    objId = !reportId.equals(WAADBulkMgmtAction.O365_REMOTE_REPORT_ID) && dataSet.getValue("OBJECT_ID") != null ? (String)dataSet.getValue("OBJECT_ID") : (String)dataSet.getValue("OBJECT_GUID");
                    if (relationalTypePresent) {
                        multipleValuesSids.put(objId, new Hashtable());
                    }
                    if (objId != null) {
                        resultTable.put("OBJECT_GUID", objId);
                    }
                    if ((message = (String)dataSet.getValue("MESSAGE")).contains(rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"))) {
                        message = message.replace(rb.getString("admp.mgmt.o365.exchange_online_later_click_to_view"), rb.getString("admp.mgmt.o365.exchange_online_later"));
                    }
                    if (message != null) {
                        resultTable.put("MESSAGE", rb.getString(message));
                    }
                    resultList.add(resultTable);
                }
            }
            ArrayList attributeList = attributeIdList.isEmpty() ? attributeListProps : ReportAttributeHandler.getInstance().getAttributeProps(attributeIdList);
            Properties props = new Properties();
            props.put("ATTRIB_COLUMN_NAME", "STATUS");
            props.put("ATTRIB_DISP_NAME", rb.getString("admp.mgmt.user_mgmt.naming_attribs.statmsg.status"));
            props.put("ATTRIB_LDAP_NAME", "status");
            props.put("ATTRIB_ID", (Object)100000);
            props.put("RELATIONAL_TYPE", (Object)0);
            attributeList.add(props);
            ReportHandler.getMultipleValues((ArrayList)attributeList, multipleValuesSids, (String)"OBJECT_ID");
            WAADBulkMgmtUtil.getCustomizedMultipleValues(multipleValuesSids, reportId, rb);
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "ModifyUser.xml";
            String reportName = request.getParameter("reportName");
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("loginId", loginId);
            if (reportId.equals(WAADBulkMgmtAction.O365_REMOTE_REPORT_ID)) {
                inputParams.put("domainTxt", rb.getString("admp.common.attrib_disp_name.dn_domain_name"));
                inputParams.put("domain", customParams.getString("adDomain"));
            } else {
                inputParams.put("domainTxt", rb.getString("admp.common.text.account"));
                inputParams.put("domain", request.getParameter("waadAccId"));
            }
            inputParams.put("actionTxt", rb.getString("admp.deleg.hdt_deleg.cre_hdt.text_action"));
            inputParams.put("modifyType", rb.getString(reportName));
            inputParams.put("Generated at", rb.getString("admp.reports_export.pageheader.generated_at"));
            inputParams.put("Page", rb.getString("admp.reports_export.pagefooter.page"));
            JasperDesign jasperDesign = JRXmlLoader.load((String)reportFileName);
            reportFileName = "ADMPReport";
            ReportJRDataSource dataSource = new ReportJRDataSource(resultList, multipleValuesSids, reportType);
            JRFieldDesignUtil.alignBands(reportType, jasperDesign, inputParams);
            JRDesignBand headerBand = (JRDesignBand)jasperDesign.getColumnHeader();
            JRDesignBand detailBand = (JRDesignBand)jasperDesign.getDetail();
            Hashtable columnWidths = JRDesignUtil.calculateWidth(attributeList, resultList, multipleValuesSids, reportType, request, rb);
            JRDesignUtil.fillBand(columnWidths, jasperDesign, headerBand, detailBand, attributeList, reportType, null, 0, rb, loginId, locale);
            JasperReport jasperReport = JasperCompileManager.compileReport((JasperDesign)jasperDesign);
            JasperPrint print = JasperFillManager.fillReport((JasperReport)jasperReport, inputParams, (JRDataSource)dataSource);
            print.setName(JRFieldDesignUtil.getXlsxSheetName(rb.getString(reportName)));
            ReportExportUtil.exportReport(reportType, request, response, print, reportFileName, loginId);
            DBUtil.closeDataSetAndConnection((DataSet)dataSet, (Connection)connection);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            DBUtil.closeDataSetAndConnection(dataSet, connection);
        }
    }

    private static void getCustomizedMultipleValues(Hashtable multipleValueSids, Integer reportId, AdventNetResourceBundle rb) {
        try {
            ArrayList attributeList = RVColumnUtil.getViewColumnList((Long)1L, (int)reportId);
            Enumeration e = multipleValueSids.keys();
            while (e.hasMoreElements()) {
                HashMap inputValues = new HashMap();
                Object objectId = e.nextElement();
                inputValues.put("OBJECT_ID", objectId);
                Hashtable attributeIds = (Hashtable)multipleValueSids.get(objectId);
                if (attributeIds == null) continue;
                for (int index = 0; index < attributeList.size(); ++index) {
                    HashMap attributeProperties = (HashMap)attributeList.get(index);
                    String columnName = (String)attributeProperties.get("ATTRIB_COLUMN_NAME");
                    Integer attributeId = (Integer)attributeProperties.get("ATTRIB_ID");
                    Integer relationalType = (Integer)attributeProperties.get("RELATIONAL_TYPE");
                    String transformerClassName = (String)attributeProperties.get("TRANSFORMER_CLASS");
                    if (!relationalType.equals(1)) continue;
                    ArrayList mulitpleValueList = (ArrayList)attributeIds.get(attributeId);
                    Transformers uiTransformer = (Transformers)Class.forName(transformerClassName.trim()).newInstance();
                    uiTransformer.renderCell(rb, columnName, mulitpleValueList, attributeProperties, inputValues, true);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getDirSyncJoinCrit(String waadaccid) {
        Hashtable<String, Object> retHashtable = new Hashtable<String, Object>();
        try {
            SelectQueryImpl q = new SelectQueryImpl(Table.getTable((String)"WAADADMapping"));
            q.addSelectColumn(Column.getColumn((String)"WAADADMapping", (String)"WAAD_DOMAIN_ID"));
            q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"));
            q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"TABLE_NAME"));
            q.addSelectColumn(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_COLUMN_NAME"));
            q.addJoin(new Join("WAADADMapping", "ADSMWAADDomainConfiguration", new String[]{"WAAD_DOMAIN_ID"}, new String[]{"WAAD_DOMAIN_ID"}, 2));
            q.addJoin(new Join("WAADADMapping", "ADSMAttributeDetails", new String[]{"ATTRIB_ID"}, new String[]{"ATTRIB_ID"}, 2));
            Criteria attrCrit = new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"WAAD_TENANT_ID"), (Object)waadaccid, 0);
            attrCrit = attrCrit.and(new Criteria(Column.getColumn((String)"ADSMWAADDomainConfiguration", (String)"IAMAPP_ID"), (Object)3, 0));
            attrCrit = attrCrit.and(new Criteria(Column.getColumn((String)"WAADADMapping", (String)"AD_OBJECT_CLASS_NAME"), (Object)"user", 0));
            q.setCriteria(attrCrit);
            DataObject joinAttrDataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)q);
            String joinColumnName = new String();
            String joinTableName = new String();
            if (!joinAttrDataObj.isEmpty()) {
                Row r = joinAttrDataObj.getFirstRow("ADSMAttributeDetails");
                joinTableName = (String)r.get("TABLE_NAME");
                joinColumnName = (String)r.get("ATTRIB_COLUMN_NAME");
            }
            Criteria splCaseJoinCrit = null;
            Criteria joinCrit = new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID"), (Object)Column.getColumn((String)joinTableName, (String)joinColumnName), 0);
            joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"DECODED_IMMUTABLE_ID"), (Object)"-", 1));
            joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"O365UserGeneralDetails", (String)"IS_DELETED"), (Object)0, 1));
            if (joinTableName.equalsIgnoreCase("ADSMUserGeneralDetails")) {
                joinCrit = joinCrit.and(new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0));
            } else {
                splCaseJoinCrit = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"IS_DELETED"), (Object)1, 0);
                splCaseJoinCrit = splCaseJoinCrit.and(new Criteria(Column.getColumn((String)joinTableName, (String)"OBJECT_GUID"), (Object)Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), 0));
            }
            if (joinCrit != null) {
                retHashtable.put("joinCrit", joinCrit);
            }
            if (splCaseJoinCrit != null) {
                retHashtable.put("splCaseJoinCrit", splCaseJoinCrit);
            }
            if (joinTableName.length() > 0) {
                retHashtable.put("joinTableName", joinTableName);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return retHashtable;
    }
}

