/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.workflow.WFAssignToRule;
import com.adventnet.sym.adsm.common.server.workflow.WFAssigningRuleUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkflowConfigDataCacheUtil;
import com.adventnet.sym.adsm.common.webclient.admin.AdminUtil;
import com.adventnet.sym.adsm.common.webclient.util.ajax.AjaxUtil;
import java.io.PrintWriter;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class AssigningRuleAction
extends DispatchAction {
    private static Logger out = Logger.getLogger("AssigningRuleAction");

    public ActionForward viewAssigningRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("AssigningRule");
    }

    public ActionForward prioritizeAssignRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        ArrayList rulesList = WFRuleHandler.getAssignRuleListNameIdAlone();
        request.setAttribute("rulesList", (Object)rulesList);
        return mapping.findForward("prioritizeAssignRule");
    }

    public ActionForward savePrioritizeAssignRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String substring = request.getParameter("substring");
            StringTokenizer substringTokenizer = new StringTokenizer(substring, ",");
            Hashtable<Long, Integer> orderedAssignRule = new Hashtable<Long, Integer>();
            int i = 0;
            while (substringTokenizer.hasMoreTokens()) {
                Long ruleId = new Long(substringTokenizer.nextToken());
                orderedAssignRule.put(ruleId, new Integer(++i));
            }
            if (WFAssigningRuleUtil.savePrioritizeAssignRule(orderedAssignRule)) {
                request.setAttribute("message", (Object)rb.getString("admp.workflow.assignrule.reoroder.success_message"));
            } else {
                request.setAttribute("message", (Object)rb.getString("admp.workflow.assignrule.reoroder.error_message"));
            }
            ArrayList rulesList = WFRuleHandler.getAssignRuleListNameIdAlone();
            request.setAttribute("rulesList", (Object)rulesList);
            return mapping.findForward("prioritizeAssignRule");
        }
        catch (Exception e) {
            e.printStackTrace();
            return mapping.findForward("WFAddRemoveColumn");
        }
    }

    public ActionForward changeRuleStatus(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long ruleID = new Long(request.getParameter("ruleID"));
        String currentStatus = request.getParameter("status");
        if (currentStatus.equals("ENABLED")) {
            Boolean isSuccess = WFAssigningRuleUtil.setRuleStatus((Long)ruleID, (String)"DISABLED");
            AjaxUtil.writeResponse(response, isSuccess.toString());
        } else {
            Boolean isSuccess = WFAssigningRuleUtil.setRuleStatus((Long)ruleID, (String)"ENABLED");
            AjaxUtil.writeResponse(response, isSuccess.toString());
        }
        return null;
    }

    public ActionForward isdeleteRuleAllowed(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long ruleId = new Long(request.getParameter("RULE_ID"));
        ArrayList list = WFAssigningRuleUtil.getOpenRequestsForRule((long)ruleId);
        PrintWriter writer = response.getWriter();
        Boolean isAllowed = true;
        if (list.size() > 0) {
            isAllowed = false;
        }
        writer.print(isAllowed);
        return null;
    }

    public ActionForward deleteAssignToRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Long ruleID = new Long(request.getParameter("ruleID"));
            Boolean isSuccess = WFAssigningRuleUtil.deleteAssigningRule((Long)ruleID);
            AjaxUtil.writeResponse(response, isSuccess.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AjaxUtil.writeResponse(response, rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_deleting_helpDesk_roles"));
        }
        return null;
    }

    public ActionForward showAssignToListDiv(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Long ruleID = new Long(request.getParameter("ruleID"));
            ArrayList TechnicianList = WFAssigningRuleUtil.getAssigningTechnicianList((Long)ruleID);
            request.setAttribute("technicianList", (Object)TechnicianList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return mapping.findForward("showAssignToList");
    }

    public ActionForward removeTechnicianFromRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Long uniqueId = new Long(request.getParameter("uniqueId"));
            Boolean isSuccess = WFAssigningRuleUtil.removeTechnicianFromRule((Long)uniqueId);
            AjaxUtil.writeResponse(response, isSuccess.toString());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            AjaxUtil.writeResponse(response, rb.getString("admp.deleg.hdt_deleg.cre_role.statmsg.error_in_deleting_helpDesk_roles"));
        }
        return null;
    }

    public ActionForward addRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        WFAssignToRule ruleDetails = new WFAssignToRule(rb);
        ArrayList criteriaList = WorkflowConfigDataCacheUtil.getQueryConstantList();
        ArrayList priorityList = WorkflowConfigDataCacheUtil.getRequestPriorityList();
        ArrayList triggerTabList = WFAssigningRuleUtil.getWFRuleTabList();
        request.setAttribute("triggerTabList", (Object)triggerTabList);
        request.setAttribute("priorityList", (Object)priorityList);
        request.setAttribute("ruledetails", (Object)ruleDetails);
        request.setAttribute("criteriaList", (Object)criteriaList);
        return mapping.findForward("AddRules");
    }

    public ActionForward editRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long ruleId = new Long(request.getParameter("ruleID"));
        WFAssignToRule ruleDetails = new WFAssignToRule(ruleId, rb);
        ruleDetails.initRuleResultData(false);
        ArrayList priorityList = WorkflowConfigDataCacheUtil.getRequestPriorityList();
        ArrayList triggerTabList = WFAssigningRuleUtil.getWFRuleTabList();
        request.setAttribute("triggerTabList", (Object)triggerTabList);
        request.setAttribute("priorityList", (Object)priorityList);
        request.setAttribute("ruledetails", (Object)ruleDetails);
        return mapping.findForward("AddRules");
    }

    public ActionForward getNewConditionField(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        request.setAttribute("ruleId", (Object)new Long(request.getParameter("ruleId")));
        request.setAttribute("fieldOrder", (Object)new Integer(request.getParameter("fieldOrder")));
        request.setAttribute("ruleFieldId", (Object)new Long(request.getParameter("ruleFieldId")));
        return mapping.findForward("createRuleConditionField");
    }

    public ActionForward checkRuleExists(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Long ruleID = new Long(request.getParameter("ruleID"));
        String ruleName = request.getParameter("ruleName");
        boolean isRuleNameExists = WFAssigningRuleUtil.checkRuleNameExists((Long)ruleID, (String)ruleName);
        PrintWriter writer = null;
        try {
            writer = response.getWriter();
            response.setContentType("text/html");
            writer.print(isRuleNameExists + "");
            writer.flush();
            writer.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward saveOrUpdateRule(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        PrintWriter writer = null;
        try {
            String params = request.getParameter("params");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            JSONObject json = new JSONObject(params);
            WFAssignToRule wfAssignToRule = new WFAssignToRule(json, rb);
            Long ruleId = wfAssignToRule.getRuleID();
            Boolean isSuccess = false;
            String message = rb.getString("admp.workflow.assigingRule.message_updated_status_success");
            if (ruleId != null && ruleId != 0L) {
                isSuccess = WFRuleHandler.updateAssigninRule((WFAssignToRule)wfAssignToRule, (AdventNetResourceBundle)rb);
            } else {
                isSuccess = WFRuleHandler.saveAssigningRule((WFAssignToRule)wfAssignToRule, (AdventNetResourceBundle)rb);
                message = rb.getString("admp.workflow.assigingRule.message_added_status_success");
            }
            if (!isSuccess.booleanValue()) {
                message = rb.getString("admp.auto.auto_policy.create_policy.text.automation_name_exists.error.message");
            } else {
                AdminUtil.setRefValue("HAS_USER_DEFINED_WORKFLOWS", true);
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("isSuccess", (Object)isSuccess);
            jsonObj.put("message", (Object)message);
            writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward showRuleRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        Long cvId = ColumnConfiguration.getCVId((String)"WFASSIGNINGRULE", (long)loginId);
        if (cvId == null) {
            cvId = ColumnConfiguration.getDefaultCvId((String)"WFASSIGNINGRULE");
        }
        ArrayList columnList = ColumnConfiguration.getTotalColumnList((long)cvId);
        JSONArray conditionfieldsArray = WFAssigningRuleUtil.getWFRuleConditionFields();
        ArrayList matchCriteria = WorkflowConfigDataCacheUtil.getQueryConstantList();
        String[] searchColumns = new String[]{"RULE_NAME", "RULE_DESC"};
        String params = request.getParameter("params");
        JSONObject jsonObject = new JSONObject(params);
        JSONObject pageNavigation = jsonObject.getJSONObject("pageNavigation");
        String searchText = URLDecoder.decode(jsonObject.getString("searchText"), "UTF-8").replace("\\", "\\\\");
        jsonObject.put("searchText", (Object)searchText);
        int range = pageNavigation.getInt("range");
        boolean isNavigate = pageNavigation.getBoolean("isNavigate");
        if (!isNavigate) {
            NavigateRangeUtil.setDefaultRange((String)"WFRulesList", (int)range, (Long)loginId);
        }
        Integer count = WFRuleHandler.getWFRulesCount((String)searchText, (String[])searchColumns);
        LinkedHashMap rulesList = WFRuleHandler.getWFRulesList((ArrayList)columnList, (AdventNetResourceBundle)rb, (JSONArray)conditionfieldsArray, (ArrayList)matchCriteria, (String[])searchColumns, (JSONObject)jsonObject);
        request.setAttribute("count", (Object)count);
        request.setAttribute("columnList", (Object)ColumnConfiguration.getViewColumnList((long)cvId));
        request.setAttribute("rulesList", (Object)rulesList);
        return mapping.findForward("showRulesList");
    }

    public ActionForward getRuleFieldComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String fieldDetailsStr = request.getParameter("fieldDetailsStr");
        Long ruleFieldId = new Long(request.getParameter("ruleFieldId"));
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            JSONObject fieldDetailsJsonObj = new JSONObject(fieldDetailsStr);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            JSONObject componentDetailsObj = WFAssigningRuleUtil.getComponentDetails((JSONObject)fieldDetailsJsonObj, null, (Long)loginId, (AdventNetResourceBundle)rb);
            request.setAttribute("componentDetails", (Object)componentDetailsObj.toString());
            request.setAttribute("ruleFieldId", (Object)ruleFieldId);
            request.setAttribute("defaultComponentId", (Object)fieldDetailsJsonObj.getLong("defaultComponentId"));
            request.setAttribute("popUpId", (Object)fieldDetailsJsonObj.getLong("popupid"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("mgmtRuleFieldValue");
    }
}

