/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.usermanagement.CustomScript;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;

public class CommitComputerCustomScript
extends WorkFlowCommitListener {
    public CommitComputerCustomScript() {
        this.reportId = (int)ReportsUtil.RESET_COMPUTER_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        this.domainName = (String)result.get(3016);
        String scriptResult = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.successfully_executed_script");
        try {
            Hashtable resultHash = new Hashtable();
            resultHash.putAll(result);
            ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
            if (!inputsDetails.isEmpty()) {
                for (AdmpInput admpInput : inputsDetails) {
                    String command = admpInput.getValue();
                    if (command == null || command.equals("")) continue;
                    command = FormatClientUtil.getFormatValueForCustomScript(command, resultHash, this.domainName, "computer");
                    CustomScript customScript = new CustomScript(rb, 5L, command);
                    scriptResult = customScript.runThread();
                    if (scriptResult.indexOf("All rights reserved.") == -1) continue;
                    scriptResult.substring(scriptResult.indexOf("All rights reserved.") + 20);
                }
            }
        }
        catch (Exception e) {
            scriptResult = rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.exception_script_execution");
            e.printStackTrace();
        }
        scriptResult = MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.cre_single_user.statmsg.custom_script_result"), scriptResult);
        TechAuditAPI.getInstance().auditDeleteObject(loginId, rb.getString("jsp.UserAdmin.computer_management"), rb.getString("admp.reports.report_actions.create_request.options.custom_script"), this.getValue(result, (Integer)3001), this.domainName, scriptResult, rb);
        return scriptResult;
    }

    private void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }
}

