/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.formats.FormatClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class CommitCreateMailBox
extends WorkFlowCommitListener {
    public CommitCreateMailBox() {
        this.reportId = (int)ReportsUtil.CREATE_MAIL_BOX_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
        try {
            Hashtable<Integer, String> resultHash = new Hashtable<Integer, String>();
            resultHash.putAll(result);
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("distinguishedName");
            attributeList.add("objectGUID");
            attributeList.add("objectSID");
            attributeList.add("mailNickname");
            attributeList.add("homeMDB");
            attributeList.add("userPrincipalName");
            attributeList.add("name");
            attributeList.add("sAMAccountName");
            attributeList.add("initials");
            attributeList.add("sn");
            attributeList.add("givenName");
            attributeList.add("msExchHomeServerName");
            String sid = this.getValue(result, (Integer)1144);
            String firstName = this.getValue(result, (Integer)1001);
            String lastName = this.getValue(result, (Integer)1002);
            String initials = this.getValue(result, (Integer)1003);
            String logonName = this.getValue(result, (Integer)1006);
            String mailAliasFormat = "";
            String mailServer = "";
            String mailBox = "";
            ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
            for (AdmpInput admpInput : inputsDetails) {
                if (!admpInput.getIsMultiple().booleanValue()) continue;
                for (FcOption fcOption : admpInput.getMultipleInput()) {
                    if (fcOption.getValue().equals("")) continue;
                    String text = fcOption.getLabel();
                    if (text.equalsIgnoreCase("mailFormatValue")) {
                        mailAliasFormat = fcOption.getValue();
                        continue;
                    }
                    if (fcOption.getLabel().equalsIgnoreCase("serverNameValue")) {
                        mailServer = fcOption.getValue();
                        continue;
                    }
                    if (!fcOption.getLabel().equalsIgnoreCase("mailBoxStoresValue")) continue;
                    mailBox = fcOption.getValue();
                }
            }
            resultHash.put(1101, mailServer);
            resultHash.put(1082, mailBox);
            String mailAlias = "";
            boolean validAlias = true;
            if (!mailAliasFormat.equalsIgnoreCase("--")) {
                Properties p = new Properties();
                this.domainName = (String)result.get(1143);
                mailAlias = FormatClientUtil.getFormatValue(new Long(mailAliasFormat), resultHash, this.domainName, "");
                if (!mailAlias.equals("")) {
                    boolean isExists;
                    String query = "(&(objectCategory=person)(objectclass=user)(mailNickName=";
                    String splChars = "@()[]\\;:\",<> ";
                    for (int i = 0; i < mailAlias.length(); ++i) {
                        if (splChars.indexOf(mailAlias.charAt(i)) == -1) continue;
                        validAlias = false;
                    }
                    if (validAlias && (isExists = ADHandler.checkObjectExist((String)this.domainName, (Long)loginId, (String)(query + mailAlias + "))"), null))) {
                        int i = 2;
                        while (isExists) {
                            isExists = ADHandler.checkObjectExist((String)this.domainName, (Long)loginId, (String)(query + mailAlias + i + "))"), null);
                            ++i;
                        }
                        mailAlias = mailAlias + i;
                    }
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("ATTRIB_LDAP_NAME", "mailNickName");
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_VALUE", mailAlias);
                    setAttributeList.add(p);
                }
            }
            if (!mailBox.equals("0")) {
                Properties p1 = new Properties();
                p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                p1.put("ATTRIB_LDAP_NAME", "homeMDB");
                p1.put("DATA_HANDLER_TYPE", new Long(1L));
                p1.put("ATTRIB_VALUE", mailBox);
                setAttributeList.add(p1);
            }
            Properties p2 = new Properties();
            p2.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p2.put("ATTRIB_LDAP_NAME", "msExchHomeServerName");
            p2.put("DATA_HANDLER_TYPE", new Long(1L));
            p2.put("ATTRIB_VALUE", mailServer);
            setAttributeList.add(p2);
            Properties p3 = new Properties();
            p3.put("ATTRIB_VALUE_COUNT", new Long(1L));
            p3.put("DATA_HANDLER_TYPE", new Long(3L));
            p3.put("ATTRIB_LDAP_NAME", "mdbusedefaults");
            p3.put("ATTRIB_VALUE", "TRUE");
            setAttributeList.add(p3);
            String statMessage = "";
            String actionName = "";
            String objectGUID = (String)result.get("OBJECT_GUID");
            String objDistinguishedName = this.getValue(result, (Integer)1004);
            objectGUID = objectGUID.substring(objectGUID.indexOf("{") + 1, objectGUID.indexOf("}"));
            boolean usePowershell = false;
            Properties exchangeServerDetails = new Properties();
            String exchVersion = "2003";
            Integer exchType = 2003;
            if (!mailBox.equals("0")) {
                mailServer = ExchangeUtil.getMailboxServer((String)mailBox, (String)this.domainName);
            }
            usePowershell = ExchangeUtil.checkExchange2007((String)mailServer);
            exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailServer);
            exchVersion = exchangeServerDetails.getProperty("VERSION");
            exchType = (int)ExchangeUtil.getExchType((String)exchVersion);
            try {
                if (mailAlias == null || mailAlias.equalsIgnoreCase("")) {
                    throw new Exception(rb.getString("client.usermanagement.CreateMailBoxListener.empty_mail_nick_name_is_not_allowed"));
                }
                actionName = rb.getString("admp.mgmt.user_mgmt.cre_mailbox.mgmtname.create_mailbox");
                if (validAlias) {
                    if (usePowershell) {
                        statMessage = ADHandler.createMailBox2007((String)this.domainName, (long)loginId, (String)objectGUID, (String)mailAlias, (String)mailBox, (Properties)exchangeServerDetails, null, (String)objDistinguishedName);
                        message.append(rb.getString(statMessage));
                        if (statMessage.equals("")) {
                            ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)loginId, (String)sid, (String)objDistinguishedName, setAttributeList, new ArrayList(), attributeList, (NativeListener)this);
                        }
                    }
                    if (!usePowershell) {
                        ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)loginId, (String)sid, (String)objDistinguishedName, setAttributeList, new ArrayList(), null, null);
                        ADHandler.createMailBox((String)this.domainName, (Long)loginId, (String)sid, (String)objDistinguishedName, (String)mailBox);
                    }
                    if (message.length() == 0) {
                        message.append(rb.getString("groupmanagement.messages.successfully_modified"));
                    }
                } else {
                    message.append(rb.getString("admp.management.usermanagement.create_mailbox.message.pls_enter_valid_alias_name"));
                }
                if (message.length() == 0) {
                    message.append(rb.getString("groupmanagement.messages.successfully_modified"));
                }
            }
            catch (LocalizedException le) {
                message = new StringBuffer(rb.getString("groupmanagement.messages.successfully_modified_error") + le.getMessage(rb));
            }
            catch (Exception e) {
                message = new StringBuffer(e.getMessage());
            }
            if (mailBox.equals("0")) {
                Properties p = new Properties();
                p.put("ATTRIB_VALUE", rb.getString("admp.mgmt.user_mgmt.cre_template.auto_select_mailbox"));
                p.put("ATTRIB_LDAP_NAME", "homeMDB");
                setAttributeList.add(p);
            }
            TechAuditAPI.getInstance().auditUserModification(loginId, actionName, this.getValue(result, (Integer)1010), this.domainName, setAttributeList, new ArrayList(), new ArrayList(), message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }
}

