/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitDeleteComputers
extends WorkFlowCommitListener {
    public CommitDeleteComputers() {
        this.reportId = (int)ReportsUtil.DELETE_COMPUTER_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String guid = "";
        Boolean errorOccured = true;
        this.domainName = (String)result.get(3016);
        try {
            String dn = (String)result.get(3020);
            guid = (String)result.get(3017);
            ADHandlerForMgmt.deleteUser((String)this.domainName, (Long)loginId, (String)CommonUtil.escapeDN((String)dn));
            UserHandler.deleteUser((String)this.domainName, (Long)loginId, (String)dn);
            message.append(rb.getString("admp.workflow.commit.deletecomputer_success_message"));
            errorOccured = false;
            out.log(Level.INFO, " Deleted Computer guid " + guid + " dn " + dn);
        }
        catch (LocalizedException le) {
            le.printStackTrace();
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + le.getMessage(rb));
        }
        catch (Exception e) {
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error") + e.getMessage());
        }
        this.updateResult(guid, message.toString(), errorOccured);
        TechAuditAPI.getInstance().auditDeleteComputer(loginId, rb.getString("admp.mgmt.comp_mgmt.del_comps.mgmtname.del_comps"), this.getValue(result, (Integer)3001), this.domainName, message.toString(), rb);
        return message.toString();
    }
}

